<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';
	
	if ( ! isset( $data[$prefix.'more_text'] ) || '' == $data[$prefix.'more_text'] ) {
		$more_text = __('More', 'themify');
	} else {
		$more_text = $data[$prefix.'more_text'];
	}
	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);
	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);

	$show_hide_options = array(
		array('name'=>__('Show', 'themify'),'value'=>'no'),
		array('name'=>__('Hide', 'themify'),'value'=>'yes'),
	);

	$unlink_options = [
		[ 'name' => __('Linked', 'themify'), 'value' => 'no' ],
		[ 'name' => __('Unlinked', 'themify'), 'value' => 'yes' ],
	];

	/**
	 * Post layout options
	 * @var array
	 */
	$default_post_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __('List Post', 'themify'), "selected" => true),
		array('value' => 'grid6','img' => 'images/layout-icons/grid6.png','title' => __('Grid 6', 'themify')),
		array('value' => 'grid5', 'img' => 'images/layout-icons/grid5.png','title' => __('Grid 5', 'themify')),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __('Grid 4', 'themify')),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __('Grid 3', 'themify')),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __('Grid 2', 'themify')),
		array('value' => 'list-large-image', 'img' => 'images/layout-icons/list-large-image.png', 'title' => __('List Large Image', 'themify')),
		array('value' => 'list-thumb-image', 'img' => 'images/layout-icons/list-thumb-image.png', 'title' => __('List Thumb Image', 'themify')),
		array('value' => 'grid2-thumb', 'img' => 'images/layout-icons/grid2-thumb.png', 'title' => __('Grid 2 Thumb', 'themify')),
	);
	/**
	 * Sidebar placement options
	 * @var array
	 */
	$sidebar_location_options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify'))
	);

	/**
	 * HTML for settings panel
	 * @var string
	 */
	$output = '<div class="themify-info-link">' . __( 'Here you can set the <a href="https://themify.me/docs/default-layouts">Default Layouts</a> for WordPress archive post layout (category, search, archive, tag pages, etc.), single post layout (single post page), and the static Page layout. The default single post and page layout can be override individually on the post/page > edit > Themify Custom Panel.', 'themify' ) . '</div>';
	
	/**
	 * Index Sidebar Option
	 */
	$output .= '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
	$val = isset( $data[$prefix.'layout'] ) ? $data[$prefix.'layout'] : '';
	foreach ( $sidebar_location_options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) { 
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) { 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';	
	}
	
	$output .= '	<input type="hidden" name="'.$prefix.'layout" class="val" value="'.$val.'" />
				</p>';
	/**
	 * Post Layout
	 */
	$output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
	$val = isset( $data[$prefix.'post_layout'] ) ? $data[$prefix.'post_layout'] : '';
	foreach ( $default_post_layout_options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) { 
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) { 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';	
	}
	
	$output .= '	<input type="hidden" name="'.$prefix.'post_layout" class="val" value="'.$val.'" />
				</p>';
	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="'.$prefix.'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';
	
	/**
	 * Excerpt length
	 */
	$output .= '<p data-show-if-element="[name=setting-default_layout_display]" data-show-if-value=\'["excerpt"]\'>
					<span class="pushlabel vertical-grouped">
						<label>
							<input class="width2" type="text" value="' . ( isset( $data[ $prefix . 'excerpt_length' ] ) ? esc_attr( $data[ $prefix . 'excerpt_length' ] ) : '' ) . '" name="' . esc_attr( $prefix ) . 'excerpt_length"> '
							. __( 'Excerpt length (enter number of words)', 'themify' ) . '
						</label>
					</span>
				</p>';

	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="'.$prefix.'more_text" value="'.$more_text.'">
					
					<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked( themify_get( 'setting-excerpt_more','',true ), 1, false ).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>
				</p>';
					
	/**
	 * Order & OrderBy Options
	 */
	if( function_exists( 'themify_post_sorting_options' ) ) 
		$output .= themify_post_sorting_options('setting-index_order', $data);
	
	/**
	 * Hide Post Title
	 */
	$output .=	'<p>
					<span class="label">' . __('Post Title', 'themify') . '</span>
					<select name="'.$prefix.'post_title">' .
						themify_options_module($show_hide_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Post Title Link', 'themify') . '</span>
					<select name="'.$prefix.'unlink_post_title">' .
						themify_options_module($unlink_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Post Date', 'themify') . '</span>
					<select name="'.$prefix.'post_date">' .
						themify_options_module($show_hide_options, $prefix.'post_date') . '
					</select>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" '.checked( themify_get( 'setting-auto_featured_image','',true ), 1, false ).'/> ' . __('If no featured image is specified, display first image in content.', 'themify') . '</label>
				</p>';
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Featured Image', 'themify') . '</span>
					<select name="'.$prefix.'post_image">' .
						themify_options_module($show_hide_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Featured Image Link', 'themify') . '</span>
					<select name="'.$prefix.'unlink_post_image">' .
						themify_options_module($unlink_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="setting-image_post_width" value="' . themify_get( 'setting-image_post_width','',true ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>  
					<input type="text" class="width2 show_if_enabled_img_php" name="setting-image_post_height" value="' . themify_get( 'setting-image_post_height','',true ) . '" /> <span class="show_if_enabled_img_php">' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel show_if_enabled_img_php"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';
	
	return $output;
}


/**
 * Control page loader effect in regular pages.
 * @param array $data
 * @return string
 */
function themify_page_section_scroll( $data = array() ) {
	
        $out='<div class="themify-info-link">'.__("This is the loading screen customization for 'Builder Section Scrolling' layout (it is only effective when the 'Builder Section Scrolling' is enabled in page's Themify Custom Panel &gt; Page Options)",'themify').'</div>';
	$key = 'setting-page_loader_sensitivity';
	$out.= '<p>
				<span class="label">' . __( 'Scroll Sensitivity', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'Normal', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Low', 'themify' ), 'value' => 'l' ),
				), $key ) . '
				</select>
			</p>';
	
	$key = 'setting-page_loader_duration';
	$out.= '<p>
				<span class="label">' . __( 'Transition Duration', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'Slow', 'themify' ), 'value' => 1.5 ),
					array( 'name' => __( 'Normal', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Fast ', 'themify' ), 'value' => .5 ),
					array( 'name' => __( 'Custom ', 'themify' ), 'value' => 'custom' ),
				), $key,true,'' ) . '
				</select>
			';
	$key = 'setting-page_loader_duration_sec';
	$out.= '<span data-show-if-element="[name=setting-page_loader_duration]" data-show-if-value="custom"><input class="width2" name="'.$key.'" type="text" value="'.themify_get($key,'',true).'">'. __( 'Second', 'themify' ) .'</span></p>';

        $key = 'setting-all_page_loader';
        $out.= '<hr>
				<h4>'.__('Loading Screen','themify').'</h4>
				<p class="page_loader_wrap">
                    <span class="label">' . __( 'Loading Screen Every Page', 'themify' ) . '</span>
                    <input type="checkbox" id="'.$key.'" name="'.$key.'" '. checked( themify_get($key,'',true), 'on', false ) .'/> ' . __('Enable loading screen on every page', 'themify') . '</label>
                </p>';

        $key = 'setting-page_loader_color';
        $value = themify_get($key,'',true);
        $out.= '<p class="page_loader_wrap">
                    <label class="label" for="'.$key.'">' . __('Loading screen color', 'themify') . '  </label>
                    <span class="colorSelect" style=""><span></span></span> <input id="'.$key.'" type="text"  name="'.$key.'" class="colorSelectInput width4" value="'.esc_attr($value).'"/>
                </p>';
        $key = 'setting-page_loader_icon';
        $value = themify_get($key,'',true);
        $out.='<div class="themify_field_row page_loader_wrap">
                        <span class="label">'. __('Loader Icon', 'themify') . '</span>
                        <input id="'.$key.'" type="text" class="width10" name="'.$key.'" value="' . esc_attr( $value ) . '" /> <br />
                        <span class="pushlabel">
                            <a class="left button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#'.$key.'">'.__( 'Insert Icon', 'themify' ).'</a>
                            <span style="margin: 2px 7px;font-size: 1.15em;" class="left">'.__('or', 'themify').'</span>
                            <div class="left" style="margin-top: -4px;">' . themify_get_uploader($key, array('tomedia' => true,'label'=>__('Upload an image','themify'))) . '</div>
                        </span>
                </div>';
	return $out;
}


/**
 * Display control for menu bar position and to exclude the footer (shown at the top).
 *
 * @since 1.3.6
 *
 * @return string
 */
function themify_header_and_footer_options() {
	$value = themify_get( 'setting-menu_bar_position','',true );
	return '
		<div class="themify_field_row">
			<span class="label">'. __('Menu Bar Position', 'themify') . '</span>
			<select id="setting-menu_bar_position" name="setting-menu_bar_position">
				<option value="menubar-bottom">' . __( 'Menu bar at the bottom', 'themify' ) . '</option>
				<option value="menubar-top" '. selected( $value, 'menubar-top', false ) .'>' . __( 'Menu bar at the top', 'themify' ) . '</option>
			</select>
		</div>
		<div class="themify_field_row">
			<span class="label"></span>
			<label><input type="checkbox" name="setting-exclude_footer_panel" value="on" ' . checked( 'on', themify_get( 'setting-exclude_footer_panel','',true ), false ) . '>' . __( 'Exclude footer panel (the footer will be excluded)', 'themify' ) . '</label>
		</div>';
}
