<?php
/***************************************************************************
 *  					Theme Functions
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom PHP functions to the theme, create a child theme (https://themify.me/docs/child-theme) and add it to the child theme functions.php file.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/** Compatibility with portfolio posts plugin */
const THEMIFY_PORTFOLIO_POSTS_COMPAT_MODE=true;
Themify_Enqueue_Assets::$mediaMaxWidth=false;

// Register sidebars
add_action( 'widgets_init', 'themify_theme_register_sidebars' );

// Exclude CPT for sidebar
add_filter( 'themify_exclude_CPT_for_sidebar', 'themify_CPT_exclude_sidebar' );

// Add loading animation
add_action( 'themify_body_start', 'themify_theme_add_section_loader' );

/**
 * Enqueue Stylesheets and Scripts
 * @since 1.0.0
 */
function themify_theme_enqueue_footer() {
	// Get theme version for Themify theme scripts and styles
	$theme_version = Themify_Enqueue_Assets::$themeVersion;
	$themify_script_vars=array(
		'pageLoaderEffect' => page_loader_status()
	);
	$is_builder_off=class_exists('Themify_Builder_Model',false) && !Themify_Builder_Model::is_front_builder_activate();
	$is_full_scroll=themify_theme_is_fullpage_scroll(false);
	if ( $is_builder_off===true && $is_full_scroll===true){
	    $themify_script_vars['breakpoints']=themify_get_breakpoints();
	    if('on' !== themify_get( 'section_scrolling_mobile' )){
		$themify_script_vars['f_s_d']=$themify_script_vars['breakpoints']['tablet'][1]+1;
	    }
	    $media=!empty($themify_script_vars['f_s_d'])?'screen and (min-width:'.$themify_script_vars['f_s_d'].'px)':null;
	    themify_enque_style( 'themify-section-scroll', THEME_URI . '/styles/fullpage/section-scroll.css', null, $theme_version,$media,true);
		
	    Themify_Enqueue_Assets::addPrefetchJs(THEME_URI . '/js/modules/fullpage.js',$theme_version);
	    Themify_Enqueue_Assets::preFetchAnimtion();
        if( 'on' !== themify_get('fullpage_parallax_scrolling') ) {
            $themify_script_vars['fullpage_parallax']=true;
        }
	}
	// Slide mobile navigation menu
	Themify_Enqueue_Assets::preFetchSideMenuJs();
	
    // Inject variable values in gallery script
	wp_localize_script( 'themify-main-script', 'themifyScript', apply_filters('themify_script_vars',$themify_script_vars ));
}

/**
 * Load Google fonts used by the theme
 *
 * @return array
 */
function themify_theme_google_fonts(array $fonts=array() ):array {
	global $themify;
	/* translators: If there are characters in your language that are not supported by Roboto, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Roboto font: on or off', 'themify' ) ) {
		$fonts['roboto'] = 'Roboto:400,100,300,700';
	}
	/* translators: If there are characters in your language that are not supported by Roboto Condensed, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Roboto Condensed font: on or off', 'themify' ) ) {
		$fonts['roboto-condensed'] = 'Roboto+Condensed:400,300,700';
	}
	if ( !empty( $themify->google_fonts )){
	    $fonts['google_fonts']=substr( $themify->google_fonts, 0, -1 );
	}
	return $fonts;
}

function themify_theme_avatar_size(){
    return 70;
}
add_filter('themify_comment_avatar_size','themify_theme_avatar_size');
add_filter( 'themify_google_fonts', 'themify_theme_google_fonts' );


if ( ! function_exists( 'themify_theme_init_types' ) ) {
	/**
	 * Initialize custom panel with its definitions
	 * Custom panel definitions are located in admin/post-type-TYPE.php
	 * @since 1.0.7
	 */
	function themify_theme_init_types() {

		/* prevent update checks from wp.org repository */
		add_theme_support( 'themify-exclude-theme-from-wp-update' );
		
		add_theme_support( 'post-thumbnails' );
		$supportedCss=array(
		    'grid2-thumb',
		    'grid2',
		    'grid3',
		    'grid4',
		    'list-large-image',
		    'list-post',
		    'list-thumb-image',
		    'widget_text',
		    'widget_themify-feature-posts',
		    'widget_themify-flickr',
		    'widget_themify-social-links',
		    'comments'
		);
		
		foreach ($supportedCss as $css){
		    Themify_Enqueue_Assets::add_theme_support_css($css);
		}
		unset($supportedCss);
		// Load required files for post, page and custom post types where it applies
		foreach ( array( 'base','highlight', 'team', 'portfolio', 'section', 'testimonial', 'gallery' ) as $type ) {
			require_once( "admin/post-type-$type.php" );
		}
		register_nav_menus( array(
		    'main-nav' => __( 'Main Navigation', 'themify' )
		));
	}
}
add_action( 'after_setup_theme', 'themify_theme_init_types' );



/**
 * Output required classes like transition setting or full section/builder row scrolling setting.
 *
 * @param array $classes
 *
 * @return array
 */
function themify_theme_body_class(array $classes ):array {
	
	/**
	 * Introduced when deprecating sections in favor of Builder rows.
	 *
	 * @since 1.3.1
	 */
	$classes[] =themify_theme_is_fullpage_scroll() ||  page_loader_status()? 'hidden-view':'ready-view';

	$classes[] = themify_theme_is_fullpage_scroll() && themify_check( 'fullpage_footer_section', false ) ? 'fullpage-footer' : '';

	if ( is_page() && 'yes' === themify_get( 'section_full_scrolling' ) ) {
		$classes[] = 'query-section';
		$classes[] = 'full-section-scrolling';
		if( 'horizontal' === themify_get( 'section_scrolling_direction' ) ){
			$classes[] = 'full-section-scrolling-horizontal';
		}
		if( 'single' === themify_get( 'section_scrolling_style' ) ){
			$classes[] = 'full-section-scrolling-single';
		}

	}
	/*Output required classes to check if parallax effect is enabled*/
	if( 'on' !== themify_get('fullpage_parallax_scrolling') ) {
	    $classes[] = 'section-scrolling-parallax-enabled';
	}
	/* Add body classes for the menu bar position*/
	$menu_bar_position = '';
	if ( is_singular() ) {
		$menu_bar_position = themify_get( 'menu_bar_position','' );
	}
	if ( empty( $menu_bar_position ) ) {
		$menu_bar_position = themify_get( 'setting-menu_bar_position','menubar-bottom',true );
	}

	$classes[] = $menu_bar_position;

	$classes[] = 'fixed-header-enabled';
	
	return $classes;
}
add_filter( 'body_class', 'themify_theme_body_class' );


/**
 * Apply theme-specific row settings
 *
 * @return 	array
 */
function themify_theme_builder_row_attributes(array $attr,array $settings, $builder_id):array {
	if(!themify_theme_is_fullpage_scroll()){
		remove_filter( 'themify_builder_row_attributes', 'themify_theme_builder_row_attributes');
	}
	elseif (isset($attr['class']) && !str_contains( $attr['class'], 'not_editable_builder' ) && $builder_id === get_queried_object_id() ) {
		if ( ! empty( $settings['row_scroll_direction'] ) ) {
			$attr['class'] .= ' ' . $settings['row_scroll_direction'];
		}else{ 
			$attr['class'] .= 'horizontal' === themify_get( 'section_scrolling_direction' ) ? ' module_row_slide' : ' module_row_section';
		}
		$breakpoints=array('desktop'=>'')+themify_get_breakpoints();
		foreach($breakpoints as $bp=>$v){
			$padding='';
			$st=$bp==='desktop'?$settings:($settings['breakpoint_'.$bp]??array());
			if(isset($st['checkbox_padding_apply_all']) && '1'===$st['checkbox_padding_apply_all']){
				if(isset($st['padding_top']) && $st['padding_top']!==''){
					$padding=$st['padding_top'].($st['padding_top_unit']??'px');
				}
			}
			else{
				if(isset($st['padding_top']) && $st['padding_top']!==''){
					$padding=$st['padding_top'].($st['padding_top_unit']??'px');
				}
				$padding.=' ';
				if(isset($st['padding_bottom']) && $st['padding_bottom']!==''){
					$padding.=$st['padding_bottom'].($st['padding_bottom_unit']??'px');
				}
				else{
					$padding.=' ';
				}
			}
			$padding=trim($padding);
			if($padding!==''){
				$attr['data-'.$bp.'-pd']=$padding;
			}
		}
		if ( ! empty( $settings['row_title'] ) ) {
			$attr['data-row-title'] = $settings['row_title'];
		}
		/* disable row animation effects */
		unset( $attr['data-sticky-active'], $attr['data-lax'], $attr['data-lax-anchor'], $attr['data-lax-optimize'], $attr['data-lax-no-op'] );
	}

	return $attr;
}
add_filter( 'themify_builder_row_attributes', 'themify_theme_builder_row_attributes', 10, 3 );


/**
 * Adds page loading animation
 *
 * @since 1.3.6
 */
function themify_theme_add_section_loader() {

	if ( !Themify_Builder_Model::is_front_builder_activate() && (page_loader_status() || themify_theme_is_fullpage_scroll()) ) {
		$color = themify_get_color('setting-page_loader_color',false,true);
		$icon = themify_get('setting-page_loader_icon',false,true);
		$duration = themify_get('setting-page_loader_duration',false,true);
		$sensitivy = themify_get('setting-page_loader_sensitivity',false,true);
		$cl = $bg = '';
		if ( $icon ) {
			// check if the value is a valid icon name
			$cl = themify_get_icon( $icon );
			// not an icon, it's an image
			if ( empty( $cl ) ) {
				$cl='';
				$bg = 'background:transparent url(' . $icon . ') center/cover no-repeat';
			}else{
                $bg = 'background:0';
            }
		}
		$media=(!page_loader_status() && themify_theme_is_fullpage_scroll()) && 'on'!==themify_get( 'section_scrolling_mobile' )?'screen and (min-width:'.(themify_get_breakpoints('tablet')[1]+1).'px)':null;
		Themify_Enqueue_Assets::loadThemeStyleModule('loader',$media);
		if($duration==='custom'){
		    $duration=themify_get('setting-page_loader_duration_sec',false,true);
		}
		?>
		<?php if($color || $bg || $sensitivy || $duration):?>
            <style<?php echo !empty($media)?' media="'.$media.'"':'';?>>
                <?php if($color):?>
					.hidden-view:after,.section_loader{background-color:<?php echo $color ?>}
				<?php endif;?>
                <?php if($bg):?>
					.section_loader .section_spinner{<?php echo $bg ?>}
				<?php endif;?>
				<?php if($sensitivy || $duration):?>
					.themify_builder{
					<?php if($sensitivy):?>
						--tf_section_sensitivy:<?php echo $sensitivy?>;
					<?php endif;?>
					<?php if($duration):?>
						--tf_section_duration:<?php echo $duration?>s
					<?php endif;?>
					}
				<?php endif;?>
            </style>
		<?php endif;?>
        <div class="section_loader tf_textc tf_w tf_h">
            <div class="section_spinner tf_rel"><?php echo $cl ?></div>
        </div>
		<?php
	}
}

function page_loader_status():bool {
    static $is=null;
    if($is===null){
		$is='on' === themify_get('setting-all_page_loader',false,true);
    }
    return $is;

}


/**
 * Register sidebars
 * @since 1.0.0
 */
function themify_theme_register_sidebars() {
	$sidebars = array(
		array(
			'name' => __('Sidebar', 'themify'),
			'id' => 'sidebar-main',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
		),
		array(
			'name' => __('Social Widget', 'themify'),
			'id' => 'social-widget',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<strong class="widgettitle">',
			'after_title' => '</strong>',
		)
	);
	foreach( $sidebars as $sidebar ) {
		register_sidebar( $sidebar );
	}
}

if ( ! function_exists('themify_theme_gallery_plugins_args') ) {
	/**
	 * Enable Timeline entries to launch lightbox/fullscreen galleries
	 * @param $args
	 * @return mixed
	 * @since 1.0.4
	 */
	function themify_theme_gallery_plugins_args(array $args=array()):array {
		$args['contentImagesAreas'] = empty($args['contentImagesAreas']) ? '.section-post' : $args['contentImagesAreas'].', .section-post';
		return $args;
	}
	add_filter('themify_gallery_plugins_args', 'themify_theme_gallery_plugins_args');
}


if ( ! function_exists( 'themify_theme_custom_post_css' ) ) {
	/**
	 * Outputs custom post CSS at the end of a post
	 * @since 1.0.0
	 */
	function themify_theme_custom_post_css() {
		global $themify;
		$post_id = '.section-post.post-'.get_the_ID();
		$css = array();
		$style = '';
		$rules = array(
			"$post_id" => array(
				array(	'prop' => 'font-size',
						'key' => array('font_size', 'font_size_unit')
				),
				array(	'prop' => 'font-family',
						'key' => 'font_family'
				),
				array(	'prop' => 'color',
						'key' => 'font_color'
				),
				array(	'prop' => 'background-color',
						'key' => 'background_color'
				),
				array(	'prop' => 'background-image',
						'key' => 'background_image'
				),
				array(	'prop' => 'background-repeat',
						'key' => 'background_repeat'
				)
			),
			"$post_id h1, $post_id h2, $post_id h3, $post_id h4, $post_id h5, $post_id h6" => array(
				array(	'prop' => 'font-family',
						'key' => 'font_family'
				),
				array(	'prop' => 'color',
						'key' => 'font_color'
				)
			),
			"$post_id .section-title" => array(
				array(	'prop' => 'font-size',
						'key' => array('title_font_size', 'font_size_unit')
				),
				array(	'prop' => 'font-family',
						'key' => 'title_font_family'
				),
				array(	'prop' => 'color',
						'key' => 'title_font_color'
				)
			),
			"$post_id a" => array(
				array(	'prop' => 'color',
						'key' => 'link_color'
				)
			)
		);
		foreach ( $rules as $selector => $property ) {
			foreach ( $property as $val ) {
				$prop = $val['prop'];
				$key = $val['key'];
				if ( is_array( $key ) ) {
					if ( $prop === 'font-size' && themify_check( $key[0] ) ) {
						$css[$selector][$prop] = $prop . ': ' . themify_get( $key[0] ) . themify_get( $key[1] );
					}
				} elseif ( themify_check( $key ) && 'default' !== themify_get( $key ) ) {
					if ( $prop === 'color' || stripos( $prop, 'color' ) ) {
						$css[$selector][$prop] = $prop . ': #' . themify_get( $key );
					}
					elseif ( $prop === 'background-image' && 'default' !== themify_get( $key ) ) {
					    $img=themify_get( $key );
					    themify_generateWebp($img); 
					    $css[$selector][$prop] = $prop .': url(' . $img . ')';
					}
					elseif ( $prop === 'background-repeat' && 'fullcover' === themify_get( $key ) ) {
						continue;
					}
					elseif ( $prop === 'font-family' ) {
						$font = themify_get( $key );
						$css[$selector][$prop] = $prop .': '. $font;
						if ( ! in_array( $font, themify_get_web_safe_font_list( true ) ) ) {
							//$themify->google_fonts .= str_replace( ' ', '+', $font.'|' );
						}
					}
					else {
						$css[$selector][$prop] = $prop .': '. themify_get( $key );
					}
				}
			}
			if ( ! empty( $css[$selector] ) ) {
				$style .= "$selector {\n\t" . implode( ";\n\t", $css[$selector] ) . "\n}\n";
			}
		}

		if ( '' != $style ) {
			echo "\n<!-- $post_id Style -->\n<style>\n$style</style>\n<!-- End $post_id Style -->\n";
		}
	}
	add_action( 'themify_post_end', 'themify_theme_custom_post_css' );
}


if ( ! function_exists( 'themify_post_count_markup' ) ) {
	/**
	 * Remove parentheses, wrap in span and put inside link
	 * @param $output
	 * @param $args
	 * @return mixed
	 * @since 1.0.0
	 */
	function themify_post_count_markup( $output, $args ) {
		if ( isset( $args['id'] ) && stripos( $args['id'], 'themify-list-categories' ) !== false ) {
			$search = array( '</a>', '(', ')' );
			$replace = array( '', '<span class="badge pull-right">', '</span></a>' );
			$output = str_replace( $search, $replace, $output );
		}
		return $output;
	}
	add_filter( 'wp_list_categories', 'themify_post_count_markup', 10, 2 );
}

if ( ! function_exists( 'themify_comment_reply_link' ) ) {
	/**
	 * Set class for reply link
	 * @param $before_link_after
	 * @return mixed
	 * @since 1.0.0
	 */
	function themify_comment_reply_link(string $before_link_after='' ):string {
		return str_replace( "class='", "class='shortcode button outline small ", $before_link_after );
	}
	add_filter( 'comment_reply_link', 'themify_comment_reply_link' );
}

if( ! function_exists('themify_CPT_exclude_sidebar') ) {
	/**
	 * Exclude Custom Post Types
	 */
	function themify_CPT_exclude_sidebar(array $CPT = array()):array {
		$CPT[]='portfolio';
		$CPT[]='team';
		$CPT[]='highlight';
		$CPT[]='gallery';
		$CPT[]='testimonial';
		return $CPT;
	}
}
/**
 * Set portfolio post type slug
 *
 * @since 1.1.0
 * @return string
 */
function themify_theme_portfolio_post_rewrite($slugs) {
	$slug = themify_get( 'themify_portfolio_slug','',true );
    if(is_array($slugs)){
        $slugs['post'] = empty( $slug ) ? apply_filters( 'themify_portfolio_rewrite', $slugs['post'] ) : $slug;
		$category_slug = themify_get( 'themify_portfolio_category_slug','',true );
		$slugs['tax'] = empty( $category_slug ) ? apply_filters( 'themify_portfolio_category_rewrite', $slugs['tax'] ) : $category_slug;    
    }else{
		$slugs = empty( $slug ) ? apply_filters( 'themify_portfolio_rewrite', 'project' ) : $slug;
    }
	return $slugs;
}
add_filter( 'themify_portfolio_post_rewrite', 'themify_theme_portfolio_post_rewrite' );

/**
 * Check whether fullpage scrolling is enabled
 *
 * @return bool
 * @since 1.5.4
 */
function themify_theme_is_fullpage_scroll(bool $builder_check=true):bool {
    static  $is_fullpage_scroll = null;
    if($is_fullpage_scroll===null || $builder_check===false){
        if($builder_check===true && class_exists('Themify_Builder_Model',false) && Themify_Builder_Model::is_front_builder_activate()){
            $is_fullpage_scroll = false;
        }
		else{
            if ( ! ( ( isset( $_REQUEST['wp_customize'] ) && 'on' === $_REQUEST['wp_customize'] )|| ( is_admin() && 'customize.php' === basename( $_SERVER['PHP_SELF'] ) )) ) {
                $is_fullpage_scroll = 'yes' === themify_get( 'section_full_scrolling' );
            } else {
                $is_fullpage_scroll = 'no' === themify_get( 'section_full_scrolling' );
            }
            $is_fullpage_scroll = apply_filters( 'themify_theme_is_fullpage_scroll', $is_fullpage_scroll );
			if($builder_check===false){
				$result = $is_fullpage_scroll;
				$is_fullpage_scroll = null;
				return $result;
			}
        }
    }
	return $is_fullpage_scroll;
}



/**
 * Set the variables for scroll-highlight.js
 *
 * @since 1.0.0
 */
function themify_theme_scroll_highlight_vars(array $vars ):array {
	if(themify_theme_is_fullpage_scroll()){
	    $vars['scroll']='external';
	}
	return $vars;
}
add_filter( 'themify_builder_scroll_highlight_vars', 'themify_theme_scroll_highlight_vars' );


function themify_theme_loops_wrapper_class($class,$post_type,$layout,$type,$moduleArgs=array(),$slug=false) {
	if($post_type!=='' && $post_type!=='post'){
	    if($post_type==='portfolio'){
			$class[]='no-gutter';
	    }
	    Themify_Shortcode_Base::loadStyles($post_type,$layout );
	}
	return $class;
}
add_filter('themify_loops_wrapper_class','themify_theme_loops_wrapper_class',10,6);

/**
 * Add Skip to Content link to site
 *
 * @return string
 */
add_action('themify_body_start','themify_theme_skip_to_content');
function themify_theme_skip_to_content(){
    echo '<a class="screen-reader-text skip-to-content" href="#'.esc_attr(apply_filters('themify_skip_content_id','content')).'">'.__('Skip to content','themify').'</a>';
}
add_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
function themify_theme_search_form_css(){
    remove_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
    Themify_Enqueue_Assets::loadThemeStyleModule('search-form');
}

/*Let the builder know that page is full section enabled*/
function themify_theme_builder_full_section(array $vars):array {
	$vars['addons'][THEME_URI . '/js/modules/builder-active.js']=Themify_Enqueue_Assets::$themeVersion;
	$i18n = include( THEME_DIR . '/admin/i18n.php' );
	$vars['i18n']['label']+= $i18n;
    if(themify_theme_is_fullpage_scroll(false)) {
        $vars['is_fullSection']=true;
    }
    return $vars;
}
add_filter('themify_builder_active_vars','themify_theme_builder_full_section',10,1);