<?php

defined('ABSPATH') || exit;

/**
 * Line Awesome Icons for Themify Icon Picker
 *
 * Version 1.3.0
 *
 * @link https://icons8.com/line-awesome
 */
class Themify_Icon_LineAwesome extends Themify_Icon_Font {

    public function __construct() {
    parent::__construct();
    }

    public function get_id() {
    return 'la';
    }

    public function get_label() {
    return __('Line Awesome', 'themify');
    }

    /**
     * Check if the icon name belongs to the Line Awesome icon font
     * Assumes yes, if the icon name has "fa-" prefix
     *
     * @return bool
     */
    public function is_valid_icon($name) {
    return strpos($name, 'la-') === 0;
    }

    function get_classname($icon, $lazy = null, $data_only = false, $attrs = array()) {
    $id = $this->get_id();
    $icon = ltrim(ltrim($icon, $id), '-');
    $k = $id . '-' . $icon;
    if (!isset(self::$usedIcons[$k])) {
        $icon = self::get_icons($icon);
        if ($icon !== '') {
        self::$usedIcons[$k] = array('p' => $icon);
        }
    }

    if ($data_only === true) {
        return self::$usedIcons[$k];
    }

    return self::get_svg($k, $attrs);
    }

    function get_categories() {
    return array(
        $this->get_id() => __('LineAwesome', 'themify'),
    );
    }

    public function get_icons_by_category($cat = '') {
    return array($this->get_id() => self::get_icons());
    }

    private static function get_icons($icon = '') {
    $icons = array(
        '500px' => 'M26.2 12.83c-3.32 0-5.29 3.15-5.41 3.15-.13 0-2.08-3.15-5.43-3.15-3.35 0-4.3 3.15-4.41 3.15-.1 0-.87-2.58-3.77-2.58-2.34 0-2.67 1.08-2.87 1.08 0 0 .18-1.16.53-3.22h5.78V9H2.8l-1.32 7.57h2.53s.58-1.06 2.12-1.06c1.53 0 2.46 1.18 2.46 2.51 0 1.33-1.03 2.78-2.46 2.78a2.26 2.26 0 0 1-2.27-2.08H1.04c0 .76.6 4.28 5.08 4.28 3.66 0 4.83-2.72 4.83-3.05 0 .28 1.4 3.05 4.4 3.05 3.49 0 5.24-3.05 5.44-3.05.2 0 2.26 3.05 5.41 3.05 3.15 0 4.76-2.77 4.76-5.1 0-2.35-1.43-5.07-4.76-5.07Zm-7.1 5.1c-.02.03-1.94 2.37-3.73 2.37-1.8 0-2.12-1.78-2.12-2.36 0-.58.33-2.37 2.12-2.37s3.71 2.34 3.73 2.37Zm9.25 0c0 .59-.33 2.37-2.13 2.37-1.78 0-3.7-2.33-3.73-2.36.03-.03 1.95-2.37 3.73-2.37 1.8 0 2.13 1.8 2.13 2.37Z',
        'accessible-icon' => 'M24 4c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-5.44 3.03-3.6.4a2 2 0 0 0-1.37.88l-.03-.03-.03.06-2.31 3.07 1.56 1.18 2.38-3.09.06-.06 2.19-.25-1.7 3.84A7 7 0 0 0 10.26 18h2.78A5 5 0 1 1 16 27a5 5 0 0 1-3.97-2H9.7A7 7 0 0 0 23 22c0-.34-.05-.67-.1-1h1.98l-1.54 5.75 1.94.5 1.66-6.22.06-.22-.03-.25A2.02 2.02 0 0 0 25 19h-2.69a6.96 6.96 0 0 0-1.12-1.66l1.62-3.4.03-.06v-.04a3 3 0 0 0-1.4-3.65l-1.69-.94v.03c-.36-.19-.79-.3-1.19-.25Zm.9 2.35 1.04.56c.45.24.64.74.47 1.22L19.59 16a6.93 6.93 0 0 0-1.8-.75ZM7 19v2h7v-2Zm-3 3v2h13v-2Z',
        'accusoft' => 'm18.74 6-6.46.03c-1 0-1.7 0-1 .8l12.86 14.58c.69.77 1.08.63 1.6.44.17-.05 5.98-2.26 6.1-2.32.42-.2-.08-.8-.37-1.12L20.73 6.61C20.23 6.03 20 6 18.74 6zm-5.28 7s-.6.08-1.24.73C11.76 14.17.19 24.62.12 24.71c-.35.48.08.32.79.08l4.74-1.48.03-.03c-.02-.24-.03-1.25-.04-1.32-.04-.25.1-.32.34-.42l5.54-1.96c.03-.03 4.4-3.44 4.48-3.52v-.05L13.46 13zm2.32 7c-.16.01-.5.04-.74.14s-7.36 2.24-7.61 2.32c-.26.1-.58.18-.57.36 0 .12.1.13.24.18l15.62 3.72c.8.15 1.95.5 2.72.08l6.39-4.14c.26-.2.22-.33-.1-.4-.11 0-1.24-.14-1.92-.26l-5.96 2.38c-.82.35-1.37-.15-1.86-.7l-2.9-3.23a74.2 74.2 0 0 0-3.31-.45z',
        'acquisitions-incorporated' => 'M7.25 3c-.19 0-.28.06-.24.27.11.67-.04.04.33 2.3 3.3 0 3.75.04 5.31.02.64 0 1.93.18 1.97 1.13.02.58-.06.57-1.7 4.43-2.8 6.6-2.65 6.11-3.51 8.18-.1.2-.19.26-.4.26H7.7c-.1.01-.28.1-.3.17-.07.4-.1.81-.16 1.24H13v-1.38c-.36 0-1.55.02-1.65-.15l.82-1.86c.85.2 1.78.4 2.6.6.18.04.24.15.24.34l.01 6.54c0 .52-.29.97-.78 1.17-.33.14-.28.17-6.45.12-.27 0-.37.1-.4.35-.07.65-.14 1.31-.25 1.97-.04.25.07.29.27.29 9.56.03-1.6 0 17.59 0-.13-.76-.23-1.5-.35-2.22-.06-.4-.06-.39-.5-.39-5.2.01-6.03-.12-6.07-.13-.65-.09-1.08-.53-1.1-1.17 0-.08-.01-3.64-.05-6.56 0-.24.08-.32.3-.38.66-.15 1.5-.3 2.15-.49.23-.07.36-.01.44.18.24.52.46 1.04.69 1.57.08.18 0 .22-.18.22H19v1.37h5.8l-.21-1.4c-.37 0-.72.02-1.06 0-1.18-.09-.96-.23-4.39-8.06-.46-1.02-1.45-3.15-1.9-4.52-.23-.72.29-1.3.98-1.35.97-.09 1.96-.08 2.94-.1 1.07-.03 2.15-.03 3.22-.03.16 0 .21-.07.23-.22l.2-1.48.13-.82L7.24 3zm8.57 5.84c.4.12.42-.04.5 0 .48 1.14.94 3.05 1.4 4.2.35.85.68 1.7 1.03 2.59l-.2.1c-.68.2-1.38.38-2.06.6-.31.1-.65.1-.96 0l-2.08-.64-.3-.15 2.67-6.7z',
        'ad-solid' => 'M2 7v18h28V7H2zm2 2h24v14H4V9zm7.72 2-.22.69-2.47 7.72-.03.15V21h2v-1h3v1h2v-1.44l-.03-.15-2.47-7.72-.22-.69h-1.56zM21 11v4h-1.5a2.52 2.52 0 0 0-2.5 2.5v1c0 1.37 1.13 2.5 2.5 2.5H23V11h-2zm-8.5 4.16.9 2.84h-1.8l.9-2.84zm7 1.84H21v2h-1.5a.49.49 0 0 1-.5-.5v-1c0-.29.21-.5.5-.5z',
        'address-book-solid' => 'M6 4v5H5v2h3V6h16v20H8v-3H6v5h20V4Zm10 6a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 21h2a3 3 0 0 1 6 0h2c0-1.71-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 10ZM6 12v2H5v2h3v-4Zm10 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2ZM6 17v2H5v2h3v-4Z',
        'address-book' => 'M6 4v5H5v2h3V6h16v20H8v-3H6v5h20V4Zm10 6a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 21h2a3 3 0 0 1 6 0h2c0-1.71-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 10ZM6 12v2H5v2h3v-4Zm10 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2ZM6 17v2H5v2h3v-4Z',
        'address-card-solid' => 'M3 6v20h26V6Zm2 2h22v16h-3.4c-.08-.14-.05-.32-.16-.44A2.03 2.03 0 0 0 22 23c-.52 0-1.06.18-1.44.56-.11.12-.08.3-.15.44h-8.82c-.07-.14-.04-.32-.15-.44A2.03 2.03 0 0 0 10 23c-.52 0-1.06.18-1.44.56-.11.12-.08.3-.15.44H5Zm7 2a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 7 21h2a3 3 0 0 1 6 0h2c0-1.71-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 12 10Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm7 1v2h6v-2Zm0 4v2h6v-2Z',
        'address-card' => 'M3 6v20h26V6Zm2 2h22v16h-3.4c-.08-.14-.05-.32-.16-.44A2.03 2.03 0 0 0 22 23c-.52 0-1.06.18-1.44.56-.11.12-.08.3-.15.44h-8.82c-.07-.14-.04-.32-.15-.44A2.03 2.03 0 0 0 10 23c-.52 0-1.06.18-1.44.56-.11.12-.08.3-.15.44H5Zm7 2a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 7 21h2a3 3 0 0 1 6 0h2c0-1.71-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 12 10Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm7 1v2h6v-2Zm0 4v2h6v-2Z',
        'adjust-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2v20c-5.54 0-10-4.46-10-10S10.46 6 16 6Z',
        'adn' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 3.94-6.6 9.9H11l1.53-2.3h6.94l1.56 2.3h1.6Zm0 2.4 2.84 4.25h-5.68Z',
        'adobe' => 'M4 6v20l8.9-20H4zm15.1 0L28 26V6h-8.9zM16 13.4 12.1 22h4.1l1.6 4h3.8L16 13.4z',
        'adversal' => 'M5.35 5C4.27 5 4 5.28 4 6.36v18.29C4 25.74 4.27 26 5.35 26H26.6c1.14 0 1.4-.24 1.4-1.4V6.43C28 5.26 27.75 5 26.6 5H5.35zm19.58 2.09h.45c.46-.04.62.2.62.65v13.37c0 .26-.04.64-.38.64-.57-.02-1.26.32-1.65-.26-.27-.4-.36-.18-.57-.05-2.45 1.36-5.88.32-6.62-3.91a7.2 7.2 0 0 1 .72-4.59c.54-1.1 2.6-3.49 6.24-1.4V8.3c0-1.2 0-1.2 1.2-1.2zm-14.08 3.59a6.7 6.7 0 0 1 2.88.55c1.88.77 1.27 2.72 1.27 5.9.12 1.18-.2 2.67.43 4.07.08.2.01.36-.13.49-.38.3-1.48.1-1.82-.34-.08-.1-.08-.17-.18-.29-.16-.17-.33-.1-.54.05-2.63 1.67-6.43.98-6.74-1.98a3.27 3.27 0 0 1 1.81-3.26c1.75-.9 4.96-.54 5.04-1.42.05-.47-.09-.92-.52-1.25a2.42 2.42 0 0 0-3.67 1.07c-.2.51-.43.44-.8.38a4.47 4.47 0 0 1-1.03-.25c-1.32-.52.39-2.54 1.14-2.95.94-.49 1.9-.74 2.86-.77zM21.3 13c-.71.04-1.4.44-1.77 1.2a5.03 5.03 0 0 0-.02 4.5c.78 1.68 3.22 1.87 4.11-.24.31-.73.58-3.2-.37-4.48A2.28 2.28 0 0 0 21.3 13zm-8.44 4.01a.42.42 0 0 0-.22 0c-1.1.22-2.22.39-3.32.65-.54.12-.9.52-.9 1.13.04 1.07 1.19 1.15 1.53 1.21 1.86.02 3.1-1.13 3.04-2.57-.02-.17.02-.36-.13-.42zm-6.58 6c.16-.03.36.03.51.03 6.2-.02 12.22-.03 18.42 0 .32 0 .78-.22.78.45 0 .71-.52.47-.83.47H6.84c-.35 0-.86.23-.84-.5.01-.32.13-.43.3-.45z',
        'affiliatetheme' => 'M12.1 5c-1.86.02-4.72 1.95-7.06 4.96-2.88 3.7-3.9 7.6-2.26 8.74 1.64 1.12 5.3-.97 8.18-4.66 2.88-3.7 3.9-7.6 2.26-8.73A1.9 1.9 0 0 0 12.1 5zm17.88 6c-3.8 6.36-9.9 9.54-13.62 7.27-1.28-.79-2.07-2.46-2.37-4.27A16.72 16.72 0 0 1 4 22c2.68 3.19 6.84 5 11.31 5 8.1 0 14.65-6.62 14.65-14.8.01-.46.07-.76.02-1.2z',
        'air-freshener-solid' => 'M16 2a3 3 0 0 0-2.06 5.17L9.06 14h2.07l-4 6H15v2H9v6h14v-6h-6v-2h7.87l-4-6h2.07l-4.88-6.83A2.99 2.99 0 0 0 16 2zm0 2a1 1 0 0 1 .41 1.9l-.08.03A.98.98 0 0 1 16 6a.98.98 0 0 1-.33-.07l-.08-.02A1 1 0 0 1 16 4zm-.2 4h.4l2.86 4h-1.93l4 6H10.87l4-6h-1.93l2.87-4zM11 24h10v2H11v-2z',
        'airbnb' => 'M16.02 4c-1.22 0-2.35.54-3.2 1.53-.36.45-.62.92-.85 1.34l-.05.1L11.4 8l-.04.1c-1.93 3.82-3.6 7.3-5.12 10.66l-.1.2-.18.42-.08.18a15.13 15.13 0 0 0-.54 1.27 5.31 5.31 0 0 0 2.9 6.78 5.13 5.13 0 0 0 2.63.34c.83-.1 1.65-.39 2.4-.83a11.5 11.5 0 0 0 2.7-2.24l.05.06.01-.02c.9.96 1.77 1.68 2.66 2.2a6.37 6.37 0 0 0 3.06.88 5.23 5.23 0 0 0 5.15-4.45l.03-.16a4.79 4.79 0 0 0-.35-2.83l-.23-.55a4.08 4.08 0 0 0-.19-.42l-.16-.36-.15-.36-.07-.12c-1.64-3.63-3.36-7.2-5.09-10.6l-.08-.17c-.18-.34-.37-.7-.56-1.1l-.06-.11a6.6 6.6 0 0 0-.73-1.14l-.05-.06A3.97 3.97 0 0 0 16.02 4zm-.03 2.02a2 2 0 0 1 1.58.73l.11.13c.21.24.36.51.53.8l.06.14.56 1.09.07.15c1.72 3.38 3.42 6.92 5.04 10.49l.14.31.01.02.07.15.18.4c.05.1.1.2.16.36l.22.53.07.18c.21.62.26 1.1.16 1.55l-.03.15a3.27 3.27 0 0 1-3.18 2.8c-.1 0-.23 0-.4-.03a4.4 4.4 0 0 1-1.66-.59 10.28 10.28 0 0 1-2.43-2.08l.06-.09a13.06 13.06 0 0 0 2.55-4.85c.15-.71.18-1.38.09-1.98A3.9 3.9 0 0 0 16 13a4 4 0 0 0-3.31 1.7l-.06.1c-.3.5-.5 1.03-.58 1.56-.1.64-.07 1.29.1 1.98a12.8 12.8 0 0 0 2.54 4.88l.04.06c-.91 1-1.69 1.67-2.46 2.1a4.43 4.43 0 0 1-2.05.62A3.2 3.2 0 0 1 9 25.76a3.29 3.29 0 0 1-1.97-2.55 3.6 3.6 0 0 1 .19-1.7c.1-.28.2-.52.31-.77l.16-.35.09-.2.17-.39.12-.27c1.49-3.29 3.14-6.73 5.08-10.56l.03-.08.53-1.03.02-.06c.19-.32.4-.7.63-.99a2.2 2.2 0 0 1 1.63-.79zM16 15a1.9 1.9 0 0 1 1.97 1.67c.06.36.03.8-.07 1.26-.23 1.06-.87 2.3-1.9 3.7a10.28 10.28 0 0 1-1.9-3.71c-.1-.46-.13-.87-.07-1.27.04-.28.14-.55.31-.81l.02-.04A2 2 0 0 1 16 15z',
        'algolia' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8 1a1 1 0 0 0-1 1v1.3a6.96 6.96 0 0 1 4 0V9a1 1 0 0 0-1-1h-2zm-4.3 2a1 1 0 0 0-.7.3l-.7.7a1 1 0 0 0 0 1.41l.8.82a7.03 7.03 0 0 1 2.13-2.12l-.82-.82a1 1 0 0 0-.7-.29zm5.3 1a6 6 0 1 0 0 12 6 6 0 0 0 0-12zm0 2a4 4 0 1 1 0 8 4 4 0 0 1 0-8zm0 1v3l2.6-1.48A2.99 2.99 0 0 0 16 14z',
        'align-center-solid' => 'M3 7v2h26V7Zm4 4v2h18v-2Zm-4 4v2h26v-2Zm4 4v2h18v-2Zm-4 4v2h26v-2Z',
        'align-justify-solid' => 'M3 7v2h26V7Zm0 4v2h26v-2Zm0 4v2h26v-2Zm0 4v2h26v-2Zm0 4v2h26v-2Z',
        'align-left-solid' => 'M3 7v2h26V7Zm0 4v2h18v-2Zm0 4v2h26v-2Zm0 4v2h18v-2Zm0 4v2h26v-2Z',
        'align-right-solid' => 'M3 7v2h26V7Zm8 4v2h18v-2Zm-8 4v2h26v-2Zm8 4v2h18v-2Zm-8 4v2h26v-2Z',
        'allergies-solid' => 'M16 2a3 3 0 0 0-2.88 2.25A2.93 2.93 0 0 0 12 4c-1.64 0-3 1.36-3 3v10.75l-.88-.88a3.02 3.02 0 0 0-4.24 0 3.02 3.02 0 0 0 0 4.25l6.78 6.79A6.73 6.73 0 0 0 15.37 30H20a7 7 0 0 0 7-7V11c0-1.64-1.36-3-3-3-.35 0-.68.07-1 .19V7c0-1.64-1.36-3-3-3-.4 0-.77.1-1.13.25A3 3 0 0 0 16 2zm0 2c.57 0 1 .43 1 1v10h2V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2v-4c0-.57.43-1 1-1 .57 0 1 .43 1 1v12c0 2.77-2.23 5-5 5h-4.63a4.66 4.66 0 0 1-3.28-1.53l-6.8-6.75a1.01 1.01 0 1 1 1.43-1.44l2.56 2.6L11 22.59V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2V5c0-.57.43-1 1-1zm0 13a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm6 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'amazon-pay' => 'm8.87 8-.2.04a3.72 3.72 0 0 0-2.15.98.16.16 0 0 1-.03-.07c-.02-.13-.03-.27-.06-.4-.03-.21-.15-.32-.36-.32h-.55c-.33 0-.4.07-.4.4v10.13c.02.15.11.23.24.24h1.01c.14 0 .23-.1.24-.24V15.1a3.34 3.34 0 0 0 3.01.83 2.9 2.9 0 0 0 2.1-1.67c.34-.67.48-1.34.49-2.08.02-.8-.05-1.58-.39-2.34a2.8 2.8 0 0 0-2.09-1.76l-.46-.07-.4-.01zm7.77 0-.14.02c-.46.03-.92.08-1.37.2-.3.07-.57.18-.85.27-.18.06-.26.19-.26.37v.47c.01.23.1.3.33.23.37-.1.74-.2 1.11-.27a5.9 5.9 0 0 1 1.78-.07c.31.06.6.14.8.41.18.22.25.5.26.78l.01 1.11v.06h-.07c-.5-.13-1.01-.2-1.53-.23-.53-.03-1.07 0-1.58.18a2.3 2.3 0 0 0-1.41 1.2 2.5 2.5 0 0 0-.2 1.45c.11.68.44 1.2 1.04 1.52.57.31 1.18.35 1.8.25.73-.1 1.37-.4 1.93-.87l.07-.06.1.53c.02.15.11.24.25.25h.78c.12 0 .22-.1.22-.23.02-.03.02-.08.02-.13v-4.98c0-.2-.02-.4-.05-.6-.1-.62-.35-1.14-.91-1.46a2.85 2.85 0 0 0-1.04-.34L17.2 8h-.57zm4.05 0c-.12 0-.18.1-.15.22l.09.3 2.82 6.94c.08.2.1.36 0 .56l-.44 1.06c-.14.31-.37.55-.72.64-.24.06-.5.08-.74.05l-.35-.05c-.16-.01-.24.06-.26.23v.47c.02.27.1.38.36.43a7 7 0 0 0 .8.1 2 2 0 0 0 1.9-1.04c.17-.28.31-.57.44-.88l3.37-8.57a.95.95 0 0 0 .07-.26c.02-.14-.05-.2-.17-.2h-.95a.38.38 0 0 0-.37.24l-.07.2-1.67 4.77-.36 1.06-.05-.12-1.84-5.1-.3-.83a.31.31 0 0 0-.3-.22h-1.1zM8.86 9.21c.71.06 1.3.41 1.6 1.24.18.51.23 1 .23 1.54 0 .5-.03.95-.18 1.43-.33 1.01-1.08 1.4-2.04 1.36a3.38 3.38 0 0 1-1.78-.66c-.06-.04-.1-.1-.08-.15V10a.17.17 0 0 1 .08-.17 3.3 3.3 0 0 1 2.17-.63zm7.57 3.15a4 4 0 0 1 .6.01c.4.04.8.1 1.19.17.08 0 .1.04.1.11v1.37c0 .06-.03.1-.08.14-.54.38-1.12.64-1.78.71-.27.02-.54.02-.8-.08a.96.96 0 0 1-.6-.64c-.08-.3-.08-.62 0-.93.12-.4.4-.61.78-.74.19-.06.39-.1.59-.12zM29.04 20a5.2 5.2 0 0 0-2.87.81c-.26.18-.21.43.07.4.94-.12 3.04-.37 3.41.1.38.48-.41 2.46-.76 3.34-.11.26.12.37.36.17 1.56-1.31 1.97-4.06 1.65-4.45-.16-.2-.93-.38-1.86-.37zM1.22 21c-.22.03-.32.3-.09.53C5.05 25.2 10.23 27 15.97 27c4.1 0 8.86-1.34 12.15-3.86.54-.42.08-1.04-.48-.8a28.54 28.54 0 0 1-11.33 2.41c-5.4 0-10.62-1.12-14.84-3.68a.39.39 0 0 0-.25-.07z',
        'amazon' => 'M16.2 4c-3.3 0-6.9 1.2-7.7 5.3-.1.4.2.7.5.7l3.3.3c.3 0 .6-.3.6-.6.3-1.4 1.5-2.1 2.8-2.1.7 0 1.5.3 1.9.9.5.7.4 1.7.4 2.5v.5c-2 .2-4.6.4-6.5 1.2-2.2.9-3.7 2.8-3.7 5.7 0 3.6 2.3 5.4 5.2 5.4 2.5 0 3.8-.6 5.7-2.5.6.9.9 1.4 2 2.3.3.1.6.1.8-.1l2.7-2.3c.3-.2.2-.6 0-.9-.6-.9-1.3-1.6-1.3-3.2v-5.4c0-2.3.2-4.4-1.5-6C20.1 4.4 17.9 4 16.2 4zm.9 10.3h.9v.8c0 1.3.1 2.5-.6 3.7-.5 1-1.4 1.6-2.4 1.6-1.3 0-2.1-1-2.1-2.5 0-2.7 2-3.4 4.2-3.6zm9.6 8.1c-.9 0-1.9.2-2.7.8-.2.2-.2.4.1.4.9-.1 2.8-.4 3.2.1s-.4 2.3-.7 3.1c-.1.2.1.3.3.2 1.5-1.2 1.9-3.8 1.6-4.2-.2-.3-.9-.4-1.8-.4zm-23 .4c-.2 0-.3.3-.1.4 3.3 3 7.6 4.7 12.4 4.7 3.4 0 7.4-1.1 10.2-3.1.5-.3.1-.9-.4-.7a24.77 24.77 0 0 1-21.9-1.4c-.1.2-.2.1-.2.1z',
        'ambulance-solid' => 'M18 3a2 2 0 0 0-2 2v1H1v19h3.16c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3h8.32c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3H31V13.62l-.25-.28-6-7-.28-.34H20V5a2 2 0 0 0-2-2ZM3 8h20.53L29 14.38V23h-1.16A3.98 3.98 0 0 0 24 20a3.99 3.99 0 0 0-3.84 3h-8.32A3.98 3.98 0 0 0 8 20a3.99 3.99 0 0 0-3.84 3H3Zm11 3v3h-3v2h3v3h2v-3h3v-2h-3v-3ZM8 22c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm16 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'american-sign-language-interpreting-solid' => 'm9.22 7.38-2.4 2.87-.16.19-.04.25L6 13.4V9H4v7l-1 1v6l4.38-.97 2.25.9.18.07h.81l.22-.16 2.7-1.59.24-.19.16-.28 1-2.4-1.88-.75-.87 2.09-1.56.97C9.86 20.5 8 19.87 8 18c0-2.33 2-3 2-3h1.56l1.72 1.72 1.44-1.44-2-2-.31-.28h-1.85l.19-.28 2.53-1.56-1.06-1.7-2.75 1.7-.19.09-1.12 1.69.37-1.63 2.25-2.69ZM21.37 9l-.21.16-2.7 1.59-.24.19-.16.28-1 2.4 1.88.76.87-2.1 1.57-.97c.76.18 2.62.82 2.62 2.69 0 2.33-2 3-2 3h-1.56l-1.72-1.72-1.44 1.44 2 2 .31.28h1.85l-.19.28-2.53 1.56 1.06 1.7 2.75-1.7.19-.09 1.12-1.69-.37 1.63-2.25 2.68 1.56 1.25 2.4-2.87.16-.19.04-.25.62-2.72V23h2v-7l1-1V9l-4.38.97-2.25-.9L22.2 9Z',
        'amilia' => 'M16.43 6c-2.76 0-5.73.28-8.09 2-.22.14-.4.41-.32.87.05.22.23 1.22.46 1.76.18.46.63.46.9.28C10.83 9.9 13.9 9 16.4 9c2.59 0 2.63 1.52 2.63 3.51v1.72c-3.9.5-10.25 1.55-11.65 2.14C5.78 17.09 6 20.2 6 21.02c0 1.26.68 4.98 5.58 4.98 2.13 0 5.85-.92 7.62-1.88v1.38c0 .14.1.37.27.4.14.05 1.91.1 2.32.1.41 0 2.8.01 2.97-.03.18-.05.23-.28.23-.4v-13.5C25 8.49 22.42 6 16.43 6zm2.59 10.77v5.1a8.94 8.94 0 0 1-4.08 1.09c-2.36 0-2.98-1.83-2.98-2.33 0-.55-.14-1.9.82-2.36 1.08-.6 4.24-1.32 6.24-1.5z',
        'anchor-solid' => 'M16 4a3.99 3.99 0 0 0-1 7.84V14h-3v2h3v7.97a8.52 8.52 0 0 1-7.06-4.44l1.6-.78-4-1.81-1.07 4.31 1.66-.81c.47.85 1.2 1.93 2.34 2.93A10.78 10.78 0 0 0 15 25.95V26l1 1 1-1v-.06a10.8 10.8 0 0 0 6.53-2.57c1.14-1 1.87-2.08 2.34-2.93l1.66.81-1.06-4.31-4 1.81 1.6.78A8.52 8.52 0 0 1 17 23.97L16.99 16h3v-2h-3v-2.16A3.99 3.99 0 0 0 16 4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'android' => 'M10.53 3.5a.5.5 0 0 0-.25.81l1.47 2.13A7.02 7.02 0 0 0 9 12v10c0 .7.44 1.2 1 1.56v2.94c0 1.37 1.13 2.5 2.5 2.5s2.5-1.13 2.5-2.5V24h2v2.5c0 1.37 1.13 2.5 2.5 2.5s2.5-1.13 2.5-2.5v-2.94c.56-.36 1-.86 1-1.56V12a7.02 7.02 0 0 0-2.75-5.56l1.47-2.13a.5.5 0 0 0-.4-.81h-.1a.5.5 0 0 0-.31.25l-1.5 2.13a6.98 6.98 0 0 0-6.82 0l-1.5-2.13a.5.5 0 0 0-.4-.25h-.16ZM16 7a5 5 0 0 1 4.9 4h-9.8A5 5 0 0 1 16 7Zm-2 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM6 11v10h2V11Zm18 0v10h2V11Zm-13 2h10v9h-1v4.5c0 .29-.21.5-.5.5a.49.49 0 0 1-.5-.5V22h-6v4.5c0 .29-.21.5-.5.5a.49.49 0 0 1-.5-.5V22h-1Z',
        'angellist' => 'M12.8 4c-.3 0-.6 0-1 .2a2.1 2.1 0 0 0-1 1.2 4.1 4.1 0 0 0-.3 1.6 15 15 0 0 0 .6 3.4l.9 2.7a2.1 2.1 0 0 0-1.6.3 3 3 0 0 0-1.3 2c0 .7 0 1.3.3 1.9-.6 0-1 .2-1.5.6-.6.6-.9 1.6-.9 2.6 0 3.6 1.9 5.7 3.9 6.6 2 1 4.1.9 5 .9.8 0 2.8 0 4.7-1.3 1.8-1.3 3.4-3.8 3.4-8 0-.4.3-2-.8-3.4l-.8-.8A43 43 0 0 0 24 6.8a4.2 4.2 0 0 0-.3-1.5A2 2 0 0 0 22.3 4a2.6 2.6 0 0 0-1.8.3 4 4 0 0 0-1.2 1.2 12.5 12.5 0 0 0-1.6 3.3l-.4 1.3a24.4 24.4 0 0 0-.5-1.5A13.9 13.9 0 0 0 15 5.4a4 4 0 0 0-1.3-1.1 2.3 2.3 0 0 0-.9-.3Zm-.1 2 .7.6a30.3 30.3 0 0 1 2.8 6.4 3 3 0 0 0-1.9.7A33.8 33.8 0 0 1 12.5 7l.1-.8V6Zm9 .1.2.7c0 .8-.2 2-.4 3a42.5 42.5 0 0 1-.9 3.8 6 6 0 0 0-2-.4l1-3.6c.4-1.1.8-2.2 1.3-2.8.2-.3.4-.6.6-.6h.2ZM16 15c3.7 0 5 .8 5.6 1.5.4.7.3 1.3.3 2.2 0 3.7-1.2 5.4-2.5 6.3a7 7 0 0 1-3.7 1c-.8 0-2.6 0-4-.7S9 23.4 9 20.5c0-.7.2-1 .3-1.2h.6c.6 0 1.7.8 2.7 2.1l.6 1a.6.6 0 0 1-.4.2c-.1 0-.3 0-.5-.3a6.5 6.5 0 0 1-1-1.2l-1.6 1.1c.4.6.7 1.2 1.2 1.6a3 3 0 0 0 2 .8c.7 0 1.4-.3 1.8-.9.2-.1.2-.3.3-.5l.5 1c.4.7 1 1 1 1l1-1.7-.4-.4a3 3 0 0 1-.4-1.7l.1-.8c.2-.4.5-.6.9-.8a3.7 3.7 0 0 1 1-.5 1 1 0 0 0 .1-2l-2.8-.8a.6.6 0 0 1-.3-.2l-.1-.2a1.1 1.1 0 0 1 0-.5.8.8 0 0 1 .1-.4l.4-.2Zm-4.6 0h.3l1 .8c.8.8 1.6 2 2.1 3.4.2.4.1.5.1.5a.7.7 0 0 1-.3.3 1.5 1.5 0 0 1-.6 0c-.2 0-.1 0 0 .2a9.4 9.4 0 0 0-1.9-2s-.6-.7-1-1.5l-.1-1c0-.3 0-.5.4-.7Z',
        'angle-double-down-solid' => 'm5.22 6.69-1.44 1.4L16 20.31 28.22 8.1l-1.44-1.4L16 17.47Zm0 7-1.44 1.4L16 27.31 28.22 15.1l-1.44-1.4L16 24.47Z',
        'angle-double-left-solid' => 'M15.9 4.78 4.7 16l11.2 11.22 1.4-1.44L7.53 16l9.78-9.78Zm7 0L11.7 16l11.2 11.22 1.4-1.44L14.53 16l9.78-9.78Z',
        'angle-double-right-solid' => 'M9.1 4.78 7.68 6.22 17.47 16l-9.78 9.78 1.4 1.44L20.31 16Zm7 0-1.41 1.44L24.47 16l-9.78 9.78 1.4 1.44L27.31 16Z',
        'angle-double-up-solid' => 'M16 4.69 3.78 16.9l1.44 1.4L16 7.53l10.78 10.78 1.44-1.4Zm0 7L3.78 23.9l1.44 1.4L16 14.53l10.78 10.78 1.44-1.4Z',
        'angle-down-solid' => 'm4.22 10.78-1.44 1.44 12.5 12.5.72.69.72-.7 12.5-12.5-1.44-1.43L16 22.56Z',
        'angle-left-solid' => 'm19.03 4.28-11 11-.69.72.7.72 11 11 1.43-1.44L10.19 16 20.47 5.72Z',
        'angle-right-solid' => 'm12.97 4.28-1.44 1.44L21.81 16 11.53 26.28l1.44 1.44 11-11 .69-.72-.7-.72Z',
        'angle-up-solid' => 'm16 6.6-.72.68-12.5 12.5 1.44 1.44L16 9.44l11.78 11.78 1.44-1.44-12.5-12.5Z',
        'angry-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-5.31 6A2.35 2.35 0 1 0 14 15.31Zm10.62 0L18 15.31A2.35 2.35 0 0 0 21.31 12Zm-2.75 5.84c-.14 0-.3.02-.43.04-1.13.16-1.97.78-2.72 1.28-.75.5-1.41.89-1.91.96-.5.08-.94 0-1.78-.84l-1.44 1.44c1.13 1.14 2.42 1.55 3.53 1.37 1.11-.17 1.94-.78 2.69-1.28s1.39-.86 1.9-.93c.53-.08 1.04-.02 1.91.84l1.38-1.44a4.43 4.43 0 0 0-3.13-1.44Z',
        'angry' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-5.31 6A2.35 2.35 0 1 0 14 15.31Zm10.62 0L18 15.31A2.35 2.35 0 0 0 21.31 12Zm-2.75 5.84c-.14 0-.3.02-.43.04-1.13.16-1.97.78-2.72 1.28-.75.5-1.41.89-1.91.96-.5.08-.94 0-1.78-.84l-1.44 1.44c1.13 1.14 2.42 1.55 3.53 1.37 1.11-.17 1.94-.78 2.69-1.28s1.39-.86 1.9-.93c.53-.08 1.04-.02 1.91.84l1.38-1.44a4.43 4.43 0 0 0-3.13-1.44Z',
        'angrycreative' => 'm29 9-1.55.1-1.15 2.26-.65-2.13-1.61.11.22.59c-.42-.47-1.18-.53-1.81-.48l-1.97.13-.16 1.58c-.05-.05-.65-1.63-2.67-1.49-2.04.13-2.8 1.67-3.18 2.34l.2-2.03-1.43.09-.32 3.28-1.9-3.13-1.34.1-.5 5.15-1.53-5.03-1.2.08-2.85 6 1.6-.09.4-.9 1.98-.13.22.86 2.84-.18.3-3.26 1.89 3.12 1.25-.08.2-2c.49 1.44 1.46 2.03 2.77 1.94 2-.12 2.65-1.41 2.98-1.87l-.16 1.55 1.42-.09.2-1.89.96 1.82 1.82-.12-1.26-1.92a2.36 2.36 0 0 0 1.6-2.44l.79 2.12-.24 2.18 1.42-.09.24-2.18L29 9zm-7.23 1.79c.62-.03.97 0 1.15.1.14.08.2.25.17.52a.71.71 0 0 1-.38.59c-.2.11-.57.18-1.08.21l.14-1.42zm-4.2.33c.2-.01.4.04.6.12.16.08.35.22.55.4l1.56-.1-.06.6-3.15.2-.12 1.18 1.71-.11c-.23.31-.48.56-.76.7a1.6 1.6 0 0 1-.66.21 1.3 1.3 0 0 1-1.07-.39c-.29-.3-.4-.68-.36-1.15.05-.5.26-.89.65-1.21.33-.27.7-.43 1.1-.45zM6.87 12.4l.42 1.85-1.2.08.78-1.93zM32 15.12l-4.66.31-1.58 4.06-.68-3.92-1.52.1 1.19 5.81 1.6-.1 2.36-5.7-.63 5.59 3.23-.2.15-1.3-1.72.12.12-.99 1.72-.11.16-1.39-1.73.12.1-.9 1.73-.11.16-1.4zm-8.6.56-1.42.1-.64 5.9 1.41-.08.65-5.92zm-1.66.12-3.75.24-.14 1.38 1.11-.07-.44 4.22-1.61-5.45-1.19.07-2.75 5.78.11-1.02-1.82.11.1-.98 1.82-.1.13-1.39-1.82.1.09-.87 1.82-.12.13-1.37-3.24.2-.13 1.32c-.19-.99-1.12-1.24-2.12-1.17l-1.95.12-.14 1.52c-.18-.28-.68-1.54-2.56-1.42a3.62 3.62 0 0 0-3.38 3.22c-.16 1.84 1.18 2.97 2.82 2.87a3.7 3.7 0 0 0 2.85-1.76l-.14 1.43 1.4-.08.2-1.84.96 1.77 6.31-.38.4-.8 1.97-.13.21.77 2.9-.18.5-4.53 1.2-.08.15-1.38zM7.99 18.04c.51.01.74.15.7.63-.07.69-.73.75-1.44.8l.13-1.4c.23-.02.44-.04.6-.03zm8.13.04.39 1.86-1.18.08.79-1.94zm-12.87.27c.59-.04.98.17 1.31.78l1.32-.08-.13 1.47-1.35.08c-.38.51-.81.9-1.45.93-1.07.07-1.5-.75-1.43-1.53.06-.78.78-1.59 1.73-1.65zm6.78.85-.29 2.96-1.1-1.65c.66-.27 1.14-.64 1.39-1.31z',
        'angular' => 'M16 3.94 4.36 8.17l2.09 15.67 9.55 5.3 9.55-5.3 2.09-15.67L16 3.94zm0 2.12 9.44 3.44-1.74 13.08-7.7 4.28-7.7-4.28L6.56 9.5 16 6.06zM16 8l-6 14h2l1.29-3h5.42L20 22h2L16 8zm0 4.55.02.06.7 1.75L17.85 17h-3.7l1.13-2.64.7-1.75.02-.06z',
        'ankh-solid' => 'M16 2c-2.75 0-5 2.25-5 5 0 1.96 1.11 3.88 2.16 5.44.13.2.27.37.4.56H8v3.16L9.16 16l5.75-.81L14 28.94 13.94 30h4.12L18 28.94l-.9-13.75 5.74.81 1.16.16V13h-5.56c.13-.19.27-.36.4-.56C19.9 10.88 21 8.96 21 7c0-2.75-2.25-5-5-5Zm0 2c1.67 0 3 1.33 3 3 0 1.08-.89 2.91-1.84 4.34-.59.88-.8 1.09-1.16 1.54-.37-.45-.57-.66-1.16-1.54C13.9 9.91 13 8.08 13 7c0-1.67 1.33-3 3-3Z',
        'app-store-ios' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 2.01a.29.29 0 0 0-.23.03c-.16.08-.24.27-.17.42.49 1.13 2.18 5.04 3.6 7.66l1.32-.71a102.16 102.16 0 0 0-4.34-7.27.3.3 0 0 0-.19-.13zm-.75 2.25a.87.87 0 0 0-.88.43l1.52.89a.92.92 0 0 0-.32-1.22c-.1-.05-.22-.08-.32-.1zm-1 .64-.81 1.4 1.54.86.78-1.35-1.51-.9zm-.9 1.55-3.22 5.6 1.52.87 3.2-5.57-1.5-.9zM9 15v2h1.93l1.17-2H9zm5.84 0-1.15 2h5.08l-1-2h-2.93zm5.3 0 .67 1.29.1.18.22.53H23v-2h-2.87zm.48 1.6-1.31.72.99 1.54 1.02-.59-.7-1.66zm.8 1.93-.96.52 1.03 2.45c.18.43.68.63 1.09.4a.81.81 0 0 0 .29-1.15l-1.44-2.22zM10 19.24l-.55 2.6.14.07 1.95-1.77-1.54-.9z',
        'app-store' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-.03 3.25a.78.78 0 0 0-.25.1l-.5.28a.6.6 0 0 0-.22.84l4.28 7.34 1.56-.9-4.28-7.35a.6.6 0 0 0-.6-.31Zm-1.31 2.44a.64.64 0 0 0-.63.31l-.53.94 1.63.94.53-.94a.62.62 0 0 0-.22-.85l-.56-.3c-.08-.05-.15-.1-.22-.1Zm-1.29 1.47L9.6 18.62l1.6.94 3.78-6.47ZM8 15.09v1.82h2.28l1.06-1.82Zm6.06 0-1 1.82h5.85l-1-1.82Zm6.69 0 .97 1.82h2.25v-1.82Zm.28 1.13-1.56.9.9 1.57 1.57-.9Zm.81 1.97c-.05 0-.1.03-.15.06-.26.14-.62.37-.85.5-.41.25-.09 1 0 1.16.55.9 1.11.79 1.54 1.43.23.36.14.51.21.63.03.04.12.08.16.03.65-.9.47-2.47 0-3.16-.2-.28-.54-.71-.9-.65Zm-12.46.78-.79 2.94c-.01.05.02.13.07.15.04.03.11.01.15-.03L11 19.91Z',
        'apper' => 'M3.1 12.02c-1.35 0-1.93.15-2.3.59-.2.26-.27.52-.29 1.22h1.93c.04-.52.19-.64.76-.64.65 0 .89.2.89.77v1.14h-.04c-.22-.59-.56-.73-1.67-.73-1.49 0-2.11.53-2.11 1.79C.27 17.52.81 18 2.33 18c1.09 0 1.51-.21 1.77-.99h.05l-.06.95H6v-3.81c0-.41-.1-.97-.2-1.19-.34-.69-1.04-.94-2.7-.94zm7.69 0c-1.08 0-1.42.2-1.88 1.04h-.04l.08-1.03H7.03v8.45H9v-3.5h.04c.23.77.67 1.02 1.69 1.02.84 0 1.32-.11 1.66-.48.45-.49.6-1.14.6-2.64 0-1.39-.15-1.98-.64-2.4-.34-.3-.85-.46-1.57-.46zm6.97 0c-1.08 0-1.42.2-1.88 1.04h-.04l.08-1.03H14v8.45h1.97v-3.5h.04c.24.77.68 1.02 1.7 1.02.84 0 1.32-.11 1.66-.48.46-.49.61-1.14.61-2.64 0-1.39-.15-1.98-.64-2.4-.34-.3-.86-.46-1.58-.46zm5.78 0c-1.14 0-1.81.16-2.25.57-.45.4-.62 1.02-.62 2.3 0 1.46.14 2.1.57 2.53.45.45 1.15.58 2.53.58 1.23 0 1.85-.16 2.21-.65.22-.29.34-.74.34-1.23V16h-1.87c0 .55-.2.7-.9.7-.78 0-1-.25-1-1.1l.01-.24h3.77v-.55c0-2.15-.65-2.79-2.8-2.79zm6.81 0c-.77 0-1.15.26-1.5 1h-.02l.09-1H27v5.94h1.91v-3.4c0-.4 0-.47.05-.62.12-.3.34-.46.66-.46.4 0 .51.2.51.97l-.01.2h1.75l-.01-.47c0-.98-.08-1.33-.34-1.7-.22-.3-.63-.46-1.17-.46zm-6.85 1.36c.81 0 .98.1.98.73l.01.2h-1.91l.01-.18c.05-.6.19-.75.91-.75zm-13.46.06c.87 0 1.04.25 1.04 1.63 0 1.2-.19 1.48-1.01 1.48-.89 0-1.06-.27-1.06-1.67 0-1.19.19-1.44 1.03-1.44zm6.98 0c.87 0 1.03.25 1.03 1.63 0 1.2-.2 1.48-1.01 1.48-.9 0-1.06-.27-1.06-1.67 0-1.19.19-1.44 1.04-1.44zM3.1 15.53c.76 0 .98.12.98.58 0 .52-.19.67-.85.67-.84 0-1.03-.13-1.03-.65 0-.45.24-.6.9-.6z',
        'apple-alt-solid' => 'M10.38 3.97c-.3 0-.47.03-.47.03l-1.04.1L9 5.12s.25 2.28 1.88 3.96A6.77 6.77 0 0 0 5 15.66c0 3.58 1.6 6.43 3.47 8.34.93.96 1.92 1.68 2.87 2.19.95.5 1.82.81 2.66.81.55 0 1.08-.1 1.56-.25.3-.1.58-.1.88 0 .48.16 1.01.25 1.56.25.9 0 1.78-.38 2.72-.97.94-.58 1.92-1.4 2.84-2.4C25.41 21.6 27 18.82 27 15.66 27 11.96 23.82 9 20 9c-1.03 0-1.98.25-2.84.66l-.04-.13a5.3 5.3 0 0 1 2.38-3.65l-1-1.75s-1.41.84-2.44 2.65c-.32-.5-.75-.98-1.28-1.4a7.14 7.14 0 0 0-4.4-1.41Zm.96 2.12c.7.1 1.55.34 2.2.85a4.64 4.64 0 0 1 1.34 1.93A4.7 4.7 0 0 1 12.66 8a4.54 4.54 0 0 1-1.32-1.9ZM12 11c1.3 0 2.46.47 3.34 1.22l.66.53.66-.53A5.16 5.16 0 0 1 20 11c2.8 0 5 2.11 5 4.66 0 2.48-1.3 4.87-2.9 6.62a11.6 11.6 0 0 1-2.44 2.03c-.77.48-1.46.69-1.66.69a3 3 0 0 1-.94-.16 3.46 3.46 0 0 0-2.12 0A3 3 0 0 1 14 25c-.27 0-.96-.16-1.72-.56s-1.62-1.04-2.4-1.85A9.8 9.8 0 0 1 7 15.66C7 13.1 9.2 11 12 11Z',
        'apple-pay' => 'M8.83 9a2.4 2.4 0 0 0-1.7.83c-.33.4-.7 1.05-.56 1.69.6.07 1.26-.3 1.63-.8A2.3 2.3 0 0 0 8.83 9zM4.8 11.66c-1.59 0-2.8 1.38-2.8 3.37C2 17.63 3.83 20 4.95 20c.7 0 .95-.45 1.85-.45.84 0 1.1.45 1.83.45 1.35 0 2.47-2.75 2.51-2.93-.22-.1-1.52-.72-1.52-2.2 0-1.44 1.19-2.09 1.24-2.12a2.5 2.5 0 0 0-2.09-1.09c-.9 0-1.7.5-2.14.5-.44 0-1.1-.5-1.83-.5zM13 12v8h2v-3h.5c.98 0 1.67-.67 2.08-1.5H18v-1c0-1.37-1.13-2.5-2.5-2.5H13zm7.22 0L18 18.84V20h2v-.84l.05-.16h1.9l.05.16V20h2v-1.16L21.78 12h-1.56zM24 12v1.3l2 3.07V20h2v-3.63l2-3.07V12h-2v.7l-1 1.54-1-1.54V12h-2zm-9 2h.5c.29 0 .5.21.5.5 0 .29-.21.5-.5.5H15v-1zm6 2.08.3.92h-.6l.3-.92z',
        'apple' => 'M20.84 2c-1.64 0-3.3.85-4.4 2.16v.03a5.66 5.66 0 0 0-1.38 4.31l-.28-.1a6.7 6.7 0 0 0-2.56-.59c-3.98 0-7 3.6-7 8.35 0 3.06 1.03 5.94 2.4 8.09a10.98 10.98 0 0 0 2.29 2.63A4.2 4.2 0 0 0 12.53 28c.96 0 1.68-.32 2.22-.56.54-.24.96-.44 1.75-.44.71 0 1.08.2 1.63.44.54.24 1.29.56 2.28.56a4.1 4.1 0 0 0 2.71-1.19A11.1 11.1 0 0 0 25 24.47a20.16 20.16 0 0 0 1.56-3.1c.09-.21.13-.28.19-.53l.19-.8-.75-.35a5.33 5.33 0 0 1-1.5-1.07 3.85 3.85 0 0 1-1.16-2.84c0-1.3.5-2.16 1.03-2.78.27-.3.55-.56.75-.72.1-.08.19-.12.25-.15l.16-.1.84-.53-.56-.84a6.33 6.33 0 0 0-5.28-2.85c-.48 0-.82.17-1.25.25.24-.22.55-.36.75-.62V7.4l.03-.04h.03a6.16 6.16 0 0 0 1.56-4.43L21.78 2Zm-1.18 2.31a4.13 4.13 0 0 1-.91 1.78l-.06.07c-.39.51-.98.9-1.57 1.12.17-.65.45-1.31.85-1.81l.03-.03c.44-.5 1.04-.88 1.66-1.13Zm-7.44 5.5c.56 0 1.17.21 1.81.47.64.26 1.24.6 2.1.6.85 0 1.5-.34 2.25-.6a7.4 7.4 0 0 1 2.34-.47c.52 0 1.82.33 2.9 1.35-.19.17-.35.3-.56.53a6.21 6.21 0 0 0 .19 8.34c.55.56.9.7 1.31.94l-.15.37a18.8 18.8 0 0 1-1.1 2.07c-.45.72-1 1.43-1.53 1.9-.53.48-1 .69-1.37.69-.57 0-.9-.16-1.47-.4a5.74 5.74 0 0 0-2.44-.6 6.1 6.1 0 0 0-2.56.6c-.59.25-.9.4-1.4.4-.25 0-.79-.2-1.38-.69a9.23 9.23 0 0 1-1.85-2.15 13.41 13.41 0 0 1-2.1-7c0-3.95 2.2-6.35 5-6.35Z',
        'archive-solid' => 'M4 5v6h1v16h22V11h1V5Zm2 2h20v2H6Zm1 4h18v14H7Zm5.81 2a1 1 0 0 0 .19 2h6a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 19 13h-6.19Z',
        'archway-solid' => 'M3 6v6h2v12H3v2h10v-7a3 3 0 0 1 6 0v7h10v-2h-2V12h2V6H3zm2 2h22v2H5V8zm2 4h18v12h-4v-5a5 5 0 0 0-10 0v5H7V12z',
        'arrow-alt-circle-down-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1 4v10h-3l4 4 4-4h-3V9Z',
        'arrow-alt-circle-down' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1 4v10h-3l4 4 4-4h-3V9Z',
        'arrow-alt-circle-left-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-3 7-4 4 4 4v-3h10v-2H13Z',
        'arrow-alt-circle-left' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-3 7-4 4 4 4v-3h10v-2H13Z',
        'arrow-alt-circle-right-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm3 7v3H9v2h10v3l4-4Z',
        'arrow-alt-circle-right' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm3 7v3H9v2h10v3l4-4Z',
        'arrow-alt-circle-up-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 4-4 4h3v10h2V13h3Z',
        'arrow-alt-circle-up' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 4-4 4h3v10h2V13h3Z',
        'arrow-circle-down-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1 4v10.28l-4-4-1.4 1.44 6.4 6.4 6.4-6.4-1.4-1.44-4 4V9Z',
        'arrow-circle-left-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-.72 4.6L8.88 16l6.4 6.4 1.44-1.4-4-4H23v-2H12.72l4-4Z',
        'arrow-circle-right-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm.72 4.6L15.28 11l4 4H9v2h10.28l-4 4 1.44 1.4 6.4-6.4Z',
        'arrow-circle-up-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 3.88-6.4 6.4 1.4 1.44 4-4V23h2V12.72l4 4 1.4-1.44Z',
        'arrow-down-solid' => 'M15 4v20.06l-6.78-6.78-1.44 1.44 8.5 8.5.72.69.72-.7 8.5-8.5-1.44-1.43L17 24.06V4Z',
        'arrow-left-solid' => 'm13.28 6.78-8.5 8.5-.69.72.7.72 8.5 8.5 1.43-1.44L7.94 17H28v-2H7.94l6.78-6.78Z',
        'arrow-right-solid' => 'm18.72 6.78-1.44 1.44L24.06 15H4v2h20.06l-6.78 6.78 1.44 1.44 8.5-8.5.69-.72-.7-.72Z',
        'arrow-up-solid' => 'm16 4.1-.72.68-8.5 8.5 1.44 1.44L15 7.94V28h2V7.94l6.78 6.78 1.44-1.44-8.5-8.5Z',
        'arrows-alt-h-solid' => 'm9.28 6.78-8.5 8.5L.1 16l.7.72 8.5 8.5 1.43-1.44L3.94 17h24.12l-6.78 6.78 1.44 1.44 8.5-8.5.69-.72-.7-.72-8.5-8.5-1.43 1.44L28.06 15H3.94l6.78-6.78Z',
        'arrows-alt-solid' => 'm16 1.59-5.7 5.7 1.4 1.42L15 5.4V15H5.41l3.3-3.3-1.42-1.4L1.6 16l5.7 5.7 1.42-1.4L5.4 17H15v9.59l-3.3-3.3-1.4 1.42 5.7 5.7 5.7-5.7-1.4-1.42-3.3 3.3V17h9.59l-3.3 3.3 1.42 1.4 5.7-5.7-5.7-5.7-1.42 1.4 3.3 3.3H17V5.41l3.3 3.3 1.4-1.42L16 1.6z',
        'arrows-alt-v-solid' => 'm16 2.1-.72.68-8 8 1.44 1.44L15 5.94v20.12l-6.28-6.28-1.44 1.44 8 8 .72.69.72-.7 8-8-1.44-1.43L17 26.06V5.94l6.28 6.28 1.44-1.44-8-8Z',
        'artstation' => 'M13.73 5 26 27l2-4.51a3 3 0 0 0-.13-2.91L20.1 6.44A3 3 0 0 0 17.54 5h-3.81zm-2.22 2.18L5.63 18h11.92L11.5 7.18zM4 21l2.17 4.34A3 3 0 0 0 8.85 27h13.72l-3.35-6H4z',
        'assistive-listening-systems-solid' => 'm24.75 1.38-1.1 1.65a11.44 11.44 0 0 1 3.79 4.06l1.75-.96a13.38 13.38 0 0 0-4.44-4.75Zm-1.69 2.5-1.12 1.65a9.31 9.31 0 0 1 2.9 3.06l1.72-1a11.41 11.41 0 0 0-3.5-3.71ZM17 5c-4.43 0-8 3.57-8 8h2c0-3.37 2.63-6 6-6s6 2.63 6 6c0 2.25-.65 3.47-1.38 4.69C20.9 18.9 20 20.17 20 22a3 3 0 0 1-3 3v2c2.75 0 5-2.25 5-5 0-1.17.6-1.97 1.38-3.28A10.79 10.79 0 0 0 25 13c0-4.43-3.57-8-8-8Zm0 3c-2.75 0-5 2.25-5 5h2a3 3 0 0 1 6 0h2c0-2.75-2.25-5-5-5Zm0 5a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3.78 1.94-1.19 1.22 2.81 2.8 1.22-1.18ZM8 22a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'asterisk-solid' => 'm17.7 17 6.2 8.4-2.4 1.6-5.5-8.7-5.5 8.7-2.3-1.6 6.2-8.4-9.3-2.4L6 12l9.1 3.2L14.5 5h3L17 15.2l9-3.2.8 2.7Z',
        'asymmetrik' => 'M18.09 6.08A32.7 32.7 0 0 0 2 10a55.12 55.12 0 0 1 8.28-2.44c3.66-.8 7.43-1.23 10.75-.72 7.41 1.16 9.57 6.2 4.8 11.27-.49.52-1.17 1.1-1.8 1.56L16.85 9.1l-9.2 13.4-.1-.03C3.27 21 3.21 18.48 5.98 15.33a16.1 16.1 0 0 1 3.87-2.83c.99-.56 2.04-1.1 3.13-1.49C9.8 12 6.9 13.58 5 15.53c-1.34 1.39-2 2.77-2 4.03-.02 1.7 1.84 3 4.02 3.86L5.28 26h4.95l1.17-1.77c1.05.04 2.18 0 3.27-.14L13.51 26h6.57l-1.6-2.67c.87-.25 1.75-.55 2.58-.89l1.86 2.82.46.74h4.94l-3.66-5.4c.9-.59 1.8-1.3 2.47-2 1.89-1.95 2.83-3.9 2.85-5.65.04-3.19-2.89-5.75-8.24-6.57-1.17-.17-2.4-.27-3.65-.3zm-1.28 9.94.7 1.02 3.01 4.58c-.8.34-1.65.64-2.5.89l-1.22-1.97-1.54 2.59c-1.1.16-2.19.18-3.24.15l4.79-7.26z',
        'at-solid' => 'M16.19 4A12.05 12.05 0 0 0 4.16 18.03a12 12 0 0 0 10.18 9.84c3.47.47 6.7-.53 9.16-2.5l-1.25-1.56a9.98 9.98 0 0 1-16.1-6.1A9.99 9.99 0 0 1 16.16 6c5.26.08 9.69 4.43 9.85 9.69v.34c0 2.2-1.8 3.97-4 3.97-1.12 0-2-.88-2-2v-8h-2v.78a4.43 4.43 0 0 0-2.5-.78 4.52 4.52 0 0 0-4.5 4.5v3a4.47 4.47 0 0 0 7.88 2.94A3.99 3.99 0 0 0 22 22a6.02 6.02 0 0 0 6-5.97v-.4A12.1 12.1 0 0 0 16.19 4Zm-.69 8c1.4 0 2.5 1.1 2.5 2.5v3c0 1.4-1.1 2.5-2.5 2.5S13 18.9 13 17.5v-3c0-1.4 1.1-2.5 2.5-2.5Z',
        'atlas-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4H9zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1zm7 2c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6zm.69 2.1c.48.08.94.22 1.34.46l.07.72-.47-.19-.38.32.06.9.97-.28 1.2.38-.32.53-.72-.44-.78.13-.75.56-.44 1.31.84.69.94-.16c.05 0 .38.82.38.82l-.5 1.53c-.62.38-1.34.62-2.13.62-.23 0-.46-.05-.69-.1l-.19-.3.47-1.76-1.78-1.34h-1.65l-.13-.25c0-.09-.03-.16-.03-.25 0-.21.03-.42.06-.63l.85-.65 1.78-.85-.28-1.15.78-.16.34.5 1.35-.25-.2-.72zm-3.63 6.62h.32l.6.72c-.35-.2-.65-.44-.92-.72zM9 24h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1z',
        'atlassian' => 'M15.93 4a.68.68 0 0 0-.58.36c-5.22 8.62-.37 15.66 2.83 22.27.1.22.33.37.58.37h7.6c.47 0 .8-.53.57-.98L16.47 4.35a.6.6 0 0 0-.54-.35zm-.05 3.74L24.21 25h-4.6l-.9-1.75c-2.6-5.06-5.06-9.87-2.83-15.5zM10.32 14a.62.62 0 0 0-.57.39L4.07 26a.7.7 0 0 0 .6 1h7.93c.25 0 .47-.16.57-.38 1.72-3.6.69-9.08-2.3-12.36a.76.76 0 0 0-.55-.26zm.25 3.26c1.34 2.37 1.8 5.43 1.09 7.74H6.79l3.78-7.74z',
        'atom-solid' => 'M16 3c-3.1 0-5.5 4.58-5.92 10.94.55.59 1.2 1.17 1.93 1.74 0-.66.04-1.3.1-1.91.58-.4 1.31-.9 1.89-1.23a21.81 21.81 0 0 1 7.7-2.85c.46-.06.89-.09 1.27-.09 1.3 0 2.22.31 2.56.9.3.53.17 1.38-.35 2.36.53.49 1.02.98 1.46 1.48 1.13-1.87 1.36-3.56.62-4.84-.89-1.53-2.94-2.17-5.8-1.8A23.75 23.75 0 0 0 13 10.8l-.54.34C13.18 7.44 14.64 5 16 5c.63 0 1.29.54 1.88 1.48.68-.21 1.35-.4 2-.53C18.86 4.09 17.52 3 16 3ZM9.22 7.61c-2.17-.04-3.74.61-4.48 1.89-.8 1.4-.47 3.26.92 5.3.12.2.26.4.43.63A23.8 23.8 0 0 0 13 21.2l.56.3c-1.14.4-2.25.68-3.27.81-1.95.26-3.38-.05-3.81-.81-.31-.53-.18-1.38.34-2.36-.53-.49-1.02-.98-1.47-1.47-1.12 1.86-1.35 3.55-.6 4.83.71 1.25 2.21 1.9 4.29 1.9a11.48 11.48 0 0 0 2.43-.26l.22-.04.04-.01a19.7 19.7 0 0 0 1.79-.48l.66-.2c.98-.34 1.98-.76 2.99-1.25.22-.72.41-1.57.56-2.55-.58.33-1.16.62-1.74.9-.67-.32-1.34-.67-1.99-1.05a21.76 21.76 0 0 1-6.32-5.25c-1.2-1.56-1.64-2.95-1.2-3.71.3-.52 1.1-.82 2.2-.88.15-.7.33-1.37.54-2Zm11.52 4.29c-.79.18-1.62.45-2.48.8.57.33 1.1.69 1.63 1.05.06.72.11 1.46.11 2.25 0 5.9-1.86 10.4-3.64 10.94A1.2 1.2 0 0 1 16 27c-.63 0-1.29-.54-1.88-1.48-.68.21-1.35.4-2 .53C13.14 27.91 14.48 29 16 29c.2 0 .4-.02.58-.06C19.7 28.34 22 23 22 16l-.02-.64c.91.8 1.72 1.61 2.34 2.43 1.2 1.56 1.64 2.95 1.2 3.71-.3.53-1.09.83-2.2.89-.15.7-.32 1.37-.53 2l.17.01c2.08 0 3.58-.65 4.3-1.9.88-1.53.4-3.63-1.35-5.93a22.12 22.12 0 0 0-5.17-4.67ZM16 14a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'audible' => 'M16 8c-5.08 0-9.46 2.92-11.6 7.16a12.47 12.47 0 0 1 20.8.9l2.28-1.15A13 13 0 0 0 16 8Zm0 4a9 9 0 0 0-8.27 5.45 8.44 8.44 0 0 1 13.88.4l2.3-1.16A9 9 0 0 0 16 12ZM1 15.38v2.24l14.55 7.27.45.23 15-7.5v-2.24l-15 7.5-15-7.5Zm14.97.62a4.96 4.96 0 0 0-4.7 3.41 4.44 4.44 0 0 1 6.7.25l2.3-1.15a4.95 4.95 0 0 0-4.3-2.51Z',
        'audio-description-solid' => 'm5.6 7-.32.28S2 10.6 2 16s3.28 8.72 3.28 8.72l.31.28h20.82l.3-.28S30 21.4 30 16s-3.28-8.72-3.28-8.72L26.4 7Zm.93 2h18.94c.33.36 2.53 2.73 2.53 7s-2.2 6.64-2.53 7H6.53A10.16 10.16 0 0 1 4 16c0-4.27 2.2-6.64 2.53-7Zm3.84 3-4 8h2.25l.5-1H11v1h2c2.2 0 4-1.8 4-4s-1.8-4-4-4Zm5.6 0a4.98 4.98 0 0 1 0 8h2.78A6.95 6.95 0 0 0 20 16c0-1.49-.46-2.86-1.25-4Zm3.94 0A7.96 7.96 0 0 1 21 16a7.9 7.9 0 0 1-1.1 4h2.26a9.98 9.98 0 0 0 0-8Zm3.34 0a10.9 10.9 0 0 1 0 8h2.13a12.91 12.91 0 0 0 0-8ZM13 14c1.12 0 2 .88 2 2s-.88 2-2 2Zm-2 1.25V17h-.88Z',
        'autoprefixer' => 'M15.93 5 8.67 27h3.5l1.23-4h5.2l1.24 4h3.5L15.92 5zm.04 9.69h.07L18 21h-3.97l1.95-6.31zM9.27 21l-7.8.56-.47 1.1 7.56.34.7-2zm13.43 0 .72 2 7.58-.33-.47-1.11L22.7 21z',
        'avianex' => 'M10.61 4a5.1 5.1 0 0 0-4.89 4.1L3.07 22.55a3.74 3.74 0 0 0 .76 3.14c.7.84 1.75 1.31 2.93 1.31h14.62a5.1 5.1 0 0 0 4.9-4.09l2.65-14.46a3.77 3.77 0 0 0-.77-3.14A3.72 3.72 0 0 0 25.24 4H10.6zm0 2h14.63c.57 0 1.07.21 1.39.6.32.38.44.91.33 1.5l-2.65 14.45A3.14 3.14 0 0 1 21.38 25H6.76c-.58 0-1.07-.21-1.39-.6a1.78 1.78 0 0 1-.33-1.49L7.69 8.45A3.14 3.14 0 0 1 10.61 6zm.8 1.97L11 8.2l-.9 1.36 3.25 4.71.97 1.4a49.4 49.4 0 0 0-1.55 1.64l-2.73-1.46-.74.72 2.47 2.27 1.91 2.88.85-.6-1.04-3.03c.59-.36 1.27-.8 1.96-1.28L20.9 22l1.5-.64.3-.37-4.47-5.63-.22-.34 1.67-1.21c.37-.31.3-.98-.13-1.48s-1.08-.68-1.45-.37c0 0-.68.64-1.59 1.53l-.23-.21-4.86-5.3z',
        'aviato' => 'M3.1 11 0 17.57h.85l.95-2.09h2.61l.94 2.09h.87L3.11 11zm14.4 0-3.12 6.56h.87l.95-2.09h1.2l-.08 1.93s-1.13.33-1.27 1.19a.13.13 0 0 0-.01.06l-3.24-.1 3.24.41c0 .11.01.2.03.32.01.13.03.24.06.36L4 19l4.43.46v.32a.62.62 0 0 0-.52.61.62.62 0 0 0 1.24 0 .62.62 0 0 0-.53-.61v-.29l4.02.45v.27a.62.62 0 0 0-.5.61c0 .34.28.51.62.51.34 0 .62-.17.62-.51 0-.3-.2-.56-.49-.6v-.26l1.42.16v1.2h-.3V22h.3v-.32h.25V22h.29v-.68h-.29v-1.17l1.92.22c.4.57.94.68.94.68v.33l-.25.01-.01.61h.2v-.25h.27l.01.25h.2l-.01-.6-.25-.02-.01-.33s.55-.11.95-.68l1.92-.22v1.17h-.3V22h.3v-.32h.25V22h.3v-.68h-.3v-1.19l1.42-.16v.25a.61.61 0 0 0-.5.6c0 .34.28.51.63.51.34 0 .61-.17.61-.51a.6.6 0 0 0-.5-.6v-.28l4.02-.45v.29a.63.63 0 0 0-.52.62c0 .33.28.62.62.62.34 0 .62-.29.62-.62a.64.64 0 0 0-.53-.62v-.32L31 19l-12.15.63c.04-.1.06-.22.08-.35l.02-.33 3.24-.41-3.24.1v-.05c-.15-.87-1.28-1.19-1.28-1.19l-.08-1.93h1.21l.95 2.1h.86L17.5 11zm11 .14c-.46 0-.89.08-1.29.25-.4.18-.75.3-1.05.6a3.27 3.27 0 0 0-.72 3.64c.17.4.42.75.72 1.04a3.18 3.18 0 0 0 2.34.98 3.26 3.26 0 0 0 2.35-.98 3.23 3.23 0 0 0 .96-2.33 3.32 3.32 0 0 0-.96-2.35c-.31-.31-.66-.42-1.06-.6-.4-.17-.83-.25-1.29-.25zm-22.6.07L9 17.78l3.1-6.57h-.85L9 16.01l-2.26-4.8h-.86zm7.22 0v6.36h.76v-6.36h-.76zm6.9 0v.58h2.06v5.78h.86v-5.78h2.04v-.58h-4.96zm8.48.55a2.6 2.6 0 0 1 1.8.74c.23.24.41.51.54.81.13.32.19.66.19 1.03 0 .35-.06.69-.19 1.01-.13.31-.3.59-.54.81-.23.24-.5.42-.82.55-.3.14-.64.2-.98.2-.35 0-.68-.06-.99-.2a2.2 2.2 0 0 1-.81-.55 2.64 2.64 0 0 1-.54-2.85c.12-.3.3-.57.54-.81.24-.22.5-.4.81-.54.31-.14.64-.2.99-.2zm-25.4.9.99 2.13H2.13l.98-2.13zm14.4 0 .97 2.13h-.91l-.06-1.4-.06 1.4h-.92l.98-2.13z',
        'award-solid' => 'M16 3a3 3 0 0 0-1.78.6l-1.66 1.15-1.9.25h-.04l-.03.03A3.4 3.4 0 0 0 8.03 7.6L8 7.63v.03l-.25 1.93-1.16 1.5-.03.04v.03a3.27 3.27 0 0 0 .03 3.62l1.2 1.66.3 1.72-3.21 4.9-1.04 1.53h4.79l1.15 2.7.72 1.71 1.03-1.56 3.16-4.75c.85.35 1.8.38 2.62 0l3.16 4.75L21.5 29l.72-1.72 1.16-2.69h4.78l-1.04-1.53L24 18.31l.25-1.87 1.16-1.66.03-.03v-.03c.7-1.12.73-2.53-.03-3.6l-1.16-1.65-.38-1.88h.04c0-.02-.03-.04-.04-.06A2.95 2.95 0 0 0 21.34 5h-.03l-1.87-.25-1.66-1.16A3.07 3.07 0 0 0 16 3Zm0 2.03c.23 0 .46.07.63.19L18.4 6.5l.21.16.25.03 2.2.31h.02c.45.05.77.36.82.81v.07l.4 2.21.03.22.16.19 1.28 1.78c.24.33.27.9-.03 1.38l-1.4 1.96-.04.26-.31 2.18v.03a1 1 0 0 1-.16.44l-.06.03v.03a.88.88 0 0 1-.6.32h-.05l-2.29.4-.25.03-.18.16-1.79 1.28c-.33.24-.92.27-1.4-.03l-1.63-1.25-.18-.16-.29-.03-2.18-.31h-.03a.88.88 0 0 1-.7-.44.99.99 0 0 1-.12-.37v-.07l-.4-2.28-.03-.25-.16-.18-1.28-1.79c-.24-.33-.27-.92.03-1.4l1.25-1.63.16-.18.03-.29.28-2.09c0-.01.03-.01.03-.03a1.4 1.4 0 0 1 1-1c.02 0 .02-.03.03-.03l2.1-.28.24-.03.22-.16 1.79-1.28c.16-.12.39-.19.62-.19Zm6.9 15.22 1.54 2.34h-2.4l-.26.63-.69 1.6-2.12-3.26.47-.34 1.97-.34v.03c.02 0 .04-.03.06-.04.54-.07 1.03-.3 1.44-.62Zm-13.8.03c.42.38.96.65 1.56.72h.03l1.9.25.44.34-2.12 3.22-.7-1.6-.24-.62h-2.4Z',
        'aws' => 'M6.6 9c-1.4 0-2.8.5-3 .8 0 .1-.2 1.1.1 1.1l.5-.1c1.2-.5 2-.5 2-.5 1.4-.1 2.2.8 2.1 2v.7a8.6 8.6 0 0 0-2.1-.3c-1.7 0-3.2.8-3.2 2.7C3 17.5 4.9 18 5.6 18a3.6 3.6 0 0 0 2.8-1.4c.6 1.3 1 1.2 1 1.2l.2-.1.6-.4.2-.3c0-.3-.6-.7-.5-1.7V12c0-.8-.3-1.7-.8-2.3A3.4 3.4 0 0 0 6.6 9zM26 9c-2 0-3.2 1.3-3.2 2.5 0 1.8 1.8 2.3 2 2.4 1.7.5 2 .5 2.4 1a1 1 0 0 1-.2 1.5c-.2 0-1 .5-2.6.2l-1.3-.4c-.1 0-.4-.2-.4.2v.5c0 .2.2.4.4.5a6.2 6.2 0 0 0 2.5.6s2.4 0 3.1-1.6c.2-.3.6-1.4-.2-2.4-.6-.8-1.1-.9-2.8-1.4-.1 0-1.3-.3-1.3-1.2 0-1 1.4-1.1 1.7-1.1 1.3 0 1.9.4 2.2.5.2 0 .2-.1.2-.3V10a.5.5 0 0 0 0-.3c-.5-.5-2-.7-2.5-.7zm-15.2.3a.2.2 0 0 0-.2.2l.1.4 2.2 7.4c0 .2.2.5.6.4h.8c.5 0 .6-.4.6-.4l1.5-6.2 1.5 6.2s0 .5.5.5h.9c.3 0 .5-.3.5-.5l2.4-7.6c0-.5-.2-.4-.2-.4h-1c-.4 0-.5.3-.5.4L19 16.1l-1.5-6.4c-.1-.5-.5-.4-.6-.4H16c-.4 0-.5.3-.6.4L14 16.1l-1.6-6.4c0-.2-.1-.5-.5-.4h-1zm-4.3 4.6 1.8.2-.1 1.2c-.1.5-.8 1.4-2.2 1.4a1.3 1.3 0 0 1-1.4-1.4c0-1.2 1.2-1.5 2-1.4zM29 20a5.2 5.2 0 0 0-2.8.8c-.3.2-.2.4 0 .4 1-.1 3-.4 3.4.1.4.5-.4 2.5-.7 3.3-.1.3.1.4.3.2 1.6-1.3 2-4 1.7-4.4-.2-.2-1-.4-1.9-.4zM1.2 21c-.2 0-.3.3 0 .5C5 25.2 10.1 27 16 27a21 21 0 0 0 12-3.9c.6-.4.1-1-.5-.8a28.5 28.5 0 0 1-11.3 2.4 28 28 0 0 1-14.8-3.6.4.4 0 0 0-.3-.1z',
        'baby-carriage-solid' => 'M18 4v9H9.69a9.83 9.83 0 0 0-1.22-2.1A6.83 6.83 0 0 0 3 8v2c1.86 0 3.05 1 3.88 2.1.78 1.04 1.09 2.03 1.12 2.12A9.02 9.02 0 0 0 12.94 22 3.02 3.02 0 0 0 10 25c0 1.64 1.36 3 3 3a3.02 3.02 0 0 0 2-5.25 8.9 8.9 0 0 0 2 .25h3c.69 0 1.36-.1 2-.25A3.02 3.02 0 0 0 24 28c1.64 0 3-1.36 3-3a3.02 3.02 0 0 0-2.94-3A9.04 9.04 0 0 0 29 14.12V13h-.06a11.1 11.1 0 0 0-1-3.94C26.74 6.56 24.04 4 19 4Zm2 2.13c3.61.3 5.3 2 6.16 3.8a8.3 8.3 0 0 1 .78 3.07H20ZM10.22 15h16.56c-.5 3.36-3.28 6-6.78 6h-3a6.91 6.91 0 0 1-6.78-6ZM13 24c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm11 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'baby-solid' => 'M16 2c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm0 7c-6.67 0-9.9 6.56-9.9 6.56l1.8.88s1.4-2.73 4.1-4.32v6.1c-.4.14-.94.36-1.53.69-.54.29-1.1.67-1.56 1.18A3.2 3.2 0 0 0 8 24.13c-.05 1.55.83 2.96 1.63 4.12a22.68 22.68 0 0 0 1.59 2.06l1.5-1.37s-.73-.78-1.44-1.82c-.7-1.03-1.3-2.35-1.28-2.93 0-.24.12-.48.38-.75.25-.28.64-.56 1.06-.78.41-.23.81-.39 1.12-.5A4.27 4.27 0 0 0 16 24a4.25 4.25 0 0 0 3.4-1.81c.3.11.67.26 1.04.47.42.22.81.5 1.06.78.25.27.34.5.34.75 0 .62-.61 1.9-1.3 2.9-.7 1-1.38 1.75-1.38 1.75l1.43 1.38s.81-.87 1.6-2c.78-1.13 1.65-2.5 1.65-4.03 0-.84-.4-1.57-.87-2.1a5.8 5.8 0 0 0-1.56-1.18c-.51-.28-1.02-.48-1.41-.63v-6.16c2.7 1.6 4.1 4.32 4.1 4.32l1.8-.88S22.68 11 16 11Zm0 2c.71 0 1.38.08 2 .25v7.44c-.1.2-.7 1.31-2 1.31s-1.9-1.1-2-1.31v-7.44a7.62 7.62 0 0 1 2-.25Z',
        'backspace-solid' => 'm11.6 7-.32.28-8 8-.69.72.7.72 8 8 .3.28H29V7Zm.84 2H27v14H12.44l-7-7Zm2.72 2.75-1.41 1.4L16.59 16l-2.84 2.84 1.4 1.41L18 17.41l2.84 2.84 1.41-1.4L19.41 16l2.84-2.84-1.4-1.41L18 14.59Z',
        'backward-solid' => 'm17 5-1.6 1.19-12 9-1.06.81 1.07.81 12 9L17 27v-7.38l8.4 6.2 1.6 1.15V5.03L25.4 6.2 17 12.37Zm8 3.97v14.06l-8.4-6.19-1.13-.84 1.12-.84ZM15 9v14l-9.31-7Z',
        'bacon-solid' => 'M10.4 5c-2.8 0-5 2.3-5 2.3l-.4.3V15h1.4l.3-.2 1.5-1a5.1 5.1 0 0 1 2.2-.8 8 8 0 0 1 2.4.5c.9.2 2 .5 3.2.5s2.3-.3 3.1-.5c.8-.3 1.5-.5 2.5-.5a5 5 0 0 1 2.3.8l1.4 1 .2.2H27V7.6l-.3-.4S24.4 5 21.6 5a10 10 0 0 0-3.1.5 6.6 6.6 0 0 1-5 0 10 10 0 0 0-3-.5Zm0 2c1 0 1.7.2 2.5.5.9.2 1.8.5 3.1.5s2.2-.3 3-.5c.9-.3 1.6-.5 2.6-.5A6 6 0 0 1 25 8.5v.7l-.2-.1A6.6 6.6 0 0 0 21.6 8c-1.2 0-2 .3-3 .5A8.7 8.7 0 0 1 16 9c-1 0-1.9-.2-2.8-.5-.8-.2-1.7-.5-2.8-.5a7 7 0 0 0-3.2 1l-.2.2v-.7C7.5 8.1 9 7 10.4 7Zm0 2c1 0 1.7.2 2.6.5.8.2 1.8.5 3 .5s2.1-.3 3-.5a8.4 8.4 0 0 1 2.6-.5c.9 0 2 .5 2.7 1l.7.4V12a6.7 6.7 0 0 0-3.4-1.1 10 10 0 0 0-3 .5 7 7 0 0 1-5.2 0c-.8-.2-1.8-.5-3-.5s-2.3.5-3.2 1l-.2.2v-1.8l.7-.5a6 6 0 0 1 2.7-.9Zm0 8c-2.8 0-5 2.3-5 2.3l-.4.3V27h1.4l.3-.2 1.5-1a5.1 5.1 0 0 1 2.2-.8 8 8 0 0 1 2.4.5c.9.2 2 .5 3.2.5s2.3-.3 3.1-.5c.8-.3 1.5-.5 2.5-.5a5 5 0 0 1 2.3.8l1.4 1 .2.2H27v-7.4l-.3-.4S24.4 17 21.6 17a10 10 0 0 0-3.1.5 6.6 6.6 0 0 1-5 0 10 10 0 0 0-3-.5Zm0 2c1 0 1.7.2 2.5.5.9.2 1.8.5 3.1.5s2.2-.3 3-.5c.9-.3 1.6-.5 2.6-.5a6 6 0 0 1 3.4 1.5v1.7l-.2-.1a6.6 6.6 0 0 0-3.2-1.1c-1.2 0-2 .3-3 .5a8.7 8.7 0 0 1-2.6.5c-1 0-1.9-.2-2.8-.5-.8-.2-1.7-.5-2.8-.5a7 7 0 0 0-3.2 1l-.2.2v-1.7c.5-.4 2-1.5 3.4-1.5Zm0 3c1 0 1.7.2 2.6.5.8.2 1.8.5 3 .5s2.1-.3 3-.5a8.4 8.4 0 0 1 2.6-.5c.9 0 2 .5 2.7 1l.7.4v.7a6.7 6.7 0 0 0-3.4-1.1 10 10 0 0 0-3 .5 7 7 0 0 1-5.2 0c-.8-.2-1.8-.5-3-.5s-2.3.5-3.2 1l-.2.2v-.8l.7-.5a6 6 0 0 1 2.7-.9Z',
        'balance-scale-left-solid' => 'm23.52 5.1-5.24 1.98A2.98 2.98 0 0 0 13 9v.06L8 11l-5 8.75v.27a5 5 0 0 0 10 0v-.27l-3.99-6.98 4.71-1.84a3 3 0 0 0 1.28.89V26h6v-2h-4V11.82A3 3 0 0 0 19 9v-.05l4.21-1.59L19 14.73V15a5 5 0 0 0 10 0v-.27l-4.49-7.85-.99-1.77zM16 8a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm8 2.02L26.28 14h-4.56L24 10.02zM8 15.03 10.27 19H5.73L8 15.03zm13.19.97h5.62A3 3 0 0 1 24 18a3 3 0 0 1-2.81-2zM5.18 21h5.64A3 3 0 0 1 8 23.02 3 3 0 0 1 5.18 21z',
        'balance-scale-right-solid' => 'm8.48 5.1-.99 1.78L3 14.73V15a5 5 0 0 0 10 0v-.27L8.79 7.36 13 8.95V9a3 3 0 0 0 2 2.82V24h-4v2h6V11.82a3 3 0 0 0 1.28-.89l4.71 1.84L19 19.75v.27a5 5 0 0 0 10 0v-.27L24 11l-5-1.94V9a2.98 2.98 0 0 0-5.28-1.92L8.48 5.1zM16 8a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm-8 2.02L10.28 14H5.72L8 10.02zm16 5.01L26.27 19h-4.54L24 15.03zM5.19 16h5.62A3 3 0 0 1 8 18a3 3 0 0 1-2.81-2zm15.99 5h5.64A3 3 0 0 1 24 23.02 3 3 0 0 1 21.18 21z',
        'balance-scale-solid' => 'M16 5c-1.3 0-2.4.84-2.81 2H6v2h1.4l-.28.5-4 7-.12.25V17c0 2.75 2.25 5 5 5s5-2.25 5-5v-.25l-.13-.25-4-7L8.6 9h4.6c.3.84.97 1.5 1.81 1.81V24h-4v2h10v-2h-4V10.81c.84-.3 1.5-.97 1.81-1.81h4.6l-.29.5-4 7-.12.25V17c0 2.75 2.25 5 5 5s5-2.25 5-5v-.25l-.13-.25-4-7-.28-.5H26V7h-7.19A3.01 3.01 0 0 0 16 5Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-8 5.03L10.28 16H5.72Zm16 0L26.28 16h-4.56ZM5.25 18h5.5A2.9 2.9 0 0 1 8 20a2.9 2.9 0 0 1-2.75-2Zm16 0h5.5A2.9 2.9 0 0 1 24 20a2.9 2.9 0 0 1-2.75-2Z',
        'ban-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2a10.99 10.99 0 0 1 8.38 18.13L9.03 7.46A10.95 10.95 0 0 1 16 5ZM7.62 8.88l15.35 15.65A10.95 10.95 0 0 1 16 27 10.99 10.99 0 0 1 7.62 8.87Z',
        'band-aid-solid' => 'M19.84 3c-.35.02-.65.1-.65.1l-.22.09L3.19 18.97l-.1.22s-.07.3-.09.65c-.02.36.03.86.19 1.44.31 1.17 1.11 2.71 2.97 4.56 1.85 1.86 3.4 2.66 4.56 2.97a3.64 3.64 0 0 0 2.09.09l.22-.09 15.78-15.78.1-.22s.07-.3.09-.65a4.8 4.8 0 0 0-.19-1.44C28.5 9.55 27.7 8 25.84 6.16 24 4.3 22.44 3.5 21.28 3.19A4.8 4.8 0 0 0 19.84 3Zm.1 2h.03c.16 0 .4.02.78.13.77.2 2.03.77 3.69 2.43l.1.13c1.55 1.6 2.13 2.81 2.34 3.56.1.37.12.63.12.78v.03L12.06 27h-.03c-.15 0-.4-.02-.78-.13-.77-.2-2.03-.77-3.69-2.43l-.12-.16c-1.53-1.57-2.11-2.79-2.32-3.53-.1-.37-.12-.63-.12-.78v-.03ZM19 9a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-5.78 2.78-1.44 1.44 4 4 1.44-1.44ZM22 12a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-8.78 2.78-1.44 1.44 4 4 1.44-1.44ZM10 18a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'bandcamp' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-2.62 7-4 8h9.24l4-8h-9.24zm1.24 2h4.76l-2 4h-4.76l2-4z',
        'barcode-solid' => 'M2 7v18h2V7Zm4 0v18h6V7Zm8 0v18h2V7Zm4 0v18h4V7Zm6 0v18h2V7Zm4 0v18h2V7Z',
        'bars-solid' => 'M4 7v2h24V7Zm0 8v2h24v-2Zm0 8v2h24v-2Z',
        'baseball-ball-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c3.1 0 5.88 1.29 7.88 3.35a9.21 9.21 0 0 0-2.56 2.83l1.72 1a7.37 7.37 0 0 1 2.1-2.29 10.94 10.94 0 0 1 0 12.22 7.49 7.49 0 0 1-2.13-2.34l-1.73 1a9.39 9.39 0 0 0 2.6 2.88 10.96 10.96 0 0 1-15.76 0 9.39 9.39 0 0 0 2.6-2.88l-1.73-1a7.49 7.49 0 0 1-2.13 2.34 10.94 10.94 0 0 1 0-12.22c.85.61 1.57 1.4 2.1 2.3l1.72-1.01a9.21 9.21 0 0 0-2.56-2.83C10.12 6.29 12.9 5 16 5zm-4.42 8.21-1.91.6a7.52 7.52 0 0 1 .02 4.34l1.91.57a9.29 9.29 0 0 0-.02-5.5zm8.84 0a9.48 9.48 0 0 0-.02 5.51l1.91-.57a7.46 7.46 0 0 1 .02-4.35l-1.91-.59z',
        'basketball-ball-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm-1.13 2.06H15V15h-3.06A12.92 12.92 0 0 0 8.9 7.6c1.64-1.4 3.7-2.3 5.96-2.54Zm2.13 0a10.9 10.9 0 0 1 6.1 2.53A12.92 12.92 0 0 0 20.05 15H17ZM7.5 9.03A10.88 10.88 0 0 1 9.94 15H5.06A10.9 10.9 0 0 1 7.5 9.03Zm17 0A10.9 10.9 0 0 1 26.94 15h-4.88a10.9 10.9 0 0 1 2.44-5.97ZM5.06 17h4.88a10.88 10.88 0 0 1-2.44 5.97A10.9 10.9 0 0 1 5.06 17Zm6.88 0H15v9.94a10.9 10.9 0 0 1-6.1-2.53A12.92 12.92 0 0 0 11.95 17ZM17 17h3.06a12.94 12.94 0 0 0 3.03 7.4A10.9 10.9 0 0 1 17 26.95Zm5.06 0h4.88a10.9 10.9 0 0 1-2.44 5.97A10.88 10.88 0 0 1 22.06 17Z',
        'bath-solid' => 'M26 4a4 4 0 0 0-4 4h-2v2h6V8h-2c0-1.2.8-2 2-2s2 .8 2 2v6H1v2h1.19l1.53 7.6v.02c.23 1.04 1 1.88 2 2.22L5 28h2l.66-2h16.68l.66 2h2l-.72-2.16a3.03 3.03 0 0 0 2.1-2.21v-.04L29.8 16H31v-2h-1V8a4 4 0 0 0-4-4ZM4.22 16h23.6l-1.41 7.22c-.12.43-.49.78-1 .78H6.69a1 1 0 0 1-1-.81Z',
        'battery-empty-solid' => 'M3 8v16h24v-5h2v-6h-2V8Zm2 2h20v12H5Z',
        'battery-full-solid' => 'M3 8v16h24v-5h2v-6h-2V8Zm2 2h20v12H5Zm2 2v8h16v-8Z',
        'battery-half-solid' => 'M3 8v16h24v-5h2v-6h-2V8Zm2 2h20v12H5Zm2 2v8h8v-8Z',
        'battery-quarter-solid' => 'M3 8v16h24v-5h2v-6h-2V8Zm2 2h20v12H5Zm2 2v8h4v-8Z',
        'battery-three-quarters-solid' => 'M3 8v16h24v-5h2v-6h-2V8Zm2 2h20v12H5Zm2 2v8h14v-8Z',
        'battle-net' => 'M26.58 14.34s2.3.12 2.3-1.24c0-1.77-3.07-3.36-3.07-3.36s.48-1.02.78-1.6a21.6 21.6 0 0 0 1.22-3.29c.1-.64-.05-.84-.05-.84-.2 1.37-2.43 5.3-2.61 5.44-2.17-1.02-5.16-1.3-5.16-1.3S17.07 2 14.32 2c-2.73 0-2.71 5.27-2.71 5.27s-.77-1.5-1.74-1.5C8.46 5.77 8 7.91 8 10.22c-2.79 0-5.13.63-5.35.69-.2.05-.86.54-.57.48.62-.2 3.48-.64 6-.43.13 2.2 1.42 5.07 1.42 5.07s-2.76 4-2.76 6.84c0 .75.33 2.12 2.3 2.12 1.67 0 3.53-1 3.88-1.2a3.8 3.8 0 0 0-.54 1.66c0 .3.2 1.2 1.47 1.2 1.64 0 3.48-1.26 3.48-1.26s1.73 2.87 3.21 4.19c.4.35.78.42.78.42s-1.47-1.41-3.4-5.06c1.8-1.11 3.67-3.74 3.67-3.74l1.93.01c2.68 0 6.49-.56 6.49-2.69 0-2.2-3.42-4.18-3.42-4.18Zm.3-1.32c0 .77-.74.77-.74.77l-.57.03s-1.06-.56-1.71-.82c0 0 1-1.55 1.24-1.98.17.1 1.77 1.1 1.77 2ZM15.65 5.1c1.26 0 3.06 2.97 3.06 2.97s-2.8-.25-5.11 1.1c.06-2.13.78-4.07 2.05-4.07Zm-4.99 2.4c.4 0 .8.5.96.9 0 .28.14 1.87.14 1.87l-2.32-.09c0-2.08.82-2.68 1.22-2.68Zm-.24 14.48c-1.27 0-1.52-.7-1.52-1.34 0-1.43 1.14-3.44 1.14-3.44s1.29 2.7 3.52 3.84a5.8 5.8 0 0 1-3.14.94Zm4.1 2.82c-.88 0-1-.57-1-.7 0-.42.33-.9.33-.9s1.5-1 1.59-1.12l1.1 2.06s-1.13.66-2.01.66Zm2.77-1.12c-.54-.94-.94-1.92-.94-1.92s2.22.14 3.41-1.09a6.6 6.6 0 0 1-3.3.63 40.06 40.06 0 0 0 5.97-6.26c-.12-.15-.77-.6-.93-.68-.85 1.03-4.19 4.59-7.27 6.35-3.9-2.13-4.73-8.39-4.81-9.69l2.13.2s-.8 1.42-.8 2.47c0 1.04.13 1.1.13 1.1s-.03-1.82 1.1-3.23c.85 4.56 1.75 6.9 2.44 8.3l1.02-.45s-1.97-5.67-1.86-9.51c.9-.48 2.22-.97 3.71-.97 3.93 0 7.1 1.69 7.1 1.69l-1.24 1.72s-1.1-1.99-2.66-2.34c.82.6 1.74 1.41 2.21 2.57a40.09 40.09 0 0 0-8.44-2.09c-.11.47-.1 1.13-.1 1.13s5.27.98 9.1 3.17c-.02 4.8-5.25 8.48-5.97 8.9Zm5-3.58s1.63-2.15 1.6-5c0 0 2.65 1.65 2.65 3.24 0 1.79-4.26 1.76-4.26 1.76Z',
        'bed-solid' => 'M6 6C4.36 6 3 7.36 3 9v6.78c-.6.55-1 1.34-1 2.22v9h5v-2h18v2h5v-9c0-.88-.4-1.67-1-2.22V9c0-1.64-1.36-3-3-3Zm0 2h20a1 1 0 0 1 1 1v6h-2v-1c0-1.64-1.36-3-3-3h-4c-.77 0-1.47.3-2 .78a2.98 2.98 0 0 0-2-.78h-4c-1.64 0-3 1.36-3 3v1H5V9a1 1 0 0 1 1-1Zm4 5h4a1 1 0 0 1 1 1v1H9v-1a1 1 0 0 1 1-1Zm8 0h4a1 1 0 0 1 1 1v1h-6v-1a1 1 0 0 1 1-1ZM5 17h22a1 1 0 0 1 1 1v7h-1v-2H5v2H4v-7a1 1 0 0 1 1-1Z',
        'beer-solid' => 'M13.5 4a4.4 4.4 0 0 0-3.13 1.4C9.94 5.24 9.52 5 9 5a3.94 3.94 0 0 0-2.94 6.66A.93.93 0 0 0 6 12v13c0 1.64 1.36 3 3 3h12c1.64 0 3-1.36 3-3v-2h1c1.64 0 3-1.36 3-3v-4c0-1.64-1.36-3-3-3h-1v-1.41A4 4 0 0 0 25 9c0-2.2-1.8-4-4-4-.75 0-1.4.27-2 .63A3.84 3.84 0 0 0 17 5c-.26 0-.46.08-.69.13A4.36 4.36 0 0 0 13.5 4Zm0 2c.73 0 1.38.33 1.84.84l.44.47.63-.18c.22-.08.4-.13.59-.13a2 2 0 0 1 1.34.53l.66.6.66-.6A1.98 1.98 0 0 1 23 9c0 1.12-.88 2-2 2-1.1 0-2.72-.47-2.72-.47L17 10.16v1.34c0 1.4.3 2.47.56 3.28.26.81.44 1.33.44 1.72 0 .84-.66 1.5-1.5 1.5s-1.5-.66-1.5-1.5c0-.4.18-.94.44-1.75.26-.8.56-1.86.56-3.25V9.72l-1.5.94-.4.18c-.23.1-.52.16-.6.16a2.5 2.5 0 0 1-1.69-.66l-.72-.65-.65.69A2 2 0 0 1 7 9a1.98 1.98 0 0 1 3.1-1.66l.8.5.57-.78A2.46 2.46 0 0 1 13.5 6Zm-2.31 6.25c.68.43 1.45.75 2.31.75.1 0 .15-.05.25-.06-.08.38-.08.88-.19 1.22-.24.73-.56 1.43-.56 2.34 0 1.92 1.58 3.5 3.5 3.5s3.5-1.58 3.5-3.5c0-.9-.32-1.61-.56-2.34-.13-.4-.17-.96-.25-1.44.64.15.93.28 1.81.28.34 0 .68-.07 1-.16v.85c-.06.2-.06.4 0 .6v7.52a.9.9 0 0 0 0 .4V25c0 .57-.43 1-1 1H9c-.57 0-1-.43-1-1V12.84c.32.09.66.16 1 .16a3.9 3.9 0 0 0 2.19-.75ZM24 15h1c.57 0 1 .43 1 1v4c0 .57-.43 1-1 1h-1Z',
        'behance-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm2 4.37v8.61h4.18c1.56-.01 3.03-.76 3.03-2.5 0-1.1-.52-2.02-1.57-2.32.77-.38 1.17-.8 1.17-1.66 0-1.72-1.27-2.13-2.75-2.13H9zm9.14.63v.85h3.48V12h-3.48zm-7.24.69h1.78c.67 0 1.3.19 1.3.98 0 .73-.49 1.03-1.17 1.03H10.9v-2.01zm9.06.74c-1.89 0-3.18 1.41-3.18 3.3 0 1.93 1.21 3.27 3.18 3.27 1.5 0 2.46-.67 2.92-2.1h-1.51c-.17.53-.83.81-1.35.81-1.01 0-1.53-.59-1.53-1.58h4.49l.02-.33c0-1.84-1.09-3.37-3.04-3.37zm-.06 1.28c.87 0 1.3.51 1.37 1.34h-2.78c.05-.82.59-1.34 1.41-1.34zm-9 1.42h2.06c.83 0 1.36.35 1.36 1.24 0 .86-.63 1.13-1.4 1.13h-2.03v-2.37z',
        'behance' => 'M1 6.75v18.5h8.94c.83 0 6.53-.17 6.53-5.38a4.56 4.56 0 0 0-3.38-4.68c.84-.4 2.5-1.33 2.5-3.85 0-1.4-.2-4.59-5.9-4.59Zm20.38 1.72v1.69h6.9v-1.7ZM5.05 9.9h3.82c.35 0 2.78-.2 2.78 2.12 0 1.98-1.75 2.19-2.47 2.19H5.06ZM25 11.69c-5.22 0-6.31 4.53-6.31 6.5 0 5.83 4.78 6.5 6.31 6.5 4.13 0 5.3-2.67 5.78-4.16h-3c-.12.38-1 1.63-2.66 1.63-2.78 0-3.03-2.18-3.03-3.16h8.88c.18-3.38-1.3-7.31-5.97-7.31Zm-.1 2.53c.84 0 1.51.24 1.91.69.4.45.7 1.1.78 1.96h-5.5c.02-.23.07-.5.16-.8a2.4 2.4 0 0 1 1.31-1.57c.36-.19.8-.28 1.35-.28ZM5.07 17h4.4c.88 0 2.95.14 2.95 2.66 0 2.44-2.6 2.43-3 2.43H5.06Z',
        'bell-slash-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44L26 24.56V23h-1a1 1 0 0 1-1-1v-8.72a8.27 8.27 0 0 0-6.03-8c.01-.1.03-.18.03-.28a2 2 0 1 0-4 0c0 .09.02.17.03.25a7.94 7.94 0 0 0-4.4 2.94ZM15.56 7c.2-.02.42 0 .63 0 3.2.1 5.81 2.91 5.81 6.28v7.28L11.06 9.63A5.72 5.72 0 0 1 15.56 7Zm-7.53 5.25L8 13v9a1 1 0 0 1-1 1H6v2h7.19c-.12.32-.19.65-.19 1 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.35-.07-.68-.19-1h2l-2-2h-9c.12-.31.19-.65.19-1v-7.81ZM16 25c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'bell-slash' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44L26 24.56V23h-1a1 1 0 0 1-1-1v-8.72a8.27 8.27 0 0 0-6.03-8c.01-.1.03-.18.03-.28a2 2 0 1 0-4 0c0 .09.02.17.03.25a7.94 7.94 0 0 0-4.4 2.94ZM15.56 7c.2-.02.42 0 .63 0 3.2.1 5.81 2.91 5.81 6.28v7.28L11.06 9.63A5.72 5.72 0 0 1 15.56 7Zm-7.53 5.25L8 13v9a1 1 0 0 1-1 1H6v2h7.19c-.12.32-.19.65-.19 1 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.35-.07-.68-.19-1h2l-2-2h-9c.12-.31.19-.65.19-1v-7.81ZM16 25c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'bell-solid' => 'M16 3a2 2 0 0 0-2 2c0 .09.02.17.03.25A8.02 8.02 0 0 0 8 13v9c0 .57-.43 1-1 1H6v2h7.19c-.12.32-.19.65-.19 1 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.35-.07-.68-.19-1H26v-2h-1c-.57 0-1-.43-1-1v-8.72a8.3 8.3 0 0 0-6.03-8.03c.01-.08.03-.16.03-.25a2 2 0 0 0-2-2Zm-.44 4h.63c3.26.1 5.81 2.96 5.81 6.28V22c0 .35.07.68.19 1H9.8c.12-.32.19-.65.19-1v-9a6 6 0 0 1 5.56-6ZM16 25c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'bell' => 'M16 3a2 2 0 0 0-2 2c0 .09.02.17.03.25A8.02 8.02 0 0 0 8 13v9c0 .57-.43 1-1 1H6v2h7.19c-.12.32-.19.65-.19 1 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.35-.07-.68-.19-1H26v-2h-1c-.57 0-1-.43-1-1v-8.72a8.3 8.3 0 0 0-6.03-8.03c.01-.08.03-.16.03-.25a2 2 0 0 0-2-2Zm-.44 4h.63c3.26.1 5.81 2.96 5.81 6.28V22c0 .35.07.68.19 1H9.8c.12-.32.19-.65.19-1v-9a6 6 0 0 1 5.56-6ZM16 25c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'bezier-curve-solid' => 'M12 6v3H5.81A3.01 3.01 0 0 0 3 7c-1.64 0-3 1.36-3 3s1.36 3 3 3c1.3 0 2.4-.84 2.81-2h2.32c-.42.4-.77.82-1.1 1.28a11.56 11.56 0 0 0-2 5.72H2v8h8v-8H7.06a9.67 9.67 0 0 1 1.6-4.56A5.38 5.38 0 0 1 12 11.09V14h8v-2.9a5.38 5.38 0 0 1 3.34 2.34 9.67 9.67 0 0 1 1.6 4.56H22v8h8v-8h-3.03a11.56 11.56 0 0 0-2-5.72 8.36 8.36 0 0 0-1.1-1.28h2.32A3 3 0 0 0 29 13c1.64 0 3-1.36 3-3s-1.36-3-3-3c-1.3 0-2.4.84-2.81 2H20V6Zm2 2h4v4h-4ZM3 9c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm26 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1ZM4 20h4v4H4Zm20 0h4v4h-4Z',
        'bible-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4Zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1Zm6 2v3h-3v2h3v7h2v-7h3v-2h-3V8ZM9 24h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1Z',
        'bicycle-solid' => 'M19 6v1.44l.1.18L20.11 10h-8.68l-.31.44-2.72 3.84A6.5 6.5 0 1 0 6.5 27a6.5 6.5 0 0 0 6.46-6h3.44l.3-.44 4.88-7.18.66 1.5A6.52 6.52 0 0 0 19 20.5c0 3.57 2.93 6.5 6.5 6.5s6.5-2.93 6.5-6.5a6.53 6.53 0 0 0-7.9-6.34L21.4 8h3.1c.29 0 .5.21.5.5 0 .29-.21.5-.5.5v2c1.37 0 2.5-1.13 2.5-2.5S25.87 6 24.5 6ZM8 7v2h6l-1-2Zm5.47 5h6.65l-4.03 5.94Zm-1.75 1 2.62 6H6v2h4.94A4.48 4.48 0 0 1 2 20.5a4.5 4.5 0 0 1 8.25-2.5h2.25a6.5 6.5 0 0 0-2.28-2.84Zm13.78 3a4.5 4.5 0 1 1-4.5 4.5c0-1.57.83-2.95 2.06-3.75l2.03 4.66 1.82-.82-1.97-4.53c.18-.02.37-.06.56-.06Z',
        'biking-solid' => 'M19.5 5A3.51 3.51 0 0 0 16 8.5c0 1.92 1.58 3.5 3.5 3.5S23 10.42 23 8.5 21.42 5 19.5 5Zm0 2c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5S18 9.34 18 8.5 18.66 7 19.5 7Zm-4.4 3.53a2 2 0 0 0-1.35.72l-2.34 2.84c-.81.99-.46 2.54.68 3.1l3.44 1.68-.9 5 1.96.35 1.07-5.75.12-.75-.69-.34-4.15-2 2.37-2.88 4.06 3.28.29.22H25v-2h-4.66l-3.78-3.03a2.04 2.04 0 0 0-1.47-.44ZM8.5 18A4.52 4.52 0 0 0 4 22.5C4 24.97 6.03 27 8.5 27s4.5-2.03 4.5-4.5S10.97 18 8.5 18Zm15 0a4.52 4.52 0 0 0-4.5 4.5c0 2.47 2.03 4.5 4.5 4.5s4.5-2.03 4.5-4.5-2.03-4.5-4.5-4.5Zm-15 2a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5Zm15 0a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5Z',
        'bimobject' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm3 3v10.81h2.98V19.2h.05c.37 1.1 1.22 1.8 3.27 1.8h.8c4.3 0 4.83-1.55 4.83-3.85v-1.63c0-2.3-.53-3.84-4.84-3.84h-.8c-1.4 0-3.05.39-3.25 1.8h-.06V10H10zm5.05 4.24h2.24c1.62-.01 1.78.55 1.78 1.56v1.07c0 1-.16 1.57-1.78 1.57h-2.24c-1.35 0-2.06-.3-2.06-1.66v-.88c0-1.37.71-1.66 2.06-1.66z',
        'binoculars-solid' => 'M11 5a3.95 3.95 0 0 0-3.88 3.31 5.92 5.92 0 0 0-4.25 3.66h-.03L.72 17.94A7.01 7.01 0 0 0 7 28a7.01 7.01 0 0 0 6.9-5.88c.55.54 1.29.88 2.1.88s1.55-.34 2.1-.88A7.01 7.01 0 0 0 25 28a7.01 7.01 0 0 0 6.44-9.75l-2.28-6.38-.04-.03v-.03a6.14 6.14 0 0 0-4.25-3.5A3.95 3.95 0 0 0 21 5a3.95 3.95 0 0 0-3.81 3H14.8A3.95 3.95 0 0 0 11 5Zm0 2c1.2 0 2 .8 2 2v1h6V9c0-1.2.8-2 2-2s2 .8 2 2v.9l.9.1a4.21 4.21 0 0 1 3.35 2.53l.03.06.75 2.13A6.94 6.94 0 0 0 25 14a7 7 0 0 0-6.47 4.38 3.01 3.01 0 0 0-5.06 0A7 7 0 0 0 4 14.68l.75-2.02v-.04A3.9 3.9 0 0 1 8.09 10L9 9.9V9c0-1.2.8-2 2-2Zm-4 9a4.99 4.99 0 1 1 0 10 4.98 4.98 0 0 1-4.56-6.97l.03-.12A4.98 4.98 0 0 1 7 16Zm18 0a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm-9 3c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'biohazard-solid' => 'M13.6 4.4A6.5 6.5 0 0 0 9 10.5c0 1 .29 2 .69 2.9-1 0-1.98.29-2.88.79a6.58 6.58 0 0 0-3 7.12l2-.4c-.4-2 .4-4 2-5 2.1-1.2 4.98-.3 6.38 2.09.7 1.2.92 2.51.62 3.81-.3 1.2-1 2.18-2 2.78-1.6.9-3.81.62-5.31-.78l-1.31 1.5a6.75 6.75 0 0 0 7.72 1c.9-.5 1.59-1.22 2.09-2.12.5.9 1.2 1.62 2.1 2.12.9.5 1.99.78 3.09.78a6.9 6.9 0 0 0 4.62-1.78l-1.31-1.5a4.63 4.63 0 0 1-5.31.78c-1-.6-1.7-1.58-2-2.78-.3-1.3-.08-2.61.62-3.81 1.4-2.4 4.18-3.3 6.38-2.1 1.6.9 2.4 2.9 2 5l2 .41c.5-2.9-.7-5.72-3.1-7.12a6 6 0 0 0-2.9-.78c.5-.9.72-1.8.72-2.91 0-2.8-1.92-5.2-4.72-6.1l-.6 1.91c2 .6 3.32 2.3 3.32 4.19 0 2.5-2.2 4.5-5 4.5s-5-2-5-4.5c0-1.9 1.28-3.59 3.28-4.19ZM16 10c-1.1 0-2.1.19-3 .69.1.7.4 1.32 1 1.72.6-.3 1.3-.41 1.9-.41.6 0 1.31.1 1.91.4.6-.4 1-1.01 1-1.71A4.9 4.9 0 0 0 16 10Zm0 6c.6 0 1 .4 1 1s-.4 1-1 1-1-.4-1-1 .4-1 1-1Zm-6.03 1.31a1.9 1.9 0 0 0-.97.19c.2 2.1 1.3 3.99 3 5.19.5-.3.8-.78.9-1.38v-.4a5.1 5.1 0 0 1-1.9-3.32c-.35-.14-.7-.25-1.03-.28Zm12.12.1a2 2 0 0 0-1.09.28c-.2 1.3-.9 2.5-2 3.31v.4c.1.6.5 1.11.9 1.41A7.02 7.02 0 0 0 23 17.6c-.3-.1-.6-.18-.9-.18Z',
        'birthday-cake-solid' => 'm16 1.25-.81 1.19s-.54.75-1.06 1.65c-.27.46-.51.93-.72 1.41-.21.48-.41.92-.41 1.5 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.58-.2-1.02-.4-1.5-.22-.48-.46-.95-.73-1.4-.52-.9-1.06-1.66-1.06-1.66ZM16 10h-3v4H7a4 4 0 0 0-3 6.66V28h24v-7.34A4 4 0 0 0 25 14h-6v-4Zm0-5.13.13.22c.23.41.49.85.65 1.22.17.37.22.72.22.69a1 1 0 0 1-1 1 1 1 0 0 1-1-1c0 .03.05-.32.22-.69.16-.37.42-.8.65-1.22l.13-.21ZM15 12h2v2h-2Zm-8 4h18c1.2 0 2 .8 2 2s-.8 2-2 2-2-.8-2-2h-2c0 1.2-.8 2-2 2s-2-.8-2-2h-2c0 1.2-.8 2-2 2s-2-.8-2-2H9c0 1.2-.8 2-2 2s-2-.8-2-2 .8-2 2-2Zm3 4.66A4 4 0 0 0 13 22a4 4 0 0 0 3-1.34A4 4 0 0 0 19 22a4 4 0 0 0 3-1.34A4 4 0 0 0 25 22c.35 0 .68-.07 1-.16V26H6v-4.16c.32.09.65.16 1 .16a4 4 0 0 0 3-1.34Z',
        'bitbucket' => 'M16 5c-2.3 0-4.6.3-6.4.78-.91.24-1.69.5-2.32.88C6.65 7.04 6 7.6 6 8.5c0 .22.05.44.13.63l2.9 15.06c.12.6.5 1.04.94 1.37.43.33.93.58 1.53.78 1.2.42 2.75.66 4.5.66s3.29-.24 4.5-.66c.6-.2 1.13-.44 1.56-.78.44-.33.85-.77.94-1.4.02-.14.21-1.35.5-2.85l1.03-5.25 1.34-6.93c.08-.19.13-.4.13-.63 0-.9-.65-1.46-1.28-1.84a9.08 9.08 0 0 0-2.31-.88A25.8 25.8 0 0 0 16 5Zm0 2c2.13 0 4.32.27 5.9.69.8.2 1.42.47 1.79.68.1.07.1.1.15.13-.04.04-.05.06-.15.13-.37.21-1 .47-1.78.68-1.59.42-3.79.69-5.91.69-2.13 0-4.32-.27-5.9-.69a7.42 7.42 0 0 1-1.79-.69c-.1-.06-.1-.08-.15-.12.04-.04.05-.06.15-.13.37-.21 1-.47 1.78-.68C11.68 7.27 13.88 7 16 7Zm-7.53 3.88c.35.12.72.23 1.12.34 1.82.48 4.12.78 6.41.78 2.3 0 4.6-.3 6.4-.78.41-.11.78-.22 1.13-.35-.28 1.36-.5 2.35-.97 4.79l-.62 3.37c-.01.02-.03 0-.13.13-.14.16-.4.45-.81.71-.83.54-2.32 1.13-5 1.13s-4.2-.6-5.03-1.13a3.26 3.26 0 0 1-.78-.68l-.16-.19-1.56-8.13ZM16 13c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-5.4 6.9c1.2.6 2.91 1.1 5.4 1.1 2.46 0 4.18-.46 5.38-1.06l-.38 1.9a3.41 3.41 0 0 1-1.13.63c-.92.31-2.3.53-3.87.53a12.2 12.2 0 0 1-3.84-.53 3.65 3.65 0 0 1-1-.5c-.2-.15-.2-.22-.2-.16l-.37-1.9Z',
        'bitcoin' => 'M12 3v3H8v20h4v3h2v-3h2v3h2v-3h1.5a5.51 5.51 0 0 0 2.63-10.34A5.51 5.51 0 0 0 18.5 6H18V3h-2v3h-2V3Zm-2 5h8.5c1.95 0 3.5 1.55 3.5 3.5S20.45 15 18.5 15H10Zm0 9h9.5c1.95 0 3.5 1.55 3.5 3.5S21.45 24 19.5 24H10Z',
        'bity' => 'M16 3c-3.56 0-7 1.3-9.66 3.69a1 1 0 1 0 1.32 1.49 12.52 12.52 0 0 1 16.68 0 1 1 0 0 0 1.4-.08 1 1 0 0 0-.08-1.41A14.51 14.51 0 0 0 16 3zm-5 7a1 1 0 0 0-1 1v3.5c0 2.52 2.64 4.5 6 4.5s6-1.98 6-4.5V11a1 1 0 0 0-2 0v3.5c0 1.36-1.83 2.5-4 2.5s-4-1.14-4-2.5V11a1 1 0 0 0-1-1zm-6.67 3.01a1 1 0 0 0-1.15.83c-.12.73-.18 1.47-.18 2.22 0 6.08 4 11.39 9.74 12.9.09.03.18.04.26.04a1 1 0 0 0 .26-1.97A11.27 11.27 0 0 1 5 16.06c0-.64.05-1.28.15-1.9a1 1 0 0 0-.82-1.15zm23.34 0a1 1 0 0 0-.82 1.15c.1.62.15 1.26.15 1.9 0 5.17-3.4 9.69-8.26 10.97a1 1 0 0 0 .52 1.94A13.27 13.27 0 0 0 29 16.06c0-.75-.06-1.5-.18-2.22a1 1 0 0 0-1.15-.83zM16 20a1 1 0 0 0-1 1v3a1 1 0 0 0 2 0v-3a1 1 0 0 0-1-1z',
        'black-tie' => 'M5 5v22h22V5Zm2 2h18v18H7Zm5 2 2.81 3.63L12 20.37 16 24l4-3.63-2.81-7.75L20 9Z',
        'blackberry' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-6.28 6-.6 2.69h2.16c1.67 0 2.16-.77 2.16-1.5 0-.52-.32-1.19-1.66-1.19Zm5.53 0-.6 2.69h2.16c1.67 0 2.16-.77 2.16-1.5 0-.52-.33-1.19-1.66-1.19Zm5.06 2.4-.6 2.72h2.13c1.68 0 2.16-.79 2.16-1.53 0-.52-.32-1.18-1.66-1.18ZM8.97 15.07l-.56 2.72h2.12c1.67 0 2.16-.8 2.16-1.53 0-.52-.32-1.19-1.66-1.19Zm5.53 0-.56 2.72h2.12c1.67 0 2.16-.8 2.16-1.53 0-.52-.33-1.19-1.66-1.19Zm5 2.6-.6 2.68h2.16c1.67 0 2.13-.8 2.13-1.53 0-.52-.3-1.15-1.63-1.15Zm-5.78 1.65-.6 2.69h2.16c1.67 0 2.13-.8 2.13-1.53 0-.52-.3-1.16-1.63-1.16Z',
        'blender-phone-solid' => 'M6.58 5a.98.98 0 0 0-.82.48 12.9 12.9 0 0 0 0 13.04 1 1 0 0 0 1.15.44l1.94-.58a.52.52 0 0 0 .12-.53l-.8-2.42a.51.51 0 0 0-.48-.35h-.82a.51.51 0 0 1-.5-.38 10.72 10.72 0 0 1 0-5.4.51.51 0 0 1 .5-.38h.82c.22 0 .42-.14.49-.35l.8-2.42a.52.52 0 0 0-.13-.53l-1.94-.58A1.24 1.24 0 0 0 6.58 5zM10 5l1.88 16.01A3 3 0 0 0 9 24v3h17v-3a3 3 0 0 0-2.75-2.97L26.95 5H10zm2.25 2h12.2l-.47 2H19v2h4.52l-.47 2H19v2h3.6l-.47 2H19v2h2.67l-.46 2h-7.32L12.25 7zM12 23h11a1 1 0 0 1 1 1v1H11v-1a1 1 0 0 1 1-1z',
        'blender-solid' => 'M8 5a3 3 0 0 0-3 3v5a3 3 0 0 0 3 3h3.24l.63 5.01A3 3 0 0 0 9 24v3h17v-3a3 3 0 0 0-2.75-2.97L26.95 5H8zm0 2h2.12l.87 7H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm4.13 0h12.31l-.46 2H19v2h4.52l-.47 2H19v2h3.6l-.47 2H19v2h2.67l-.46 2h-7.33L12.13 7zM12 23h11a1 1 0 0 1 1 1v1H11v-1a1 1 0 0 1 1-1z',
        'blind-solid' => 'M14.5 3A3.51 3.51 0 0 0 11 6.5c0 1.92 1.58 3.5 3.5 3.5S18 8.42 18 6.5 16.42 3 14.5 3Zm0 2c.84 0 1.5.66 1.5 1.5S15.34 8 14.5 8 13 7.34 13 6.5 13.66 5 14.5 5Zm-3.69 5.25a2 2 0 0 0-1.34.69l-1.81 2.1c-.24.26-.41.6-.47.96l-.69 3.88 1.97.34.69-3.88 1.8-2.09H11l.78.16-1.19 5.37a2 2 0 0 0 .35 1.6L16.47 27h2.47l-6.38-8.81 1.19-5.4.47.09.75 2.62a2 2 0 0 0 1.22 1.31l2.97 1.13 3.87 8.75.94-.38L20 17.38l.4-1.1-3.5-1.34-.77-2.63a1.99 1.99 0 0 0-1.54-1.4l-3.25-.63a2.03 2.03 0 0 0-.53-.03Zm-.34 10.78-.5 1.94L7.07 27h2.46l2.31-3.16.13-.59Z',
        'blog-solid' => 'M14.52 4.01a.5.5 0 0 0-.52.51V6.5c0 .28.22.5.5.5v.02A11.96 11.96 0 0 1 25.98 18.5H26c0 .28.22.5.5.5h1.98a.5.5 0 0 0 .51-.52A15.02 15.02 0 0 0 14.52 4.01zm0 5a.51.51 0 0 0-.52.51v1.98c0 .28.22.5.5.5v.03c3.47.23 6.24 3 6.47 6.47H21c0 .28.22.5.5.5h1.98c.28 0 .52-.24.51-.52-.27-5.1-4.37-9.2-9.47-9.47zM5.5 10a.5.5 0 0 0-.5.5v11c0 3.58 2.92 6.5 6.5 6.5s6.5-2.92 6.5-6.5-2.92-6.5-6.5-6.5a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5A2.5 2.5 0 1 1 9 21.5v-11a.5.5 0 0 0-.5-.5h-3z',
        'blogger-b' => 'M13 7a6 6 0 0 0-6 6v7a6 6 0 0 0 6 6h7a6 6 0 0 0 6-6v-5a1 1 0 0 0-1-1h-1a1 1 0 0 1-1-1 6 6 0 0 0-6-6h-4zm0 5h4a1 1 0 0 1 1 1 1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1 1 1 0 0 1 1-1zm0 7h7a1 1 0 0 1 1 1 1 1 0 0 1-1 1h-7a1 1 0 0 1-1-1 1 1 0 0 1 1-1z',
        'blogger' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8 3c-2 0-1.97.02-2.6.27a3.82 3.82 0 0 0-2.31 2.71c-.05.23-.07.61-.08 2.78-.02 2.71 0 3.11.17 3.65a3.8 3.8 0 0 0 2.8 2.53c.4.07 5.28.1 5.77.02a3.54 3.54 0 0 0 2.19-1.13c.47-.47.76-.98.95-1.66.14-.47.13-3.82.07-4.06-.05-.21-.17-.42-.33-.5a4.9 4.9 0 0 0-.67-.07c-.54-.02-.6-.03-.77-.14-.26-.15-.34-.33-.34-.78 0-.88-.37-1.71-1.1-2.45a4.04 4.04 0 0 0-1.76-1.09c-.15-.04-.8-.08-1.99-.08zm-1.23 3h2.3a.77.77 0 0 1 0 1.54h-2.3a.77.77 0 0 1 0-1.54zm0 4.46h4.27a.77.77 0 0 1 0 1.54h-4.27a.77.77 0 0 1 0-1.54z',
        'bluetooth-b' => 'M14 3.6v9.96L9.72 9.28l-1.44 1.44L13.56 16l-5.28 5.28 1.44 1.44L14 18.44v9.97l1.72-1.7 5-5 .69-.71-.7-.72L16.45 16l4.28-4.28.69-.72-.7-.72-5-5Zm2 4.84L18.56 11 16 13.56Zm0 10L18.56 21 16 23.56Z',
        'bluetooth' => 'M16 2c-3.11 0-5.97.74-7.97 2.97C6.03 7.2 5 10.7 5 16c0 5.29 1.03 8.8 3.03 11.03C10.03 29.26 12.9 30 16 30c3.11 0 5.97-.74 7.97-2.97C25.97 24.8 27 21.3 27 16c0-5.29-1.04-8.8-3.03-11.03C21.97 2.74 19.1 2 16 2Zm0 2c2.8 0 4.95.62 6.47 2.31C23.99 8.01 25 10.98 25 16s-1 8-2.53 9.69C20.95 27.39 18.8 28 16 28s-4.95-.62-6.47-2.31C8.01 23.99 7 21.02 7 16s1-8 2.53-9.69C11.05 4.61 13.2 4 16 4Zm-1 3v6.56l-2.28-2.28-1.44 1.44L14.56 16l-3.28 3.28 1.44 1.44L15 18.44V25l1.6-1.19 4-3 .93-.72-4.1-4.09 4.1-4.1-.94-.71-4-3Zm2 4 1.47 1.1L17 13.55Zm0 7.44 1.47 1.47L17 21Z',
        'bold-solid' => 'M16 7a4.95 4.95 0 0 1 3.7 8.3A5 5 0 0 1 18 25H7V7h9m-7 8h7c1.7 0 3-1.3 3-3s-1.3-3-3-3H9v6m0 8h9c1.7 0 3-1.3 3-3s-1.3-3-3-3H9v6m7-18H5v22h13c3.9 0 7-3.1 7-7 0-2.1-1-4.1-2.5-5.4A6.96 6.96 0 0 0 16 5Zm-5 6h5c.6 0 1 .4 1 1s-.4 1-1 1h-5Zm0 8h7c.6 0 1 .4 1 1s-.4 1-1 1h-7Z',
        'bolt-solid' => 'M16 6v9l4 1-3.9 10H16v-8.03l-4-1L15.9 6h.1m2-2h-3.51l-.47 1.33-3.9 10.97-.74 2.07 2.14.54 2.48.62V28h3.47l.5-1.27 3.9-10 .82-2.12L18 13.44Z',
        'bomb-solid' => 'M24.73 5.87c-.35 0-.7.07-1.05.18a7.24 7.24 0 0 0-3.97 3.46A4.31 4.31 0 0 0 17.7 9h-.4l-1.6 1.6c-1.3-.6-2.6-.8-4.1-.6a8.4 8.4 0 0 0-7.5 7.4c-.3 2.6.6 5.2 2.4 7.1 1.6 1.6 3.8 2.5 6 2.5.4 0 .7 0 1.1-.1 3.9-.5 7-3.6 7.5-7.6.1-1.5-.1-2.9-.6-4.1l1.5-1.5v-.4c0-.9-.27-1.74-.73-2.43.44-.89 1.38-2.37 3.05-2.92.73-.25 1.12-.1 1.35.3.24.39.35 1.46-.56 3.3-.72 1.34-2.9 5.07-1.34 10.82L21 22.7l2.6 1.3-2 2.8 3.1-1.7 1.2 1.7v-2.2l3.2 1.1-2.1-2.1 1.7-1.3h-2.2V18l-1.14 2.34c-.73-4.17.8-6.5 1.52-7.87l.01-.02c1.09-2.16 1.25-3.94.51-5.22A2.74 2.74 0 0 0 25.78 6c-.33-.1-.69-.13-1.05-.12ZM18.1 11c.9.2 1.7.9 1.9 1.9l-.9.9c-1-.1-1.8-.9-1.9-1.9Zm-5.5.9c1 0 1.9.2 2.7.7.4 1.6 1.6 2.8 3.2 3.1.5 1 .7 2.1.6 3.4-.3 3-2.8 5.5-5.7 5.8-2 .2-4-.4-5.4-1.9a6.71 6.71 0 0 1-1.9-5.4c.3-2.9 2.8-5.4 5.7-5.6.3 0 .6-.1.8-.1Z',
        'bone-solid' => 'M20 4c-2.2 0-4 1.8-4 4 0 1 .45 1.83 1.06 2.53l-6.53 6.53A3.83 3.83 0 0 0 8 16c-2.2 0-4 1.8-4 4s1.8 4 4 4c0 2.2 1.8 4 4 4s4-1.8 4-4c0-1-.45-1.83-1.06-2.53l6.53-6.53C22.17 15.54 23 16 24 16c2.2 0 4-1.8 4-4s-1.8-4-4-4c0-2.2-1.8-4-4-4Zm0 2a1.98 1.98 0 0 1 1.9 2.56l-.18.6.44.4.28.28.4.44.6-.19A1.98 1.98 0 0 1 26 12a1.98 1.98 0 0 1-3.69 1.04l-.68-1.1-.88.91-7.9 7.91-.91.88 1.1.68A1.98 1.98 0 0 1 12 26a1.98 1.98 0 0 1-1.92-2.56l.2-.6-.45-.4-.28-.28-.4-.44-.6.19A1.98 1.98 0 0 1 6 20a1.98 1.98 0 0 1 3.69-1.04l.69 1.1.87-.91 7.9-7.91.91-.88-1.1-.68A1.98 1.98 0 0 1 20 6Z',
        'bong-solid' => 'M12 4v2h8V4h-8zm1 3v7.68a7.94 7.94 0 0 0-2.59 13.04l.3.28h10.58l.3-.28A7.96 7.96 0 0 0 24 22c0-1.45-.47-2.76-1.15-3.94l1.92-1.91.7.7 1.42-1.41-2.83-2.83-1.41 1.42.7.7-1.72 1.72A7.89 7.89 0 0 0 19 14.68V7h-2v9.04l.71.2A6 6 0 0 1 21.65 20h-11.3a6 6 0 0 1 3.94-3.75l.71-.21V7h-2zm-3 15h12a5.9 5.9 0 0 1-1.61 4H11.6a5.9 5.9 0 0 1-1.6-4z',
        'book-dead-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4H9zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1zm7 3c-5.93 0-4.94 8-4.94 8H13v2h6v-2h1.94s.99-8-4.94-8zm-2 4a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zm4 0a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zm-2 2 1 2h-2l1-2zm-7 9h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1z',
        'book-medical-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4Zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1Zm6 4v3h-3v2h3v3h2v-3h3v-2h-3v-3ZM9 24h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1Z',
        'book-open-solid' => 'M3 6v19h10a2 2 0 0 1 2 2h2c0-1.1.9-2 2-2h10V6H19a4 4 0 0 0-3 1.36A4 4 0 0 0 13 6Zm2 2h8a2 2 0 0 1 2 2h2c0-1.1.9-2 2-2h8v15h-8a4 4 0 0 0-3 1.36A4 4 0 0 0 13 23H5Zm10 4v2h2v-2Zm0 4v2h2v-2Zm0 4v2h2v-2Z',
        'book-reader-solid' => 'M16 4a6.02 6.02 0 0 0-5.31 8.78A28.04 28.04 0 0 0 4 12H2.72l3.5 14H7c3.4 0 5.5.49 6.72.94a6.14 6.14 0 0 1 1.47.75l.28.31h1.06l.28-.31.25-.16a6.8 6.8 0 0 1 1.22-.6C19.5 26.5 21.6 26 25 26h.78l3.5-14H28c-2.63 0-4.85.32-6.66.75A6.02 6.02 0 0 0 16 4Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4ZM5.31 14.13c3.11.15 5.65.69 7.32 1.3 1.33.5 2 .9 2.37 1.13v8.75c-.18-.08-.34-.17-.56-.25-1.35-.5-3.57-.92-6.66-1Zm21.38 0-2.47 9.93c-3.09.08-5.3.5-6.66 1-.22.08-.38.17-.56.25v-8.75c.38-.24 1.03-.63 2.34-1.12a25.3 25.3 0 0 1 7.35-1.31Z',
        'book-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4Zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1Zm2 3v2h11V9ZM9 24h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1Z',
        'bookmark-solid' => 'M7 5v23l1.6-1.19 7.4-5.56 7.4 5.56L25 28V5Zm2 2h14v17l-6.4-4.81-.6-.44-.6.44L9 24Z',
        'bookmark' => 'M7 5v23l1.6-1.19 7.4-5.56 7.4 5.56L25 28V5Zm2 2h14v17l-6.4-4.81-.6-.44-.6.44L9 24Z',
        'bootstrap' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 3v11.99c5.93 0 7.12.08 8.23-.25.65-.2 2.43-.84 2.43-3.09 0-1-.3-2.7-2.26-3.11v-.03h-.37c1-.45 1.63-1.3 1.63-2.55 0-.32.09-2.96-3.41-2.96H11zm2 2h4c1.5 0 1.66.85 1.66 1.49 0 1.55-1.63 1.51-1.66 1.51h-4v-3zm0 5h4.76c1.86 0 1.9 1.18 1.9 1.48 0 1.56-1.62 1.52-1.81 1.52H13v-3z',
        'border-all-solid' => 'M5 5v22h22V5H5zm2 2h8v8H7V7zm10 0h8v8h-8V7zM7 17h8v8H7v-8zm10 0h8v8h-8v-8z',
        'border-none-solid' => 'M5 5v4h2V7h2V5H5zm6 0v2h4V5h-4zm6 0v2h4V5h-4zm6 0v2h2v2h2V5h-4zm-8 4v4h2V9h-2zM5 11v4h2v-4H5zm20 0v4h2v-4h-2zM9 15v2h4v-2H9zm6 0v2h2v-2h-2zm4 0v2h4v-2h-4zM5 17v4h2v-4H5zm20 0v4h2v-4h-2zm-10 2v4h2v-4h-2zM5 23v4h4v-2H7v-2H5zm20 0v2h-2v2h4v-4h-2zm-14 2v2h4v-2h-4zm6 0v2h4v-2h-4z',
        'border-style-solid' => 'M5 5v22h4v-2H7V7h18v2h2V5H5zm20 6v4h2v-4h-2zm0 6v4h2v-4h-2zm0 6v2h-2v2h4v-4h-2zm-14 2v2h4v-2h-4zm6 0v2h4v-2h-4z',
        'bowling-ball-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-1.5 4a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-4 4a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm5 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'box-open-solid' => 'm16 4-5 4h10ZM8.5 5 5 9.66V27h22V9.66L23.5 5h-5L21 7h1.5L24 9H8l1.5-2H11l2.5-2ZM7 11h18v14H7Zm5.81 2a1 1 0 0 0 .19 2h6a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 19 13h-6.19Z',
        'box-solid' => 'm8.5 5-.31.4L5 9.67V27h22V9.66L23.81 5.4 23.5 5Zm1 2H15v2H8ZM17 7h5.5L24 9h-7ZM7 11h18v14H7Zm5.81 2a1 1 0 0 0 .19 2h6a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 19 13h-6.19Z',
        'boxes-solid' => 'M10 4v11h12V4H10zm2 2h2v4l2-2 2 2V6h2v7h-8V6zM3 17v11h12V17H3zm14 0v11h12V17H17zM5 19h2v4l2-2 2 2v-4h2v7H5v-7zm14 0h2v4l2-2 2 2v-4h2v7h-8v-7z',
        'braille-solid' => 'M12 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm8 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-8 8a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm8 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-8 8a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm8 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'brain-solid' => 'M13 4a3.97 3.97 0 0 0-3.84 3.19 4.94 4.94 0 0 0-4.1 5.5A5.86 5.86 0 0 0 4 16c0 1.8.9 3.3 2.16 4.4A4.4 4.4 0 0 0 6 21.5c0 2.47 2.03 4.5 4.5 4.5h.06c.58 1.13 1.6 2 2.94 2a3.5 3.5 0 0 0 2.5-1.06A3.5 3.5 0 0 0 18.5 28c1.35 0 2.36-.87 2.94-2h.06a4.5 4.5 0 0 0 4.47-4.13H26l-.03-.18c0-.07.03-.13.03-.19 0-.37-.13-.69-.22-1.03A5.87 5.87 0 0 0 28 16c0-1.25-.42-2.36-1.06-3.31.03-.23.06-.44.06-.69 0-2.45-1.82-4.4-4.16-4.81A3.97 3.97 0 0 0 19 4c-1.2 0-2.27.56-3 1.4A3.97 3.97 0 0 0 13 4Zm0 2c1.12 0 2 .88 2 2v2c0 1.67-1.33 3-3 3v2c1.13 0 2.16-.4 3-1.03V24.5c0 .84-.66 1.5-1.5 1.5-.75 0-1.34-.52-1.47-1.22l-.19-.97-.96.16c-.18.03-.29.03-.38.03a2.49 2.49 0 0 1-2.34-3.38l.03-.06c.3-.77.98-1.33 1.81-1.5l-.4-1.97A4.45 4.45 0 0 0 7 18.66a3.96 3.96 0 0 1-.13-5.13l.32-.37-.1-.5A2.99 2.99 0 0 1 10 9h1.01V8c0-1.12.88-2 2-2Zm6 0c1.12 0 2 .88 2 2v1h1c1.67 0 3 1.33 3 3 0 .21-.04.42-.1.66l-.09.5.32.37a3.96 3.96 0 0 1-.47 5.47 3.78 3.78 0 0 0-5-.1l1.28 1.54a1.85 1.85 0 0 1 3.03 1.22 2.47 2.47 0 0 1-2.85 2.3l-.96-.15-.2.97c-.12.7-.71 1.22-1.46 1.22-.84 0-1.5-.66-1.5-1.5V13.97A4.92 4.92 0 0 0 20 15v-2c-1.67 0-3-1.33-3-3V8c0-1.12.88-2 2-2Z',
        'bread-slice-solid' => 'M16 4C8.82 4 4 8.43 4 12.57c0 1.44.78 2.62 2 3.14V24a4 4 0 0 0 4 4h12a4 4 0 0 0 4-4v-8.29a3.3 3.3 0 0 0 2-3.14C28 8.43 23.18 4 16 4zm0 2c6.44 0 10 3.88 10 6.57 0 .77-.43 1.3-1.16 1.4l-.84.14V24a2 2 0 0 1-2 2H10a2 2 0 0 1-2-2v-9.89l-.84-.13C6.43 13.86 6 13.34 6 12.57 6 9.88 9.56 6 16 6z',
        'briefcase-medical-solid' => 'M14 5a2 2 0 0 0-2 2v1H6c-1.64 0-3 1.36-3 3v15h26V11c0-1.64-1.36-3-3-3h-6V7a2 2 0 0 0-2-2Zm0 2h4v1h-4Zm-8 3h20c.57 0 1 .43 1 1v13H5V11c0-.57.43-1 1-1Zm9 3v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'briefcase-solid' => 'M16 3a3.97 3.97 0 0 0-3.84 3H3v20h26V6h-9.16A3.97 3.97 0 0 0 16 3Zm0 2c.8 0 1.43.39 1.75 1h-3.5c.32-.61.94-1 1.75-1ZM5 8h22v9H5Zm11 6a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM5 19h22v5H5Z',
        'broadcast-tower-solid' => 'M7.19 4.19a10.83 10.83 0 0 0 0 15.4l1.4-1.4a8.8 8.8 0 0 1 0-12.57Zm17.62.1-1.4 1.43a8.79 8.79 0 0 1 0 12.56l1.4 1.44a10.9 10.9 0 0 0 0-15.44Zm-14.9 2.9a6.67 6.67 0 0 0 0 9.4l1.4-1.4a4.68 4.68 0 0 1 0-6.6Zm12.18.1-1.4 1.43a4.64 4.64 0 0 1 0 6.56l1.4 1.44a6.71 6.71 0 0 0 0-9.44ZM16 10a2 2 0 0 0-2 2c0 .63.3 1.16.75 1.53L10.31 26H9v2h4v-2h-.6L16 15.97 19.6 26H19v2h4v-2h-1.31l-4.44-12.47c.45-.37.75-.9.75-1.53a2 2 0 0 0-2-2Z',
        'broom-solid' => 'm28.28 2.28-10 10L17 11v-.03l-.03-.03a3.44 3.44 0 0 0-2.28-.85c-.8 0-1.58.3-2.19.91l-.16.13-.5.5-.34.28L2.37 19l-.87.72L12.28 30.5l.72-.88 7.06-9.06.03.03 1-1h.04l.03-.03a3.27 3.27 0 0 0-.07-4.47l-1.37-1.37 10-10Zm-13.6 9.81c.32 0 .66.1.91.32.02 0 .02.02.04.03l4.06 4.06c.37.38.4 1.17 0 1.69l-.03.06-.32.28-5.78-5.78.35-.34c.19-.2.47-.3.78-.32Zm-2.65 1.94 5.94 5.94-5.88 7.5-1.43-1.44 2.15-2.25-1.44-1.37-2.12 2.21-1.31-1.3 3.87-3.91-1.4-1.41-3.91 3.88-1.97-1.97Z',
        'brush-solid' => 'm19 2.03-.72.69-5.56 5.6L12 9l-1 1-2.28 2.31-.56.56.43.7s.61.93 1.1 1.96c.24.52.46 1.06.53 1.44.03.19.04.3.03.34-.1.09-1.43 1.13-3 2.4-1.64 1.34-3.38 2.74-4.1 3.45a4.01 4.01 0 0 0 0 5.65 4 4 0 0 0 5.63 0h.03a65.6 65.6 0 0 0 3.47-4.06l2.44-3.03s.04-.06.4 0c.37.06.88.25 1.38.5 1 .5 1.9 1.16 1.9 1.16l.7.5.59-.6L22 21l1-1 .69-.72 5.6-5.56.68-.72-.69-.72-9.56-9.56Zm1.31 5.22c.2.02.34.09.47.22.51.51-.23 2.52-.6 3.37-.35.86-.24 1.54.23 2 .79.8 2.89-1.08 3.78-.18.88.9-.73 2.8-.16 3.37l.03.03-1.78 1.78-8.12-8.12 1.37-1.38.06.07c.68.68 2.08.03 2.66-.35.69-.44 1.5-.86 2.06-.81Zm-7.6 3.9 8.13 8.13-.28.28-1.72 1.75c-.38-.26-.65-.48-1.43-.87-.6-.3-1.25-.57-1.94-.69-.7-.12-1.57-.09-2.19.53l-.03.06-.03.04s-1.18 1.5-2.5 3.12a83.57 83.57 0 0 1-3.31 3.9c-.8.8-2.03.8-2.82 0a1.97 1.97 0 0 1 0-2.8c.46-.47 2.28-2 3.91-3.32 1.63-1.32 3.13-2.5 3.13-2.5l.03-.03.06-.03c.63-.63.6-1.47.47-2.13a8 8 0 0 0-.69-1.9c-.38-.81-.6-1.11-.84-1.5l1.78-1.75Zm-6.46 13.5a1.1 1.1 0 1 0 0 2.19 1.1 1.1 0 0 0 0-2.18Z',
        'btc' => 'M12 3v3H8v20h4v3h2v-3h2v3h2v-3h1.5a5.51 5.51 0 0 0 2.63-10.34A5.51 5.51 0 0 0 18.5 6H18V3h-2v3h-2V3Zm-2 5h8.5c1.95 0 3.5 1.55 3.5 3.5S20.45 15 18.5 15H10Zm0 9h9.5c1.95 0 3.5 1.55 3.5 3.5S21.45 24 19.5 24H10Z',
        'buffer' => 'M16 5c-.16 0-.31.03-.46.09L3.2 10.79c-.26.12-.26.3 0 .42l12.34 5.7a1.18 1.18 0 0 0 .92 0l12.34-5.7c.26-.12.26-.3 0-.42l-12.34-5.7C16.3 5.03 16.16 5 16 5zm0 2.08L24.5 11 16 14.92 7.5 11 16 7.08zM4.84 14.45l-1.64.82c-.26.13-.26.33 0 .46l12.34 6.17a1.1 1.1 0 0 0 .92 0l12.34-6.17c.26-.13.26-.33 0-.46l-1.64-.82-10.7 5.35a1.1 1.1 0 0 1-.92 0l-10.7-5.35zm0 5-1.64.82c-.26.13-.26.33 0 .46l12.34 6.17a1.1 1.1 0 0 0 .92 0l12.34-6.17c.26-.13.26-.33 0-.46l-1.64-.82-10.7 5.35a1.1 1.1 0 0 1-.92 0l-10.7-5.35z',
        'bug-solid' => 'M10.72 3.28 9.28 4.72l1.94 1.94a10.64 10.64 0 0 0-3.35 4.65L5.45 10.1l-.88 1.82 2.75 1.37A13.2 13.2 0 0 0 7.03 17H4v2h3.38a12.4 12.4 0 0 0 1.03 2.94l-3 2.25 1.18 1.62 2.94-2.18A8.25 8.25 0 0 0 16 27a8.25 8.25 0 0 0 6.47-3.38l2.94 2.2 1.18-1.63-3-2.25c.47-.9.8-1.9 1.04-2.94H28v-2h-3.03a13.2 13.2 0 0 0-.28-3.72l2.75-1.37-.88-1.82-2.43 1.22a10.64 10.64 0 0 0-3.35-4.65l1.94-1.94-1.44-1.44-2.31 2.31a7.57 7.57 0 0 0-5.94 0ZM16 7c1.98 0 3.83 1.1 5.13 2.88A12.52 12.52 0 0 1 16 11c-2.2 0-4-.61-5.13-1.13C12.18 8.1 14.03 7 16 7Zm-6.1 4.6c1.16.54 2.93 1.17 5.1 1.34V24.9c-3.3-.63-6-4.28-6-8.91 0-1.62.34-3.11.9-4.4Zm12.2 0c.56 1.29.9 2.78.9 4.4 0 4.63-2.7 8.28-6 8.9V12.95c2.17-.17 3.94-.8 5.1-1.35Z',
        'building-solid' => 'M4 3v26h11v-4h2v4h11V3Zm2 2h20v22h-7v-4h-6v4H6Zm2 2v2h4V7Zm6 0v2h4V7Zm6 0v2h4V7ZM8 11v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 15v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 19v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 23v2h4v-2Zm12 0v2h4v-2Z',
        'building' => 'M4 3v26h11v-4h2v4h11V3Zm2 2h20v22h-7v-4h-6v4H6Zm2 2v2h4V7Zm6 0v2h4V7Zm6 0v2h4V7ZM8 11v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 15v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 19v2h4v-2Zm6 0v2h4v-2Zm6 0v2h4v-2ZM8 23v2h4v-2Zm12 0v2h4v-2Z',
        'bullhorn-solid' => 'M28 3.03 26.4 4.2s-1.98 1.47-4.84 2.93C18.71 8.6 15 10 11.72 10H2v9.13l.03.15 2 7 .22.72h6.06l-.34-1.28L8.34 20h3.38c3.23 0 6.94 1.44 9.81 2.9a41.98 41.98 0 0 1 4.88 2.91L28 26.97V17.8a3 3 0 0 0 2-2.81c0-1.3-.84-2.4-2-2.81Zm-2 3.72v16.47c-.83-.56-1.48-1.07-3.56-2.13C19.5 19.6 15.7 18.07 12 18v-6c3.74-.07 7.54-1.63 10.47-3.13 2.07-1.06 2.71-1.56 3.53-2.12ZM4 12h6v6H4Zm.34 8h1.91l1.4 5h-1.9Z',
        'bullseye-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 1a12 12 0 1 1 .01 23.99A12 12 0 0 1 16 4Zm0 2C10.49 6 6 10.49 6 16s4.49 10 10 10 10-4.49 10-10S21.51 6 16 6Zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Zm0 2c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Zm0 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'burn-solid' => 'm16.03 3.47-.66.56s-2.33 1.91-4.65 4.69C8.4 11.5 6 15.16 6 19a8.5 8.5 0 0 0 2.97 6.63 10.68 10.68 0 0 0 6.53 2.34c.17 0 .33.03.5.03.17 0 .33-.02.5-.03 2.5-.1 4.8-.89 6.53-2.34A8.5 8.5 0 0 0 26 19c0-3.46-2.41-7.06-4.72-9.94-2.3-2.88-4.6-5-4.6-5Zm-.06 2.78c.52.5 1.88 1.73 3.75 4.06C21.92 13.06 24 16.56 24 19a6.43 6.43 0 0 1-3.4 5.9c.24-.58.4-1.22.4-1.9 0-6.25-3.34-10.06-3.34-10.06l-1.82-2.03.07 2.71s0 1.28-.16 2.5c-.08.62-.2 1.23-.34 1.57-.05.1-.07.1-.1.15a2.2 2.2 0 0 1-.72-.5 5.63 5.63 0 0 1-.56-.68l-.97-1.5-.75 1.62S11 19.46 11 23c0 .68.16 1.32.4 1.9A6.43 6.43 0 0 1 8 19c0-2.96 2.1-6.38 4.28-9 1.85-2.22 3.17-3.3 3.69-3.75Zm1.69 10.53A14.7 14.7 0 0 1 19 23a3 3 0 0 1-6 0c0-1.6.3-2.94.6-3.9.44.4 1 .8 1.8.8.48 0 .94-.21 1.22-.5.3-.27.46-.6.6-.93.23-.53.34-1.11.44-1.69Z',
        'buromobelexperte' => 'M5 5v6h6V5H5zm8 0v6h6V5h-6zm8 0v6h6V5h-6zM7 7h2v2H7V7zm8 0h2v2h-2V7zm8 0h2v2h-2V7zM5 13v6h6v-6H5zm8 0v6h6v-6h-6zm8 0v6h6v-6h-6zM7 15h2v2H7v-2zm8 0h2v2h-2v-2zm8 0h2v2h-2v-2zM5 21v6h6v-6H5zm8 0v6h6v-6h-6zm8 0v6h6v-6h-6zM7 23h2v2H7v-2zm8 0h2v2h-2v-2z',
        'bus-alt-solid' => 'M12 3a3 3 0 0 0-2.82 2H9C6.8 5 5 6.8 5 9v5H3v3h2v10a1 1 0 0 0 1 1h3l.34-1h13.32l.34 1h3a1 1 0 0 0 1-1V17h2v-3h-2V9c0-2.2-1.8-4-4-4h-.18A3 3 0 0 0 20 3h-8zm0 2h8a1 1 0 0 1 1 1v1h2c1.12 0 2 .88 2 2v2H7V9c0-1.12.88-2 2-2h2V6a1 1 0 0 1 1-1zm1 2v2h6V7h-6zm-6 6h8v4H7v-4zm10 0h8v4h-8v-4zM7 19h18v6H7v-6zm1 2v2h4v-2H8zm12 0v2h4v-2h-4z',
        'bus-solid' => 'M9 4C6.8 4 5 5.8 5 8v5H3v3h2v11a1 1 0 0 0 1 1h3l.34-1h13.32l.34 1h3a1 1 0 0 0 1-1V16h2v-3h-2V8c0-2.2-1.8-4-4-4Zm0 2h14c1.12 0 2 .88 2 2H7c0-1.12.88-2 2-2Zm-2 4h8v7H7Zm10 0h8v7h-8ZM7 19h18v6H7Zm1 2v2h4v-2Zm12 0v2h4v-2Z',
        'business-time-solid' => 'M14 3c-.52 0-1.06.18-1.44.56-.38.38-.56.92-.56 1.44v1H3v20h11.2c-.13-.64-.2-1.31-.2-2H5v-6.56A4 4 0 0 0 7 18h9.01a9.48 9.48 0 0 1 2-2H7c-1.19 0-2-.81-2-2V8h22v6c0 .16 0 .3-.04.45.72.22 1.4.52 2.04.89V6h-9V5c0-.52-.18-1.06-.56-1.44A2.04 2.04 0 0 0 18 3h-4zm0 2h4v1h-4V5zm-5 7v3h2v-3H9zm12 0v2.46a10.15 10.15 0 0 1 2-.4V12h-2zm3 4a8.01 8.01 0 0 0 0 16 8.01 8.01 0 0 0 0-16zm0 2a6 6 0 1 1 .02 11.98A6 6 0 0 1 24 18zm-1 1v6h5v-2h-3v-4h-2z',
        'buy-n-large' => 'M16 4.21C7.72 4.21 1 9.5 1 16c0 6.51 6.72 11.79 15 11.79 8.28 0 15-5.28 15-11.79 0-6.51-6.72-11.79-15-11.79zM8.84 8h6.51c3.15 0 4.24 1.48 3.89 3.76l-.1.42a3.7 3.7 0 0 0-1.11-.18 4 4 0 0 0-.52 7.95l-.01.02c-.94 1.8-2.8 3-5.75 3.03H5L8.84 8zm12.51 0H26l-2.79 11H28l-1 4h-9.4l.76-3.03a3.98 3.98 0 0 0 1.83-7.33L21.35 8zm-9.36 3-.65 2.76h1.19c1 0 1.98-.79 2.18-1.69.22-.99-.47-1.07-1.53-1.07h-1.19zm4.44 2.42h1.64l.78 1.99.5-1.99h1.68l-1.16 4.9H18l-.58-1.94-.41 1.94h-2l1.41-4.9zm-5.82 3.32L9.84 20h1.38c.9 0 1.79-.18 2.12-1.54.31-1.29-.45-1.72-1.35-1.72h-1.38z',
        'buysellads' => 'm11.19 6-.22.69-5.9 18L4.61 26h7.35l.28-.22L18.13 21l1.15 4.25.22.75h7.9l-.46-1.31-6.07-18-.25-.69Zm1.47 2h6.53l5.43 16H21L17.06 9.47l-.18-.75h-1.72l-.22.72-2.66 9.28-.37 1.28h4.28l-4.9 4H7.37Zm3.3 5.1 1.35 4.9h-2.75Z',
        'calculator-solid' => 'M6 3v26h20V3Zm2 2h16v22H8Zm2 2v6h12V7Zm2 2h8v2h-8Zm-1 6v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'calendar-alt-solid' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4ZM7 7h2v1h2V7h10v1h2V7h2v2H7Zm0 4h18v14H7Zm6 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 17v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'calendar-alt' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4ZM7 7h2v1h2V7h10v1h2V7h2v2H7Zm0 4h18v14H7Zm6 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 17v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'calendar-check-solid' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm13.28 2.28L15 19.56l-2.28-2.28-1.44 1.44 3 3 .72.69.72-.7 6-6Z',
        'calendar-check' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm13.28 2.28L15 19.56l-2.28-2.28-1.44 1.44 3 3 .72.69.72-.7 6-6Z',
        'calendar-day-solid' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4ZM7 7h2v1h2V7h10v1h2V7h2v2H7Zm0 4h18v14H7Zm6 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-5 3v4h4v-4Zm-7 1v2h2v-2Zm4 0v2h2v-2Zm8 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'calendar-minus-solid' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm4 6v2h10v-2Z',
        'calendar-minus' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm4 6v2h10v-2Z',
        'calendar-plus-solid' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm8 2v4h-4v2h4v4h2v-4h4v-2h-4v-4Z',
        'calendar-plus' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm8 2v4h-4v2h4v4h2v-4h4v-2h-4v-4Z',
        'calendar-solid' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4ZM7 7h2v1h2V7h10v1h2V7h2v2H7Zm0 4h18v14H7Zm6 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 17v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'calendar-times-solid' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm6.22 2.78-1.44 1.44L14.56 19l-2.78 2.78 1.44 1.44L16 20.44l2.78 2.78 1.44-1.44L17.44 19l2.78-2.78-1.44-1.44L16 17.56Z',
        'calendar-times' => 'M9 5v1H5v22h22V6h-4V5h-2v1H11V5ZM7 8h2v1h2V8h10v1h2V8h2v2H7Zm0 4h18v14H7Zm6.22 2.78-1.44 1.44L14.56 19l-2.78 2.78 1.44 1.44L16 20.44l2.78 2.78 1.44-1.44L17.44 19l2.78-2.78-1.44-1.44L16 17.56Z',
        'calendar-week-solid' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4H9zM7 7h2v1h2V7h10v1h2V7h2v2H7V7zm0 4h18v14H7V11zm6 2v2h2v-2h-2zm4 0v2h2v-2h-2zm4 0v2h2v-2h-2zM9 17v2h2v-2H9zm4 0v2h2v-2h-2zm4 0v2h2v-2h-2zm4 0v2h2v-2h-2zM9 21v2h14v-2H9z',
        'calendar' => 'M9 4v1H5v22h22V5h-4V4h-2v1H11V4ZM7 7h2v1h2V7h10v1h2V7h2v2H7Zm0 4h18v14H7Zm6 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 17v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'camera-retro-solid' => 'm11.5 6-.31.4L10 8H9V7H5v1H3v18h26V8h-7l-1.19-1.6-.31-.4Zm1 2h7l1.19 1.6.31.4h6v4h-5.81A6.02 6.02 0 0 0 16 11a6.02 6.02 0 0 0-5.19 3H5v-4h6l.31-.4ZM23 11v2h2v-2Zm-7 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4ZM5 16h5.1a6.02 6.02 0 0 0 5.9 7 6.02 6.02 0 0 0 5.9-7H27v8H5Z',
        'camera-solid' => 'm11.5 6-.31.4L10 8H3v18h26V8h-7l-1.19-1.6-.31-.4Zm1 2h7l1.19 1.6.31.4h6v14H5V10h6l.31-.4ZM8 11a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm8 0c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Z',
        'campground-solid' => 'm10.53 4.88-.37.59S8.89 7.4 7.28 9.63c-1.61 2.21-3.65 4.72-4.84 5.56l-.5.34.06.6 1 9 .1.87H4c1.48 0 3.21.08 4.94.19l1.06.06V18h2v8.4l.9.1c2.83.25 4.97.5 4.97.5h.16l10.94-2.19.03-.78s.09-1.67.25-3.62c.16-1.96.42-4.26.69-5.1l.22-.69-.54-.4c-3.44-2.67-6.75-8.69-6.75-8.69l-.3-.62-.73.09s-6.42.89-10.65.03Zm10.94 2.18a33.2 33.2 0 0 0 5.34 7.25l-7.53 1.19c-2.46-2.37-4.98-6.1-6.34-8.28 3.87.4 7.69-.04 8.53-.16Zm-10.53.82c1.31 2.1 4.06 6.26 6.97 9.03a43.1 43.1 0 0 0-.91 8c-.67-.07-1.47-.17-3-.32V16H8v8.16a80 80 0 0 0-3.1-.13l-.84-7.69c1.62-1.3 3.34-3.46 4.85-5.53a72.16 72.16 0 0 0 2.03-2.94Zm16.84 8.34a39.7 39.7 0 0 0-.53 4c-.13 1.58-.16 2.45-.19 2.97l-8.03 1.62c.05-1.76.24-5.1.75-7.34Z',
        'canadian-maple-leaf' => 'm16 3.03-.72.72-2.19 2.22-2.18.69-.91.28.22.9 1.19 4.82-1.72-1.2L9 11l-2.22 2.22-2.94 1.31-.87.4.34.88 1.13 2.85-.32 2.37-.12 1 7 .88V25h4v4h2v-4h4v-2.1l7-.87-.13-1-.3-2.37 1.12-2.85.34-.87-.87-.4-2.94-1.32L23 11l-.69.47-1.72 1.19 1.2-4.82.21-.9-.9-.28-2.2-.7-2.18-2.21Zm0 2.85 1.88 1.87.21.06 1.54.47-1.6 6.47-.62 2.6 2.15-1.54 3.19-2.22 1.16 1.2.15.12.16.09 2.25 1-.84 2.16-.1.25.03.25.19 1.62-5.88.72-.87.13V23h-6v-1.88l-.88-.12-5.87-.72.19-1.62.03-.25-.1-.25L5.54 16l2.25-1 .16-.1.15-.12 1.16-1.19 3.19 2.22 2.15 1.53-.62-2.59-1.6-6.47 1.54-.47.21-.06Z',
        'candy-cane-solid' => 'M18 2c-2.15 0-4.18.85-5.69 2.38l-.72.71-.68.72.71.69 2.85 2.81.69.72.71-.72.7-.72A2 2 0 0 1 18 8a1.99 1.99 0 0 1 1.4 3.4L5.73 25.04l-.72.72.72.69 2.81 2.84.72.72.69-.72 13.72-13.62A8.02 8.02 0 0 0 18 2Zm0 2c.8 0 1.58.15 2.28.44l-1.06 1.78A4.07 4.07 0 0 0 18.06 6l-.62-1.97c.18-.01.37-.03.56-.03Zm-2.47.56.6 1.94a4 4 0 0 0-.97.69l-1.44-1.4a5.97 5.97 0 0 1 1.81-1.23Zm6.44.94a5.97 5.97 0 0 1 1.5 2l-1.94.69a4.06 4.06 0 0 0-.6-.88Zm2 3.94c.01.18.03.37.03.56 0 .7-.13 1.37-.34 2h-2.2c.33-.55.52-1.2.54-1.84ZM19.66 14h2.8l-.21.25L20.5 16h-2.84Zm-4.04 4h2.85l-2 2h-2.84Zm-4 4h2.82l-2 2H9.59ZM8.1 26h2.32l-1.16 1.16Z',
        'cannabis-solid' => 'M28 18.77v-2.56l-1.88-.25c-.09-.01-1.25-.12-2.57-.13 1.44-2.7 2-5.08 2-5.11l.31-1.36-1.16-.76-.07-.05-1-.65-1.04.56c-.25.14-1.8.99-3.36 2.34-.3-2.62-.97-4.82-1.25-5.53L17.48 4h-2.9l-.52 1.23a23.8 23.8 0 0 0-1.56 6.49 37.34 37.34 0 0 0-4.44-2.89l-2.1 1.65.2 1.03c.21 1.02 1.3 3.49 1.3 3.49-1.13 0-3.46.4-3.46.4v2.64s1.88 1.59 4.04 2.73l-.18.18-.94.8.28 1.07.3 1.14 1.14.34c.17.04 1.24.26 2.41.26.83 0 1.61-.1 2.33-.32l.23-.06c.2 1.2.46 2.17.51 2.35l.4 1.47H21a13.08 13.08 0 0 1-2.18-3.42l-.03-.04c.8.34 1.84.46 2.8.48l1.37-.08.54-.9.54-.91s-.46-1.09-.98-1.56c1.54-.56 3.39-1.4 4.17-2.15Zm-6.5 1.21c-.58.17-2.27.4-2.9.48 0 0 2.42 1.4 2.81 2.44l.01.03c-.02 0-.05-.01-.07 0-1.87.14-4.82-1.51-5.16-1.8.07 1.07.45 3.57 1.36 4.84l-.03.03h-1.47s-1.1-2.93-1.02-4.97c-.51.44-1.1 1-2.2 1.3a6.4 6.4 0 0 1-1.78.23 9.6 9.6 0 0 1-1.9-.2l-.02-.04s1.42-1.3 3.26-1.75c.22-.07.44-.14.66-.14a14.4 14.4 0 0 1-2.28-.58 17.63 17.63 0 0 1-4.66-2.66v-.04s.76-.04 1.34-.04c.95 0 2.5.1 4.13.7.44.14.88.29 1.25.5-.61-.53-3.64-3.06-4.54-6.87 0 0 4.4 2.27 6.69 5.9a23.87 23.87 0 0 1-.54-4.14c0-3.7 1.47-7.2 1.47-7.2h.21c.35.88 1.25 4 1.25 7.2 0 1.09-.3 3.6-.36 4.1.16-.4.77-1.6 1.6-2.86 1.6-2.44 4.92-4.21 4.92-4.21l.07.04c-.11.5-.89 3.3-2.64 6-.43.68-1.78 1.95-1.9 2.05.2-.05.91-.33 3-.45a25.5 25.5 0 0 1 3.8.07v.03c-.62.58-2.6 1.51-4.36 2.01Z',
        'capsules-solid' => 'M8.5 5A5.5 5.5 0 0 0 3 10.5v11a5.5 5.5 0 0 0 11 0v-5.1l6.05 8.34a5.5 5.5 0 0 0 7.69 1.22 5.5 5.5 0 0 0 1.21-7.69l-6.46-8.9a5.5 5.5 0 0 0-8.68-.27A5.5 5.5 0 0 0 8.5 5zm0 2a3.5 3.5 0 0 1 3.5 3.5V15H5v-4.5A3.5 3.5 0 0 1 8.5 7zm9.54 2.1c1.08 0 2.15.5 2.83 1.45l2.65 3.64-5.67 4.11-2.64-3.64a3.5 3.5 0 0 1 2.83-5.55zm6.65 6.7 2.65 3.65a3.5 3.5 0 0 1-5.67 4.11l-2.64-3.64 5.66-4.12zM5 17h7v4.5a3.5 3.5 0 0 1-7 0V17z',
        'car-alt-solid' => 'M9.5 6a3 3 0 0 0-2.88 2.13l-1.37 4.59-1.94-.66-.62 1.88 1.97.65-.63 2.13A.97.97 0 0 0 4 17v8a1 1 0 0 0 1 1h3l.34-1h15.32l.34 1h3a1 1 0 0 0 1-1v-8c0-.1 0-.2-.03-.28l-.63-2.13 1.97-.65-.62-1.88-1.94.66-1.38-4.6A3 3 0 0 0 22.5 6Zm0 2h13c.45 0 .84.3.97.72L24.75 13H7.25l1.28-4.28A1 1 0 0 1 9.5 8Zm1.5 5a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm10 0a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm-5-4a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-9.34 6h18.68l.66 2.19V23H6v-5.81Zm1.84 1a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM12 19l-1.25 3h2.16l.43-1h5.32l.43 1h2.16L20 19Z',
        'car-battery-solid' => 'M8 6v2h4V6Zm12 0v2h4V6ZM4 9v18h24V9Zm2 2h20v14H6Zm14 4v2h-2v2h2v2h2v-2h2v-2h-2v-2ZM8 17v2h6v-2Z',
        'car-crash-solid' => 'M9.5 6a3 3 0 0 0-2.88 2.13l-1.37 4.59-1.94-.66-.62 1.88 1.97.65-.63 2.13A.97.97 0 0 0 4 17v8a1 1 0 0 0 1 1h3l.66-2h5.25l9.93 1.53.16.47h3.03a1 1 0 0 0 .66-.25l.03-.03.03-.03a1 1 0 0 0 .25-.63v-.22L27.16 19H29v-2h-2.38l-2.12-4.34.88-2.94a1 1 0 0 0-.35-1.1L23.1 7.2c-.14-.1-.32-.17-.5-.19L9.56 6H9.5Zm0 2 12.63.97 1.12.84-.78 2.63a1 1 0 0 0 .06.75l1.5 3.06-6.12-2.13-.13-.06h-.12L7.22 13.1l1.31-4.37A1 1 0 0 1 9.5 8Zm-2.88 7.06 10.79 1h.06l7.62 2.69.72 5.03L14.21 22h-1.29l.43-1 4.32.63 2.59.37L19 20l-7-1-1.25 3H6v-4.81ZM8.5 16a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm12.38 2.75a1.8 1.8 0 1 0 3.4 1.22Z',
        'car-side-solid' => 'M6.6 6c-1.34 0-2.58.67-3.32 1.78L.5 11.94C.17 12.43 0 13 0 13.59v6.63a2 2 0 0 0 1.5 1.94l2.6.65a3.99 3.99 0 0 0 7.75.19h9.3c.45 1.72 2 3 3.85 3s3.4-1.28 3.84-3H30a2 2 0 0 0 2-2v-3.66a4 4 0 0 0-3.03-3.87l-5.4-1.38-3.91-4.65A3.99 3.99 0 0 0 16.59 6Zm0 2H11v4H2.87l2.07-3.1v-.03C5.3 8.32 5.92 8 6.59 8ZM13 8h3.6c.59 0 1.15.26 1.52.72L20.88 12H13ZM2 14h20.88l5.62 1.4c.9.23 1.5 1.02 1.5 1.94V21h-1.16A3.98 3.98 0 0 0 25 18a3.99 3.99 0 0 0-3.84 3h-9.32A3.98 3.98 0 0 0 8 18a3.98 3.98 0 0 0-3.78 2.78L2 20.22Zm6 6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm17 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'car-solid' => 'M9.5 6a3 3 0 0 0-2.88 2.13l-1.37 4.59-1.94-.66-.62 1.88 1.97.65-.63 2.13A.97.97 0 0 0 4 17v8a1 1 0 0 0 1 1h3l.34-1h15.32l.34 1h3a1 1 0 0 0 1-1v-8c0-.1 0-.2-.03-.28l-.63-2.13 1.97-.65-.62-1.88-1.94.66-1.38-4.6A3 3 0 0 0 22.5 6Zm0 2h13c.45 0 .84.3.97.72L24.75 13H7.25l1.28-4.28A1 1 0 0 1 9.5 8Zm-2.84 7h18.68l.66 2.19V23H6v-5.81Zm1.84 1a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM12 19l-1.25 3h2.16l.43-1h5.32l.43 1h2.16L20 19Z',
        'caret-down-solid' => 'm3.6 12 1.68 1.72 10 10 .72.69.72-.7 10-10L28.4 12Zm4.84 2h15.12L16 21.56Z',
        'caret-left-solid' => 'm20 4.6-1.72 1.68-9 9-.69.72.7.72 9 9L20 27.4Zm-2 4.84v13.12L11.44 16Z',
        'caret-right-solid' => 'M12 4.6v22.8l1.72-1.68 9-9 .69-.72-.7-.72-9-9Zm2 4.84L20.56 16 14 22.56Z',
        'caret-square-down-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm3.72 5.78-1.44 1.44 6 6 .72.69.72-.7 6-6-1.44-1.43L16 18.06Z',
        'caret-square-down' => 'M5 5v22h22V5Zm2 2h18v18H7Zm3.72 5.78-1.44 1.44 6 6 .72.69.72-.7 6-6-1.44-1.43L16 18.06Z',
        'caret-square-left-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm10.78 2.28-6 6-.69.72.7.72 6 6 1.43-1.44L13.94 16l5.28-5.28Z',
        'caret-square-left' => 'M5 5v22h22V5Zm2 2h18v18H7Zm10.78 2.28-6 6-.69.72.7.72 6 6 1.43-1.44L13.94 16l5.28-5.28Z',
        'caret-square-right-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm7.22 2.28-1.44 1.44L18.06 16l-5.28 5.28 1.44 1.44 6-6 .69-.72-.7-.72Z',
        'caret-square-right' => 'M5 5v22h22V5Zm2 2h18v18H7Zm7.22 2.28-1.44 1.44L18.06 16l-5.28 5.28 1.44 1.44 6-6 .69-.72-.7-.72Z',
        'caret-square-up-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm9 4.1-.72.68-6 6 1.44 1.44L16 13.94l5.28 5.28 1.44-1.44-6-6Z',
        'caret-square-up' => 'M5 5v22h22V5Zm2 2h18v18H7Zm9 4.1-.72.68-6 6 1.44 1.44L16 13.94l5.28 5.28 1.44-1.44-6-6Z',
        'caret-up-solid' => 'm16 8.6-.72.68-10 10L3.6 21h24.82l-1.7-1.72-10-10Zm0 2.84L23.56 19H8.44Z',
        'carrot-solid' => 'M22.88 3.16 21.75 4.8s.61.48.9 1.16c.26.6.44 1.3-.52 2.47l-.88.87c-2.95-2.5-5.94-2.62-5.94-2.62h-.56l-.31.5s-2.55 4.33-5 8.81a123.56 123.56 0 0 0-3.28 6.31c-.43.9-.76 1.68-.97 2.32-.1.31-.18.58-.22.87-.04.3-.15.7.34 1.19.5.49.9.38 1.19.34.3-.04.56-.11.88-.22.63-.21 1.4-.54 2.3-.97 1.8-.84 4.08-2.05 6.32-3.28 4.47-2.45 8.81-5 8.81-5l.5-.31v-.6s-.13-2.95-2.62-5.9l.34-.38.25-.21.25-.22c1.18-.9 2.3-.87 3.28-.63 1.13.28 1.9.88 1.9.88l1.26-1.56s-1.11-.86-2.69-1.26a6.32 6.32 0 0 0-1.06-.15l2.03-2.03-1.44-1.44-2.1 2.1a3.72 3.72 0 0 0-.21-.7c-.56-1.3-1.63-2-1.63-2ZM15.8 8.8c.66.06 2.54.34 4.78 2.6 2.25 2.26 2.53 4.13 2.6 4.78l-1.69 1c-.26-.59-.68-1.38-1.31-2.22l-1.6 1.22c.7.93 1 1.58 1.16 2a385.6 385.6 0 0 1-4.72 2.62l-.28.16A7.35 7.35 0 0 0 13.72 19l-1.63 1.16c.5.68.74 1.25.85 1.62l.03.13a94.5 94.5 0 0 1-4.13 2.12c-.61.29-1.05.45-1.5.63.18-.45.34-.89.63-1.5.8-1.73 2-3.97 3.22-6.2l1.56-2.8c.32.28.73.66 1.19 1.25l1.56-1.22a10.32 10.32 0 0 0-1.75-1.81c1.05-1.84 1.88-3.26 2.06-3.57Z',
        'cart-arrow-down-solid' => 'M4 7a1 1 0 0 0 0 2h2.22l2.62 10.5c.23.9 1.02 1.5 1.94 1.5h12.47c.9 0 1.67-.6 1.9-1.47l2.6-9.53h-2.1l-2.4 9H10.78L8.16 8.5A1.98 1.98 0 0 0 6.22 7Zm18 14c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm-9 0c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm3-14v5h-3l4 4 4-4h-3V7Zm-3 16c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm9 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'cart-plus-solid' => 'M4 7a1 1 0 0 0 0 2h2.22l2.62 10.5c.23.9 1.02 1.5 1.94 1.5h12.47c.9 0 1.67-.6 1.9-1.47l2.6-9.53h-2.1l-2.4 9H10.78L8.16 8.5A1.98 1.98 0 0 0 6.22 7Zm18 14c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm-9 0c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm3-14v3h-3v2h3v3h2v-3h3v-2h-3V7Zm-3 16c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm9 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'cash-register-solid' => 'M22 3v4c-1.85 0-3.61.33-5.27.91l-.52-1.15.9-.4-.81-1.83-3.66 1.63.82 1.82.92-.4.51 1.1c-1.1.55-2.1 1.22-3.04 1.99l-.79-.84.73-.67-1.35-1.47-2.95 2.7 1.35 1.48.75-.68.8.85a15.93 15.93 0 0 0-2.44 3.39l-1.09-.54.45-.88-1.78-.9-1.81 3.56 1.78.9.46-.9 1.14.58A15.94 15.94 0 0 0 6.05 22H4v6h24V3Zm2 2h2v17H8.05C8.56 14.73 14.6 9 22 9h2Zm-6 6.95a2 2 0 0 0-1 3.74V20h5v-2h-3v-2.32a2 2 0 0 0-1-3.73ZM6 24h20v2H6Z',
        'cat-solid' => 'M10 4c0 1.12-.88 2-2 2H7c-2.2 0-4 1.8-4 4s1.8 4 4 4h1.16c-.1.49-.16.98-.16 1.5V28h2V15.5a5.5 5.5 0 0 1 8-4.9V8.43A7.46 7.46 0 0 0 8.87 12H7c-1.12 0-2-.88-2-2s.88-2 2-2h1c2.2 0 4-1.8 4-4Zm9 2.1v6.4c0 2.55 2.32 4.5 5 4.5s5-1.95 5-4.5V6.1l-1.56 1.09-1.66 1.15c-.57-.2-1.13-.43-1.78-.43-.65 0-1.21.23-1.78.43L20.56 7.2Zm5 3.8c.58 0 1.1.15 1.56.38l.53.28.5-.34.41-.28v2.56c0 1.32-1.27 2.5-3 2.5s-3-1.18-3-2.5V9.94l.4.28.5.34.54-.28A3.4 3.4 0 0 1 24 9.91ZM17 15a5 5 0 0 0-5 5v8h2v-8a3 3 0 0 1 6 0v8h2v-8c0-.96-.27-1.86-.75-2.63a5.88 5.88 0 0 1-2.34-2A5 5 0 0 0 17 15Zm9 2.69c-.63.2-1.3.31-2 .31v10h2Z',
        'cc-amazon-pay' => 'M5 6C3.35 6 2 7.36 2 9v14c0 1.64 1.35 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3H5zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1zm6.52 2-.14.02c-.44.06-.86.22-1.22.5a.87.87 0 0 0-.22.17l-.02-.05-.04-.27c-.02-.14-.1-.21-.24-.21h-.37c-.23 0-.27.04-.27.27v6.82c0 .1.07.16.16.16h.68c.1 0 .15-.06.16-.16v-2.42l.08.06c.57.48 1.23.64 1.96.5a1.95 1.95 0 0 0 1.4-1.13c.23-.44.33-.93.33-1.42a3.6 3.6 0 0 0-.26-1.6 1.88 1.88 0 0 0-1.4-1.19l-.32-.04-.27-.01zm5 0a4.63 4.63 0 0 0-1.02.15c-.2.05-.38.12-.57.18-.12.04-.17.13-.17.25v.32c0 .15.07.2.22.15l.75-.18c.4-.07.8-.1 1.2-.04.2.04.4.1.54.27a.9.9 0 0 1 .17.53l.01.8v.04h-.05a5.72 5.72 0 0 0-1.03-.16c-.36-.01-.72 0-1.07.13-.41.14-.75.4-.95.8a1.7 1.7 0 0 0-.12.98c.07.46.29.8.69 1.02.38.22.8.24 1.22.18.49-.07.92-.28 1.3-.6l.04-.03.06.35c.02.1.08.17.18.18h.53c.07 0 .14-.08.14-.16l.01-.09v-3.41c0-.14 0-.28-.03-.41a1.27 1.27 0 0 0-.61-.98 1.91 1.91 0 0 0-.7-.23L16.9 10h-.38zm6.72 0a.25.25 0 0 0-.25.16l-.05.14-1.12 3.22-.25.71-.03-.08-1.24-3.44c-.06-.2-.13-.37-.2-.55a.21.21 0 0 0-.2-.15h-.75c-.08 0-.12.06-.1.14l.06.2 1.9 4.68c.06.13.07.24 0 .37-.1.24-.18.48-.3.72a.73.73 0 0 1-.48.43 1.4 1.4 0 0 1-.5.03l-.23-.03c-.11 0-.17.04-.17.16v.31c0 .18.06.26.24.3.17.02.35.05.54.06.55 0 .99-.22 1.27-.7.12-.19.21-.38.3-.59A1361.4 1361.4 0 0 0 24 10.14c.01-.1-.03-.14-.12-.14h-.64zm-11.72.82c.48.04.87.27 1.07.83.13.35.16.7.16 1.06 0 .34-.02.66-.13.99-.21.68-.72.95-1.36.92-.46-.03-.84-.2-1.2-.45-.04-.03-.07-.06-.06-.1v-2.72c-.01-.04.02-.08.05-.1.44-.31.93-.47 1.47-.43zM16.38 13a2 2 0 0 1 .4 0l.8.11c.06.01.08.04.08.08v.47l-.01.45c0 .04-.02.07-.05.1a2.5 2.5 0 0 1-1.2.48c-.18.01-.36.01-.54-.06a.65.65 0 0 1-.4-.43c-.06-.2-.06-.42 0-.62a.77.77 0 0 1 .52-.5c.13-.05.26-.07.4-.08zm8.15 4.5c-.7 0-1.53.16-2.15.6-.2.14-.16.33.05.3.7-.08 2.28-.27 2.56.08.28.36-.31 1.84-.58 2.5-.08.2.1.28.28.13 1.17-.98 1.47-3.04 1.23-3.34-.12-.14-.69-.28-1.39-.27zm-18.39.4c-.14.01-.2.19-.05.33A14.66 14.66 0 0 0 15.98 22c2.73 0 5.9-.86 8.1-2.47.36-.27.05-.67-.32-.51a19.68 19.68 0 0 1-17.45-1.09.27.27 0 0 0-.17-.04z',
        'cc-amex' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm2.06 5.25L5 18.75h1.25l.4-1.25H9l.4 1.25h2.35v-4.13l1.5 4.13h1.1l1.53-4v4h1.09v-5.5h-1.78l-1.38 3.72-1.37-3.72H10.5v5.22l-1.94-5.22Zm11.4 0v5.5h4.41l1.38-1.78 1.38 1.78H27L24.94 16 27 13.25h-1.5l-1.38 1.66L23 13.25Zm-10.71 1.1.69 1.93H7.06Zm11.81.15h2.75l1.13 1.5-1.25 1.66h-2.63v-1.1h2.5v-1.12h-2.5Z',
        'cc-apple-pay' => 'M5 6C3.35 6 2 7.36 2 9v14c0 1.64 1.35 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3H5zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1zm6 3c-.47 0-1 .27-1.34.65-.27.32-.56.83-.46 1.34.48.06 1-.24 1.3-.63.33-.35.52-.85.5-1.36zm2 2v6h.93v-2.05h1.3c1.17 0 2-.81 2-1.98S16.41 13 15.25 13H13zm-5.16.52c-1.04 0-1.84.91-1.84 2.22C6 17.44 7.2 19 7.94 19c.45 0 .61-.3 1.21-.3.55 0 .73.3 1.2.3.89 0 1.62-1.81 1.65-1.92-.15-.07-1-.48-1-1.45 0-.95.78-1.37.82-1.39a1.65 1.65 0 0 0-1.37-.72c-.6 0-1.12.33-1.4.33-.3 0-.73-.33-1.21-.33zm6.1.27H15c.8 0 1.27.43 1.27 1.18 0 .76-.47 1.2-1.27 1.2h-1.08v-2.38zm5.49.74c-.99 0-1.72.57-1.74 1.34h.84c.07-.36.41-.6.88-.6.57 0 .88.26.88.75v.33l-1.16.08c-1.07.06-1.66.5-1.66 1.27 0 .78.6 1.3 1.46 1.3.59 0 1.13-.3 1.37-.77h.03v.73h.86v-3c0-.86-.7-1.43-1.76-1.43zm2.14.06 1.58 4.38-.08.26c-.14.45-.38.62-.79.62h-.27v.71l.35.02c.91 0 1.34-.35 1.72-1.4l1.63-4.6h-.94l-1.1 3.55h-.02l-1.1-3.54h-.98zm-1.28 2.39v.33c0 .57-.47.97-1.1.97-.5 0-.81-.23-.81-.6 0-.38.3-.6.88-.63l1.03-.07z',
        'cc-diners-club' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm10 2c-3.3 0-6 2.7-6 6s2.7 6 6 6h2a6 6 0 0 0 0-12Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Zm-.81 1.66A2.5 2.5 0 0 0 12.5 16c0 1.09.71 2 1.69 2.34Zm1.62 0v4.68A2.5 2.5 0 0 0 17.5 16c0-1.09-.71-2-1.69-2.34Z',
        'cc-discover' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm5.44 6.16c-.63 0-1.1.45-1.1 1.03 0 .48.23.72.88.97.37.14.69.22.69.56 0 .28-.23.5-.54.5a.8.8 0 0 1-.74-.47l-.47.4c.31.47.72.7 1.25.7.71 0 1.18-.48 1.18-1.16 0-.57-.21-.84-1-1.13-.41-.15-.53-.24-.53-.44 0-.22.2-.37.5-.37a.7.7 0 0 1 .56.28l.38-.47c-.3-.26-.68-.4-1.06-.4Zm3.25 0a1.84 1.84 0 1 0 0 3.69c.3 0 .56-.08.87-.23v-.8c-.27.27-.53.37-.84.37-.7 0-1.19-.5-1.19-1.22 0-.68.51-1.19 1.16-1.19.33 0 .59.1.87.38v-.82c-.3-.15-.58-.18-.87-.18Zm2.9 0a1.85 1.85 0 0 0 0 3.68 1.85 1.85 0 0 0 0-3.68ZM5 14.22v3.53h1c1.54 0 1.9-1.2 1.9-1.75 0-1.04-.78-1.78-1.9-1.78Zm3.22 0v3.53h.69v-3.53Zm10.1 0 1.5 3.62h.37l1.53-3.62h-.75L20 16.59l-.94-2.37Zm3.71 0v3.53h1.94v-.6h-1.25v-.96h1.22v-.6h-1.22v-.78h1.25v-.6Zm2.4 0v3.53h.7v-1.4h.06l.97 1.4H27l-1.13-1.5c.52-.1.82-.46.82-1 0-.66-.46-1.03-1.25-1.03Zm.7.56h.18c.43 0 .69.19.69.53 0 .36-.25.53-.69.53h-.18Zm-19.44.03h.22c.93 0 1.28.64 1.28 1.19 0 .27-.08 1.16-1.32 1.16H5.7Z',
        'cc-jcb' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm3.16 3C6.93 11 6 11.78 6 13.13V21h3.94c.96 0 2.06-.9 2.06-2.06V11Zm7 0c-1.23 0-2.16.78-2.16 2.13v7.8h3.94c.95 0 2.06-.9 2.06-2.05V11Zm7 0c-1.23 0-2.16.78-2.16 2.13v7.8h3.9c.96 0 2.1-.9 2.1-2.05V11Zm-6.79 3h2.88v.63a8.94 8.94 0 0 0-1.69-.26c-.72 0-1.28.62-1.28 1.38 0 .76.56 1.34 1.28 1.34.33 0 1-.05 1.69-.21v.59h-2.88a1.7 1.7 0 0 1-1.65-1.72c0-.95.76-1.75 1.65-1.75Zm5.47 0h3.7c.44 0 .8.4.8.84 0 .45-.3.88-.75.88.51 0 .91.4.91.84a.9.9 0 0 1-.9.88h-3.76Zm-11.37.03h1.72v1.94c0 1.08-1.39 1.65-2.4 1.65-1.12 0-2.11-.66-2.32-1.5h.75c.09.52.58.88 1.16.88.62 0 1.09-.46 1.09-1.03Zm12.78.31v1.16h1.19c.3 0 .56-.27.56-.56 0-.3-.27-.6-.56-.6Zm0 1.6v1.15h1.22c.3 0 .56-.26.56-.56 0-.3-.26-.6-.56-.6Z',
        'cc-mastercard' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm7 1a7 7 0 0 0-7 7 7.01 7.01 0 0 0 11 5.75A7.01 7.01 0 0 0 27 16a7.01 7.01 0 0 0-11-5.75A6.93 6.93 0 0 0 12 9Zm0 2c1.28 0 2.43.5 3.31 1.28a5.92 5.92 0 0 0-.97 1.72h2.22c.14.32.28.65.35 1h-2.82a5.99 5.99 0 0 0 0 2h2.82c-.07.35-.2.68-.35 1h-2.22c.23.63.56 1.2.97 1.72A4.96 4.96 0 0 1 7 16c0-2.77 2.23-5 5-5Zm8 0c2.77 0 5 2.23 5 5a4.98 4.98 0 0 1-7.5 4.31 6.92 6.92 0 0 0 0-8.62A4.95 4.95 0 0 1 20 11Z',
        'cc-paypal' => 'm8.9 5-.18.78-3.69 17L4.75 24h4.88l-.6 2.78L8.75 28h6.97l.15-.81 1.04-4.82h2.68A7.94 7.94 0 0 0 27.5 16a5.81 5.81 0 0 0-1-5 5.49 5.49 0 0 0-2.97-1.81 5.11 5.11 0 0 0-1.28-2.47A5.81 5.81 0 0 0 18.06 5Zm1.63 2h7.53c.98 0 2.07.38 2.75 1.1.69.7 1.1 1.73.72 3.46-.66 3.1-3 4.81-5.94 4.81h-4.3l-.16.79L10.09 22H7.25Zm2.53 1.47-.19.78-1.03 4.63-.28 1.21h3.53a3.93 3.93 0 0 0 3.75-3.03h.04V12c.21-.88.07-1.77-.41-2.44a2.75 2.75 0 0 0-2.22-1.1Zm1.6 2h1.59c.31 0 .48.09.6.25.11.16.2.42.09.81v.03c-.19.81-1.15 1.53-1.85 1.53h-1.03Zm8.93.87c.53.22 1.03.51 1.38.94.58.7.9 1.68.56 3.28-.66 3.1-3 4.81-5.94 4.81h-4.3l-.16.79L14.09 26h-2.84l.44-2h.03l.15-.81 1.04-4.82h2.68A7.94 7.94 0 0 0 23.5 12c.05-.23.07-.44.1-.66Z',
        'cc-stripe' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm11.5 3.44a.84.84 0 0 0-.84.84.84.84 0 1 0 1.69 0 .84.84 0 0 0-.85-.84Zm-5.44.75-1.37.22-.19 1.21-.5.1-.19 1.12h.69v2.35c0 .6.15 1.02.47 1.28.26.21.65.31 1.19.31.41 0 .66-.08.84-.12V17.4c-.1.02-.32.06-.47.06-.32 0-.47-.16-.47-.53v-2.1h.85l.18-1.21h-1.03Zm-4.15 1.34c-.55 0-1.02.14-1.35.4-.34.28-.5.7-.5 1.2 0 .88.53 1.24 1.4 1.56.58.2.76.34.76.56 0 .21-.17.34-.5.34-.41 0-1.1-.2-1.53-.46L5 18.34a4 4 0 0 0 1.81.44 2.2 2.2 0 0 0 1.38-.37c.36-.29.56-.74.56-1.29 0-.9-.55-1.27-1.44-1.59-.47-.17-.75-.28-.75-.5 0-.18.14-.31.4-.31.5 0 1 .2 1.35.37l.19-1.21a3.7 3.7 0 0 0-1.6-.35Zm13.8 0c-.46 0-.89.22-1.27.63l-.07-.54h-1.43v6.94l1.62-.28v-1.6c.25.09.5.1.72.1.4 0 .99-.1 1.44-.6.43-.47.66-1.18.66-2.15 0-.85-.15-1.52-.47-1.94a1.42 1.42 0 0 0-1.2-.56Zm4.23 0c-1.37 0-2.22 1.03-2.22 2.66 0 .9.2 1.6.66 2.03.4.39 1 .56 1.75.56.68 0 1.31-.14 1.71-.4l-.18-1.13c-.4.21-.86.34-1.38.34a1 1 0 0 1-.69-.21c-.16-.15-.25-.36-.28-.7h2.66l.03-.55c0-.81-.19-1.46-.53-1.91a1.83 1.83 0 0 0-1.53-.69Zm-9.94.03a.99.99 0 0 0-.97.69l-.1-.63h-1.4v5.07h1.63V15.4c.2-.25.48-.35.87-.35l.28.03v-1.5a1.28 1.28 0 0 0-.31-.03Zm.69.06v5.07h1.62v-5.07Zm9.22 1c.36 0 .56.35.59 1.07h-1.19c.05-.73.23-1.06.6-1.06Zm-4.75.16c.4 0 .62.42.62 1.28 0 .5-.07.9-.22 1.16-.13.24-.33.37-.56.37a.95.95 0 0 1-.44-.09v-2.4c.28-.3.5-.32.6-.32Z',
        'cc-visa' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm14.4 4.38c-1.92 0-2.93.94-2.93 2.15 0 2.18 2.56 1.88 2.56 3 0 .2-.16.63-1.22.63s-1.75-.38-1.75-.38l-.31 1.44s.66.4 1.97.4 3.16-1 3.16-2.46c0-1.76-2.57-1.88-2.57-2.66 0-.4.34-.72 1.25-.72.6 0 1.25.47 1.25.47l.32-1.53s-.88-.35-1.72-.35Zm-8.21.12L9.5 17.44l-.13-.69c-.95-2.14-2.5-2.94-2.5-2.94l1.47 5.6h2l2.82-6.91Zm2.69 0-1.1 6.9h1.85l1.09-6.9Zm9.93 0-3 6.9h1.82l.37-.96h2.31l.19.97h1.66l-1.41-6.91Zm-18.97.03s3.6 1.1 4.44 3.81l-.62-3.12s-.28-.69-1-.69ZM24.5 14.5l.53 2.6h-1.5Z',
        'centercode' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-2.8 4c-2.35 2.26-2.82 7.59-1.4 13.87 2.83.63 6.92-1.07 11.09-4.44 1.14-4.75-6.56-8.29-9.7-9.43zm2.8 5a2 2 0 1 1 0 4 2 2 0 0 1 0-4z',
        'centos' => 'm16 3-3 3h2v6l1 1 1-1V6h2l-3-3zM7 7v4l1.3-1.3 4.29 4.3H14v-1.41l-4.3-4.3L11 7H7zm5.41 0-1.29 1.3L14 11.16V7h-1.59zM18 7v4.17l2.88-2.88L19.58 7H18zm3 0 1.3 1.3-4.3 4.29V14h1.41l4.3-4.3L25 11V7h-4zM8.3 11.12 7 12.42V14h4.17L8.3 11.12zm15.4 0L20.84 14H25v-1.59l-1.3-1.29zM6 13l-3 3 3 3v-2h6l1-1-1-1H6v-2zm20 0v2h-6l-1 1 1 1h6v2l3-3-3-3zM7 18v1.59l1.3 1.29L11.16 18H7zm5.59 0-4.3 4.3L7 21v4h4l-1.3-1.3 4.3-4.29V18h-1.41zM18 18v1.41l4.3 4.3L21 25h4v-4l-1.3 1.3-4.29-4.3H18zm2.83 0 2.88 2.88 1.29-1.3V18h-4.17zM16 19l-1 1v6h-2l3 3 3-3h-2v-6l-1-1zm-2 1.83-2.88 2.88 1.3 1.29H14v-4.17zm4 0V25h1.59l1.29-1.3L18 20.84z',
        'certificate-solid' => 'M16 3a3 3 0 0 0-1.78.6l-1.66 1.15-1.9.25h-.04l-.03.03A3.4 3.4 0 0 0 8.03 7.6L8 7.63v.03l-.25 1.93-1.16 1.5-.03.04v.03a3.27 3.27 0 0 0 .03 3.62l1.2 1.66.3 1.72-3.21 4.9-1.04 1.53h4.79l1.15 2.7.72 1.71 1.03-1.56 3.16-4.75c.85.35 1.8.38 2.62 0l3.16 4.75L21.5 29l.72-1.72 1.16-2.69h4.78l-1.04-1.53L24 18.31l.25-1.87 1.16-1.66.03-.03v-.03c.7-1.12.73-2.53-.03-3.6l-1.16-1.65-.38-1.88h.04c0-.02-.03-.04-.04-.06A2.95 2.95 0 0 0 21.34 5h-.03l-1.87-.25-1.66-1.16A3.07 3.07 0 0 0 16 3Zm0 2.03c.23 0 .46.07.63.19L18.4 6.5l.21.16.25.03 2.2.31h.02c.45.05.77.36.82.81v.07l.4 2.21.03.22.16.19 1.28 1.78c.24.33.27.9-.03 1.38l-1.4 1.96-.04.26-.31 2.18v.03a1 1 0 0 1-.16.44l-.06.03v.03a.88.88 0 0 1-.6.32h-.05l-2.29.4-.25.03-.18.16-1.79 1.28c-.33.24-.92.27-1.4-.03l-1.63-1.25-.18-.16-.29-.03-2.18-.31h-.03a.88.88 0 0 1-.7-.44.99.99 0 0 1-.12-.37v-.07l-.4-2.28-.03-.25-.16-.18-1.28-1.79c-.24-.33-.27-.92.03-1.4l1.25-1.63.16-.18.03-.29.28-2.09c0-.01.03-.01.03-.03a1.4 1.4 0 0 1 1-1c.02 0 .02-.03.03-.03l2.1-.28.24-.03.22-.16 1.79-1.28c.16-.12.39-.19.62-.19Zm6.9 15.22 1.54 2.34h-2.4l-.26.63-.69 1.6-2.12-3.26.47-.34 1.97-.34v.03c.02 0 .04-.03.06-.04.54-.07 1.03-.3 1.44-.62Zm-13.8.03c.42.38.96.65 1.56.72h.03l1.9.25.44.34-2.12 3.22-.7-1.6-.24-.62h-2.4Z',
        'chair-solid' => 'M11 4v12.44c-.1.02-.22.06-.31.1a3.72 3.72 0 0 0-1.38.71c-.08.08-.19.25-.19.25l-.12.22V20h1v8h2v-8h8v8h2v-8h1v-2.28l-.13-.22s-.1-.17-.18-.25c-.08-.08-.2-.17-.32-.25a3.96 3.96 0 0 0-1.06-.47l-.31-.1V4h-2v1h-6V4Zm2 3h2v9.03c-.76.02-1.44.04-2 .1Zm4 0h2v9.13c-.56-.06-1.24-.08-2-.1Z',
        'chalkboard-solid' => 'M5 7v16H3v2h26v-2h-2V7Zm2 2h18v14H7Zm14.28 3.28L17 16.56l-3.28-3.28-.72-.69-.72.7-3 3 1.44 1.43L13 15.44l3.28 3.28.72.69.72-.7 5-5ZM20 20l-1 1 1 1h4v-2Z',
        'chalkboard-teacher-solid' => 'M4 6v2h22v16H12v2h18v-2h-2V6H4zm4 3c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm6 1v2h5v-2h-5zm7 0v2h3v-2h-3zM8 11c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2zm6 3v2h10v-2H14zM4 18v8h2v-6h3v6h2v-5.34l2.06 1.09a2 2 0 0 0 1.88 0l3.53-1.87-.94-1.76L14 19.98l-3.1-1.63A3 3 0 0 0 9.5 18H4z',
        'charging-station-solid' => 'M9 5C7.36 5 6 6.36 6 8v19h14v-7h2v4c0 1.64 1.36 3 3 3s3-1.36 3-3V13.81c0-.8-.31-1.53-.88-2.1L22.41 7 21 8.4l2.84 2.85A3 3 0 0 0 22 14c0 1.64 1.36 3 3 3 .35 0 .68-.07 1-.19V24c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-4a2 2 0 0 0-2-2h-2V8c0-1.64-1.36-3-3-3H9zm0 2h8c.57 0 1 .43 1 1v17H8V8c0-.57.43-1 1-1zm4.09 3.56-2.43 4.88.9.47 1.1.53-1.57 3.12 1.82.88 2.43-4.88-.9-.47-1.1-.53 1.57-3.12-1.82-.88zM25 13c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1z',
        'chart-area-solid' => 'm28 4.06-1.63 1.25-4.62 3.63-5.6-.94-.37-.06-.34.22-5.69 3.78-4.56-.9L4 10.77V28h24Zm-2 4.1v5.37l-4.22 3.35-5.47-1.82-.47-.15-.4.25-5.56 3.71L6 17.32v-4.1l3.81.76.4.1.35-.23 5.66-3.78 5.62.94.44.06.34-.28Zm0 7.93V26H6v-6.5l3.63 1.44.5.18.43-.28 5.63-3.75 5.5 1.85.5.18.43-.34Z',
        'chart-bar-solid' => 'M21 4v24h8V4Zm2 2h4v20h-4ZM3 10v18h8V10Zm2 2h4v14H5Zm7 4v12h8V16Zm2 2h4v8h-4Z',
        'chart-bar' => 'M13 3v24h-2V7H5v20H3v2h26v-2h-2V14h-6v13h-2V3Zm2 2h2v22h-2Z',
        'chart-line-solid' => 'm27.22 5.38-3.5 4.37-3.28-1.66-.78-.37-.5.72-3.41 5.12-3.16-2.37-.59-.44-.6.44-3.62 2.72-3.53-.88-.5 1.94 4 1 .47.12.37-.28L12 13.25l3.4 2.56.85.63.6-.88 3.5-5.25 3.21 1.6.72.34 4.5-5.63ZM20.06 18.3l-.84 1.07-3.4 4.25-3.23-2.44-.59-.44-.6.44-3.5 2.62-3.46-1.72-.88 1.82 4 2 .53.25.5-.35L12 23.25l3.4 2.56.79.57.6-.75 3.12-3.91 3.25 4.84.78 1.13.84-1.07 4-5-1.56-1.25-3.13 3.91-3.25-4.84Z',
        'chart-pie-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm-1.13 2.06H15v11.35l.28.3 7.78 7.76A10.96 10.96 0 0 1 16 27a10.99 10.99 0 0 1-1.13-21.94Zm2.13 0c5.29.48 9.46 4.65 9.94 9.94H17ZM18.44 17h8.5c-.21 2.3-1.08 4.4-2.47 6.06Z',
        'check-circle-solid' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13a12.98 12.98 0 0 0 12.31-17.1l-1.62 1.6A10.97 10.97 0 0 1 16 27C9.9 27 5 22.1 5 16a10.97 10.97 0 0 1 18.6-7.9L25 6.68A12.72 12.72 0 0 0 16 3Zm11.28 4.28L16 18.56l-4.28-4.28-1.44 1.44 5 5 .72.69.72-.7 12-12Z',
        'check-circle' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13a12.98 12.98 0 0 0 12.31-17.1l-1.62 1.6A10.97 10.97 0 0 1 16 27C9.9 27 5 22.1 5 16a10.97 10.97 0 0 1 18.6-7.9L25 6.68A12.72 12.72 0 0 0 16 3Zm11.28 4.28L16 18.56l-4.28-4.28-1.44 1.44 5 5 .72.69.72-.7 12-12Z',
        'check-double-solid' => 'M23.28 7.28 11.5 19.06l-2.78-2.78-1.44 1.44 2.78 2.78L8 22.56l-6.28-6.28-1.44 1.44 7 7 .72.69.72-.7 2.78-2.77 2.78 2.78.72.69.72-.7 15.9-16-1.43-1.43L15 22.56l-2.06-2.06L24.72 8.72Z',
        'check-solid' => 'M28.28 6.28 11 23.56l-7.28-7.28-1.44 1.44 8 8 .72.69.72-.7 18-18Z',
        'check-square-solid' => 'M4 4v24h24V12.19l-2 2V26H6V6h19.81l2-2Zm23.28 3.28L16 18.56l-4.28-4.28-1.44 1.44 5 5 .72.69.72-.7 12-12Z',
        'check-square' => 'M5 5v22h22V5Zm2 2h18v18H7Zm14.28 4.28L14 18.56l-3.28-3.28-1.44 1.44 4 4 .72.69.72-.7 8-8Z',
        'cheese-solid' => 'm11.1 5.97-.32.06c-6.47 1.44-7.75 7.78-7.75 7.78l-.03.1V26h26v-6h-1c-.57 0-1-.43-1-1 0-.57.43-1 1-1h1v-4.66l-.63-.28-17-7Zm-.13 2.12 2.78 1.16c-.44.18-.75.44-.75.75 0 .55.9 1 2 1a2.7 2.7 0 0 0 1.75-.53L22.91 13H5.37c.6-1.48 2.1-4 5.6-4.9ZM5 15h3.1c-.06.16-.1.33-.1.5a1.5 1.5 0 0 0 3 0c0-.17-.04-.34-.1-.5H27v1.4c-1.1.45-2 1.34-2 2.6s.9 2.15 2 2.6V24H14.72A1.98 1.98 0 0 0 13 21a1.98 1.98 0 0 0-1.72 3H5Zm14.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'chess-bishop-solid' => 'M16 3a1.98 1.98 0 0 0-1.6 3.19c-.35.37-.76.82-1.18 1.34C12.17 8.81 11 10.3 11 12c0 1.14.41 2.16 1.06 3h-.16a1 1 0 0 0 .1 2h.5l-1.4 3.56-.72 1.44H8.9a1 1 0 0 0 .1 2l-1.81 2.4-.19.26V29h18v-2.34l-.19-.25L23 24a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 23 22h-1.38l-.71-1.44L19.5 17h.5a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 20 15c.63-.84 1-1.88 1-3 0-1.7-1.17-3.19-2.22-4.47-.42-.52-.83-.97-1.19-1.34A2 2 0 0 0 18 5a2 2 0 0 0-2-2Zm0 4.47c.36.37.6.6 1.22 1.34C18.17 9.98 19 11.5 19 12c0 1.68-1.3 3-2.97 3A3.02 3.02 0 0 1 13 12c0-.5.83-2.02 1.78-3.19.61-.74.86-.97 1.22-1.34ZM14.69 17h2.62l1.75 4.38.03.03v.03l.29.56h-6.75l.28-.56v-.03l.03-.04Zm-3.19 7h9l2.25 3H9.25Z',
        'chess-board-solid' => 'M7 4v3h3V4H7zm3 3v3h3V7h-3zm3 0h3V4h-3v3zm3 0v3h3V7h-3zm3 0h3V4h-3v3zm3 0v3h3V7h-3zm3 0h3V4h-3v3zm0 3v3h3v-3h-3zm0 3h-3v3h3v-3zm0 3v3h3v-3h-3zm0 3h-3v3h3v-3zm0 3v3h3v-3h-3zm0 3h-3v3h3v-3zm-3 0v-3h-3v3h3zm-3 0h-3v3h3v-3zm-3 0v-3h-3v3h3zm-3 0h-3v3h3v-3zm-3 0v-3H7v3h3zm-3 0H4v3h3v-3zm0-3v-3H4v3h3zm0-3h3v-3H7v3zm0-3v-3H4v3h3zm0-3h3v-3H7v3zm0-3V7H4v3h3zm3 3v3h3v-3h-3zm3 0h3v-3h-3v3zm3 0v3h3v-3h-3zm3 0h3v-3h-3v3zm0 3v3h3v-3h-3zm0 3h-3v3h3v-3zm-3 0v-3h-3v3h3zm-3 0h-3v3h3v-3z',
        'chess-king-solid' => 'M16 3a2 2 0 0 0-2 2c0 .36.1.7.28 1H8v2.38l.22.24L11.87 13a1 1 0 0 0 .13 2h.66l-1.57 5.56-.06.16-.65 1.28H8.9a1 1 0 0 0 .1 2l-1.81 2.4-.19.26V29h18v-2.34l-.19-.25L23 24a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 23 22h-1.38l-.65-1.28-.03-.06-.03-.1L19.34 15H20a1 1 0 0 0 .16-2l3.62-4.38.22-.24V6h-6.28A2 2 0 0 0 18 5a2 2 0 0 0-2-2Zm-5.69 5H21.7l-4.16 5h-3.06Zm4.44 7h2.5l1.78 6.28.03.1.32.62h-6.75l.3-.63.04-.09Zm-3.25 9h9l2.25 3H9.25Z',
        'chess-knight-solid' => 'M16 3c-1.77 0-2.94.98-3.4 2-.36.77-.31 1.3-.32 1.75a15.6 15.6 0 0 0-2.15 1.78A7.55 7.55 0 0 0 8 14.03c.02.97.22 1.95.6 2.94.18.5.53 1.35.84 2.31.31.96.56 2.01.56 2.72H8.9a1 1 0 0 0 .06 2L7.2 26.4l-.19.26V29h18v-2.34l-.19-.25L23 24a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 23 22h-1c0-2.26-1.4-4.34-2.72-5.94-.75-.92-1-1.08-1.5-1.56l.53-.31.28-.19c.29 0 .3.05.6.28.29.24.89.72 1.72.72.72 0 1.25-.47 1.53-.81.25-.32.38-.56.4-.6.1-.04.29-.1.54-.28.24-.17.56-.56.62-1 .06-.43-.08-.81-.25-1.19a7.68 7.68 0 0 0-1.47-1.96 8.74 8.74 0 0 0-2.9-2.1c-.1-.04-.02.02-.07-.03-.04-.05-.18-.26-.47-.47-.36-.27-1.16-.3-1.84-.37V3Zm-1 2.22V8h1c1.36 0 1.66.16 1.66.16l.15.18c.15.18.45.45.82.6a8.33 8.33 0 0 1 3.25 2.94c-.17.07-.33.13-.54.37-.27.33-.37.56-.46.69-.04.04-.03.05-.04.06-.08-.01-.14-.07-.4-.28a2.97 2.97 0 0 0-1.85-.72c-.65 0-1.02.3-1.34.5-.32.2-.57.34-.66.38l-.03.03h-.03c-.18.07-.5.09-.5.09L15 12.97v1.6l.34.27s1.2 1.05 2.38 2.5C18.9 18.8 20 20.67 20 22h-8c0-1.12-.31-2.3-.66-3.34-.34-1.05-.75-1.96-.9-2.38a6.99 6.99 0 0 1-.44-2.31 5.5 5.5 0 0 1 1.53-4.03c.65-.65 1.63-1.47 2.16-1.78l.5-.29v-.56c0-.37 0-.99.22-1.47.12-.27.3-.47.59-.62ZM11.5 24h9l2.25 3H9.25Z',
        'chess-pawn-solid' => 'M16 9c-2.2 0-4 1.8-4 4 0 1.2.56 2.27 1.4 3h-1.5a1 1 0 0 0 .1 2h.5l-1.4 3.56-.72 1.44H8.9a1 1 0 0 0-.28 1.94l-1.34 1.34-.28.31V29h18v-2.4l-.28-.32-1.34-1.34A1 1 0 0 0 23 23h-1.38l-.71-1.44L19.5 18h.5a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 20 16h-1.4c.84-.73 1.4-1.8 1.4-3 0-2.2-1.8-4-4-4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-1.31 7h2.62l1.75 4.38.03.03v.03l.29.56h-6.75l.28-.56v-.03l.03-.04Zm-3.25 7h9.12l2 2H9.44Z',
        'chess-queen-solid' => 'M16 3a2 2 0 0 0-1 3.72v1.53c0 .43-.32.75-.75.75h-2.34a.92.92 0 0 1-.75-.38A2 2 0 0 0 10 5a2 2 0 0 0-1 3.72v1.69l.28.3 2.35 2.35A1 1 0 0 0 12 15h.65l-1.57 5.56-.06.16-.65 1.28H8.9a1 1 0 0 0 .1 2l-1.81 2.4-.19.26V29h18v-2.34l-.19-.25L23 24a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 23 22h-1.38l-.65-1.28-.03-.06-.03-.1L19.34 15H20a1 1 0 0 0 .38-1.94l2.34-2.34.28-.31V8.7A2 2 0 0 0 22 5a2 2 0 0 0-1.16 3.63.92.92 0 0 1-.75.37h-2.34a.74.74 0 0 1-.75-.75V6.72A2 2 0 0 0 16 3Zm0 7.34c.48.4 1.08.66 1.75.66h1.81l-2 2h-3.12l-2-2h1.81c.67 0 1.27-.25 1.75-.66ZM14.75 15h2.5l1.78 6.28.03.1.32.62h-6.75l.3-.63.04-.09Zm-3.25 9h9l2.25 3H9.25Z',
        'chess-rook-solid' => 'M9 4v9h3.75l-.22 1h-.63a1 1 0 0 0 .1 2h.1l-1 4.56-.72 1.44H8.9a1 1 0 0 0 .1 2l-1.81 2.4-.19.26V29h18v-2.34l-.19-.25L23 24a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 23 22h-1.38l-.71-1.44-1-4.56H20a1 1 0 0 0 .88-.5 1 1 0 0 0 0-1A1 1 0 0 0 20 14h-.53l-.22-1H23V4Zm2 2h2v3h2V6h2v3h2V6h2v5H11Zm3.78 7h2.44l.22 1h-2.88Zm-.65 3h3.74l1.16 5.22.03.12.03.1.29.56h-6.75l.28-.56.03-.1.03-.12Zm-2.63 8h9l2.25 3H9.25Z',
        'chess-solid' => 'M8 4v2H4.8l1.27 6H6c-.6 0-1 .4-1 1s.4 1 1 1h.1l-1 7H5c-.6 0-1 .4-1 1 0 .32.12.58.32.75L3 24.7V27h12.1v-2.3l-1.36-2A1 1 0 0 0 14 22c0-.6-.4-1-1-1h-.1l-1.1-7h.2c.6 0 1-.4 1-1s-.4-1-1-1h-.05l1.35-6H10V4H8zm-.8 4h3.6l-.9 4H8.1l-.9-4zM19 9v6.4l.9.9-.77 4.7H19c-.6 0-1 .4-1 1 0 .32.12.58.32.75L17 24.7V27h12.1v-2.3l-1.36-2A1 1 0 0 0 28 22c0-.6-.4-1-1-1h-.13l-.77-4.7.9-.9V9h-2v2h-1V9h-2v2h-1V9h-2zm2 4h4v1.6l-1.1 1.1.9 5.3h-3.6l.9-5.3-1.1-1.1V13zM8.2 14h1.7l1 7H7.2l1-7zm-1.7 9h5l1.3 2H5.2l1.3-2zm14.1 0h4.9l1.3 2h-7.6l1.4-2z',
        'chevron-circle-down-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-5.28 7.78-1.44 1.44 6 6 .72.69.72-.7 6-6-1.44-1.43L16 18.06Z',
        'chevron-circle-left-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm1.78 4.28-6 6-.69.72.7.72 6 6 1.43-1.44L13.94 16l5.28-5.28Z',
        'chevron-circle-right-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1.78 4.28-1.44 1.44L18.06 16l-5.28 5.28 1.44 1.44 6-6 .69-.72-.7-.72Z',
        'chevron-circle-up-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 6.1-.72.68-6 6 1.44 1.44L16 13.94l5.28 5.28 1.44-1.44-6-6Z',
        'chevron-down-solid' => 'm6.9 6.6-.71.68-3.9 3.9-.7.73L16 26.3l14.4-14.4-.68-.72-3.9-3.9-.73-.7L16 15.7Zm-.03 2.84 8.41 8.37.72.69.72-.69 8.4-8.37 2.44 2.44L16 23.46 4.44 11.87Z',
        'chevron-left-solid' => 'm19.75 2.6-.72.68-12 12-.69.72.7.72 12 12 .71.69.72-.7 3.6-3.62.68-.68-.69-.72L16.38 16l7.68-7.69.69-.72-.69-.68-3.6-3.63Zm0 2.84 2.19 2.18-7.69 7.66-.72.72.72.72 7.69 7.66-2.19 2.18L9.19 16Z',
        'chevron-right-solid' => 'm12.25 2.6-.72.68-3.6 3.63-.68.68.69.72L15.62 16l-7.68 7.69-.69.72.69.68 3.6 3.63.71.69.72-.7 12-12 .69-.71-.7-.72-12-12Zm0 2.84L22.81 16 12.25 26.56l-2.19-2.18 7.69-7.66.72-.72-.72-.72-7.69-7.65Z',
        'chevron-up-solid' => 'M16 5.69 1.6 20.09l.68.72 3.9 3.9.73.7L16 16.3l9.1 9.1.71-.7 3.9-3.9.7-.72Zm0 2.84 11.56 11.6-2.43 2.43-8.41-8.37-.72-.69-.72.69-8.4 8.37-2.44-2.43Z',
        'child-solid' => 'M16 3c-2.75 0-5 2.25-5 5 0 1.57.77 2.96 1.9 3.88A6.02 6.02 0 0 0 10 17v3.4l.28.32L12 22.44V29h2v-5h4v5h2v-6.56l1.72-1.72.28-.31V17a6.02 6.02 0 0 0-2.9-5.13A4.99 4.99 0 0 0 21 8c0-2.75-2.25-5-5-5Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Zm0 8c2.22 0 4 1.78 4 4v2.56l-.44.44h-7.12l-.44-.44V17c0-2.22 1.78-4 4-4Z',
        'chrome' => 'M16 4C9.39 4 4 9.39 4 16s5.39 12 12 12 12-5.39 12-12S22.61 4 16 4zm0 2c3.9 0 7.28 2.23 8.92 5.5l-6.8-.01a4.93 4.93 0 0 0-6.1 1.52L8.45 9.46A9.97 9.97 0 0 1 16 6zm-8.37 4.52 3.39 5.87a5.01 5.01 0 0 0 4.37 4.57l-1.28 4.86a9.98 9.98 0 0 1-6.48-15.3zm17.81 2.2A10 10 0 0 1 16 26c-.19 0-.37-.02-.55-.03l3.4-5.87a5 5 0 0 0 1.75-6.05l4.84-1.33zM16 13c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3z',
        'chromecast' => 'M6 6a2 2 0 0 0-2 2v4h2V8h20v16h-8v2h8a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6zm-2 8v2a10.01 10.01 0 0 1 10 10h2c0-6.62-5.38-12-12-12zm0 4v2a6 6 0 0 1 6 6h2a8 8 0 0 0-8-8zm0 4v4h4a4 4 0 0 0-4-4z',
        'church-solid' => 'M15 3v2h-2v2h2v2.56l-3.72 3.72-.28.31v3.82l-6.5 3.71 1 1.75 1.5-.84V29h8v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v4h8v-6.97l1.5.84 1-1.75-6.5-3.71v-3.82l-.28-.3L17 9.55V7h2V5h-2V3Zm1 8.44 3 3v4.15l.5.29 3.5 2V27h-4v-2c0-1.64-1.36-3-3-3s-3 1.36-3 3v2H9v-6.13l3.5-2 .5-.28v-4.15ZM16 15a1 1 0 0 0-1 1v3h2v-3a1 1 0 0 0-1-1Z',
        'circle-notch-solid' => 'M18 4.18V6.2A10 10 0 1 1 6 16c0-4.83 3.44-8.87 8-9.8V4.18C8.34 5.14 4 10.07 4 16a12.01 12.01 0 0 0 24 0c0-5.93-4.34-10.86-10-11.82Z',
        'circle-solid' => 'M16 4a12 12 0 1 0 .02 24.02A12 12 0 0 0 16 4Zm0 1a11 11 0 1 1 0 22 11 11 0 1 1 0-22Z',
        'circle' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Z',
        'city-solid' => 'm10 3.88-7 3.5V28h26V10H17V7.38l-7-3.5zm0 2.24 5 2.5V26H5V8.62l5-2.5zM7 10v2h2v-2H7zm4 0v2h2v-2h-2zm6 2h10v14H17V12zM7 14v2h2v-2H7zm4 0v2h2v-2h-2zm8 0v2h2v-2h-2zm4 0v2h2v-2h-2zM7 18v2h2v-2H7zm4 0v2h2v-2h-2zm8 0v2h2v-2h-2zm4 0v2h2v-2h-2zM7 22v2h2v-2H7zm4 0v2h2v-2h-2zm8 0v2h2v-2h-2zm4 0v2h2v-2h-2z',
        'clinic-medical-solid' => 'M16 4.9 3.62 10.07l-.62.28V27h26V10.34l-.63-.28Zm0 2.2 11 4.59V25H5V11.69ZM15 13v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'clipboard-check-solid' => 'M16 2c-1.26 0-2.15.9-2.6 2H5v25h22V4h-8.4c-.45-1.1-1.34-2-2.6-2Zm0 2a1 1 0 0 1 1 1v1h3v2h-8V6h3V5a1 1 0 0 1 1-1ZM7 6h3v4h12V6h3v21H7Zm14.28 7.28L15 19.56l-3.28-3.28-1.44 1.44 4 4 .72.69.72-.7 7-7Z',
        'clipboard-list-solid' => 'M16 2c-1.26 0-2.15.89-2.59 2H5v25h22V4h-8.41c-.44-1.11-1.33-2-2.59-2zm0 2a1 1 0 0 1 1 1v1h3v2h-8V6h3V5a1 1 0 0 1 1-1zM7 6h3v4h12V6h3v21H7V6zm2 7v2h2v-2H9zm4 0v2h10v-2H13zm-4 4v2h2v-2H9zm4 0v2h10v-2H13zm-4 4v2h2v-2H9zm4 0v2h10v-2H13z',
        'clipboard-solid' => 'M15 3c-1.26 0-2.15.9-2.6 2H5v23h8v2h14V14h-2V5h-7.4c-.45-1.1-1.34-2-2.6-2Zm0 2a1 1 0 0 1 1 1v1h3v2h-8V7h3V6a1 1 0 0 1 1-1ZM7 7h2v4h12V7h2v7H13v12H7Zm8 9h10v12H15Z',
        'clipboard' => 'M16 3c-1.26 0-2.15.9-2.6 2H6v23h20V5h-7.4c-.45-1.1-1.34-2-2.6-2Zm0 2a1 1 0 0 1 1 1v1h3v2h-8V7h3V6a1 1 0 0 1 1-1ZM8 7h2v4h12V7h2v19H8Z',
        'clock-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-1 2v9h7v-2h-5V8Z',
        'clock' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-1 2v9h7v-2h-5V8Z',
        'clone-solid' => 'M9 4a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 4 15v5.63l2 1V28h6v-6.38l2-1V19h-2v.38l-2 1V26H8v-5.63l-2-1V15c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 9 4Zm14 0a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 18 15v5.63l2 1V28h6v-6.38l2-1V15c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 23 4ZM9 6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm14 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm0 6c1.67 0 3 1.33 3 3v4.38l-2 1V26h-2v-5.63l-2-1V15c0-1.67 1.33-3 3-3Zm-8 2.19V16h-4v2h4v1.81L17.81 17Z',
        'clone' => 'M5 5v17h4v-2H7V7h13v2h2V5H5zm5 5v17h17V10H10zm2 2h13v13H12V12z',
        'closed-captioning-solid' => 'M2 6v17.9h28V6Zm2 2h24v13.9H4Zm8 2c-2.75 0-5 2.25-5 5s2.25 5 5 5c1.2 0 2.28-.44 3.13-1.13l-1.26-1.56A2.97 2.97 0 0 1 9 15a2.99 2.99 0 0 1 4.88-2.31l1.24-1.56A4.97 4.97 0 0 0 12 10Zm10 0c-2.75 0-5 2.25-5 5s2.25 5 5 5c1.2 0 2.28-.44 3.13-1.13l-1.25-1.56A2.97 2.97 0 0 1 19 15a2.99 2.99 0 0 1 4.88-2.31l1.25-1.56A4.97 4.97 0 0 0 22 10Z',
        'closed-captioning' => 'M2 6v17.9h28V6Zm2 2h24v13.9H4Zm8 2c-2.75 0-5 2.25-5 5s2.25 5 5 5c1.2 0 2.28-.44 3.13-1.13l-1.26-1.56A2.97 2.97 0 0 1 9 15a2.99 2.99 0 0 1 4.88-2.31l1.24-1.56A4.97 4.97 0 0 0 12 10Zm10 0c-2.75 0-5 2.25-5 5s2.25 5 5 5c1.2 0 2.28-.44 3.13-1.13l-1.25-1.56A2.97 2.97 0 0 1 19 15a2.99 2.99 0 0 1 4.88-2.31l1.25-1.56A4.97 4.97 0 0 0 22 10Z',
        'cloud-download-alt-solid' => 'M16 6a8.87 8.87 0 0 0-6.6 3.06C9.28 9.05 9.16 9 9 9c-2.2 0-4 1.8-4 4a5.9 5.9 0 0 0-3 5c0 3.3 2.7 6 6 6h5v-2H8a4 4 0 0 1-1.56-7.69l.69-.28-.1-.75L7 13a1.98 1.98 0 0 1 2.47-1.94l.62.16.38-.5a7 7 0 0 1 12.31 2.56l.19.78.84-.03c.21-.01.26-.03.19-.03 2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4h-5v2h5c3.3 0 6-2.7 6-6a5.96 5.96 0 0 0-5.6-5.9A8.93 8.93 0 0 0 16 6Zm-1 12v8h-3l4 4 4-4h-3v-8Z',
        'cloud-meatball-solid' => 'M16 4a7.02 7.02 0 0 0-6.78 5.34 5.11 5.11 0 0 0-2.81 2.7A5.97 5.97 0 0 0 0 18a6 6 0 0 0 6 6h3v-2H6a4 4 0 1 1 .88-7.9l1 .21.18-.97a3.04 3.04 0 0 1 2.25-2.25l.66-.15.1-.66a4.99 4.99 0 0 1 9.4-1.53l.37.78.85-.28c.47-.16.9-.25 1.31-.25a4 4 0 0 1 4 4v.13l-.03.18-.06.72.65.28A4.01 4.01 0 0 1 26 22h-2v2h2a6 6 0 0 0 3-11.19 6.02 6.02 0 0 0-7.19-5.69A6.94 6.94 0 0 0 16 4zm5 9c-.64 0-1.15.52-1.15 1.15l.02.12a1.14 1.14 0 0 0-1.53.07 1.14 1.14 0 0 0-.07 1.53l-.12-.02a1.15 1.15 0 1 0 0 2.3l.12-.02c-.36.45-.35 1.11.07 1.53.42.42 1.08.43 1.53.07l-.02.12a1.15 1.15 0 1 0 2.3 0l-.02-.12c.45.36 1.11.35 1.53-.07.42-.42.43-1.08.07-1.53l.12.02a1.15 1.15 0 1 0 0-2.3l-.12.02c.36-.45.35-1.11-.07-1.53a1.14 1.14 0 0 0-1.53-.07l.02-.12c0-.63-.51-1.15-1.15-1.15zm-9 2a1 1 0 0 0-1 1 1 1 0 0 0 0 2 1 1 0 0 0 1 1 1 1 0 0 0 1-1 1 1 0 0 0 0-2 1 1 0 0 0-1-1zm3 6c-.64 0-1.15.52-1.15 1.15l.02.12a1.14 1.14 0 0 0-1.53.07 1.14 1.14 0 0 0-.07 1.53l-.12-.02a1.15 1.15 0 1 0 0 2.3l.12-.02c-.36.45-.35 1.11.07 1.53.42.42 1.08.43 1.53.07l-.02.12a1.15 1.15 0 1 0 2.3 0l-.02-.12c.45.36 1.11.35 1.53-.07.42-.42.43-1.08.07-1.53l.12.02a1.15 1.15 0 1 0 0-2.3l-.12.02c.36-.45.35-1.11-.07-1.53a1.14 1.14 0 0 0-1.53-.07l.02-.12c0-.63-.51-1.15-1.15-1.15z',
        'cloud-moon-rain-solid' => 'm10.4 5.94-1.65.03a7 7 0 0 0-4.06 12.5A5 5 0 0 0 9 26h1.16c.18-.63.5-1.32.87-2H9a3 3 0 0 1 0-6h1v-1c0-1.1.9-2 1.9-2l1 .06.2-.84a4 4 0 0 1 7.59-.78l.28.69.9-.1c.05 0 .08-.03.13-.03a3 3 0 0 1 3 2.94l-.03.97.78.19A3 3 0 0 1 25 24h-1a4 4 0 0 1-.56 2H25a5 5 0 0 0 1.97-9.6 5.02 5.02 0 0 0-4.78-4.4 5.97 5.97 0 0 0-10.57.34A3.65 3.65 0 0 1 9.7 7.41l.72-1.47zM7.5 8.3c-.03.23-.16.42-.16.66 0 1.95 1 3.66 2.5 4.69a4.07 4.07 0 0 0-1.75 2.43c-.77.14-1.46.46-2.06.91A5.03 5.03 0 0 1 4 12.97 4.88 4.88 0 0 1 7.5 8.3zM20 20s-2 2.9-2 4 .9 2 2 2c.14 0 .28 0 .4-.03A2 2 0 0 0 22 24c0-1.1-2-4-2-4zm-6 3-.63 1c-.12.2-.24.36-.37.6-.18.3-.34.61-.5.93l-.22.47c-.16.39-.28.75-.28 1a2 2 0 1 0 4 0c0-.25-.12-.61-.28-1-.02-.03-.02-.06-.03-.1l-.19-.37a17.7 17.7 0 0 0-.87-1.53L14 23z',
        'cloud-moon-solid' => 'm10.4 5.94-1.65.03a6.99 6.99 0 0 0-4.06 12.5A5 5 0 0 0 9 26h16a5 5 0 0 0 1.97-9.6 5.02 5.02 0 0 0-4.78-4.4 5.97 5.97 0 0 0-10.57.34A3.65 3.65 0 0 1 9.7 7.41ZM7.5 8.3c-.03.23-.16.42-.16.66 0 1.95 1 3.66 2.5 4.69a4.07 4.07 0 0 0-1.75 2.43c-.77.14-1.46.46-2.06.91A5.02 5.02 0 0 1 4 12.97 4.88 4.88 0 0 1 7.5 8.3ZM17 11c1.6 0 3.05.96 3.69 2.44l.28.69.9-.1c.05 0 .08-.03.13-.03a3 3 0 0 1 3 2.94l-.03.97.78.18A3 3 0 0 1 25 24H9a3 3 0 0 1 0-6h1v-1c0-1.1.9-2 1.9-2l1 .06.2-.84A4 4 0 0 1 17 11Z',
        'cloud-rain-solid' => 'M16 4a7.03 7.03 0 0 0-6.78 5.34 5.11 5.11 0 0 0-2.81 2.7A5.97 5.97 0 0 0 0 18a6 6 0 0 0 6 6h2l1-2H6a4 4 0 1 1 .88-7.9l1 .21.18-.97a3.03 3.03 0 0 1 2.25-2.25l.66-.15.1-.66a4.99 4.99 0 0 1 9.4-1.53l.37.78.85-.28c.47-.16.9-.25 1.31-.25a4 4 0 0 1 4 4v.13l-.03.18-.06.72.65.28A4.01 4.01 0 0 1 26 22h-2l1 2h1a6 6 0 0 0 3-11.19 6.02 6.02 0 0 0-7.19-5.69A6.94 6.94 0 0 0 16 4Zm2 10s-2 2.9-2 4a2 2 0 1 0 4 0c0-1.1-2-4-2-4Zm-5 5s-2 2.9-2 4a2 2 0 1 0 4 0c0-1.1-2-4-2-4Zm8 3s-2 2.9-2 4a2 2 0 1 0 4 0c0-1.1-2-4-2-4Z',
        'cloud-showers-heavy-solid' => 'M16 5a6.95 6.95 0 0 0-6.75 5.5 4.78 4.78 0 0 0-2.66 2.56C6.4 13.04 6.21 13 6 13c-3.3 0-6 2.7-6 6v.19a5.97 5.97 0 0 0 4.84 5.68L6.75 23H6a3.99 3.99 0 0 1-4-3.88V19a3.99 3.99 0 0 1 4.88-3.9l1 .21.18-.97a3.02 3.02 0 0 1 2.25-2.25l.66-.15.1-.69a5 5 0 0 1 9.4-1.5l.37.78.85-.28c.43-.15.86-.25 1.31-.25a3.99 3.99 0 0 1 3.97 4.31l-.06.72.65.28A4 4 0 0 1 26 23h-.69l-2.03 2H26c3.3 0 6-2.7 6-6a5.9 5.9 0 0 0-3-5c0-3.3-2.7-6-6-6-.43 0-.8.13-1.19.22A6.93 6.93 0 0 0 16 5Zm-2.4 14.1-9.66 9.5 1.4 1.4L15 20.5Zm5 0-9.66 9.5 1.4 1.4L20 20.5Zm5 0-9.66 9.5 1.4 1.4L25 20.5Z',
        'cloud-solid' => 'M16 7a8.87 8.87 0 0 0-6.6 3.06c-.13-.01-.25-.06-.4-.06-2.2 0-4 1.8-4 4a5.9 5.9 0 0 0-3 5c0 3.3 2.7 6 6 6h16c3.3 0 6-2.7 6-6a5.96 5.96 0 0 0-5.6-5.9A8.93 8.93 0 0 0 16 7Zm0 2a7 7 0 0 1 6.78 5.28l.19.78.84-.03c.21-.01.26-.03.19-.03 2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4H8a4 4 0 0 1-1.56-7.69l.69-.28-.1-.75L7 14a1.98 1.98 0 0 1 2.47-1.94l.62.16.38-.5A7 7 0 0 1 16 9Z',
        'cloud-sun-rain-solid' => 'M7 6v3.1a5 5 0 0 0-1.75.74L3.06 7.63 1.62 9.05l2.22 2.19A5 5 0 0 0 3.1 13H0v2h3.1c.13.64.4 1.23.74 1.75l-2.21 2.19 1.43 1.43 2.19-2.21c.3.2.63.36.97.5A5 5 0 0 0 6 20a5 5 0 0 0 5 5h1.16c.18-.63.5-1.32.87-2H11a3 3 0 0 1 0-6h1v-1c0-1.1.9-2 1.9-2l1 .06.2-.84a4 4 0 0 1 7.59-.78l.28.69.9-.1c.05 0 .08-.03.13-.03a3 3 0 0 1 3 2.94l-.03.97.78.18A3 3 0 0 1 27 23h-1a4 4 0 0 1-.56 2H27a5 5 0 0 0 1.97-9.6 5.02 5.02 0 0 0-4.78-4.4A5.97 5.97 0 0 0 19 8a6.04 6.04 0 0 0-5.69 4.06c-.23.04-.44.08-.65.16-.14-.35-.3-.67-.5-.97l2.21-2.19-1.43-1.44-2.19 2.22A4.96 4.96 0 0 0 9 9.1V6Zm1 5a2.99 2.99 0 0 1 2.94 2.44 4.1 4.1 0 0 0-.85 1.65 4.9 4.9 0 0 0-2.96 1.79A2.99 2.99 0 0 1 5 14c0-1.67 1.33-3 3-3Zm14 8s-2 2.9-2 4 .9 2 2 2a2 2 0 0 0 .4-.03A2 2 0 0 0 24 23c0-1.1-2-4-2-4Zm-6 3-.63 1c-.12.2-.24.36-.37.6-.18.3-.34.61-.5.93l-.22.47c-.16.39-.28.75-.28 1a2 2 0 1 0 4 0c0-.25-.12-.61-.28-1-.02-.03-.02-.06-.03-.1l-.19-.37c-.27-.55-.59-1.07-.88-1.53L16 22Z',
        'cloud-sun-solid' => 'M9 6v3.1a5 5 0 0 0-1.75.74L5.06 7.63 3.63 9.05l2.21 2.19A5 5 0 0 0 5.1 13H2v2h3.13a5 5 0 0 0 .71 1.72l-2.21 2.22.62.62C4.11 20.02 4 20.5 4 21a5 5 0 0 0 5 5h16a5 5 0 0 0 1.97-9.6 5.02 5.02 0 0 0-4.78-4.4 5.97 5.97 0 0 0-5.85-2.97l-1.4-1.4-2.19 2.21A5.2 5.2 0 0 0 11 9.13V6Zm1 5c.77 0 1.45.29 1.97.75-.26.4-.5.85-.66 1.31A4.02 4.02 0 0 0 8.1 16.1l-.15.04A2.95 2.95 0 0 1 10 11Zm7 0c1.6 0 3.05.96 3.69 2.44l.28.69.9-.1c.05 0 .08-.03.13-.03a3 3 0 0 1 3 2.94l-.03.97.78.18A3 3 0 0 1 25 24H9a3 3 0 0 1 0-6h1v-1c0-1.1.9-2 1.9-2l1 .06.2-.84A4 4 0 0 1 17 11Z',
        'cloud-upload-alt-solid' => 'M16 7a8.87 8.87 0 0 0-6.6 3.06c-.13-.01-.25-.06-.4-.06-2.2 0-4 1.8-4 4a5.9 5.9 0 0 0-3 5c0 3.3 2.7 6 6 6h5v-2H8a4 4 0 0 1-1.56-7.69l.69-.28-.1-.75L7 14a1.98 1.98 0 0 1 2.47-1.94l.62.16.38-.5a7 7 0 0 1 12.31 2.56l.19.78.84-.03c.21-.01.26-.03.19-.03 2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4h-5v2h5c3.3 0 6-2.7 6-6a5.96 5.96 0 0 0-5.6-5.9A8.93 8.93 0 0 0 16 7Zm0 8-4 4h3v8h2v-8h3Z',
        'cloudscale' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm0 4a7 7 0 0 0-6.97 7.67 4.98 4.98 0 0 1 8.35-3.33l-.87.73a2 2 0 1 0 1.41 1.41l3.93-4.63a.5.5 0 0 0-.35-.85.5.5 0 0 0-.35.15l-.62.52A6.97 6.97 0 0 0 16 9z',
        'cloudsmith' => 'M18.85 3c-2.4 0-4.56 1.95-4.56 4.35 0 2.41-1.53 3.94-3.94 3.94-2.4 0-4.35 2.15-4.35 4.56C6 18.26 7.95 20 10.35 20c2.41 0 4.36-1.73 4.36-4.14a4 4 0 0 1 4.14-4.15c2.4 0 4.15-1.95 4.15-4.36C23 4.95 21.25 3 18.85 3zm.66 17a4.5 4.5 0 1 0-.01 9 4.5 4.5 0 0 0 0-9z',
        'cloudversify' => 'M20.28 7c-.88-.01-1.7.1-2.4.3-2.87.86-4.21 2.63-4.97 5.43-.38.13-1.32.44-2.25 1.19-.2.15-.44.37-.7.6.02.05.04.1.04.16v1.82a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5V16h-.5a.5.5 0 0 0-.5.5v1.99c0 .28.22.5.5.5h1.83c.1 0 .2-.03.29-.07l.08.36c.6 3.16 3.45 5.3 7.22 5.1 2.56 2.14 6.84 2.26 9.32-.27a6.48 6.48 0 0 0 6.58-4.93c.75-3.1-.9-6.56-4.6-7.68-1.24-3.26-4.32-4.45-6.94-4.5zM9.5 8a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm-9 2a.5.5 0 0 0-.5.5v1c0 .28.23.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm4 0a.5.5 0 0 0-.5.5v2.99c0 .27.22.5.5.5h3a.5.5 0 0 0 .5-.5V10.5a.5.5 0 0 0-.5-.5h-3zm16.32 0c.3 0 .62.02.95.06 3.66.47 7 4.16 3.56 7.57a4.22 4.22 0 0 0 2.48-3.86l.55.98c.62 1.11.8 2.4.5 3.62a5.28 5.28 0 0 1-4.2 3.85c-1.67.31-4.35-.23-4.8-2.95-.56 2.32 1.13 3.62 2.9 4.34-5.63 1.7-9-2.47-7.1-5.48-1.74 1.08-1.78 3.48-1.54 4.58-.94-.62-2.83-1.63-3.01-4.02-.16-2 1.13-3.8 2.99-4.72 1.6-.8 5.43-.59 7 1.89-.73-2.41-2.8-3.36-5.32-3.6C17.19 10.92 18.7 10 20.82 10zM1.5 15a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1z',
        'cocktail-solid' => 'M8.5 4a5.5 5.5 0 0 0 0 11c.81 0 1.58-.2 2.28-.53L16 21.34V27h-4v2h10v-2h-4v-5.66l8.81-11.62.19-.28V8H13.75c-.6-2.32-2.77-4-5.25-4Zm0 2c1.4 0 2.59.84 3.13 2H7v1.44l.19.28 2.34 3.1A3.46 3.46 0 0 1 5 9.5a3.47 3.47 0 0 1 3.5-3.51Zm1.44 4h14.12l-1.5 2H13.5l1.5 2h6.03L17 19.34Z',
        'code-branch-solid' => 'M11 4a2.99 2.99 0 0 0-1 5.81V22.2c-1.16.4-2 1.5-2 2.8 0 1.64 1.36 3 3 3s3-1.36 3-3a3 3 0 0 0-1.94-2.78 2.91 2.91 0 0 1 1.38-2.34c.9-.61 2.27-.97 3.78-1.32 1.5-.35 3.12-.7 4.47-1.65a5.52 5.52 0 0 0 2.28-4.1A3 3 0 0 0 26 10c0-1.64-1.36-3-3-3s-3 1.36-3 3a3 3 0 0 0 1.97 2.78 3.11 3.11 0 0 1-1.4 2.5c-.9.63-2.3 1-3.79 1.35-1.5.34-3.12.64-4.47 1.56l-.31.25V9.8c1.16-.4 2-1.5 2-2.8 0-1.64-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm12 3c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1ZM11 24c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'code-solid' => 'm18 5-6 22h2l6-22ZM7.94 6.4l-6.75 9-.44.6.44.6 6.75 9 1.62-1.2L3.25 16l6.31-8.4Zm16.12 0-1.62 1.2 6.31 8.4-6.31 8.4 1.62 1.2 6.75-9 .44-.6-.44-.6Z',
        'codepen' => 'm16 2.84-.56.38-12 8.03-.44.28v8.94l.44.28 12 8.03.56.38.56-.38 12-8.03.44-.28v-8.94l-.44-.28-12-8.03Zm-1 3.07v5.43l-5.16 3.47-4.03-2.72Zm2 0 9.19 6.18-4.03 2.72L17 11.34Zm-1 7.18L20.34 16 16 18.9 11.66 16Zm-11 .85L8.06 16 5 18.06Zm22 0v4.12L23.94 16ZM9.87 17.19 15 20.66v5.43l-9.19-6.18Zm12.26 0 4.06 2.72L17 26.09v-5.43Z',
        'codiepie' => 'M16.04 3a13 13 0 1 0 0 26c5.44 0 9.98-3.34 11.92-8.07L17.12 16l10.54-5.8A12.98 12.98 0 0 0 16.04 3zm0 2c3.54 0 6.77 1.67 8.83 4.45l-3.58 1.97a7 7 0 1 0 .28 8.8l3.66 1.66A10.83 10.83 0 0 1 16.04 27a11.01 11.01 0 0 1 0-22zM24 13v5h2v-2h.5a1.5 1.5 0 0 0 0-3H24z',
        'coffee-solid' => 'M11 3v4h2V3Zm4 1v3h2V4ZM4.87 8 5 9.1l1.81 17.2a3.03 3.03 0 0 0 3 2.69h9.38a3.03 3.03 0 0 0 3-2.69l.47-4.31H25c1.64 0 3-1.36 3-3v-3c0-1.64-1.36-3-3-3h-1.4l.4-3.9.13-1.1Zm2.25 2h14.75L20.2 26.1a1 1 0 0 1-1 .9H9.8a1 1 0 0 1-1-.9Zm16.25 5H25c.57 0 1 .43 1 1v3c0 .57-.43 1-1 1h-2.16Z',
        'cog-solid' => 'm13.19 3-.16.81-.6 2.97c-.95.38-1.8.9-2.59 1.53l-2.9-1-.78-.25-.41.72-2 3.44-.4.72.59.53 2.25 1.97C6.1 14.94 6 15.46 6 16s.1 1.05.19 1.56l-2.25 1.97-.6.53.41.72 2 3.44.4.72.79-.25 2.9-1a9.94 9.94 0 0 0 2.6 1.53l.6 2.97.15.81h5.62l.16-.81.6-2.97c.95-.38 1.8-.9 2.59-1.53l2.9 1 .78.25.41-.72 2-3.44.4-.72-.59-.53-2.25-1.97c.08-.5.19-1.02.19-1.56s-.1-1.05-.19-1.56l2.25-1.97.6-.53-.41-.72-2-3.44-.4-.72-.79.25-2.9 1a9.94 9.94 0 0 0-2.6-1.53l-.6-2.97-.15-.81Zm1.62 2h2.38l.5 2.6.12.59.57.19c1.13.35 2.16.95 3.03 1.74l.43.41.57-.19 2.53-.87 1.18 2.03-2 1.78-.46.38.15.59a7.9 7.9 0 0 1 0 3.5l-.12.6.43.37 2 1.78-1.18 2.03-2.53-.87-.57-.2-.43.41c-.87.8-1.9 1.4-3.04 1.75l-.56.2-.12.59-.5 2.59H14.8l-.5-2.6-.12-.59-.56-.18a8.02 8.02 0 0 1-3.04-1.75l-.43-.41-.57.19-2.53.87-1.18-2.03 2-1.78.46-.38-.15-.59a7.9 7.9 0 0 1 0-3.5l.15-.6-.46-.37-2-1.78 1.18-2.03 2.53.87.57.2.43-.41c.87-.8 1.9-1.4 3.04-1.76l.56-.18.12-.6ZM16 11c-2.75 0-5 2.25-5 5s2.25 5 5 5 5-2.25 5-5-2.25-5-5-5Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Z',
        'cogs-solid' => 'M15 4v1.13a4.9 4.9 0 0 0-1.84.71l-.79-.78-1.43 1.4.81.82c-.34.52-.59 1.1-.72 1.72H10v2h1.03c.13.62.38 1.2.72 1.72l-.81.81 1.44 1.4.78-.77a4.9 4.9 0 0 0 1.84.71V16h2v-1.13a4.9 4.9 0 0 0 1.69-.68l.75.75 1.4-1.4-.75-.76c.36-.53.62-1.13.75-1.78H22V9h-1.16a4.94 4.94 0 0 0-.75-1.78l.75-.75-1.4-1.4-.75.74A4.9 4.9 0 0 0 17 5.13V4Zm.94 3c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3ZM8 16v1.1c-.67.12-1.3.37-1.84.74l-.79-.78-1.43 1.4.81.82c-.34.52-.59 1.1-.72 1.72H3v2h1.03c.13.63.38 1.2.72 1.72l-.81.81 1.44 1.4.78-.77a4.9 4.9 0 0 0 1.84.75V28h2v-1.13a4.9 4.9 0 0 0 1.69-.68l.75.75 1.4-1.4-.75-.76c.36-.52.62-1.11.75-1.75l1.2-.03-.07-2-1.13.03a4.93 4.93 0 0 0-.75-1.81l.75-.75-1.4-1.4-.75.74a4.9 4.9 0 0 0-1.69-.68V16Zm14 0v1.13a4.9 4.9 0 0 0-1.84.71l-.79-.78-1.43 1.4.81.82c-.34.52-.59 1.1-.72 1.72H17v2h1.03c.13.62.38 1.2.72 1.72l-.81.81 1.43 1.4.79-.77a4.9 4.9 0 0 0 1.84.71V28h2v-1.13a5 5 0 0 0 1.66-.71l.78.78 1.4-1.4-.75-.76c.36-.52.62-1.1.75-1.75l1.2-.03-.07-2-1.13.03a4.93 4.93 0 0 0-.78-1.78l.78-.78-1.4-1.4-.78.77a5.04 5.04 0 0 0-1.66-.68V16ZM8.94 19c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Zm14 0c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Z',
        'coins-solid' => 'M21 4c-1.8 0-3.42.34-4.69.97C15.04 5.6 14 6.63 14 8v4c0 .13.04.25.06.38-.93-.25-1.96-.38-3.06-.38-1.8 0-3.42.34-4.69.97C5.04 13.6 4 14.63 4 16v8c0 1.37 1.04 2.4 2.31 3.03 1.27.63 2.9.97 4.69.97 1.8 0 3.42-.34 4.69-.97C16.96 26.4 18 25.37 18 24v-.4a11.72 11.72 0 0 0 7.69-.57C26.96 22.4 28 21.37 28 20V8c0-1.37-1.04-2.4-2.31-3.03C24.42 4.34 22.79 4 21 4Zm0 2a8.8 8.8 0 0 1 3.78.78c.9.45 1.22.93 1.22 1.22 0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 21 10a8.75 8.75 0 0 1-3.78-.78C16.32 8.77 16 8.29 16 8c0-.29.32-.77 1.22-1.22A8.8 8.8 0 0 1 21 6Zm-5 4.84.31.2c1.27.62 2.9.96 4.69.96 1.8 0 3.42-.34 4.69-.97l.31-.19V12c0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 21 14a8.75 8.75 0 0 1-3.78-.78c-.9-.45-1.22-.93-1.22-1.22ZM11 14a8.8 8.8 0 0 1 3.78.78c.9.45 1.22.93 1.22 1.22 0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 11 18a8.75 8.75 0 0 1-3.78-.78C6.32 16.77 6 16.29 6 16c0-.29.32-.77 1.22-1.22A8.8 8.8 0 0 1 11 14Zm15 .84V16c0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 21 18a9.5 9.5 0 0 1-3-.47V16c0-.13-.04-.25-.06-.38.93.25 1.96.38 3.06.38 1.8 0 3.42-.34 4.69-.97l.31-.19Zm-20 4 .31.2c1.27.62 2.9.96 4.69.96 1.8 0 3.42-.34 4.69-.97l.31-.19V20c0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 11 22a8.75 8.75 0 0 1-3.78-.78C6.32 20.77 6 20.29 6 20Zm20 0V20c0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 21 22a9.66 9.66 0 0 1-3-.44v-1.93c.92.24 1.92.37 3 .37 1.8 0 3.42-.34 4.69-.97l.31-.19Zm-20 4 .31.2c1.27.62 2.9.96 4.69.96 1.8 0 3.42-.34 4.69-.97l.31-.19V24c0 .29-.32.77-1.22 1.22A8.8 8.8 0 0 1 11 26a8.75 8.75 0 0 1-3.78-.78C6.32 24.77 6 24.29 6 24Z',
        'columns-solid' => 'M5 5v22h22V5Zm2 2h8v18H7Zm10 0h8v18h-8Z',
        'comment-alt-solid' => 'M3 5v18h5v5.08L14.35 23H29V5Zm2 2h22v14H13.65L10 23.92V21H5Z',
        'comment-alt' => 'M3 5v18h5v5.08L14.35 23H29V5Zm2 2h22v14H13.65L10 23.92V21H5Z',
        'comment-dollar-solid' => 'M3 6v20h9.59L16 29.41 19.41 26H29V6H3zm2 2h22v16h-8.41L16 26.59 13.41 24H5V8zm10 2v1.19A3 3 0 0 0 13 14c0 1.65 1.36 3 3 3 .57 0 1 .44 1 1 0 .57-.43 1-1 1-.57 0-1-.43-1-1h-2c0 1.3.84 2.4 2 2.81V22h2v-1.19A3 3 0 0 0 19 18c0-1.65-1.36-3-3-3-.57 0-1-.44-1-1 0-.57.43-1 1-1 .57 0 1 .43 1 1h2c0-1.3-.84-2.4-2-2.81V10h-2z',
        'comment-dots-solid' => 'M3 5v18h5v5.08L14.35 23H29V5Zm2 2h22v14H13.65L10 23.92V21H5Zm5 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'comment-dots' => 'M3 5v18h5v5.08L14.35 23H29V5Zm2 2h22v14H13.65L10 23.92V21H5Zm5 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'comment-medical-solid' => 'M3 6v20h9.59L16 29.41 19.41 26H29V6H3zm2 2h22v16h-8.41L16 26.59 13.41 24H5V8zm10 3v4h-4v2h4v4h2v-4h4v-2h-4v-4h-2z',
        'comment-slash-solid' => 'M3.7 2.3 2.3 3.7l26 26 1.4-1.4-2.29-2.3H29V6H7.41l-3.7-3.7zM3 7.23V26h9.59L16 29.41 19.41 26h2.35l-2-2h-1.17L16 26.59 13.41 24H5V9.24l-2-2zM9.41 8H27v16h-1.59l-16-16z',
        'comment-solid' => 'M3 6v20h9.59L16 29.41 19.41 26H29V6Zm2 2h22v16h-8.41L16 26.59 13.41 24H5Zm4 3v2h14v-2Zm0 4v2h14v-2Zm0 4v2h10v-2Z',
        'comment' => 'M3 6v20h9.59L16 29.41 19.41 26H29V6Zm2 2h22v16h-8.41L16 26.59 13.41 24H5Zm4 3v2h14v-2Zm0 4v2h14v-2Zm0 4v2h10v-2Z',
        'comments-dollar-solid' => 'M2 3v18h4v5.1l1.63-1.32L12.34 21H22V3H2zm2 2h16v14h-8.34l-.29.22L8 21.9V19H4V5zm7 2v1.04a2.4 2.4 0 0 0-2 2.34 2 2 0 0 0 1.1 1.8l2.9 1.44c0 .22-.16.38-.38.38h-1.24a.37.37 0 0 1-.38-.38V13H9v.62a2.4 2.4 0 0 0 2 2.34V17h2v-1.04a2.4 2.4 0 0 0 2-2.34c0-.76-.43-1.45-1.1-1.8L11 10.39c0-.23.16-.38.38-.38h1.24c.22 0 .38.16.38.38V11h2v-.62a2.4 2.4 0 0 0-2-2.34V7h-2zm13 2v2h4v12h-4v2.9L20.34 23h-7.5l-2.5 2h9.32L26 30.1V25h4V9h-6z',
        'comments-solid' => 'M2 5v16h4v5.1l1.63-1.32L12.34 21H22V5Zm2 2h16v12h-8.34l-.29.22L8 21.9V19H4Zm20 2v2h4v12h-4v2.9L20.34 23h-7.5l-2.5 2h9.32L26 30.1V25h4V9Z',
        'comments' => 'M2 5v16h4v5.1l1.63-1.32L12.34 21H22V5Zm2 2h16v12h-8.34l-.29.22L8 21.9V19H4Zm20 2v2h4v12h-4v2.9L20.34 23h-7.5l-2.5 2h9.32L26 30.1V25h4V9Z',
        'compact-disc-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-2.78 2.5a8.04 8.04 0 0 0-4.72 4.72l1.88.69a6.02 6.02 0 0 1 3.53-3.54ZM16 13c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm5.63 3.1a6.02 6.02 0 0 1-3.54 3.52l.7 1.88a8.04 8.04 0 0 0 4.71-4.72Z',
        'compass-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm-1.03 2.06H15V7h2v-.94A9.94 9.94 0 0 1 25.94 15H25v2h.94A9.94 9.94 0 0 1 17 25.94V25h-2v.94A9.94 9.94 0 0 1 6.06 17H7v-2h-.94a9.95 9.95 0 0 1 8.9-8.94ZM22.5 9.5l-8.34 4.66L9.5 22.5l8.34-4.66Zm-6.5 5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z',
        'compass' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm-1.03 2.06H15V7h2v-.94A9.94 9.94 0 0 1 25.94 15H25v2h.94A9.94 9.94 0 0 1 17 25.94V25h-2v.94A9.94 9.94 0 0 1 6.06 17H7v-2h-.94a9.95 9.95 0 0 1 8.9-8.94ZM22.5 9.5l-8.34 4.66L9.5 22.5l8.34-4.66Zm-6.5 5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z',
        'compress-arrows-alt-solid' => 'M4.72 3.28 3.28 4.72 10.56 12H5v2h9V5h-2v5.56Zm22.56 0L20 10.56V5h-2v9h9v-2h-5.56l7.28-7.28ZM5 18v2h5.56l-7.28 7.28 1.44 1.44L12 21.44V27h2v-9Zm13 0v9h2v-5.56l7.28 7.28 1.44-1.44L21.44 20H27v-2Z',
        'compress-solid' => 'M11 4v7H4v2h9V4h-2zm8 0v9h9v-2h-7V4h-2zM4 19v2h7v7h2v-9H4zm15 0v9h2v-7h7v-2h-9z',
        'concierge-bell-solid' => 'M13 6v2h6V6Zm3 3C9.7 9 4.57 13.84 4.06 20H2v5h28v-5h-2.06C27.43 13.84 22.3 9 16 9Zm0 2a9.93 9.93 0 0 1 9.94 9H6.06c.5-5.09 4.71-9 9.94-9ZM4 22h24v1H4Z',
        'confluence' => 'M22.5 5a.72.72 0 0 0-.6.32l-.03.05c-1.45 2.42-2.34 3.5-3.87 3.5-1.66 0-4.06-1.26-8.7-3.46a.7.7 0 0 0-.3-.07.74.74 0 0 0-.66.41l-.01.02-2.25 5.11c-.17.36 0 .8.36.95.99.47 2.96 1.4 4.75 2.27 2.81 1.36 5.15 1.9 7.1 1.9 5.76 0 8.2-4.7 9.61-6.96a.72.72 0 0 0-.24-1l-4.74-2.92a.74.74 0 0 0-.4-.12zm.42 2.48 2.6 1.6c-1.68 2.65-3.6 4.92-7.24 4.92-1.8 0-3.9-.57-6.23-1.7L8.4 10.55l1.22-2.77.5.24c3.86 1.84 5.98 2.86 7.87 2.86 2.3 0 3.65-1.42 4.93-3.4zM13.72 16c-5.77 0-8.2 4.72-9.61 6.96-.21.35-.1.8.24 1L9.1 26.9a.73.73 0 0 0 1-.24c1.44-2.43 2.34-3.51 3.88-3.51 1.65 0 4.05 1.26 8.71 3.47.1.05.21.08.32.08.27 0 .53-.16.65-.42l.01-.02 2.27-5.12a.73.73 0 0 0-.37-.95l-4.74-2.26C18 16.55 15.67 16 13.7 16zm0 2c1.8 0 3.9.58 6.24 1.72l3.65 1.74-1.24 2.78-.55-.26c-3.84-1.83-5.95-2.84-7.84-2.84-2.3 0-3.64 1.4-4.92 3.38l-2.58-1.59C8.16 20.28 10.06 18 13.71 18z',
        'connectdevelop' => 'm9.16 4.19-.29.5-6.24 10.9-.29.5.29.5L8.88 27.5l.28.5h13.68l.29-.5 6.25-10.9.28-.5-.29-.5-6.25-10.91-.28-.5Zm2.43 2h6.13L13.16 7.8Zm9.13 0-4.6 4.68-2.18-2.28Zm-10.44.1 1.88 1.9-1.91.69V6.33Zm11.53.18L24.44 11l-4.03 4.28-3.57-3.69ZM9.25 8.09v1.13l-.81.28Zm3.66.88 2.53 2.62-3.72 3.79-1.47-1.57V9.94Zm-3.66 1.31v2.47l-1.66-1.78.07-.13Zm-2.19 1.6 2.19 2.34v3.72l-2.22 2.28-2.37-4.13Zm17.82.12-1.38 6.47L21.1 16Zm-8.75.31L19.71 16 16 19.94l-3.6-3.82Zm9.53.85 1.68 2.93-2.28 3.97-.68-.72Zm-15.41 2.12.78.81-.78.82Zm10.16 1.44 2.87 2.94-.34 1.59h-5.72l-.53-.56Zm-8.7.12 3.6 3.85-.56.56h-4.5v-2.94Zm-2.46 2.5v1.91H7.62l-.09-.13Zm14.88 1.2.4.43-.16.28h-.4Zm-15.94 1.7h1.06v1.84Zm2.06 0h3.56l-3.5 3.72-.06-.13Zm4.94 0h1.6l3.5 3.75h-8.63Zm2.97 0h4.56l-.63 3-.43.75Zm5.59 0h.06l-.1.16Z',
        'contao' => 'M5.66 5.47C4.75 5.47 4 6.19 4 7.09v17.82c0 .9.75 1.62 1.66 1.62h3.71A12.13 12.13 0 0 1 7 22.03c-.24-.95-1.17-5.1-1.5-7.06-.13-.79-.22-1.66-.22-2.78a8.55 8.55 0 0 1 3.06-6.72Zm16.5 0a11.13 11.13 0 0 1 2.5 3.94l-6.41 1.34s-.95-2.13-3.13-2.13c-1.18 0-3.34.84-3.34 2.97 0 1.39.49 4.28 1.13 7.04.77 3.33 1.62 5.09 3.78 5.09 3.55 0 3.53-3.53 3.53-3.53l6.44-1.44v1.56c0 3.11-2.03 5.54-2.66 6.22h2.34c.91 0 1.66-.72 1.66-1.62V7.09c0-.9-.75-1.62-1.66-1.62Z',
        'cookie-bite-solid' => 'M16 4a12 12 0 1 0 11.9 10.57 2.5 2.5 0 0 1-3.75-1.2A4 4 0 0 1 18.55 8a2.5 2.5 0 0 1-2.06-3.97A3.9 3.9 0 0 0 16 4Zm7.5 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-9.45 2.19a4.5 4.5 0 0 0 2 3.08 6 6 0 0 0 7.42 6.54 4.52 4.52 0 0 0 2.48 1.16A10.01 10.01 0 0 1 6 16c0-4.85 3.47-8.9 8.05-9.81ZM22 9a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-8 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm13 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-16 3a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm5 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3.5 4a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm7 1a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'cookie-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-2 4a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm5.5 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM11 13a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm6 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm5 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-9.5 3a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm7 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'copy-solid' => 'M4 4v20h7v-2H6V6h12v1h2V4Zm8 4v20h16V8Zm2 2h12v16H14Z',
        'copy' => 'M4 4v20h7v-2H6V6h12v1h2V4Zm8 4v20h16V8Zm2 2h12v16H14Z',
        'copyright-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-.1 5a6 6 0 0 0-6 6 5.99 5.99 0 0 0 11.41 2.53l-1.81-.84A3.96 3.96 0 0 1 15.9 20c-2.27 0-4-1.72-4-4 0-2.28 1.73-4 4-4 1.6 0 2.96.94 3.6 2.31l1.81-.84a6 6 0 0 0-5.4-3.47Z',
        'copyright' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-.1 5a6 6 0 0 0-6 6 5.99 5.99 0 0 0 11.41 2.53l-1.81-.84A3.96 3.96 0 0 1 15.9 20c-2.27 0-4-1.72-4-4 0-2.28 1.73-4 4-4 1.6 0 2.96.94 3.6 2.31l1.81-.84a6 6 0 0 0-5.4-3.47Z',
        'cotton-bureau' => 'M15.4 3C8.7 3 3 9 3 16s5.7 13 12.3 13h1.8c5.1 0 9.8-3.4 11.8-8h-2.1a11.35 11.35 0 0 1-8.8 5.96V25.2c0-1.3.56-2.48 1.57-3.18l.03-.02.28-.22c.5.14 1.04.22 1.62.22 1.75 0 3.19-.7 4.12-1.74A5.64 5.64 0 0 0 27 16.5c0-1.35-.44-2.7-1.38-3.76a5.28 5.28 0 0 0-3.32-1.68 5.4 5.4 0 0 0-1.18-2.32A5.42 5.42 0 0 0 17 7c-1.75 0-3.19.7-4.12 1.74a5.4 5.4 0 0 0-1.18 2.32c-1.39.17-2.54.8-3.32 1.68A5.64 5.64 0 0 0 7 16.5c0 1.35.44 2.7 1.38 3.76A5.42 5.42 0 0 0 12.5 22c.58 0 1.12-.08 1.62-.22l.28.22.03.02A3.78 3.78 0 0 1 16 25.2V27h-.6C9.7 27 5 22 5 16S9.7 5 15.3 5h1.8c4 0 7.8 2.5 9.6 6H29c-2-4.6-6.7-8-11.8-8h-1.8zM17 9a3.3 3.3 0 0 1 2.63 1.07c.27.3.47.66.62 1.05a5.2 5.2 0 0 0-3.25 2.1 5.2 5.2 0 0 0-3.25-2.1c.15-.39.35-.75.62-1.05A3.29 3.29 0 0 1 17 9zm-5.45 4.1a5.53 5.53 0 0 0 1.33 3.16 5.2 5.2 0 0 0 2.87 1.61c-.15.4-.35.76-.62 1.06A3.29 3.29 0 0 1 12.5 20a3.29 3.29 0 0 1-2.63-1.07A3.68 3.68 0 0 1 9 16.5c0-.9.3-1.8.87-2.43.41-.46.95-.8 1.68-.96zm10.9 0c.73.17 1.27.51 1.68.97.56.64.87 1.53.87 2.43 0 .9-.3 1.8-.87 2.43A3.29 3.29 0 0 1 21.5 20a3.29 3.29 0 0 1-2.63-1.07c-.27-.3-.47-.66-.62-1.05a5.2 5.2 0 0 0 2.87-1.62c.8-.9 1.22-2.01 1.33-3.15zm-8.9.04c.68.17 1.2.5 1.58.93.43.49.7 1.12.82 1.8a3.06 3.06 0 0 1-1.58-.94 3.55 3.55 0 0 1-.82-1.8zm6.9 0c-.11.67-.4 1.3-.82 1.79-.39.43-.9.76-1.58.93.11-.67.4-1.3.82-1.79.39-.43.9-.76 1.58-.93zM17 19.77a5.18 5.18 0 0 0 .95 1.02 7 7 0 0 0-.95 1.26 7 7 0 0 0-.95-1.26 4.9 4.9 0 0 0 .95-1.02z',
        'couch-solid' => 'M6 7c-1.64 0-3 1.36-3 3v2.19C1.84 12.6 1 13.7 1 15v11h2v-2h26v2h2V15c0-1.3-.84-2.4-2-2.81V10c0-1.64-1.36-3-3-3Zm0 2h20a1 1 0 0 1 1 1v2.19A3 3 0 0 0 25 15v2H7v-2c0-1.3-.84-2.4-2-2.81V10a1 1 0 0 1 1-1Zm-2 5a1 1 0 0 1 1 1v4h22v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v7H3v-7a1 1 0 0 1 1-1Z',
        'cpanel' => 'M6.12 12a.72.72 0 0 0-.72.54L3.66 19l1.23-.01c.34 0 .62-.22.71-.53l1.3-4.75h.98c.42 0 .81.28.92.74a.94.94 0 0 1-.92 1.12h-.51a.74.74 0 0 0-.72.53l-.32 1.18h1.6c1.86 0 2.92-1.8 2.59-3.24A2.6 2.6 0 0 0 7.97 12H6.12zm24.6 0a.53.53 0 0 0-.52.4L28.42 19a2.3 2.3 0 0 0 2.24-1.72l1.33-4.87c.06-.21-.1-.41-.33-.41h-.94zm-19.37 2-.16.62c-.11.46.2.87.67.87h2.71c.2 0 .12.2.1.25l-.4 1.5c-.02.06-.05.24-.26.24h-1.65c-.25 0-.25-.37 0-.37h1.02a.7.7 0 0 0 .67-.51l.16-.62h-2.28c-1.85 0-2.06 3-.03 3l2.71.01c.53 0 .98-.34 1.1-.84l.67-2.43c.23-.9-.45-1.72-1.34-1.72h-3.69zm-8.85.01c-1.08 0-2.08.66-2.42 1.93A2.44 2.44 0 0 0 2.46 19h.58l.34-1.23a.3.3 0 0 0-.3-.39h-.54c-1.16 0-1.17-1.75 0-1.75h.88a.7.7 0 0 0 .68-.51L4.4 14H2.5zm17.28 0H17.5l-1.23 4.6c-.06.2.1.39.3.39h.89a.5.5 0 0 0 .49-.37l.81-3h.94c.59 0 1.02.55.86 1.1l-.5 1.87a.3.3 0 0 0 .3.4h.9a.5.5 0 0 0 .49-.37l.41-1.55a2.43 2.43 0 0 0-2.38-3.07zm5.16 0c-.84 0-1.6.57-1.82 1.39l-.51 1.87c-.24.83.4 1.73 1.34 1.73h3.14a.7.7 0 0 0 .68-.51l.27-.98h-3.47a.24.24 0 0 1-.24-.31l.38-1.41c.04-.18.17-.29.37-.29h1.55a.2.2 0 0 1 .19.25l-.04.12c-.03.1-.08.14-.18.14h-1.02c-.33 0-.6.21-.67.5l-.17.62h2.52c.5 0 .97-.31 1.1-.83l.15-.56c.24-.9-.43-1.73-1.33-1.73h-2.24z',
        'creative-commons-by' => 'M16 3C8.85 3 3 8.85 3 16s5.85 13 13 13 13-5.85 13-13S23.15 3 16 3zm0 2c6.05 0 11 4.95 11 11s-4.95 11-11 11S5 22.05 5 16 9.95 5 16 5zm0 3a2 2 0 0 0-2 2c0 1.1.9 2 2 2a2 2 0 0 0 2-2 2 2 0 0 0-2-2zm0 5c-1.7 0-3 1.3-3 3v3l1 1v4h4v-4l1-1v-3c0-1.7-1.3-3-3-3z',
        'creative-commons-nc-eu' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.4 14.54L17 15.35V14h-2.72c.12-.38.26-.73.44-1 .44-.68.95-1 1.75-1 .73 0 1.16.3 1.81 1.06l1.53-1.31c-.8-.93-1.9-1.75-3.34-1.75-1.46 0-2.68.78-3.4 1.9a5.8 5.8 0 0 0-.64 1.41L6.4 10.63A11 11 0 0 1 16 5zM5.6 12.46l5.4 2.4v.64h1.03c0 .17-.03.33-.03.5 0 .17.02.33.03.5H11V18h1.22c.17.76.45 1.48.84 2.1a4.04 4.04 0 0 0 3.4 1.9c1.38 0 2.52-.7 3.35-1.66l-1.53-1.3c-.62.71-1.01.96-1.81.96s-1.31-.32-1.75-1a4.1 4.1 0 0 1-.44-1H17v-.46l8.6 3.83A11 11 0 0 1 5 16c0-1.24.22-2.43.6-3.54z',
        'creative-commons-nc-jp' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.4 14.54l-8.85-3.94L21 11h-2.38L16 14.31 13.53 11h-2.37l1.96 2.63-6.71-3A11 11 0 0 1 16 5zM5.6 12.46l7.4 3.3V18h2v1h-2v2h2v1h2v-1h2v-2h-2v-1h1.03l7.56 3.37A11 11 0 0 1 5 16c0-1.24.22-2.43.6-3.54z',
        'creative-commons-nc' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.4 14.54l-8.38-3.74a3.05 3.05 0 0 0-.86-.56 2.95 2.95 0 0 0-.56-.18c-.1-.02-.21-.02-.32-.03l-1.11-.5-.1-.13a1.04 1.04 0 0 1 .22-1.11.9.9 0 0 1 .31-.21c.12-.05.26-.08.4-.08.57 0 1 .43 1 1h2a2.94 2.94 0 0 0-.15-.92 3.05 3.05 0 0 0-1.85-1.9V10h-2v1.19a3.08 3.08 0 0 0-1.85 1.89 2.9 2.9 0 0 0-.11.5L6.4 10.63A11 11 0 0 1 16 5zM5.6 12.46l8.38 3.74a2.84 2.84 0 0 0 1.74.77l1.11.5.1.13c.04.12.07.26.07.4a.98.98 0 0 1-1 1c-.14 0-.28-.03-.4-.08A1 1 0 0 1 15 18h-2a2.94 2.94 0 0 0 1.58 2.62l.42.2V22h2v-1.19a3.02 3.02 0 0 0 1.96-2.34v-.05l6.63 2.95A11 11 0 0 1 5 16c0-1.24.22-2.43.6-3.54z',
        'creative-commons-nd' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 8v2h10v-2H11zm0 4v2h10v-2H11z',
        'creative-commons-pd-alt' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-7 7v8h2v-2h2a3 3 0 0 0 0-6H9zm8 0v8h3.5c1.93 0 3.5-1.8 3.5-4s-1.57-4-3.5-4H17zm-6 2h2a1 1 0 0 1 0 2h-2v-2zm8 0h1.5c.81 0 1.5.92 1.5 2s-.69 2-1.5 2H19v-4z',
        'creative-commons-pd' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.4 14.54L14 14.02V14a2 2 0 0 1 4 0h2a4 4 0 0 0-7.9-.84l-5.7-2.53A11 11 0 0 1 16 5zM5.6 12.46l6.4 2.85V18a4 4 0 0 0 7.9.84l5.7 2.53A11 11 0 0 1 5 16c0-1.24.22-2.43.6-3.54zm8.4 3.75L18.03 18H18a2 2 0 0 1-4 0v-1.8z',
        'creative-commons-remix' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-1.5 4L11 10.33v3.62l.06.03L11 14l-3 1.14v3.38L11 20l3-1.41 6.5 2.42 3.5-1.33v-3.63l-3-1.11v-3.52L14.5 9zm5.21 6.53 2.37.88-1.58.6-2.37-.88 1.58-.6zm-4.71.5 5 1.86v1.86l-5-1.85v-1.87zm8 1.1v1.86l-2 .76v-1.86l2-.76z',
        'creative-commons-sa' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm0 5a4 4 0 0 0-4 4h-2l3 3 3-3h-2a2 2 0 0 1 4 0v4a2 2 0 0 1-3.72 1h-2.14A4 4 0 0 0 20 18v-4a4 4 0 0 0-4-4z',
        'creative-commons-sampling-plus' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm.13 4a.5.5 0 0 0-.5.47l-.35 3.67-.32-2.75a.5.5 0 0 0-1 0l-.31 3.23-.3-2.32a.5.5 0 0 0-.49-.45.5.5 0 0 0-.5.45l-.45 4.7-.2-1.05a.5.5 0 0 0-.92-.17L10.08 16H8v1h2.37a.5.5 0 0 0 .43-.25l.17-.3.6 3.3c.04.24.27.4.5.4a.5.5 0 0 0 .48-.45l.27-1.7.37 3.54a.5.5 0 0 0 1 0l.27-2.5.34 3.5a.5.5 0 0 0 1 0l.3-3.54.24 2.53a.5.5 0 0 0 .5.47.5.5 0 0 0 .5-.46l.35-2.82.26 2.81a.5.5 0 0 0 .5.47.5.5 0 0 0 .5-.45l.45-4.91.3 2.16a.5.5 0 0 0 .95.13L21.5 17H24v-1h-2.83a.5.5 0 0 0-.46.3l-.26.6-.65-4.7c-.03-.25-.25-.42-.5-.43a.5.5 0 0 0-.49.45L18.53 14l-.27-2.69a.5.5 0 0 0-1 0L16.95 13l-.32-3.53a.5.5 0 0 0-.5-.47zM15 14h2v1h1v2h-1v1h-2v-1h-1v-2h1v-1z',
        'creative-commons-sampling' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm.13 4a.5.5 0 0 0-.5.47l-.35 5.48-.32-4.56a.5.5 0 0 0-1 0l-.3 4.5-.3-3.59a.5.5 0 0 0-1 0l-.45 4.7-.2-1.05a.5.5 0 0 0-.92-.17L10.08 16H8v1h2.37a.5.5 0 0 0 .43-.25l.17-.3.6 3.3c.04.24.27.4.5.4a.5.5 0 0 0 .48-.45l.27-2.73.37 4.57a.5.5 0 0 0 1 0l.27-3.9.34 4.9a.5.5 0 0 0 1 0l.31-4.94.24 3.93a.5.5 0 0 0 .49.47.5.5 0 0 0 .5-.46l.35-3.85.26 3.84a.5.5 0 0 0 .5.47.5.5 0 0 0 .5-.45l.45-4.91.3 2.16a.5.5 0 0 0 .95.13L21.5 17H24v-1h-2.83a.5.5 0 0 0-.46.3l-.26.6-.65-4.7c-.03-.25-.25-.42-.5-.43a.5.5 0 0 0-.49.45l-.28 3.05-.27-3.96a.5.5 0 0 0-.5-.46.48.48 0 0 0-.5.45l-.31 3.52-.32-5.35a.5.5 0 0 0-.5-.47z',
        'creative-commons-share' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-6 4v10h4v4h8V13h-4V9h-8zm2 2h4v2h-2v4h-2v-6zm4 4h4v6h-4v-6z',
        'creative-commons-zero' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm0 5a4 4 0 0 0-4 4v4a4 4 0 0 0 8 0v-4a4 4 0 0 0-4-4zm0 2c.26 0 .5.05.72.14L14 17.87V14c0-1.1.9-2 2-2zm2 2.12V18a2 2 0 0 1-2.73 1.86L18 14.12z',
        'creative-commons' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 6c-1.64 0-3 1.36-3 3v2c0 1.64 1.36 3 3 3s3-1.36 3-3h-2c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-2c0-.57.43-1 1-1 .57 0 1 .43 1 1h2c0-1.64-1.36-3-3-3Zm8 0c-1.64 0-3 1.36-3 3v2c0 1.64 1.36 3 3 3s3-1.36 3-3h-2c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-2c0-.57.43-1 1-1 .57 0 1 .43 1 1h2c0-1.64-1.36-3-3-3Z',
        'credit-card-solid' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v2H5v2h23v10c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Z',
        'credit-card' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v2H5v2h23v10c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Z',
        'critical-role' => 'M16.01 3.36 5.15 9.54A.24.24 0 0 0 5 9.8v12.5c0 .06.03.12.1.15l10.78 6.2h.15l10.8-6.15a.29.29 0 0 0 .17-.29V9.84c0-.15-.04-.26-.18-.32L16.1 3.36h-.09zm.35.91 9.67 5.56-5.08 1.91c-.04.02-.05.04-.04.07.04.1.08.19.1.28.02.05.05.07.1.04l5.22-1.95v11.37l-3.82-6.62c-.05-.09-.05-.09-.15-.07l-.33.07 4 6.95h-9.2c-.07 0-.1 0-.1-.08l-.04-1.32c0-.06-.02-.07-.08-.07-.38.07-.77.08-1.16.02-.05-.01-.07.01-.07.06v.55c0 .03 0 .06-.05.05-.85-.12-.68.01-2.04-1.63l-.38-.49a.07.07 0 0 1 0-.1c.42-.51.79-.9.74-1.61a1.2 1.2 0 0 0-.62-1.01c-.49-.3-1.1-.24-2.76-.24-.19 0-.23.19-.09.24.06.02.17.01.23.03.25.04.27.13.27.66 0 3.48 0 3.25-.06 3.92-.02.26-.16.18-.33.22a.12.12 0 0 0-.1.09c-.01.06.03.13.09.15.1.03 1.58.02 1.66 0 .17-.04.13-.23-.02-.24-.37-.03-.46-.02-.48-.24-.04-.36-.04-.32-.05-1.61 0-.09 0-.09.09-.09.65 0 .71-.03.82.12l1.08 1.44c.36.47.69.62 1.06.63 1.02 0 .9-.02.9.05v.43c0 .07 0 .08-.08.08h-9.2c-.1 0-.1.02-.07-.05l3.33-5.78c.04-.05.03-.06-.04-.07-.3-.02-.37-.06-.45.08l-3.16 5.48V10.17l1.32.5c.12.04.15.04.53-.26l-1.53-.57v-.02l9.58-5.46.01.01-4.25 7.36h.45c.1-.01 3.77-6.5 4.22-7.23l4.05 7.02c.06.11.1.15.58.2l.01-.02-4.28-7.43zm-.43 3.36a.78.78 0 0 0-.71.8c0 .31.16.54.44.69.05.02.08.07.08.13-.02.35-.02.1-.05 1.46 0 .09 0 .1-.1.1-1.5-.02-1.55 0-1.83-.1-.1-.04-.15-.01-.17.1l-.16.88c-.01.05.07.3.2-.01.16-.44.38-.4 1.98-.42.03 0 .07 0 .06.05l-.18 6c0 .06-.04.11-.1.13a1.5 1.5 0 0 0-.98 1.8c.29 1.2 1.55 1.15 1.69 1.14 1.45-.07 1.66-1.25 1.59-1.83a1.22 1.22 0 0 0-.62-.96 3.98 3.98 0 0 0-.43-.2c-.03-.01-.06-.03-.06-.07l-.18-6.03c0-.03.01-.05.05-.05 2.24.12 1.68.12 1.93.6.03.07.08.07.13 0 .04-.06.04-1 .04-1 0-.09-.05-.11-.13-.1a1.8 1.8 0 0 1-.27.04l-1.7.03c-.04 0-.06-.01-.06-.06l-.05-1.48a.21.21 0 0 1 .1-.22c.42-.25.47-.83.13-1.19a.76.76 0 0 0-.64-.23zm.07.41c.5 0 .47.74 0 .74-.48 0-.48-.74 0-.74zm-7 2.22a4 4 0 0 0-.68.1c-1.47.33-2.12 1.7-1.98 2.97.32 3.16 4.53 2.53 4.6 2.07l.17-.94v-.05a.13.13 0 0 0-.15-.12c-.28.02.12.91-1.22 1.01-1.83.14-2.69-1.33-2.67-2.5.04-2.88 3.53-2.37 3.68-1.26.02.14 0 .44.2.36a.13.13 0 0 0 .08-.12l.06-1.14c0-.14-.04-.18-.18-.2-.73-.08-1.27-.21-1.9-.18zm13.32 1.55a.1.1 0 0 0-.06.04c-.07.07-.02-.03-.91 2.05l-.2.45a.3.3 0 0 1-.3.17c-.11 0-.1.16.04.16h1.3c.2 0 .12-.15-.03-.18-.22-.04-.67.05-.6-.1l.22-.55a.1.1 0 0 1 .08-.05c.24-.02.48-.02.72 0a.1.1 0 0 1 .1.06l.2.5c.1.22-.1.25.02.28l.18.04 2.5.01c.27 0 .2-.15.27-.5.01-.12-.11-.28-.2 0-.05.2-.13.19-.78.17a.15.15 0 0 1-.16-.12c-.03-.12-.02-1.95-.02-2.03v-.02c0-.07.06-.13.13-.13.33-.03.18-.17.06-.17-1.11 0-1.06 0-1.07.01-.12.12 0 .15 0 .15.17.03.28 0 .28.21v2.04c0 .16-.03.22-.2.21-.04 0-.22.04-.32-.1-.26-.35-1.02-2.4-1.17-2.56 0 0 0-.02-.02-.02a.09.09 0 0 0-.06-.02zm-2.5.03c-.42 0-.9.09-1.25.44-.49.48-.7 1.68.34 2.23.65.35 1.53.18 1.61.17.32-.04.3-.62.3-.63-.05-.14-.1-.12-.16-.05-.05.05-.05.28-.34.37-.34.1-1.14.08-1.43-.68-.27-.73.05-1.87 1.35-1.5.22.08.35.22.37.46 0 .12.13.12.17.01l.02-.47c.01-.15-.02-.2-.14-.23a3.57 3.57 0 0 0-.84-.12zm-4.77.06h-.94c-.16.06-.16.15.03.17.14.01.16.06.16.34 0 2.23 0 1.83-.02 2a.1.1 0 0 1-.11.1c-.18.02-.36-.01-.49-.15-.51-.54-.8-.91-.85-.97l.3-.33c.44-.5.04-1.07-.39-1.12-.37-.05-.9-.04-1.48-.04-.1 0-.3.13.05.17.14.01.17.08.17.24 0 .1-.02.71-.01 1.98 0 .35-.18.12-.3.3.02.06.08.1.14.1h.96c.19 0 .19-.18-.05-.18-.2 0-.15-.06-.2-.87 0-.1.33-.09.41.02.53.72.67 1.03 1.2 1.03h1.53c.2 0 .13-.17 0-.17-.24 0-.24-.07-.25-.11-.02-.13-.03.05-.02-2.12 0-.17.02-.21.2-.22h.01c.17-.14-.03-.17-.05-.17zm1.83 0c-.09 0-.15.1-.02.16.07.03.23-.04.23.2 0 2.33.05 2.26-.17 2.26-.17 0-.19.16 0 .16H18c.13 0 .13-.16 0-.16-.15-.01-.3.02-.3-.18-.03-2.08 0-2.15 0-2.16.02-.14.16-.1.21-.13.11-.06.07-.1.02-.14-.05-.03-.98 0-1.04 0zm-4.74.28c.18-.03.55.04.61.46.02.11.07.73-.6.66-.09-.01-.1-.04-.1-.13v-.92c0-.03.03-.05.1-.07zm10.08.52.3.78h-.6l.3-.78zm-10.48 3.68c.18 0 .38.04.43.05.75.22.91 1.2.62 1.92-.23.54-.7.42-1.27.36-.12-.01-.13-.03-.13-.15v-2.05c0-.11.17-.14.35-.13zm10.74.78c-.45.05-.06.03-1.83.03-.2 0-.18.17.03.17.19 0 .31-.24.2 2.54-.02.15-.16.12-.21.13-.12.02-.15.14-.01.17l1.73.01c.23 0 .23-.1.23-.12l.07-.47c.01-.12-.12-.15-.16-.03-.1.28 0 .3-.81.28-.23 0-.2-.2-.2-.8 0-.43-.12-.34.64-.3.19.01.13.16.19.26.03.06.1.05.12-.01.02-.05.06-.55.06-.56.01-.18-.13-.1-.15-.1-.27.1-.62.07-.78.08-.08 0-.08.01-.08-.07v-.8c0-.07 0-.07.08-.07.67.03.76-.01.78.25 0 .14.15.11.16 0l.05-.5c.01-.08-.02-.1-.1-.09zm-3.22.03h-1.14c-.12 0-.14.14-.02.16.14.02.27 0 .28.19.01.15.03 1.57-.02 2.35 0 .16-.15.12-.25.14-.08.02-.07.16.02.17h1.89c.05 0 .27.07.25-.6 0-.01-.04-.17-.13-.06-.2.24.15.38-.93.32-.12 0-.17-.07-.17-.18-.03-.61-.02-1.95-.02-2.05 0-.29.12-.25.25-.27.17-.02.15-.17-.01-.17zm-3.79.49c.01.1-.05 1.84-.05 1.94-.02.41 1.26.62 1.24.13l-.05-1.93h.02c.6.46.5 1.53.26 1.92a.88.88 0 0 1-1.1.35c-1.03-.43-1.02-2.05-.32-2.41zm1.35 4.63c9.52 0 8.95 0 8.96.01-.76.45-8.9 5.08-9.74 5.56a.15.15 0 0 1-.17 0L6.2 22.3h9.03c.1 0 .1 0 .1.1a84.53 84.53 0 0 1-.08 2.37c0 .18.03.37.1.53l.62 1.53c.05.12.06.1.1 0 .69-1.6.64-1.5.67-1.58.04-.13.06-.26.06-.39l-.06-2.48c0-.06.02-.08.08-.08z',
        'crop-alt-solid' => 'M8 4v4H4v2h4v14h14v4h2v-4h4v-2H10V4H8zm4 4v2h10v10h2V8H12z',
        'crop-solid' => 'M8 4v4H4v2h4v14h14v4h2v-4h4v-2H11.44L22 11.44V21h2V9.44l3.72-3.72-1.44-1.44L22.56 8H11v2h9.56L10 20.56V4Z',
        'cross-solid' => 'M13 3v6H7v6h6v14h6V15h6V9h-6V3Zm2 2h2v6h6v2h-6v14h-2V13H9v-2h6Z',
        'crosshairs-solid' => 'M15 3v2.06A11 11 0 0 0 5.06 15H3v2h2.06A11 11 0 0 0 15 26.94V29h2v-2.06A11 11 0 0 0 26.94 17H29v-2h-2.06A11 11 0 0 0 17 5.06V3Zm0 4.03V9h2V7.03A9 9 0 0 1 24.97 15H23v2h1.97A9 9 0 0 1 17 24.97V23h-2v1.97A9 9 0 0 1 7.03 17H9v-2H7.03A9 9 0 0 1 15 7.03Z',
        'crow-solid' => 'M7 6a4 4 0 0 0-4 4v5a8 8 0 0 0 7 7.93V27h2v-4h2v4h2v-4h6.38l3.08 2h4L11 13v-3h4c0-1.66-2.2-3-4-3H9.62A4 4 0 0 0 7 6zm0 2c.2 0 .4.04.58.1A1 1 0 0 0 8 10a1 1 0 0 0 .9-.58c.06.19.1.38.1.58v4.09l.91.59L19.64 21H11a6 6 0 0 1-6-6v-5c0-1.1.9-2 2-2z',
        'crown-solid' => 'M16 3c-1.64 0-3 1.36-3 3a3 3 0 0 0 1.56 2.63l-2.94 5.87-4.59-3.28A3 3 0 1 0 2 9a3 3 0 0 0 2.16 2.84L6 22v5h20v-5l1.84-10.16A3 3 0 0 0 30 9c0-1.64-1.36-3-3-3a3.02 3.02 0 0 0-2.03 5.22l-4.6 3.28-2.93-5.88A3 3 0 0 0 19 6c0-1.64-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1ZM5 8c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm22 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-11 2.25 3.1 6.19 1.5.37 5-3.56L24.18 21H7.8l-1.4-7.75 5 3.56 1.5-.37ZM8 23h16v2H8Z',
        'crutch-solid' => 'M19.47 4a2.01 2.01 0 0 0-1.94 1.13l-.5.93v.03a2.02 2.02 0 0 0 0 1.7l-1.06 1.05a10.92 10.92 0 0 0-2.88 5.1l-.71 2.84L11.12 18l.72.72-4.53 4.56-.87.13L5 24.84 7.16 27l1.43-1.44.13-.87 4.56-4.53.72.71 1.22-1.25 2.84-.71a10.92 10.92 0 0 0 5.1-2.88l1.06-1.06c.53.22 1.15.23 1.69-.03h.03l.93-.47a2.03 2.03 0 0 0 .54-3.22l-.04-.06-6.43-6.4-.19-.2A2 2 0 0 0 19.47 4Zm-.16 2h.03L26 12.66v.03l-.97.47H25L18.84 7v-.03Zm-1 3.31 4.38 4.38-.94.9c-.18.18-.37.34-.56.5l-4.28-4.28c.16-.19.32-.38.5-.56Zm-2.53 3.22 3.69 3.69a9 9 0 0 1-1.9.75l-1.48.37.63-.62-1.44-1.44-.62.63.37-1.47a9 9 0 0 1 .75-1.9Z',
        'css3-alt' => 'm6 4 2 21 8 3 8-3 2-21H6zm3.33 3h13.32l-.26 3-5.7 3h5.44l-.5 6h.01l-.27 3L16 24l-5.37-2-.33-4h3.03l.15 2.03 2.52.87 2.52-.85.35-4.05h-8.74l-.26-3 5.91-3H9.61l-.28-3z',
        'css3' => 'm8.22 5-.16.81-.5 2.88-.22 1.19h14.13l-.31 1.8H7.03l-.16.82-.5 2.88-.21 1.15h14.12l-.72 4.06L14.34 23l-4.09-2.25.22-1.22.22-1.16H5.8l-.12.82L5 23l-.16.75.7.34 7.8 3.82.41.18.4-.15 9.16-3.85.5-.18.13-.57L27 6.2l.22-1.2Zm1.65 2h14.94l-2.75 15.47-8.28 3.4-6.69-3.25.41-2.25h.78l-.25 1.44.63.35L13.8 25l.44.25.47-.22 6.15-2.84.47-.22.1-.53 1.03-5.72.22-1.19H8.56l.13-.84h14.15l.13-.85.69-3.8.21-1.16H9.76Z',
        'cube-solid' => 'm16 4.4-.4.2-10 4.5-.6.24v12.7l.5.27 10 5.57.5.28.5-.29 10-5.56.5-.28V9.34l-.6-.25-10-4.5Zm0 2.2 7.69 3.43L16 13.88l-7.69-3.85Zm-9 5.03 8 4v9.65l-8-4.44Zm18 0v9.21l-8 4.44v-9.66Z',
        'cubes-solid' => 'm16 4-.38.16-6 2.4-.62.25v6.72l-5.4 2.35-.6.28v8.06l.5.31 6 3.34.47.25.47-.21L16 25.12l5.56 2.79.47.21.47-.25 6-3.34.5-.31v-8.06l-.6-.29-5.4-2.34V6.81l-.63-.25-6-2.4Zm0 2.19 3.28 1.28L16 8.75l-3.28-1.28Zm-5 2.75 4 1.53v4.87l-4-1.78Zm10 0v4.62l-4 1.78v-4.87ZM10 15.3l3.63 1.6L10 18.69l-3.63-1.82Zm12 0 3.63 1.56L22 18.7l-3.63-1.78 1.13-.5ZM5 18.4l4 2v4.9l-4-2.25Zm22 0v4.65l-4 2.25v-4.9Zm-12 .06v4.9l-4 2V20.4Zm2 0 4 1.94v4.96l-4-2Z',
        'cut-solid' => 'M19.66 4.31a2 2 0 0 0-1.7 1.44l-2.65 9.31-3.34.97A3.53 3.53 0 0 0 8.5 13 3.51 3.51 0 0 0 5 16.5C5 18.42 6.58 20 8.5 20c1.29 0 2.43-.73 3.03-1.78l3.13-.88-.88 3.13A3.52 3.52 0 0 0 12 23.5c0 1.92 1.58 3.5 3.5 3.5s3.5-1.58 3.5-3.5a3.53 3.53 0 0 0-3.03-3.47l4.47-15.66a2.1 2.1 0 0 0-.78-.06Zm7.96 7.25-8.71 2.47-.66 2.28 8-2.28a2 2 0 0 0 1.38-2.47ZM8.5 15c.84 0 1.5.66 1.5 1.5S9.34 18 8.5 18 7 17.34 7 16.5 7.66 15 8.5 15Zm7 7c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5-1.5-.66-1.5-1.5.66-1.5 1.5-1.5Z',
        'cuttlefish' => 'M17 3C9.83 3 4 8.83 4 16a13.01 13.01 0 0 0 22.5 8.88l.88-.94-1.07-.7a18.15 18.15 0 0 1-4.52-6.12C20.62 18.68 18.79 20 17 20a4 4 0 0 1 0-8c1.8 0 3.63 1.32 4.8 2.89.13-.31 1.88-4.15 4.5-6.12l1.08-.7-.88-.95A12.88 12.88 0 0 0 17 3zm0 2c2.75 0 5.32.99 7.34 2.8a17.46 17.46 0 0 0-3.05 3.78A7.27 7.27 0 0 0 17 10a6 6 0 0 0 0 12c1.6 0 3.07-.67 4.3-1.59a21.2 21.2 0 0 0 3.07 3.75A11.01 11.01 0 0 1 6 16c.01-6.06 4.94-11 11.01-11z',
        'd-and-d-beyond' => 'M15.92 11c-.9-.04-.92.75-.9.85.01.23.14.35.14.35a.56.56 0 0 1 .05-.43c.05.14.12.3.34.41a.83.83 0 0 1 .02-.36c-.06-.25.1-.46.3-.46.3 0 .38.4.2.66.1.14.26.25.36.35.14-.16.24-.43.24-.63 0-.37-.24-.71-.75-.74zm.9.3c0 .03.02.37.44.67.14.1.13.2.13.43.08-.05.17-.1.28-.14-.05.06-.13.13-.16.21a.8.8 0 0 1 .66-.16.6.6 0 0 0-.26.12c.04 0 .13-.03.32 0v-.2c.22 0 1.05-.15 1.05.78 0 .94-.84.8-.9.8.27.2.27.54.1.73h.02c1.52 0 1.66-1.24 1.66-1.55 0-.17-.04-1.44-1.53-1.52-1.46 0-1.49.01-1.8-.18zm-5.13 0c0 .04.02.37.43.67.08.07.13.11.13.3v1.76c0 .19-.04.24-.12.29l-.36.2h1.6c.45 0 .78-.06 1.17-.38-.02-.23.01-.43.04-.55a.6.6 0 0 0-.13.17c0-.27.07-.7.44-.94 0 0-.17-.03-.41.06.09-.15.45-.36.47-.36-.34-1.08-1.5-1.06-1.5-1.04-1.35 0-1.44.01-1.76-.18zm3.98.44c-.08.07-.12.35-.06.5.11.06.2.17.22.27-.1-.23-.52-.28-.63-.56a.4.4 0 0 0 .04.31s-.1-.03-.32-.03c.09.03.24.16.22.24-.02.08-.32.16-.46.3.22-.04.32 0 .35.09.03.06 0 .15-.01.25.07-.08.31-.24.5-.28l-.2-.03c.12-.15.4-.2.55-.17-.1 0-.28.06-.36.12l.2.05a.5.5 0 0 0-.27.28c.32-.23.6.23.32.37.03 0 .13 0 .16-.03a.32.32 0 0 1-.13.16c.12 0 .31-.08.37-.21 0 0-.08.03-.12-.01-.03-.03 0-.14 0-.17-.1.1-.15-.08-.05-.21a.83.83 0 0 0-.2-.03c.14-.04.47-.08.5 0 .03.04-.04.15-.04.15.18-.03.37.04.3.22.13-.06.25-.26.21-.47 0 .05-.07.11-.12.13 0-.06-.05-.1-.1-.12.09-.44-.66-.64-.63-1.09-.04.06-.08.23-.04.33.12.14.4.3.46.55-.12-.29-.68-.52-.66-.91zm-2.32.47c.32 0 .8.1.8.8 0 .94-.84.78-1.06.78v-1.57h.26zm4.48.19c-.23.01-.4.29-.48.25-.05-.02.07-.16.07-.16-.24.13-.42.4-.47.59.21-.27.63-.45.9-.41-.48.02-.89.43-1.08.71.1.04.08.03.3.2.45-1.1.97-.7 1-.7a.9.9 0 0 1 .6-.12.88.88 0 0 0-.6-.28c-.21 0-.33.1-.36.06-.02-.04.08-.12.12-.14zm-1.7.2c.14.07.19.2.19.2-.13 0-.16-.1-.2-.2zm-1.17.26s-.38.25-.42.66c0 0 .05-.07.1-.08.02-.02.06 0 .02.08 0 .03-.26.72.24 1.18-.03-.07-.1-.34.1-.08 0 .02.28.32.71.32.63 0 .96-.46 1.13-.81-.05-.06-.23-.2-.34-.3-.1.19-.37.48-.62.48-.47 0-.7-.66-.15-1.2-.03-.01-.2-.09-.36.1 0-.13.04-.22.09-.3a1.6 1.6 0 0 0-.52.37c.01-.27.07-.35.03-.41v-.01zm2.86.02a.47.47 0 0 0-.34.15l-.09.12v.72c.15.11.32-.14.14-.33.06 0 .2.12.22.15 0 0 .12-.03.23-.03.1 0 .18.02.25.05v-.83a.44.44 0 0 0-.12.06l-.03.03-.05-.03c-.04-.04-.12-.06-.2-.06zm-1.7.12c-.1.2.14.28.2.38.04.08-.04.21.17.38.67.52.42.36.47.82.03.2.2.3.3.34a.3.3 0 0 1 0-.43c0 .63.86.6 1.03.3-.1.05-.31-.02-.4-.1.35.06.65-.18.67-.47 0-.3-.3-.52-.62-.49.36.06.26.62-.23.52.18-.12.15-.45-.05-.56.06.19-.13.37-.33.2l-.48-.39c-.11-.1-.26-.04-.3-.08-.07-.05-.03-.17-.11-.23-.08-.03-.14-.01-.21-.04-.06-.03-.12-.08-.12-.15zm1.71.78c.1.18.05.34.01.4.12-.01.25-.07.25-.2 0-.18-.22-.2-.26-.2zm-.1 2.26c-3.7 0-3.88 4.96-.02 4.96 3.9 0 3.71-4.96.02-4.96zm11.25.04c-1.03 0-2 .07-2.5.1l.36.42v3.86l-.37.4c.52.05 1.54.11 2.58.11 2.1 0 2.95-1.03 2.95-2.44 0-1.47-1.16-2.45-3.02-2.45zm-28.83.1.42.43v1.47H0l.57.73v1.62l-.42.43c3.09 0 3.7.07 4.32-.3.34-.2.5-.49.5-.88 0-.25.13-.94-.97-1.26.86-.23.81-.9.81-.99 0-1.03-1.2-1.25-1.85-1.25H.15zm8.76 0H5.23l.37.42v3.85l-.37.4h4.06L10 19.8l-3.01.01v-.77l1.16.01v-.01l.7-1.06H6.99v-.74h2.62l-.7-1.05v-.01zm11.83 0 .37.43v3.84l-.36.42h1.95l-.37-.4v-2.38h.02c.18.53 2.22 2.14 2.42 2.78h1.07V16.6l.37-.42h-1.96l.35.41v2.13h-.02c-.27-.72-2.11-2.08-2.26-2.55h-1.58zm-11.18 0 2.2 3.3.01.97-.38.4h2.13l-.36-.4-.01-.95 2.2-3.31h-2.08l.3.36-1.02 1.86h-.02l-1.05-1.86.32-.36H9.56zm-7.63.87c1 0 1.48-.04 1.48.45v.15c0 .61-.95.44-1.48.44v-1.04zm15.8.1c1.83 0 1.93 2.76-.02 2.76-1.87 0-1.84-2.76.01-2.76zm11.03.01c1.17-.03 1.81.37 1.81 1.35 0 1.28-1.07 1.5-2.34 1.35V17.2l.53-.04zm-26.32 1.7c.55 0 1.13.04 1.13.46v.22h.01c0 .56-.63.47-1.65.47v-1.13l.51-.01z',
        'd-and-d' => 'M12.91 5c-.3 0-.63.01-.95.07-1.1.21-1.54.66-1.92.98-.02-.25.05-.5.13-.76A4.48 4.48 0 0 0 8.34 8.1c-.13-.3-.16-.6-.18-.92a3.13 3.13 0 0 0-.55 2.07c.03.9.28 1.71.95 2.37a3.4 3.4 0 0 1 .29-2.33 3.54 3.54 0 0 0 1.87 2.25v-.12a4.5 4.5 0 0 1 .11-1.79.37.37 0 0 0 0-.17c-.14-.7-.02-1.33.47-1.87a1.6 1.6 0 0 1 2.32-.02c.3.31.44.7.49 1.12.07.68-.08 1.31-.44 1.89-.04.06-.04.1 0 .16.47.52-.22-.15 1.63 1.6l.25.24c.37-.46.67-.97.9-1.5.38-.92.58-1.87.35-2.86a3.84 3.84 0 0 0-3.01-3.1 4.8 4.8 0 0 0-.88-.12zm-1.45 4.07a.89.89 0 0 0-.17.29c-.08.23-.16.46-.2.7-.1.53-.11 1.07.03 1.61.03.09.07.14.15.2.41.27.76.61.98 1.07l.1.26c-.15-.17-.28-.33-.42-.47-.48-.46-1.17-.73-2.02-1.3a2.7 2.7 0 0 1-1.03-1.15c-.15.6-.08 1.14.22 1.66a5.73 5.73 0 0 0-1.71-.15c.38.24.72.51.95.9.17.3.13.46-.13.65-.74.5-1.6.8-2.3 1.44h.13c.34-.05.67-.1 1.01-.06.47.05.79.3.85.7a2 2 0 0 1 0 .59c-.03.2-.1.4-.14.61a7.25 7.25 0 0 1 2.7-1.53l-1-.18c.95-1.05 2.8-1.03 3.03-.9-.7.06-1.38.23-2.01.63.68.16.4.09 1.06.27a2.8 2.8 0 0 0-1.4 1.48c.34-.2.72-.27 1.11-.23.93.08 1.46.8 1.08 1.71-.1.23-.24.42-.44.57l.01.03.83-.1c-.13.33-.38.57-.68.77.68.07 1.85-.6 1.96-1.1-.27.01-.66.12-.68-.32 0-.1-.01-.02.12-.79l-.14.12c-.31.21-.48-.13-.4-.41l.25-.82c-.31-.1-.66-.12-1.02-.14a5.3 5.3 0 0 1 2.5-.2c.43.08.18.58-.02.97.44.03.7.03 1 .09.92.18.72 1 .7 1.19.79-.36 1.36-1.66 1.18-2.53-.17.28-.37.51-.7.63 0-.32-.16-.5-.43-.62a.14.14 0 0 1-.05-.08 2 2 0 0 0-.24-1.27 5 5 0 0 0-1.1-1.36c-1.26-1.17-1.93-1.74-2.14-2.73-.04-.16-.04-.32-.06-.5l-.08.14c-.2.41-.24.85-.19 1.3a.7.7 0 0 0 .22.47c.42.38.85.78 1.26 1.18.44.41.83.89 1.05 1.45-.07-.06-.12-.14-.16-.2-.31-.44-.72-.8-1.1-1.16-.5-.46-1-.92-1.47-1.4-.85-.88-.83-1.68-.85-1.98zM23.3 12.6l-.08.01c-.84.14-1.33.67-2.12 1.27-.45.35-.6.17-.51-.02.06-.15.14-.29.22-.43.04-.08.1-.14.15-.22l-.03-.02a6.3 6.3 0 0 0-2.5 3.15l.04.04.04-.07c.45-.52.99-.94 1.59-1.28a6.15 6.15 0 0 1 2.53-.87c.2-.02.38 0 .57 0a5.82 5.82 0 0 0-2.46.84c-1.3.77-2.35 1.81-3.24 3.02l-.03.06c.62.22 1.03.74 1.56 1.1l.01-.02.06-.12a12.58 12.58 0 0 1 2.02-3.2 2.66 2.66 0 0 1 2.7-.86c.26.06.5.2.74.3l.35-.2c.36-.2.75-.3 1.16-.4a4.35 4.35 0 0 1 1.92-.05v-.02l-.07-.06c-.5-.5-1.08-.88-1.74-1.15a3.97 3.97 0 0 0-2.98-.02l-.33.1c-.21.04-.32-.14-.2-.3.13-.2.14-.18.64-.52l.1-.06h-.1zm-9.41 1.26c.5.2.83.56 1.03 1.04-.49.06-.89-.35-1.03-1.04zm-6.47 1.38A9.94 9.94 0 0 0 5 18.86c.32-.25.65-.49 1.02-.7a6.6 6.6 0 0 0-.34 4.35c.2.81.52 1.58 1.05 2.24.12.16.27.3.4.45l.03-.02c-.06-.3-.09-.61-.06-.95l.25.37a5.67 5.67 0 0 0 5.41 1.9c2.38-.42 3.93-2.09 5.02-4.24.05-.08.03-.13-.04-.18-1.7-1.42-.98-.84-1.84-1.53-.04.04 0-.01-.09.13a6.11 6.11 0 0 1-1.9 2.04c-.44.3-.93.51-1.47.51-.94 0-1.65-.4-2.14-1.2a3.42 3.42 0 0 1-.35-2.68c.33-1.45 1.3-2.37 1.67-2.76-.81-.27-1.43.07-2.01.6.03-.6.18-1.13.5-1.61a9 9 0 0 0-2.8 1.89c0-.25.24-1.88.25-1.92a.35.35 0 0 0-.13-.32zm6.31.73c-.21.47-.06.96.32 1.29l.6.48c.2.16.32.37.34.63.02.2.04.41.08.6.1.46.38.8.73 1.09l2.14 1.76c.78.65.6 1.41.57 2.4-.04 1 .52 1.85 1.44 2.21l.16.05c-.68-.79-.44-1.9.03-2.25l.04.27c.4 1.9 1.96 2.76 3.68 2.45a3.75 3.75 0 0 0 1.85-.85c.09-.08.16-.18.26-.28-.84.2-1.55 0-2.2-.46a.2.2 0 0 1 .08-.01c.92.08 1.75-.15 2.46-.75a2.5 2.5 0 0 0 .76-2.83 2.88 2.88 0 0 0-1.9-1.67 2.99 2.99 0 0 0-1.24-.13c.43.17.61.28.82.52.54.62.45 1.49-.24 1.96a2.44 2.44 0 0 1-1.81.36c.12-.16.26-.3.35-.46.4-.73.23-1.81-.38-2.41-.09-.1-.2-.17-.3-.26v.12c.19.72-.35 1.4-1.07 1.37-.33-.01-.6-.16-.85-.37l-2.53-2.07a1.54 1.54 0 0 0-.87-.37l-.6-.04c-.25-.02-.38-.12-.45-.36l-.1-.44c-.06-.35-.26-.56-.61-.61l-.58-.07c-.56-.06-.85-.32-.98-.87z',
        'dashcube' => 'm24.5 3-.31.28L20.47 7H11c-2.75 0-5 2.25-5 5v10c0 2.75 2.25 5 5 5h10c2.75 0 5-2.25 5-5V3ZM24 6.31V22c0 1.67-1.33 3-3 3H11c-1.67 0-3-1.33-3-3V12c0-1.67 1.33-3 3-3h10.31ZM13 12a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h10.4l-1.68-1.72-.72-.72V14a2 2 0 0 0-2-2Zm0 2h6v6h-6Z',
        'database-solid' => 'M6 4v24h20V4Zm2 2h16v5H8Zm0 7h16v6H8Zm0 8h16v5H8Z',
        'deaf-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44-7.84-7.84C23.38 18.2 25 15.2 25 12A8.01 8.01 0 0 0 9.84 8.4ZM17 6a6 6 0 0 1 6 6c0 2.53-1.27 5.03-2.56 7l-6.4-6.4A2.9 2.9 0 0 1 17 10c1.08 0 2.1.59 2.63 1.53l1.71-1A5 5 0 0 0 17 8a4.95 4.95 0 0 0-4.6 2.97l-1.03-1.03A6 6 0 0 1 17 6Zm-5.84 9.34-.16.13V16c0 1.43 1.21 1.98 2.03 2.34.75.34.97.47.97.66 0 .69-1.08 1-2.1 1v2c1.97 0 3.38-.77 3.88-2ZM9 22v1a5 5 0 0 0 5 5c2.9 0 4-1.84 4.88-3.31.2-.35.4-.69.62-1l-1.44-1.44-.06.13c-.32.43-.59.88-.84 1.3C16.32 25.1 15.77 26 14 26a3 3 0 0 1-3-3v-1Z',
        'delicious' => 'M10 5c-2.75 0-5 2.25-5 5v12c0 2.75 2.25 5 5 5h12c2.75 0 5-2.25 5-5V10c0-2.75-2.25-5-5-5Zm0 2h6v9h9v6c0 1.67-1.33 3-3 3h-6v-9H7v-6c0-1.67 1.33-3 3-3Z',
        'democrat-solid' => 'M6.05 5c-.1 0-.18.06-.24.14-.5.76-.59 2.25.28 3.06.14.13.3.21.46.3-.09.07-.2.13-.26.22l-3.03 4.04c-.3.39-.34.92-.12 1.36l.58 1.16c.22.44.67.72 1.16.72h1.26c.35 0 .67-.14.92-.38l1.55-1.4L11 19h14v-3.51c.66.49.84.9 1.73 2.22.2.3.6.38.9.18l1.08-.72c.3-.2.38-.6.18-.91l-.8-1.19C26.95 13.35 25.04 12 22.97 12H13.4L9.94 8.59c1-.96 1.14-2.49.53-3.41a.4.4 0 0 0-.62-.06L8.09 7.44 6.31 5.1a.32.32 0 0 0-.26-.1zm7.52 9a.2.2 0 0 1 .17.1l.38.78.86.13c.15.02.2.21.1.31l-.63.61.15.85a.18.18 0 0 1-.27.2l-.76-.4-.77.4a.18.18 0 0 1-.27-.2l.15-.85-.62-.6a.19.19 0 0 1 .1-.32l.86-.13.38-.78c.03-.07.1-.1.17-.1zm4.38 0a.2.2 0 0 1 .18.1l.38.78.85.13c.15.02.22.21.1.31l-.62.61.14.85a.18.18 0 0 1-.26.2l-.77-.4-.77.4a.18.18 0 0 1-.27-.2l.15-.85-.62-.6a.18.18 0 0 1 .1-.32l.86-.13.38-.78c.04-.07.1-.1.17-.1zm4.48 0a.2.2 0 0 1 .18.1l.38.78.86.13c.14.02.2.21.09.31l-.62.61.15.85a.18.18 0 0 1-.27.2l-.77-.4-.77.4a.18.18 0 0 1-.26-.2l.14-.85-.61-.6a.18.18 0 0 1 .1-.32l.86-.13.38-.78c.03-.07.1-.1.16-.1zM11 21v5.35c0 .36.29.65.65.65h2.7c.36 0 .65-.29.65-.65V23h6v3.35c0 .36.29.65.65.65h2.7c.36 0 .65-.29.65-.65V21H11z',
        'deploydog' => 'M6 6a4 4 0 0 0-4 4v12a4 4 0 0 0 4 4h20a4 4 0 0 0 4-4V10a4 4 0 0 0-4-4H6zm0 2h20a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V10c0-1.1.9-2 2-2zm6 2v4.55a4 4 0 1 0 0 6.9V22h3V10h-3zm10 0v4.55a4 4 0 1 0 0 6.9V22h3V10h-3zm-11.5 6.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zm10 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3z',
        'deskpro' => 'M6.7 5c-.25.01-.7.04-.7.78v9.92c-.17 4.06 3.8 5.3 4.97 5.3h4.24a4 4 0 0 1-1.2-2.49c-.07-.62.88-.7.93-.09 0 .11.25 2.58 2.7 2.58h.29l1.52-2.58.24-.42H23v-7.4c0-1.9-.83-5.61-5.88-5.59h-4.05c.47.5.86 1.15.86 1.99 0 .63-.93.63-.93 0 0-2.12-2.26-2.01-2.46-1.99L10.5 5H6.7zm11.81 7c.93.06 1.77 1.01 1.4 2.3L17 12.97c.37-.72.96-1 1.51-.97zm1.94 7-1.1 2H24c1.8 0 4-1 5-2h-8.55zM19 22c1 1 1.6 1.55 1.6 1.8 0 .09.02 2-1.83 2.88-.53.25-.7.31-1.28.32L16 29c1 0 1.54 0 1.96-.05a5.99 5.99 0 0 0 4.55-3.33c.13-.33.48-1.22.49-3.62h-4z',
        'desktop-solid' => 'M2 6v18h13v2h-5v2h12v-2h-5v-2h13V6Zm2 2h24v14H4Z',
        'dev' => 'M2 7v18h28V7H2zm2 2h24v14H4V9zm2 2v10h3a3 3 0 0 0 3-3v-4a3 3 0 0 0-3-3H6zm10 0a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h2v-2h-2v-2h2v-2h-2v-2h2v-2h-2zm3.7 0 2.08 9.03a1.26 1.26 0 0 0 2.44 0L26.31 11h-2.05L23 16.44 21.74 11H19.7zM8 13h1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8v-6z',
        'deviantart' => 'm18.38 4-.29.31-.4.38-.1.12-.06.13-1.78 3.37-.16.1H8.2v7.5h3.6l-3.5 6.62-.12.22V28h5.44l.28-.31.4-.38.1-.12.06-.13 1.78-3.37.16-.1h7.4v-7.5h-3.6l3.48-6.62.12-.22V4Zm.84 2h2.6v2.78l-3.95 7.47-.28.6.41.5.34.4.29.34h3.18v3.5h-6.03l-.28.2-.6.37-.18.15-.13.22L12.8 26h-2.6v-2.78l3.9-7.47.32-.56-.41-.53-.34-.41-.29-.34H10.2v-3.5h6.03l.25-.2.6-.37.21-.15.13-.22Z',
        'dharmachakra-solid' => 'M16 2.13a1 1 0 0 0-1 1c0 .4.25.75.6.9-3.06.1-5.82 1.34-7.88 3.31.05-.12.1-.23.1-.37a1 1 0 0 0-2 0 1 1 0 0 0 1 1c.13 0 .25-.04.37-.1a11.95 11.95 0 0 0-3.16 7.72 1 1 0 0 0-.9-.59 1 1 0 0 0 0 2 1 1 0 0 0 .9-.6c.1 2.98 1.27 5.68 3.16 7.73a.95.95 0 0 0-.38-.1 1 1 0 0 0 0 2 1 1 0 0 0 1-1 .95.95 0 0 0-.1-.37 11.93 11.93 0 0 0 7.88 3.3 1 1 0 0 0-.59.91 1 1 0 0 0 2 0 1 1 0 0 0-.6-.9c3.06-.1 5.82-1.34 7.88-3.31a.95.95 0 0 0-.1.37 1 1 0 0 0 2 0 1 1 0 0 0-1-1 .95.95 0 0 0-.37.1 11.95 11.95 0 0 0 3.16-7.72 1 1 0 0 0 .9.59 1 1 0 0 0 0-2 1 1 0 0 0-.9.6 11.95 11.95 0 0 0-3.16-7.72c.12.05.24.09.38.09a1 1 0 0 0 0-2 1 1 0 0 0-1 1c0 .14.04.25.1.37a11.93 11.93 0 0 0-7.88-3.3 1 1 0 0 0 .59-.92 1 1 0 0 0-1-1Zm-1.03 3.93H15v6.1c-.38.1-.7.24-1.03.43L9.62 8.3a9.93 9.93 0 0 1 5.35-2.23Zm2.03 0c2.03.2 3.89 1 5.38 2.22l-4.35 4.31c-.32-.2-.66-.34-1.03-.43ZM8.22 9.72 12.56 14a3.8 3.8 0 0 0-.4 1h-6.1c.2-2 .97-3.8 2.16-5.28Zm15.56 0A9.94 9.94 0 0 1 25.94 15h-6.1a3.8 3.8 0 0 0-.4-1ZM16 14c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-9.97 3h6.1c.09.36.24.69.43 1l-4.34 4.25A9.89 9.89 0 0 1 6.03 17Zm13.84 0h6.1c-.2 2-1 3.78-2.19 5.25L19.44 18c.18-.31.34-.64.43-1Zm-5.9 2.4c.32.2.66.35 1.03.44v6.1a9.91 9.91 0 0 1-5.38-2.25Zm4.06 0 4.34 4.29A9.91 9.91 0 0 1 17 25.94v-6.1c.37-.1.71-.25 1.03-.43Z',
        'dhl' => 'm5.63 13-1.02 1.4h5.57c.28 0 .27.1.13.29l-.5.7c-.08.1-.22.28.22.28h2.28l.67-.92c.42-.57.04-1.75-1.45-1.75h-5.9zm9.6 0-1.96 2.67h7.18L22.4 13h-2.93l-1.12 1.53h-1.32L18.17 13h-2.94zm8.14 0-1.96 2.67h3.11L26.48 13h-3.1zM6.25 14.74 4.2 17.53h5a3.54 3.54 0 0 0 2.86-1.51h-3.4c-.44 0-.3-.18-.24-.28l.53-.7c.14-.19.13-.3-.15-.3H6.24zM0 16.02v.32h4.53l.24-.32H0zm13.02 0-1.12 1.5h2.94l1.1-1.5h-2.92zm4.25 0-1.12 1.5h2.94l1.1-1.5h-2.92zm3.88 0-.31.43c-.37.5-.05 1.08 1.15 1.08h4.72l1.11-1.51h-6.67zm7.22 0-.24.32H32v-.32h-3.63zM0 16.6v.32h4.09l.23-.32H0zm27.93 0-.24.32H32v-.32h-4.07zM0 17.2v.32h3.65l.24-.32H0zm27.48 0-.23.32H32v-.32h-4.52z',
        'diagnoses-solid' => 'M16 5c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm0 8h-1.38a5 5 0 0 0-4.33 2.52c.7.08 1.33.46 1.73 1a2.96 2.96 0 0 1 2.6-1.52h2.76c.44 0 .85.09 1.23.26.2-.69.71-1.24 1.35-1.53a4.9 4.9 0 0 0-2.58-.73H16zm0-6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2zm5 8a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-11 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm12.73.81a2.5 2.5 0 0 1-1.73.69l-.16-.01 1.25 2.92.19.47.53.1 5 1 .38-1.95-4.47-.91-.99-2.3zM15 18a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-6.63 1.9-.1.22-4.46.9.38 1.95 5-1 .53-.09.19-.47.4-.93-.31.02c-.62 0-1.2-.23-1.63-.6zM18 21a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM2 25v2h28v-2H2z',
        'diaspora' => 'M12 5v6.14L6.38 9.26 4.15 15.9l5.67 1.9-3.72 5 5.62 4.17 3.67-4.94 3.47 5.07 5.78-3.95-3.6-5.26 5.78-1.87-2.16-6.66L20 11.2 19 5h-7zm2 2h3v6.94l6.38-2.06.92 2.85-6.42 2.08 3.98 5.82-2.48 1.69-3.92-5.74-4.15 5.6-2.41-1.8 4.17-5.61-6.38-2.13.94-2.85L14 14V7z',
        'dice-d20-solid' => 'm16 3.72-.63.5-8.24 6.4-.25.22-.1.32-2.75 10.09-.22.78L16 28.13l12.19-6.1-.22-.78-2.75-10.1-.1-.3-.25-.22-8.25-6.41Zm-1 3.34V10h-3.78Zm2 0L20.78 10H17ZM9.06 12H14l-3.6 4.78ZM18 12h4.94l-1.35 4.78Zm-2 .69L20 18h-8ZM7.81 15l1 3.5-2.25 1.13Zm16.38 0 1.25 4.63-2.25-1.13ZM12 20h8l-4 5.31Zm-2.31.28 2.94 3.9-5.38-2.68Zm12.62 0 2.44 1.22-5.38 2.69Z',
        'dice-d6-solid' => 'M16 2.94 4.66 7.06 4 7.31V22.6l.53.29 11 6 .47.25.47-.25 11-6 .53-.29V7.31l-.66-.25Zm0 2.12 8.38 3.03L16 11.91 7.62 8.09ZM16 7c-1.1 0-2 .45-2 1s.9 1 2 1 2-.45 2-1-.9-1-2-1ZM6 9.53l9 4.1V26.3l-9-4.9Zm20 0v11.88l-9 4.9V13.63ZM12.66 14c-.37 0-.66.36-.66.88 0 .66.36 1.35.88 1.65.14.08.32.06.46.06.23 0 .36-.07.5-.21.08-.15.16-.36.16-.66 0-.67-.45-1.36-.97-1.66-.15-.07-.23-.06-.37-.06Zm7.37 1a.95.95 0 0 0-.25.1c-.6.26-1.12 1.12-1.12 1.9 0 .26-.02.51.15.69.18.17.37.28.63.28.17 0 .35 0 .53-.1A2.25 2.25 0 0 0 21 16.04c0-.6-.26-1.03-.78-1.03h-.19Zm-9.9 1.28c-.38 0-.66.36-.66.88 0 .66.35 1.32.87 1.62.15.08.3.1.44.1a.7.7 0 0 0 .53-.22c.08-.15.16-.4.16-.7a2 2 0 0 0-.97-1.62c-.15-.07-.23-.06-.38-.06Zm13.4 1.16a.65.65 0 0 0-.25.06c-.6.26-1.12 1.16-1.12 1.94 0 .26 0 .5.18.68.18.18.34.25.6.25.17 0 .35.03.53-.06a2.25 2.25 0 0 0 1.03-1.84c0-.61-.26-1.03-.78-1.03h-.19Zm-15.87.97c-.37 0-.66.35-.66.87 0 .67.36 1.36.88 1.66.14.07.32.06.46.06a.6.6 0 0 0 .5-.22c.08-.15.16-.36.16-.66 0-.66-.45-1.35-.97-1.65-.15-.08-.23-.06-.37-.06Z',
        'dice-five-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-5 5a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-5 5a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'dice-four-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zM11 19a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'dice-one-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 7a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'dice-six-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 1a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-10 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-10 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'dice-solid' => 'M12 1 0 13l12 12 12-12L12 1zm0 2.8 9.2 9.2-9.2 9.2L2.8 13 12 3.8zM12 8a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 4a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm10.8 1-2 2H30v12H18v-5.2l-2 2V29h16V13h-5.2zM12 16a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm12 4a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'dice-three-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm5 5a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm5 5a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'dice-two-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 10a2 2 0 0 0 0 4 2 2 0 0 0 0-4z',
        'digg' => 'M9.52 6.99v1.96h2.82s.35 0 .35-.4V6.6h-2.8s-.36 0-.36.4Zm0 4.06v10.6h2.81s.36 0 .36-.4v-10.6H9.9s-.37 0-.37.4ZM5.39 7v3.67H.36s-.36-.01-.36.4v10.58h8.2s.36 0 .36-.4V6.6H5.75s-.36 0-.36.4Zm0 11.9c0 .4-.36.4-.36.4H3.11v-5.9c0-.41.36-.4.36-.4h1.92Zm8.4-7.84v10.6h5.38v1.4h-5.03s-.35 0-.35.4v1.96h8.2s.36 0 .36-.4V10.66h-8.2s-.36-.01-.36.4Zm3.1 2.36c0-.41.36-.4.36-.4h1.93v5.88c0 .4-.36.4-.36.4h-1.93Zm6.9-2.75s-.35-.01-.35.4v10.58h5.38v1.41H23.8s-.36 0-.36.4v1.96h8.2s.36 0 .36-.4V10.66Zm5.04 8.23c0 .4-.36.4-.36.4h-1.92v-5.9c0-.41.36-.4.36-.4h1.92Z',
        'digital-ocean' => 'M16 3C8.83 3 3 8.83 3 16h5a8 8 0 1 1 8 8v5a13.01 13.01 0 0 0 0-26zm0 21v-6h-6v6h6zm-6 0H6v4h4v-4zm-4 0v-3H3v3h3z',
        'digital-tachograph-solid' => 'M4.02 7C2.9 7 2 7.9 2 9.02v13.96C2 24.1 2.9 25 4.02 25h22.96c1.12 0 2.02-.9 2.02-2.02V9.02C29 7.9 28.1 7 26.98 7H4.02zM4 9h23v14H4V9zm2 2v2h10v-2H6zm0 4v2h2v-2H6zm4 0v2h2v-2h-2zm4 0v2h2v-2h-2zm-8 4v2h10v-2H6zm12 0v2h7v-2h-7z',
        'directions-solid' => 'M16 3a3 3 0 0 0-2.13.88l-.12.15-9.72 9.72-.16.13a3.02 3.02 0 0 0 0 4.24l10 10a3.02 3.02 0 0 0 4.26 0l10-10a3.02 3.02 0 0 0 0-4.25l-10-10A3 3 0 0 0 16 3zm0 2a1 1 0 0 1 .72.28l10 10c.4.4.4 1.04 0 1.44l-10 10c-.4.4-1.04.4-1.44 0l-10-10c-.4-.4-.4-1.04 0-1.44l10-10A1 1 0 0 1 16 5zm1 6v3h-4a2 2 0 0 0-2 2v3h2v-3h4v3l4-4-4-4z',
        'discord' => 'm12.66 4.9-.79.1s-3.5.38-6.06 2.44h-.03l-.03.03c-.57.53-.82 1.17-1.22 2.12A34.94 34.94 0 0 0 2 22v.26l.13.25c.92 1.63 2.57 2.66 4.09 3.38 1.52.71 2.84 1.09 3.75 1.12l.6.03.3-.53 1.1-1.94a18.33 18.33 0 0 0 8.06 0l1.1 1.94.3.53.6-.03a10.4 10.4 0 0 0 3.75-1.13c1.52-.71 3.17-1.75 4.1-3.37l.12-.25V22a34.94 34.94 0 0 0-2.53-12.4c-.4-.96-.65-1.6-1.22-2.13l-.03-.03h-.03C23.63 5.38 20.12 5 20.12 5l-.78-.1-.28.72s-.29.74-.47 1.57A20.1 20.1 0 0 0 16 7c-.54 0-1.46.04-2.6.19-.17-.83-.46-1.57-.46-1.57Zm-1.38 2.3.13.37c-1.3.32-2.68.81-3.94 1.6l1.06 1.68C11.13 9.24 14.85 9 16 9c1.15 0 4.88.23 7.47 1.84l1.06-1.68a13.7 13.7 0 0 0-3.94-1.6l.13-.37c.93.18 2.71.61 4.19 1.78-.01 0 .37.58.71 1.4a33.88 33.88 0 0 1 2.34 11.28 7.5 7.5 0 0 1-3.02 2.41c-1.08.5-1.93.69-2.44.78L22 24c.3-.1.59-.23.84-.34a10.2 10.2 0 0 0 2.38-1.41l-1.31-1.5s-.57.52-1.88 1.1A14.91 14.91 0 0 1 16 23c-2.71 0-4.72-.58-6.03-1.16-1.31-.57-1.88-1.09-1.88-1.09l-1.3 1.5s.83.73 2.37 1.4c.25.12.54.24.84.35l-.5.84a9.45 9.45 0 0 1-2.44-.78 7.5 7.5 0 0 1-3.03-2.4 33.88 33.88 0 0 1 2.34-11.29c.35-.82.73-1.4.72-1.4a9.96 9.96 0 0 1 4.2-1.78ZM12.5 14a2.4 2.4 0 0 0-1.88 1 3.29 3.29 0 0 0-.62 2c0 .75.2 1.44.63 2 .41.56 1.1 1 1.87 1a2.4 2.4 0 0 0 1.88-1c.41-.56.62-1.25.62-2s-.2-1.44-.63-2a2.4 2.4 0 0 0-1.87-1Zm7 0a2.4 2.4 0 0 0-1.88 1 3.29 3.29 0 0 0-.62 2c0 .75.2 1.44.63 2 .41.56 1.1 1 1.87 1a2.4 2.4 0 0 0 1.88-1c.41-.56.62-1.25.62-2s-.2-1.44-.63-2a2.4 2.4 0 0 0-1.87-1Zm-7 2c.05 0 .13.02.25.19a1.44 1.44 0 0 1 0 1.62c-.13.17-.2.19-.25.19-.05 0-.13-.02-.25-.19A1.4 1.4 0 0 1 12 17c0-.35.13-.64.25-.81.13-.17.2-.19.25-.19Zm7 0c.05 0 .13.02.25.19a1.44 1.44 0 0 1 0 1.62c-.13.17-.2.19-.25.19-.05 0-.13-.02-.25-.19A1.4 1.4 0 0 1 19 17c0-.35.13-.64.25-.81.13-.17.2-.19.25-.19Z',
        'discourse' => 'M16.1 3C9 3 3 8.72 3 15.77V29l13.1-.01c7.13 0 12.9-5.94 12.9-13C29 8.94 23.23 3 16.1 3zM16 8a8 8 0 1 1-3.9 14.98L8 24l1.12-3.93A8 8 0 0 1 16 8z',
        'divide-solid' => 'M16 6c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1ZM5 15v2h22v-2Zm11 5c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'dizzy-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-6.3 5.3-1.4 1.4 1.79 1.8-1.8 1.8 1.42 1.4 1.79-1.79 1.8 1.8 1.4-1.42-1.79-1.79 1.8-1.8-1.42-1.4-1.79 1.79-1.8-1.8zm9 0-1.4 1.4 1.79 1.8-1.8 1.8 1.42 1.4 1.79-1.79 1.8 1.8 1.4-1.42-1.79-1.79 1.8-1.8-1.42-1.4-1.79 1.79-1.8-1.8zM16 18c-2.2 0-4 1.53-4 3.4 0 1.73 1.35 2.6 4 2.6s4-.87 4-2.6c0-1.87-1.8-3.4-4-3.4zm0 2c1.08 0 2 .64 2 1.4 0 .16 0 .6-2 .6s-2-.44-2-.6c0-.76.92-1.4 2-1.4z',
        'dizzy' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-6.3 5.3-1.4 1.4 1.79 1.8-1.8 1.8 1.42 1.4 1.79-1.79 1.8 1.8 1.4-1.42-1.79-1.79 1.8-1.8-1.42-1.4-1.79 1.79-1.8-1.8zm9 0-1.4 1.4 1.79 1.8-1.8 1.8 1.42 1.4 1.79-1.79 1.8 1.8 1.4-1.42-1.79-1.79 1.8-1.8-1.42-1.4-1.79 1.79-1.8-1.8zM16 18c-2.2 0-4 1.53-4 3.4 0 1.73 1.35 2.6 4 2.6s4-.87 4-2.6c0-1.87-1.8-3.4-4-3.4zm0 2c1.08 0 2 .64 2 1.4 0 .16 0 .6-2 .6s-2-.44-2-.6c0-.76.92-1.4 2-1.4z',
        'dna-solid' => 'M6 5c0 3.02 1.28 5.38 3.1 7.22A26.6 26.6 0 0 0 14.05 16C9.9 18.63 6 21.51 6 27h2c0-4.7 3.78-7.26 7.97-9.84 1 .61 1.97 1.2 2.87 1.84H15.2c-1 .6-1.89 1.3-2.78 2h8.9l.16.16c.57.57 1.07 1.19 1.47 1.84H10.59c-.5.6-.79 1.3-1.09 2h14.25c.16.62.25 1.27.25 2h2c0-3.02-1.28-5.38-3.1-7.22-1.8-1.84-4.12-3.25-6.37-4.62-2.25-1.38-4.44-2.72-6-4.32A7.9 7.9 0 0 1 8 5Zm18 0c0 .72-.12 1.38-.28 2H9.5c.3.7.6 1.4 1.1 2h12.28c-.44.72-1 1.38-1.63 2h-8.84c.9.7 1.78 1.4 2.78 2h3.69c-.6.44-1.24.88-1.88 1.31.6.4 1.21.7 1.81 1.1C22.61 12.9 26 10 26 5Z',
        'dochub' => 'M19 3.59V12h8.41L19 3.59zM7 4v24h11a8 8 0 0 0 8-8v-6h-6v4.94A3.07 3.07 0 0 1 16.94 22H13V10h4V4H7zm2 2h6v2h-4v16h5.94A5.07 5.07 0 0 0 22 18.94V16h2v4a6 6 0 0 1-6 6H9V6zm12 2.41L22.59 10H21V8.41z',
        'docker' => 'M12 6v3H6v3H3v3h-.94a1 1 0 0 0-.78.4s-.08.11-.12.2c-.04.08-.07.2-.1.3-.06.22-.1.46-.1.82 0 .69.1 1.45.29 2.22L1 19h.28c.2.77.52 1.55.97 2.31l.03.07v.03c.06.24.2.45.4.59l.04.03c.17.24.33.47.53.69 1.64 1.88 4.28 3.31 8.03 3.31 5.77 0 10.76-2.37 13.75-7.03h5.06c-.63-.16-2-.4-1.78-1.22-.7.81-1.99.98-3.06.84.35-.58.68-1.19.97-1.84a5.72 5.72 0 0 0 3.62-1.34c.82-.79 1.07-1.69 1.07-1.69a1 1 0 0 0-.32-1.03s-1.5-1.06-3.68-.85a6.38 6.38 0 0 0-2.32-2.96 1 1 0 0 0-.68-.13.99.99 0 0 0-.44.22s-.46.4-.81 1.06a5.12 5.12 0 0 0-.57 2.9c.05.47.33.88.5 1.32-.12.08-.24.17-.4.25-.5.25-1.2.47-2.1.47H20v-3h-3V6Zm2 2h1v1h-1Zm-6 3h1v1H8Zm3 0h1v1h-1Zm3 0h1v1h-1Zm10.34.31c.36.4.75.98.91 1.81.05.28.21.52.45.67a1 1 0 0 0 .8.12c.9-.25 1.57-.17 2.03-.04-.05.07-.02.06-.1.13-.45.44-1.22.93-2.8.88a1 1 0 0 0-.97.62 14.94 14.94 0 0 1-1.6 3c-1.47.57-4.76.15-5.03-.6-.98 1.15-3.99 1.15-4.97 0-.31.89-4.87 1.3-5.65.16-.63.59-2.92.98-4.22.1-.08-.4-.14-.8-.16-1.16H20.1a6.72 6.72 0 0 0 4.2-1.44c.24-.14.4-.39.46-.67a.99.99 0 0 0-.19-.8 2.47 2.47 0 0 1-.47-1.3c-.06-.71.1-1.12.25-1.48ZM5 14h1v1H5Zm3 0h1v1H8Zm3 0h1v1h-1Zm3 0h1v1h-1Zm3 0h1v1h-1ZM3.4 19h19.3c-2.64 3.4-6.62 5.03-11.4 5.03-2.52 0-4.28-.67-5.54-1.66 2.13-.07 3.66-.62 3.66-.62a1 1 0 1 0-.5-1.94l-.16.07s-2.2.71-4.78.4A7.07 7.07 0 0 1 3.4 19Zm7.32.19a.6.6 0 0 0-.6.6c0 .31.28.59.6.59.32 0 .56-.28.56-.6 0-.08 0-.15-.03-.22a.25.25 0 0 1-.22.13c-.13 0-.22-.12-.22-.25 0-.1.03-.15.1-.19-.07-.03-.12-.06-.2-.06Z',
        'dog-solid' => 'm20.31 3-.25.66L17.31 11H9.63a4.6 4.6 0 0 0-2.5.72L4.71 9.28l-1.44 1.44 2.44 2.4a4.63 4.63 0 0 0-.47 4l.72 2.1-.94 3.53-.03.13V28h2v-4.88l.97-3.65.06-.31-.1-.29-.8-2.4a2.68 2.68 0 0 1-.13-.84A2.6 2.6 0 0 1 9.63 13h8.03L21 16.28v-2.81l-1.81-1.78 2.06-5.53.25.37.28.47h1.88l3.06 2.31-.84 1.69H22v5.88l-.94 2.8-.06.16v3.29l1 4V28h2v-1.13l-1-4v-2.75l.94-2.8.06-.16V13h3.13l2.15-4.31-.69-.5L24.34 5h-1.43l-.97-1.53-.28-.47Zm-10.1 15L9 22.88V28h2v-4.88l.78-3.12h.94c.35.23 1.6 1 3.28 1h1v2.13l1 4V28h2v-1.13l-1-4V19h-3a5.96 5.96 0 0 1-2.44-.84l-.25-.16Z',
        'dollar-sign-solid' => 'M15 3v2.1a6 6 0 0 0-5 5.9c0 1.78.83 3.15 1.94 4.03 1.1.88 2.44 1.38 3.69 1.88 1.24.5 2.41 1 3.18 1.62A2.78 2.78 0 0 1 20 21c0 2.16-1.8 4-4 4-2.22 0-4-1.78-4-4v-1h-2v1a6 6 0 0 0 5 5.9V29h2v-2.1c2.84-.47 5-2.97 5-5.9 0-1.78-.83-3.14-1.94-4.03-1.1-.89-2.43-1.4-3.68-1.9s-2.42-.99-3.2-1.6A2.79 2.79 0 0 1 12 11a4 4 0 0 1 8 0v1h2v-1a6 6 0 0 0-5-5.9V3Z',
        'dolly-flatbed-solid' => 'M19 6c-1.64 0-3 1.36-3 3h-6v12h18V9h-6c0-1.64-1.36-3-3-3ZM4 7v2h1a1 1 0 0 1 1 1v11a4 4 0 0 0 4 4h18v-2H10c-1.2 0-2-.8-2-2V10c0-1.64-1.36-3-3-3Zm20.5 18a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-12 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM19 8a1 1 0 0 1 1 1h-2a1 1 0 0 1 1-1Zm-7 3h14v8H12Z',
        'dolly-solid' => 'm18.6 1.66-.94.34-5.54 2.03-.93.34.34.94 1.69 4.57.34.93.94-.34 5.53-2.03.94-.35-.34-.93-1.7-4.57ZM8.6 3l-.94.34L5 4.31l.66 1.88 1.75-.63 6.65 17.78.35.94.93-.34 10.63-4-.69-1.88-9.69 3.66L8.94 3.94Zm8.8 1.22 1 2.69-3.65 1.34-1-2.69Zm4.38 5.69-.94.34-5.53 2.03-.94.35.35.93 1.69 4.56.34.94.94-.34 5.53-2.03.94-.35-.35-.96-1.68-4.54Zm-1.19 2.56 1 2.69-3.65 1.34-1-2.69ZM11 21c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 6H5v2h22v-2Zm0-4c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'donate-solid' => 'M16 3a10.01 10.01 0 0 0 0 20 10.01 10.01 0 0 0 0-20zm0 2a8 8 0 0 1 0 16 8 8 0 0 1 0-16zm-1 2v1.19a3.08 3.08 0 0 0-1.85 1.89 2.92 2.92 0 0 0 .37 2.59A3.06 3.06 0 0 0 16 14c.14 0 .28.03.4.08a.96.96 0 0 1 .52.52c.05.12.08.26.08.4a.98.98 0 0 1-1 1c-.14 0-.28-.03-.4-.08A1 1 0 0 1 15 15h-2a2.94 2.94 0 0 0 1.58 2.62l.42.2V19h2v-1.19a3.02 3.02 0 0 0 1.94-3.41 2.95 2.95 0 0 0-1.27-1.88A3.03 3.03 0 0 0 16 12c-.14 0-.28-.03-.4-.08a.96.96 0 0 1-.52-.52 1.04 1.04 0 0 1 .2-1.11A1.04 1.04 0 0 1 16 10a.98.98 0 0 1 1.01 1h2a2.94 2.94 0 0 0-.15-.92A3.05 3.05 0 0 0 17 8.18V7h-2zM2 21v8h2v-6h5.38a12.1 12.1 0 0 1-2.3-2H2zm22.92 0a12.1 12.1 0 0 1-2.3 2H28v6h2v-8h-5.08zM6 25v2h20v-2H6z',
        'door-closed-solid' => 'M8 5v22h16V5Zm2 2h12v18H10Zm10 8a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'door-open-solid' => 'm15.88 4-.1.03-8 1.88-.78.18v20.25l.81.13 8 1.5.1.03H18V4ZM20 6v2h3v16h-3v2h5V6Zm-4 .03V26l-7-1.31V7.66ZM14.34 15c-.36 0-.68.45-.68 1s.32 1 .68 1c.37 0 .66-.45.66-1s-.29-1-.66-1Z',
        'dot-circle-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 7a3 3 0 1 0 0 6 3 3 0 0 0 0-6Z',
        'dot-circle' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 7a3 3 0 1 0 0 6 3 3 0 0 0 0-6Z',
        'dove-solid' => 'm9.84 1.66-1.16.4c-1.62.53-2.7 1.25-3.34 2.14a3.58 3.58 0 0 0-.57 2.75c.15.74.49 1.33.8 1.8-.28.18-.35.12-.65.42a4 4 0 0 0-.87 4.15 3.86 3.86 0 0 0 2.38 2.42c.24.08.25.03.46.07-.06.35-.13.4-.12.88a4.19 4.19 0 0 0 1.81 3.52c.74.48 1.56.72 2.37.85l-5.53 7.38 1.2.49c5.48 2.19 11.7.02 11.7.02l.68-.23v-3.85a12.8 12.8 0 0 0 3.2-.89c2.12-.88 4.5-2.7 4.8-5.89.1-1.24-.18-2.54-.47-3.6-.07-.28-.08-.26-.16-.49h3.29l-.78-1.47-.8-1.59c.79-1.74.22-3.64-1.22-4.44-.4-.22-.85-.36-1.32-.4-1.42-.12-3.06.6-4.34 2.3l-.97 1.17a5.6 5.6 0 0 1-.3-.7A15.92 15.92 0 0 1 19 3V2h-1c-1.17 0-2.1.3-2.78.84a3.5 3.5 0 0 0-1.19 1.92c-.23.9-.08 1.27 0 1.7-.35.17-.6.2-1.11.7-.3.31-.59.71-.8 1.2A11.91 11.91 0 0 1 10 2.87Zm7.27 2.58c.12 2.37.5 4.22.96 5.38.29.7.59 1.22.83 1.57l-1.42 1.69a14.95 14.95 0 0 1-3.6-2.53c-.22-.92.06-1.38.45-1.77.44-.44.99-.63.99-.63l.88-.3-.23-.9s-.17-.81 0-1.5c.09-.36.23-.63.5-.84.1-.1.45-.1.64-.17Zm-8.77.3a14.33 14.33 0 0 0 3.7 6.7l.01.08.04-.02a17.33 17.33 0 0 0 4.5 3.35l1.17 1s4.08-4.77 5.04-6.05c1.3-1.73 2.45-1.7 3.1-1.35.63.36 1.01 1.08.27 2.2l-.3.44.2.5c.09.2.18.34.32.61h-2.86l.54 1.36s.27.71.54 1.66c.25.94.46 2.14.4 2.89-.22 2.3-1.83 3.5-3.58 4.23-1.76.74-3.5.86-3.5.86l-.93.06v4.13c-.86.25-4.48 1.11-8.27.17l4.64-6.19a15.7 15.7 0 0 0 1.82-.19l-.38-1.96s-.86.16-1.98.17a6.33 6.33 0 0 1-3.16-.65c-.72-.47-.9-1.15-.9-1.88-.02-.74.18-1.34.18-1.34l.46-1.4-1.46.08s-.39.02-.85-.14a1.7 1.7 0 0 1-1.15-1.18c-.4-1.18-.06-1.66.38-2.1.44-.44.99-.63.99-.63l1.53-.51-1.14-1.15s-.81-.89-.98-1.74c-.09-.42-.06-.76.24-1.19.18-.24.88-.54 1.37-.82Z',
        'download-solid' => 'M15 4v16.56l-5.28-5.28-1.44 1.44 7 7 .72.69.72-.7 7-7-1.44-1.43L17 20.56V4ZM7 26v2h18v-2Z',
        'draft2digital' => 'M15.77 5.05c-2.51.01-4.77.79-6.37 2.04a5.33 5.33 0 0 0-2.35 3.74v.02a3.5 3.5 0 1 0 4.68-2.62c.26-.05.53-.09.82-.09 1.9 0 3.45 1.51 3.45 3.36 0 2.79-4.71 7.19-10.68 12.77L3.47 26H23v3l7-4-7-4v3h-5.85C21.31 19.6 24 16.43 24 11.84c0-3.86-3.51-6.77-8.18-6.79h-.05zm-.18 2h.2c3.54.01 6.21 2.06 6.21 4.79 0 4.16-2.76 7.06-7.33 11.86l-.28.3H8.53C14.6 18.27 18 14.68 18 11.5c0-1.85-.96-3.48-2.41-4.45zM10.5 10A1.5 1.5 0 1 1 9 11.5c0-.11.02-.21.03-.31.15-.68.75-1.19 1.47-1.19zM25 24.45l.97.55-.97.55v-1.1z',
        'drafting-compass-solid' => 'M15 3v3.16c-1.72.44-3 1.99-3 3.84a4 4 0 0 0 1.1 2.72L9.74 20H6v2h2.81l-2.84 6.19 1.81.84L11.03 22H15v2h2v-2h3.97l3.22 7.03 1.81-.81L23.16 22H26v-2h-3.75l-3.34-7.31A3.95 3.95 0 0 0 20 10c0-1.85-1.28-3.4-3-3.84V3Zm1 5c1.12 0 2 .88 2 2a2 2 0 0 1-.63 1.47l-.03.03-1 .44 3.7 8.06H17v-2h-2v2h-3.06l3.69-8-1-.47.03-.03c-.42-.37-.66-.9-.66-1.5 0-1.12.88-2 2-2Z',
        'dragon-solid' => 'M8 3v6l-5 1.5L6.5 14 4 19h5v10h2v-9.15c1.3.56 2.66 1.14 5 2.07V22c0 2.23.7 4.05 1.98 5.25A7.15 7.15 0 0 0 23 29v-2a5.2 5.2 0 0 1-3.65-1.2 4.56 4.56 0 0 1-1.32-3.07c1.32.5 2.5.92 3.32 1.14.29.08.58.11.87.11a4.13 4.13 0 0 0 3.91-3.3L27 16l-3 2c-4.69 0-5.8-3-5.8-3a3.91 3.91 0 0 1 1.92-1.88L21 14v-1.26l.56-.18L23 14v-1.78l.18-.04L25 14v-2l3 2V9.15c0-1.47-1-2.83-2.45-3.1a2.97 2.97 0 0 0-2.6.8L21.5 3 20 7h-6Zm2 3.73 2.9 1.93.5.34h10.27l.6-.66a1 1 0 0 1 .92-.32c.45.08.81.58.81 1.13V10h-1.03c-.7.01-6.94.23-8.61 4.23l-.3.72.26.74C16.92 17.3 19.2 20 24 20h.23l-.07.34a2.12 2.12 0 0 1-1.94 1.64c-.12 0-.24-.01-.35-.04C18.8 21.1 9.9 17.2 9.8 17.17L9.42 17H7.23l1.06-2.1.64-1.3-2.15-2.15 1.8-.53 1.42-.43ZM13 10s.23 2 2 2 3-2 3-2Z',
        'draw-polygon-solid' => 'M14 4a2 2 0 0 0-2 2v.06L6.94 9.25A2 2 0 0 0 6 9a2 2 0 0 0-1 3.72v11.56A2 2 0 1 0 7.72 27h12.56A2 2 0 0 0 24 26c0-.4-.1-.78-.31-1.1l2.43-4.9a2 2 0 0 0 .25-3.97l-1.9-5.72c.32-.35.53-.8.53-1.31a2 2 0 0 0-2-2c-.51 0-.96.21-1.31.53L15.97 5.6c-.19-.9-1-1.6-1.97-1.6Zm1.31 3.5 5.72 1.88a2 2 0 0 0 1.6 1.59l1.9 5.69a2 2 0 0 0-.19 2.46L21.88 24c-.7.04-1.27.44-1.6 1H7.72c-.18-.3-.42-.54-.72-.72V12.72c.6-.35 1-.98 1-1.72v-.06l5.06-3.19A2 2 0 0 0 14 8c.5 0 .96-.2 1.31-.5Z',
        'dribbble-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9.25 1c-2.13 0-2.13 5.5-2.13 5.56 0 .64.03 1.25.07 1.81-.3-.1-.64-.18-1-.18C11 15.19 10 17.04 10 19c0 1.85 1.04 4 3.4 4 1.12 0 2.09-.71 2.85-1.78.67.68 1.35.94 1.88.94 1.66 0 2.76-2.9 3.15-4.16a.78.78 0 0 0-.5-.97c-.4-.13-.8.1-.94.5-.46 1.47-1.33 3.02-1.71 3.1-.29 0-.68-.25-1.1-.82.95-2 1.44-4.48 1.44-6.15 0-4.68-1.21-5.66-2.22-5.66zm.06 1.63c.24.35.66 1.48.66 4.03 0 1.35-.33 2.93-.81 4.3a15.85 15.85 0 0 1-.54-4.4 10 10 0 0 1 .7-3.94zm-3.4 7.09c.09-.02.18 0 .28 0 .64 0 1.12.47 1.12.47.03.04.08.1.13.12.2 1.06.52 1.9.87 2.57-.57.97-1.24 1.6-1.9 1.6-1.71 0-1.88-1.54-1.88-2.2 0-.1.02-2.3 1.38-2.56z',
        'dribbble' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c2.54 0 4.83.95 6.6 2.5-.2.26-.45.58-.85.97a12.3 12.3 0 0 1-4.31 2.6 47.69 47.69 0 0 0-3.72-5.82C14.45 6.08 15.22 6 16 6Zm-4.25.94a46.68 46.68 0 0 1 3.75 5.72 38.35 38.35 0 0 1-9.28 1.21 9.98 9.98 0 0 1 5.53-6.93Zm12.22 3.03A9.99 9.99 0 0 1 26 15.75c-.9-.2-2.2-.4-3.9-.4-.9-.01-1.9.05-2.98.18-.25-.57-.51-1.12-.78-1.65a14 14 0 0 0 4.79-2.97c.34-.34.6-.65.84-.94Zm-7.56 4.5c.23.46.46.94.68 1.44-4.27 1.18-7.34 4.8-8.65 6.62A9.96 9.96 0 0 1 6 16v-.13c1.35.02 5.65-.07 10.4-1.4Zm5.68 2.84c1.79 0 3.02.25 3.75.44a9.93 9.93 0 0 1-4.09 6.44 35.5 35.5 0 0 0-1.84-6.75c.79-.08 1.53-.13 2.18-.13Zm-4.21.47a33.2 33.2 0 0 1 2.03 7.44 10.06 10.06 0 0 1-10-1.28c1.02-1.4 4.04-5.15 7.96-6.16Z',
        'dropbox' => 'm11.78 4.47-.62.4-6.7 4.32-1.21.78 1.16.87 3.5 2.66-3.5 2.66-1.22.9 1.31.75 3.63 2.13v3.34l.43.28 6.88 4.53.56.38.56-.38 6.88-4.46.43-.32v-3.34l3.63-2.16 1.22-.72-1.06-.9-3.35-2.85 3.32-2.71 1.09-.88L27.53 9l-6.5-4.13-.62-.37-.57.47L16 8.13l-3.66-3.16Zm8.81 2.47 4.72 3.03-2.65 2.15-4.91-2.84Zm-9 .03 2.75 2.34-4.71 3-2.91-2.22ZM16 10.63l4.81 2.74-4.81 3-4.53-2.84Zm6.66 3.93 2.62 2.25-2.81 1.69a.9.9 0 0 0-.25.16l-1.75 1.03-2.72-2.07Zm-13.04.16 4.63 2.9-2.63 2.07-4.84-2.85Zm6.41 4.1 3.75 2.87.56.4.57-.34.96-.6v1.07L16 26.06l-5.88-3.87v-1.07l1.07.63.6.34.52-.4Z',
        'drum-solid' => 'm27.19 5.1-11.07 5.24a2 2 0 1 0 .88 1.81l6.06-2.87C24.88 10.05 26 11.05 26 12c0 1.89-4.28 4-10 4S6 13.89 6 12c0-1.89 4.28-4 10-4h.5l3.53-1.66C18.78 6.14 17.43 6 16 6 9.16 6 4 8.58 4 12v10c0 .99.45 1.9 1.13 2.63.67.73 1.6 1.32 2.68 1.8A19.8 19.8 0 0 0 16 28c3.16 0 6.02-.58 8.19-1.56 1.08-.5 2-1.08 2.68-1.82A3.88 3.88 0 0 0 28 22V12c0-1.48-.98-2.79-2.63-3.81l2.66-1.28ZM6 15.4a12 12 0 0 0 4 1.85v7.9c-.5-.15-.96-.33-1.38-.52-.9-.42-1.6-.92-2.03-1.38C6.16 22.79 6 22.39 6 22Zm20 0V22c0 .4-.16.79-.6 1.25-.43.46-1.12.96-2.02 1.38-.42.19-.88.37-1.38.53v-7.91a12 12 0 0 0 4-1.84Zm-14 2.3a25.17 25.17 0 0 0 8 0v7.93a21.78 21.78 0 0 1-8 0Z',
        'drum-steelpan-solid' => 'M16 6C8.82 6 3 8.46 3 11.5v9C3 23.54 8.82 26 16 26s13-2.46 13-5.5v-9C29 8.46 23.18 6 16 6zm0 2c.9 0 1.73.04 2.52.1l.48.06v.44c0 1.32-1.35 2.4-3 2.4s-3-1.08-3-2.4v-.44c.93-.1 1.92-.16 3-.16zm-3.1.17-.97.13.4-.06.57-.07zm6.2 0 .57.07.4.06c-.31-.05-.63-.1-.97-.13zm-7.58.2c-.17.02-.34.06-.5.1l.25-.07.25-.04zm8.96 0 .25.03c.1.02.17.05.26.06l-.51-.1zm-9.96.2 1.04 1.81a3.18 3.18 0 0 1-.77 4.1C7.02 13.72 5 12.24 5 11.5a.5.5 0 0 1 .04-.2c.31-.76 2.21-2 5.48-2.72zm10.96 0c3.59.8 5.52 2.22 5.52 2.93 0 .73-2.02 2.2-5.8 2.99a3.22 3.22 0 0 1-.78-4.1l1.06-1.81zM16 13c1.31 0 2.4.78 2.78 1.86a27.22 27.22 0 0 1-5.56 0A2.9 2.9 0 0 1 16 13zM5 14.42C7.3 15.97 11.36 17 16 17s8.7-1.03 11-2.58v6.08c0 1.02-3.86 3.5-11 3.5-7.14 0-11-2.48-11-3.5v-6.08zm6.11.14zm9.78 0z',
        'drumstick-bite-solid' => 'M19.65 4a8.3 8.3 0 0 0-5.9 2.45C12.17 8 10.32 12.4 8.26 19.48l-1.6 1.6a3 3 0 0 0-1.55 5.8 3 3 0 0 0 5.8-1.56l1.6-1.6c1.76-.5 4.26-1.28 6.6-2.14l1.15-.43-.65-1.04a3.99 3.99 0 0 1 6.3-4.83l1.16 1.25.52-1.63A8.32 8.32 0 0 0 19.65 4zm0 2a6.33 6.33 0 0 1 6.33 6.8 6 6 0 0 0-8.6 7.28c-1.6.56-3.13 1.04-4.47 1.44l-2.43-2.43c1.78-5.95 3.47-10.02 4.68-11.23A6.34 6.34 0 0 1 19.65 6zM9.57 21 11 22.43l-2.46 2.46.35.66c.08.15.12.3.12.46a1 1 0 0 1-2 0v-1H6a1 1 0 0 1 0-2 1 1 0 0 1 .46.12l.65.35 2.46-2.46z',
        'drupal' => 'm14.53 2.78-.5 2.28s-.12.57-.4 1.19c-.29.62-.77 1.18-1.04 1.28v.03A10.99 10.99 0 1 0 27 18c0-5.3-3.77-9.75-8.78-10.78-.09-.02-.9-.58-1.44-1.22-.55-.64-.94-1.25-.94-1.25Zm.78 4.56c.64.74 1.33 1.6 2.5 1.85a9 9 0 0 1 6.47 12.31c.24-.64.34-1.36.34-1.81 0-.66-.28-1.75-1.34-1.75-1 0-3.03 2.07-4.1 2.1-1.24.01-2.98-2.47-5.46-2.45-1.95.03-3.48 1.57-3.5 3.22-.02.94.3 1.62.94 2.07.42.27.79.46 2.06.46 2.1 0 4.77-2.6 6-2.56.98.04 2.52 2.4 3.28 2.47.6.04.9-.23 1.4-.97A8.98 8.98 0 0 1 7 18c0-4.03 2.62-7.4 6.25-8.56l.03-.03h.03a3.74 3.74 0 0 0 2-2.07Zm3 14.91c-.13.01-.29.05-.47.13a3.5 3.5 0 0 0-.96.68c-.24.21-.29.4-.16.57.13.17.26.07.62-.22.36-.3.57-.57 1.32-.57.74 0 .88.29 1.03.57.15.27.16.3.31.21.17-.08.27-.19.19-.4-.09-.21-.25-.61-.5-.78-.26-.17-.6-.19-.94-.19h-.44Zm2.19 2.28a4.9 4.9 0 0 1-2.88.75c-1.35 0-1.98-.28-2.4-.62-.06-.05-.03-.04-.16-.04s-.24.08-.34.16a.3.3 0 0 0 0 .44c.93.85 2.48.8 3.62.69 1.15-.1 2.15-.8 2.25-.91.15-.15.09-.26.07-.34-.02-.07-.05-.15-.16-.13Z',
        'dumbbell-solid' => 'M21.31 3.5a2.92 2.92 0 0 0-2.88 2.22c-.2-.04-.4-.1-.62-.1-.76 0-1.54.27-2.12.85a3 3 0 0 0 0 4.22l.84.84-5 5-.84-.84a2.95 2.95 0 0 0-2.1-.88c-.76 0-1.54.3-2.12.88a3 3 0 0 0-.78 2.78 2.8 2.8 0 0 0-1.32.72 3 3 0 0 0 0 4.22l.04.03 1.34 1.37-.69.69 1.44 1.44.69-.69 1.4 1.38a2.95 2.95 0 0 0 4.97-1.31c.96.2 2.01-.05 2.75-.79a3 3 0 0 0 0-4.22l-.84-.84 5-5 .84.84a3 3 0 0 0 4.22 0 3 3 0 0 0 .78-2.75c.49-.13.94-.37 1.32-.75a3 3 0 0 0 0-4.22l-1.38-1.4.69-.69-1.44-1.44-.69.69-1.4-1.38a2.95 2.95 0 0 0-2.1-.87Zm0 2c.25 0 .5.09.69.28L26.22 10c.4.4.39.98 0 1.38a.98.98 0 0 1-1.4 0l-4.2-4.2a.99.99 0 0 1 0-1.4c.2-.2.44-.28.7-.28Zm-3.5 2.1c.25 0 .5.11.69.3l5.6 5.6a1 1 0 0 1 0 1.4c-.4.4-.99.37-1.38-.03h-.03l-5.6-5.59c-.39-.39-.36-.98.04-1.37.19-.19.44-.32.68-.32Zm.13 5.34 1.12 1.12-5 5-1.12-1.12ZM8.59 16.8c.25 0 .5.12.7.32h.02l5.6 5.59c.39.39.36.98-.04 1.37a.97.97 0 0 1-1.37 0l-.69-.68-.12-.1-4.1-4.12-.68-.69a.99.99 0 0 1 0-1.4c.2-.2.43-.29.68-.29Zm-2.12 3.5c.25 0 .52.12.72.32l4.18 4.18c.4.4.4 1.01 0 1.4-.39.4-.98.4-1.37 0L5.78 22a.95.95 0 0 1 0-1.38 1 1 0 0 1 .69-.3Z',
        'dumpster-fire-solid' => 'm5 6-2 8h1.33l.34 2H3v2h2l1 6v2h2v-2h11.64c.3-.73.67-1.4 1.07-2H7.69l-1.33-8h19.28l-.54 3.26 1.45-1.11s2.1 1.73 2.22 1.85H29v-2h-1.67l.34-2H29l-2-8H5zm1.56 2h2.78l-.77 4h-3l1-4zm4.83 0H15v4h-4.37l.76-4zM17 8h3.6l.77 4H17V8zm5.66 0h2.78l1 4h-3.01l-.77-4zm3.87 10.66-.65.56s-1.22.98-2.4 2.41C22.27 23.06 21 24.96 21 27.1c0 1.51.63 2.82 1.66 3.68a5.89 5.89 0 0 0 3.84 1.32c1.45 0 2.82-.45 3.84-1.32A4.73 4.73 0 0 0 32 27.1c0-1.99-1.3-3.81-2.47-5.28a27 27 0 0 0-2.34-2.57l-.66-.59zm-.06 2.78c.4.38.75.7 1.5 1.63C29.04 24.41 30 26.13 30 27.1c0 .98-.37 1.68-.97 2.18-.18.16-.39.3-.62.41.05-.19.09-.39.09-.59 0-2.95-1.56-4.69-1.56-4.69s.05 2.63-.75 2.63c-.55 0-1.1-.85-1.1-.85s-.59 1.26-.59 2.91c0 .2.04.4.09.6a2.67 2.67 0 0 1-.62-.42c-.6-.5-.97-1.2-.97-2.18 0-1.26.97-2.92 2.03-4.19.73-.87 1.06-1.13 1.44-1.47z',
        'dumpster-solid' => 'm5 6-2 8h1.33l.34 2H3v2h2l1 6v2h2v-2h16v2h2v-2l1-6h2v-2h-1.67l.34-2H29l-2-8H5zm1.56 2h2.78l-.77 4h-3l1-4zm4.83 0H15v4h-4.37l.76-4zM17 8h3.6l.77 4H17V8zm5.66 0h2.78l1 4h-3.01l-.77-4zm-16.3 6h19.28l-1.33 8H7.69l-1.33-8z',
        'dungeon-solid' => 'M16 5c-1.04 0-2.04.15-3 .43l1.45 3.75a6.97 6.97 0 0 1 3.1 0L19 5.43A10.9 10.9 0 0 0 16 5zm-4.86 1.15A11.1 11.1 0 0 0 7.31 9.3l3.39 2.15.3-.32v.01a.4.4 0 0 1 .13-.13h-.02a7 7 0 0 1 1.47-1.1l-1.44-3.75zm9.72 0L19.42 9.9c.54.3 1.02.67 1.46 1.1h-.01c.05.03.1.08.13.13v-.01c.17.17.33.34.47.53l3.47-2.02a11.1 11.1 0 0 0-4.08-3.48zM6.23 10.97A10.9 10.9 0 0 0 5 16h4c0-1.02.23-2 .62-2.87l-3.39-2.16zM16 11c-.34 0-.68.03-1 .1V25h2V11.1c-.32-.07-.66-.1-1-.1zm9.95.35-3.47 2.03c.33.8.52 1.7.52 2.62h4c0-1.66-.38-3.23-1.05-4.65zM13 12c-1.21.91-2 2.37-2 4v9h2V12zm6 0v13h2v-9c0-1.63-.79-3.09-2-4zM5 18v4h4v-4H5zm18 0v4h4v-4h-4zM5 24v3h4v-3H5zm18 0v3h4v-3h-4z',
        'dyalog' => 'M6 5v7h2V7h7a9.01 9.01 0 0 1 0 18H6v2h9a11 11 0 0 0 0-22H6z',
        'earlybirds' => 'M14.85 4a1.7 1.7 0 0 0 .12 1.96 7.02 7.02 0 0 0-3.92 2.33c-1.95.07-4.1.14-4.39 1.67-.13.03-.56.04-.62.13-.01.02-.1.39-.11.74.02.68.32 1.24 1.14 1.12.22 1.17.08 1.98.78 2.92-.06.32-.1.64-.13.96-2.3 1.11-4.08 1.83-3.56 3.3.52 1.26 2.4.83 3.62.21.55 3.06 2.61 4.97 5.56 5.72a77.6 77.6 0 0 0-3-.07c-1.01 0-1.01 1.52 0 1.52.11 0 1.16-.16 2.93-.2l-.05.59c-.09.74.91 1.07 1.27.42 0 .89 1.34.92 1.37.02l.03-.25c.06 1.1 1.41.91 1.37.05.2.87 1.52.57 1.34-.3l-.05-.56c1.54-.05 3.64-.02 5.86-.53 1.2-.28 1.6-.4 2.28-.53.71-.09-.02-.68-.15-.64-.08.03-.25.06-.47.1.65-.66.41-1.62.33-1.67-.09-.06-1.05.05-1.46.66-.34-.48-.98-.6-1.05-.56-.07.05-.48 1.18.48 1.84-1.63.24-3.26.37-4.88.3-1.26-.05-1.15 0-1.17-.05 3.3-.62 5.46-2.66 6.11-6.01 1.13.59 2.99 1.3 3.47.14.48-1.18-1.5-2.09-3.3-3.31-.03-.61-.1-1.2-.22-1.77.3-.71.26-1.47.42-2.3.81.1 1.1-.45 1.14-1.12-.02-.35-.1-.72-.12-.75-.05-.08-.48-.09-.6-.12-.27-1.36-1.99-1.57-3.74-1.65a7.18 7.18 0 0 0-4.65-2.45c.55-.53.29-1.22.24-1.25-.06-.04-.7.1-.95.52-.24-.92-1.19-1.16-1.27-1.13zm5.88 1.01c-.59-.06-1.15.09-1.2.55-.03 1.2 1.35-.04 2.7.32.35-.27-.87-.72-.92-.74a3.5 3.5 0 0 0-.58-.13zm-9.26 0c-.22.03-.44.08-.64.15-.05.02-1.39.5-1.01.8 1.49-.38 3 .98 2.96-.34-.05-.51-.67-.67-1.31-.6zm.58 4.52c1.36.03 2.41.36 2.38 1.87.01.84-.3 2.66-.7 3.1-.63.68-3.71.54-4.2.32-.82-.38-1.66-3.67-1.11-4.63.32-.55 1.15-.59 2.2-.63.5-.02.98-.05 1.43-.03zm7.8 0c.44-.01.92 0 1.41.03 1.05.05 1.93.09 2.25.63.59 1.03-.42 4.29-1.18 4.64-.47.2-3.55.35-4.17-.33-.4-.44-.67-2.26-.64-3.1-.04-1.5.99-1.84 2.33-1.87zM12 11a1 1 0 1 0-.01 2 1 1 0 0 0 0-2zm7.98 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-4.2 1.6c.1-.03.4-.03.5 0 .43.13.5 1.03.71 1.67-.61.15-.7.73-.9.73-.2 0-.4-.5-1.1-.5.29-.77.33-1.76.79-1.9z',
        'ebay' => 'M8.53 10v5.84C8.36 14.7 7.63 13 4.88 13 1.13 13 .98 15.88 1 16.63 1 16.63.81 20 4.78 20c2.94 0 3.47-1.56 3.56-2H6.75c-.12.29-.58 1.06-1.97 1.03C2.9 19 2.58 17.42 2.53 17h6v3H10v-.9s.75.9 2.75.9c1.7 0 3.09-.9 3.5-2.56.07-.3.12-.6.13-.94.03-2.28-1.71-3.49-3.6-3.5-1.89-.01-2.78 1.28-2.78 1.28V10Zm7.72 7.44c-.3 1.97 1.48 2.57 2.88 2.56 1.4 0 2.28-.42 2.87-1.16V20h1.53v-4.34c-.04-.74-.15-2.53-3.4-2.66 0 0-3.12-.28-3.44 2h1.6s.12-1.03 1.74-1c1.53.03 1.98 1.09 1.97 2h-1.94c-.79 0-3.4-.1-3.81 1.44ZM22.53 13 26 19.47 24.66 22h1.68L31 13h-1.6l-2.56 5-2.56-5ZM4.84 14C7 14 7 16 7 16H2.53s.16-2 2.31-2Zm7.6 0c2.42-.06 2.34 2.5 2.34 2.5s.04 2.47-2.34 2.5c-2.39.03-2.35-2.53-2.35-2.53s-.08-2.4 2.35-2.47Zm7.31 3h2.09s.29 2.1-2.43 2.06c0 0-1.54 0-1.63-1.18 0-.67 1.31-.84 1.97-.88Z',
        'edge' => 'M9.96 10.83c-2.62 1.63-4.11 3.94-4.11 3.94s.38-4.85 4.11-7.7A10.01 10.01 0 0 1 16.2 5c1.02 0 3.17.18 5.1 1.37a9.32 9.32 0 0 1 4.46 5.88c.36 1.46.4 3.21.4 3.21v2.31H12.34s-.34 4.64 6.02 4.64c2.2 0 2.98-.35 3.7-.56 1.14-.34 2.24-1.09 2.24-1.09v4.64S21.7 27 17.77 27a11 11 0 0 1-3.4-.46 8.62 8.62 0 0 1-5.69-5.78c-.28-1-.28-1.97-.28-2.51 0-2 .69-3.92 1.88-5.3 1.54-1.8 3.49-2.6 3.49-2.6s-.64.75-1.03 1.67c-.39.92-.5 1.85-.5 1.85h7.8s.46-4.67-4.4-4.67c-1.84 0-4.1.64-5.68 1.63Z',
        'edit-solid' => 'M25 4.03c-.77 0-1.52.3-2.1.88L13 14.78l-.22.22-.06.31-.69 3.5-.31 1.47 1.47-.31 3.5-.69.31-.06.22-.22 9.87-9.9A2.97 2.97 0 0 0 25 4.02Zm0 1.94c.23 0 .46.12.69.34.44.45.44.93 0 1.38L16 17.37l-1.72.35.35-1.72 9.68-9.69c.23-.22.46-.34.69-.34ZM4 8v20h20V14.81l-2 2V26H6V10h9.19l2-2Z',
        'edit' => 'M25 4.03c-.77 0-1.52.3-2.1.88L13 14.78l-.22.22-.06.31-.69 3.5-.31 1.47 1.47-.31 3.5-.69.31-.06.22-.22 9.87-9.9A2.97 2.97 0 0 0 25 4.02Zm0 1.94c.23 0 .46.12.69.34.44.45.44.93 0 1.38L16 17.37l-1.72.35.35-1.72 9.68-9.69c.23-.22.46-.34.69-.34ZM4 8v20h20V14.81l-2 2V26H6V10h9.19l2-2Z',
        'egg-solid' => 'M16 3c-3 0-5.7 2.3-7.7 5.2C6.3 11.1 5 14.7 5 18c0 3.5 1.2 6.3 3.2 8.2C10.3 28 13 29 16 29s5.7-.9 7.8-2.8S27 21.5 27 18c0-3.3-1.3-6.9-3.3-9.8C21.7 5.3 19 3 16 3zm0 2c1.9 0 4.2 1.7 6 4.3 1.8 2.6 3 6 3 8.7 0 3.1-1 5.3-2.6 6.7A9.12 9.12 0 0 1 16 27c-2.6 0-4.8-.8-6.4-2.3C8 23.2 7 21 7 18c0-2.8 1.2-6.1 3-8.7C11.8 6.7 14.1 5 16 5z',
        'eject-solid' => 'm16 6.6-.72.68-9 9L4.6 18h22.82l-1.7-1.72-9-9Zm0 2.84L22.56 16H9.44ZM4 22v2h24v-2Z',
        'elementor' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4 4v10h2V11h-2zm4 0v2h6v-2h-6zm0 4v2h6v-2h-6zm0 4v2h6v-2h-6z',
        'ellipsis-h-solid' => 'M6 14a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'ellipsis-v-solid' => 'M16 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm0 8a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm0 8a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'ello' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zM9.08 17a7 7 0 0 0 13.84 0H20.9a5 5 0 0 1-9.8 0H9.08z',
        'ember' => 'M18.02 8c-.14 0-.29.02-.43.07-.85.34-1.17.84-1.17.84s-1.1 1.62-1.36 4.01l-.13 1.18c-.23 2-.5 3.98-.5 3.98s-.52.5-1 .52c-.5.02-.28-1.4-.28-1.4s.38-2.12.35-2.49c-.02-.36-.05-.56-.5-.69-.44-.13-.92.42-.92.42s-1.27 1.84-1.38 2.12l-.07.12-.06-.08s.9-2.56.04-2.6c-.86-.04-1.43.91-1.43.91s-.98 1.6-1.02 1.78l-.06-.07s.4-1.79.32-2.25c-.08-.45-.53-.36-.53-.36s-.56-.07-.7.28c-.15.36-.69 2.62-.75 3.37 0 0-1.41.99-2.34 1-.93 0-.84-.58-.84-.58s3.4-1.1 2.47-3.33c-.41-.58-.9-.76-1.59-.75-.68.02-1.51.38-2.06 1.59a4.93 4.93 0 0 0-.4 1.53s-.6.12-.93-.14c-.33-.26-.5 0-.5 0s-.56.68 0 .9c.55.2 1.4.29 1.4.29.08.36.31.95.98 1.44 1.01.75 2.94-.06 2.94-.06l.8-.43s.02.71.6.82c.58.1.82.04 1.82-2.34.6-1.21.64-1.14.64-1.14l.06-.02s-.45 2.28-.28 2.9c.18.63.94.56.94.56s.42.12.75-1.03c.34-1.15.98-2.43.98-2.43h.08s-.28 2.34.15 3.1c.43.76 1.54.26 1.54.26s.78-.38.9-.5c0 0 .93.77 2.24.63 2.91-.56 3.95-1.26 3.95-1.26s.5 1.19 2.05 1.3c1.78.13 2.75-.9 2.75-.9s-.02.65.6.9 1.04-1.11 1.04-1.11l1.03-2.79h.1s.05 1.82 1.07 2.1c1.02.3 2.35-.66 2.35-.66s.32-.17.26-.7c-.05-.52-.53-.33-.53-.33s-.78.6-1.47.52c-.68-.06-.47-1.5-.47-1.5s.15-1.37-.25-1.48c-.4-.12-.9.35-.9.35s-.62.62-.92 1.47l-.08.02s.1-1.49-.01-1.83c-.08-.17-.82-.15-.94.15s-.71 2.4-.75 3.27c0 0-1.16.95-2.17 1.11-1 .16-1.25-.46-1.25-.46s2.66-.51 2.56-2.65c-.1-2.13-2.2-1.34-2.45-1.16-.23.17-1.38.66-1.74 2.67l-.04.37s-1.06.69-1.65.87c0 0 1.65-2.7-.36-3.93-.57-.34-1.07-.03-1.36.25.1-.11.2-.26.32-.42.77-1.08 1.93-3.08 1.52-4.86-.21-.92-.61-1.23-1.03-1.24zm-.3 1.32c.08 0 .15.1.2.33.17.98-1.2 3.48-1.77 4.45l-.24.39c0-.1.02-.24.05-.39.17-1.07.77-3.16.77-3.16s.63-1.66 1-1.62zm-13.34 5.8c.06.02.12.05.16.09.37.34.23 1.04-.45 1.5-.69.46-1 .36-1 .36.04-1.36.85-2.02 1.3-1.94zm18.74.1c.18.01.28.15.28.15s.47.5-.06 1.24c-.54.74-1.32.7-1.32.7s-.15-.52.4-1.5c.28-.5.52-.6.7-.59zm-5.82.23c.23.03.4.12.4.12s.8.6.17 2.21c-.63 1.61-2.16.96-2.16.96s-.18-.58.32-2.19c.3-1 .88-1.14 1.27-1.1z',
        'empire' => 'M27.6 12.9a12 12 0 1 0-23.2 6.22 12 12 0 0 0 23.2-6.23ZM16.4 5.33a10.6 10.6 0 0 1 8.57 4.9l-.43.25c-.39-.6-.84-1.17-1.35-1.68l-.9.9a8.91 8.91 0 0 0-3.99-2.3l.33-1.22c-.72-.2-1.46-.3-2.22-.34ZM19.6 16c0 .32-.05.64-.12.94l3.68.99a7.44 7.44 0 0 1-1.92 3.32l-2.7-2.7c-.43.43-.99.76-1.61.93l.99 3.68a7.4 7.4 0 0 1-3.84 0l.99-3.68a3.56 3.56 0 0 1-1.62-.94l-2.7 2.7a7.38 7.38 0 0 1-1.91-3.33l3.68-.98a3.6 3.6 0 0 1 0-1.86l-3.68-.99a7.39 7.39 0 0 1 1.91-3.32l2.7 2.7c.44-.44 1-.77 1.62-.94l-1-3.68a7.43 7.43 0 0 1 3.85 0l-.99 3.68c.62.17 1.18.5 1.62.93l2.7-2.7a7.4 7.4 0 0 1 1.91 3.33l-3.68.99c.08.3.12.6.12.93ZM8.46 8.46a10.67 10.67 0 0 1 6.95-3.1v.5a10 10 0 0 0-2.04.32l.33 1.22a8.89 8.89 0 0 0-4 2.31l-.9-.9c-.5.51-.95 1.07-1.34 1.68l-.44-.25c.41-.65.9-1.24 1.44-1.78ZM6.52 20.9a10.61 10.61 0 0 1-.82-7.65c.2-.75.47-1.46.82-2.13l.43.25c-.32.63-.58 1.3-.77 2l1.22.34a8.8 8.8 0 0 0 0 4.6l-1.22.33c.18.7.45 1.38.77 2.01Zm8.89 5.76a10.64 10.64 0 0 1-8.39-4.89l.43-.25c.4.6.85 1.17 1.35 1.67l.9-.9a8.87 8.87 0 0 0 4 2.32l-.33 1.22c.65.18 1.34.29 2.04.33Zm8.13-3.1a10.67 10.67 0 0 1-7.13 3.1v-.5c.76-.02 1.5-.14 2.22-.33l-.33-1.22a8.87 8.87 0 0 0 4-2.3l.89.9a11 11 0 0 0 1.35-1.69l.44.25c-.42.65-.9 1.24-1.44 1.78Zm1.94-2.66-.43-.25c.32-.63.58-1.3.77-2l-1.22-.33a9 9 0 0 0 0-4.61l1.22-.33c-.19-.7-.45-1.38-.77-2.01l.43-.25a10.58 10.58 0 0 1 .82 7.66c-.2.74-.48 1.45-.82 2.12Z',
        'envelope-open-solid' => 'm16 3-.53.34-12 7.82-.47.3V29h26V11.47l-.47-.31-12-7.82Zm0 2.38L26.19 12 16 18.6 5.81 12ZM5 13.84l10.47 6.79.53.34.53-.34L27 13.84V27H5Z',
        'envelope-open-text-solid' => 'M10 5v1.9l-6 3.9V27h24V10.8l-6-3.9V5H10zm2 2h8v7.68l-4 2.6-4-2.6V7zm1 2v2h6V9h-6zm-3 .29v4.1l-3.16-2.05L10 9.3zm12 0 3.16 2.05L22 13.4V9.3zM13 12v2h6v-2h-6zm-7 1.18 10 6.48 10-6.48V25H6V13.18z',
        'envelope-open' => 'm16 3-.53.34-12 7.82-.47.3V29h26V11.47l-.47-.31-12-7.82Zm0 2.38L26.19 12 16 18.6 5.81 12ZM5 13.84l10.47 6.79.53.34.53-.34L27 13.84V27H5Z',
        'envelope-solid' => 'M3 8v18h26V8Zm4.31 2H24.7L16 15.78ZM5 10.88l10.44 6.96.56.35.56-.35L27 10.88V24H5Z',
        'envelope-square-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm2 3v12h14V10Zm2.81 2h8.38L16 14.78ZM11 13.88l4.44 2.96.56.35.56-.35L21 13.88V20H11Z',
        'envelope' => 'M3 8v18h26V8Zm4.31 2H24.7L16 15.78ZM5 10.88l10.44 6.96.56.35.56-.35L27 10.88V24H5Z',
        'envira' => 'M5 5c2.61 8.98 2.36 13.18 6.9 16.7 3.97 3.02 7.94 2.23 10.1 1.9l3.4 3.4h2l-3.98-3.98C23.39 20.62 29 5 5 5zm3.08 2c.14.01.45.12 1.05.4 4 1.85 5.4 4.59 6.93 7.4 1.1 2.02 3.02 5.1 4.38 6.1 1.35.98 2.83 1.7-.3.4-3.13-1.32-5.4-5.04-6.92-7.86-1.17-2.16-2.17-4.15-4.34-5.61 0 0-1.2-.86-.8-.83z',
        'equals-solid' => 'M5 12v2h22v-2Zm0 6v2h22v-2Z',
        'eraser-solid' => 'M18.9 4.1c-.8 0-1.63.27-2.27.84v.03l-.04.03L4.91 16.6a3.27 3.27 0 0 0-.07 4.46l.04.03h.03l6 6a3.27 3.27 0 0 0 4.46.07v-.04L27 15.5a3.2 3.2 0 0 0 .1-4.5l-6-6a3.1 3.1 0 0 0-2.2-.9Zm-.02 2.03c.32 0 .61.08.8.28l6 6c.4.38.45 1.15-.09 1.68l-5.03 5.04-7.65-7.66 5.06-5.03.03-.03c.25-.21.57-.29.88-.29Zm-7.41 6.78 7.65 7.65-5.09 5.1-.03.03c-.52.43-1.3.38-1.69 0l-5.97-5.94-.03-.06c-.4-.52-.37-1.32 0-1.69Z',
        'erlang' => 'M2 7v18h4.32A16.3 16.3 0 0 1 3 15c0-3.08 1.15-5.88 3.05-8H2zm14 0a4 4 0 0 0-4 4h8a4 4 0 0 0-4-4zm9.66 0A14.7 14.7 0 0 1 28 15H12c0 3.51 1 6.56 3 8.03.31.24.64.43 1 .58.6.25 1.27.39 2 .39 2.97 0 5.57-1.82 6.94-4.53l2.02 1.01 1.56.78c-.7 1.4-1.62 2.66-2.73 3.74H30V7h-4.34z',
        'ethereum' => 'M14.95 3 6.93 15.55 16 20.01l8.93-4.46L17.05 3h-2.1zM15 6.64v4.35l-3.91 1.77L15 6.64zm2 .04 3.82 6.08L17 11V6.68zm-2 6.5v4.11l-4.34-2.14L15 13.18zm2 .03 4.25 1.95L17 17.28V13.2zM7 17.5v2.52l7.93 8.84h2.14L25 20.04v-2.52l-9 4.61-9-4.6zm4.52 4.57L15 23.86v2.1l-3.48-3.88zm8.96 0L17 25.96v-2.1l3.48-1.78z',
        'ethernet-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm7 4v3h-3v7h2v-2h2v2h2v-2h2v2h2v-7h-3v-3Z',
        'etsy' => 'M23.97 5c-5.26.6-14.2.3-17.83.18v1.26c2.4.45 2.95.37 3 1.76.17 3.83.09 12.27 0 15.82-.02 1.33-.77 1.29-3 1.73V27c7.3-.23 12.3-.21 18.1 0 .07-.93.51-4.62.7-6H23.7c-1.4 3.3-1.66 4.42-4.64 4.42h-4.38c-1.48 0-2.18-.6-2.18-1.88V16.7c3.27 0 4.32.1 4.32.1 1.5.02 1.73 1.22 2.18 3.19h1c-.1-4.83-.22-3.02 0-8h-1c-.65 2.79-.69 3.12-2.15 3.16 0 0-1.5.15-4.35.13V7.25c0-.31.03-.48.53-.48h6.73c1.7 0 2.12 2.18 2.63 4.23h1.21c.04-.89.22-4.37.37-6z',
        'euro-sign-solid' => 'M18 4c-4.74 0-8.59 3.89-9.69 9H6v2h2.06c-.02.33-.06.66-.06 1 0 .34.04.67.06 1H6v2h2.31c1.1 5.11 4.95 9 9.69 9 2.7 0 5.17-1.3 6.94-3.34l-1.53-1.32A7.14 7.14 0 0 1 18 26c-3.5 0-6.59-2.9-7.63-7H19v-2h-8.97a12.1 12.1 0 0 1 0-2H19v-2h-8.63C11.41 8.9 14.5 6 18 6c2.07 0 3.95.98 5.4 2.66l1.54-1.32A9.23 9.23 0 0 0 18 4Z',
        'evernote' => 'M11.98 3a1 1 0 0 0-.54.17l-.08.06-.07.06v.01l-7 7-.01.01a1 1 0 0 0-.27.91c.01 1.35.26 3.9.89 6.36.33 1.3.74 2.53 1.35 3.53.57.95 1.43 1.8 2.57 1.87.04.01 1.3.26 2.72.4.71.06 1.47.1 2.18.04.7-.06 1.38-.1 1.99-.71a1 1 0 0 0 .27-.51l.43-2.14.07.12c.32.38.78.82 1.52.82h4v-2h-3.87s-.05-.03-.12-.11c-.15-.18-.34-.5-.5-.83-.33-.67-.56-1.36-.56-1.36a1 1 0 0 0-1.93.1l-.9 4.53c-.07 0-.17.06-.56.1-.5.03-1.19 0-1.85-.05-1.3-.12-2.51-.36-2.51-.36A1.07 1.07 0 0 0 9 21c-.26 0-.6-.21-1.04-.92a11.8 11.8 0 0 1-1.12-2.99 25.8 25.8 0 0 1-.7-5.09H12a1 1 0 0 0 1-1V5h2c.63 0 1.09.33 1.46.81.37.49.54 1.22.54 1.19a1 1 0 0 0 .97 1c.84.03 2.23.07 3.45.5 1.22.44 2.2 1.14 2.61 2.74.44 1.76.72 6.04.47 9.7a21.43 21.43 0 0 1-.73 4.67c-.18.57-.4 1-.57 1.2-.16.22-.18.19-.2.19h-2.14a.84.84 0 0 1-.86-.86c0-.64.5-1.14 1.14-1.14H22v-2h-.86A3.16 3.16 0 0 0 18 26.14c0 .27.1.53.3.72.34 1.18 1.27 2.14 2.56 2.14H23c.73 0 1.37-.43 1.78-.95.4-.51.67-1.13.9-1.84.44-1.42.7-3.22.82-5.14.25-3.85.03-8.07-.53-10.31a5.88 5.88 0 0 0-3.88-4.13c-1.38-.5-2.57-.5-3.45-.54-.15-.5-.2-.98-.6-1.5A3.88 3.88 0 0 0 15 3h-3.02ZM11 6.4V10H7.41ZM21.8 14c-1.8 0-1.82 1.91-1.8 2 1.8 0 2.34.66 2.71 1 .17-.23.9-3-.9-3Z',
        'exchange-alt-solid' => 'm22.19 2.28-1.4 1.44L25.05 8H4v2h21.06l-4.28 4.28 1.4 1.44L28.92 9Zm-12.38 14L3.1 23l6.72 6.72 1.4-1.44L6.95 24H28v-2H6.94l4.28-4.28Z',
        'exclamation-circle-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-1 4v8h2v-8Zm0 10v2h2v-2Z',
        'exclamation-solid' => 'M13 4v16h6V4Zm2 2h2v12h-2Zm-2 16v6h6v-6Zm2 2h2v2h-2Z',
        'exclamation-triangle-solid' => 'm16 3.22-.88 1.5-12 20.78-.84 1.5h27.44l-.84-1.5-12-20.78Zm0 4L26.25 25H5.75ZM15 14v6h2v-6Zm0 7v2h2v-2Z',
        'expand-arrows-alt-solid' => 'M4 4v9h2V7.44L14.56 16 6 24.56V19H4v9h9v-2H7.44L16 17.44 24.56 26H19v2h9v-9h-2v5.56L17.44 16 26 7.44V13h2V4h-9v2h5.56L16 14.56 7.44 6H13V4Z',
        'expand-solid' => 'M4 4v9h2V6h7V4H4zm15 0v2h7v7h2V4h-9zM4 19v9h9v-2H6v-7H4zm22 0v7h-7v2h9v-9h-2z',
        'expeditedssl' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm.03 1.84a4.5 4.5 0 0 0-4.4 4.5v1.22c0 .21.16.38.37.38h.94c.2 0 .37-.17.37-.38v-1.22A2.84 2.84 0 0 1 16 9.47a2.83 2.83 0 0 1 2.94 2.81v1.28c0 .21.16.38.37.38h.9c.22 0 .38-.17.38-.38v-1.15a4.54 4.54 0 0 0-4.56-4.57Zm-5.6 6.5a.82.82 0 0 0-.84.82v6.46c0 .47.39.82.85.82h11.31c.46 0 .84-.35.84-.82v-6.46a.82.82 0 0 0-.84-.82Zm.16.82h.38c.1 0 .19.08.19.18v6.13c0 .1-.09.19-.2.19h-.37a.19.19 0 0 1-.18-.2v-6.12c0-.1.08-.18.18-.18Zm5.47.8a1.6 1.6 0 0 1 .82 2.98v1.5c0 .22-.2.37-.41.37h-.81c-.22 0-.41-.15-.41-.37v-1.5a1.6 1.6 0 0 1 .81-2.97Z',
        'external-link-alt-solid' => 'M18 5v2h5.56L11.28 19.28l1.44 1.44L25 8.44V14h2V5ZM5 9v18h18V14l-2 2v9H7V11h9l2-2Z',
        'external-link-square-alt-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm6 3v2h5.56l-9.28 9.28 1.44 1.44L20 13.44V19h2v-9Z',
        'eye-dropper-solid' => 'M24.66 3.03c-1.11 0-2.23.41-3.07 1.25L18.81 7.1l-1-1-1.4 1.41 1 1L7.9 18a11.21 11.21 0 0 0-2 2.47 5.2 5.2 0 0 0-.57 1.69c-.06.4-.1.62-.34 1.06a9.85 9.85 0 0 1-1.72 2.06L2.6 26l.7.72 2 2 .71.69.72-.7a9.55 9.55 0 0 1 2-1.65c.42-.23.65-.27 1.06-.34.41-.07 1-.18 1.69-.56.69-.38 1.47-1 2.53-2.07l9.5-9.5 1 1 1.4-1.4-1-1 2.82-2.78a4.31 4.31 0 0 0-3.06-7.38Zm0 2c.59 0 1.16.23 1.62.69a2.3 2.3 0 0 1 0 3.28l-2.78 2.78-3.28-3.28L23 5.72a2.34 2.34 0 0 1 1.66-.69ZM18.8 9.91l3.28 3.28-9.5 9.5c-.98.98-1.65 1.47-2.09 1.72-.44.24-.66.27-1.06.34s-.98.16-1.66.53c-.46.25-1.08.85-1.69 1.38l-.75-.75c.55-.62 1.15-1.25 1.41-1.72.38-.69.5-1.31.56-1.72.07-.41.12-.6.35-1.03.23-.43.7-1.07 1.65-2.03Z',
        'eye-slash-solid' => 'M3.72 2.28 2.28 3.72l6.19 6.15 12.97 12.97 6.84 6.88 1.44-1.44-6.34-6.34a33.05 33.05 0 0 0 7.34-5.22l.66-.66-.63-.72C30.49 15.04 24.39 8 16 8c-2 0-3.85.42-5.53 1.03ZM16 10c2.16 0 4.16.55 5.94 1.34a6.96 6.96 0 0 1-.78 8.38l-2.85-2.84A3 3 0 0 0 19 15a3 3 0 0 0-3-3 3 3 0 0 0-1.88.69l-2.06-2.06C13.3 10.24 14.61 10 16 10Zm-9.38.88a24.13 24.13 0 0 0-5.37 4.46l-.63.72.66.66c.29.28 6.82 6.66 13.78 7.22h.06c.3.02.6.06.88.06.29 0 .59-.04.88-.06h.06c.8-.07 1.6-.21 2.37-.4L17.6 21.8c-.25.06-.52.1-.78.13l-.12.03c-.47.04-.91.04-1.38 0l-.1-.03a6.98 6.98 0 0 1-6.02-8.5Zm.66 1.96a8.85 8.85 0 0 0 .9 6.6 32.64 32.64 0 0 1-4.77-3.5c.74-.74 2.1-1.95 3.87-3.1Zm17.44 0a23.8 23.8 0 0 1 3.84 3.13 32.9 32.9 0 0 1-4.75 3.47 8.93 8.93 0 0 0 .9-6.6ZM16 14a1 1 0 0 1 1 1c0 .16-.05.3-.13.44l-1.3-1.31A.93.93 0 0 1 16 14Z',
        'eye-slash' => 'M3.72 2.28 2.28 3.72 8.5 9.9 19.6 21l1.9 1.94 6.78 6.78 1.44-1.44-6.22-6.22a26.46 26.46 0 0 0 7.25-5.4l.6-.66-.6-.66C30.48 15.04 24.09 8 16 8c-1.96 0-3.8.43-5.5 1.06ZM16 10c2.15 0 4.19.6 6 1.44a6.93 6.93 0 0 1-.84 8.28l-2.85-2.84A3 3 0 0 0 19 15a3 3 0 0 0-3-3 3 3 0 0 0-1.88.69l-2.03-2.03c1.25-.39 2.55-.66 3.91-.66Zm-9.31.9a26.47 26.47 0 0 0-5.44 4.44l-.6.66.6.66c.26.29 6.18 6.77 13.81 7.28.31.03.62.06.94.06.32 0 .63-.03.94-.06.82-.06 1.63-.17 2.4-.35l-1.78-1.78a7 7 0 0 1-8.38-8.38Zm.56 2.04a8.92 8.92 0 0 0 1.1 6.78A25.84 25.84 0 0 1 3.4 16c.74-.72 2.09-1.92 3.84-3.06Zm17.5 0A26.33 26.33 0 0 1 28.59 16c-.9.87-2.67 2.44-4.96 3.75a8.98 8.98 0 0 0 1.12-6.81Z',
        'eye-solid' => 'M16 8C7.66 8 1.25 15.34 1.25 15.34l-.6.66.6.66s5.85 6.66 13.63 7.28a8.93 8.93 0 0 0 2.24 0c7.78-.62 13.63-7.28 13.63-7.28l.6-.66-.6-.66S24.34 8 16 8Zm0 2c2.2 0 4.23.6 6 1.4a7 7 0 0 1-5.22 10.56h-.06c-.24.02-.48.04-.72.04-.27 0-.52-.02-.78-.03a7 7 0 0 1-5.25-10.53h-.03A14.52 14.52 0 0 1 16 10Zm0 2a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm-8.75.94a9 9 0 0 0 1.13 6.84A23.2 23.2 0 0 1 3.53 16c.48-.5 1.82-1.8 3.72-3.06Zm17.5 0A23.93 23.93 0 0 1 28.47 16a23.2 23.2 0 0 1-4.84 3.78 8.93 8.93 0 0 0 1.12-6.84Z',
        'eye' => 'M16 8C7.66 8 1.25 15.34 1.25 15.34l-.6.66.6.66s5.85 6.66 13.63 7.28a8.93 8.93 0 0 0 2.24 0c7.78-.62 13.63-7.28 13.63-7.28l.6-.66-.6-.66S24.34 8 16 8Zm0 2c2.2 0 4.23.6 6 1.4a7 7 0 0 1-5.22 10.56h-.06c-.24.02-.48.04-.72.04-.27 0-.52-.02-.78-.03a7 7 0 0 1-5.25-10.53h-.03A14.52 14.52 0 0 1 16 10Zm0 2a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm-8.75.94a9 9 0 0 0 1.13 6.84A23.2 23.2 0 0 1 3.53 16c.48-.5 1.82-1.8 3.72-3.06Zm17.5 0A23.93 23.93 0 0 1 28.47 16a23.2 23.2 0 0 1-4.84 3.78 8.93 8.93 0 0 0 1.12-6.84Z',
        'facebook-f' => 'M19.25 2C15.31 2 13 4.08 13 8.83V13H8v5h5v12h5V18h4l1-5h-5V9.67C18 7.88 18.58 7 20.26 7H23V2.2c-.47-.06-1.86-.2-3.75-.2z',
        'facebook-messenger' => 'M16 4C9.41 4 4 9.14 4 15.5c0 3.4 1.57 6.4 4 8.5v4.63l4.44-2.22c1.13.34 2.3.59 3.56.59 6.59 0 12-5.14 12-11.5S22.59 4 16 4Zm0 2c5.56 0 10 4.27 10 9.5S21.56 25 16 25c-1.2 0-2.34-.23-3.4-.6l-.41-.12-2.19 1.1v-2.25l-.38-.32A9.3 9.3 0 0 1 6 15.5C6 10.27 10.44 6 16 6Zm-1.13 6.34-6.03 6.38 5.41-3 2.88 3.1 5.96-6.48-5.28 2.97Z',
        'facebook-square' => 'M7 5a2 2 0 0 0-2 2v18c0 1.1.9 2 2 2h18a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2Zm0 2h18v18h-5.19v-6.75h2.6l.37-3h-2.97v-1.94c0-.87.22-1.47 1.47-1.47h1.63V9.13c-.28-.04-1.24-.1-2.35-.1-2.3 0-3.87 1.39-3.87 3.97v2.25h-2.63v3h2.63V25H7Z',
        'facebook' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24zm0 2a9.98 9.98 0 0 1 1.49 19.88v-6.96h2.85l.44-2.9h-3.3v-1.58c0-1.2.4-2.26 1.53-2.26h1.8V9.65c-.32-.04-.99-.13-2.26-.13-2.64 0-4.2 1.4-4.2 4.58v1.92h-2.72v2.9h2.73v6.93A9.98 9.98 0 0 1 16 6z',
        'fan-solid' => 'M16 4C10.49 4 6 8.49 6 14s4.49 10 10 10 10-4.49 10-10S21.51 4 16 4Zm0 2a7.98 7.98 0 0 1 7.97 7.44c-.6-.44-1.3-.7-2-.81a7.07 7.07 0 0 0-3.22.18 3.02 3.02 0 0 0-3.38-1.75h-.03a5.87 5.87 0 0 1-1.65-2.22 2.6 2.6 0 0 1-.16-1.5c.1-.41.31-.8.88-1.18.5-.1 1.05-.16 1.59-.16Zm-4.5 1.4c-.07.74.06 1.46.31 2.13a7.4 7.4 0 0 0 1.78 2.69 2.98 2.98 0 0 0 .22 3.84c-.16.8-.54 1.77-1.1 2.44-.37.46-.82.78-1.24.9-.43.14-.87.14-1.5-.18A7.93 7.93 0 0 1 11.5 7.4ZM16 13c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm4.69 1.56c.32 0 .64.01.93.06.6.1 1.08.32 1.41.63.31.3.51.67.56 1.31a8 8 0 0 1-11.12 4.63 4.9 4.9 0 0 0 1.78-1.4 7.53 7.53 0 0 0 1.44-2.82c.1.01.2.03.31.03a3 3 0 0 0 2.81-2.06 6.2 6.2 0 0 1 1.88-.38ZM15 25v1H9v2h14v-2h-6v-1Z',
        'fantasy-flight-games' => 'M16 2 2 16l14 14 14-14L16 2zm0 2.01L28 16 16 28 4 16 16 4.01zM16 6 6 16l10 10 10-10L16 6zm.31 4.01c.68.05 1.32.3 1.9.73 1.1.83 2.8 2.66 2.8 2.66.03.04.05.13.03.16l-1.51 1.57a23.86 23.86 0 0 0-2.2-2 2 2 0 0 0-2.58.24c-.1.1-.08.16 0 .24l1.59 1.62-1.61 1.57-1.66-1.73-2.8 2.77-1.86-1.85 4.37-4.4c1.17-1.19 2.4-1.66 3.53-1.58zm5.42 4.18A349 349 0 0 1 23.6 16c-.91.94-3.7 3.74-4.55 4.6-1.6 1.59-3.54 1.71-4.84.92-1-.61-1.78-1.46-3.3-3.03l1.6-1.64c1.49 1.44 1.67 1.62 2.02 1.9.84.67 1.93.62 2.69-.08.16-.15.16-.16 0-.33l-1.43-1.45c-.07-.06-.14-.11-.04-.21l1.45-1.47.1-.05c.55.6 1.12 1.18 1.67 1.76l2.77-2.73z',
        'fast-backward-solid' => 'm17 5-1.6 1.19-12 9-1.06.81 1.07.81 12 9L17 27v-7.38l8.4 6.2 1.6 1.15V5.03L25.4 6.2 17 12.37Zm8 3.97v14.06l-8.4-6.19-1.13-.84 1.12-.84ZM15 9v14l-9.31-7Z',
        'fast-forward-solid' => 'M15 5v7.38l-8.4-6.2L5 5.04v21.94l1.6-1.16 8.4-6.18V27l1.6-1.19 12-9 1.06-.81-1.07-.81-12-9ZM7 8.97l8.4 6.19 1.13.84-1.12.84L7 23.04ZM17 9l9.31 7L17 23Z',
        'fax-solid' => 'M12 5v5h-2V8H4v18h2v1c0 1.64 1.36 3 3 3s3-1.36 3-3v-1h16V10h-4V5Zm2 2h8v5h-8Zm-8 3h2v14H6Zm4 2h2v2h12v-2h2v12H10Zm3 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM8 26h2v1a1 1 0 0 1-1 1 1 1 0 0 1-1-1Z',
        'feather-alt-solid' => 'M27 4c-8.8 0-13.2 4.8-15.31 7.1l-3.05 3.08A8.93 8.93 0 0 0 6 20.54V22l2.03-2.03a6.9 6.9 0 0 1 2.02-4.38l3.11-3.14c1.84-2 5.57-6.07 12.81-6.43a16.84 16.84 0 0 1-3.6 9.86L19 17h2.42a29.6 29.6 0 0 1-1.87 1.84l-.98.97L15 21h2.37l-.96.95A6.95 6.95 0 0 1 11.46 24H9.42l9.29-9.3-1.42-1.4L4 26.58 5.41 28l2-2h4.05c2.4 0 4.67-.94 6.37-2.64l3.07-3.05C23.2 18.21 28 13.81 28 5V4h-1z',
        'feather-solid' => 'M21.5 4c-1.8 0-3.48.73-4.7 2.02l-8.16 8.16A8.94 8.94 0 0 0 6 20.54V22l2.03-2.03a6.9 6.9 0 0 1 2.02-4.38l8.18-8.18a4.5 4.5 0 1 1 6.33 6.37l-2.03 2.04L19 17h2.36l-3.82 3.82L14 22h2.35a6.95 6.95 0 0 1-4.89 2H9.41l9.3-9.3-1.42-1.4L4 26.58 5.41 28l2-2h4.05c2.4 0 4.67-.94 6.36-2.64l8.14-8.14A6.5 6.5 0 0 0 21.5 4z',
        'fedex' => 'M16 11v3.95h-.08a2.14 2.14 0 0 0-1.77-.77c-1.42 0-2.49 1.01-2.86 2.34-.9-3.1-4.88-3.01-6.1-.73v-1.26H2.45v-1.38h3v-2.14H0v9.64h2.45V16.6h2.44c-.07.3-.11.61-.11.95a3.36 3.36 0 0 0 6.5 1.24h-2.1c-.73 1.09-2.28.46-2.28-.77h4.28c.18 1.6 1.36 2.98 3 2.98.7 0 1.35-.36 1.75-.97h.02v.62h10.61l1.1-1.3 1.12 1.3H32l-2.7-3.17 2.66-3.13h-3.11l-1.09 1.3-1.13-1.3H20.7v-.83h2.8V11H16zm2.3.47h4.75v1.57h-2.8v1.78h2.78v1.47h-2.8v2.34h2.8v1.54H18.3v-8.7zm5.24 3.05 2.53 2.98-2.53 2.98v-2.39h-2.81v-1.27h2.8v-2.3zm.9.3h2l1.33 1.53 1.27-1.53h1.93l-2.27 2.66 2.3 2.7h-2.03l-1.31-1.55-1.3 1.54h-1.91l2.28-2.67-2.28-2.68zm-16.29.78c.52 0 1.02.35 1.14 1.02H6.96c.16-.7.68-1.03 1.2-1.02zm6.48.3c1.63 0 1.73 3.28 0 3.28s-1.7-3.29 0-3.29z',
        'fedora' => 'M16.05 3A13 13 0 0 0 3.02 15.96L3 25.85a3.1 3.1 0 0 0 3.09 3.13h.02l9.87.02a13 13 0 0 0 .07-26zm2.87 5.01h.01c.33 0 .66.04.98.11.54.1.96.58.96 1.17a1.2 1.2 0 0 1-1.47 1.15 2.71 2.71 0 0 0-3.2 2.66v2.28c0 .24.2.43.43.43h1.63c1.57.02 1.57 2.4 0 2.4h-2.07v2.7a5.09 5.09 0 0 1-6.09 4.99c-.28 0-.96-.42-.96-1.18 0-.65.53-1.18 1.18-1.19.3 0 .3.08.76.08a2.7 2.7 0 0 0 2.72-2.7v-2.28c0-.22-.22-.44-.43-.44h-1.63c-1.57 0-1.57-2.4.01-2.39h2.06v-2.7A5.1 5.1 0 0 1 18.92 8zm2 .41a5.14 5.14 0 0 1 2.83 3.1l-2.63-2.65a1.3 1.3 0 0 0-.2-.45zm.28.8 2.67 2.71a5 5 0 0 1 .14 1.09l-3-3.03c.12-.23.19-.45.19-.7v-.07zm-.3.95L24 13.3c-.01.27-.05.54-.11.8l-3.48-3.49c.19-.11.35-.26.48-.44zm.38 1.62 2.57 2.58c-.06.24-.14.47-.23.7l-2-2.01a2.81 2.81 0 0 0-.34-1.27zm.33 1.57 1.91 1.93c-.1.2-.2.4-.32.58l-1.76-1.77c.1-.24.15-.49.17-.74zm-.26.96 1.73 1.73c-.13.18-.27.35-.41.51l-1.7-1.7c.15-.16.28-.35.38-.54zm-.52.7 1.69 1.7c-.16.16-.32.3-.5.44l-1.7-1.72c.18-.12.35-.26.5-.41zm-.73.52 1.75 1.74c-.18.13-.38.25-.57.35l-1.84-1.86c.23-.05.46-.11.66-.23zm-9.49.29a2.3 2.3 0 0 0-.37.55l-.41-.41c.25-.08.52-.12.78-.14zm-1.02.2.57.58-.04.38c0 .2.04.41.11.6l-1.3-1.3c.21-.11.43-.2.66-.26zm-.88.36 1.85 1.86c-.24.04-.47.12-.69.22l-1.7-1.73c.17-.13.35-.25.54-.35zm11.05.03 1.3 1.31c-.2.11-.43.2-.66.26l-.57-.58.05-.39c0-.2-.04-.4-.12-.6zm-11.79.44 1.71 1.72a3.3 3.3 0 0 0-.5.41l-1.7-1.67c.15-.17.31-.32.5-.46zm-.64.6 1.69 1.7c-.15.16-.27.35-.37.54L6.9 17.97c.14-.19.28-.35.42-.51zm12.43.18.4.41c-.25.07-.5.12-.77.14.16-.15.28-.34.37-.55zm-12.96.51 1.76 1.77c-.1.24-.16.49-.18.74l-1.9-1.93c.09-.2.2-.4.32-.58zm-.43.79 2 2.02c.02.44.13.88.32 1.27l-2.55-2.59c.07-.24.14-.46.23-.7zm-.28.95 3.5 3.51c-.19.11-.35.26-.48.42l-3.12-3.1c0-.28.04-.56.1-.83zm-.1 1.13 3 3.01c-.12.22-.18.45-.18.7v.05l-2.68-2.7c-.1-.34-.14-.7-.14-1.06zm.25 1.49 2.63 2.64c.04.16.11.31.2.45a5.14 5.14 0 0 1-2.83-3.1z',
        'female-solid' => 'M16 2a3.98 3.98 0 0 0-2.75 6.88c-.24.17-.46.35-.66.56A6.54 6.54 0 0 0 11 12.8h.03l-2 10-.25 1.2H13v6h2v-6h2v6h2v-6h4.22l-.25-1.19-2-10A6.65 6.65 0 0 0 19.4 9.5a4.7 4.7 0 0 0-.7-.63A3.95 3.95 0 0 0 16 2Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm0 6c.83 0 1.42.32 1.94.88a4.8 4.8 0 0 1 1.1 2.3L20.77 22h-9.56l1.75-8.81H13c.18-1 .56-1.84 1.06-2.38.5-.53 1.1-.81 1.94-.81Z',
        'fighter-jet-solid' => 'm7.88 4 1 9h-.85l-1.72-2.56-.28-.44H1.78l.25 1.19L3 16l-.97 4.81L1.78 22h4.25l.28-.44L8.03 19h.85l-1 9h3.53l.3-.28L20.45 19H26c1.16 0 1.9-.67 2.56-1.22.67-.55 1.16-1.1 1.16-1.1l.66-.68-.66-.69s-.49-.54-1.16-1.1C27.9 13.68 27.16 13 26 13h-5.56l-8.72-8.72L11.4 4Zm2.25 2h.43l8.72 8.72.31.28H26c-.05 0 .73.33 1.28.78l.25.22-.25.22c-.55.45-1.33.78-1.28.78h-6.4l-.32.28L10.56 26h-.44l1-9H6.95l-.28.44L4.94 20h-.72l.75-3.81.06-.19-.06-.19L4.22 12h.72l1.72 2.56.28.44h4.18ZM16 7l2 2h2l1-1-1-1Zm2 16-2 2h4l1-1-1-1Z',
        'figma' => 'M12.5 1a5.5 5.5 0 0 0-3.6 9.65A5.5 5.5 0 0 0 8.35 20 5.5 5.5 0 1 0 17 24.5V12h3.5a5.5 5.5 0 0 0 0-11h-8zm0 2h8a3.5 3.5 0 0 1 0 7h-8a3.5 3.5 0 0 1 0-7zm-1 9H15v7h-3.5a3.5 3.5 0 0 1 0-7zm9.5 0a4 4 0 0 0 0 8 4 4 0 0 0 0-8zm-9.5 9H15v3.5a3.5 3.5 0 1 1-3.5-3.5z',
        'file-alt-solid' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM11 13v2h10v-2Zm0 4v2h10v-2Zm0 4v2h10v-2Z',
        'file-alt' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM11 13v2h10v-2Zm0 4v2h10v-2Zm0 4v2h10v-2Z',
        'file-archive-solid' => 'M6 3v26h20V3Zm2 2h7v1h2V5h7v22H8Zm7 2v2h2V7Zm0 3v2h2v-2Zm0 3v2.19A3 3 0 0 0 13 18c0 1.64 1.36 3 3 3s3-1.36 3-3c0-1.3-.84-2.4-2-2.81V13Zm1 4c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'file-archive' => 'M6 3v26h20V3Zm2 2h7v1h2V5h7v22H8Zm7 2v2h2V7Zm0 3v2h2v-2Zm0 3v2.19A3 3 0 0 0 13 18c0 1.64 1.36 3 3 3s3-1.36 3-3c0-1.3-.84-2.4-2-2.81V13Zm1 4c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'file-audio-solid' => 'M6 3v26h20V3Zm2 2h16v22H8Zm8 4.72v6.47a2.95 2.95 0 0 0-1-.19c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3v-6.72l2.75.69.5-1.94ZM15 18c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'file-audio' => 'M6 3v26h20V3Zm2 2h16v22H8Zm8 4.72v6.47a2.95 2.95 0 0 0-1-.19c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3v-6.72l2.75.69.5-1.94ZM15 18c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'file-code-solid' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM16 13l-2 12h2l2-12Zm-3.78 2.38-2.5 3-.53.62.53.63 2.5 3 1.56-1.25L11.81 19l1.97-2.38Zm7.56 0-1.56 1.24L20.19 19l-1.97 2.38 1.56 1.25 2.5-3 .53-.63-.53-.63Z',
        'file-code' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM16 13l-2 12h2l2-12Zm-3.78 2.38-2.5 3-.53.62.53.63 2.5 3 1.56-1.25L11.81 19l1.97-2.38Zm7.56 0-1.56 1.24L20.19 19l-1.97 2.38 1.56 1.25 2.5-3 .53-.63-.53-.63Z',
        'file-contract-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM10 9v2h6V9h-6zm0 4v2h12v-2H10zm3.5 3c-.9 0-1.6.6-2 1.3-.4.7-.5 1.6-.5 2.6 0 .6.2 1.2.3 1.8-.4.1-.8.4-1.3.4v2c.7 0 1.4-.1 2-.3.1.2.1.3.3.5.4.4 1 .7 1.7.7 1.6 0 2.6-1.1 3.3-1.9.1-.2.2-.3.3-.4 0 .1 0 .2.1.3.1.2.2.4.4.6.2.2.6.4.9.4.6 0 1-.4 1.2-.6.2-.2.4-.5.6-.7.4-.4.7-.7 1.1-.7v-2c-1.2 0-2.1.7-2.6 1.3 0-.1 0-.2-.1-.3-.1-.2-.2-.4-.4-.7-.2-.3-.5-.3-.8-.3-.8 0-1.1.5-1.4.8-.3.3-.6.7-.8 1.1-.6.7-1 1.1-1.8 1.1-.1 0-.1-.1-.2-.1.1 0 .1-.1.2-.1 1.1-.9 2-2.1 2-3.7 0-.8-.2-1.5-.6-2.1-.4-.6-1.1-1-1.9-1zm-.1 2c.3 0 .3 0 .4.2.1.2.2.5.2 1 0 .6-.3 1.2-.8 1.7 0-.3-.2-.7-.2-.9 0-.8.1-1.4.3-1.7.1-.2.1-.3.1-.3z',
        'file-csv-solid' => 'M6 3v7h2V5h16v5h2V3Zm3.5 9A2.5 2.5 0 0 0 7 14.5v3a2.5 2.5 0 1 0 5 0V17h-2v.5c0 .21-.29.5-.5.5-.21 0-.5-.29-.5-.5v-3c0-.21.29-.5.5-.5.21 0 .5.29.5.5v.5h2v-.5A2.5 2.5 0 0 0 9.5 12Zm6 0a2.5 2.5 0 1 0 0 5c.21 0 .5.29.5.5 0 .3-.12.5-.5.5-.37 0-.43-.08-.44-.1 0 0-.06-.07-.06-.3h-2c0 .56.16 1.2.63 1.68.46.49 1.14.72 1.87.72a2.5 2.5 0 1 0 0-5c-.21 0-.5-.29-.5-.5 0-.21.29-.5.5-.5.27 0 .35.06.4.13.06.06.1.16.1.28h2c0-.6-.21-1.2-.66-1.66A2.54 2.54 0 0 0 15.5 12Zm3.5 0v1.16l.06.15 2 6 .94 2.85.94-2.85 2-6 .06-.15V12h-2v.88l-1 3-1-3V12ZM6 22v7h20v-7h-2v5H8v-5Z',
        'file-download-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM15 13v5h-3l4 4 4-4h-3v-5h-2zm-3 10v2h8v-2h-8z',
        'file-excel-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM11 13l3.8 5.5L11 24h2.4l2.6-3.8 2.6 3.8H21l-3.8-5.5L21 13h-2.4L16 16.8 13.4 13H11z',
        'file-excel' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM11 13l3.8 5.5L11 24h2.4l2.6-3.8 2.6 3.8H21l-3.8-5.5L21 13h-2.4L16 16.8 13.4 13H11z',
        'file-export-solid' => 'M6 4v24h20v-8l-2 2v4H8V6h16v4l2 2V4Zm16.4 7L21 12.4l2.56 2.6h-9.65v2h9.65L21 19.6l1.4 1.4 4.32-4.28.69-.72-.7-.72Z',
        'file-image-solid' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM21.1 14a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM14 15.6l-.72.68-4 4 1.44 1.44L14 18.44l2.28 2.28.72.69.72-.7L19 19.45l2.28 2.28 1.44-1.44-3-3-.72-.69-.72.7L17 18.55l-2.28-2.28Z',
        'file-image' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20ZM21.1 14a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM14 15.6l-.72.68-4 4 1.44 1.44L14 18.44l2.28 2.28.72.69.72-.7L19 19.45l2.28 2.28 1.44-1.44-3-3-.72-.69-.72.7L17 18.55l-2.28-2.28Z',
        'file-import-solid' => 'M6 4v24h20v-9h-2v7H8V6h16v7h2V4Zm11.5 7-4.31 4.28-.69.72.69.72L17.5 21l1.4-1.4-2.59-2.6H28v-2H16.31l2.6-2.6Z',
        'file-invoice-dollar-solid' => 'M6 3v26h16v-2H8V5h10v6h6v2h2V9.6l-.3-.3-6-6-.3-.3H6zm14 3.4L22.6 9H20V6.4zM10 13v2h12v-2H10zm17 2v2c-1.7.3-3 1.7-3 3.5 0 2 1.5 3.5 3.5 3.5h1c.8 0 1.5.7 1.5 1.5s-.7 1.5-1.5 1.5H25v2h2v2h2v-2c1.7-.3 3-1.7 3-3.5 0-2-1.5-3.5-3.5-3.5h-1c-.8 0-1.5-.7-1.5-1.5s.7-1.5 1.5-1.5H31v-2h-2v-2h-2zm-17 3v2h7v-2h-7zm9 0v2h3v-2h-3zm-9 4v2h7v-2h-7zm9 0v2h3v-2h-3z',
        'file-invoice-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM10 13v2h12v-2H10zm0 5v2h7v-2h-7zm9 0v2h3v-2h-3zm-9 4v2h7v-2h-7zm9 0v2h3v-2h-3z',
        'file-medical-alt-solid' => 'M6 3v11h1.37L8 12.42V5h10v6h6v16H8v-5.75l-.05-.06L6.75 20H6v9h20V9.6l-.28-.32-6-6L19.4 3H6zm14 3.44L22.56 9H20V6.44zm-9.03 3.95-2.34 5.83-.22-.22H2v2h5.59l1.77 1.78 1.67-4.17 3 7 2.07-5.17.28.56h1.89a2 2 0 1 0 0-2h-.65l-1.72-3.44-1.93 4.83-3-7z',
        'file-medical-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM15 14v3h-3v2h3v3h2v-3h3v-2h-3v-3h-2z',
        'file-pdf-solid' => 'M6 3v26h20V3Zm2 2h16v22H8Zm7.4 5.34c-.3 0-.65.1-.9.32a1.4 1.4 0 0 0-.44.75c-.13.54-.1 1.1.03 1.71.16.73.59 1.6.94 2.44-.18.76-.23 1.44-.5 2.22-.23.67-.53 1.06-.81 1.66-.63.24-1.38.38-1.88.68-.53.34-1 .7-1.28 1.22a1.8 1.8 0 0 0 .13 1.79c.18.27.42.5.75.62.32.13.67.13.97.03.59-.2 1-.66 1.4-1.19.37-.49.64-1.32.97-2 .5-.16.87-.38 1.4-.5.57-.12.95-.06 1.48-.12.22.26.41.67.65.87.48.42 1 .75 1.63.79.62.03 1.25-.36 1.6-.94h.02v-.03c.15-.27.26-.56.25-.88 0-.32-.17-.66-.37-.87-.41-.44-.94-.55-1.5-.63-.44-.06-1.05.1-1.57.13-.45-.6-.9-1.05-1.3-1.82-.23-.41-.29-.76-.48-1.18.15-.68.43-1.44.47-2.04a4.6 4.6 0 0 0-.18-1.9 1.8 1.8 0 0 0-.54-.78 1.5 1.5 0 0 0-.9-.35h-.03Zm.66 7.41c.18.32.4.52.6.81-.29.05-.5 0-.79.07-.04 0-.07.05-.12.06.06-.16.13-.25.19-.4.06-.2.06-.36.12-.54Zm3.69 2.03c.34.04.46.1.5.13v.03c-.13.2-.14.19-.22.18-.07 0-.32-.14-.56-.3.07 0 .22-.05.28-.04Zm-7 1.56c-.05.09-.1.28-.16.35-.3.4-.58.6-.65.62-.01-.01.02 0 0-.03h-.03c-.1-.14-.08-.08 0-.22.07-.13.3-.4.71-.65l.13-.07Z',
        'file-pdf' => 'M6 3v26h20V3Zm2 2h16v22H8Zm7.4 5.34c-.3 0-.65.1-.9.32a1.4 1.4 0 0 0-.44.75c-.13.54-.1 1.1.03 1.71.16.73.59 1.6.94 2.44-.18.76-.23 1.44-.5 2.22-.23.67-.53 1.06-.81 1.66-.63.24-1.38.38-1.88.68-.53.34-1 .7-1.28 1.22a1.8 1.8 0 0 0 .13 1.79c.18.27.42.5.75.62.32.13.67.13.97.03.59-.2 1-.66 1.4-1.19.37-.49.64-1.32.97-2 .5-.16.87-.38 1.4-.5.57-.12.95-.06 1.48-.12.22.26.41.67.65.87.48.42 1 .75 1.63.79.62.03 1.25-.36 1.6-.94h.02v-.03c.15-.27.26-.56.25-.88 0-.32-.17-.66-.37-.87-.41-.44-.94-.55-1.5-.63-.44-.06-1.05.1-1.57.13-.45-.6-.9-1.05-1.3-1.82-.23-.41-.29-.76-.48-1.18.15-.68.43-1.44.47-2.04a4.6 4.6 0 0 0-.18-1.9 1.8 1.8 0 0 0-.54-.78 1.5 1.5 0 0 0-.9-.35h-.03Zm.66 7.41c.18.32.4.52.6.81-.29.05-.5 0-.79.07-.04 0-.07.05-.12.06.06-.16.13-.25.19-.4.06-.2.06-.36.12-.54Zm3.69 2.03c.34.04.46.1.5.13v.03c-.13.2-.14.19-.22.18-.07 0-.32-.14-.56-.3.07 0 .22-.05.28-.04Zm-7 1.56c-.05.09-.1.28-.16.35-.3.4-.58.6-.65.62-.01-.01.02 0 0-.03h-.03c-.1-.14-.08-.08 0-.22.07-.13.3-.4.71-.65l.13-.07Z',
        'file-powerpoint-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM13 13v2h4c1.2 0 2 .8 2 2s-.8 2-2 2-2-.8-2-2h-2v7h2v-3.6c.6.4 1.3.6 2 .6 2.2 0 4-1.8 4-4s-1.8-4-4-4h-4z',
        'file-powerpoint' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM13 13v2h4c1.2 0 2 .8 2 2s-.8 2-2 2-2-.8-2-2h-2v7h2v-3.6c.6.4 1.3.6 2 .6 2.2 0 4-1.8 4-4s-1.8-4-4-4h-4z',
        'file-prescription-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM11 11v9h2v-3h.6l2.5 4.4L14 25h2l1-1.8 1 1.8h2l-2-3.6 2-3.4h-2l-1 1.7-1.7-3c1-.5 1.6-1.5 1.6-2.7 0-1.6-1.4-3-3-3H11zm2 2h1c.6 0 1 .4 1 1s-.4 1-1 1h-1v-2z',
        'file-signature-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM10 13v2h12v-2H10zm3.5 3c-.9 0-1.6.6-2 1.3-.4.7-.5 1.6-.5 2.6 0 .6.2 1.2.3 1.8-.4.1-.8.4-1.3.4v2c.7 0 1.4-.1 2-.3.1.2.1.3.3.5.4.4 1 .7 1.7.7 1.6 0 2.6-1.1 3.3-1.9.1-.2.2-.3.3-.4 0 .1 0 .2.1.3.1.2.2.4.4.6.2.2.6.4.9.4.6 0 1-.4 1.2-.6.2-.2.4-.5.6-.7.4-.4.7-.7 1.1-.7v-2c-1.2 0-2.1.7-2.6 1.3 0-.1 0-.2-.1-.3-.1-.2-.2-.4-.4-.7-.2-.3-.5-.3-.8-.3-.8 0-1.1.5-1.4.8-.3.3-.6.7-.8 1.1-.6.7-1 1.1-1.8 1.1-.1 0-.1-.1-.2-.1.1 0 .1-.1.2-.1 1.1-.9 2-2.1 2-3.7 0-.8-.2-1.5-.6-2.1-.4-.6-1.1-1-1.9-1zm-.1 2c.3 0 .3 0 .4.2.1.2.2.5.2 1 0 .6-.3 1.2-.8 1.7 0-.3-.2-.7-.2-.9 0-.8.1-1.4.3-1.7.1-.2.1-.3.1-.3z',
        'file-solid' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20Z',
        'file-upload-solid' => 'M6 3v26h20V9.6l-.3-.3-6-6-.3-.3H6zm2 2h10v6h6v16H8V5zm12 1.4L22.6 9H20V6.4zM16 13l-4 4h3v5h2v-5h3l-4-4zm-4 10v2h8v-2h-8z',
        'file-video-solid' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20Zm-7 6.78v9.56l1.5-.94 5-3 1.44-.84-1.44-.84-5-3Zm2 3.53L17.1 18 15 19.25Z',
        'file-video' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20Zm-7 6.78v9.56l1.5-.94 5-3 1.44-.84-1.44-.84-5-3Zm2 3.53L17.1 18 15 19.25Z',
        'file-word-solid' => 'M6 3v26h20V3Zm2 2h16v22H8Zm10 7v6.5c0 .21-.29.5-.5.5-.04 0 .02.05-.06-.06s-.21-.39-.28-.69C17 17.65 17 17 17 17v-2h-2v4.5c0 .21-.29.5-.5.5-.21 0-.5-.29-.5-.5V13h-4v2h2v4.5a2.5 2.5 0 0 0 2.5 2.5c.98 0 1.69-.64 2.1-1.47.3.19.51.47.9.47a2.5 2.5 0 0 0 2.5-2.5V14h2v-2Z',
        'file-word' => 'M6 3v26h20V3Zm2 2h16v22H8Zm10 7v6.5c0 .21-.29.5-.5.5-.04 0 .02.05-.06-.06s-.21-.39-.28-.69C17 17.65 17 17 17 17v-2h-2v4.5c0 .21-.29.5-.5.5-.21 0-.5-.29-.5-.5V13h-4v2h2v4.5a2.5 2.5 0 0 0 2.5 2.5c.98 0 1.69-.64 2.1-1.47.3.19.51.47.9.47a2.5 2.5 0 0 0 2.5-2.5V14h2v-2Z',
        'file' => 'M6 3v26h20V9.6l-.28-.32-6-6L19.4 3Zm2 2h10v6h6v16H8Zm12 1.44L22.56 9H20Z',
        'fill-drip-solid' => 'M11.3 3.3 9.9 4.7l1.8 1.8-6.9 6.9a3.02 3.02 0 0 0 0 4.3l.1.1 6.3 6.3c1.2 1.2 3.1 1.2 4.3 0l7.6-7.6.7-.7-9.7-9.7-.8-.8-.2-.2-1.8-1.8zm1.8 4.6 7.9 7.9-2.2 2.2H7.9l-1.7-1.7c-.4-.4-.4-1.1 0-1.5l6.9-6.9zM25 19.3l-.8 1.2s-.5.8-1.1 1.7c-.3.5-.5.9-.7 1.4-.2.5-.4.8-.4 1.4 0 1.6 1.4 3 3 3s3-1.4 3-3c0-.6-.2-1-.4-1.5s-.5-1-.7-1.4c-.5-.9-1.1-1.7-1.1-1.7l-.8-1.1z',
        'fill-solid' => 'm11.31 3.28-1.4 1.44 1.78 1.78-6.9 6.9a3.06 3.06 0 0 0 0 4.32l.05.06 6.35 6.31a3.06 3.06 0 0 0 4.31 0l7.6-7.59.71-.69L14.1 6.1l-.78-.8-.22-.2Zm1.81 4.66L21 15.8l-6.9 6.88c-.42.42-1.09.42-1.5 0l-6.38-6.4a1.02 1.02 0 0 1 0-1.48ZM25 19.25l-.81 1.19s-.54.75-1.07 1.65c-.26.46-.5.93-.71 1.41-.21.48-.41.92-.41 1.5 0 1.64 1.36 3 3 3s3-1.36 3-3c0-.58-.2-1.02-.4-1.5-.22-.48-.46-.95-.73-1.4-.52-.9-1.06-1.66-1.06-1.66Zm0 3.63.13.21c.23.41.49.85.65 1.22.17.37.22.72.22.69a1 1 0 0 1-1 1 1 1 0 0 1-1-1c0 .03.05-.32.22-.69.16-.37.42-.8.66-1.22l.12-.21Z',
        'film-solid' => 'M4 4v24h24V4Zm2 2h2v1h2V6h12v1h2V6h2v20h-2v-1h-2v1H10v-1H8v1H6Zm2 3v2h2V9Zm14 0v2h2V9ZM8 13v2h2v-2Zm14 0v2h2v-2ZM8 17v2h2v-2Zm14 0v2h2v-2ZM8 21v2h2v-2Zm14 0v2h2v-2Z',
        'filter-solid' => 'M5 4v2.34l.22.29L13 16.34V28l1.6-1.19 4-3 .4-.31v-7.16l7.78-9.71.22-.29V4Zm2.28 2h17.44l-7.19 9h-3.06ZM15 17h2v5.5L15 24Z',
        'fingerprint-solid' => 'M16 4c-.26 0-.5.02-.75.03a13 13 0 0 0-4.06.88l.75 1.87c1.08-.43 2.21-.68 3.4-.75.21-.01.43-.03.66-.03a11 11 0 0 1 5.22 1.31l.94-1.75A12.98 12.98 0 0 0 16 4ZM9.5 5.72a13.05 13.05 0 0 0-3.19 2.6c-.41.45-.77.97-1.12 1.5-.39.56-.72 1.16-1 1.77l1.81.82a11.2 11.2 0 0 1 4.5-4.94Zm14.47 1-1.22 1.6a10.93 10.93 0 0 1 4.22 8.09c0 .06.05.6 0 1.53l2 .12c.05-1 0-1.66 0-1.78a12.94 12.94 0 0 0-5-9.56ZM16 7v2a8 8 0 0 1 8 7.56c0 .12.13 3.07-1 6.63l1.9.6a22.24 22.24 0 0 0 1.1-7.32C25.71 11.17 21.3 7 16 7Zm-1.84.16a9.9 9.9 0 0 0-6.5 4.3h.03v.04A9.84 9.84 0 0 0 6 17.4v.58l2 .06v-.66a7.86 7.86 0 0 1 2.03-5.71 7.96 7.96 0 0 1 4.5-2.54ZM15.59 10a6.9 6.9 0 0 0-4.25 1.78l1.32 1.5A5 5 0 0 1 15.72 12H16c.58 0 1.14.1 1.66.28l.68-1.87A7.09 7.09 0 0 0 16 10h-.4Zm4.29 1.16-1.1 1.68A4.95 4.95 0 0 1 21 16.72l2-.1a7.05 7.05 0 0 0-3.13-5.46ZM15.78 13a4.01 4.01 0 0 0-2.75 1.34A3.98 3.98 0 0 0 12 17.22s.05 1.12-.4 2.44a6.34 6.34 0 0 1-3.35 3.75l-.63.28c-.33.15-.75.32-.84.34l.44 1.94c.44-.1.87-.3 1.25-.47l.65-.31a8.42 8.42 0 0 0 4.35-4.88 9 9 0 0 0 .53-3.18v-.04c-.03-.54.14-1.03.5-1.43.36-.41.85-.63 1.38-.66H16v-2h-.22Zm-5.62.13A6.96 6.96 0 0 0 9 17.34v.04c0 .08.09 2.26-2.06 3.3-.05.03-.8.32-1.94.32v2c1.57 0 2.75-.47 2.75-.47h.03l.03-.03c3.23-1.56 3.2-5.04 3.19-5.22v-.03a4.9 4.9 0 0 1 .84-3Zm7.75.34-.97 1.78c.6.32 1.02.9 1.06 1.63 0 .16.29 6.38-4.63 10.34l1.26 1.56c5.71-4.6 5.4-11.53 5.37-12a4 4 0 0 0-2.1-3.31ZM16 16a1 1 0 0 0-1 1v.06s.12 2.06-.9 4.38l1.8.81A12.7 12.7 0 0 0 17 17v-.06a1 1 0 0 0-1-.94Zm4.97 1.94c-.13 2.03-.77 6.2-3.72 9.68l1.5 1.29a18.76 18.76 0 0 0 4.22-10.85Zm-7.4 4.56a9.13 9.13 0 0 1-4 3.6l.87 1.8a11.3 11.3 0 0 0 4.84-4.4Z',
        'fire-alt-solid' => 'm16.8 4.4-3 4.99-1.85-1.85-.7.8C7.77 12.29 6 15.87 6 19c0 4.96 4.49 9 10 9s10-4.04 10-9c0-4.76-5.2-10.63-8.3-13.71l-.9-.9zm.4 3.22C19.76 10.31 24 15.3 24 19a6.8 6.8 0 0 1-3.48 5.77c.3-.72.48-1.5.48-2.34 0-2.38-1.68-5.2-3.1-7.15l-.84-1.17-2.22 3.32-1.4-1.4-.66 1.09C11.6 19.06 11 20.85 11 22.43c0 .84.18 1.62.48 2.34A6.8 6.8 0 0 1 8 19c0-2.39 1.4-5.32 4.06-8.53l2.14 2.14 3-4.99zm-.1 10.03c1.23 1.92 1.9 3.58 1.9 4.78C19 24.4 17.65 26 16 26s-3-1.6-3-3.57c0-.92.29-1.98.87-3.15l1.29 1.29 1.94-2.92z',
        'fire-extinguisher-solid' => 'M16 4c-1.3 0-2.4.84-2.81 2H12c-2.75 0-5 2.25-5 5h2a3 3 0 0 1 3-3h1v2.47c-.32.24-.73.58-1.22 1.06C10.95 12.36 10 13.5 10 15v13h12V15c0-1.5-.95-2.64-1.78-3.47-.49-.48-.9-.82-1.22-1.06v-.28l4.84.81 1.16.19V4.8l-1.16.2-5.09.84A3 3 0 0 0 16 4Zm0 2a1 1 0 0 1 1 1v3h-2V7a1 1 0 0 1 1-1Zm7 1.19V8.8l-4-.69v-.24ZM14.37 12h3.26c.15.1.57.4 1.15.97.67.67 1.22 1.53 1.22 2.03v11h-8V15c0-.5.55-1.36 1.22-2.03.58-.58 1-.86 1.15-.97ZM14 17v2h4v-2Z',
        'fire-solid' => 'm14.38 3-.2.78c-.3 1.35-2.23 3.57-4.21 6.28C7.98 12.78 6 16.16 6 20.41c0 2 .61 4.14 2.13 5.8C9.63 27.9 12.04 29 15.3 29c.15 0 .27-.03.4-.03.1 0 .2.03.29.03.3 0 .59-.04.88-.06.08-.01.16-.03.25-.03 3.34-.28 5.57-1.31 6.93-2.85C25.66 24.26 26 21.98 26 20c0-4.46-2.57-8.62-5.06-11.69-2.5-3.07-5-5.1-5-5.1L15.66 3Zm1.12 2.5c.8.71 2.17 2 3.88 4.1C21.73 12.5 24 16.32 24 20c0 1.75-.3 3.45-1.44 4.72a5.2 5.2 0 0 1-.87.78c.54-1.56.42-3.33.06-5.1a26.72 26.72 0 0 0-1.94-5.65 15.81 15.81 0 0 0-1.93-3.4l-.29-.35h-1.93l.37 1.28c1.05 3.4.5 5.72-.1 6.4-.29.35-.41.38-.71.29-.3-.1-.83-.48-1.35-1.44l-.74-1.4-.94 1.28c-1.87 2.52-2.6 5.28-1.97 7.59.05.2.14.4.22.6-.3-.23-.58-.46-.81-.73A6.64 6.64 0 0 1 8 20.41c0-3.62 1.7-6.57 3.6-9.16 1.53-2.1 3.03-3.88 3.9-5.75Zm3.06 11.72c.47 1.17.97 2.36 1.22 3.6.36 1.78.36 3.42-.16 4.46-.38.78-.97 1.36-2.18 1.6l-.44.06c-.31.02-.66.05-1 .06h-.25c-2.16-.07-3.2-1.04-3.6-2.5-.32-1.2.1-2.9 1-4.6.45.47.92.8 1.47.98a2.74 2.74 0 0 0 2.85-.88c.59-.7.94-1.65 1.1-2.78Z',
        'firefox' => 'M26.82 12.63a4.38 4.38 0 0 1-.32 1.17 10.97 10.97 0 0 0-.57-3.4 7.62 7.62 0 0 0-1.1-2.08c.2.85.32 1.5.32 1.98-.42-1.48-2.43-5.12-9.2-4.35 1.01 0 1.98.17 2.9.46l-.44-.02c1.45.41 2.38 1.07 2.5 1.38a2.6 2.6 0 0 0-1.44.1c3.05 1.2 4.5 2.64 4.33 4.29a1.59 1.59 0 0 0-.9-.69c.47 1.82.52 3.31.14 4.5-.26-.8-.5-1.26-.71-1.43.3 2.43-.1 4.23-1.2 5.4.21-.72.3-1.3.25-1.76-1.19 1.87-2.9 2.98-4.39 2.98a5.74 5.74 0 0 1-4.12-1.75c.16.02.33.02.49.02 2.56 0 3.33-1.5 4.03-1.5.1 0 .19.02.27.06.26-.04.4-.16.4-.33 0-.39-.83-1.05-1.72-1.05-1.04 0-1.26.7-2.32.7-1.32 0-2.5-1.81-2.5-1.81 0-.48.24-.79.64-.85-.1-.01.98.14 1.57.31a2.6 2.6 0 0 0-.38-1.77s.84-.8 1.46-1.12c.19-.1.3-.25.33-.45.06-.03.1-.12.1-.21s-.05-.16-.17-.23c-1.8.14-1.93-.88-2.6-1.27a3.66 3.66 0 0 1 1.69-2.44 5.11 5.11 0 0 0-2.95 1.46c-.47-.4-2.59-.54-3.1-.28a4.27 4.27 0 0 1-.72-1.98c-.79.77-1.17 2.16-1.15 4.17C6.2 10.89 5 12.4 5 13.48c0 .12.01.28.04.36l.64-.53A7.02 7.02 0 0 0 5.16 16c0 4.46 3.92 10.17 10.84 10.17 8.47 0 11-7.02 11-12.04 0-.6-.06-1.1-.18-1.5Z',
        'first-aid-solid' => 'M14 5a2 2 0 0 0-2 2v1H6c-1.64 0-3 1.36-3 3v15h26V11c0-1.64-1.36-3-3-3h-6V7a2 2 0 0 0-2-2Zm0 2h4v1h-4Zm-8 3h20c.57 0 1 .43 1 1v13H5V11c0-.57.43-1 1-1Zm9 3v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'first-order-alt' => 'M16 3a13 13 0 1 0 0 26 13 13 0 0 0 0-26zm0 1a12 12 0 1 1 0 24 12 12 0 0 1 0-24zm0 1a11 11 0 1 0 0 22 11 11 0 0 0 0-22zm0 1a10 10 0 1 1 0 20 10 10 0 0 1 0-20zm-.01 1c-.41 0-.82.03-1.23.09l.22 3.8-1.25-3.6c-.8.2-1.57.52-2.28.94l1.68 3.46-2.56-2.88a9.28 9.28 0 0 0-1.75 1.74l2.88 2.57-3.47-1.68a9.31 9.31 0 0 0-.94 2.27L10.93 15l-3.84-.23a8.66 8.66 0 0 0-.01 2.47l3.84-.23-3.63 1.27c.2.8.52 1.56.94 2.28l3.46-1.68-2.88 2.56a10 10 0 0 0 1.75 1.75l2.56-2.88-1.68 3.46c.72.43 1.48.74 2.28.95L15 21.06l-.23 3.85a8.62 8.62 0 0 0 2.46 0L17 21.04l1.28 3.67a9.19 9.19 0 0 0 2.27-.95l-1.68-3.46 2.56 2.86a8.7 8.7 0 0 0 1.73-1.73l-2.86-2.56 3.46 1.67c.42-.7.74-1.48.94-2.27L21.07 17l3.83.23a8.62 8.62 0 0 0 0-2.46l-3.84.22 3.64-1.27a9.23 9.23 0 0 0-.95-2.28l-3.46 1.68 2.87-2.56a8.97 8.97 0 0 0-1.73-1.73l-2.56 2.86 1.67-3.46c-.7-.4-1.47-.73-2.27-.94L17 10.92l.23-3.83c-.4-.06-.81-.09-1.24-.09z',
        'first-order' => 'M16 2 4 9v14l12 7 12-7V9L16 2zm0 1 11 6.49v13L16 29 5 22.49v-13L16 3zm0 1L6 10v12l10 6 10-6V10L16 4zm0 2.95c4.96 0 9 4.04 9 9.05a9.03 9.03 0 0 1-9 9.04c-4.98 0-9-4.05-9-9.04 0-5 4.02-9.05 9-9.05zM16 8c-.35 0-.73.03-1.08.08l.2 3.38L14 8.25a8 8 0 0 0-2 .84l1.48 3.08-2.27-2.56a8.2 8.2 0 0 0-1.54 1.55l2.54 2.29-3.06-1.5a7.67 7.67 0 0 0-.83 2.01l3.22 1.14-3.41-.2a8.2 8.2 0 0 0 0 2.19l3.4-.2-3.21 1.14c.18.7.46 1.38.83 2.01l3.06-1.49-2.55 2.27c.45.59.96 1.12 1.55 1.55l2.26-2.55L12 22.9a8.1 8.1 0 0 0 2 .85l1.12-3.24-.2 3.41a8.15 8.15 0 0 0 2.18 0l-.2-3.45 1.14 3.27c.7-.2 1.38-.47 2-.85l-1.48-3.07 2.25 2.55a7.6 7.6 0 0 0 1.55-1.55l-2.54-2.27 3.06 1.48c.36-.62.66-1.29.83-2.02l-3.21-1.12 3.4.2a7.9 7.9 0 0 0 0-2.2l-3.41.21 3.21-1.13a7.54 7.54 0 0 0-.83-2.01l-3.06 1.49 2.54-2.29a8.41 8.41 0 0 0-1.53-1.55l-2.27 2.56 1.48-3.07A8.11 8.11 0 0 0 18 8.25l-1.12 3.23.2-3.4A6.59 6.59 0 0 0 16 8z',
        'firstdraft' => 'M7 4v18h6v-6h6v-6h6V4H7zm14 8v6h-6v6H7v1h9v-6h6v-6h3v-1h-4zm3 3v6h-6v6h-8v1h9v-6h6v-7h-1zm-3 9v4h1v-3h3v-1h-4z',
        'fish-solid' => 'm10.5 6 .56 1.38c.35.85.83 2.99.72 4-1.36.83-2.2 1.66-2.84 2.34A7.53 7.53 0 0 0 4 12H3v1c0 1.91.7 3.47.94 4A9.34 9.34 0 0 0 3 21v1h1a7.6 7.6 0 0 0 4.94-1.72 16.56 16.56 0 0 0 5 3.47 6.1 6.1 0 0 0 .1 2.5l.18.75H15a6 6 0 0 0 3.16-1.16c.7-.44 1.04-.75 1.21-.9a9.5 9.5 0 0 0 7.88-4.4c1.4-2.2 1.75-4.38 1.75-4.38l.03-.25-.1-.25s-2.28-6.3-8.5-6.6a7.12 7.12 0 0 0-2.87-2A14.7 14.7 0 0 0 12 6Zm2.9 2.13c1.27.14 2.45.39 3.38.78a5.83 5.83 0 0 1 2.38 1.62l.28.47H20c5 0 6.8 4.73 6.94 5.13a9.66 9.66 0 0 1-1.38 3.34A7.24 7.24 0 0 1 19 23h-.38l-.28.25s-.52.45-1.25.9c-.38.24-.7.29-1.09.44.04-.45 0-1.12 0-1.12l.22-.88-.81-.28a15.2 15.2 0 0 1-5.66-3.97l-.69-.8-.75.74s-1.33.93-3.06 1.38c.26-1.18.66-2.22.66-2.22l.21-.44-.21-.44s-.44-1.15-.7-2.37c1.85.4 3.1 1.53 3.1 1.53l.75.75.69-.81c.9-1.02 3.3-3.54 6.84-4l-.28-1.97c-.95.12-1.79.4-2.6.72a9.68 9.68 0 0 0-.3-2.29ZM22.5 15a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'fist-raised-solid' => 'M16 6a3 3 0 0 0-2.53 1.4c-.44-.24-.93-.4-1.47-.4-1.64 0-3 1.36-3 3v3.66l-.13.15-.21.25c-.52.6-1 1.23-1.44 1.88l-.31.4c-.43.55-.7 1.2-.82 1.85-.01.07-.05.14-.06.22a4.43 4.43 0 0 0 1.06 3.53l2.38 2.68A6.98 6.98 0 0 0 14.72 27H20a7 7 0 0 0 7-7v-9c0-1.64-1.36-3-3-3-.54 0-1.03.16-1.47.4a2.95 2.95 0 0 0-4-1A3 3 0 0 0 16 6Zm0 2c.57 0 1 .43 1 1v2.19a2.95 2.95 0 0 0-1-.19h-1V9c0-.57.43-1 1-1Zm-4 1c.57 0 1 .43 1 1v1h-1.4l-.29.28-.31.31V10c0-.57.43-1 1-1Zm8 0c.57 0 1 .43 1 1v3c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-3c0-.57.43-1 1-1Zm4 1c.57 0 1 .43 1 1v2c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-2c0-.57.43-1 1-1Zm-11.56 3H16c.56 0 1 .44 1 1s-.44 1-1 1h-3.13l-.28.38-2.34 2.96 1.56 1.25 1.85-2.3a6 6 0 0 1 1.21.77C15.95 18.93 17 20.35 17 23h2a8.19 8.19 0 0 0-2.4-6.06c.8-.17 1.5-.67 1.93-1.35.44.25.93.41 1.47.41.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78.35 0 .68-.07 1-.19V20c0 2.77-2.23 5-5 5h-5.28c-1.44 0-2.8-.6-3.75-1.69L8.59 20.6A2.33 2.33 0 0 1 8 18.91l.03-.1v-.1c.05-.21.2-.63.53-1.18l.16-.22 1.47-1.93c1.1-1.3 2.02-2.17 2.25-2.38Z',
        'flag-checkered-solid' => 'M5 4v24h2v-8h20V4Zm2 2h3v3h3V6h3v3h3V6h3v3h3v3h-3v3h3v3h-3v-3h-3v3h-3v-3h-3v3h-3v-3H7v-3h3V9H7Zm3 6v3h3v-3Zm3 0h3V9h-3Zm3 0v3h3v-3Zm3 0h3V9h-3Z',
        'flag-solid' => 'M5 5v24h2V19h8v3h12V8H17V5Zm2 2h8v10H7Zm10 3h8v10h-8Z',
        'flag-usa-solid' => 'M3 7v10h26v-2H17v-2h12v-2H17V9h12V7H3zm2 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm-6 3a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zM5 14a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zM3 19v2h26v-2H3zm0 4v2h26v-2H3z',
        'flag' => 'M5 5v24h2V19h8v3h12V8H17V5Zm2 2h8v10H7Zm10 3h8v10h-8Z',
        'flask-solid' => 'M17 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3 3a1 1 0 0 0-1 1h-3v2h1v7.66l-6.16 7.93A3.98 3.98 0 0 0 7.97 28l16.06.01a3.98 3.98 0 0 0 3.13-6.4L21 13.65V6h1V4h-7a1 1 0 0 0-1-1Zm-1 3h6v8.34L21.84 18H10.16L13 14.34Zm4 4a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM8.6 20h14.8l2.2 2.81c.26.35.4.78.4 1.22 0 1.1-.86 1.97-1.97 1.97H7.97C6.87 26 6 25.14 6 24.03c0-.44.14-.87.4-1.22Z',
        'flickr' => 'M8 5C6.36 5 5 6.36 5 8v16c0 1.64 1.36 3 3 3h16c1.64 0 3-1.36 3-3V8c0-1.64-1.36-3-3-3Zm0 2h16c.57 0 1 .43 1 1v16c0 .57-.43 1-1 1H8c-.57 0-1-.43-1-1V8c0-.57.43-1 1-1Zm3.5 5.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Zm9 0a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Z',
        'flipboard' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm2 2v14h6v-4h4v-4h4V9H9zm2 2h10v2h-4v4h-4v4h-2V11z',
        'flushed-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 3a5.5 5.5 0 1 0 4.5 8.65 5.5 5.5 0 1 0 0-6.3A5.5 5.5 0 0 0 11.5 8zm0 2a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7zm9 0a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7zm-9 2a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM12 21v2h8v-2h-8z',
        'flushed' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 3a5.5 5.5 0 1 0 4.5 8.65 5.5 5.5 0 1 0 0-6.3A5.5 5.5 0 0 0 11.5 8zm0 2a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7zm9 0a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7zm-9 2a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM12 21v2h8v-2h-8z',
        'fly' => 'M16 4c-.16 0-.31.02-.47.03C10.83 4.26 7 7.85 7 12.34c0 2.95 1.79 5.54 3.47 7.41a23.5 23.5 0 0 0 3.34 3.06l.28.19h3.82l.28-.19s1.66-1.2 3.34-3.06c1.68-1.87 3.47-4.46 3.47-7.4 0-4.51-3.85-8.1-8.56-8.32A3.3 3.3 0 0 0 16 4Zm0 2c.27 0 1.11.31 1.78 1.16A6.43 6.43 0 0 1 19 11.22c0 4.32-2.27 9.01-2.66 9.78h-.68c-.39-.77-2.66-5.48-2.66-9.78 0-1.82.57-3.17 1.25-4.03C14.93 6.32 15.75 6 16 6Zm-4.1 1.22a8.93 8.93 0 0 0-.9 4c0 2.88.86 5.83 1.69 8-.25-.25-.48-.52-.75-.81C10.42 16.7 9 14.45 9 12.34c0-2.1 1.14-3.96 2.9-5.12Zm8.26.03a6.15 6.15 0 0 1 2.84 5.1c0 2.1-1.42 4.36-2.94 6.06-.26.29-.5.54-.75.78A23.5 23.5 0 0 0 21 11.22c0-1.57-.33-2.9-.84-3.97ZM14 25v3h4v-3Z',
        'folder-minus-solid' => 'M6 3v26h20V15.44l1.72-1.72.28-.31V3H6zm2 2h14v8.4l.28.32L24 15.44V27H8V5zm16 0h2v7.56l-1 1-1-1V5zM12 15v2h8v-2h-8z',
        'folder-open-solid' => 'M5 3v24.81l.78.16 12 2.5 1.22.25V28h6V15.44l1.72-1.72.28-.31V3Zm9.13 2H25v7.56l-1.72 1.72-.28.31V26h-4v-8.9l-.28-.32L17 15.06V5.72ZM7 5.28l8 2v8.63l.28.3L17 17.95v10.34l-10-2.1Z',
        'folder-open' => 'M5 3v24.81l.78.16 12 2.5 1.22.25V28h6V15.44l1.72-1.72.28-.31V3Zm9.13 2H25v7.56l-1.72 1.72-.28.31V26h-4v-8.9l-.28-.32L17 15.06V5.72ZM7 5.28l8 2v8.63l.28.3L17 17.95v10.34l-10-2.1Z',
        'folder-plus-solid' => 'M6 3v26h20V15.44l1.72-1.72.28-.31V3H6zm2 2h14v8.4l.28.32L24 15.44V27H8V5zm16 0h2v7.56l-1 1-1-1V5zm-9 7v3h-3v2h3v3h2v-3h3v-2h-3v-3h-2z',
        'folder-solid' => 'M6 3v26h20V15.44l1.72-1.72.28-.31V3Zm2 2h14v8.4l.28.32L24 15.44V27H8Zm16 0h2v7.56l-1 1-1-1Z',
        'folder' => 'M6 3v26h20V15.44l1.72-1.72.28-.31V3Zm2 2h14v8.4l.28.32L24 15.44V27H8Zm16 0h2v7.56l-1 1-1-1Z',
        'font-awesome-alt' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm5.5 2a1.5 1.5 0 0 0-1.5 1.5V22a1 1 0 0 0 2 0v-4.26a7.34 7.34 0 0 1 2.48-.5c1.58 0 2.19.81 3.5.81.94 0 1.82-.32 2.64-.67.2-.09.38-.18.38-.38v-5.62c0-.2-.2-.38-.44-.38-.3 0-1.52.79-2.63.79-.23 0-.44-.03-.64-.12-1-.38-1.87-.67-2.98-.67-.49 0-1 .08-1.48.2A1.5 1.5 0 0 0 12.5 9z',
        'font-awesome-flag' => 'M9 4a3 3 0 0 0-1 5.82v17.2c0 .54.44.98.98.98h.04c.54 0 .98-.44.98-.98v-4.8c.33-.38 1.14-1.17 3.45-1.17a8 8 0 0 1 3.28.88c1.04.44 2.11.9 3.36.9a7.45 7.45 0 0 0 4.64-1.78l.16-.11C25.44 20.54 26 20 26 19v-8.32C26 9.77 25.22 9 24.3 9c-.5 0-.86.29-1.36.68-.66.53-1.66 1.32-2.85 1.32-.82 0-1.61-.38-2.54-.82A9.2 9.2 0 0 0 13.45 9a7.6 7.6 0 0 0-2.74.46A3 3 0 0 0 9 4zm0 2a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm4.44 5c1.2 0 2.2.48 3.25.98A7.79 7.79 0 0 0 20.1 13c1.75 0 3.07-.95 3.9-1.6v7.67s-.04.08-.28.25l-.2.15a5.53 5.53 0 0 1-3.42 1.35c-.84 0-1.64-.34-2.57-.73a9.98 9.98 0 0 0-4.08-1.05 7.6 7.6 0 0 0-3.44.71v-7.39c.35-.45 1.13-1.36 3.44-1.36z',
        'font-awesome' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm5.5 2a1.5 1.5 0 0 0-1.5 1.5V22a1 1 0 0 0 2 0v-4.26a7.34 7.34 0 0 1 2.48-.5c1.58 0 2.19.81 3.5.81.94 0 1.82-.32 2.64-.67.2-.09.38-.18.38-.38v-5.62c0-.2-.2-.38-.44-.38-.3 0-1.52.79-2.63.79-.23 0-.44-.03-.64-.12-1-.38-1.87-.67-2.98-.67-.49 0-1 .08-1.48.2A1.5 1.5 0 0 0 12.5 9z',
        'font-solid' => 'M15 6 8 26h2l2.1-6h7.8l2.1 6h2L17 6Zm1 2.84L19.19 18H12.8Z',
        'fonticons-fi' => 'M5 5v22h22V5Zm2 2h18v18H7Zm12.72 1.9-.69 1.29h-1.25l-.16.44 1 1.06-.4 1.5s.29.35.31.34l1.4-.78 1.38.78.38-.34-.44-1.5 1-1.1-.22-.4h-1.22l-.68-1.28Zm-5.34 1.82c-3.5 0-3.41 2.65-3.41 2.65v1.38H9.69v1.69h1.25v5.37l-1.25.16v1.16h5.87V22l-2.1-.22v-5.34h2.5l.5-1.69h-3V13s.18-.75.82-.75c.65 0 .75.6.75.6v.5l2.25-.32s.42-2.31-2.9-2.31Zm3.43 4.06-.37 1.28 1.18.35c.15.04.25.16.25.3v4.79c0 .16-.12.28-.28.31l-.93.19v1.13h4.56v-1.1l-.53-.1a.36.36 0 0 1-.28-.34v-6.8Z',
        'fonticons' => 'M5 5v22h22V5Zm2 2h18v18H7Zm12.72 1.9-.69 1.29h-1.25l-.16.44 1 1.06-.4 1.5s.29.35.31.34l1.4-.78 1.38.78.38-.34-.44-1.5 1-1.1-.22-.4h-1.22l-.68-1.28Zm-5.34 1.82c-3.5 0-3.41 2.65-3.41 2.65v1.38H9.69v1.69h1.25v5.37l-1.25.16v1.16h5.87V22l-2.1-.22v-5.34h2.5l.5-1.69h-3V13s.18-.75.82-.75c.65 0 .75.6.75.6v.5l2.25-.32s.42-2.31-2.9-2.31Zm3.43 4.06-.37 1.28 1.18.35c.15.04.25.16.25.3v4.79c0 .16-.12.28-.28.31l-.93.19v1.13h4.56v-1.1l-.53-.1a.36.36 0 0 1-.28-.34v-6.8Z',
        'football-ball-solid' => 'M21.03 4A18.16 18.16 0 0 0 9.1 9.1a18.2 18.2 0 0 0-4.87 9.65c-.53 3.2-.22 6.06 1.37 7.66 1.6 1.59 4.46 1.92 7.66 1.4s6.79-2.03 9.66-4.9a17.81 17.81 0 0 0 4.87-9.6c.53-3.2.23-6.08-1.34-7.72h-.03v-.03a6.04 6.04 0 0 0-3.29-1.43A11.7 11.7 0 0 0 21.04 4Zm0 2.03c.63 0 1.23.04 1.75.13a4.49 4.49 0 0 1 2.22.87c.72.79 1.28 3.17.81 5.97a15.87 15.87 0 0 1-4.31 8.5 15.84 15.84 0 0 1-8.56 4.34C10.12 26.3 7.7 25.71 7 25c-.7-.7-1.28-3.11-.81-5.94a16.18 16.18 0 0 1 4.31-8.56 16.14 16.14 0 0 1 8.53-4.31c.7-.12 1.37-.16 2-.16Zm.25 3.25L19 11.56l-1.78-1.78-1.44 1.44L17.56 13 16 14.56l-1.78-1.78-1.44 1.44L14.56 16 13 17.56l-1.78-1.78-1.44 1.44L11.56 19l-2.28 2.28 1.44 1.44L13 20.44l1.78 1.78 1.44-1.44L14.44 19 16 17.44l1.78 1.78 1.44-1.44L17.44 16 19 14.44l1.78 1.78 1.44-1.44L20.44 13l2.28-2.28Z',
        'fort-awesome-alt' => 'M15.5 3a12.5 12.5 0 1 0 0 25 12.5 12.5 0 0 0 0-25zm0 2a10.51 10.51 0 0 1 0 21 10.51 10.51 0 0 1 0-21zM15 8v5h-1v-1h-1v1h-1v-1h-1v6H9v-1H8v2.49a8.52 8.52 0 0 0 6 4.37V20.5c0-.82.68-1.5 1.5-1.5s1.5.68 1.5 1.5v3.36a8.52 8.52 0 0 0 6-4.37V17h-1v1h-2v-6h-1v1h-1v-1h-1v1h-1v-3s.39-.23.9-.23c.5 0 .78.23 1.19.23.55 0 .91-.23.91-.23V8s-.36.23-.91.23c-.41 0-.69-.23-1.19-.23-.51 0-.9.23-.9.23V8h-1zm-2 7h1v2h-1v-2zm4 0h1v2h-1v-2z',
        'fort-awesome' => 'M15.5 4a.5.5 0 0 0-.5.5V12h-2v-2h-2v2H9v-2H7v9H5v-2H3v10h10v-3a3 3 0 1 1 6 0v3h10V17h-2v2h-2v-9h-2v2h-2v-2h-2v2h-2v-2h-1V7.9c.27-.1.73-.22 1.28-.23.76-.01 1.13.2 1.94.29.35.04.85.07 1.48 0 .17-.03.3-.18.3-.35V4.43c0-.1-.11-.17-.24-.15-.66.08-1.17.05-1.54.01-.8-.09-1.18-.3-1.94-.29-.55.01-1 .14-1.28.24v.26a.5.5 0 0 0-.5-.5zM11 14h2v4h-2v-4zm8 0h2v4h-2v-4z',
        'forumbee' => 'M16 2.97a13.04 13.04 0 0 0-12.72 15.9c2.7-7.01 8.14-12.9 15.44-15.62A13 13 0 0 0 16 2.97Zm7.38 2.31a27.02 27.02 0 0 0-18.1 18.13 13.2 13.2 0 0 0 2.6 2.78C12.36 12.63 22.63 8.83 26.18 7.9c-.79-1-1.75-1.9-2.8-2.63Zm4.59 5.6C16.38 14.6 12.16 24.31 10.94 27.96c1.04.44 2.15.75 3.31.9A26.65 26.65 0 0 1 28.88 14.2a12.9 12.9 0 0 0-.91-3.31Zm.9 6.96c-1.2.6-3.16 1.81-5.84 4.32-3.04 2.84-4.46 5.3-5.06 6.68a13 13 0 0 0 4.81-1.75L29 29s-1.23-4.6-1.84-6.34a12.93 12.93 0 0 0 1.71-4.82Z',
        'forward-solid' => 'M15 5v7.38l-8.4-6.2L5 5.04v21.94l1.6-1.16 8.4-6.18V27l1.6-1.19 12-9 1.06-.81-1.07-.81-12-9ZM7 8.97l8.4 6.19 1.13.84-1.12.84L7 23.04ZM17 9l9.31 7L17 23Z',
        'foursquare' => 'M10 5a2 2 0 0 0-2 2v18.72c0 .5.36.97.78 1.12.42.15.99.03 1.31-.34l6.32-7.5h3.43c.95 0 1.79-.7 1.97-1.63l1.94-10A2.02 2.02 0 0 0 21.78 5Zm0 2h11.78L21 11h-6.53a.48.48 0 0 0-.47.47v1.06c0 .25.22.47.47.47h6.15l-.78 4h-3.93a1 1 0 0 0-.79.34L10 23.5Z',
        'free-code-camp' => 'M6.03 6C4.78 6 1 10.17 1 16.32 1 21.7 4.65 26 6.09 26c.39 0 .91-.43.91-.86 0-.36-.38-.83-1.3-1.83l-.48-.55A11.17 11.17 0 0 1 3 15.98 11.32 11.32 0 0 1 6.06 8.4l.14-.14c.34-.36.8-.86.8-1.35C7 6.43 6.46 6 6.03 6zm19.94 0c-.43 0-.97.43-.97.92 0 .5.46.99.8 1.35l.14.14A11.32 11.32 0 0 1 29 15.98c.03 2.55-.86 5-2.22 6.78l-.49.55c-.91 1-1.29 1.47-1.29 1.83 0 .43.52.86.91.86 1.44 0 5.09-4.3 5.09-9.68C31 10.17 27.22 6 25.97 6zM13.1 7.03c-.13.03-.21.1-.21.22s.13.2.23.26c.47.28 1 1.1 1 1.96 0 2.37-2.96 4.52-2.96 6.98 0 2.07 1.45 3.73 3.36 4.42.22.1.62.27.62-.06 0-.13-.1-.14-.21-.18-.44-.18-.72-.4-.99-.78a3.27 3.27 0 0 1-.51-1.98c0-1.65 2.27-1.94 2.27-3.6 0-.62-.4-.8-.4-.98 0-.11.04-.11.15-.11.41 0 .98.67 1.15 1.01a1 1 0 0 1 .12.57c0 .36-.03.73-.03 1.1 0 1.38 1.63 1.01 1.63.34 0-.3-.18-.59-.18-.89 0-.04 0-.06.04-.06.17 0 .48.4.56.51.3.46.44 1.07.44 1.61 0 1.67-1.51 2.52-1.51 2.87 0 .06.15.4.62.1a5.1 5.1 0 0 0 2.72-4.6 5.6 5.6 0 0 0-1.64-4.23c-.2-.22-.84-.87-1.16-.87-.42 0 .37.95.37 1.6a.6.6 0 0 1-.63.63c-.6 0-.75-1.3-.82-1.71-.3-1.73-.65-2.98-2.38-3.8-.4-.19-1.25-.43-1.65-.33zM10 23a.98.98 0 0 0-.98 1.02c0 .54.44.98.98.98h12.16c.2 0 .84-.07.84-1.02 0-.6-.33-.98-.84-.98H10z',
        'freebsd' => 'M5 5v1c0 1.85.62 3.86 1.5 5.47a10.99 10.99 0 1 0 19.53 1.03l-.12.22a20.6 20.6 0 0 1-1.16 2.25 8.79 8.79 0 0 1 .22 2.94 9 9 0 1 1-7.72-9.82c.24-.32.5-.61.72-.87v-.03l.19-.19c.21-.24.42-.44.62-.63a10.85 10.85 0 0 0-6.75.38c-.29-.2-.64-.43-1.1-.66A11 11 0 0 0 6 5Zm21 0a11 11 0 0 0-4.94 1.1c-1.12.55-1.78 1.18-1.78 1.18L19 7.6v.44s.02 1.21.66 2.44A4.76 4.76 0 0 0 24 13h.53l.31-.44S27 9.45 27 6V5ZM7.22 7.16c1.1.14 2.03.39 2.69.68-.75.5-1.4 1.1-2 1.75-.3-.78-.55-1.63-.7-2.43Zm17.5 0a12.78 12.78 0 0 1-1.25 3.71c-1.1-.16-1.7-.68-2.03-1.34-.28-.54-.28-.8-.32-1.1.18-.14.24-.23.82-.52a9.4 9.4 0 0 1 2.78-.75Z',
        'frog-solid' => 'M21 7a3 3 0 0 0-2.63 1.56 7.5 7.5 0 0 0-1.78 1.47 16 16 0 0 0-4.65.72 9.3 9.3 0 0 0-5.66 4.56c-.01.03-.05.04-.06.06-.05.06-.54.56-1.06 1.35A5.83 5.83 0 0 0 4 19.9c0 .91.32 1.84 1 2.5.22.21.51.37.81.5-.11.15-.24.3-.34.46-.23.36-.47.62-.47 1.29 0 .41.3.81.53.96.23.16.39.22.56.25a5 5 0 0 0 1.13.1c.83.01 1.91-.04 3.12-.1 2.43-.11 5.4-.22 7.5.13l.32-2c-1-.16-2.11-.23-3.22-.25A3.57 3.57 0 0 0 16 21.28c0-1.6-1.03-2.8-2.22-3.44A8.19 8.19 0 0 0 10 17v2c.94 0 2.07.21 2.84.63.78.4 1.16.84 1.16 1.65 0 .65-.53 1.27-1.4 1.78a6.4 6.4 0 0 1-2.41.78v.04c-1.08.05-2 .09-2.69.09l.31-.4c.5-.61 1-1.13 1-1.13l-1.47-1.38-.03.07c-.5.14-.72.05-.93-.16-.22-.2-.38-.63-.38-1.06 0-.54.4-1.39.84-2.07.45-.67.88-1.15.88-1.15l.12-.13.07-.15c.93-2.07 2.77-3.15 4.65-3.75A15.3 15.3 0 0 1 17 12h.5l.31-.4c.14-.2.29-.33.44-.47A3 3 0 0 0 21 13a3 3 0 0 0 2.97-2.84c.46.11.9.26 1.28.46.32.18.58.38.72.5 0 .04-.02.02-.03.07a4.03 4.03 0 0 1-2.31 2.16l-.63.24v.7c0 1.4-.13 4.84-2.06 6.21l1.15 1.63c2.81-1.99 2.85-5.57 2.85-7.25a6.17 6.17 0 0 0 2.28-1.91c.27-.4.47-.79.6-1.13.11-.34.18-.6.18-.93 0-.78-.38-.97-.69-1.25a6.91 6.91 0 0 0-4.06-1.63A2.99 2.99 0 0 0 21 7Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-2 7.38a6.33 6.33 0 0 0-1.1 2.68c-.11.78-.08 1.5-.09 1.53v.04c0 .26.05.3.07.34l.03.1.09.18.22.47c.19.37.46.87.75 1.37.58 1.02 1.16 2.06 1.94 2.72.11.1.25.18.4.22.46.1.67-.01.88-.06l.65-.13c.48-.07 1.06-.1 1.88.13l.56-1.94a6.43 6.43 0 0 0-2.75-.16c-.24.04-.4.1-.56.13-.28-.33-.81-1.08-1.28-1.9a28.15 28.15 0 0 1-.88-1.66v-.03c0-.32 0-.6.07-1.04a4.1 4.1 0 0 1 .75-1.84Z',
        'frown-open-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 5c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5Zm9 0c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5ZM16 17c-2.3 0-4 1.86-4 4 0 .99.36 1.97 1.16 2.47.8.5 1.68.53 2.84.53s2.04-.04 2.84-.53c.8-.5 1.16-1.48 1.16-2.47 0-2.14-1.7-4-4-4Zm0 2c1.3 0 2 .83 2 2 0 .67-.04.7-.19.78-.15.1-.76.22-1.81.22a4.92 4.92 0 0 1-1.81-.22c-.15-.09-.19-.11-.19-.78 0-1.17.7-2 2-2Z',
        'frown-open' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 5c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5Zm9 0c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5ZM16 17c-2.3 0-4 1.86-4 4 0 .99.36 1.97 1.16 2.47.8.5 1.68.53 2.84.53s2.04-.04 2.84-.53c.8-.5 1.16-1.48 1.16-2.47 0-2.14-1.7-4-4-4Zm0 2c1.3 0 2 .83 2 2 0 .67-.04.7-.19.78-.15.1-.76.22-1.81.22a4.92 4.92 0 0 1-1.81-.22c-.15-.09-.19-.11-.19-.78 0-1.17.7-2 2-2Z',
        'frown-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM16 18a7.98 7.98 0 0 0-6.47 3.34l1.63 1.16a5.93 5.93 0 0 1 9.68 0l1.63-1.16A7.98 7.98 0 0 0 16 18Z',
        'frown' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM16 18a7.98 7.98 0 0 0-6.47 3.34l1.63 1.16a5.93 5.93 0 0 1 9.68 0l1.63-1.16A7.98 7.98 0 0 0 16 18Z',
        'fulcrum' => 'm15 0-1.28 12.2L10.1 16l3.62 3.8L15 32V19l-3-3 3-3V0zm2 0v13l3 3-3 3v13l1.28-12.2L21.9 16l-3.62-3.8L17 0zM9.5 7 7 10l2.5 3 2.5-3-2.5-3zm13 0L20 10l2.5 3 2.5-3-2.5-3z',
        'funnel-dollar-solid' => 'M5 4v2.34l.22.29L13 16.34v11.7l1.6-1.26 1.56-1.19A8.04 8.04 0 0 0 24 32c4.4 0 8-3.6 8-8s-3.6-8-8-8c-1.89 0-3.63.68-5 1.78v-1.44l7.78-9.72.22-.28V4H5zm2.28 2h17.44l-7.19 9h-3.06L7.28 6zM15 17h2v3.13a8.03 8.03 0 0 0-.97 3.06L15 24v-7zm9 1a6 6 0 1 1 .02 11.98A6 6 0 0 1 24 18zm-1 1v1.06c-1.13.2-2 1.14-2 2.32 0 .75.42 1.44 1.1 1.78l2.9 1.46c0 .23-.15.38-.38.38h-1.25a.36.36 0 0 1-.37-.38V25h-2v.63c0 1.17.88 2.12 2 2.3V29h2v-1.06c1.13-.2 2-1.14 2-2.32 0-.75-.42-1.44-1.1-1.78L23 22.38c0-.23.15-.38.38-.38h1.25c.22 0 .37.15.37.38V23h2v-.63c0-1.17-.88-2.12-2-2.3V19h-2z',
        'futbol-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c.6 0 1.18.06 1.75.16L16 6.4l-1.75-1.25C14.82 5.06 15.4 5 16 5Zm-4.19.84 3.6 2.63.59.44.6-.44 3.59-2.63c1.6.67 3 1.68 4.12 2.97l-1.37 4.28-.22.7.6.4 3.62 2.65a11 11 0 0 1-1.53 4.85h-5.29l-.21.68-1.41 4.35a10.97 10.97 0 0 1-5.1-.03l-1.37-4.28-.22-.7H6.6a10.86 10.86 0 0 1-1.53-4.87l3.6-2.62.59-.4-.22-.7-1.4-4.24a11 11 0 0 1 4.18-3.04ZM16 10.1l-.6.44-4.56 3.31-.56.44.22.69 1.75 5.34.22.69h7.06l.22-.69 1.75-5.34.22-.69-.56-.44-4.57-3.3Zm9.75.82c.55 1.04.9 2.2 1.1 3.4l-1.79-1.28Zm-19.53.06.69 2.06-1.75 1.28a10.9 10.9 0 0 1 1.06-3.34ZM16 12.59l3.38 2.44L18.09 19h-4.18l-1.29-3.97Zm5.6 11.1h2.24c-.85.88-1.83 1.6-2.93 2.15Zm-13.44.03h2.18l.7 2.1a11.07 11.07 0 0 1-2.88-2.1Z',
        'futbol' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c.6 0 1.18.06 1.75.16L16 6.4l-1.75-1.25C14.82 5.06 15.4 5 16 5Zm-4.19.84 3.6 2.63.59.44.6-.44 3.59-2.63c1.6.67 3 1.68 4.12 2.97l-1.37 4.28-.22.7.6.4 3.62 2.65a11 11 0 0 1-1.53 4.85h-5.29l-.21.68-1.41 4.35a10.97 10.97 0 0 1-5.1-.03l-1.37-4.28-.22-.7H6.6a10.86 10.86 0 0 1-1.53-4.87l3.6-2.62.59-.4-.22-.7-1.4-4.24a11 11 0 0 1 4.18-3.04ZM16 10.1l-.6.44-4.56 3.31-.56.44.22.69 1.75 5.34.22.69h7.06l.22-.69 1.75-5.34.22-.69-.56-.44-4.57-3.3Zm9.75.82c.55 1.04.9 2.2 1.1 3.4l-1.79-1.28Zm-19.53.06.69 2.06-1.75 1.28a10.9 10.9 0 0 1 1.06-3.34ZM16 12.59l3.38 2.44L18.09 19h-4.18l-1.29-3.97Zm5.6 11.1h2.24c-.85.88-1.83 1.6-2.93 2.15Zm-13.44.03h2.18l.7 2.1a11.07 11.07 0 0 1-2.88-2.1Z',
        'galactic-republic' => 'M27.6 12.9a12 12 0 1 0-23.2 6.22 12 12 0 0 0 23.2-6.23ZM16.4 5.33a10.6 10.6 0 0 1 8.57 4.9l-.43.25c-.39-.6-.84-1.17-1.35-1.68l-.9.9a8.91 8.91 0 0 0-3.99-2.3l.33-1.22c-.72-.2-1.46-.3-2.22-.34ZM19.6 16c0 .32-.05.64-.12.94l3.68.99a7.44 7.44 0 0 1-1.92 3.32l-2.7-2.7c-.43.43-.99.76-1.61.93l.99 3.68a7.4 7.4 0 0 1-3.84 0l.99-3.68a3.56 3.56 0 0 1-1.62-.94l-2.7 2.7a7.38 7.38 0 0 1-1.91-3.33l3.68-.98a3.6 3.6 0 0 1 0-1.86l-3.68-.99a7.39 7.39 0 0 1 1.91-3.32l2.7 2.7c.44-.44 1-.77 1.62-.94l-1-3.68a7.43 7.43 0 0 1 3.85 0l-.99 3.68c.62.17 1.18.5 1.62.93l2.7-2.7a7.4 7.4 0 0 1 1.91 3.33l-3.68.99c.08.3.12.6.12.93ZM8.46 8.46a10.67 10.67 0 0 1 6.95-3.1v.5a10 10 0 0 0-2.04.32l.33 1.22a8.89 8.89 0 0 0-4 2.31l-.9-.9c-.5.51-.95 1.07-1.34 1.68l-.44-.25c.41-.65.9-1.24 1.44-1.78ZM6.52 20.9a10.61 10.61 0 0 1-.82-7.65c.2-.75.47-1.46.82-2.13l.43.25c-.32.63-.58 1.3-.77 2l1.22.34a8.8 8.8 0 0 0 0 4.6l-1.22.33c.18.7.45 1.38.77 2.01Zm8.89 5.76a10.64 10.64 0 0 1-8.39-4.89l.43-.25c.4.6.85 1.17 1.35 1.67l.9-.9a8.87 8.87 0 0 0 4 2.32l-.33 1.22c.65.18 1.34.29 2.04.33Zm8.13-3.1a10.67 10.67 0 0 1-7.13 3.1v-.5c.76-.02 1.5-.14 2.22-.33l-.33-1.22a8.87 8.87 0 0 0 4-2.3l.89.9a11 11 0 0 0 1.35-1.69l.44.25c-.42.65-.9 1.24-1.44 1.78Zm1.94-2.66-.43-.25c.32-.63.58-1.3.77-2l-1.22-.33a9 9 0 0 0 0-4.61l1.22-.33c-.19-.7-.45-1.38-.77-2.01l.43-.25a10.58 10.58 0 0 1 .82 7.66c-.2.74-.48 1.45-.82 2.12Z',
        'galactic-senate' => 'M15.64 3v1.53c-.8 1.2-1.4 6.37-1.44 12.64a5.04 5.04 0 0 0 1.13-2.83v-1c0-.3.04-.61.13-.91a.95.95 0 0 1 .15-.34.5.5 0 0 1 .4-.23c.18 0 .31.12.38.23.07.1.12.21.16.34.08.3.13.6.13.92v.99c0 .87.43 1.91 1.12 2.83-.04-6.27-.64-11.43-1.44-12.64V3h-.72zm-1.55 8.67c-.56.13-1.1.3-1.6.54.51.94.57 1.91.1 2.18-.48.28-1.29-.24-1.85-1.16a8.97 8.97 0 0 0-1.8 1.83c.87.56 1.35 1.34 1.08 1.8-.26.45-1.17.41-2.08-.06a9.12 9.12 0 0 0-.68 2.49c.57 0 1.1.14 1.53.35 1.05-.02 1.93-.11 2.38-.25a5.04 5.04 0 0 1 2.72-3.49c.04-1.5.11-2.91.2-4.23zm3.81 0c.1 1.32.17 2.73.2 4.23a5.03 5.03 0 0 1 2.73 3.5c.45.13 1.33.22 2.37.24.44-.21.97-.34 1.54-.35a9.07 9.07 0 0 0-.68-2.5c-.9.48-1.82.52-2.09.07-.26-.46.21-1.24 1.08-1.8a9 9 0 0 0-1.8-1.83c-.55.92-1.36 1.44-1.83 1.16-.48-.27-.43-1.24.1-2.18a8.69 8.69 0 0 0-1.62-.54zm-1.9.5c-.19 0-.34.52-.36 1.18v.99c0 2.43-2.88 5.57-5.49 5.57-3.04 0-7.17-.08-9.15 1.7v.2c.55 1 1.2 1.92 1.93 2.78.73-1.24 3.02-2.4 6.33-2.43 2.68.06 4.64 1.2 5.33 2.4a5.19 5.19 0 0 0 2.82 0c.7-1.2 2.65-2.34 5.33-2.4 3.31.03 5.6 1.2 6.34 2.43.73-.86 1.37-1.79 1.92-2.78v-.2c-1.98-1.78-6.11-1.7-9.15-1.7-2.61 0-5.49-3.14-5.49-5.57v-1c-.02-.65-.17-1.16-.36-1.16zm0 5.67a2.38 2.38 0 1 1 0 4.77 2.38 2.38 0 0 1 0-4.77zm0 .45a1.93 1.93 0 1 0 0 3.87 1.93 1.93 0 0 0 0-3.87zm0 .36a1.57 1.57 0 1 1 0 3.15 1.57 1.57 0 0 1 0-3.15zm-6.74 3.92c-.6 0-1.27.02-1.79.1.03.25.1 1.09.42 1.74a6 6 0 0 1 1.62-.23c2.42.06 4.2 2.02 4.6 4.37v.28a10.42 10.42 0 0 0 3.78 0v-.28c.4-2.35 2.18-4.31 4.6-4.37a6 6 0 0 1 1.62.23 5 5 0 0 0 .42-1.75c-.52-.07-1.2-.09-1.8-.1a8 8 0 0 0-2.84.57 4.74 4.74 0 0 1-2.91 1.94h-.02v.01a4.7 4.7 0 0 1-1.9 0h-.03a4.7 4.7 0 0 1-2.91-1.95 8.03 8.03 0 0 0-2.86-.56z',
        'gamepad-solid' => 'M16 7C9.62 7 4.03 9.06 4.03 9.06l-.6.22-.06.6-1.34 10.24a5.24 5.24 0 0 0 4.5 5.85c2.64.34 5-1.44 5.63-3.97h7.68a5.16 5.16 0 0 0 5.63 3.97c2.83-.36 4.86-3 4.5-5.84L28.63 9.88l-.07-.6-.6-.22S22.39 7 16 7Zm0 2c5.48 0 10 1.52 10.75 1.78l1.22 9.63a3.16 3.16 0 0 1-2.75 3.56 3.19 3.19 0 0 1-3.6-2.75l-.03-.34-.12-.88H10.53l-.12.88-.04.34a3.19 3.19 0 0 1-3.59 2.75 3.16 3.16 0 0 1-2.75-3.56l1.22-9.63C5.99 10.52 10.52 9 16 9Zm-7 3v2H7v2h2v2h2v-2h2v-2h-2v-2Zm13 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-2 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-2 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'gas-pump-solid' => 'M8 5C6.36 5 5 6.36 5 8v19h14v-7h2v4c0 1.64 1.36 3 3 3s3-1.36 3-3V13.81c0-.8-.31-1.53-.88-2.1L21.41 7 20 8.4l2.84 2.85A3 3 0 0 0 21 14c0 1.64 1.36 3 3 3 .35 0 .68-.07 1-.19V24c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-4a2 2 0 0 0-2-2h-2V8c0-1.64-1.36-3-3-3Zm0 2h8c.57 0 1 .43 1 1v4H7V8c0-.57.43-1 1-1Zm16 6c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1ZM7 14h10v11H7Z',
        'gavel-solid' => 'm15.97 1.6-.72.68-7 7.03-.72.69 4.44 4.44.69-.72.34-.35 2.1 2.1L3.27 27.28l1.44 1.44L16.53 16.9l2.06 2.06-.34.34-.72.69 4.44 4.44.69-.72L30.37 16l-.71-.69-3-3.03-.7-.69-.71.7-.28.27L19.37 7l1-1-.71-.69-3-3.03Zm0 2.8 1.6 1.6-5.6 5.6-1.6-1.6ZM18 8.45 23.56 14 20 17.56 14.44 12Zm7.97 5.97 1.6 1.59-5.6 5.6-1.6-1.6Z',
        'gem-solid' => 'm9.53 6-5.31 6.38-.5.59.5.65 11 14 .78 1 .78-1 11-14 .5-.65-.5-.6L22.47 6Zm.94 2h3.65l-2.68 4H7.13Zm7.4 0h3.66l3.34 4h-4.3ZM16 8.84 18.13 12h-4.25ZM7.03 14h4.22l2.38 8.4Zm6.28 0h5.35L16 23.31Zm7.44 0h4.22l-6.6 8.38Z',
        'gem' => 'm9.53 6-5.31 6.38-.5.59.5.65 11 14 .78 1 .78-1 11-14 .5-.65-.5-.6L22.47 6Zm.94 2h3.65l-2.68 4H7.13Zm7.4 0h3.66l3.34 4h-4.3ZM16 8.84 18.13 12h-4.25ZM7.03 14h4.22l2.38 8.4Zm6.28 0h5.35L16 23.31Zm7.44 0h4.22l-6.6 8.38Z',
        'genderless-solid' => 'M16 4c-4.4 0-8 3.6-8 8a8.03 8.03 0 0 0 7 7.94V28h2v-8.06c3.93-.5 7-3.87 7-7.94 0-4.4-3.6-8-8-8Zm0 2a6 6 0 1 1 .02 11.98A6 6 0 0 1 16 6Z',
        'get-pocket' => 'M7 5C5.36 5 4 6.36 4 8v7a12.01 12.01 0 0 0 24 0V8c0-1.64-1.36-3-3-3Zm0 2h18c.57 0 1 .43 1 1v7c0 5.54-4.46 10-10 10S6 20.54 6 15V8c0-.57.43-1 1-1Zm3.66 4.4c-.39 0-.77.18-1.07.47-.58.6-.58 1.51 0 2.1l5.41 5.4a1.5 1.5 0 0 0 2.13 0l5.28-5.25A1.5 1.5 0 0 0 20.28 12l-4.22 4.22-4.34-4.34c-.3-.3-.68-.47-1.06-.47Z',
        'gg-circle' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm2.54 4.49-3.85 3.85 3.97 3.97 1.25-1.26-2.73-2.71 1.36-1.37 3.97 3.97-3.97 3.97-.57-.57-1.24 1.25 1.81 1.8L25 15.96 18.54 9.5zm-5.08.1L7 16.06l6.46 6.46 3.85-3.86-3.97-3.97-1.25 1.26 2.73 2.71-1.37 1.37-3.96-3.97 3.96-3.96.57.57 1.25-1.25-1.81-1.81z',
        'gg' => 'm12 6.6-.72.68-8 8-.69.72.7.72 8 8 .71.69.72-.7 4-4 .69-.71-.7-.72-5-5-1.43 1.44L14.56 20 12 22.56 5.44 16 12 9.44l1.28 1.28 1.44-1.44-2-2Zm8 0-.72.68-4 4-.69.72.7.72 5 5 1.43-1.44L17.44 12 20 9.44 26.56 16 20 22.56l-1.28-1.28-1.44 1.44 2 2 .72.69.72-.7 8-8 .69-.71-.7-.72-8-8Z',
        'ghost-solid' => 'M16 3c-1.94 0-3.43.5-4.5 1.34a7.22 7.22 0 0 0-2.13 3c-.43 1.04-.71 2.04-1 2.75-.28.72-.51 1-.71 1.07A7.12 7.12 0 0 0 3 18v1h1c1.35 0 2 .28 2.31.53.31.25.43.54.5 1.03.07.5.04 1.1.13 1.78.04.34.11.73.34 1.1.23.37.64.69 1.1.84 1.05.35 1.73.58 2.15.81.42.24.67.46 1 1.16.32.67.74 1.4 1.5 1.94s1.78.83 3.06.81a4.73 4.73 0 0 0 4-2.06c.33-.48.55-.89.75-1.16.2-.27.32-.37.54-.44a4.63 4.63 0 0 0 2.71-1.87c.5-.78.59-1.55.72-2.06.14-.52.24-.72.57-.94.32-.22 1.07-.47 2.62-.47h1v-1c0-1.38.05-2.98-.56-4.5-.61-1.52-2-2.86-4.28-3.38-.03 0-.05.01-.16-.12-.1-.13-.27-.4-.4-.75-.29-.7-.56-1.72-1-2.78a7.68 7.68 0 0 0-2.16-3.06A6.86 6.86 0 0 0 16 3Zm0 2c1.54 0 2.48.4 3.19.97a5.7 5.7 0 0 1 1.56 2.28c.38.9.65 1.88 1 2.75.17.43.36.84.66 1.22.3.38.73.75 1.28.87 1.8.41 2.47 1.15 2.87 2.16.31.77.32 1.82.35 2.84-1.11.1-2.02.3-2.66.72a3.53 3.53 0 0 0-1.38 2.1c-.17.65-.24 1.13-.46 1.5-.23.36-.6.72-1.63 1.03a3.1 3.1 0 0 0-1.56 1.15c-.34.46-.54.87-.78 1.22-.48.7-.82 1.17-2.38 1.19-.98.01-1.5-.18-1.87-.44a2.8 2.8 0 0 1-.88-1.15 4.48 4.48 0 0 0-1.78-2.07c-.74-.42-1.5-.63-2.53-.96 0-.02-.07-.1-.1-.29-.04-.38-.01-1.05-.12-1.8a3.51 3.51 0 0 0-1.22-2.32 4.72 4.72 0 0 0-2.31-.81c.3-1.93 1.3-3.5 3.06-4.13 1.06-.37 1.59-1.3 1.94-2.19.35-.88.6-1.87.97-2.75.37-.87.8-1.61 1.5-2.15C13.42 5.39 14.4 5 16 5Zm-3 4c-.55 0-1 .67-1 1.5s.45 1.5 1 1.5 1-.67 1-1.5S13.55 9 13 9Zm4 0c-.55 0-1 .67-1 1.5s.45 1.5 1 1.5 1-.67 1-1.5S17.55 9 17 9Z',
        'gift-solid' => 'M12 5c-1.64 0-3 1.36-3 3 0 .35.07.68.19 1H4v6h1v13h22V15h1V9h-5.19c.12-.32.19-.65.19-1 0-1.64-1.36-3-3-3-1.75 0-2.94 1.33-3.72 2.44l-.28.43-.28-.43C14.94 6.33 13.75 5 12 5Zm0 2c.63 0 1.44.67 2.06 1.56.15.22.13.23.25.44H12c-.57 0-1-.43-1-1 0-.57.43-1 1-1Zm8 0c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-2.31c.12-.2.1-.22.25-.44C18.56 7.67 19.37 7 20 7ZM6 11h20v2h-9v-1h-2v1H6Zm1 4h18v11h-8V16h-2v10H7Z',
        'gifts-solid' => 'M9 4v3.23L5.52 5.14 4.48 6.86 6.38 8H3v19h6v-2H5V10h8.03A4.96 4.96 0 0 1 17 9.1V8h-3.39l1.9-1.14-1.03-1.72L11 7.24V4H9zm7 7c-1.64 0-3 1.36-3 3 0 .35.07.68.19 1H11v12h18V15h-2.19c.12-.32.19-.65.19-1 0-1.64-1.36-3-3-3-1.75 0-2.94 1.33-3.72 2.44l-.28.44-.28-.44C18.94 12.33 17.75 11 16 11zm0 2c.63 0 1.44.67 2.06 1.56.15.22.13.23.25.44H16c-.57 0-1-.43-1-1 0-.56.43-1 1-1zm8 0c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-2.31c.12-.2.1-.22.25-.44.62-.89 1.43-1.56 2.06-1.56zm-11 4h6v8h-6v-8zm8 0h6v8h-6v-8z',
        'git-alt' => 'M16 2c-.5 0-1 .18-1.38.56l-2.8 2.85a.97.97 0 0 0-.38.34l-8.88 8.88a1.93 1.93 0 0 0 0 2.74l12.06 12.07c.76.75 2 .75 2.76 0l12.06-12.07c.76-.75.76-1.99 0-2.75L17.37 2.56A1.92 1.92 0 0 0 16 2Zm0 2.03L27.97 16 16 27.97 4.03 16l8.28-8.28 1.75 1.75c-.04.17-.06.35-.06.53 0 .74.4 1.37 1 1.72v8.56a2 2 0 1 0 2 0v-7.84l3.06 3.06a2 2 0 1 0 1.44-1.44l-3.56-3.56a2 2 0 0 0-2.47-2.44l-1.75-1.75Z',
        'git-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9.87 3.36c-.63 0-1 .34-1 .97 0 .64.37 1 1 1 .64 0 1.01-.36 1.01-1 0-.63-.37-.97-1-.97zm3.11 1.06c-.12 1.2-.5 1.7-1.48 1.8v1c.9 0 .86-.04.86.1v2.92c0 1.25.5 1.76 1.83 1.76.63 0 1.33-.18 1.81-.42l-.3-.98c-1.79.67-1.7-.55-1.7-.73V14.2h1.7v-1.1H21v-1.7h-1.02zm-8.25 1.8c-1.16 0-2.56.46-2.56 2.16 0 .82.42 1.4.96 1.67-.68.63-1.01.92-1.01 1.33 0 .31.13.58.49.74-.38.36-.61.64-.61 1.14 0 .87.77 1.38 2.78 1.38 1.93 0 3.06-.72 3.06-2 0-1.6-1.23-1.54-4.15-1.72l.37-.6c.74.22 3.24.28 3.24-1.84 0-.51-.2-.87-.41-1.12l1.02-.08v-.95h-2.17a4.1 4.1 0 0 0-1.01-.12zm3.82 0-.12.9c.69.25.74.21.74.44v3.28c0 .24 0 .2-.74.3V19h3.17v-.87l-.56-.07c-.17-.02-.18-.05-.18-.22v-4.62h-2.3zm-3.73 1.1a.97.97 0 0 1-.03 1.94c-1.44 0-1.37-1.94.03-1.94zm-1.22 5.1c2.12.15 2.58.1 2.58.52 0 .88-2.86.88-2.86.07 0-.22.14-.4.28-.6z',
        'git' => 'M16 2c-.5 0-1 .18-1.38.56l-2.8 2.85a.97.97 0 0 0-.38.34l-8.88 8.88a1.93 1.93 0 0 0 0 2.74l12.06 12.07c.76.75 2 .75 2.76 0l12.06-12.07c.76-.75.76-1.99 0-2.75L17.37 2.56A1.92 1.92 0 0 0 16 2Zm0 2.03L27.97 16 16 27.97 4.03 16l8.28-8.28 1.75 1.75c-.04.17-.06.35-.06.53 0 .74.4 1.37 1 1.72v8.56a2 2 0 1 0 2 0v-7.84l3.06 3.06a2 2 0 1 0 1.44-1.44l-3.56-3.56a2 2 0 0 0-2.47-2.44l-1.75-1.75Z',
        'github-alt' => 'M5.69 5S5 6.2 5 8.25c0 1.36.3 2.07.53 2.44A9.28 9.28 0 0 0 3 17.34C3 24.6 7.59 27 16 27s13-2.41 13-9.66c0-2.92-.91-5.12-2.4-6.71.36-1.11.78-3.2-.26-5.63-3.1 0-5.68 2.38-5.78 2.47A21.47 21.47 0 0 0 16 7c-1.6 0-3.18.2-4.66.56A8.7 8.7 0 0 0 5.7 5Zm15 10.44c.84-.01 1.62.06 2.31.28a4.3 4.3 0 0 1 3 4.15C26 25.12 23.2 26 16 26c-5.34 0-9.69-.94-9.69-5.94a4.7 4.7 0 0 1 1.78-3.65c1.64-1.48 4.23-.75 7.91-.75 1.67 0 3.28-.2 4.69-.22ZM10.5 18c-.83 0-1.5.9-1.5 2s.67 2 1.5 2 1.5-.9 1.5-2-.67-2-1.5-2Zm11 0c-.83 0-1.5.9-1.5 2s.67 2 1.5 2 1.5-.9 1.5-2-.67-2-1.5-2Zm-11.16.84c.24 0 .41.2.41.44s-.17.44-.4.44a.44.44 0 0 1-.44-.44c0-.24.2-.44.43-.44Zm11 0c.24 0 .41.2.41.44s-.17.44-.4.44a.44.44 0 0 1-.44-.44c0-.24.2-.44.43-.44Z',
        'github-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8.9 2A6.77 6.77 0 0 0 9 15.88a7.08 7.08 0 0 0 4.78 6.76c.37.07.5-.16.5-.34l-.01-1.74s-1.99.43-2.4-.84c0 0-.32-.81-.78-1.03 0 0-.65-.44.04-.43 0 0 .7.05 1.1.73.61 1.1 1.65.77 2.05.59.07-.45.25-.77.46-.95-1.58-.18-3.18-.4-3.18-3.12 0-.78.22-1.16.67-1.66-.07-.19-.32-.95.07-1.92.6-.19 1.95.76 1.95.76a6.93 6.93 0 0 1 3.55 0s1.36-.95 1.96-.76c.38.98.14 1.73.07 1.92.45.5.73.88.73 1.66 0 2.73-1.67 2.94-3.25 3.12.26.22.49.64.49 1.3l-.01 2.37c0 .18.13.4.48.34A7.03 7.03 0 0 0 23 15.88 6.92 6.92 0 0 0 15.9 9zm-4.34 9.49c-.05-.02-.1-.01-.12.02-.01.03.01.08.07.11.04.03.1.02.12-.02.01-.03-.01-.08-.07-.11zm.26.23c-.03 0-.06 0-.08.02-.04.03-.03.1.02.15.05.04.11.06.15.02.04-.03.03-.09-.02-.15a.2.2 0 0 0-.07-.04zm.3.37a.1.1 0 0 0-.1 0c-.04.04-.04.11 0 .18.06.06.13.09.17.06.05-.03.05-.11 0-.18a.15.15 0 0 0-.08-.06zm.32.4c-.04 0-.06 0-.08.03-.04.04-.03.12.03.17.07.07.15.07.19.03.04-.04.01-.12-.04-.18a.18.18 0 0 0-.1-.05zm.54.31c-.07-.01-.16 0-.17.07-.02.05.04.12.12.13.07.03.16 0 .17-.05.03-.06-.03-.12-.12-.15zm1.07.03c-.08.01-.13.07-.12.13 0 .06.08.09.16.07.09-.01.14-.07.13-.12 0-.06-.09-.1-.17-.08zm-.52.06c-.09 0-.15.05-.15.1 0 .07.06.12.16.1.09 0 .15-.04.15-.1 0-.06-.08-.1-.16-.1z',
        'github' => 'M16 4a12 12 0 0 0-3.8 23.39c.6.1.83-.26.83-.58L13 24.77c-3.34.72-4.04-1.61-4.04-1.61-.55-1.39-1.33-1.76-1.33-1.76-1.1-.74.08-.72.08-.72 1.2.08 1.83 1.23 1.83 1.23 1.07 1.84 2.81 1.3 3.5 1 .1-.78.42-1.3.76-1.6-2.67-.3-5.47-1.34-5.47-5.93 0-1.32.47-2.39 1.24-3.23-.12-.3-.54-1.52.12-3.17 0 0 1-.32 3.3 1.23a11.49 11.49 0 0 1 6 0c2.3-1.55 3.3-1.23 3.3-1.23a4.3 4.3 0 0 1 .12 3.17 4.63 4.63 0 0 1 1.23 3.22c0 4.61-2.8 5.63-5.47 5.93.43.36.8 1.1.8 2.22v3.29c0 .32.21.7.82.58A12 12 0 0 0 16 4Z',
        'gitkraken' => 'M21.12 5a.52.52 0 0 0-.52.3.53.53 0 0 0 .22.69 10.11 10.11 0 0 1 5.14 8.84 10.1 10.1 0 0 1-6.31 9.4V20a1.62 1.62 0 0 0 .34-2.93c.38-3.64 2-2.68 2-3.84v-.68c0-1.73-3.96-7.4-5.81-7.53h-.35c-1.86.14-5.82 5.8-5.82 7.53v.68c0 1.16 1.64.2 2 3.84a1.62 1.62 0 0 0 .34 2.93v4.22a10.1 10.1 0 0 1-6.3-9.4c0-3.8 2.07-7.11 5.13-8.84a.53.53 0 0 0 .22-.7.52.52 0 0 0-.72-.22A11.17 11.17 0 0 0 5 14.83c0 5.25 3.57 9.65 8.4 10.84V20.9c.33.11.67.2 1.03.28v5.66a12.08 12.08 0 0 1-10.4-12.02c0-1.5.28-2.94.77-4.27a.52.52 0 0 0-.28-.67.52.52 0 0 0-.7.3c-.53 1.45-.82 3-.82 4.64A13.1 13.1 0 0 0 15.47 28v-6.68c.31.02.68.03 1.06 0V28A13.1 13.1 0 0 0 29 14.83c0-1.63-.3-3.2-.83-4.64a.52.52 0 1 0-.97.37c.5 1.32.76 2.77.76 4.27 0 6.16-4.53 11.24-10.39 12.02v-5.66c.36-.07.7-.17 1.04-.29v4.76A11.12 11.12 0 0 0 27 14.83c0-4.2-2.3-7.86-5.68-9.76a.5.5 0 0 0-.2-.07zm-8.27 12.4c.59 0 1.06.48 1.06 1.07 0 .6-.47 1.09-1.06 1.09-.6 0-1.07-.5-1.07-1.09 0-.59.47-1.08 1.07-1.08zm6.3 0c.6 0 1.07.47 1.07 1.08 0 .6-.47 1.08-1.07 1.08-.58 0-1.06-.48-1.06-1.08 0-.6.47-1.09 1.06-1.09z',
        'gitlab' => 'm8.38 1.97-4.3 11.48-.24.66-2.04 5.43L16 29.88l14.2-10.34-2.04-5.43-4.55-12.14-3.73 11.48h-7.76Zm-.13 6.06 1.77 5.42h-3.8Zm15.5 0 2.04 5.42h-3.8ZM5.46 15.45h5.2l3.43 10.57-9.89-7.2Zm7.3 0h6.47L16 25.4Zm8.58 0h5.2l1.26 3.37-9.9 7.2Z',
        'gitter' => 'M6 2v17h2V2H6zm6 4v24h2V6h-2zm6 0v24h2V6h-2zm6 0v13h2V6h-2z',
        'glass-cheers-solid' => 'm24.84 4.06-.96.28-7.7 2.2-.93.27.19.69-7.22-2.1-.97-.28-.28.97-2.81 9.57A7.26 7.26 0 0 0 4 19.62a4.61 4.61 0 0 0 2.34 2.82l-.9 3.28-2.88-.84L2 26.8l7.69 2.22.56-1.94-2.88-.84.91-3.25a4.64 4.64 0 0 0 3.47-1.16 7.16 7.16 0 0 0 2-3.4l2.47-8.25 2.03 7.22v.03a7.16 7.16 0 0 0 2 3.4 4.54 4.54 0 0 0 3.47 1.13l.9 3.28-2.87.84.56 1.94L30 25.81l-.56-1.93-2.88.84-.93-3.28a4.61 4.61 0 0 0 2.34-2.82 7.24 7.24 0 0 0-.13-3.96l-2.71-9.63ZM23.5 6.53 24.75 11H18.5l-.78-2.81ZM8.62 7.63l5.76 1.62-.82 2.75H7.31ZM19.06 13h6.25l.63 2.22c.27.93.36 2.03.12 2.87-.24.84-.69 1.43-1.9 1.79-1.22.35-1.92.08-2.57-.5a5.61 5.61 0 0 1-1.43-2.5ZM6.72 14h6.25l-1.13 3.88h-.03a5.57 5.57 0 0 1-1.4 2.5c-.65.58-1.35.85-2.57.5-1.21-.36-1.66-.95-1.9-1.79a5.57 5.57 0 0 1 .12-2.87Z',
        'glass-martini-alt-solid' => 'M8.5 4a5.5 5.5 0 0 0 0 11c.81 0 1.58-.2 2.28-.53L16 21.34V27h-4v2h10v-2h-4v-5.66l8.81-11.62.19-.28V8H13.75c-.6-2.32-2.77-4-5.25-4Zm0 2c1.4 0 2.59.84 3.13 2H7v1.44l.19.28 2.34 3.1A3.46 3.46 0 0 1 5 9.5a3.47 3.47 0 0 1 3.5-3.51Zm1.44 4h14.12l-1.5 2H13.5l1.5 2h6.03L17 19.34Z',
        'glass-martini-solid' => 'M5 5v1.34l10 13V26h-5v2h12v-2h-5v-6.66l10-13V5H5zm3.03 2h15.94l-1.54 2H11.92l1.54 2h7.43L16 17.36 8.03 7z',
        'glass-whiskey-solid' => 'm4.82 7 3.33 20h15.7l3.33-20H4.82zm2.36 2h17.64l-1.67 10H10.67l.33 2h11.82l-.67 4H9.85L7.18 9z',
        'glasses-solid' => 'm5.06 6-.25.66L1.31 16H0v2h1v2c0 3.3 2.7 6 6 6h2c3.3 0 6-2.7 6-6v-3c0-.57.43-1 1-1 .57 0 1 .43 1 1v3c0 3.3 2.7 6 6 6h2c3.3 0 6-2.7 6-6v-2h1v-2h-1.31l-3.5-9.34-.25-.66H25l-.28.38-2.5 3 1.56 1.24 1.9-2.3L28.57 16h-9.75A3.01 3.01 0 0 0 16 14c-1.3 0-2.4.84-2.81 2H3.44L6.3 8.31l1.9 2.31 1.57-1.24-2.5-3L7 6ZM3 18h10v2a4 4 0 0 1-4 4H7a4 4 0 0 1-4-4Zm16 0h10v2a4 4 0 0 1-4 4h-2a4 4 0 0 1-4-4Z',
        'glide-g' => 'M16.04 3C10.19 3 7 8.77 7 13.07c0 4.47 2.84 6.94 7.27 6.94.6 0 .56-.05.56.2-.86 6.54-4.61 6.75-4.61 4.8 0-2 2.75-2.49 2.77-2.6C12.98 21.77 10.6 21 10 21c-1.72 0-3 2.1-3 3.54C7 27.17 8.54 29 11.22 29c3.93 0 6.8-3.95 7.68-7.38.77-3.08.57-3.22 1-3.44 1.64-.82 2.92-.6 4.77-.6.9 0 1.55.18 2.99.42.15 0 .34-.15.34-.3 0-.4-1.62-3.36-2-3.5a3 3 0 0 0-.78-.2c-1.89 0-3.24.38-4.83 1.28l-.04-.04c.35-2.4 1.65-4.95 1.65-7.42C22 4.2 19.6 3 16.04 3zm.25 2.83c.94 0 1.48.39 1.48 1.17 0 .73-.14 1.45-.29 2.15-.47 2.27-1.4 4.84-1.87 7.11-.12.52-.68.4-1.12.4-1.94 0-2.49-2.13-2.49-3.72 0-2.38.92-5.55 3.14-6.77.36-.2.75-.34 1.15-.34z',
        'glide' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8.92 2c-3.14 0-4.73 3.1-4.73 5.4 0 2.4 1.4 3.73 3.78 3.73.33 0 .3-.03.3.1-.46 3.51-2.47 3.63-2.47 2.58 0-1.07 1.23-1.6 1.24-1.67-.01-.33-1.28-.75-1.6-.75-.93 0-1.44 1.45-1.44 2.22 0 1.4.9 2.39 2.33 2.39 2.11 0 3.65-2.18 4.13-4.01.41-1.65.3-1.73.54-1.85.87-.44 1.22-.73 2.21-.73.49 0 .84.1 1.61.23.08 0 .18-.08.18-.16 0-.22-.91-1.65-1.12-1.73-.1-.04-.31-.1-.42-.1-1 0-1.35.46-2.2.94l-.02-.02c.18-1.29.64-2.5.64-3.83C18.88 9.8 17.83 9 15.92 9zm.14 1.52c.5 0 .54.36.54.78 0 .38-.07.77-.15 1.15l-.76 3.66c-.06.28-.36.22-.6.22-1.04 0-1.33-1.14-1.33-2 0-1.28.49-2.97 1.68-3.63.2-.11.4-.18.62-.18z',
        'globe-africa-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c.34 0 .67.02 1 .05V7h-2l-1 3h-1v1h5l1 1h1v1l-1 1-4-1-4 3v3l2 2h3v2.5l1 2.5h1l3-4v-1l1-2v-1h-1l-1-2 1-1 1.5 1 2.5-1v-1h1.8A11.01 11.01 0 0 1 16 27C9.94 27 5 22.07 5 16 5 9.94 9.94 5 16 5z',
        'globe-americas-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c.34 0 .67.02 1 .05V6h2v-.57c2.46.7 4.57 2.22 6 4.27V13l1 2v1h1c0 .37-.02.73-.05 1.09l-.05.28c-.03.26-.06.52-.11.78l-.07.29c-.06.25-.12.5-.2.75l-.08.25c-.08.26-.17.5-.28.75l-.09.22-.36.75-.1.17a11.02 11.02 0 0 1-1.07 1.6l-.1.1c-.19.24-.4.46-.6.68l-.1.1a11 11 0 0 1-.67.6l-.1.1c-.23.18-.48.36-.73.53l-.11.09c-.24.16-.49.3-.74.45a10.91 10.91 0 0 1-3.87 1.3l4-3.02 1.1-1.1L24 20v-1l-2-1h-1l-2-2h-2l-1 1v1l-1 1v2l2 1.6-1.98 4.35A11.01 11.01 0 0 1 9 7.52V8L8 9v2.2L9 15l5 2h1v-1l-3-1v-2h3l1-2.5L18 9V8l-3-2-1.44-.72A11 11 0 0 1 16 5zm-1 9v1h2v-1h-2z',
        'globe-asia-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm.4 2.03c.97.04 1.89.18 2.76.47l-.47.66.37.78-.5 1 2.13.28.78 3.62 1.72 2.35 1.53.97-.6-1.66.57-.69 1.15.31c.12.61.16 1.24.16 1.88 0 .15-.02.3-.03.44l-.1-.19-.96.4-.25.63-.54.19.2 1.62.4.6-.28.78-1.5 2.37-.13.47a9.97 9.97 0 0 1-14.43-.84L6.96 19l.81-1.38-1.22-.68 1.38-.66.06-.75-.4-1.06.78.1.78 1.18.71.34-.21-.8.75-.76 1.21.88.66-.54L12 13.5l.97-1.38-.13-1.37 1.2-.72-.82-2 2.25-.12 1.25-1.6ZM15 15.6l-2.66 2 .2 2.5.68.6 1.53-.82.78.22 1.35 1.44.8-.22.85-2-.53-1.37-1.06-2.07-.78 1.26Zm5 4.22-.19.07-.06 1.28-.44.59.5.47.63-.72Zm-1.1 2.44-1.27 1.47.34.37 1.5-1.43Z',
        'globe-europe-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c2.1 0 4.06.6 5.74 1.63l-.24.57 1.18 1.17-1.1 1.1L20 8h-2l-2 2.5 1 2.2 1-.7v-1h1l1.1.9L19 13l-4 2h-1v2h1l2-1 1 1h2v-1l.8-1.2L23 14v2h-2v1h2l2 3 1-1v-1h-1v-1h1l.96-.2A10.91 10.91 0 0 1 25 22.3V22h-1.1l-2.4-4-2.5 1-3-1-3 1-1 3 1 2h2l1-1 1 1v2.95A11.01 11.01 0 0 1 5.35 13.32L5.9 13H7V9.7c.17-.24.34-.48.52-.7h.9l.44-1.35c.63-.54 1.31-1 2.05-1.4L10 9h2l2-2V6h-1l-1 1V5.76c1.24-.48 2.59-.76 4-.76zm-2 6v2h1v-2h-1z',
        'globe-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2a10 10 0 0 1 5.34 1.56l-.8.1.18 2-1.06-.47-.88.75.16 2.06 2.15-.69 2.7.88-.7 1.25-1.62-1-1.75.25L18 13.97l-.97 3 1.94 1.6s1.99-.35 2.1-.35c.1 0 .84 1.81.84 1.81l-1.6 5A10 10 0 0 1 16 26c-.32 0-.63-.04-.94-.06l-1.1-1.9 1.07-4L11 17H7.28l-.97-1.97L9 12.91 13 11l-.6-2.66 1.72-.37.82 1.12 3-.56-.53-2.31-2.22-.16c.26-.02.54-.06.81-.06Zm-1.13.06-1.56.66-.75-.13c.74-.27 1.5-.44 2.31-.53Zm-8.8 10.72.96 1.13v2.06l1.88 2.06h1.15l2.85 3.5a9.98 9.98 0 0 1-6.85-8.75Z',
        'gofore' => 'M17 4a12 12 0 0 0 0 24c3.59 0 6.78-1.6 8.98-4.09a4.1 4.1 0 0 0-3.98-3.9v.86A6.95 6.95 0 0 1 17 23a7 7 0 1 1 4.46-12.4l3.5-3.56A11.94 11.94 0 0 0 17 4zm-1 9v5h6c2.21 0 3.42.8 4 2 0-2.63 0-7-4-7h-6z',
        'golf-ball-solid' => 'M16 3a9.99 9.99 0 0 0-5 18.63V22l-.03 1H11a4.28 4.28 0 0 1 3.97 4H7v2h18v-2h-7.97A4.2 4.2 0 0 1 21 23h.03L21 22v-.38A9.99 9.99 0 0 0 16 3Zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Zm3 6a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-2 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-5 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-2.72 7h1.44c-.26.3-.5.62-.72 1a6.4 6.4 0 0 0-.72-1Z',
        'goodreads-g' => 'M16 3c-4.41 0-8 4.26-8 9.5s3.59 9.5 8 9.5a7.51 7.51 0 0 0 6-3.24V22c0 2.76-2.7 5-6 5-2.46 0-4.57-1.24-5.5-3H8.35c.98 2.89 4.04 5 7.66 5 4.41 0 8-3.14 8-7V4h-2v2.24A7.51 7.51 0 0 0 16 3zm0 2c3.3 0 6 3.36 6 7.5 0 4.14-2.7 7.5-6 7.5s-6-3.36-6-7.5C10 8.36 12.7 5 16 5z',
        'goodreads' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8.5 2c-2.48 0-4.5 2.24-4.5 5s2.02 5 4.5 5c1.42 0 2.68-.75 3.5-1.9v1.4a3.5 3.5 0 0 1-6.65 1.5h-1.07A4.5 4.5 0 0 0 20 18.5V10h-1v.9A4.33 4.33 0 0 0 15.5 9zm0 1c1.93 0 3.5 1.8 3.5 4s-1.57 4-3.5 4-3.5-1.8-3.5-4 1.57-4 3.5-4z',
        'google-drive' => 'm11.44 5-.28.47-8 13-.32.5.29.53 4 7 .28.5h17.18l.29-.5 4-7 .28-.53-.32-.5-8-13-.28-.47Zm2.34 2h5.66l6.78 11h-5.66ZM12 7.9l2.97 4.85-6.94 11.28L5.16 19Zm4.16 6.76L18.22 18h-4.13ZM12.87 20h13.41l-2.87 5H9.78Z',
        'google-play' => 'M7.75 3c-.07 0-.14.03-.22.03h-.32c-.1.02-.2.07-.3.13A1.82 1.82 0 0 0 6 4.7v22.78c0 .5.22 1.08.75 1.37l.13.04.09.03c.48.16.97.06 1.34-.16h.03L17.75 23l4.78-2.88 4.6-2.78c.45-.27.88-.8.87-1.43 0-.64-.45-1.1-.88-1.35L24.7 13.1l-2.07-1.25a1.3 1.3 0 0 0-.09-.06l-4.78-2.9-9.22-5.6c-.23-.14-.5-.25-.78-.28ZM8 6.1l9.44 9.84L8 25.78Zm4.81 2.12 3.9 2.37 3.7 2.25-1.6 1.66Zm9.35 5.69 1.5.9c.83.51 1.41.83 1.9 1.13-.92.55-2.66 1.63-3.37 2.06l-1.97-2.06Zm-3.35 3.5 1.6 1.65-3.7 2.25-3.93 2.38Z',
        'google-plus-g' => 'M11 7a9 9 0 1 0 8.81 7.2l-.04-.2H11v3h6a6.1 6.1 0 0 1-6 5 6 6 0 1 1 3.92-10.54l2.15-2.1A8.96 8.96 0 0 0 11 7Zm14 4v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'google-plus-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm6.6 4a4.6 4.6 0 1 0 0 9.18c2.64 0 4.4-1.86 4.4-4.48 0-.3-.03-.47-.08-.7h-4.33v1.52h2.6c-.1.67-.78 1.97-2.6 1.97a2.87 2.87 0 0 1-2.84-2.9c0-1.6 1.28-2.9 2.84-2.9.9 0 1.5.39 1.83.71l1.25-1.2a4.38 4.38 0 0 0-3.08-1.2zm6.73 3v1.33H19v1.34h1.33V18h1.34v-1.33H23v-1.34h-1.33V14h-1.34z',
        'google-plus' => 'M11 7a9 9 0 1 0 8.81 7.2l-.04-.2H11v3h6a6.1 6.1 0 0 1-6 5 6 6 0 1 1 3.92-10.54l2.15-2.1A8.96 8.96 0 0 0 11 7Zm14 4v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'google-wallet' => 'M22 3.5c-.58 0-1.14.16-1.66.44a3.48 3.48 0 0 0-1.4 4.72s.45.94.87 2.46a20.26 20.26 0 0 0-4.5-4.74c-.01-.02-.04-.02-.06-.04A3.46 3.46 0 0 0 13 5.5a3.5 3.5 0 0 0-2.88 5.47s.26.45.54 1.1c-.36-.28-.71-.54-1.07-.76C8.2 10.44 7 10 6 10c-1.64 0-3 1.36-3 3 0 1 .61 1.79 1.28 2.34.67.56 1.45 1.03 2.25 1.57 1.49 1 2.97 2.2 3.81 4.46l-.4.94a3.47 3.47 0 0 0 1.34 4.72c.52.3 1.12.47 1.72.47a3.5 3.5 0 0 0 3.03-1.78 20.8 20.8 0 0 0 1.78-4.6 13 13 0 0 1 .69 4.82 1 1 0 0 0 .06.6v.05a3.49 3.49 0 0 0 6.63.85 30.2 30.2 0 0 0 2.31-11.35 23.8 23.8 0 0 0-2.44-10.78A3.48 3.48 0 0 0 22 3.5Zm0 2c.53 0 1.04.29 1.31.78a21.9 21.9 0 0 1 2.19 9.81 28.5 28.5 0 0 1-2.13 10.54 1.54 1.54 0 0 1-2 .75 1.52 1.52 0 0 1-.75-2c.03-.07 1.64-3.76 1.85-8.35a.98.98 0 0 0 .03-.53v-.4c0-4.96-1.8-8.35-1.81-8.38A1.5 1.5 0 0 1 22 5.5Zm-9 2c.36 0 .7.14.97.38l.03.03c.08.07.16.15.22.25.1.13 2.28 3.32 2.28 8.03 0 4.63-2.1 8.4-2.19 8.56a1.5 1.5 0 0 1-1.31.75c-.25 0-.52-.05-.75-.19a1.52 1.52 0 0 1-.56-2.06c.02-.05 1.81-3.25 1.81-7.06 0-3.73-1.7-6.32-1.72-6.35-.46-.68-.3-1.59.38-2.06.25-.18.55-.28.84-.28Zm4.97 4.47a17.5 17.5 0 0 1 2.5 4.81c-.06 1.61-.3 3.1-.6 4.34-.54-1.9-1.2-3.07-1.43-3.43a17.12 17.12 0 0 0-.47-5.72ZM6 12c.1 0 1.36.3 2.53 1.03a8.5 8.5 0 0 1 2.97 3v.16c0 .88-.11 1.72-.28 2.5a12.48 12.48 0 0 0-3.56-3.44c-.86-.58-1.63-1.05-2.1-1.44C5.1 13.43 5 13.24 5 13c0-.57.43-1 1-1Z',
        'google' => 'M18.68 15.4c0-1.97 3.21-2.14 3.21-6a5.1 5.1 0 0 0-2.14-4.26h1.94L23.62 4h-6.27c-6.39 0-7.41 4.47-7.41 5.95 0 2.2 1.72 4.95 5.2 4.95.31 0 .65-.02 1-.06-.05.16-.3.73-.3 1.23 0 1.07.68 1.74.91 2.15-3.8-.03-8.38 1.62-8.38 5.28 0 1.34 1.16 4.5 6.57 4.5 6.18 0 8.05-3.81 8.05-5.95 0-4.08-4.3-4.76-4.3-6.64Zm-2.1-1.36c-2.15 0-3.98-2.72-3.98-5.62 0-.87.42-3.37 2.8-3.37 3.08 0 3.83 4.56 3.83 5.8 0 .3.2 3.2-2.64 3.2Zm-.14 12.64c-1.98 0-5.4-.84-5.4-3.84 0-1.04.6-3.76 5.86-3.76.27 0 .5.01.7.03 1.1.82 3.36 2 3.36 4.17 0 .99-.58 3.4-4.52 3.4Z',
        'gopuram-solid' => 'M9 5v5H8v4H6v6H4v7h5v-7h1v-6h1v-4h2v4h-1v6h-1v7h2v-2a3 3 0 1 1 6 0v2h2v-7h-1v-6h-1v-4h2v4h1v6h1v7h5v-7h-2v-6h-2v-4h-1V5h-2v2h-2V5h-2v2h-2V5h-2v2h-2V5H9zm7 6a1 1 0 0 1 1 1v2h-2v-2a1 1 0 0 1 1-1zm0 5a2 2 0 0 1 2 2v2h-4v-2c0-1.1.9-2 2-2z',
        'graduation-cap-solid' => 'm16 4.88-.47.25-13.5 7L.31 13l1.69.84v8.44a2 2 0 1 0 2 0v-7.4l2 1.03V21c0 .44.2.84.44 1.1.23.25.52.4.81.56.59.3 1.29.52 2.16.71 1.73.4 4.04.63 6.59.63s4.86-.24 6.6-.63a8.6 8.6 0 0 0 2.15-.71c.3-.16.58-.31.81-.57.24-.25.44-.65.44-1.09v-5.1l3.97-2.03 1.72-.87-1.72-.88-13.5-7Zm0 2.25L27.31 13l-1.78.9c-.23-.23-.5-.4-.78-.56a8.6 8.6 0 0 0-2.16-.71A31.41 31.41 0 0 0 16 12c-2.56 0-4.86.24-6.6.63a8.6 8.6 0 0 0-2.15.71c-.28.15-.55.33-.78.57L4.69 13ZM16 14c2.44 0 4.64.22 6.16.56.75.17 1.36.37 1.68.53.1.06.12.1.16.13v3.81c-.42-.15-.88-.29-1.4-.4A31.52 31.52 0 0 0 16 18c-2.55 0-4.86.24-6.6.63-.53.11-.98.25-1.4.4v-3.81c.04-.03.05-.07.16-.13.32-.16.93-.36 1.68-.53A29.9 29.9 0 0 1 16 14Zm0 6c2.43 0 4.63.22 6.16.56.63.14 1.03.3 1.37.44-.34.15-.74.3-1.37.44-1.53.34-3.73.56-6.16.56s-4.63-.22-6.16-.56A7.17 7.17 0 0 1 8.47 21c.34-.15.74-.3 1.37-.44A30.1 30.1 0 0 1 16 20Z',
        'gratipay' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-3.5 6a2.52 2.52 0 0 0-2.06 3.94h.03L16 22.25l5.53-6.31.03-.03A2.5 2.5 0 0 0 19.5 12c-1.77-.01-2.19 1.68-3.5 1.68S14.27 12 12.5 12Z',
        'grav' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-.1 2.02a.81.81 0 0 0-.72.48l.02-.02c-.21.5.2 2.49.97 3.8-.1.07-.17.13-.34.29-.91.41-2.37 2.55-2.37 2.55-1.2.46-3.27 1.82-2.99 3.04.01.13.06.23.13.31-.12.1-.24.22-.35.36-.5.58-.23 1.48.74 1.03.67-.3 1.26-.86 1.54-1.29 0 0-.23-.2-.69-.18 1.17-.28 1.47-.11 1.95-.05.34.16.34-1.46.34-1.46 0-.62-.09-1.3-.47-1.75.53.52 1.23 1.38 1.19 2.56-.04.78-.64.97-.64.97-.39.7-1.83 2.8-1.29 4.49 0 0-.41-.63-.43-.94-.74.82-1.97 2.21-1.04 2.73 1.12.62 4.6-3.75 5.34-6.02 1.46-.88 2.34-2 2.7-2.75.92 1.84 4.2 3.74 4.45 2.24.1-.68-.85-.7-1.07-1.09-.57-1.01-1.35-1.3-2.48-1.02.49-.34 1-.26 1-.26 0-.27 0-.55-.4-1.05.16-.53 0-.95 0-.95a2.4 2.4 0 1 0-2.22.05 2 2 0 0 1-1.7-1.46c-.23-.93.03-1.82.27-2.36l-.7-.59s-.58 0-1.03.23c.5-.65 1.06-.61 1.06-.61 0-.27-.02-.63-.15-.92a.68.68 0 0 0-.63-.36zm3.57 2.27c.42.05.82.32 1.23.7.5.48 1.23 1.05.72 2.04-.53 1-1.9 1.4-2.75.8-.84-.6-1.43-1.82-.5-2.87.45-.53.88-.71 1.3-.67zm.9 1.54c-.3.04-.59.51-.34.8.31.39 1.36.1.66-.68a.34.34 0 0 0-.31-.12zm-3.19 2.58c.13 0 .26.05.36.14l.44.46a.5.5 0 0 1 0 .69l-.41.4c-.19.2-.5.2-.7 0l-.45-.44a.51.51 0 0 1 0-.7l.41-.4c.1-.1.22-.15.35-.15z',
        'greater-than-equal-solid' => 'M6 5v2.16L22.53 14 6 20.84V23l20-8.22v-1.56Zm0 20v2h20v-2Z',
        'greater-than-solid' => 'M6 6v2.16L22.53 16 6 23.84V26l20-9.22v-1.56Z',
        'grimace-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM12 17a3 3 0 0 0 0 6h8a3 3 0 0 0 0-6h-8zm0 2h1v2h-1a1 1 0 0 1 0-2zm3 0h2v2h-2v-2zm4 0h1a1 1 0 0 1 0 2h-1v-2z',
        'grimace' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM12 17a3 3 0 0 0 0 6h8a3 3 0 0 0 0-6h-8zm0 2h1v2h-1a1 1 0 0 1 0-2zm3 0h2v2h-2v-2zm4 0h1a1 1 0 0 1 0 2h-1v-2z',
        'grin-alt-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 6a1.5 3 0 0 0 0 6 1.5 3 0 0 0 0-6zm9 0a1.5 3 0 0 0 0 6 1.5 3 0 0 0 0-6zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-alt' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 6a1.5 3 0 0 0 0 6 1.5 3 0 0 0 0-6zm9 0a1.5 3 0 0 0 0 6 1.5 3 0 0 0 0-6zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-beam-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-beam-sweat-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.02 13.02 0 0 0 11.66-18.72c-.3.7-.8 1.3-1.4 1.77A11.01 11.01 0 0 1 16 27C9.94 27 5 22.07 5 16A11.01 11.01 0 0 1 19.84 5.7c.26-.59.56-1.2.87-1.8C19.25 3.33 17.66 3 16 3zm7.5 0S21 7.27 21 8.6c0 1.32 1.12 2.4 2.5 2.4S26 9.92 26 8.6C26 7.27 23.5 3 23.5 3zM9 14v2h5v-2H9zm9 0v2h5v-2h-5z',
        'grin-beam-sweat' => 'M16 3a13.01 13.01 0 0 0 0 26 13.02 13.02 0 0 0 11.66-18.72c-.3.7-.8 1.3-1.4 1.77A11.01 11.01 0 0 1 16 27C9.94 27 5 22.07 5 16A11.01 11.01 0 0 1 19.84 5.7c.26-.59.56-1.2.87-1.8C19.25 3.33 17.66 3 16 3zm7.5 0S21 7.27 21 8.6c0 1.32 1.12 2.4 2.5 2.4S26 9.92 26 8.6C26 7.27 23.5 3 23.5 3zM9 14v2h5v-2H9zm9 0v2h5v-2h-5z',
        'grin-beam' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-hearts-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-5.5 5a1.5 1.5 0 0 0-1.19 2.4C10.06 14.7 12 16 12 16s3-1.9 3-3.5a1.5 1.5 0 0 0-3 0c0-.83-.67-1.5-1.5-1.5Zm8 0a1.5 1.5 0 0 0-1.19 2.4C18.06 14.7 20 16 20 16s1.99-1.29 2.72-2.63c.16-.3.28-.58.28-.87a1.5 1.5 0 0 0-3 0c0-.83-.67-1.5-1.5-1.5Zm-7.69 8L9.1 20a7.98 7.98 0 0 0 13.82 0l-1.72-1a5.98 5.98 0 0 1-10.38 0Z',
        'grin-hearts' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-5.5 5a1.5 1.5 0 0 0-1.19 2.4C10.06 14.7 12 16 12 16s3-1.9 3-3.5a1.5 1.5 0 0 0-3 0c0-.83-.67-1.5-1.5-1.5Zm8 0a1.5 1.5 0 0 0-1.19 2.4C18.06 14.7 20 16 20 16s1.99-1.29 2.72-2.63c.16-.3.28-.58.28-.87a1.5 1.5 0 0 0-3 0c0-.83-.67-1.5-1.5-1.5Zm-7.69 8L9.1 20a7.98 7.98 0 0 0 13.82 0l-1.72-1a5.98 5.98 0 0 1-10.38 0Z',
        'grin-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-squint-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-squint-tears-solid' => 'M16 3C8.83 3 3 8.83 3 16c0 3.88 1.72 7.36 4.42 9.74.2-.49.48-1.12.89-1.89A11.01 11.01 0 1 1 23.85 8.31c.77-.4 1.4-.7 1.9-.89A12.96 12.96 0 0 0 16 3zm11.5 6c-.83 0-3.5 1.5-3.5 1.5s2.67 1.5 3.5 1.5a1.5 1.5 0 0 0 0-3zm-8.2.3-4 4 1.4 1.4 4-4-1.4-1.4zm4.27 4.13L13.43 23.57a8 8 0 0 0 10.14-10.14zm5.22.32a3.47 3.47 0 0 1-2 .16A11.01 11.01 0 0 1 13.92 26.8c.09.37.09.59.09.71 0 .46-.1.9-.25 1.3A13.02 13.02 0 0 0 28.8 13.77zm-15.5 1.54-4 4 1.42 1.42 4-4-1.42-1.42zM10.5 24S9 26.67 9 27.5a1.5 1.5 0 0 0 3 0c0-.83-1.5-3.5-1.5-3.5z',
        'grin-squint-tears' => 'M16 3C8.83 3 3 8.83 3 16c0 3.88 1.72 7.36 4.42 9.74.2-.49.48-1.12.89-1.89A11.01 11.01 0 1 1 23.85 8.31c.77-.4 1.4-.7 1.9-.89A12.96 12.96 0 0 0 16 3zm11.5 6c-.83 0-3.5 1.5-3.5 1.5s2.67 1.5 3.5 1.5a1.5 1.5 0 0 0 0-3zm-8.2.3-4 4 1.4 1.4 4-4-1.4-1.4zm4.27 4.13L13.43 23.57a8 8 0 0 0 10.14-10.14zm5.22.32a3.47 3.47 0 0 1-2 .16A11.01 11.01 0 0 1 13.92 26.8c.09.37.09.59.09.71 0 .46-.1.9-.25 1.3A13.02 13.02 0 0 0 28.8 13.77zm-15.5 1.54-4 4 1.42 1.42 4-4-1.42-1.42zM10.5 24S9 26.67 9 27.5a1.5 1.5 0 0 0 3 0c0-.83-1.5-3.5-1.5-3.5z',
        'grin-squint' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grin-stars-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4 5.27-.88 1.96-2.12.23 1.59 1.43-.45 2.11L12 14.93 13.86 16l-.45-2.1L15 12.45l-2.13-.23-.87-1.96zm8 0-.88 1.96-2.12.23 1.59 1.43-.45 2.11L20 14.93 21.86 16l-.45-2.1L23 12.45l-2.13-.23-.87-1.96zM10.81 19 9.1 20a8.11 8.11 0 0 0 4.78 3.71A7.94 7.94 0 0 0 22.91 20l-1.72-1a6 6 0 0 1-10.38 0z',
        'grin-stars' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4 5.27-.88 1.96-2.12.23 1.59 1.43-.45 2.11L12 14.93 13.86 16l-.45-2.1L15 12.45l-2.13-.23-.87-1.96zm8 0-.88 1.96-2.12.23 1.59 1.43-.45 2.11L20 14.93 21.86 16l-.45-2.1L23 12.45l-2.13-.23-.87-1.96zM10.81 19 9.1 20a8.11 8.11 0 0 0 4.78 3.71A7.94 7.94 0 0 0 22.91 20l-1.72-1a6 6 0 0 1-10.38 0z',
        'grin-tears-solid' => 'M16 3A13.01 13.01 0 0 0 3 15.89c.58-.23 1.26-.46 2.04-.7A11 11 0 0 1 16 5a11 11 0 0 1 10.96 10.2c.78.23 1.46.46 2.03.69A13.01 13.01 0 0 0 16 3zM9 14v2h5v-2H9zm9 0v2h5v-2h-5zM6 17s-2.97.83-3.56 1.42a1.51 1.51 0 0 0 2.14 2.14C5.17 19.97 6 17 6 17zm20 0s.83 2.97 1.42 3.56a1.51 1.51 0 0 0 2.14-2.14C28.97 17.83 26 17 26 17zM9 19s1.61 5 7 5 7-5 7-5H9zm-2.57 2.4a3.29 3.29 0 0 1-1.54 1.31A12.99 12.99 0 0 0 16 29c4.7 0 8.83-2.53 11.1-6.29a3.32 3.32 0 0 1-1.54-1.31 11 11 0 0 1-19.13 0z',
        'grin-tears' => 'M16 3A13.01 13.01 0 0 0 3 15.89c.58-.23 1.26-.46 2.04-.7A11 11 0 0 1 16 5a11 11 0 0 1 10.96 10.2c.78.23 1.46.46 2.03.69A13.01 13.01 0 0 0 16 3zM9 14v2h5v-2H9zm9 0v2h5v-2h-5zM6 17s-2.97.83-3.56 1.42a1.51 1.51 0 0 0 2.14 2.14C5.17 19.97 6 17 6 17zm20 0s.83 2.97 1.42 3.56a1.51 1.51 0 0 0 2.14-2.14C28.97 17.83 26 17 26 17zM9 19s1.61 5 7 5 7-5 7-5H9zm-2.57 2.4a3.29 3.29 0 0 1-1.54 1.31A12.99 12.99 0 0 0 16 29c4.7 0 8.83-2.53 11.1-6.29a3.32 3.32 0 0 1-1.54-1.31 11 11 0 0 1-19.13 0z',
        'grin-tongue-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-8.73 5.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-tongue-squint-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-9.23 5.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-tongue-squint' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-9.23 5.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-tongue-wink-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6.5 1v2h5v-2h-5zm-6.23 4.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-tongue-wink' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6.5 1v2h5v-2h-5zm-6.23 4.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-tongue' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-8.73 5.36-1.54 1.28A6.82 6.82 0 0 0 14 20.77V22c0 1.1.9 2 2 2a2 2 0 0 0 2-2v-1.23a6.81 6.81 0 0 0 3.77-2.13l-1.54-1.28C19.38 18.37 17.76 19 16 19c-1.76 0-3.39-.63-4.23-1.64z',
        'grin-wink-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm6.5 1v2h5v-2Zm2.97 4.03a4.6 4.6 0 0 1-1.66 3.69A5.4 5.4 0 0 1 16 22a6.35 6.35 0 0 1-4.69-1.97l-1.4 1.44A8.54 8.54 0 0 0 16 24c1.55 0 3.26-.59 4.63-1.75a6.75 6.75 0 0 0 2.34-5.22Z',
        'grin-wink' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm6.5 1v2h5v-2Zm2.97 4.03a4.6 4.6 0 0 1-1.66 3.69A5.4 5.4 0 0 1 16 22a6.35 6.35 0 0 1-4.69-1.97l-1.4 1.44A8.54 8.54 0 0 0 16 24c1.55 0 3.26-.59 4.63-1.75a6.75 6.75 0 0 0 2.34-5.22Z',
        'grin' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'grip-horizontal-solid' => 'M2 7v8h8V7H2zm10 0v8h8V7h-8zm10 0v8h8V7h-8zM4 9h4v4H4V9zm10 0h4v4h-4V9zm10 0h4v4h-4V9zM2 17v8h8v-8H2zm10 0v8h8v-8h-8zm10 0v8h8v-8h-8zM4 19h4v4H4v-4zm10 0h4v4h-4v-4zm10 0h4v4h-4v-4z',
        'grip-lines-solid' => 'M3 11v2h26v-2H3zm0 8v2h26v-2H3z',
        'grip-lines-vertical-solid' => 'M11 3v26h2V3h-2zm8 0v26h2V3h-2z',
        'grip-vertical-solid' => 'M7 2v8h8V2H7zm10 0v8h8V2h-8zM9 4h4v4H9V4zm10 0h4v4h-4V4zM7 12v8h8v-8H7zm10 0v8h8v-8h-8zm-8 2h4v4H9v-4zm10 0h4v4h-4v-4zM7 22v8h8v-8H7zm10 0v8h8v-8h-8zm-8 2h4v4H9v-4zm10 0h4v4h-4v-4z',
        'gripfire' => 'm15.69 1 .03.6C15.72 7.18 7 10.92 7 17.86c0 3 2.49 5.02 4.51 6.79 3.87 2.82 4.63 4.08 4.63 5 0 .62-.14 1.03-.14 1.35.77-1.01.86-1.93.87-2.8 0-1.8-1.26-3.41-2.6-5.24-.94-1.35-2.5-2.58-2.5-4.2 0-4.47 6.23-7.42 6.23-12.3 0-2.84-2.02-5.32-2.31-5.46zm3.69 8 .24.43c.14.31.2.66.2 1.03 0 2.7-3.48 6.71-3.63 7.04-.14.31-.19.65-.19.96 0 1.21.91 2.54 1.07 2.54.15 0 3.41-3.34 3.51-5.3.38.71.55 1.37.55 2.02 0 2.49-2.52 5.85-2.52 5.85 0 .7 1.92 3.2 2.13 3.2.07 0 .15-.07.2-.14C23.23 24.26 25 21.5 25 18.38c0-.48-.04-.98-.13-1.49-.73-4.02-4.5-7.5-5.5-7.89z',
        'grunt' => 'M17.12 3c-1.5.53-1.87 1.34-1.99 2.07-.38-.28-.34-1.17-.36-1.4-.38.04-1.48 1.1-1.43 2.45l-.3.09a5.65 5.65 0 0 0-2.5-2c-.4-.11-.82-.18-1.22-.18-1.47 0-2.34.88-2.35.89l-.41.47.62.13c.01 0 1.05.22 1.47.89.08.11.1.33.12.57 0 .14-.02.28-.05.41l-.05.3c-.39.02-.72.1-.99.23-.36.2-.61.49-.71.87-.26.92.57 1.95.6 1.99.1.17.14 1.4-.09 1.9a.76.76 0 0 1-.22.23l-.1.08c-.32.24-.8.6-.8 1.41 0 1.12 1.15 1.73 2.06 2.22l.42.23c.14.08.62.58.62 1.33 0 .35-.03 2.01-.19 3.17a3.68 3.68 0 0 1-1.25-2.23s-1.48 1.15-1.04 3.6a3.43 3.43 0 0 0 2.38 2.77c.45.97 1.5 2.32 3.42 2.52.73.6 1.75.99 3.23.99a4.9 4.9 0 0 0 3.24-.99 4.23 4.23 0 0 0 3.41-2.52 3.45 3.45 0 0 0 2.39-2.77c.41-2.46-1.07-3.6-1.07-3.6-.13.9-.66 1.71-1.25 2.22a29.74 29.74 0 0 1-.2-3.17c0-.75.5-1.24.63-1.32l.42-.24c.91-.49 2.05-1.1 2.05-2.22 0-.82-.47-1.17-.78-1.4a2.16 2.16 0 0 1-.11-.1c-.11-.08-.2-.15-.22-.22a3.98 3.98 0 0 1-.09-1.9c.03-.03.85-1.06.6-2-.1-.37-.35-.67-.72-.86-.26-.13-.6-.2-.99-.22 0-.1-.02-.2-.04-.3a1.4 1.4 0 0 1-.05-.41c.02-.24.04-.46.12-.58.42-.67 1.46-.89 1.47-.89l.62-.12-.41-.48c0-.01-.88-.9-2.35-.9a4 4 0 0 0-1.22.2 5.7 5.7 0 0 0-2.51 2 6.9 6.9 0 0 0-.49-.14c-.21-.8.46-1.95.46-1.95s-.69-.15-1.7.77a2.5 2.5 0 0 1-.1-1.89zm-7.8 1.8c.32 0 .62.04.9.13.91.3 1.61 1.18 1.92 1.63l-.24.11a7.5 7.5 0 0 0-.36.19c-.14-.28-.43-.7-1.06-1.14a2.53 2.53 0 0 0-1.91-.4c-.17-.12-.34-.2-.5-.28.25-.1.7-.25 1.26-.25zm13.35 0c.55 0 1 .14 1.25.25a3.9 3.9 0 0 0-.5.26 2.51 2.51 0 0 0-1.92.41c-.62.45-.91.86-1.05 1.14a4 4 0 0 0-.6-.3 4.14 4.14 0 0 1 1.92-1.63c.28-.1.59-.14.9-.14zm.16 1.05-.11.16c-.17.27-.2.6-.23.9-.02.33-.05.64-.22.87a6.2 6.2 0 0 0-.58.14 3.45 3.45 0 0 0-.54-.57c.08-.24.28-.82.69-1.14.28-.22.62-.34 1-.36zm-13.67 0c.38.02.71.14.99.36.4.32.61.9.69 1.14-.25.21-.43.4-.54.57a6.2 6.2 0 0 0-.58-.14c-.17-.22-.2-.53-.22-.86a1.96 1.96 0 0 0-.22-.9 1.91 1.91 0 0 0-.12-.16zm6.84.8a8.5 8.5 0 0 1 3.77.8c.72.35 1 .62 1.1.77a6.56 6.56 0 0 0-2.7 2.36l-.18.3.29-.2.01-.02c.45-.34 1.98-1.51 3.26-1.91.35-.12 1.04-.3 1.67-.3.32 0 .57.04.76.14.18.1.3.22.34.4.13.46-.3 1.14-.47 1.35a.45.45 0 0 0-.07.1 7.03 7.03 0 0 1-.01-.72c-.2.44-.33 1.6-.26 2.18.18 1.49.8 2.25.8 2.25a4 4 0 0 1-.14-.76l.1.09.03.02c.24.19.46.36.46.93 0 .72-.79 1.14-1.54 1.54l-.42.24c-.45.25-.92.84-.97 1.73-.05.74.04 2.53.17 3.85a6.2 6.2 0 0 1-2.01.35c-.1-.2-.2-.43-.28-.67-.04-.1-1-2.59-1.34-3.15.28 1.98.89 3.74 1.2 4.54a4.25 4.25 0 0 0-.6-.03h-5.94c-.23 0-.42.01-.6.03.3-.8.92-2.56 1.2-4.54-.35.56-1.3 3.06-1.34 3.15-.08.24-.18.46-.28.67a6.26 6.26 0 0 1-2.02-.35c.13-1.32.22-3.1.18-3.85a2.1 2.1 0 0 0-.97-1.73l-.42-.24c-.76-.4-1.54-.82-1.54-1.54 0-.57.22-.75.46-.93l.02-.02.11-.09a4 4 0 0 1-.13.76s.6-.76.8-2.25a5.61 5.61 0 0 0-.27-2.18c.01.25 0 .5-.01.73a.6.6 0 0 0-.07-.11c-.16-.2-.6-.9-.47-1.36a.6.6 0 0 1 .34-.39c.19-.1.44-.15.76-.15.63 0 1.32.19 1.67.3a12.62 12.62 0 0 1 3.27 1.94l.29.2-.18-.3a6.56 6.56 0 0 0-2.7-2.36c.1-.15.38-.41 1.1-.77a8.5 8.5 0 0 1 3.77-.8zm-1.4 4.99c.01 0 .75.9 1.4.9.65 0 1.38-.9 1.38-.9-.5.3-.95.4-1.38.42a2.72 2.72 0 0 1-1.4-.42zm-4.79.06c-.24 0-.5.04-.77.1l.68.21c-.21.1-.33.36-.36.61-.05.5.27.97.27.97.03-.38.1-.65.2-.84.02.52.16 1.2.65 1.73.35.39 1.8 1.18 2.79.3l.15.44c.15.52-.14 1.29-.14 1.29s.77-.87.7-1.65c.55-.03 1.1-.43 1.08-1 0 0-.96.53-1.8-.44-.43-.5-1.7-1.76-3.45-1.72zm12.37.01c-1.75-.04-3.01 1.22-3.44 1.72-.85.97-1.8.45-1.8.45-.01.55.52.95 1.07.98-.06.78.7 1.65.7 1.65s-.28-.77-.13-1.29l.15-.43c.98.88 2.44.08 2.78-.31.5-.54.63-1.2.65-1.73.1.2.18.46.2.84 0 0 .33-.46.27-.97-.03-.25-.15-.5-.35-.6h-.01c.23-.09.47-.16.69-.2a3.1 3.1 0 0 0-.78-.1zm-11.38.82c1 .56 1.9 1.3 2.28 1.88a1.7 1.7 0 0 1-1.93-.09c-.52-.38-.5-1.33-.35-1.79zm10.4 0c.15.46.17 1.4-.36 1.8a1.7 1.7 0 0 1-1.92.08 7.17 7.17 0 0 1 2.27-1.88zM7.82 20.55c.55 1.75 2.4 2.25 3.78 2.3a8.7 8.7 0 0 1-.36.51l-.07.07c-.36.4-.44.94-.2 1.62-1.16 0-2.36-.5-2.96-1.5-.61-1.02-.44-2.75-.19-3zm16.34 0c.25.26.43 1.99-.2 3-.6 1-1.8 1.49-2.94 1.5.23-.67.15-1.22-.21-1.6a8.37 8.37 0 0 1-.43-.58c1.38-.07 3.23-.57 3.78-2.32zm-11.19 2.93H19c.77 0 1.1.2 1.25.36.21.25.23.64.04 1.18-.33.95-1.23 3.28-4.3 3.28-3.08 0-3.98-2.32-4.31-3.28-.2-.54-.17-.93.04-1.18.15-.16.49-.36 1.25-.36zm4.65.77c-.21 0-.36.05-.45.14-.11.11-.08.26-.05.34a4 4 0 0 0 .66.98.8.8 0 0 0 .56.23c.22 0 .44-.09.6-.22.12-.1.52-.47.7-.92.06-.16.05-.3-.05-.4-.07-.06-.2-.14-.48-.15h-1.49zm-4.75 0c-.28 0-.42.09-.48.15-.1.1-.11.24-.05.41.18.46.58.84.7.95.16.13.38.21.6.21.22 0 .42-.08.56-.23.38-.41.6-.87.66-1 .03-.08.06-.23-.05-.35-.1-.09-.24-.13-.45-.13h-1.49zm-2.54 1.5c.3.06.62.1.94.13.18.4.38.8.63 1.17a3.53 3.53 0 0 1-1.57-1.3zm11.32 0c-.33.49-.84 1-1.57 1.3.25-.36.45-.77.62-1.17.33-.03.64-.07.95-.12z',
        'guitar-solid' => 'M26.6 3.06c-.11 0-.21.05-.32.16l-.75.75-.31-.31-.44.4.34.35-.43.4-.32-.31-.43.44.31.31-.72.75c-.21.21-.21.41 0 .63l-4.19 4.18a8.8 8.8 0 0 0-2.87-1.6 4.34 4.34 0 0 0-4.53 1.07 3.57 3.57 0 0 0-1 1.97 2.9 2.9 0 0 1-2.66 2.34c-1.44.1-2.7.68-3.65 1.63-2.5 2.5-2.06 7.05 1.03 10.12A8.7 8.7 0 0 0 11.69 29c1.56 0 3-.54 4.1-1.63a5.64 5.64 0 0 0 1.62-3.65 2.87 2.87 0 0 1 2.3-2.66 3.66 3.66 0 0 0 2-1 4.33 4.33 0 0 0 1.07-4.53 7.73 7.73 0 0 0-.84-1.78l-1.47 1.47c.16.3.29.59.37.87.31 1.04.15 1.89-.53 2.57-.24.23-.53.37-.9.43a4.93 4.93 0 0 0-4 4.5 3.66 3.66 0 0 1-1.04 2.38c-1.72 1.72-4.98 1.27-7.28-1.03s-2.78-5.6-1.06-7.32a3.7 3.7 0 0 1 2.38-1.03 4.93 4.93 0 0 0 4.5-4c.06-.37.2-.66.43-.9.47-.47 1-.69 1.63-.69.28 0 .61.06.94.16.63.18 1.33.55 2 1.06l-3.35 3.34A2.5 2.5 0 1 0 16.5 18c0-.15-.04-.3-.06-.44l9.1-9.12c.2.21.43.21.65 0l.75-.75.31.31.4-.4-.3-.32.43-.44.22.44.4-.44-.3-.3.74-.76c.22-.21.22-.44 0-.66l-1.9-1.9a.51.51 0 0 0-.35-.16Zm-.1 1.22.44.44L25 6.62l-.4-.4Zm.84.75.44.44-1.94 1.9-.4-.43ZM9.1 19.7l-1.4 1.4 3.22 3.22 1.4-1.4Z',
        'gulp' => 'M22.15 1a.14.14 0 0 0-.09.03l-3.71 4.42-.76 2.6c-.52-.02-1.05-.02-1.6-.02-3.85 0-6.99.4-6.99.91 0 1.21 13.99 1.21 13.99 0 0-.37-1.67-.69-4.09-.84l.6-2.14 3.47-4.18h.01c.08-.09-.07-.33-.32-.55a.87.87 0 0 0-.5-.23zM17.3 9.08l-.01.04v.01c0 .08.3.14.67.14.36 0 .67-.06.67-.14l.01-.04c.1.03.15.07.15.12 0 .12-.37.22-.84.21-.45 0-.83-.09-.83-.2 0-.06.07-.1.18-.14zm5.61.34c-1.85.99-11.96 1-13.82.01l.82 7.24c.36-1.16 1.26-2.71 2.43-3.19.38-.15.76-.15 1.13.06.31.17.58.53.6.68.08.37-.11.52-.26.52-.19 0-.32-.26-.42-.42-.24-.42-.62-.44-1.02-.16-.42.29-.78.77-1.03 1.2-.31.5-.57 1.06-.73 1.62-.1.32-.17.84-.04 1.14.07.13.16.21.3.21.3 0 .74-.38.96-.58.27-.26.62-.66.75-.92l.32-.9c.16-.39.6-.32.6 0 0 .6-.23.79-.6 2l-.47 1.5c-.04.15-.2.42-.38.42-.07 0-.13-.02-.16-.07-.06-.08-.05-.3-.04-.36 0-.18.38-1.28.44-1.45l-.39.38c-.33.3-.85.68-1.3.68a.76.76 0 0 1-.47-.14l.46 4.59c.12.29 2.38.98 5.34.98 2.97 0 5.22-.7 5.34-.98l.66-5.45c-.35.3-.75.67-1.19.85-.32.13-1.05.22-1.05-.33 0-.3.55-.85.87-1.24.09-.1.28-.34.28-.46 0-.17-.36-.13-.7.14a3.9 3.9 0 0 0-1.04 1.46c-.38.8-.25.49-.56 1.26-.3.77-.25.68-.31.8a.56.56 0 0 1-.24.27.38.38 0 0 1-.37-.02c-.05-.04-.08-.11-.08-.22 0-.05 0-.1.02-.15.09-.35.47-1.04.9-1.98.1-.21.07-.15.05-.13-.37.35-.66.51-.87.6-.35.15-.78.15-.87-.23l-.02-.07c-.71.53-1.47.67-1.2-.47-.28.47-.77.86-1.36.86-.25 0-.43-.08-.52-.3-.14-.3.08-.85.28-1.37.1-.25.24-.57.43-.93.1-.2.25-.31.46-.26l.1.04c.15.1.09.26.01.42-.23.43-.43.75-.56 1.2-.06.19-.12.52.09.52.14 0 .28-.05.42-.14a3.57 3.57 0 0 0 1.01-1.49l.1-.28c.07-.14.16-.29.32-.29.08 0 .15.03.2.09.1.12.08.25.02.4-.12.32-.28.6-.42.96-.08.2-.16.46-.16.67 0 .2.22.15.41.07.15-.07.3-.16.41-.26.08-.28.06-.22 1.6-3.93.08-.2.22-.27.37-.27.07 0 .13.02.2.06.1.08.1.24.06.36l-.28.6-.8 1.84c-.11.27-.46 1.1-.52 1.29-.04.12-.08.33.06.33.33 0 1.17-.75 1.4-.98 0-.02.03-.02.05-.03l.1-.32c.09-.22.17-.48.33-.65.04-.06.1-.1.16-.1.17 0 .25.07.25.24 0 .06-.04.29-.06.35l.27-.26c.9-.8 1.55-.39 1.55.02 0 .42-.54 1.02-.83 1.34-.1.11-.3.32-.3.37 0 .08.05.1.13.1.12 0 .38-.2.48-.26.3-.23.71-.57 1-.82l.9-7.88zM10.93 24.03l.9 1.47.35 4.57c0 .52 1.72.93 3.82.93 2.1 0 3.82-.41 3.82-.93l.28-4.62.85-1.42c-2.4.96-7.53 1-10.02 0z',
        'h-square-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4 3v12h2v-5h6v5h2V10h-2v5h-6v-5Z',
        'hacker-news-square' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4 3 4 7v5h2v-5l4-7h-2l-3 5.25L13 10Z',
        'hacker-news' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4.5 4 3.5 6v5h2v-5l3.5-6h-2L16 15.28 13.5 11Z',
        'hackerrank' => 'M16 3C14.23 3 5.54 7.98 4.66 9.5c-.88 1.52-.88 11.48 0 13C5.54 24.02 14.23 29 16 29c1.76 0 10.45-4.98 11.34-6.5.88-1.52.88-11.49 0-13C26.44 7.98 17.76 3 16 3zm0 2.01c1.7.35 8.42 4.2 9.6 5.5.54 1.64.53 9.33 0 10.98-1.17 1.29-7.9 5.15-9.6 5.5-1.7-.35-8.43-4.2-9.6-5.5-.53-1.65-.53-9.33 0-10.98 1.17-1.3 7.9-5.15 9.6-5.5zM13 9l-2 2h1v10h2v-4h4v4h-1l2 2 2-2h-1v-9h-2v3h-4v-4h1l-2-2z',
        'hamburger-solid' => 'M11 5c-3.3 0-6 2.7-6 6v.25l-1.13 1.5c.36.27.73.44 1.13.56v2.47c-.6.55-1 1.34-1 2.22 0 .88.4 1.67 1 2.22V23c0 1.1.9 2 2 2h18a2 2 0 0 0 2-2v-2.78c.6-.55 1-1.34 1-2.22 0-.88-.4-1.67-1-2.22v-2.47c.4-.12.77-.3 1.13-.56L27 11.22V11c0-3.3-2.7-6-6-6Zm0 2h1a1 1 0 0 0 2 0h7c2.22 0 4 1.78 4 4v.5c-.26-.07-.5-.2-.72-.38l-.53-.37-.6.34-.74.44c-.7.42-1.55.42-2.25 0l-.75-.44-.47-.28-.5.22-1.44.75a2.2 2.2 0 0 1-1.97 0l-1.47-.75-.5-.22-.47.28-.75.44c-.7.42-1.55.42-2.25 0l-.75-.44-.59-.34-.53.38c-.22.16-.47.3-.72.37V11c0-2.22 1.78-4 4-4Zm0 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-6.84 5 .4.25c1.33.8 2.99.8 4.31 0l.29-.19.96.5a4.2 4.2 0 0 0 3.76 0l.96-.5.29.19c1.32.8 2.98.8 4.3 0l.41-.25c.38.18.76.3 1.16.38V15H7v-1.63c.4-.08.78-.19 1.16-.37ZM7 17h18c.57 0 1 .43 1 1 0 .57-.43 1-1 1H7c-.57 0-1-.43-1-1 0-.57.43-1 1-1Zm0 4h18v2H7Z',
        'hammer-solid' => 'm7.06 2 2.5 1.81c4.72 3.4 6.15 6.73 6.44 7.47l-.9.9v.04l-.7.69L2.7 25.06l-.69.72 4.25 4.25.72-.75 12.4-12.84.32-.38.1-.06.96-.34.19.18-.38.91-.28.63 3.31 3.3 6.38-6.37-2.84-2.84-.47-.44-.6.22-.9.34-.22-.21.31-1 .13-.41-.2-.38s-1.05-1.95-3.43-3.84S15.59 2 10.15 2Zm6.03 2.25c3.37.5 5.8 1.77 7.44 3.06a10.57 10.57 0 0 1 2.69 2.9l-.38 1.16-.15.57.4.44 1.6 1.59.62-.25.88-.35.93.94-3.53 3.53-.93-.93.37-.91.28-.63-.5-.46-1.12-1.13-.44-.47-.63.22-1.78.72-.18.06-.72-.69-.72-.71 1.16-1.16-.22-.6s-1.35-3.39-5.07-6.9Zm2.72 10.06 1.44 1.44-11.03 11.4-1.4-1.4Z',
        'hamsa-solid' => 'M16 3a4 4 0 0 0-3.7 2.51A3.5 3.5 0 0 0 7 8.5V17H5.5a2.5 2.5 0 0 0-1.73 4.3l4.95 4.76a10.44 10.44 0 0 0 14.56 0l4.95-4.76A2.5 2.5 0 0 0 26.5 17H25V8.5a3.5 3.5 0 0 0-5.3-2.99A4 4 0 0 0 16 3zm0 2a2 2 0 0 1 2 2v8h2V8.5a1.5 1.5 0 0 1 3 0V19h3.5c.27 0 .5.23.5.5 0 .18-.1.3-.15.36l-4.96 4.76a8.46 8.46 0 0 1-11.78 0l-4.95-4.76A.5.5 0 0 1 5.5 19H9V8.5a1.5 1.5 0 0 1 3 0V15h2V7c0-1.1.9-2 2-2zm0 12c-3.5 0-5.74 3.3-5.83 3.45L9.8 21l.37.55C10.27 21.7 12.5 25 16 25s5.74-3.3 5.83-3.45l.37-.55-.37-.55C21.73 20.3 19.5 17 16 17zm0 2c1.7 0 3.06 1.25 3.72 2-.66.75-2.02 2-3.72 2-1.7 0-3.06-1.25-3.72-2 .66-.75 2.03-2 3.72-2zm0 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'hand-holding-heart-solid' => 'M14.5 3A3.5 3.5 0 0 0 11 6.5c0 3.5 6 6.5 6 6.5s6-3 6-6.5a3.5 3.5 0 0 0-6-2.44A3.48 3.48 0 0 0 14.5 3zm0 2c.4 0 .78.16 1.07.45l.53.55h1.8l.53-.55A1.5 1.5 0 0 1 21 6.5c0 1.26-2.1 3.08-4 4.21-1.9-1.14-4-2.95-4-4.21 0-.83.67-1.5 1.5-1.5zm4.72 8.98-1.64 1.15 2.61 3.72-3.6 2.5-2.54-1.32 2.7-1.36v-.01h.02a2.5 2.5 0 0 0 1.13-2.85 2.51 2.51 0 0 0-3.1-1.71l-7.1 1.98-4.71 3.24 1.9 7.72 5.04-1.83 7.14 3.7 11.87-8.21-1.13-1.65-10.88 7.54-6.86-3.55L6.3 24.4l-1.03-4.22 3.3-2.26 6.8-1.9c.28-.08.54.07.62.34a.5.5 0 0 1-.22.57l-4.36 2.2-1.75.87 7.09 3.67 6.24-4.32-3.76-5.37z',
        'hand-holding-solid' => 'M10.52 18c-1.04 0-1.82.27-1.82.27h-.02l-5.67 2.18 1.98 5.57 4.93-1.9 7.14 3.94 12.32-5.1-.76-1.85-11.44 4.73-7.1-3.9-3.9 1.48-.63-1.8 3.8-1.46s.47-.16 1.17-.16 1.52.16 2.22.79h.01v.01c1.04.9 1.81 1.52 2.9 1.86 1.08.34 2.3.38 4.36.37l-.01-2c-2.02 0-3.07-.06-3.75-.28-.7-.21-1.18-.59-2.17-1.45h-.01a5.23 5.23 0 0 0-3.55-1.3z',
        'hand-holding-usd-solid' => 'M17 4v1.19a3.08 3.08 0 0 0-1.67 1.46 2.92 2.92 0 0 0 .19 3.02A3.06 3.06 0 0 0 18 11c.14 0 .28.03.4.08a.96.96 0 0 1 .52.52c.05.12.08.26.08.4a.98.98 0 0 1-1 1c-.14 0-.28-.03-.4-.08a.96.96 0 0 1-.52-.52A1.04 1.04 0 0 1 17 12h-2a2.94 2.94 0 0 0 1.58 2.62l.42.2V16h2v-1.19A3 3 0 0 0 21 12a3.03 3.03 0 0 0-3-3c-.14 0-.28-.03-.4-.08a.96.96 0 0 1-.52-.52 1.04 1.04 0 0 1 .2-1.11A1 1 0 0 1 18 7c.57 0 1 .43 1 1h2a2.94 2.94 0 0 0-.15-.92A3.05 3.05 0 0 0 19 5.18V4h-2zm-6.48 14c-1.04 0-1.82.27-1.82.27h-.02l-5.67 2.18 1.98 5.57 4.93-1.9 7.14 3.94 12.32-5.1-.76-1.85-11.44 4.73-7.1-3.9-3.9 1.48-.63-1.8 3.8-1.46s.47-.16 1.17-.16 1.52.16 2.22.79h.01v.01c1.04.9 1.81 1.52 2.9 1.86 1.08.34 2.3.38 4.36.37l-.01-2c-2.02 0-3.07-.06-3.75-.28-.7-.21-1.18-.59-2.17-1.45h-.01a5.23 5.23 0 0 0-3.55-1.3z',
        'hand-lizard-solid' => 'M14.31 4c-1.77 0-3.45.93-4.34 2.47l-5.28 9.1A5.06 5.06 0 0 0 4 18.08V28h10v-4.31A9.06 9.06 0 0 0 18.4 21h6.32a2.03 2.03 0 0 0 1.94-2.5l-.13-.47A4 4 0 0 0 22.66 15h-6.88l-.5-2h6.38a4 4 0 0 0 3.87-3.03l.34-1.31C27.05 8.25 28 7.3 28 6V4Zm0 2H26c0 .57-.43 1-1 1h-9l-1 2h8.72l-.13.5c-.22.9-1.01 1.5-1.93 1.5h-6.38a2.03 2.03 0 0 0-1.94 2.5l.5 2a2 2 0 0 0 1.94 1.5h6.88c.92 0 1.71.6 1.93 1.5l.13.5H17.5l-.31.4s-1.44 2.05-4.38 2.63l-.81.16V26H6v-7.9c0-.54.14-1.08.4-1.54l5.32-9.06a3.01 3.01 0 0 1 2.6-1.5Z',
        'hand-lizard' => 'M14.31 4c-1.77 0-3.45.93-4.34 2.47l-5.28 9.1A5.06 5.06 0 0 0 4 18.08V28h10v-4.31A9.06 9.06 0 0 0 18.4 21h6.32a2.03 2.03 0 0 0 1.94-2.5l-.13-.47A4 4 0 0 0 22.66 15h-6.88l-.5-2h6.38a4 4 0 0 0 3.87-3.03l.34-1.31C27.05 8.25 28 7.3 28 6V4Zm0 2H26c0 .57-.43 1-1 1h-9l-1 2h8.72l-.13.5c-.22.9-1.01 1.5-1.93 1.5h-6.38a2.03 2.03 0 0 0-1.94 2.5l.5 2a2 2 0 0 0 1.94 1.5h6.88c.92 0 1.71.6 1.93 1.5l.13.5H17.5l-.31.4s-1.44 2.05-4.38 2.63l-.81.16V26H6v-7.9c0-.54.14-1.08.4-1.54l5.32-9.06a3.01 3.01 0 0 1 2.6-1.5Z',
        'hand-middle-finger-solid' => 'M16 2c-1.64 0-3 1.36-3 3v5.19a2.95 2.95 0 0 0-1-.19c-1.64 0-3 1.36-3 3v3.66l-2.1 2.68a4.43 4.43 0 0 0 .2 5.6l2.37 2.68A6.98 6.98 0 0 0 14.72 30H20a7 7 0 0 0 7-7v-9c0-1.64-1.36-3-3-3-.54 0-1.03.16-1.47.4A3 3 0 0 0 20 10c-.35 0-.68.07-1 .19V5c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v10h2v-2c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2v-1c0-.57.43-1 1-1 .57 0 1 .43 1 1v9c0 2.77-2.23 5-5 5h-5.28c-1.44 0-2.8-.6-3.75-1.69L8.59 23.6a2.34 2.34 0 0 1-.09-3l.5-.65V21h2v-8c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2V5c0-.57.43-1 1-1Z',
        'hand-paper-solid' => 'M16 2a3 3 0 0 0-2.88 2.25A2.94 2.94 0 0 0 12 4c-1.64 0-3 1.36-3 3v10.75l-.88-.88a3.02 3.02 0 0 0-4.24 0 3.02 3.02 0 0 0 0 4.25l6.78 6.79A6.73 6.73 0 0 0 15.37 30H20a7 7 0 0 0 7-7V11c0-1.64-1.36-3-3-3-.35 0-.68.07-1 .19V7c0-1.64-1.36-3-3-3-.4 0-.77.1-1.13.25A3 3 0 0 0 16 2Zm0 2c.57 0 1 .43 1 1v10h2V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2v-4c0-.57.43-1 1-1 .57 0 1 .43 1 1v12c0 2.77-2.23 5-5 5h-4.63a4.66 4.66 0 0 1-3.28-1.53l-6.8-6.75c-.4-.4-.4-1.04 0-1.44a1 1 0 0 1 1.43 0l2.56 2.6L11 22.59V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2V5c0-.57.43-1 1-1Z',
        'hand-paper' => 'M16 2a3 3 0 0 0-2.88 2.25A2.94 2.94 0 0 0 12 4c-1.64 0-3 1.36-3 3v10.75l-.88-.88a3.02 3.02 0 0 0-4.24 0 3.02 3.02 0 0 0 0 4.25l6.78 6.79A6.73 6.73 0 0 0 15.37 30H20a7 7 0 0 0 7-7V11c0-1.64-1.36-3-3-3-.35 0-.68.07-1 .19V7c0-1.64-1.36-3-3-3-.4 0-.77.1-1.13.25A3 3 0 0 0 16 2Zm0 2c.57 0 1 .43 1 1v10h2V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2v-4c0-.57.43-1 1-1 .57 0 1 .43 1 1v12c0 2.77-2.23 5-5 5h-4.63a4.66 4.66 0 0 1-3.28-1.53l-6.8-6.75c-.4-.4-.4-1.04 0-1.44a1 1 0 0 1 1.43 0l2.56 2.6L11 22.59V7c0-.57.43-1 1-1 .57 0 1 .43 1 1v8h2V5c0-.57.43-1 1-1Z',
        'hand-peace-solid' => 'M15 2c-1.64 0-3 1.36-3 3v1.53l-.13-.4a3.02 3.02 0 0 0-3.74-2 3.02 3.02 0 0 0-2 3.75l2.59 8.43c-.19.08-.4.16-.6.28a4.48 4.48 0 0 0-2.06 3.13c-.2 1.2.02 2.24.19 2.81v.03l.78 2.5A7 7 0 0 0 13.72 30H19a7 7 0 0 0 7-7V12.87l-.03-.09a3 3 0 0 0-1.84-2.56 2.97 2.97 0 0 0-2.25.03 3.01 3.01 0 0 0-1.54-1.4A2.99 2.99 0 0 0 18 8.9V5c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v6.6l-1.03 2.62c-.15.37-.22.77-.22 1.15l-4.1.54-2.59-8.63a.98.98 0 0 1 .66-1.25 1 1 0 0 1 1.25.69l2.06 6.84 1.13-.34H14V5c0-.57.43-1 1-1Zm4.19 6.63c.13 0 .27 0 .4.06a1 1 0 0 1 .57 1.31l-1.07 2.66v.03l-.4 1.03c-.02.05-.07.08-.1.12-.5-.4-1.14-.64-1.8-.65 0-.08 0-.15.02-.22l1.5-3.72c.16-.4.5-.62.88-.63ZM22.97 12a.98.98 0 0 1 1.03.96V13c0 .12-.02.25-.06.38l-1.13 2.78a1 1 0 0 1-1.31.56.99.99 0 0 1-.53-1.31l1.06-2.66c.02-.04.02-.09.03-.13a1 1 0 0 1 .53-.56.92.92 0 0 1 .38-.06Zm-6.47 5.16a.95.95 0 0 1 1.16.71c.07.33.03.5-.07.66-.1.17-.3.38-.75.53L12 20.31a1 1 0 0 0-.63 1.44l.91 1.66a1 1 0 0 0 1.36.39 1 1 0 0 0 .4-1.36l-.29-.5 3.69-.97.1-.03a3.25 3.25 0 0 0 1.77-1.38c.32-.52.44-1.14.38-1.75.29.32.67.58 1.1.75 1.14.46 2.4.17 3.21-.65V23c0 2.77-2.23 5-5 5h-5.28a5 5 0 0 1-4.78-3.53l-.75-2.5a5.2 5.2 0 0 1-.13-1.9c.19-1.08.66-1.5 1.1-1.76.43-.26.75-.28.75-.28h.06l6.44-.84.09-.03Z',
        'hand-peace' => 'M15 2c-1.64 0-3 1.36-3 3v1.53l-.13-.4a3.02 3.02 0 0 0-3.74-2 3.02 3.02 0 0 0-2 3.75l2.59 8.43c-.19.08-.4.16-.6.28a4.48 4.48 0 0 0-2.06 3.13c-.2 1.2.02 2.24.19 2.81v.03l.78 2.5A7 7 0 0 0 13.72 30H19a7 7 0 0 0 7-7V12.87l-.03-.09a3 3 0 0 0-1.84-2.56 2.97 2.97 0 0 0-2.25.03 3.01 3.01 0 0 0-1.54-1.4A2.99 2.99 0 0 0 18 8.9V5c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v6.6l-1.03 2.62c-.15.37-.22.77-.22 1.15l-4.1.54-2.59-8.63a.98.98 0 0 1 .66-1.25 1 1 0 0 1 1.25.69l2.06 6.84 1.13-.34H14V5c0-.57.43-1 1-1Zm4.19 6.63c.13 0 .27 0 .4.06a1 1 0 0 1 .57 1.31l-1.07 2.66v.03l-.4 1.03c-.02.05-.07.08-.1.12-.5-.4-1.14-.64-1.8-.65 0-.08 0-.15.02-.22l1.5-3.72c.16-.4.5-.62.88-.63ZM22.97 12a.98.98 0 0 1 1.03.96V13c0 .12-.02.25-.06.38l-1.13 2.78a1 1 0 0 1-1.31.56.99.99 0 0 1-.53-1.31l1.06-2.66c.02-.04.02-.09.03-.13a1 1 0 0 1 .53-.56.92.92 0 0 1 .38-.06Zm-6.47 5.16a.95.95 0 0 1 1.16.71c.07.33.03.5-.07.66-.1.17-.3.38-.75.53L12 20.31a1 1 0 0 0-.63 1.44l.91 1.66a1 1 0 0 0 1.36.39 1 1 0 0 0 .4-1.36l-.29-.5 3.69-.97.1-.03a3.25 3.25 0 0 0 1.77-1.38c.32-.52.44-1.14.38-1.75.29.32.67.58 1.1.75 1.14.46 2.4.17 3.21-.65V23c0 2.77-2.23 5-5 5h-5.28a5 5 0 0 1-4.78-3.53l-.75-2.5a5.2 5.2 0 0 1-.13-1.9c.19-1.08.66-1.5 1.1-1.76.43-.26.75-.28.75-.28h.06l6.44-.84.09-.03Z',
        'hand-point-down-solid' => 'M10 2v5.6l-6.72 6.78-.28.3v.41C3 16.71 4.23 18 5.66 18c1.33 0 2.32-.47 2.96-.94.4-.29.47-.42.63-.62l.75-.19V27c0 1.64 1.36 3 3 3s3-1.36 3-3v-3.56l7.63-1.66A3.02 3.02 0 0 0 26 18.84V2Zm2 2h12v3H12Zm-.6 5H24v9.84a1 1 0 0 1-.78 1l-8.44 1.79-.78.18V27c0 .57-.43 1-1 1-.57 0-1-.43-1-1V13.66l-1.25.3-2.25.6-.4.13-.2.34s-.08.18-.43.44-.91.53-1.81.53c-.31 0-.48-.17-.57-.6Z',
        'hand-point-down' => 'M10 2v5.6l-6.72 6.78-.28.3v.41C3 16.71 4.23 18 5.66 18c1.33 0 2.32-.47 2.96-.94.4-.29.47-.42.63-.62l.75-.19V27c0 1.64 1.36 3 3 3s3-1.36 3-3v-3.56l7.63-1.66A3.02 3.02 0 0 0 26 18.84V2Zm2 2h12v3H12Zm-.6 5H24v9.84a1 1 0 0 1-.78 1l-8.44 1.79-.78.18V27c0 .57-.43 1-1 1-.57 0-1-.43-1-1V13.66l-1.25.3-2.25.6-.4.13-.2.34s-.08.18-.43.44-.91.53-1.81.53c-.31 0-.48-.17-.57-.6Z',
        'hand-point-left-solid' => 'M16.9 3C15.3 3 14 4.23 14 5.66c0 1.33.47 2.32.94 2.96.29.4.42.47.62.63l.19.75H5c-1.64 0-3 1.36-3 3s1.36 3 3 3h3.56l1.66 7.63A3.02 3.02 0 0 0 13.16 26H30V10h-5.6l-6.77-6.72L17.3 3Zm-.3 2.1 6.4 6.3V24h-9.84a1 1 0 0 1-1-.78l-1.79-8.44-.18-.78H5c-.57 0-1-.43-1-1 0-.57.43-1 1-1h13.34l-.3-1.25-.6-2.25-.13-.4-.34-.2s-.18-.08-.44-.43A2.94 2.94 0 0 1 16 5.66c0-.31.17-.48.6-.57ZM25 12h3v12h-3Z',
        'hand-point-left' => 'M16.9 3C15.3 3 14 4.23 14 5.66c0 1.33.47 2.32.94 2.96.29.4.42.47.62.63l.19.75H5c-1.64 0-3 1.36-3 3s1.36 3 3 3h3.56l1.66 7.63A3.02 3.02 0 0 0 13.16 26H30V10h-5.6l-6.77-6.72L17.3 3Zm-.3 2.1 6.4 6.3V24h-9.84a1 1 0 0 1-1-.78l-1.79-8.44-.18-.78H5c-.57 0-1-.43-1-1 0-.57.43-1 1-1h13.34l-.3-1.25-.6-2.25-.13-.4-.34-.2s-.18-.08-.44-.43A2.94 2.94 0 0 1 16 5.66c0-.31.17-.48.6-.57ZM25 12h3v12h-3Z',
        'hand-point-right-solid' => 'm14.69 3-.31.28L7.58 10H2v16h16.84c1.41 0 2.64-1 2.94-2.38L23.44 16H27c1.64 0 3-1.36 3-3s-1.36-3-3-3H16.25l.19-.75c.2-.16.33-.22.62-.63.47-.64.94-1.63.94-2.96C18 4.23 16.71 3 15.1 3Zm.72 2.1c.42.08.59.25.59.56 0 .9-.27 1.46-.53 1.8-.26.36-.44.45-.44.45l-.34.18-.13.41-.6 2.25-.3 1.25H27c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-5.19l-.18.78-1.79 8.44a1 1 0 0 1-1 .78H9V11.4ZM4 12h3v12H4Z',
        'hand-point-right' => 'm14.69 3-.31.28L7.58 10H2v16h16.84c1.41 0 2.64-1 2.94-2.38L23.44 16H27c1.64 0 3-1.36 3-3s-1.36-3-3-3H16.25l.19-.75c.2-.16.33-.22.62-.63.47-.64.94-1.63.94-2.96C18 4.23 16.71 3 15.1 3Zm.72 2.1c.42.08.59.25.59.56 0 .9-.27 1.46-.53 1.8-.26.36-.44.45-.44.45l-.34.18-.13.41-.6 2.25-.3 1.25H27c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-5.19l-.18.78-1.79 8.44a1 1 0 0 1-1 .78H9V11.4ZM4 12h3v12H4Z',
        'hand-point-up-solid' => 'M13 2c-1.64 0-3 1.36-3 3v10.75l-.75-.19c-.16-.2-.22-.33-.63-.62A4.97 4.97 0 0 0 5.67 14C4.23 14 3 15.29 3 16.9v.41l.28.32L10 24.4V30h16V13.16c0-1.41-1-2.64-2.38-2.94L16 8.56V5c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v5.19l.78.19 8.44 1.78a1 1 0 0 1 .78 1V23H11.4l-6.3-6.4c.08-.43.25-.6.56-.6.9 0 1.46.27 1.8.53.36.26.45.44.45.44l.18.34.41.13 2.25.6 1.25.3V5c0-.57.43-1 1-1Zm-1 21h12v3H12Z',
        'hand-point-up' => 'M13 2c-1.64 0-3 1.36-3 3v10.75l-.75-.19c-.16-.2-.22-.33-.63-.62A4.97 4.97 0 0 0 5.67 14C4.23 14 3 15.29 3 16.9v.41l.28.32L10 24.4V30h16V13.16c0-1.41-1-2.64-2.38-2.94L16 8.56V5c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v5.19l.78.19 8.44 1.78a1 1 0 0 1 .78 1V23H11.4l-6.3-6.4c.08-.43.25-.6.56-.6.9 0 1.46.27 1.8.53.36.26.45.44.45.44l.18.34.41.13 2.25.6 1.25.3V5c0-.57.43-1 1-1Zm-1 21h12v3H12Z',
        'hand-pointer-solid' => 'M13 2c-1.64 0-3 1.36-3 3v11.81l-.66-.68-.25-.22a2.97 2.97 0 0 0-4.18 4.18v.04l8.18 8.09.07.03.03.06a8.3 8.3 0 0 0 5 1.69h1.72a8.17 8.17 0 0 0 8.18-8.19V14c0-1.64-1.35-3-3-3-.42 0-.82.12-1.18.28a2.98 2.98 0 0 0-4.9-1.5A2.98 2.98 0 0 0 16.99 9c-.35 0-.68.07-1 .19V5c0-1.64-1.36-3-3-3Zm0 2a1 1 0 0 1 1 1v11h2v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v4h2v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v4h2.1v-2a1 1 0 0 1 1-1 1 1 0 0 1 1 1v7.81A6.13 6.13 0 0 1 19.9 28h-1.7a6.22 6.22 0 0 1-3.78-1.31l-8.1-8c-.44-.45-.44-.93 0-1.38.45-.44.93-.44 1.38 0l4.3 4.32V5a1 1 0 0 1 1-1Z',
        'hand-pointer' => 'M13 2c-1.64 0-3 1.36-3 3v11.81l-.66-.68-.25-.22a2.97 2.97 0 0 0-4.18 4.18v.04l8.18 8.09.07.03.03.06a8.3 8.3 0 0 0 5 1.69h1.72a8.17 8.17 0 0 0 8.18-8.19V14c0-1.64-1.35-3-3-3-.42 0-.82.12-1.18.28a2.98 2.98 0 0 0-4.9-1.5A2.98 2.98 0 0 0 16.99 9c-.35 0-.68.07-1 .19V5c0-1.64-1.36-3-3-3Zm0 2a1 1 0 0 1 1 1v11h2v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v4h2v-4a1 1 0 0 1 1-1 1 1 0 0 1 1 1v4h2.1v-2a1 1 0 0 1 1-1 1 1 0 0 1 1 1v7.81A6.13 6.13 0 0 1 19.9 28h-1.7a6.22 6.22 0 0 1-3.78-1.31l-8.1-8c-.44-.45-.44-.93 0-1.38.45-.44.93-.44 1.38 0l4.3 4.32V5a1 1 0 0 1 1-1Z',
        'hand-rock-solid' => 'M15 6a3 3 0 0 0-2.53 1.4c-.44-.24-.93-.4-1.47-.4-1.64 0-3 1.36-3 3v3.66l-2.1 2.68a4.43 4.43 0 0 0 .2 5.6l2.37 2.68A6.98 6.98 0 0 0 13.72 27H19a7 7 0 0 0 7-7v-9c0-1.64-1.36-3-3-3-.54 0-1.03.16-1.47.4a2.95 2.95 0 0 0-4-1A3 3 0 0 0 15 6Zm0 2c.57 0 1 .43 1 1v3h2v-2c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2v-1c0-.57.43-1 1-1 .57 0 1 .43 1 1v9c0 2.77-2.23 5-5 5h-5.28c-1.44 0-2.8-.6-3.75-1.69L7.59 20.6a2.34 2.34 0 0 1-.09-3l.5-.65V18h2v-8c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2V9c0-.57.43-1 1-1Z',
        'hand-rock' => 'M15 6a3 3 0 0 0-2.53 1.4c-.44-.24-.93-.4-1.47-.4-1.64 0-3 1.36-3 3v3.66l-2.1 2.68a4.43 4.43 0 0 0 .2 5.6l2.37 2.68A6.98 6.98 0 0 0 13.72 27H19a7 7 0 0 0 7-7v-9c0-1.64-1.36-3-3-3-.54 0-1.03.16-1.47.4a2.95 2.95 0 0 0-4-1A3 3 0 0 0 15 6Zm0 2c.57 0 1 .43 1 1v3h2v-2c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2v-1c0-.57.43-1 1-1 .57 0 1 .43 1 1v9c0 2.77-2.23 5-5 5h-5.28c-1.44 0-2.8-.6-3.75-1.69L7.59 20.6a2.34 2.34 0 0 1-.09-3l.5-.65V18h2v-8c0-.57.43-1 1-1 .57 0 1 .43 1 1v2h2V9c0-.57.43-1 1-1Z',
        'hand-scissors-solid' => 'M11.4 6.97a6.37 6.37 0 0 0-1.93.28h-.03l-2.5.78A7 7 0 0 0 2 14.72V20a7 7 0 0 0 7 7h9.9a2.97 2.97 0 0 0 2.84-4.13 3.01 3.01 0 0 0 1.42-1.53c.3-.78.26-1.62-.07-2.34H27c1.64 0 3-1.36 3-3s-1.36-3-3-3h-1.53l.4-.13a3.02 3.02 0 0 0 2-3.74 3.02 3.02 0 0 0-3.75-2L15.7 9.71c-.08-.19-.16-.4-.28-.6a4.48 4.48 0 0 0-3.13-2.06c-.3-.05-.6-.09-.87-.1ZM25.13 9a1 1 0 0 1 .85.72 1 1 0 0 1-.69 1.25l-6.84 2.06.34 1.13V15H27c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-6.6l-2.62-1.03a2.94 2.94 0 0 0-1.16-.22l-.53-4.1 8.63-2.62a.97.97 0 0 1 .4-.03Zm-13.75.03c.2 0 .4 0 .57.03 1.07.19 1.49.66 1.75 1.1.26.43.28.75.28.75v.06l.84 6.44.03.09a.95.95 0 0 1-.71 1.16c-.33.07-.5.03-.66-.07-.17-.1-.38-.3-.53-.75L11.69 13a1 1 0 0 0-1.44-.63l-1.66.91a1 1 0 0 0-.39 1.36 1 1 0 0 0 1.36.4l.5-.29.97 3.69.03.1c.27.76.73 1.39 1.38 1.77.52.32 1.14.44 1.75.38-.32.29-.58.67-.75 1.1a2.97 2.97 0 0 0 .65 3.21H9c-2.77 0-5-2.23-5-5v-5.28a5 5 0 0 1 3.53-4.78l2.5-.75c.2-.06.77-.16 1.35-.16Zm5.44 8.75c.08.01.15 0 .22.03l3.72 1.5c.52.21.77.76.56 1.28a1 1 0 0 1-1.31.57l-3.72-1.47c-.05-.02-.08-.07-.12-.1.4-.5.64-1.14.65-1.8Zm-.62 4.13c.13 0 .27 0 .4.06l1.35.53 1.31.53.13.03a1 1 0 0 1 .56 1.32c-.15.38-.5.6-.88.62h-.03c-.13 0-.27-.01-.4-.06l-2.79-1.13a1 1 0 0 1-.56-1.31.92.92 0 0 1 .9-.6Z',
        'hand-scissors' => 'M11.4 6.97a6.37 6.37 0 0 0-1.93.28h-.03l-2.5.78A7 7 0 0 0 2 14.72V20a7 7 0 0 0 7 7h9.9a2.97 2.97 0 0 0 2.84-4.13 3.01 3.01 0 0 0 1.42-1.53c.3-.78.26-1.62-.07-2.34H27c1.64 0 3-1.36 3-3s-1.36-3-3-3h-1.53l.4-.13a3.02 3.02 0 0 0 2-3.74 3.02 3.02 0 0 0-3.75-2L15.7 9.71c-.08-.19-.16-.4-.28-.6a4.48 4.48 0 0 0-3.13-2.06c-.3-.05-.6-.09-.87-.1ZM25.13 9a1 1 0 0 1 .85.72 1 1 0 0 1-.69 1.25l-6.84 2.06.34 1.13V15H27c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-6.6l-2.62-1.03a2.94 2.94 0 0 0-1.16-.22l-.53-4.1 8.63-2.62a.97.97 0 0 1 .4-.03Zm-13.75.03c.2 0 .4 0 .57.03 1.07.19 1.49.66 1.75 1.1.26.43.28.75.28.75v.06l.84 6.44.03.09a.95.95 0 0 1-.71 1.16c-.33.07-.5.03-.66-.07-.17-.1-.38-.3-.53-.75L11.69 13a1 1 0 0 0-1.44-.63l-1.66.91a1 1 0 0 0-.39 1.36 1 1 0 0 0 1.36.4l.5-.29.97 3.69.03.1c.27.76.73 1.39 1.38 1.77.52.32 1.14.44 1.75.38-.32.29-.58.67-.75 1.1a2.97 2.97 0 0 0 .65 3.21H9c-2.77 0-5-2.23-5-5v-5.28a5 5 0 0 1 3.53-4.78l2.5-.75c.2-.06.77-.16 1.35-.16Zm5.44 8.75c.08.01.15 0 .22.03l3.72 1.5c.52.21.77.76.56 1.28a1 1 0 0 1-1.31.57l-3.72-1.47c-.05-.02-.08-.07-.12-.1.4-.5.64-1.14.65-1.8Zm-.62 4.13c.13 0 .27 0 .4.06l1.35.53 1.31.53.13.03a1 1 0 0 1 .56 1.32c-.15.38-.5.6-.88.62h-.03c-.13 0-.27-.01-.4-.06l-2.79-1.13a1 1 0 0 1-.56-1.31.92.92 0 0 1 .9-.6Z',
        'hand-spock-solid' => 'M12.4 2c-.19 0-.39.02-.59.06a3.05 3.05 0 0 0-2.34 2.81 3.03 3.03 0 0 0-3.4 3.63L8 16.9v.85l-.88-.88a3.02 3.02 0 0 0-4.25 0 3.02 3.02 0 0 0 0 4.25l6.79 6.79A6.73 6.73 0 0 0 14.37 30H19a7 7 0 0 0 7-7v-7l.94-4.72a3.03 3.03 0 0 0-3.38-3.56l.22-1.13a3.03 3.03 0 0 0-2.37-3.53 3 3 0 0 0-3.5 2.38l-1 4.75-1.54-5.85v-.03h-.03A3 3 0 0 0 12.41 2Zm-.15 2.03a.97.97 0 0 1 1.19.75v.03l2.5 9.6.19.75h1.78l.18-.82 1.75-8.5v-.03a1 1 0 0 1 1.2-.78c.55.11.88.63.77 1.19L20 15.34l1.97.38L23 10.53h.03c.11-.55.6-.92 1.16-.81.55.1.89.63.78 1.19l-.94 4.9-.03.1V23c0 2.77-2.23 5-5 5h-4.63a4.66 4.66 0 0 1-3.28-1.53l-6.8-6.75c-.4-.4-.4-1.04 0-1.44a1 1 0 0 1 1.43 0l2.56 2.6L10 22.59v-5.8l-.03-.1-1.94-8.63a1 1 0 0 1 .75-1.22 1 1 0 0 1 1.19.79l1.78 7.93 1.97-.44-1.78-7.96v-.04l-.44-1.9a.97.97 0 0 1 .75-1.19Z',
        'hand-spock' => 'M12.4 2c-.19 0-.39.02-.59.06a3.05 3.05 0 0 0-2.34 2.81 3.03 3.03 0 0 0-3.4 3.63L8 16.9v.85l-.88-.88a3.02 3.02 0 0 0-4.25 0 3.02 3.02 0 0 0 0 4.25l6.79 6.79A6.73 6.73 0 0 0 14.37 30H19a7 7 0 0 0 7-7v-7l.94-4.72a3.03 3.03 0 0 0-3.38-3.56l.22-1.13a3.03 3.03 0 0 0-2.37-3.53 3 3 0 0 0-3.5 2.38l-1 4.75-1.54-5.85v-.03h-.03A3 3 0 0 0 12.41 2Zm-.15 2.03a.97.97 0 0 1 1.19.75v.03l2.5 9.6.19.75h1.78l.18-.82 1.75-8.5v-.03a1 1 0 0 1 1.2-.78c.55.11.88.63.77 1.19L20 15.34l1.97.38L23 10.53h.03c.11-.55.6-.92 1.16-.81.55.1.89.63.78 1.19l-.94 4.9-.03.1V23c0 2.77-2.23 5-5 5h-4.63a4.66 4.66 0 0 1-3.28-1.53l-6.8-6.75c-.4-.4-.4-1.04 0-1.44a1 1 0 0 1 1.43 0l2.56 2.6L10 22.59v-5.8l-.03-.1-1.94-8.63a1 1 0 0 1 .75-1.22 1 1 0 0 1 1.19.79l1.78 7.93 1.97-.44-1.78-7.96v-.04l-.44-1.9a.97.97 0 0 1 .75-1.19Z',
        'hands-helping-solid' => 'm21 3.03-.66.72a11.16 11.16 0 0 1-3.68 2.81c-1.01.48-1.86.62-2.7 1.25a7.4 7.4 0 0 0-2.71 4.32c-1.16.25-2.02.7-2.69 1.28-.66.57-1.16 1.22-1.78 1.93v.04c-.88 1.01-1.66 2.1-3.16 2.68l-.62.25V29h19.06c1.1-.06 1.85-.82 2.32-1.56a6.7 6.7 0 0 0 .84-2.22c.33-1.7.94-6.56.94-6.56l.03-.1v-.1a3.53 3.53 0 0 0-.66-1.77l1.13-3.35 1.78-2.68.5-.72-.66-.6-6.56-5.68Zm.06 2.75 5.22 4.53-1.37 2.03-.1.1-.03.15-.9 2.7c-.48-.2-.97-.34-1.5-.32h-.07L16 15h-1v3.88c-.14 1.08-.75 1.5-1.5 1.8-.25.1-.28.05-.5.1v-5.81c-.16-3.7 1.16-4.77 2.19-5.56.28-.22 1.12-.48 2.31-1.04 1-.46 2.23-1.3 3.56-2.59Zm-10 8.6c0 .22-.07.38-.06.62v8h1s1.07-.01 2.22-.47a4.3 4.3 0 0 0 2.78-3.4V17l5.38-.03h.03c.92-.05 1.68.65 1.75 1.56l-.07.47H20v2h3.84c-.1.77-.2 1.26-.3 2H20v2h3.22a5 5 0 0 1-.56 1.38c-.28.44-.51.6-.72.62H5v-7.47c1.62-.86 2.63-2.1 3.28-2.84.68-.78 1.14-1.36 1.6-1.75.3-.26.76-.4 1.18-.56Z',
        'hands-solid' => 'M3 5v11.4l.28.32L9 22.44V28h6v-6c0-.05.15-3.16-2.44-4.81v-.03h-.03c-1.18-.78-2.4-1.4-3.25-2.07C8.43 14.43 8 13.9 8 13H6a4.7 4.7 0 0 0 2.03 3.69c1.09.84 2.35 1.46 3.4 2.15h.04c1.6 1 1.53 3.13 1.53 3.13V26h-2v-4.4l-.28-.32L5 15.56V5H3zm24 0v10.56l-5.72 5.72-.28.31V26h-2v-4.06s-.07-2.1 1.53-3.1h.03c1.06-.69 2.32-1.3 3.4-2.15A4.7 4.7 0 0 0 26 13h-2c0 .89-.43 1.43-1.28 2.1-.85.65-2.07 1.28-3.25 2.06h-.03v.03C16.87 18.83 17 21.89 17 22v6h6v-5.56l5.72-5.72.28-.31V5h-2z',
        'handshake-solid' => 'M19.31 6.97a6.03 6.03 0 0 0-3.47 1 6.1 6.1 0 0 0-2.21-.9c-.89-.12-1.7-.06-2.66-.04-1.13.02-1.87.6-3.06 1.06C6.7 8.55 5.17 9 3 9H2v9.63l.56.28 1.85.9 6.56 7.32.03.03c.75.74 1.76.92 2.66.87.9-.05 1.73-.31 2.4-.72 1.48-.89 5.5-3.68 5.5-3.68l.1-.07.06-.06c.48-.47.71-1.05.87-1.66l3.85-1.93 2.87-.97.69-.22V9h-1c-2.17 0-3.71-.47-4.9-.94-1.2-.47-1.93-1.04-3.07-1.06-.6-.01-1.16-.04-1.72-.03Zm.03 2 1.63.03c.1 0 1.07.41 2.4.94 1.14.44 2.71.84 4.63.97v6.37l-2.31.78h-.07l-.06.03-3.03 1.54c-.17-.46-.4-.88-.75-1.25l-.06-.1-4.25-5.22-.63-.78-.78.63-2.68 2.18c-.9.63-1.64.45-2.38.1-.21-.1-.2-.14-.38-.25l4.57-3.78.06-.07c1.36-1.34 2.19-1.8 2.9-2 .37-.1.74-.12 1.2-.12ZM12.38 9c.38 0 .7 0 1 .03.26.03.55.26.8.35l-.27.24-.07.07-5.46 4.53-.85.69.75.78s.72.78 1.85 1.31c1.12.53 2.85.83 4.4-.25l.06-.06 1.94-1.6 3.69 4.54.03.06.03.03c.66.65.65 1.68 0 2.34v.03l-.16.1-1.3-1.78-1.63 1.18 1.28 1.72c-.52.35-.76.54-1.31.9l-1.35-1.8-1.62 1.18 1.28 1.72-.44.28c-.32.2-.92.41-1.47.44-.5.03-.9-.09-1.1-.25l-.02-.03-6.69-7.4-.13-.16L4 17.37v-6.46c1.91-.13 3.5-.5 4.63-.94 1.33-.51 2.28-.93 2.4-.94L12.38 9Z',
        'handshake' => 'M19.31 6.97a6.03 6.03 0 0 0-3.47 1 6.1 6.1 0 0 0-2.21-.9c-.89-.12-1.7-.06-2.66-.04-1.13.02-1.87.6-3.06 1.06C6.7 8.55 5.17 9 3 9H2v9.63l.56.28 1.85.9 6.56 7.32.03.03c.75.74 1.76.92 2.66.87.9-.05 1.73-.31 2.4-.72 1.48-.89 5.5-3.68 5.5-3.68l.1-.07.06-.06c.48-.47.71-1.05.87-1.66l3.85-1.93 2.87-.97.69-.22V9h-1c-2.17 0-3.71-.47-4.9-.94-1.2-.47-1.93-1.04-3.07-1.06-.6-.01-1.16-.04-1.72-.03Zm.03 2 1.63.03c.1 0 1.07.41 2.4.94 1.14.44 2.71.84 4.63.97v6.37l-2.31.78h-.07l-.06.03-3.03 1.54c-.17-.46-.4-.88-.75-1.25l-.06-.1-4.25-5.22-.63-.78-.78.63-2.68 2.18c-.9.63-1.64.45-2.38.1-.21-.1-.2-.14-.38-.25l4.57-3.78.06-.07c1.36-1.34 2.19-1.8 2.9-2 .37-.1.74-.12 1.2-.12ZM12.38 9c.38 0 .7 0 1 .03.26.03.55.26.8.35l-.27.24-.07.07-5.46 4.53-.85.69.75.78s.72.78 1.85 1.31c1.12.53 2.85.83 4.4-.25l.06-.06 1.94-1.6 3.69 4.54.03.06.03.03c.66.65.65 1.68 0 2.34v.03l-.16.1-1.3-1.78-1.63 1.18 1.28 1.72c-.52.35-.76.54-1.31.9l-1.35-1.8-1.62 1.18 1.28 1.72-.44.28c-.32.2-.92.41-1.47.44-.5.03-.9-.09-1.1-.25l-.02-.03-6.69-7.4-.13-.16L4 17.37v-6.46c1.91-.13 3.5-.5 4.63-.94 1.33-.51 2.28-.93 2.4-.94L12.38 9Z',
        'hanukiah-solid' => 'M16 4s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm-3 1s-1 2.06-1 3a1 1 0 0 0 2 0c0-.98-1-3-1-3Zm6 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm-9 1S9 8.06 9 9a1 1 0 0 0 2 0c0-.98-1-3-1-3Zm12 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3ZM7 7s-1 2.06-1 3a1 1 0 0 0 2 0c0-.98-1-3-1-3Zm18 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3ZM4 8s-1 2.06-1 3a1 1 0 0 0 2 0c0-.98-1-3-1-3Zm24 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3ZM15 9v9h-.03a.94.94 0 0 1-.97-.97V10h-2v7.03c0 .34.05.67.16.97h-.2a.95.95 0 0 1-.96-.97V11H9v6.03c0 .34.08.67.19.97h-.13C8.46 18 8 17.53 8 16.94V12H6v4.94c0 .37.1.73.22 1.06h-.19C5.45 18 5 17.55 5 16.97V13H3v3.97A3.05 3.05 0 0 0 6.03 20H15v6h-5v2h12v-2h-5v-6h8.97A3.05 3.05 0 0 0 29 16.97V13h-2v3.97c0 .58-.45 1.03-1.03 1.03h-.19c.13-.33.22-.69.22-1.06V12h-2v4.94c0 .6-.47 1.06-1.06 1.06h-.13c.1-.3.19-.63.19-.97V11h-2v6.03c0 .55-.42.97-.97.97h-.19c.1-.3.16-.63.16-.97V10h-2v7.03c0 .56-.41.97-.97.97H17V9Z',
        'hard-hat-solid' => 'M13 7v1.4a11.92 11.92 0 0 0-8.88 10.97C2.96 19.8 2 20.7 2 22v3h28v-3c0-1.3-.95-2.21-2.13-2.63A11.92 11.92 0 0 0 19 8.41V7Zm2.03 2H17a.97.97 0 0 0 0 .34V15h2v-4.5a10 10 0 0 1 6.97 8.5H24v2h3c.57 0 1 .43 1 1v1H4v-1c0-.57.43-1 1-1h3v-2H6.03A10 10 0 0 1 13 10.5V15h2V9.5c.05-.16.06-.33.03-.5Z',
        'hashtag-solid' => 'M11 5v6H5v2h6v6H5v2h6v6h2v-6h6v6h2v-6h6v-2h-6v-6h6v-2h-6V5h-2v6h-6V5Zm2 8h6v6h-6Z',
        'hat-cowboy-side-solid' => 'M19.21 7.01c-.26 0-.52 0-.79.05-.68.1-1.33.35-1.99.57-.66.2-1.31.37-1.8.37H13.2c-.57 0-1.11.01-1.59.1-.85.15-1.58.53-2.1 1.1a3.92 3.92 0 0 0-.9 2 1 1 0 0 0-.01.02L8 15.04c-3.15.17-5.42 2.1-6.66 4.7-.54 1.14-.4 2.4.2 3.32a4.3 4.3 0 0 0 2.72 1.8c8.18 1.76 15.18 1.22 22.8.14a1 1 0 0 0 .01 0 1 1 0 0 0 .01 0 1 1 0 0 0 .05 0l.02-.01a1 1 0 0 0 .02 0 1 1 0 0 0 .28-.1 4.61 4.61 0 0 0 2.82-1.54c.6-.8.74-1.69.74-2.37 0-3.4-2.62-7.5-7.45-8.8l-.58-2.27a1 1 0 0 0 0-.02A3.97 3.97 0 0 0 19.2 7zm-.02 1.98c1.02-.01 1.59.52 1.85 1.43l.69 2.69a1 1 0 0 0 .07.27l.16.63a1 1 0 0 0 .02.08c.11.4-.24 1.2-.71 1.48-.29.17-1.4.59-2.7.9-1.21.28-2.63.5-3.93.52A9.98 9.98 0 0 0 10 15.1l.56-3.56c.09-.48.23-.79.42-1 .2-.22.46-.38.98-.47.17-.03.72-.07 1.25-.07h1.42c.88 0 1.7-.24 2.41-.47.72-.23 1.36-.45 1.68-.5l.47-.04zm4.96 5.5c3.23 1.37 4.85 4.39 4.85 6.5 0 .4-.08.81-.34 1.15-.25.33-.73.68-1.8.86-3.01.21-4.95-.32-6.47-1.2a11.1 11.1 0 0 0 3.13-1.11 2.96 2.96 0 0 0 1.37-3.33l-.74-2.87zm-1.42 2.5.23.89a1 1 0 0 0 0 .01.92.92 0 0 1-.45 1.07c-.67.4-2.64 1.04-4.37 1.12l-.54-.5-.8-.76c.77-.1 1.53-.25 2.23-.41a12.5 12.5 0 0 0 3.25-1.12c.16-.09.3-.2.45-.3zM8.45 17c2.37 0 3.86.67 5.17 1.66a1 1 0 0 0 .3.23c.77.63 1.49 1.36 2.3 2.13.25.24.5.48.78.71a1 1 0 0 0 .33.26c.74.6 1.55 1.17 2.48 1.66-4.9.37-9.77.4-15.13-.75a2.36 2.36 0 0 1-1.48-.93c-.26-.4-.33-.8-.06-1.37C4.2 18.36 5.8 17 8.44 17z',
        'hat-cowboy-solid' => 'M14 6c-.9 0-1.56.5-2.16 1.16a5.74 5.74 0 0 0-1.3 2.59v.03c-.27 1-.64 2.73-.95 4.22A3.95 3.95 0 0 0 3 17c0 2.1.54 4.48 2.53 6.22C7.52 24.96 10.77 26 16 26c5.24 0 8.52-1.06 10.5-2.81C28.48 21.43 29 19.06 29 17a4 4 0 0 0-6.6-3.03l-.02-.03h-.04l-.87-4.16a5.69 5.69 0 0 0-1.34-2.69C19.52 6.44 18.86 6 18 6c-.82 0-1.35.42-1.72.69L16 6.9l-.28-.22C15.35 6.42 14.82 6 14 6Zm0 2c-.02 0 .22.08.53.31l.53.38c.22.13.48.31.94.31.46 0 .72-.18.94-.31l.53-.38c.3-.23.55-.31.53-.31-.06 0 .3.1.66.47.34.37.7.98.87 1.75l1.03 4.81-.15.1c-.68.39-2 .87-4.41.87-2.42 0-3.73-.48-4.4-.88l-.2-.12c.35-1.66.78-3.66 1.07-4.75v-.03c.16-.72.52-1.33.87-1.72.36-.4.76-.5.66-.5Zm-7 7c1.16 0 1.96.77 2 1.9v.04c-.04.18-.03.38.03.56l.03.1a4.44 4.44 0 0 0 2.63 3.8c1.46.62 3.06.6 4.31.6 1.28 0 2.9-.02 4.34-.66a4.52 4.52 0 0 0 2.63-3.9c.04-.14.05-.3.03-.44v-.16c.07-1.1.86-1.84 2-1.84 1.2 0 2 .8 2 2 0 1.74-.38 3.4-1.84 4.69C23.69 22.98 20.96 24 16 24s-7.7-1-9.16-2.28C5.38 20.44 5 18.8 5 17c0-1.2.8-2 2-2Zm4 2.06c1.06.52 2.62.94 5 .94s3.94-.42 5-.94c-.02 1.55-.56 2.04-1.47 2.44-.92.41-2.3.5-3.53.5-1.25 0-2.65-.02-3.56-.4-.9-.39-1.43-.88-1.44-2.54Z',
        'hat-wizard-solid' => 'M16 28c-6.2 0-8.46-2.05-8.7-2.29l-.48-.46L15.32 4h7.62l-4.73 3.36 6.96 17.89-.47.46c-.24.24-2.5 2.29-8.7 2.29Zm-6.78-3.36c.88.5 2.96 1.36 6.78 1.36 3.83 0 5.9-.86 6.78-1.37L16.1 7.45ZM18 24a3 3 0 1 1 .75-5.9 4 4 0 1 0 0 5.8c-.24.06-.49.1-.75.1Zm-2-11a1 1 0 0 1 0 2 1 1 0 0 1 0-2Zm3 7a1 1 0 0 1 0 2 1 1 0 0 1 0-2Z',
        'haykal-solid' => 'M16 3a.9.9 0 0 0-.88.65l-1.73 5.44-4.63-2.7a.92.92 0 0 0-.5-.14.94.94 0 0 0-.86 1.3l2 4.95-5.59.78c-.89.13-1.1 1.34-.3 1.76l4.98 2.68-4.15 4.3a.93.93 0 0 0 .67 1.56c.07 0 .14 0 .2-.02l6.01-1.25-.2 5.71c-.03.6.44.98.93.98a.9.9 0 0 0 .72-.37L16 24.12l3.34 4.51c.2.26.46.37.72.37.49 0 .96-.38.94-.98l-.21-5.71 6.04 1.25c.07.02.14.02.2.02a.94.94 0 0 0 .68-1.57l-4.19-4.3 4.99-2.67c.8-.42.58-1.63-.31-1.75l-5.59-.79 1.99-4.95a.94.94 0 0 0-.86-1.3.91.91 0 0 0-.5.15l-4.63 2.7-1.73-5.45A.91.91 0 0 0 16 3zm0 7.87.86 2.7L19.57 12l-1.19 2.97 3.12.43-2.97 1.6 2.15 2.2-2.93-.61.11 3.02L16 19.18l-1.86 2.43.11-3.03-2.94.63 2.14-2.22-2.95-1.58 3.12-.44-1.2-2.97 2.72 1.58.86-2.71z',
        'hdd-solid' => 'M6.22 6 3 18.88V26h26v-7.13L25.78 6Zm1.56 2h16.44l2.5 10H5.28ZM5 20h22v4H5Zm19 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'hdd' => 'M6.22 6 3 18.88V26h26v-7.13L25.78 6Zm1.56 2h16.44l2.5 10H5.28ZM5 20h22v4H5Zm19 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'heading-solid' => 'M6 5v2h1v18H6v2h8v-2h-1v-6h6v6h-1v2h8v-2h-1V7h1V5h-8v2h1v6h-6V7h1V5Zm3 2h2v8h10V7h2v18h-2v-8H11v8H9Z',
        'headphones-alt-solid' => 'M16 5C9.94 5 5 9.94 5 16v8c0 1.64 1.36 3 3 3h3v-9H7v-2a8.99 8.99 0 1 1 18 0v2h-4v9h3c1.64 0 3-1.36 3-3v-8c0-6.06-4.94-11-11-11ZM7 20h2v5H8c-.57 0-1-.43-1-1Zm16 0h2v4c0 .57-.43 1-1 1h-1Z',
        'headphones-solid' => 'M16 5C9.94 5 5 9.94 5 16v8c0 1.64 1.36 3 3 3h3v-9H7v-2a8.99 8.99 0 1 1 18 0v2h-4v9h3c1.64 0 3-1.36 3-3v-8c0-6.06-4.94-11-11-11ZM7 20h2v5H8c-.57 0-1-.43-1-1Zm16 0h2v4c0 .57-.43 1-1 1h-1Z',
        'headset-solid' => 'M16 3C9.95 3 5 7.95 5 14v6c0 1.3.84 2.4 2 2.81V23c0 2.75 2.25 5 5 5h1.28c.35.6.98 1 1.72 1h2a2 2 0 0 0 0-4h-2c-.74 0-1.37.4-1.72 1H12a3 3 0 0 1-3-3h2v-9H7c0-4.95 4.05-9 9-9s9 4.05 9 9h-4v9h3c1.64 0 3-1.36 3-3v-6c0-6.05-4.95-11-11-11ZM7 16h2v5H8a1 1 0 0 1-1-1Zm16 0h2v4a1 1 0 0 1-1 1h-1Z',
        'heart-broken-solid' => 'M9.5 4C5.36 4 2 7.4 2 11.5c0 1.43.65 2.65 1.25 3.55.6.9 1.21 1.5 1.21 1.5L16 28.07l11.54-11.54S30 14.36 30 11.5C30 7.4 26.64 4 22.5 4c-1.57 0-2.97.52-4.1 1.15l-.34.18L16 11h3.63L16 17.21V13h-3.55L14 5.36 13.33 5A8.37 8.37 0 0 0 9.5 4zm0 2c.78 0 1.5.3 2.2.6L10 15h4v6h2.1L22 10.9V9h-3.14l.79-2.18A6.4 6.4 0 0 1 22.5 6c3.04 0 5.5 2.5 5.5 5.5 0 1.54-1.87 3.62-1.87 3.62L16 25.25 5.87 15.12s-.47-.46-.96-1.18A4.88 4.88 0 0 1 4 11.5C4 8.5 6.46 6 9.5 6z',
        'heart-solid' => 'M22.5 5c-2.9 0-5.33 1.8-6.5 2.85C14.83 6.8 12.4 5 9.5 5A7.5 7.5 0 0 0 2 12.5c0 2.59 2.37 4.95 2.46 5.04L16 29.08l11.53-11.53c.1-.1 2.47-2.46 2.47-5.05A7.5 7.5 0 0 0 22.5 5z',
        'heart' => 'M9.5 5C5.36 5 2 8.4 2 12.5a6.5 6.5 0 0 0 1.25 3.56c.6.9 1.22 1.47 1.22 1.47l10.81 10.84.72.72.72-.71 10.81-10.85S30 15.36 30 12.5C30 8.4 26.64 5 22.5 5A9.12 9.12 0 0 0 16 7.94 9.12 9.12 0 0 0 9.5 5Zm0 2c2.99 0 5.75 2.9 5.75 2.9l.75.85.75-.84S19.51 7 22.5 7c3.04 0 5.5 2.5 5.5 5.5 0 1.54-1.88 3.63-1.88 3.63L16 26.24 5.87 16.12s-.48-.46-.96-1.18A4.86 4.86 0 0 1 4 12.5C4 9.5 6.46 7 9.5 7Z',
        'heartbeat-solid' => 'M10.78 5C6.5 5 3 8.3 3 12.36c0 .22.02.43.04.64h2a6.88 6.88 0 0 1-.04-.64C5 9.4 7.6 7 10.78 7a6 6 0 0 1 3.92 1.42L16 9.53l1.3-1.11A6 6 0 0 1 21.22 7C24.4 7 27 9.4 27 12.36c0 5.12-4.82 8.16-8.7 10.6-.89.55-1.67 1.04-2.3 1.5-.63-.46-1.41-.95-2.3-1.5A34.8 34.8 0 0 1 8.25 19H5.53c1.98 2.41 4.79 4.19 7.11 5.65A30.6 30.6 0 0 1 16 27l.95-.75c.6-.46 1.43-.99 2.4-1.6C23.44 22.1 29 18.6 29 12.35 29 8.3 25.5 5 21.22 5A8 8 0 0 0 16 6.9 8.01 8.01 0 0 0 10.78 5Zm1.19 4.39-2.34 5.83-.22-.22H3v2h5.59l1.77 1.78 1.67-4.17 3 7 2.07-5.17.28.56h1.89a2 2 0 1 0 0-2h-.65l-1.72-3.44-1.93 4.83Z',
        'helicopter-solid' => 'M18 6v4.06a8.52 8.52 0 0 0-4.22 1.4c-.56.41-.96.86-1.25 1.26-.07.09-.07.2-.12.28H5.8A3.01 3.01 0 0 0 3 11c-1.64 0-3 1.36-3 3s1.36 3 3 3c1.3 0 2.4-.84 2.81-2H14v-.84a.8.8 0 0 1 .13-.29c.15-.2.42-.5.8-.78A6.88 6.88 0 0 1 19 12c.45 0 .91.16 1.38.22-.53.85-.7 1.92-.7 3.56 0 .73.26 1.47.79 2 .53.54 1.3.84 2.16.84 2.01 0 3.34-.07 4.34-.25.08-.01.1-.07.19-.09-.05.08-.04.22-.1.28a2.8 2.8 0 0 1-1.25.85c-1.15.45-2.9.59-4.65.59h-4.94A2.21 2.21 0 0 1 14 17.78V16h-2v1.78C12 20.1 13.9 22 16.22 22h4.94c1.82 0 3.75-.09 5.37-.72a5 5 0 0 0 2.13-1.5c.55-.7.84-1.62.84-2.66 0-2.17-1.57-3.93-3.56-5.15-.76-.47-1.65-.78-2.53-1.1-1.1-.39-2.25-.69-3.41-.8V6ZM7 7v2h10V7Zm14 0v2h10V7Zm2.06 5.9c.63.25 1.28.46 1.82.79a5.31 5.31 0 0 1 2.28 2.5c-.16.07-.17.15-.54.22-.75.13-2.02.21-4 .21-.4 0-.62-.11-.75-.25-.12-.13-.18-.32-.18-.59 0-1.7.22-2.47.37-2.65.08-.1.15-.14.35-.2.13-.03.4-.01.65-.02ZM3 13c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm25 9c0 .57-.43 1-1 1H11v2h16c1.64 0 3-1.36 3-3Z',
        'highlighter-solid' => 'm23.63 3.06-.72.63L7.56 17l-.5.47.25.66s1.13 3-1.03 5.15v.03l-.03.03-.16.2-.12.12L2 27.53 7.38 29l2.06-2.06.22-.19.03-.03h.03c2.15-2.16 5.15-1.03 5.15-1.03l.66.25.47-.5 13.31-15.35.63-.71Zm-.13 2.75 3.69 3.69-8.75 10.06-5-5ZM11.94 15.88l5.19 5.18-1.94 2.25-5.5-5.5ZM9.56 20.5l2.94 2.94a6.1 6.1 0 0 0-4.16 1.81l-.06.03-.25.22-.53-.53.22-.25.03-.06a6.1 6.1 0 0 0 1.81-4.16Z',
        'hiking-solid' => 'M16.5 4A3.51 3.51 0 0 0 13 7.5c0 1.92 1.58 3.5 3.5 3.5S20 9.42 20 7.5 18.42 4 16.5 4Zm0 2c.84 0 1.5.66 1.5 1.5S17.34 9 16.5 9 15 8.34 15 7.5 15.66 6 16.5 6Zm-5.4 4.5a3.05 3.05 0 0 0-2.25.72c-.88.74-1.39 1.92-1.76 3.66-.11.55-.08 1.13.2 1.59.26.46.68.73 1.05.9.75.35 1.48.42 1.88.5l.47-1.93c-.6-.14-1.22-.25-1.5-.38-.14-.06-.16-.1-.16-.1a.4.4 0 0 1 0-.18c.32-1.51.79-2.24 1.13-2.53.34-.29.62-.33 1.25-.19l.43-1.97a4.52 4.52 0 0 0-.75-.09Zm1.74.31-1.46 6.69c-.17.75.14 1.56.74 2.03l3.54 2.75.87 5.72h2.03l-.93-6.03a2 2 0 0 0-.75-1.28l-3.54-2.75 1.04-4.66 1.03.28 1.78 1.72a2 2 0 0 0 2.18.38l1.63-.7V28h2V11h-2v1.81l-2.4 1.03-1.79-1.71a1.99 1.99 0 0 0-.87-.5Zm-1.3 9.81-.85 2.54L8.19 28h2.25l2.03-3.9c.05-.1.1-.22.12-.32l.63-1.84Z',
        'hippo-solid' => 'M16.16 4c-.22 0-.44 0-.66.04A3.09 3.09 0 0 0 13 7.1V9H9.14c-3.78 0-6.88 3.13-7.12 7.07L2 16l-1 5 1.3-1.3c.2 1.23.45 2.53.73 3.54L4.22 28H9v-3.45c.74.25 1.63.45 2.5.45a8.3 8.3 0 0 0 2.5-.4V28h4.78l1.16-4.67c.04-.1.76-2.2 1.01-6.33H26a4 4 0 0 0 4-4v-2.18A3.67 3.67 0 0 0 26.15 7a6.4 6.4 0 0 0-2.92.67A5.64 5.64 0 0 0 19 6h-.17a3 3 0 0 0-2.67-2zm-.34 2.01A1 1 0 0 1 17 7v1h2c2.3 0 3.08 1.4 3.1 1.45l.59 1.13.97-.83a4 4 0 0 1 2.5-.75C27.3 9 28 9.68 28 10.82V13a2 2 0 0 1-2 2h-6.96l-.04.96c-.17 4.42-.94 6.7-.97 6.8L17.22 26H16v-5l-1.6 1.2c-1.01.76-2.6.8-2.9.8a6.45 6.45 0 0 1-2.9-.8L7 21v5H5.78l-.82-3.26c-.5-1.87-.96-4.81-.96-6.18C4 13.5 6.3 11 9.14 11H15V7.1c0-.53.36-1.01.82-1.09zM20 9a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'hips' => 'M11.48 7c-.8 0-1.44.67-1.44 1.49 0 .8.63 1.49 1.44 1.49.8 0 1.45-.68 1.45-1.49 0-.84-.65-1.49-1.45-1.49zM.25 7.26c-.09 0-.13.04-.13.14v14.39c0 .1.04.15.13.15H2.3c.1 0 .14-.05.14-.15v-7.01c0-.05-.14-1.4 2.3-1.4 2.42 0 2.28 1.35 2.28 1.4v6.32c0 .46.37.84.82.84h1.37c.1 0 .13-.05.13-.15v-7.01c0-1.21-.46-2.16-1.4-2.86a4.9 4.9 0 0 0-3-.92 5.22 5.22 0 0 0-2.5.58V7.4c0-.1-.05-.14-.14-.14H.25zM18.88 11c-1.56 0-5.12 1.01-5.12 5.23v9.3c0 .04.03.13.13.13h2.01c.1 0 .14-.04.14-.14v-4.48c.8.63 1.76.96 2.83.96a5.4 5.4 0 0 0 5.34-5.5 5.4 5.4 0 0 0-5.33-5.5zm9.72 0c-1.3 0-2.22.29-2.87.78-.02.02-1.4 1-1.11 2.71.17 1 .77 1.73 1.82 2.21l2.63 1.19c.57.25.75.67.6 1.07-.18.46-.65.68-1.8.68a4.8 4.8 0 0 1-2.86-.96c-.1-.06-.21.01-.21.12v1.74c0 .53.24.87.71 1.05a6.94 6.94 0 0 0 4.15.2c.03-.03 1.77-.46 2.24-2.32.17-.69.12-1.35-.16-1.98a3.2 3.2 0 0 0-1.7-1.73l-2.83-1.28c-.42-.18-.45-.57-.13-.81.37-.29 2.17-.7 4.12.34.08.05.2-.02.2-.12v-2.26c0-.07-.03-.11-.1-.13a7.44 7.44 0 0 0-2.7-.5zm-18.14.24c-.08 0-.13.08-.13.15v10.4c0 .08.05.15.13.15h2.05c.09 0 .14-.05.14-.15v-10.4c0-.1-.05-.15-.14-.15h-2.05zm8.42 2.1a3.1 3.1 0 0 1 3.05 3.16 3.09 3.09 0 0 1-3.05 3.15c-.84 0-1.57-.31-2.16-.92-.6-.62-.9-1.36-.9-2.23a3.1 3.1 0 0 1 3.06-3.15z',
        'hire-a-helper' => 'm7.91 5-.1.9A2.2 2.2 0 0 1 5.9 7.8l-.9.1v16.29l.87.11c1.02.14 1.79.87 1.95 1.86l.14.84h16.31l.07-.92c.08-.93.84-1.7 1.77-1.81l.89-.1V7.95l-.84-.14A2.2 2.2 0 0 1 24.3 5.9l-.1-.9H7.92zm1.7 2h12.9A4.22 4.22 0 0 0 25 9.56V22.5a4.1 4.1 0 0 0-2.46 2.5H9.57A4.22 4.22 0 0 0 7 22.53V9.6A4.2 4.2 0 0 0 9.6 7zm.67 3c-.2 0-.38.39-.04.47.63.17 1.1.42 1.1 1.31v4.08c0 3.36 0 4.63-.3 5.15-.32.41-.45.42-.84.55-.22 0-.3.44 0 .44 1.4 0 .73-.08 2.13-.08 1.38 0 .8.08 2.17.08.23 0 .19-.33 0-.4-.88-.3-.89-.4-.95-.51-.4-.63-.23-3.4-.23-4.61 0-.22.25-.52.53-.52h4.3c.28 0 .53.3.53.52 0 1.2.18 3.98-.23 4.61-.06.1-.07.2-.95.52-.19.06-.22.39 0 .39 1.36 0 .79-.08 2.17-.08 1.4 0 .73.08 2.13.08.3 0 .22-.44 0-.44-.4-.13-.52-.14-.84-.55-.3-.52-.3-1.79-.3-5.15v-4.08c0-.89.47-1.14 1.1-1.3.35-.1.15-.48-.04-.48-1.4 0-.8.08-2.2.08-1.27 0-.64-.08-1.9-.08-.13 0-.33.33-.04.44.19.06 1.06.14 1.06 1.58 0 1.84.01 2.19-.03 2.71 0 .05-.1.52-.5.52h-4.22c-.4 0-.5-.47-.5-.52-.04-.52-.03-.87-.03-2.71 0-1.44.87-1.52 1.06-1.58.3-.1.1-.44-.04-.44-1.26 0-.63.08-1.9.08-1.4 0-.8-.08-2.2-.08z',
        'history-solid' => 'M16 4C11.83 4 8.15 6.11 6 9.34V6H4v7h7v-2H7.37A9.98 9.98 0 0 1 26 16c0 5.54-4.46 10-10 10S6 21.54 6 16H4a12.01 12.01 0 0 0 24 0c0-6.62-5.38-12-12-12Zm-1 4v9h7v-2h-5V8Z',
        'hockey-puck-solid' => 'M16 7C9.04 7 2 8.72 2 12v8c0 3.28 7.04 5 14 5s14-1.72 14-5v-8c0-3.28-7.04-5-14-5zm0 2c7.44 0 12 1.94 12 3 0 .93-3.49 2.53-9.35 2.91-.83.06-1.72.09-2.65.09-7.44 0-12-1.94-12-3s4.56-3 12-3zM4 14.7l.2.1a9.77 9.77 0 0 0 1 .5 22.64 22.64 0 0 0 3.78 1.07l.89.14A41.2 41.2 0 0 0 16 17a41.2 41.2 0 0 0 6.13-.49l.89-.15c.95-.18 1.86-.4 2.68-.66a14.46 14.46 0 0 0 2.1-.9l.2-.1V20c0 1.06-4.56 3-12 3S4 21.06 4 20v-5.3z',
        'holly-berry-solid' => 'M16 3a4 4 0 0 0-3.42 6.04 3.98 3.98 0 0 0-2.23 6.93c-.13.01-.25.03-.38.03h-.94l-.95-.03-.08.95a5.58 5.58 0 0 1-2.54 4.24l-.73.47.36.79A9.76 9.76 0 0 1 6 26.95l-.07 1.52 1.42-.53a14.81 14.81 0 0 1 5.62-.94l.95.03.08-.95a5.58 5.58 0 0 1 2.54-4.24l.8-.5-.47-.83a7.1 7.1 0 0 1-.9-3.94c.06.05.14.12.26.18l.11.06.27.11.04.02c1.74.64 3.53 1 5.32 1.06h.16l.01.03a7.46 7.46 0 0 0 2.63 4.31 11.98 11.98 0 0 0-.75 3.3 15.6 15.6 0 0 0-4-.64h-.15a7.72 7.72 0 0 0-1.03-2.54l-.16-.2-1.34.85-.32.23.14.2c.6.95.79 1.9.84 2.54l.08.95.95-.03a14.77 14.77 0 0 1 5.62.94l1.42.53-.07-1.52a9.67 9.67 0 0 1 .91-4.53l.36-.79-.73-.47A5.52 5.52 0 0 1 24 16.92l-.08-.95-.95.03-.62.01-.32-.01c-.13 0-.25-.02-.38-.03a3.98 3.98 0 0 0-2.23-6.93c.36-.6.58-1.29.58-2.04a4 4 0 0 0-4-4zm0 2a2 2 0 1 1 0 4 2 2 0 0 1 0-4zm-3 6a2 2 0 1 1 0 4 2 2 0 0 1 0-4zm6 0a2 2 0 1 1 0 4 2 2 0 0 1 0-4zm-5.06 6.4a9.43 9.43 0 0 0 .78 3.3 7.6 7.6 0 0 0-2.59 4.3h-.16c-1.34.04-2.68.26-4 .63a11.65 11.65 0 0 0-.74-3.29A7.55 7.55 0 0 0 9.86 18h.17c1.31-.04 2.62-.25 3.91-.6z',
        'home-solid' => 'm16 2.6-.72.68-13 13 1.44 1.44L5 16.44V28h9V18h4v10h9V16.44l1.28 1.28 1.44-1.44-13-13Zm0 2.84 9 9V26h-5V16h-8v10H7V14.44Z',
        'hooli' => 'M1.73 10.86c-.82.02-1.36.3-1.56.76 0 0-1.25 1.64 3.09 5.54v3.68h2.89v-1.43a30.93 30.93 0 0 1-2.89-2.25v-1.55a25.2 25.2 0 0 0 2.67 2.52l.23.18v-1.5c0-.34.08-.9.54-.9.45 0 .53.34.53.75v2.43c.9.61 1.86 1.1 2.88 1.48v-4.7c0-.93-.67-1.86-2.03-1.86-.79 0-1.52.4-1.92 1.1v-2.72c2.1 1.04 4.2 2.32 5 2.91-.52.73-.47 1.4-.47 2.19 0 .93-.07 1.71.84 2.62.9.91 2.52.86 2.52.86s1.61.05 2.52-.86c.9-.9.83-1.69.83-2.62 0-.93.08-1.71-.83-2.62-.91-.9-2.52-.85-2.52-.85s-1.61-.06-2.52.85l-.27.3c-1.9-1.48-3.62-2.32-5.1-3.05v-1.04l-1.13.53a8.5 8.5 0 0 0-3.3-.75zm26.58.22-2.89 1.36v8.4h2.9v-9.76zm-25.85.22c.63-.04 1.42.14 2.26.46l-1.46.68v3.17C.82 12.88 1.3 11.8 1.5 11.65c.25-.21.58-.32.96-.35zm28.1.85c-.8 0-1.45.43-1.45 1.22a1.45 1.45 0 0 0 2.89 0c0-.8-.65-1.22-1.45-1.22zm-9.21 1.87s-1.62-.06-2.52.85c-.91.91-.84 1.7-.84 2.63 0 .94-.07 1.72.84 2.63.9.9 2.52.85 2.52.85s1.61.06 2.52-.85c.9-.91.84-1.7.84-2.63 0-.94.06-1.72-.84-2.63-.91-.9-2.52-.85-2.52-.85zm7.76 1.3v5.52H32v-5.52h-2.9zm-15.06.58c.17 0 .53.1.53.55v2.02c0 .18-.09.62-.53.62-.45 0-.54-.44-.54-.62v-2.02c0-.44.37-.55.54-.55zm7.3 0c.16 0 .53.1.53.55v2.02c0 .18-.1.62-.54.62-.44 0-.53-.44-.53-.62v-2.02c0-.44.36-.55.53-.55zM7.21 20.04v.8l1.92.04a13.3 13.3 0 0 1-1.92-.84zm1.92.84c1.82.63 3.5.71 4.73.36-1 .01-2.29-.13-3.76-.66v.26l-.97.04z',
        'hornbill' => 'M10.52 3a2.5 2.5 0 0 0-.44 4.96A15.7 15.7 0 0 0 8.02 16h1a6.99 6.99 0 0 1 4.62-6.58C14.1 7.32 14.77 6 15.52 6c.49 0 .94.56 1.32 1.52 1.62.02 3.5.17 5.16.5C20.54 5.57 18.4 4 16.02 4c-1.09 0-2.12.32-3.07.91A2.49 2.49 0 0 0 10.52 3zM16 8v1a6.98 6.98 0 0 1 6.58 4.62c2.1.46 3.42 1.13 3.42 1.88 0 .49-.56.94-1.52 1.32-.02 1.62-.17 3.5-.5 5.16C26.43 20.52 28 18.38 28 16c0-1.09-.32-2.12-.91-3.07a2.5 2.5 0 1 0-3.05-2.87A15.7 15.7 0 0 0 16 8zm-7.97 2.02C5.56 11.48 4 13.62 4 16c0 1.09.32 2.12.91 3.07a2.5 2.5 0 1 0 3.05 2.87A15.7 15.7 0 0 0 16 24v-1a6.98 6.98 0 0 1-6.58-4.62C7.32 17.92 6 17.25 6 16.5c0-.49.56-.94 1.52-1.32.02-1.62.17-3.5.5-5.16zM22.98 16a6.99 6.99 0 0 1-4.62 6.58c-.46 2.1-1.13 3.42-1.88 3.42-.49 0-.94-.56-1.32-1.52-1.62-.02-3.5-.17-5.16-.5 1.46 2.46 3.6 4.02 5.98 4.02 1.09 0 2.12-.32 3.07-.91a2.5 2.5 0 1 0 2.87-3.05A15.7 15.7 0 0 0 23.98 16h-1z',
        'horse-head-solid' => 'M23 4c-2.04 0-3.3 1.2-4 2.16V5C3.18 5 3 27.77 3 28h4s-.02-4.88 1.53-9.69c.77-2.4 1.95-4.78 3.63-6.5A9.06 9.06 0 0 1 19 9h.63l.28-.56S20.79 6.95 22 6.3v2.94l4.1 8.19.09.15.12.13c.4.38.56.74.63.97.05.17.03.16.03.18-.03.1-.07.31-.25.6-.22.35-.42.53-.72.53s-.5-.18-.72-.53a2.74 2.74 0 0 1-.31-.72l-.22-.84-.88.09s-.83.1-1.75-.16c-.91-.25-1.78-.7-2.15-2.09l-.34-1.28-1.13.65a4.26 4.26 0 0 0-2.19 3.1c-.14 1.18.2 2.32.63 3.44C17.78 23.9 19 26.18 19 28h2c0-2.62-1.46-5.05-2.22-7.06a5.6 5.6 0 0 1-.47-2.47c.05-.38.2-.7.47-1a5.26 5.26 0 0 0 2.81 2.31c.93.26 1.31.18 1.75.16.1.23.07.29.25.6C24 21.17 24.8 22 26 22c1.2 0 2-.82 2.4-1.47.41-.65.57-1.28.57-1.28l.03-.1v-.09s0-.48-.16-1a4.7 4.7 0 0 0-.96-1.5h.03L24 8.75V4Zm-4.53 3.03-.03.03c-.4.02-.8.04-1.19.1-.31.04-.6.12-.9.18a9.54 9.54 0 0 1 2.12-.3ZM22 12a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'horse-solid' => 'M23.25 4c-1.26 0-2.34.46-3.13 1.13a6.52 6.52 0 0 0-1.65 2.34c-.56 1.26-.6 2.02-.66 2.5-.45.19-1.63.65-2.81.65-1.53 0-2.6-.62-4.63-.62A4.32 4.32 0 0 0 7 11.53a4.22 4.22 0 0 0-1.13-.15c-.7 0-1.33.35-1.8.8a5.21 5.21 0 0 0-1.13 1.73C2.34 15.27 2 17.04 2 19h2c0-1.72.3-3.26.75-4.28.22-.51.48-.89.69-1.1.2-.2.35-.24.43-.24.14 0 .2.01.29.03-.08.36-.16.73-.16 1.12a5.82 5.82 0 0 0 1.97 4.31c0 .38-.04 1.56-.78 2.57l-.19.25V28h2v-5.88c1.05-1.78 1-3.71 1-3.71L9.97 18l-.31-.28S8 16.17 8 14.53c0-.85.27-1.47.66-1.87a2.2 2.2 0 0 1 1.71-.66c1.54 0 2.62.63 4.63.63 2.11 0 4.06-1 4.06-1l.5-.26.07-.56s.1-1.28.65-2.53a4.6 4.6 0 0 1 1.16-1.62c.42-.36.9-.61 1.56-.66v1c1.5 0 2.1 1.4 2.1 1.4l.06.16.12.16L27 10.4l-.19.21-1.15-.3-.35-.13-.34.12c-.02.01-.6.15-1.03.06-.44-.08-.76-.19-1-.84l-1.88.69c.15.42.37.77.63 1.06-.1.47-.08.92-.03 1.35.1.94.34 1.85.34 2.59 0 1.3-1.6 2.62-1.6 2.62l-.4.32V28h2v-8.9a4.9 4.9 0 0 0 2-3.88c0-1.1-.26-2.09-.34-2.81v-.07c.63.1 1.05-.01 1.5-.12l1.71.5.6.15.4-.46.66-.72c.68-.75.65-1.91-.06-2.63l-1.75-1.78-.03.03A4.36 4.36 0 0 0 25 5.5V4ZM12 17v1a4.86 4.86 0 0 1-1.63 3.72L10 22v6h2v-5.16a6.44 6.44 0 0 0 1.72-3.21c.7.31 1.82.53 3.28.62V28h2v-9.66h-1c-2.03 0-3.1-.31-3.6-.56a1.39 1.39 0 0 1-.4-.28l-.22-.5Z',
        'hospital-alt-solid' => 'M16 4.9 3.62 10.07l-.62.28V27h26V10.34l-.63-.28Zm0 2.2 11 4.59V25H5V11.69ZM15 13v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'hospital-solid' => 'M15 3v2h-2v2h2v2h2V7h2V5h-2V3ZM6 5v23h9v-3h2v3h9V5h-5v2h3v19h-5v-3h-6v3H8V7h3V5Zm5 6v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'hospital-symbol-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4 3v12h2v-5h6v5h2V10h-2v5h-6v-5Z',
        'hospital' => 'M15 3v2h-2v2h2v2h2V7h2V5h-2V3ZM6 5v23h9v-3h2v3h9V5h-5v2h3v19h-5v-3h-6v3H8V7h3V5Zm5 6v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm-8 4v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'hot-tub-solid' => 'M11.22 4.38C10.39 5.4 10 6.28 10 7.13c0 .85.37 1.5.63 1.93.25.43.36.64.37.88 0 .23-.07.64-.69 1.44l1.56 1.24c.79-1 1.16-1.9 1.13-2.74-.03-.84-.41-1.44-.66-1.85-.24-.4-.34-.63-.34-.87 0-.25.1-.7.78-1.54Zm5 0C15.39 5.4 15 6.28 15 7.13c0 .85.37 1.5.63 1.93.25.43.36.64.37.88 0 .23-.07.64-.69 1.44l1.56 1.24c.79-1 1.16-1.9 1.13-2.74-.03-.84-.41-1.44-.66-1.85-.24-.4-.34-.63-.34-.87 0-.25.1-.7.78-1.54Zm5 0C20.39 5.4 20 6.28 20 7.13c0 .85.37 1.5.63 1.93.25.43.36.64.37.88 0 .23-.07.64-.69 1.44l1.57 1.24c.78-1 1.15-1.9 1.12-2.74-.03-.84-.41-1.44-.66-1.85-.24-.4-.34-.63-.34-.87 0-.25.1-.7.78-1.54ZM3 14v2h1.19l1.53 7.6v.02c.23 1.04 1 1.88 2 2.22L7 28h2l.66-2h12.68l.66 2h2l-.72-2.16a3.03 3.03 0 0 0 2.1-2.21v-.04L27.8 16H29v-2Zm3.22 2h19.6l-1.41 7.22c-.12.43-.49.78-1 .78H8.69a1 1 0 0 1-1-.81Z',
        'hotdog-solid' => 'M24.22 4c-1.24 0-1.97.5-2.5 1.31a10 10 0 0 0-1.34-.12 4.2 4.2 0 0 0-3.07 1.43 9.03 9.03 0 0 0-1.6 2.7h-.02c-1.04 1.95-2.15 4.51-5.9 6.27-2.81 1.32-4.17 3.25-4.5 5.16-.8.5-1.29 1.23-1.29 2.56 0 2.08 1.5 3.28 3.38 3.82A5.66 5.66 0 0 0 11.63 29c3.07 0 6.67-2.02 11-6.5h.03C27.43 17.72 29 13.75 29 10.94c0-1.83-.5-3.14-1.47-3.78C27.81 4.88 25.71 4 24.22 4Zm-3.84 3.19.46.03c-.8 2.28-1.63 5.44-4.71 8.53-2.96 3.02-6.13 3.57-8.5 4.16.45-.87 1.33-1.72 3-2.5 4.32-2.03 5.83-5.3 6.8-7.13l.07-.1a8.1 8.1 0 0 1 1.28-2.21c.49-.53.97-.78 1.6-.78ZM24.96 9c.5-.02 1.07.07 1.75.31.14.34.28.85.28 1.63 0 2.07-1.2 5.6-5.75 10.15l-.03.04c-2.96 3.07-5.48 4.72-7.47 5.43-2.33-.15-4.92-1.94 4.13-8.56 3.66-2.68 3.55-8.82 7.09-9Z',
        'hotel-solid' => 'M10 4 8 6l2 2 2-2Zm2 2 2 2 2-2-2-2Zm4 0 2 2 2-2-2-2Zm4 0 2 2 2-2-2-2Zm2 2H5v20h22V8ZM7 10h18v16h-6v-5h-6v5H7Zm2 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 15v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 18v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm12 0v2h2v-2Zm-6 2h2v3h-2Z',
        'hotjar' => 'm9 4 1.73 1.9c.01.03 1.45 1.69 1.22 3.64-.15 1.24-.96 2.39-2.4 3.4-4.24 2.87-5.53 6.74-3.77 10.49A8.08 8.08 0 0 0 13.1 28h1.82l-1.14-1.61a4.16 4.16 0 0 1-.67-3.52 3.98 3.98 0 0 0 4.6.22 4.37 4.37 0 0 0 2-3.63c.25.4.46.88.62 1.41.44 1.53.38 3.87-1.22 5.4L17.45 28h1.58c.89 0 1.78-.17 2.58-.56 2.49-1.24 4.17-3.5 5.05-6.75a12.6 12.6 0 0 0-1.26-8.9C21.86 5.44 12 4.3 11.58 4.25L9 4zm4.45 2.62c2.91.65 8.06 2.31 10.2 6.15a10.45 10.45 0 0 1 1.08 7.42 8.67 8.67 0 0 1-2.4 4.41 8.2 8.2 0 0 0-.07-4.28c-.66-2.27-2.21-3.92-4.06-4.3l-2.2-.46 1.14 1.95c1.06 1.79.49 3.27-.5 3.9-.78.5-2.06.54-3.09-.97l-.95-1.4-.77 1.5a7.48 7.48 0 0 0-.6 5.17 6.06 6.06 0 0 1-3.7-3.26c-1.62-3.64.81-6.28 3.15-7.86 1.95-1.37 3.04-3 3.26-4.84a6.3 6.3 0 0 0-.49-3.13z',
        'hourglass-end-solid' => 'M7 4v2h2v4a7 7 0 0 0 3.4 6A7 7 0 0 0 9 22v4H7v2h18v-2h-2v-4a7 7 0 0 0-3.4-6 7 7 0 0 0 3.4-6V6h2V4Zm4 2h10v4a4.99 4.99 0 1 1-10 0Zm5 11c2.77 0 5 2.23 5 5v4h-1v-2a4 4 0 1 0-8 0v2h-1v-4c0-2.77 2.23-5 5-5Z',
        'hourglass-half-solid' => 'M7 4v2h2v4a7 7 0 0 0 3.4 6A7 7 0 0 0 9 22v4H7v2h18v-2h-2v-4a7 7 0 0 0-3.4-6 7 7 0 0 0 3.4-6V6h2V4Zm4 2h10v4a4.99 4.99 0 1 1-10 0Zm1.16 5a3.97 3.97 0 0 0 7.68 0ZM16 17c2.77 0 5 2.23 5 5v4h-1a4 4 0 1 0-8 0h-1v-4c0-2.77 2.23-5 5-5Z',
        'hourglass-solid' => 'M7 4v2h2v4a7 7 0 0 0 3.4 6A7 7 0 0 0 9 22v4H7v2h18v-2h-2v-4a7 7 0 0 0-3.4-6 7 7 0 0 0 3.4-6V6h2V4Zm4 2h10v4a4.99 4.99 0 1 1-10 0Zm5 11c2.77 0 5 2.23 5 5v4H11v-4c0-2.77 2.23-5 5-5Z',
        'hourglass-start-solid' => 'M7 4v2h2v4a7 7 0 0 0 3.4 6A7 7 0 0 0 9 22v4H7v2h18v-2h-2v-4a7 7 0 0 0-3.4-6 7 7 0 0 0 3.4-6V6h2V4Zm4 2h10v4a4.99 4.99 0 1 1-10 0Zm1 2v2a4 4 0 1 0 8 0V8Zm4 9c2.77 0 5 2.23 5 5v4H11v-4c0-2.77 2.23-5 5-5Z',
        'hourglass' => 'M7 4v2h2v4a7 7 0 0 0 3.4 6A7 7 0 0 0 9 22v4H7v2h18v-2h-2v-4a7 7 0 0 0-3.4-6 7 7 0 0 0 3.4-6V6h2V4Zm4 2h10v4a4.99 4.99 0 1 1-10 0Zm5 11c2.77 0 5 2.23 5 5v4H11v-4c0-2.77 2.23-5 5-5Z',
        'house-damage-solid' => 'm16 2.59-.72.69-13 13 1.44 1.44L5 16.44V28h8.83L16 22h-3.62l3.63-6.21L16 20h3.55l-1.61 8H27V16.44l1.28 1.28 1.44-1.44-13-13-.72-.69zm0 2.85 9 9V26h-4.62L22 18h-4v-6h-2.1L10 22.1V24h3.15l-.72 2H7V14.44l9-9z',
        'houzz' => 'M16 2.28 8 6.84V16l8-4.56Zm0 9.16L24 16V6.84ZM24 16l-8 4.56v9.16l8-4.56Zm-8 4.56L8 16v9.16Z',
        'hryvnia-solid' => 'M14.21 5c-.99 0-1.95.3-2.77.84l-2 1.33 1.11 1.66 2-1.33a3 3 0 0 1 1.66-.5h4.39a2.4 2.4 0 0 1 1.53 4.25l-.89.75H8v2h8.84l-3.6 3H8v2h2.84l-.25.21A4.4 4.4 0 0 0 13.4 27h4.39c.99 0 1.95-.3 2.77-.84l2-1.33-1.11-1.66-2 1.33a3 3 0 0 1-1.66.5H13.4a2.4 2.4 0 0 1-1.53-4.25l2.1-1.75H24v-2h-7.64l3.6-3H24v-2h-1.85a4.4 4.4 0 0 0-3.55-7h-4.4z',
        'html5' => 'm5.22 4 .1 1.1 1.74 19.77.07.7.65.18 7.94 2.22.25.06.28-.06 7.94-2.19.65-.19.07-.68 1.78-19.82.1-1.06h-1.1L6.3 4ZM7.4 6l17.18.03-1.62 18L16 25.97l-7-1.94Zm2.4 3 .66 7.47h8.56l-.28 3.22-2.75.75h-.03l-2.75-.75-.16-2.07h-2.5l.35 3.97L15.97 23H16l5.06-1.4.69-7.6h-9.03l-.22-2.53h9.47L22.19 9Z',
        'hubspot' => 'M7.5 4a2.5 2.5 0 0 0 0 5 2.5 2.5 0 0 0 1.33-.39l7.49 5.64a5.97 5.97 0 0 0 .24 7.78l-3.04 3.04A2 2 0 0 0 13 25a2 2 0 0 0 0 4 2 2 0 0 0 1.93-2.52l3.2-3.2h.01A6 6 0 1 0 22 12.09V8.73A2 2 0 0 0 21 5a2 2 0 0 0-1 3.73v3.36c-.78.13-1.5.41-2.15.81l-7.9-5.94A2.5 2.5 0 0 0 7.5 4zM21 15a3 3 0 1 1 0 6 3 3 0 0 1 0-6z',
        'i-cursor-solid' => 'M10 5v2h2c1.67 0 3 1.33 3 3v4h-3v2h3v6c0 1.67-1.33 3-3 3h-2v2h2a5 5 0 0 0 4-2.03A5.01 5.01 0 0 0 20 27h2v-2h-2c-1.67 0-3-1.33-3-3v-6h3v-2h-3v-4c0-1.67 1.33-3 3-3h2V5h-2a5 5 0 0 0-4 2.03A5.01 5.01 0 0 0 12 5Z',
        'ice-cream-solid' => 'M16 4a5 5 0 0 0-4.69 3.31A5 5 0 0 0 8 12v.19A2.99 2.99 0 0 0 9 18h.38l4.3 8.5.04.03c.42.89 1.3 1.47 2.28 1.47.98 0 1.86-.58 2.28-1.47h.03v-.03l4.32-8.5H23c1.64 0 3-1.36 3-3a3 3 0 0 0-2.06-2.81 5.04 5.04 0 0 0-2.97-3.78A5.03 5.03 0 0 0 16 4Zm0 2a3 3 0 0 1 2.84 2 5.04 5.04 0 0 0-4.75 4H10a3 3 0 0 1 3.81-2.88 6.6 6.6 0 0 1 1.56-1.53 4.96 4.96 0 0 0-1.65-.53A2.96 2.96 0 0 1 16 6Zm3 4a3 3 0 0 1 2.84 2h-5.68A3 3 0 0 1 19 10ZM9 14h14c.57 0 1 .43 1 1 0 .57-.43 1-1 1H12.62l1.04 2h6.71l-3.84 7.63-.03.03v.03a.53.53 0 0 1-.5.31.53.53 0 0 1-.5-.31v-.03l-.03-.04-4.56-9.06-.29-.56H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1Z',
        'icicles-solid' => 'M6 5v2.38l.81.28A3.2 3.2 0 0 1 8 10.12V21c0 1.64 1.36 3 3 3s3-1.36 3-3v-2.13a.96.96 0 0 1 1.34-.93 1 1 0 0 1 .66.93V25c0 1.64 1.36 3 3 3s3-1.36 3-3v-8.97c0-1.27.98-2.23 2.19-2.28h.03l1.78.63V12Zm3.81 3.72 11.69 4.1c-.9.77-1.5 1.91-1.5 3.21V25c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-6.13a3 3 0 0 0-1.94-2.8 3.04 3.04 0 0 0-4.06 2.8V21c0 .57-.43 1-1 1-.57 0-1-.43-1-1V10.12c0-.48-.06-.95-.19-1.4Z',
        'icons-solid' => 'M5 5v22h22V5Zm2 2h8v8H7Zm10 0h8v8h-8Zm-6 2-3 4h6Zm8 0v4h4V9ZM7 17h8v8H7Zm10 0h8v8h-8Zm4 1-2 3 2 3 2-3Zm-10 1a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'id-badge-solid' => 'M15 3a2 2 0 0 0-2 2H7v23h18V5h-6a2 2 0 0 0-2-2Zm0 2h2v2h-2ZM9 7h4v2h6V7h4v19H9Zm7 4a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 22h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 11Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'id-badge' => 'M15 3a2 2 0 0 0-2 2H7v23h18V5h-6a2 2 0 0 0-2-2Zm0 2h2v2h-2ZM9 7h4v2h6V7h4v19H9Zm7 4a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 22h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 11Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'id-card-alt-solid' => 'M15 5a2 2 0 0 0-2 2v1H4v18h24V8h-9V7a2 2 0 0 0-2-2Zm0 2h2v2h-2Zm-9 3h7v1h6v-1h7v14H6Zm10 2a3.98 3.98 0 0 0-2.79 6.86A5 5 0 0 0 11 23h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2a5 5 0 0 0-2.21-4.14A3.98 3.98 0 0 0 16 12Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'id-card-solid' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm6 2a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 6 21h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 11 10Zm7 1v2h8v-2Zm-7 1c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm7 3v2h8v-2Zm0 4v2h5v-2Z',
        'id-card' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm6 2a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 6 21h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 11 10Zm7 1v2h8v-2Zm-7 1c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm7 3v2h8v-2Zm0 4v2h5v-2Z',
        'igloo-solid' => 'M16 6C8.83 6 3 11.83 3 19v7h26v-7c0-7.17-5.83-13-13-13zm0 2c.34 0 .67.02 1 .05V12H7.52A11 11 0 0 1 16 8zm3 .43c2.17.62 4.07 1.87 5.48 3.57H19V8.43zM6.21 14H8v5H5c0-1.8.44-3.5 1.21-5zM10 14h12v5h-1.42a5 5 0 0 0-9.16 0H10v-5zm14 0h1.79c.77 1.5 1.21 3.2 1.21 5h-3v-5zm-8 4a3 3 0 0 1 3 3v3h-6v-3a3 3 0 0 1 3-3zM5 21h6v3H5v-3zm16 0h6v3h-6v-3z',
        'image-solid' => 'M2 5v22h28V5Zm2 2h24v13.9l-5.28-5.3-.72-.72-4.53 4.53-5.75-5.82-.72-.71-7 7Zm20 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-13 6.72L20.19 25H4v-2.28Zm11 2 6 6V25h-4.97l-4.16-4.19Z',
        'image' => 'M2 5v22h28V5Zm2 2h24v13.9l-5.28-5.3-.72-.72-4.53 4.53-5.75-5.82-.72-.71-7 7Zm20 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-13 6.72L20.19 25H4v-2.28Zm11 2 6 6V25h-4.97l-4.16-4.19Z',
        'images-solid' => 'M2 5v18h4v4h24V9h-4V5Zm2 2h20v14H4Zm2 2v10h16V9Zm2 2h12v6H8Zm18 0h2v14H8v-2h18Z',
        'images' => 'M2 5v18h4v4h24V9h-4V5Zm2 2h20v14H4Zm2 2v10h16V9Zm2 2h12v6H8Zm18 0h2v14H8v-2h18Z',
        'imdb' => 'M0 7v18h32V7Zm2 2h28v14H2Zm3 2.69v8.62h2V11.7Zm3.1 0v8.62H10V15.5l.9 4.81h1.29L13 15.5v4.81h1.81V11.7H12l-.5 4.12-.69-4.12Zm7.8 0v8.5h2.41c1.3 0 1.8-.2 2.19-.5.4-.2.6-.69.6-1.19v-5.19c0-.6-.2-1.11-.6-1.31-.5-.2-.69-.31-2.19-.31Zm6.2.12v8.5h1.8s.1-.6.2-.5c.2 0 1 .38 1.4.38.5 0 .7 0 1-.1.4-.2.5-.48.5-.78v-5c0-.7-.71-1.22-1.31-1.22-.6 0-1.18.4-1.38.6V11.8ZM18 13c.4 0 .81 0 .81.4v5c0 .4-.5.41-.81.41Zm6.6 1c.1 0 .21.1.21.4v4.29c0 .2-.02.4-.22.4-.1 0-.18-.1-.18-.4V14.4c0-.2-.02-.41.18-.41Z',
        'inbox-solid' => 'M7.16 5 7 5.84l-2 13V27h22v-8.16l-2-13-.16-.84Zm1.71 2h14.26l1.68 11H18v1c0 1.12-.88 2-2 2s-2-.88-2-2v-1H7.19ZM7 20h5.19c.45 1.71 1.96 3 3.81 3a3.97 3.97 0 0 0 3.81-3H25v5H7Z',
        'indent-solid' => 'M3 7v2h26V7Zm0 4v2h19v-2Zm26 0-5 5 5 5ZM3 15v2h19v-2Zm0 4v2h19v-2Zm0 4v2h26v-2Z',
        'industry-solid' => 'M20 5v5.47l-3 1.78V9.22l-1.5.94-3.5 2.09V9.22l-1.5.94-5 3-.5.28V27h22V5Zm2 2h3v18H7V14.53l3-1.78v3.03l1.5-.94 3.5-2.09v3.03l1.5-.94 5-3 .5-.28ZM9 17v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM9 21v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'infinity-solid' => 'M9 9a7 7 0 0 0 0 14c2.93 0 4.72-1.6 6.1-3.6-.42-.65-.76-1.3-1.1-1.93C12.77 19.5 11.4 21 9 21a5 5 0 0 1 0-10 4.6 4.6 0 0 1 3.6 1.56c.94.99 1.74 2.4 2.56 3.9.8 1.5 1.63 3.09 2.84 4.35A6.77 6.77 0 0 0 23 23a7 7 0 0 0 0-14c-2.91 0-4.71 1.56-6.1 3.5a35 35 0 0 1 1.13 1.9C19.25 12.45 20.61 11 23 11a5 5 0 0 1 0 10 4.49 4.49 0 0 1-3.53-1.56 18.8 18.8 0 0 1-2.56-3.9c-.82-1.5-1.66-3.09-2.88-4.35A6.83 6.83 0 0 0 9 9Z',
        'info-circle-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1 5v2h2v-2Zm0 4v8h2v-8Z',
        'info-solid' => 'M16 4c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-5 7v5h2v5h-2v5h10v-5h-2V13Zm2 2h4v10h2v1h-6v-1h2v-9h-2Z',
        'instagram' => 'M11.47 5A6.5 6.5 0 0 0 5 11.47v9.06A6.5 6.5 0 0 0 11.47 27h9.06A6.5 6.5 0 0 0 27 20.53v-9.06A6.5 6.5 0 0 0 20.53 5Zm0 2h9.06C23 7 25 9 25 11.47v9.06C25 23 23 25 20.53 25h-9.06C9 25 7 23 7 20.53v-9.06C7 9 9 7 11.47 7ZM21.9 9.19a.9.9 0 1 0 0 1.81.9.9 0 1 0 0-1.81ZM16 10c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Z',
        'intercom' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 2c-.32 0-.63.21-.63.63v9.22c0 .84 1.27.84 1.27 0V9.63c0-.42-.32-.63-.64-.63zm-3.18.32c-.32 0-.63.21-.63.63v8.5c0 .84 1.27.84 1.27 0v-8.5c0-.42-.32-.63-.64-.63zm6.36 0c-.32 0-.64.21-.64.63v8.5c0 .84 1.27.84 1.27 0v-8.5c0-.42-.31-.63-.63-.63zm-9.54 1.27c-.32 0-.63.21-.63.63v5.72c0 .84 1.27.84 1.27 0v-5.72c0-.42-.32-.63-.64-.63zm12.72 0c-.32 0-.64.21-.64.63v5.72c0 .84 1.27.84 1.27 0v-5.72c0-.42-.31-.63-.63-.63zm.07 9.2a.6.6 0 0 0-.48.17c-2.7 2.29-9.09 2.35-11.9 0-.63-.55-1.46.42-.82.96 3.25 2.79 10.44 2.68 13.54 0 .48-.41.13-1.06-.34-1.12z',
        'internet-explorer' => 'M27.7 8.81c2.44-6.24-2.3-5.8-2.3-5.8-3.05 0-6.86 2.73-6.86 2.73S14 4.54 9.46 7.24c-4.95 3.1-4.79 8.62-4.79 8.62a24.7 24.7 0 0 1 9.63-7.98v.37C6.03 13.82 4.07 21.95 3.58 23.62 3.1 25.28 3.42 29 6.9 29s7.02-2.76 7.02-2.76.76.16 2.83.16c8.7 0 10.77-7.55 10.77-7.55h-7.73s-.54 2.47-3.31 2.47c-3.82 0-3.6-3.91-3.6-3.91h14.75C28.33 7.34 19.4 5.9 19.4 5.9s3.16-2.2 5.88-2.2c4.31 0 2.27 4.98 2.27 4.98ZM13.48 26.13s-5.3 3.17-7.7.97c-1.27-2.2.8-5.31.8-5.31s1.76 3.2 6.9 4.34Zm6.4-12.15h-7.02s-.09-3.36 3.6-3.36c3.56 0 3.41 3.36 3.41 3.36Z',
        'invision' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm5.9 3c-.57 0-1.13.38-1.13 1.13 0 .64.52 1.15 1.15 1.15.18 0 1.15-.17 1.13-1.16 0-.75-.58-1.12-1.15-1.12zm6.7 3.2c-.85.07-1.77.66-2.42 1.87l.38-1.73h-2.93l-.42 1.52h1.38l-.84 3.38c-.7 1.57-2.45 1.88-2.45 1 .01-.49-.03-.2 1.4-5.9h-3.25l-.42 1.52h1.36c-.94 3.84-.98 3.83-.98 4.44 0 2.07 2.69 2.39 4.03.18l-.35 1.39h1.93l1.1-4.4c.62-2.55 3.15-2.01 2.55-.04-.39 1.4-1.73 4.55 1.06 4.55 1.02 0 1.82-.66 2.27-2.22l-.76-.29c-.61 1.69-1.36 1.38-1.36.72.02-.34.03-.32.64-2.5.7-2.29-.5-3.6-1.92-3.49z',
        'ioxhost' => 'M16 4A12.01 12.01 0 0 0 4.4 19H2a1 1 0 0 0 0 2h3.1a12.01 12.01 0 0 0 22.5-8H30a1 1 0 0 0 0-2h-3.1C25 6.88 20.84 4 16 4Zm0 2c3.71 0 6.93 2 8.66 5H11a1 1 0 0 0 0 2h14.56a10 10 0 0 1 .44 3 9.98 9.98 0 0 1-18.66 5H21a1 1 0 0 0 0-2H6.44A10 10 0 0 1 6 16c0-5.54 4.46-10 10-10Zm-5 9a1 1 0 0 0 0 2h10a1 1 0 0 0 0-2Z',
        'italic-solid' => 'm11.75 5-.06.94-.19 3-.06 1.06h2l-.88 12h-2l-.06.94-.19 3-.1 1.06h10.04l.06-.94.19-3 .06-1.06h-2l.88-12h2l.06-.94.19-3 .1-1.06Zm1.88 2h6l-.07 1h-2l-.06.94-1 14-.06 1.06h2l-.07 1h-6l.07-1h2l.06-.94 1-14L15.56 8h-2Z',
        'itch-io' => 'M16 5c-3.25 0-7.69.05-8.59.13-1 .6-3 2.9-3.03 3.5v1c0 1.26 1.19 2.37 2.26 2.37a2.37 2.37 0 0 0 2.35-2.33A2.34 2.34 0 0 0 11.31 12c1.3 0 2.3-1.07 2.3-2.33A2.39 2.39 0 0 0 15.99 12H16c1.3 0 2.38-1.07 2.38-2.33A2.32 2.32 0 0 0 20.7 12 2.34 2.34 0 0 0 23 9.67 2.37 2.37 0 0 0 25.36 12c1.07 0 2.26-1.11 2.26-2.37v-1c-.02-.6-2.02-2.9-3.03-3.5C21.44 5.02 19.25 5 16 5zm-2.45 6.74a2.74 2.74 0 0 1-4.73.01c-.63 1.1-2.06 1.52-2.67 1.31-.17 1.9-.3 11.65 1 13.28 3.8.89 14.01.87 17.7 0 1.5-1.52 1.16-11.52 1-13.28-.61.2-2.04-.21-2.66-1.3a2.74 2.74 0 0 1-4.74-.02A2.7 2.7 0 0 1 16 13.11c-1 .04-1.95-.5-2.45-1.37zM11.42 14c.8 0 1.53 0 2.41.98 1.45-.15 2.89-.15 4.34 0 .89-.97 1.61-.97 2.41-.97 2.58 0 3.2 3.81 4.13 7.09.84 3.05-.28 3.13-1.67 3.13-2.07-.08-3.22-1.58-3.22-3.09-1.93.32-5.01.44-7.64 0 0 1.51-1.15 3.01-3.22 3.09-1.39 0-2.51-.08-1.67-3.13.93-3.3 1.55-7.09 4.13-7.09V14zM16 16.88s-1.7 1.56-2 2.1l1.1-.04v.97c0 .06.83 0 .9 0 .45.02.9.04.9 0v-.97l1.1.04c-.3-.54-2-2.1-2-2.1z',
        'itunes-note' => 'M23.07 5c-.18 0-1.44.26-11.81 2.2-.08 0-.47.1-.68.28a1 1 0 0 0-.37.65c-.17.7.38 13.15-.13 13.74-.22.24-.62.32-.92.37-1.83.32-3.04.49-3.9 1.31-1.5 1.46-.72 4 1.47 4.4a5.9 5.9 0 0 0 3.23-.52 2.96 2.96 0 0 0 1.53-2.01c.18-.8.13-.25.13-12.18 0-.58.16-.73.68-.85l9.44-1.75c.58-.1.86.05.86.62 0 8.09.1 7.93-.22 8.3-.23.25-.5.32-.8.37-1.82.32-2.92.38-3.79 1.2a2.5 2.5 0 0 0 .14 3.78c.9.7 1.92.86 3.16.63 1.42-.26 2.48-1.05 2.8-2.44.15-.63.1.3.1-17.2 0-.59-.34-.94-.92-.9z',
        'itunes' => 'M10.05 5A5.04 5.04 0 0 0 5 10.05v11.9C5 24.75 7.25 27 10.05 27h11.9c2.8 0 5.05-2.25 5.05-5.05v-11.9C27 7.25 24.75 5 21.95 5h-11.9zm5.93 2a9 9 0 1 1 0 18 9 9 0 0 1 0-18zm0 1.03a7.98 7.98 0 1 0 0 15.96 7.98 7.98 0 0 0 0-15.96zM19.32 11c.26-.02.41.14.41.4 0 7.84.02 7.12-.05 7.4-.14.63-.62.98-1.25 1.1-.56.1-1.02.13-1.47-.23a1.12 1.12 0 0 1-.06-1.69c.39-.37.93-.44 1.75-.59.13-.02.25-.05.35-.17.15-.16.1.2.1-3.42 0-.25-.12-.32-.39-.28l-4.22.79c-.23.05-.3.12-.3.38 0 5.33.02 4.8-.06 5.15-.1.41-.35.72-.68.9a2.7 2.7 0 0 1-1.44.24c-.99-.19-1.33-1.32-.67-1.97.39-.37.94-.44 1.75-.59.14-.02.26-.06.35-.17.23-.26.04-5.54.12-5.85a.45.45 0 0 1 .16-.3.7.7 0 0 1 .31-.12c4.64-.87 5.2-.98 5.29-.98z',
        'java' => 'M17.63 3c1.4 3.3-5.03 5.34-5.63 8.1-.55 2.53 3.8 5.5 3.81 5.5A19.9 19.9 0 0 1 14 13.02C12.87 10.27 20.86 7.8 17.63 3Zm4.25 4.6s-5.63.35-5.91 4.03c-.13 1.63 1.48 2.5 1.53 3.68.04.98-.97 1.78-.97 1.78s1.81-.32 2.38-1.8c.62-1.66-1.22-2.78-1.04-4.1.18-1.26 4-3.6 4-3.6Zm1.37 8.46c-.59-.02-1.25.2-1.84.63 1.16-.26 2.15.47 2.15 1.31 0 1.88-2.68 3.66-2.68 3.66s4.15-.47 4.15-3.57c0-1.27-.8-1.98-1.78-2.03Zm-11.03.03c-1.45.05-4.35.3-4.35 1.41 0 1.55 6.75 1.68 11.57.72 0 0 1.31-.92 1.65-1.25-3.16.66-10.37.76-10.37.19 0-.53 2.31-1.07 2.31-1.07h-.81Zm-.44 2.88c-.8 0-1.97.62-1.97 1.22 0 1.2 5.97 2.14 10.38.37l-1.53-.93c-3 .97-8.51.65-6.88-.66Zm.75 2.72c-1.08 0-1.78.68-1.78 1.18 0 1.56 6.46 1.7 9.03.13l-1.62-1.06c-1.92.82-6.73.94-5.63-.25Zm-3.62 1.4C7.14 23.06 6 23.86 6 24.53c0 3.58 18.1 3.4 18.1-.25 0-.6-.72-.9-.98-1.03 1.48 3.5-14.78 3.22-14.78 1.16 0-.47 1.2-.94 2.32-.72l-.94-.53a5.96 5.96 0 0 0-.81-.07ZM26 25.5c-2.75 2.66-9.71 3.61-16.72 1.97 7 2.93 16.68 1.3 16.72-1.97Z',
        'jedi-order' => 'm15.49 3-.45 16.85-1.75-2.56 1.13 3.1-3.5.5 3.5.51-1.35 2.65 1.92-2.02-.12 4.78s-8.61-4-3.83-12.84c0 0-5.96-6.59-.56-10.64 0 0-9.23 5.58-3.37 15.15 0 0-4.85-4.73-2.31-9.51 0 0-4.4 6.2.96 13 0 0-1.46-.9-2.76-4.33 0 0 .94 10.23 12.39 10.36h.23A11.8 11.8 0 0 0 28 17.64c-1.32 3.43-2.78 4.33-2.78 4.33 5.35-6.8.96-13 .96-13 2.53 4.79-2.31 9.51-2.31 9.51 5.85-9.57-3.38-15.14-3.38-15.14 5.4 4.05-.56 10.63-.56 10.63 4.78 8.84-3.83 12.84-3.83 12.84l-.12-4.78 1.92 2.02-1.35-2.64 3.5-.51-3.5-.5 1.13-3.1-1.75 2.56L15.49 3z',
        'jedi-solid' => 'M15.5 4c-.2 0-.36.15-.37.35l-.53 13.7-1.4-.94a.37.37 0 0 0-.46.03.37.37 0 0 0-.06.46l.93 1.55-1.94.4a.37.37 0 0 0-.3.36c0 .17.13.33.3.36l1.94.4-.93 1.55a.37.37 0 0 0 .06.46c.12.11.33.13.46.03l1.25-.84-.11 3a5.74 5.74 0 0 1-4.6-5.6c0-1.62.68-3.12 1.9-4.22a.75.75 0 0 0 .25-.6.75.75 0 0 0-.3-.56 6.46 6.46 0 0 1-2.2-7.59.73.73 0 0 0-.08-.7.75.75 0 0 0-.62-.32c-.15 0-.3.04-.43.13a12.4 12.4 0 0 0-4.96 7.45l1.9 1.9H3.03a12.03 12.03 0 0 0 .21 3.19l2.7 2.7H4.1A12.6 12.6 0 0 0 15.5 28c5.07 0 9.44-3.03 11.4-7.35h-1.84l2.7-2.7c.15-.78.24-1.58.24-2.4 0-.26-.03-.52-.05-.79H25.8l1.9-1.9a12.46 12.46 0 0 0-4.96-7.45.73.73 0 0 0-.42-.13.75.75 0 0 0-.7 1.02 6.46 6.46 0 0 1-2.2 7.59.75.75 0 0 0-.05 1.16 5.68 5.68 0 0 1-2.7 9.82l-.12-3 1.25.85c.14.1.34.07.46-.04.13-.12.15-.3.06-.46l-.92-1.55 1.93-.4a.37.37 0 0 0 0-.72l-1.93-.4.93-1.55a.37.37 0 0 0-.53-.5l-1.4.96-.52-13.7a.37.37 0 0 0-.37-.36z',
        'jenkins' => 'M17.43 1.9c-4.14.08-6.51 1.95-6.64 2.05-.11.04-2.84.98-3.4 3.42-.09.04-.1.03-.23.1a2.6 2.6 0 0 0-.82.87c-.48.83-.69 2.24-.16 4.44a3.02 3.02 0 0 0-1.14 2.4 4.5 4.5 0 0 0 1.1 3.02 3.55 3.55 0 0 0 1.82 1.13c.2.04.2 0 .35 0a13 13 0 0 0 1.16 3.23c-.42.24-1.63.91-3.05 1.74a109.6 109.6 0 0 0-2.92 1.77 3.76 3.76 0 0 0-.34.28c-.04.04-.12.07-.14.31l-.04.38L4.16 30h23.7l.12-.35s.27-.87.53-1.85c.13-.49.26-1 .36-1.46.1-.46.17-.83.15-1.17-.02-.2-.08-.27-.13-.34a5.68 5.68 0 0 0-.6-.63 30.93 30.93 0 0 0-2.6-2.09c.22-.26.67-.73 1.25-2.2.7-1.78 1.34-4.49 1.08-8.2-.25-3.5-1.47-5.94-3.25-7.5a9.65 9.65 0 0 0-5.13-2.19h-.05a16.15 16.15 0 0 0-2.16-.13Zm1.09 1.12c.32-.02.65-.02 1 0 1.73.23 3.33.84 4.6 1.94.68.6 1.28 1.37 1.76 2.32-.37-.15-.74-.2-1.07-.19-.85.05-1.47.45-1.47.45l.54.85s.43-.27.98-.3c.54-.02 1.15.12 1.74 1.13.2.76.35 1.6.42 2.54l-.1-.17-.4-.72-.59-1-.86.5a115.68 115.68 0 0 0 1.05 1.85c-.04.02-.06.04-.15.06-.3.06-.81.06-1.3-.09l-.28.97c.64.18 1.27.2 1.79.1.26-.06.5-.14.7-.32a.95.95 0 0 0 .18-.22c.1 3.07-.45 5.32-1.04 6.82-.66 1.65-1.33 2.37-1.33 2.37l-.38.41a6.09 6.09 0 0 1-3.89 1.64c-2.92.21-4.92-1.62-5.88-2.64-.93-.98-1.06-1.73-1.06-1.73l-.98.2s.23 1.07 1.3 2.21c.44.46 1.1 1.09 1.95 1.66h-.2c-.38.07-.77.25-1.04.58a6.22 6.22 0 0 1-3.05-.9 3.44 3.44 0 0 1-.94-.84 11.9 11.9 0 0 1-1.22-3.33c.27-.13.6-.38.95-.8l-.78-.64c-.27.33-.5.48-.64.56h-.01l-.25.08s-.1.04-.4-.02c-.3-.06-.74-.25-1.3-.83a3.54 3.54 0 0 1-.83-2.34c0-.84.31-1.52.88-1.8l.02-.02c.67-.38 1.12-.43 1.43-.36.3.06.51.23.7.49.36.51.46 1.28.46 1.28l.07.62 2.03-.7-.05-.4s-.1-.7-.4-1.54c-.18-.51-.1-1.18.1-1.86.2-.7.48-1.37.6-2a2.05 2.05 0 0 0-.22-1.44 8.12 8.12 0 0 1 6.86-4.43Zm-4.38.39a10.23 10.23 0 0 0-3.2 3.28l-.13.01c-.92.09-1.72.24-2.33.37.7-1.48 2.68-2.2 2.68-2.2l.09-.03.07-.05s.98-.82 2.82-1.38Zm2.31 3.91a2.66 2.66 0 0 0-2.14 1.16c-.52.77-.54 1.62-.54 1.62l1 .05s.03-.61.37-1.12c.34-.51.85-.95 2.24-.63l.23-.97a4.1 4.1 0 0 0-1.16-.11Zm-5.8.42c.2.23.36.35.24.97-.08.44-.36 1.14-.58 1.91a4.09 4.09 0 0 0-.07 2.46c.19.53.2.73.24.95l-.17.06c-.06-.34-.05-.64-.43-1.18-.28-.4-.72-.77-1.32-.9a2.7 2.7 0 0 0-1.52.2c-.4-1.85-.14-2.84.16-3.36a1.47 1.47 0 0 1 .68-.62h.01s1.37-.32 2.76-.49Zm8 2.29-.92.38s.68 1.61 1.13 2.4c-.04.03-.04.04-.15.06-.33.08-.97.04-1.7-.28l-.4.92c.89.39 1.7.47 2.32.34.3-.07.59-.18.79-.44.2-.26.23-.7.05-.98-.31-.52-1.12-2.4-1.12-2.4Zm3.87.6h-1s.03 2.39 1.93 4.11c.8.73 1.14 1.2 1.2 1.37.02.09.01.08 0 .1a.85.85 0 0 1-.2.23 6.49 6.49 0 0 1-3.16.92c-.16 0-.18-.04-.21-.07a.43.43 0 0 1-.08-.2c-.03-.2.03-.47.03-.47l-.98-.25s-.1.4-.04.87c.04.23.12.5.33.73.22.23.56.38.93.39a6.7 6.7 0 0 0 2.1-.35 4.53 4.53 0 0 0 1.75-.83c.17-.15.33-.32.44-.55.1-.24.12-.55.03-.83-.18-.55-.63-1.03-1.47-1.8-1.57-1.42-1.6-3.38-1.6-3.38ZM7.69 13.9c-.32.02-.66.17-.96.42l.56.67a3.36 3.36 0 0 0-.16 1.64l.98-.18c-.05-.3.03-.7.12-1.04.13.26.22.5.22.5l.97-.25s-.15-.6-.54-1.12c-.2-.26-.47-.53-.88-.61-.1-.03-.2-.03-.31-.03Zm17.6 3.86c-.77.86-2.16.98-2.16.98l.06 1s1.74-.06 2.85-1.33Zm-6.72.35-.63.77c2.12 1.73 4.68.99 4.68.99l-.27-.96s-2.07.58-3.78-.8Zm-.27 1.6-.97.28c.2.7.68 1.19 1.23 1.5.55.3 1.17.45 1.76.53 1.17.15 2.23 0 2.23 0l-.13-.99s-.96.13-1.97 0c-.5-.07-1.02-.2-1.4-.41a1.43 1.43 0 0 1-.75-.9Zm6.81 3.2c.25.2.68.5 1.35 1.04a25.05 25.05 0 0 1 1.52 1.33l.02.02c0 .13-.03.43-.1.82l-.35 1.41c-.21.77-.35 1.22-.43 1.46h-1.17l-.04-.29a1.1 1.1 0 0 0-.46-.77c.04-.08.1-.15.12-.22.1-.31.13-.63.13-.95.01-.64-.1-1.28-.15-1.63a2.2 2.2 0 0 0-.65-1.4 1.7 1.7 0 0 0-.43-.27c.27-.2.49-.4.64-.55Zm-15.23.55c.16.35.42.89 1.1 1.78a5.52 5.52 0 0 0 3.3 1.82c.04.47.1.91.22 1.32.06.21.15.42.27.61H4.84L4 26.94l.06-.05c.16-.1.4-.27.7-.44.57-.36 1.36-.82 2.15-1.29 1.38-.8 2.47-1.4 2.96-1.69Zm13.82.88c.23-.05.39 0 .53.13s.29.38.33.78c.05.4.15 1 .14 1.5 0 .26-.03.49-.07.63-.06.15-.1.2-.16.23-.4.2-1.13.16-1.75 0a7.17 7.17 0 0 1-.73-.22c.06-.16.1-.33.1-.5 0-.45-.2-.84-.52-1.11a20.3 20.3 0 0 1 1.75-1.27l.38-.17Zm-11.98.2c.65.3 1.44.57 2.43.67l.01.52.02.26c-.69-.18-1.8-.57-2.4-1.36-.05-.06-.02-.04-.06-.1Zm4.4.1c.45.02 1 .18 1.46.4l1.85.97c-.18.25-.3.55-.3.88 0 .26.08.51.2.73a8.14 8.14 0 0 1-2.97 1.1c-.34.03-.5-.03-.62-.12-.11-.09-.2-.24-.29-.5-.16-.55-.18-1.47-.3-2.48-.04-.41.03-.62.12-.74s.22-.2.45-.24c.12-.02.25-.02.4 0Zm5.02.2-.48.37c.05-.04-.13.04-.3.03-.15 0-.23 0-.27-.02l-.53-.27c.3.02.61.02.93 0 .23-.02.43-.07.65-.1Zm-.53 1.57c.27 0 .48.2.48.48 0 .27-.21.48-.48.48a.47.47 0 0 1-.48-.48c0-.27.21-.48.48-.48Zm.83 1.82c.16.07.45.2.99.34V29H20.7l-.32-.65.23.02h.09c.16.05.31.08.43.05.19-.06.2-.1.31-.18Zm3.23.37v.02s.24.1.25.2l.02.17h-1.51v-.25a3 3 0 0 0 1.24-.14Zm-5.23.12.14.27h-.67l.53-.27Z',
        'jira' => 'M16.02 2.2 3.58 14.6a1.99 1.99 0 0 0 0 2.8l12.44 12.4.7-.7 7.19-7.16 1.36-1.36.24-.26.08-.07v-.01l.06-.08 2.76-2.76a1.96 1.96 0 0 0 0-2.8l-5.5-5.52-6.18-6.18-.7-.7zm0 2.82A3592.32 3592.32 0 0 1 27 16a177.25 177.25 0 0 0-3.35 3.35l-.49.48.02.02-7.15 7.13L5 16.02l11.03-11zm0 5.9L10.92 16l5.1 5.07 5.1-5.07-5.1-5.07zm0 2.83L18.28 16l-2.26 2.25L13.76 16l2.26-2.25z',
        'joget' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.93 12.2c-2.52-.01-9.46.03-11.98-.03-3.08-.07-4.53-1.16-3.24-2.67a12.62 12.62 0 0 1 3.5-2.86c.99-.58 1.47-1.83-1.34-1.61-5.5.37-7.8 3.41-8.86 5.84C5.08 9.87 9.98 5 16 5zm5.58 7c-1 0-2.66 1.42-4.1 2.35a16.76 16.76 0 0 1-3.63 1.75l9.4-.1L26 14.66s.2-.53-1.06-.85c-1.26-.33-3.31.66-4.96 1.55-1.65.87-1.72.45-1.72.45s2.58-1.94 3.16-2.3c.59-.36 1.78-.77.75-1.36-.19-.1-.38-.15-.58-.15zm4.51 8.37a11.01 11.01 0 0 1-12.14 6.43c-.38-.63-.75-1.3-.91-1.66-.34-.77-1.57-2.57 1.8-3.8 2.7-.97 8.75-.95 11.25-.97z',
        'joint-solid' => 'M14.9 4c-.36.35-.62.8-.93 1.47a6.1 6.1 0 0 0-.6 2.5c0 .96.33 2.04 1.2 2.86.85.82 2.15 1.37 3.98 1.6a8.6 8.6 0 0 1 3.08.8c.56.33.79.67.97 1.49l1.95-.43a4.19 4.19 0 0 0-1.9-2.78c-.99-.6-2.22-.86-3.85-1.06-1.55-.2-2.41-.64-2.85-1.07a1.76 1.76 0 0 1-.57-1.4c0-.55.18-1.17.41-1.68.23-.5.59-.95.53-.9L14.91 4zm5.53.31v2c.62 0 1.44.08 2.05.42.61.35 1.12.88 1.24 2.34l.08.92h.92c.51 0 1.6.16 2.13.63.26.23.44.5.5 1.02.07.53-.02 1.33-.5 2.48l1.86.76c.55-1.36.75-2.5.63-3.47a3.6 3.6 0 0 0-1.18-2.3c-.9-.8-1.9-.97-2.7-1.04-.35-1.45-1.06-2.55-2-3.08a6.04 6.04 0 0 0-3.03-.68zM30 16 2 17v6l28 1v-8zm-2 2.07v3.86l-2-.07v-3.72l2-.07zm-4 .14v3.58l-2-.08V18.3l2-.08zm-4 .15v3.28l-16-.57v-2.14l16-.57z',
        'joomla' => 'M6.02 8.69a2.68 2.68 0 0 1 5.32-.44 4.43 4.43 0 0 1 4.15 1.18l.15.16-1.97 1.97-.15-.15a1.64 1.64 0 0 0-2.32 0 1.64 1.64 0 0 0 0 2.32l4.44 4.45-1.97 1.97-2.1-2.09L9.6 16.1l-.38-.39a4.42 4.42 0 0 1-1.11-4.4A2.67 2.67 0 0 1 6.02 8.7Zm5.8 5.2 1.97 1.97 2.09-2.09 2.35-2.36a1.64 1.64 0 1 1 2.32 2.32l-.15.15 1.98 1.98.15-.16a4.41 4.41 0 0 0 1.12-4.36 2.68 2.68 0 1 0-3-3.02 4.44 4.44 0 0 0-4.38 1.12l-.4.38-1.97 1.98Zm11.88 6.77a4.42 4.42 0 0 0-1.17-4.18l-.39-.39-1.97-1.97-2.08-2.09L16.1 14l2.09 2.1 2.35 2.35a1.64 1.64 0 1 1-2.31 2.32l-.15-.15-1.98 1.98.15.15a4.43 4.43 0 0 0 4.44 1.1 2.68 2.68 0 1 0 3-3.19Zm-3.77-2.36-1.97-1.98-2.09 2.09-1.97 1.98-.38.38a1.64 1.64 0 0 1-2.33-2.32l.15-.15-1.97-1.98-.15.16a4.42 4.42 0 0 0-1.16 4.23 2.68 2.68 0 1 0 3.23 3.2 4.42 4.42 0 0 0 4.2-1.16l.39-.4 1.97-1.97Z',
        'journal-whills-solid' => 'M9 4C7.36 4 6 5.36 6 7v18c0 1.64 1.36 3 3 3h17V4H9zm0 2h15v16H9c-.35 0-.68.07-1 .19V7c0-.57.43-1 1-1zm7 2.21a.22.22 0 0 0-.21.21l-.25 5.94-.65-.44a.21.21 0 0 0-.3.29l.46.76-.96.2a.21.21 0 0 0 0 .42l.96.2-.46.77a.22.22 0 0 0 .18.32c.05 0 .09-.01.12-.03l.56-.38-.07 1.75a3 3 0 0 1-1.54-5 3.41 3.41 0 0 1-.75-4.43 6 6 0 0 0-2.49 2.63l1.42 1.42a.43.43 0 1 1-.61.6l-1.14-1.13A5.9 5.9 0 0 0 10 14l.01.08L12 15.82c.17.16.2.43.04.6-.09.1-.2.15-.33.15-.1 0-.2-.04-.28-.1l-1.26-1.11a6 6 0 0 0 11.66 0l-1.26 1.1a.43.43 0 0 1-.6-.03.43.43 0 0 1 .03-.61l2-1.74V14a6 6 0 0 0-.27-1.7l-1.14 1.15a.43.43 0 0 1-.6-.61l1.4-1.42a6 6 0 0 0-2.48-2.63c.32.52.52 1.12.52 1.78a3.4 3.4 0 0 1-1.27 2.64 2.98 2.98 0 0 1-1.54 5l-.07-1.83.68.46a.22.22 0 0 0 .26-.02.21.21 0 0 0 .04-.26l-.46-.77.96-.2c.1-.02.17-.1.17-.2s-.07-.2-.17-.22l-.96-.2.46-.76a.21.21 0 0 0-.04-.27.22.22 0 0 0-.26-.02l-.77.52-.25-6.02c0-.11-.1-.2-.21-.2zM9 24h15v2H9c-.57 0-1-.43-1-1 0-.57.43-1 1-1z',
        'js-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13.24 8c-1.42 0-2.34.91-2.34 2.12 0 1.31.77 1.94 1.93 2.43l.4.17c.73.33 1.16.51 1.16 1.07 0 .46-.42.8-1.09.8-.79 0-1.23-.42-1.58-.98l-1.3.75c.46.93 1.43 1.64 2.92 1.64 1.52 0 2.66-.79 2.66-2.23 0-1.35-.77-1.95-2.14-2.53l-.4-.17c-.69-.3-.99-.5-.99-.98 0-.39.3-.7.77-.7.47 0 .76.2 1.04.7l1.26-.8C22 15.34 21.27 15 20.24 15zm-5.85.1v5.46c0 .8-.34 1-.86 1-.55 0-.79-.37-1.04-.82l-1.3.79a2.5 2.5 0 0 0 2.4 1.47c1.43 0 2.41-.76 2.41-2.42V15.1h-1.6z',
        'js' => 'M0 7v18h32V7Zm2 2h28v14H2Zm10 3v5.5c0 .21-.29.5-.5.5-.21 0-.5-.29-.5-.5V17H9v.5a2.5 2.5 0 1 0 5 0V12Zm6.5 0a2.5 2.5 0 1 0 0 5c.21 0 .5.29.5.5 0 .3-.12.5-.5.5-.37 0-.43-.08-.44-.1 0 0-.06-.07-.06-.3h-2c0 .56.16 1.2.63 1.68.46.49 1.14.72 1.87.72a2.5 2.5 0 1 0 0-5c-.21 0-.5-.29-.5-.5 0-.21.29-.5.5-.5.27 0 .35.06.4.13.06.06.1.16.1.28h2c0-.6-.21-1.2-.66-1.66A2.54 2.54 0 0 0 18.5 12Z',
        'jsfiddle' => 'M26 14.35a8.5 8.5 0 0 0-16.27-3.28 4 4 0 0 0-4.7 3.72A6 6 0 0 0 7.99 26h16a6 6 0 0 0 2-11.65ZM20.9 23c-1.92 0-3.76-1.64-5.52-3.23C13.86 18.4 12.3 17 11.1 17c-1.17 0-2.1.88-2.1 2 0 1.09.97 2 2.1 2 1 0 1.89-.41 2.74-1.26l1.41 1.42A5.74 5.74 0 0 1 11.11 23C8.84 23 7 21.2 7 19s1.84-4 4.1-4c1.97 0 3.82 1.66 5.61 3.28C18.2 19.6 19.74 21 20.9 21c1.16 0 2.11-.9 2.11-2 0-1.12-.93-2-2.1-2-1.36 0-2.57.9-2.89 1.22L16.6 16.8a6.6 6.6 0 0 1 4.3-1.8c2.26 0 4.1 1.8 4.1 4s-1.84 4-4.1 4Z',
        'kaaba-solid' => 'M16 5c-.21 0-.43.03-.63.1L5.03 8.55A1.5 1.5 0 0 0 4 9.97V22.9c0 .69.47 1.29 1.14 1.46l10.38 2.59a1.98 1.98 0 0 0 .96 0l10.38-2.6A1.5 1.5 0 0 0 28 22.9V9.97a1.5 1.5 0 0 0-1.03-1.42L16.63 5.1c-.2-.07-.42-.1-.63-.1zm0 2 10 3.33v2.55l-9.2-2.76a2.76 2.76 0 0 0-1.6 0L6 12.88v-2.55L16 7zm0 4.63c.16 0 .32.03.48.07L26 14.56v7.94L16 25 6 22.5v-7.94l9.53-2.86c.15-.04.3-.07.47-.07zm-.78 1.38h-.13l-3.33.9a.28.28 0 0 0-.2.28v.58c0 .18.17.3.35.27l3.33-.91a.3.3 0 0 0 .2-.28v-.57c0-.14-.1-.25-.22-.27zm1.56 0a.28.28 0 0 0-.22.27v.57c0 .14.08.25.2.28l3.33.9c.18.06.35-.08.35-.26v-.58a.28.28 0 0 0-.2-.27l-3.33-.9a.26.26 0 0 0-.13-.01zm-6.56 1.36h-.13l-2.77.76a.28.28 0 0 0-.21.27v.58c0 .18.17.31.35.26l2.78-.75c.12-.04.2-.15.2-.27v-.58c0-.13-.1-.24-.22-.27zm11.56 0a.28.28 0 0 0-.22.27v.58c0 .12.08.23.2.27l2.78.75c.18.05.35-.08.35-.26v-.58a.28.28 0 0 0-.2-.27l-2.78-.75a.26.26 0 0 0-.13 0z',
        'kaggle' => 'M10.35 4c-.23 0-.35.12-.35.35v23.3c0 .23.12.35.35.35h2.3c.23 0 .35-.12.35-.36v-4.83l1.81-1.72 5.24 6.66c.14.16.3.25.5.25h3.17c.16 0 .26-.05.28-.14l-.07-.36-6.9-8.59 6.62-6.41c.12-.13.08-.5-.25-.5h-3.28c-.17 0-.33.09-.5.25L13 18.97V4.35c0-.23-.12-.35-.35-.35h-2.3z',
        'key-solid' => 'M20 3c-4.95 0-9 4.05-9 9 0 .52.09.98.16 1.44l-7.88 7.84-.28.31V29h7v-3h3v-3h3v-2.97c1.18.58 2.55.97 4 .97 4.95 0 9-4.05 9-9s-4.05-9-9-9Zm0 2a7 7 0 0 1 7 7 7.01 7.01 0 0 1-10.4 6.13l-.26-.13H14v3h-3v3H8v3H5v-4.56l7.9-7.94.38-.34-.1-.54A7.01 7.01 0 0 1 20 5Zm2 3a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'keybase' => 'M14.72 4c-.54.75-.94 1.3-1.32 1.85a1.7 1.7 0 0 0-1.21-.61l-1.5-.1c-.93.01-1.68.73-1.74 1.65l-.09 1.4c-.05.97.68 1.79 1.64 1.85l1.06.06c-.1.9.05 1.75.41 2.47a11.23 11.23 0 0 0-3.68 2.5C4.94 18.42 5 22.59 5 26.6l1.27-1.35c.26.97.66 1.9 1.18 2.75H9a9.31 9.31 0 0 1-1.67-3.87l2.13-2.27-1 3.18c2.24-1.64 5.7-4.7 12.51-2.7 1.8.53 3.72.04 4.58-1.54.43 2.11.06 5.12-1.2 7.2h1.46A12.31 12.31 0 0 0 27 22.47c0-2.64-1.13-5.3-3.08-7.32a10.72 10.72 0 0 0-4.4-2.78l.13-.32a4.09 4.09 0 0 0-2.59-5.16c-.98-.33-1.52-.3-1.72-.3-.01-.01-.25-.4.48-1.95L14.72 4zm-4.03 2.43 1.42.08c.54.04.42.64.42.74-.28.5-.52 1.03-.7 1.58l-1.25-.08a.46.46 0 0 1-.44-.48l.09-1.4a.46.46 0 0 1 .46-.44zm3.46.61c.2.52.7.85 1.26.82.4-.01 2.16.14 2.9 1.7a2.8 2.8 0 0 1-.65 3.26l-.45-.55a1.58 1.58 0 0 0-2.81.94c-.5-.23-.9-.6-1.2-1.07-1.04-1.75.22-3.96.95-5.1zm-3.2.15-.05.83.83.06.06-.84-.83-.05zm5.06 5.78c.08 0 .15.04.22.12l2.95 3.65c.25.31-.22.7-.48.39l-.3-.37-1.04.86a.24.24 0 0 1-.34-.03l-.47-.59a.24.24 0 0 1 .03-.33l1.05-.87-.43-.52-.51.43c-.26.2-.65-.3-.4-.5l.51-.43-1.05-1.3c-.2-.24.03-.52.26-.51zm2.8.51a9.87 9.87 0 0 1 5.14 3.7c.81 1.16.95 2.34.36 3.18-.58.83-1.73 1.11-2.99.74-3.91-1.16-7.44-.9-10.53.77l1.6-5.01-6.09 6.48c.06-1.57.27-3.22 1.07-4.84.7-1.43 2.42-3.77 5.4-4.88.85.81 1.9 1.07 2.28 1.14-.23.54-.14 1.17.24 1.61-.15.5-.06 1.04.27 1.44l.48.58c.28.36.72.57 1.17.57.65 0 1.04-.41 1.19-.53a1.6 1.6 0 0 0 1.77-2.5l-1.7-2.11c.12-.1.23-.22.34-.34zm.6 10.92a.95.95 0 0 0-.95.96.95.95 0 1 0 1.9 0 .96.96 0 0 0-.95-.96zm-5.9.01a.95.95 0 0 0-.95.95c0 .53.42.96.95.96a.95.95 0 0 0 0-1.91z',
        'keyboard-solid' => 'M3 7a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h26a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2Zm0 2h26v14H3Zm2 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM5 15v2h4v-2Zm6 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h4v-2ZM5 19v2h4v-2Zm6 0v2h10v-2Zm12 0v2h4v-2Z',
        'keyboard' => 'M3 7a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h26a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2Zm0 2h26v14H3Zm2 2v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2ZM5 15v2h4v-2Zm6 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h4v-2ZM5 19v2h4v-2Zm6 0v2h10v-2Zm12 0v2h4v-2Z',
        'keycdn' => 'M25.8 4.4a2.28 2.28 0 0 0-2.17 2.94l-1.93 1.8a8.9 8.9 0 0 0-10.58-.67l1 1.03a7.44 7.44 0 0 1 4.03-1.04 7.43 7.43 0 0 1 5.95 3.14l2.94-2.8c.1.04.45.1.75.09A2.24 2.24 0 0 0 28 6.65c0-1.21-.99-2.26-2.2-2.26zM7.87 6.06a1.4 1.4 0 0 0-1.05 2.37c.32.33.77.48 1.22.42l1.18 1.24a8.95 8.95 0 0 0-.92 10.59l1.04-1.01a7.62 7.62 0 0 1 .97-8.7c.44-.5.84-.8 1.06-.99L9.23 7.73c.09-.44-.04-.9-.35-1.22a1.45 1.45 0 0 0-1-.44zm8.15 3.95a6 6 0 1 0-.09 12 6 6 0 0 0 .09-12zm7.6 1.35-1.03.98a7.7 7.7 0 0 1 .99 3.85 7.7 7.7 0 0 1-3.03 5.83l2.08 2.2c-.08.46.04.92.36 1.24.54.56 1.42.58 1.99.05a1.4 1.4 0 0 0-1.17-2.4 43.15 43.15 0 0 0-1.13-1.2 8.94 8.94 0 0 0 2.29-5.68 9 9 0 0 0-1.36-4.87zM16 13a2.25 2.25 0 0 1 1 4.27l.5 1.73h-3l.5-1.73a2.28 2.28 0 0 1-1.26-2.02A2.27 2.27 0 0 1 16 13zm-6.17 7.44L6.99 23.2A2.24 2.24 0 0 0 4 25.34c0 1.26.97 2.27 2.23 2.27a2.27 2.27 0 0 0 2.17-2.92l1.8-1.78a9 9 0 0 0 10.59.66c-.12-.11-.74-.77-.98-1.02a7.65 7.65 0 0 1-4.05 1.04 7.18 7.18 0 0 1-5.93-3.15z',
        'khanda-solid' => 'm15.5 3-2.9 2.58a.7.7 0 0 0-.17.78l.25.56a5.45 5.45 0 0 0 .12 9.41l-.38.84a.7.7 0 0 0 .13.75l2.15 1.76v.97l-3.74-2.6A7.78 7.78 0 0 1 7.5 11.6a8.7 8.7 0 0 1 1.38-4.43c.2-.3.12-.68-.12-.94a.82.82 0 0 0-.98-.13 9.19 9.19 0 0 0-4.14 11.35c.35.88.88 1.68 1.5 2.4l2.62 2.89a.8.8 0 0 0 .96.18l3.98-1.76 1.42 1-2.72 1.55c-.08-.02-.15-.05-.24-.05a1.17 1.17 0 1 0 0 2.34c.6 0 1.06-.44 1.14-1.01l2.4-1.34v1.46a1.5 1.5 0 0 0-.71 1.33c0 .86.63 1.56 1.5 1.56.86 0 1.5-.7 1.5-1.56a1.5 1.5 0 0 0-.73-1.32v-1.48L18.7 25a1.16 1.16 0 0 0 2.31-.16c0-.65-.52-1.17-1.17-1.17-.09 0-.16.03-.25.05l-2.71-1.56 1.42-1 3.98 1.77c.32.17.72.1.96-.19l2.46-2.68a9.33 9.33 0 0 0 2.01-3.7A9.16 9.16 0 0 0 23.16 6.1a.78.78 0 0 0-1.04 1.1 8.57 8.57 0 0 1 1.38 4.39 7.8 7.8 0 0 1-3.48 6.46l-3.75 2.61v-.98l2.16-1.76a.7.7 0 0 0 .13-.75l-.38-.84a5.45 5.45 0 0 0 .11-9.4l.26-.57a.7.7 0 0 0-.18-.78L15.5 3zm1.95 5.67A3.56 3.56 0 0 1 19 11.6c0 1.25-.67 2.36-1.68 3l-.33-.7a6.12 6.12 0 0 1 0-4.25l.46-.97zm-3.9.02.44.96a6.04 6.04 0 0 1 0 4.23l-.32.7a3.55 3.55 0 0 1-1.67-3c0-1.19.61-2.24 1.54-2.9z',
        'kickstarter-k' => 'M11 5a3 3 0 0 0-3 3v16a3 3 0 1 0 6 0v-4.59l5.74 6.57a3 3 0 1 0 4.52-3.95l-5.4-6.17L23.4 9.8a3 3 0 0 0-4.8-3.6L14 12.33V8a3 3 0 0 0-3-3z',
        'kickstarter' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm6.63 4c-1.05 0-1.63.8-1.63 1.82v6.31c0 1.06.56 1.86 1.65 1.86.88 0 1.6-.57 1.6-1.86v-1.7l2.47 3.09c.5.6 1.6.68 2.28 0 .6-.62.6-1.5.16-2.06l-2-2.56 1.57-2.42c.39-.55.4-1.4-.22-2a1.6 1.6 0 0 0-2.51.28l-1.75 2.67v-1.59c0-1.25-.72-1.84-1.62-1.84z',
        'kiss-beam-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-6 5v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.71-1.38.43-.36.7-.84.7-1.37 0-1.19-1.3-2.12-2.97-2.12z',
        'kiss-beam' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-6 5v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.71-1.38.43-.36.7-.84.7-1.37 0-1.19-1.3-2.12-2.97-2.12z',
        'kiss-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM15 17v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.72-1.38.44-.36.72-.84.72-1.37 0-1.19-1.31-2.12-2.98-2.12z',
        'kiss-wink-heart-solid' => 'M16 3C8.83 3 3 8.83 3 16a13.02 13.02 0 0 0 19.5 11.24l-1.44-1.48A11.01 11.01 0 0 1 5 16C5 9.94 9.94 5 16 5c6.07 0 11 4.94 11 11v.08c.72.11 1.38.38 1.96.78.01-.28.04-.57.04-.86 0-7.17-5.83-13-13-13zm-4.5 9a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm8.5 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S22.1 12 20 12zm-5 5v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.71-1.38.43-.36.7-.84.7-1.37 0-1.19-1.3-2.12-2.97-2.12zm7.75 1A2.8 2.8 0 0 0 20 20.8c0 .88.5 1.53.87 1.9l3.63 3.73 3.64-3.73c.36-.37.86-.9.86-1.9a2.8 2.8 0 0 0-2.75-2.8c-.73 0-1.33.25-1.75.5a3.42 3.42 0 0 0-1.75-.5zm0 2c.24 0 .48.07.73.22l1.02.6 1.02-.6c.25-.15.5-.22.73-.22.4 0 .75.37.75.8 0 .19 0 .21-.3.5l-2.2 2.26-2.2-2.26c-.11-.11-.3-.33-.3-.5 0-.43.35-.8.75-.8z',
        'kiss-wink-heart' => 'M16 3C8.83 3 3 8.83 3 16a13.02 13.02 0 0 0 19.5 11.24l-1.44-1.48A11.01 11.01 0 0 1 5 16C5 9.94 9.94 5 16 5c6.07 0 11 4.94 11 11v.08c.72.11 1.38.38 1.96.78.01-.28.04-.57.04-.86 0-7.17-5.83-13-13-13zm-4.5 9a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm8.5 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S22.1 12 20 12zm-5 5v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.71-1.38.43-.36.7-.84.7-1.37 0-1.19-1.3-2.12-2.97-2.12zm7.75 1A2.8 2.8 0 0 0 20 20.8c0 .88.5 1.53.87 1.9l3.63 3.73 3.64-3.73c.36-.37.86-.9.86-1.9a2.8 2.8 0 0 0-2.75-2.8c-.73 0-1.33.25-1.75.5a3.42 3.42 0 0 0-1.75-.5zm0 2c.24 0 .48.07.73.22l1.02.6 1.02-.6c.25-.15.5-.22.73-.22.4 0 .75.37.75.8 0 .19 0 .21-.3.5l-2.2 2.26-2.2-2.26c-.11-.11-.3-.33-.3-.5 0-.43.35-.8.75-.8z',
        'kiss' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM15 17v1.5c.9 0 1.48.41 1.48.63 0 .21-.58.62-1.47.63H15v1.49h.01c.9 0 1.47.41 1.47.63 0 .21-.58.63-1.48.63V24c1.67 0 2.98-.93 2.98-2.12 0-.53-.28-1-.72-1.38.44-.36.72-.84.72-1.37 0-1.19-1.31-2.12-2.98-2.12z',
        'kiwi-bird-solid' => 'M11.48 4A9.87 9.87 0 0 0 2 13.48a9.19 9.19 0 0 0 4 7.82v6.24l3.45 2.3 1.1-1.67L8 26.47v-4.12c.64.24 1.3.42 2 .52v2.85l3.68 1.23.64-1.9-2.32-.77v-1.3c4.38-.1 5.18-1.41 6.47-1.95 2.52-1.02 3.44-2.34 3.9-3.24.22-.45.35-.71.52-.89.18-.17.44-.36 1.14-.52.65-.16 1.2-.35 1.68-.56.1.3.21.64.32 1.06.48 1.78.97 4.7.97 9.12h2c0-4.57-.5-7.66-1.03-9.63-.18-.69-.37-1.2-.54-1.65.2-.2.38-.41.53-.63.65-.97.64-2 .64-2.5a5 5 0 0 0-1.09-3.3 4.76 4.76 0 0 0-3.7-1.49 4.9 4.9 0 0 0-4.26 2.47A8.34 8.34 0 0 0 11.5 4Zm.04 2c3.63 0 5.71 1.7 6.62 4.97l.2.73h2.45l.18-.77A2.88 2.88 0 0 1 23.8 8.8c1.19 0 1.8.34 2.19.8.4.47.6 1.17.6 2 0 .5 0 .93-.3 1.38-.3.45-.97 1.04-2.72 1.45-.95.23-1.64.6-2.1 1.07-.48.49-.69 1-.89 1.39-.4.77-.67 1.4-2.86 2.28-2.05.85-1.69 1.83-6.22 1.83-4.29 0-7.59-3.21-7.5-7.48A7.95 7.95 0 0 1 11.52 6Z',
        'korvue' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm3 3v5.88h7.81l3.7-5.88h-4.59L14 15.5V10h-4zm0 6.5v5.47h4V16.8l3 5.18h4.81l-3.7-5.47H10z',
        'landmark-solid' => 'M16 3.9 3.62 9.07 3 9.34V12h2v11H3v5h26v-5h-2V12h2V9.34l-.63-.28Zm0 2.2 9.38 3.9H6.63ZM7 12h2v11H7Zm4 0h2v11h-2Zm4 0h2v11h-2Zm4 0h2v11h-2Zm4 0h2v11h-2ZM5 25h22v1H5Z',
        'language-solid' => 'M4 4v18h6v6h18V10h-6V4Zm2 2h14v4.56L10.56 20H6Zm5 2v1H8v2h4.94a4.64 4.64 0 0 1-1.06 2.69 4.54 4.54 0 0 1-.91-.4c-.7-.43-.97-.87-.97-1.29H8c0 1.2.73 2.18 1.72 2.84-.5.1-1.06.16-1.72.16v2a7.8 7.8 0 0 0 4.38-1.16c.52.1 1.05.16 1.62.16v-1.88c.54-.9.83-1.97.94-3.12H16V9h-3V8Zm10.44 4H26v14H12v-4.56ZM20 13.84l-.94 2.85-2 6-.06.15V24h2v-.88l.03-.12h1.94l.03.13V24h2v-1.16l-.06-.15-2-6Zm0 6.29.28.87h-.56Z',
        'laptop-code-solid' => 'M5 6v13.56l-2.28 2.32A2.42 2.42 0 0 0 4.4 26h23.18a2.42 2.42 0 0 0 1.7-4.13L27 19.57V6H5zm2 2h18v11H7V8zm9 1-1.5 9H16l1.5-9H16zm-3.91 2-1.72 2.07-.37.43.37.43L12.09 16l1.08-.86-1.36-1.64 1.36-1.64L12.1 11zm7.82 0-1.08.86 1.36 1.64-1.36 1.64 1.08.86 1.72-2.07.37-.43-.37-.43L19.91 11zM6.44 21h19.12l2.32 2.28c.07.08.12.2.12.31 0 .25-.16.41-.4.41H4.4a.39.39 0 0 1-.4-.4c0-.12.05-.24.13-.32L6.42 21z',
        'laptop-medical-solid' => 'M5 6v13.56l-2.28 2.32A2.42 2.42 0 0 0 4.4 26h23.18a2.42 2.42 0 0 0 1.7-4.13L27 19.57V6H5zm2 2h18v11H7V8zm8 2v3h-3v2h3v3h2v-3h3v-2h-3v-3h-2zM6.44 21h19.12l2.32 2.28c.07.08.12.2.12.31 0 .25-.16.41-.4.41H4.4a.39.39 0 0 1-.4-.4c0-.12.05-.24.13-.32L6.42 21z',
        'laptop-solid' => 'M5 6v13.56l-2.28 2.32A2.42 2.42 0 0 0 4.4 26l23.18-.01a2.42 2.42 0 0 0 1.7-4.13L27 19.57V6Zm2 2h18v11H7Zm-.56 13h19.12l2.32 2.28c.07.08.12.2.12.31 0 .25-.16.41-.4.41H4.4a.39.39 0 0 1-.4-.4c0-.12.05-.24.13-.32Z',
        'laravel' => 'M7.56 5c-.66.03-5.67.46-6.03.5-.35.02-.75.19-.39 1.05.36.86 6.05 13.4 6.2 13.77.16.36.58.96 1.54.72 1-.25 4.42-1.17 6.3-1.67.99 1.84 3 5.56 3.38 6.1.5.7.85.58 1.61.34.6-.18 9.36-3.4 9.75-3.57.4-.16.64-.28.37-.69-.2-.3-2.5-3.46-3.72-5.12l4.1-1.11c.36-.1.41-.28.21-.51-.2-.23-2.94-3.75-3.42-4.34-.49-.6-.73-.49-1.02-.45l-4.18.71c-.4.07-.65.24-.4.6.22.3 2.5 3.62 3 4.35L15.8 17.9 8.56 5.56c-.29-.44-.35-.59-1-.55zm-.12.86c.17 0 .15.03.21.14l6.78 11.97c.12.2.05.27-.05.29L8.9 19.59c-.27.06-.27.04-.3-.06L2.48 6.59c-.09-.16-.08-.29 0-.29l4.96-.44zm19.33 4.99c.07.01.14.06.22.18l2.56 3.33c.08.1-.07.17-.26.22l-3.45.87-2.66-3.73c-.08-.1-.14-.22.05-.24.19-.02 3.2-.59 3.34-.61.07-.02.13-.04.2-.02zm-1.24 5.77c.06 0 .11.05.18.16.14.23 2.93 4.1 3 4.23.09.13.17.22-.09.3-.25.1-8.6 2.99-8.76 3.06-.17.07-.3.1-.5-.22-.2-.31-2.93-5.12-2.93-5.12l8.85-2.35c.11-.04.18-.07.25-.06z',
        'lastfm-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm5.61 5.1C10.25 12.1 9 13.6 9 16.15c0 2.43 1.25 3.75 3.5 3.75 1.81 0 2.68-.85 2.68-.85l-.51-1.4s-.84.94-2.09.94c-1.1 0-1.9-.96-1.9-2.5 0-1.98 1-2.68 1.98-2.68 1.82 0 2.04 1.45 2.76 3.69.51 1.55 1.47 2.8 4.25 2.8 1.99 0 3.33-.6 3.33-2.21 0-2-1.71-2.21-3.14-2.52-.7-.16-.92-.45-.92-.93 0-.55.44-.87 1.14-.87.77 0 1.19.29 1.25.98l1.6-.2c-.12-1.44-1.11-2.03-2.75-2.03-1.44 0-2.85.54-2.85 2.3 0 1.08.53 1.77 1.86 2.1 1.23.28 2.18.37 2.18 1.25 0 .6-.58.83-1.67.83-1.62 0-2.29-.85-2.67-2.02-.88-2.65-1.2-4.46-4.42-4.46z',
        'lastfm' => 'm14.35 22.08-1.03-2.8s-1.67 1.87-4.17 1.87c-2.2 0-3.78-1.93-3.78-5 0-3.95 1.99-5.36 3.94-5.36 2.83 0 3.72 1.83 4.5 4.17l1.02 3.2c1.03 3.12 2.95 5.62 8.5 5.62 3.97 0 6.67-1.22 6.67-4.43 0-2.6-1.48-3.94-4.23-4.58l-2.06-.45c-1.4-.32-1.83-.9-1.83-1.86 0-1.1.87-1.74 2.28-1.74 1.54 0 2.38.58 2.5 1.96l3.21-.38c-.26-2.89-2.25-4.08-5.52-4.08-2.88 0-5.7 1.1-5.7 4.59 0 2.18 1.05 3.56 3.71 4.2l2.19.51c1.63.39 2.18 1.06 2.18 2 0 1.18-1.16 1.66-3.34 1.66-3.24 0-4.59-1.7-5.35-4.04l-1.06-3.2c-1.35-4.18-3.5-5.72-7.77-5.72C4.51 8.22 2 11.2 2 16.27c0 4.88 2.5 7.5 7 7.5 3.62 0 5.35-1.7 5.35-1.7Z',
        'laugh-beam-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'laugh-beam' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'laugh-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'laugh-squint-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'laugh-squint' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'laugh-wink-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6.5 1v2h5v-2h-5zm-9 6s1.61 5 7 5 7-5 7-5H9z',
        'laugh-wink' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6.5 1v2h5v-2h-5zm-9 6s1.61 5 7 5 7-5 7-5H9z',
        'laugh' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM9 19s1.6 5 7 5 7-5 7-5H9z',
        'layer-group-solid' => 'm16 5.94-.38.12-10 4-2.3.94 2.3.94 3.91 1.56-3.9 1.56L3.3 16l2.31.94 3.91 1.56-3.9 1.56L3.3 21l2.31.94 10 4 .38.12.38-.12 10-4 2.3-.94-2.3-.94-3.91-1.56 3.9-1.56L28.7 16l-2.32-.94-3.9-1.56 3.9-1.56L28.7 11l-2.32-.94-10-4Zm0 2.15L23.28 11 16 13.9 8.72 11Zm-3.75 6.5 3.38 1.35.37.12.38-.12 3.37-1.35L23.28 16 16 18.9 8.72 16Zm0 5 3.38 1.35.37.12.38-.12 3.37-1.35L23.28 21 16 23.9 8.72 21Z',
        'leaf-solid' => 'M25.03 4 24 4.47c-3.18 1.4-7.77 1.93-11.69 3.31a12.3 12.3 0 0 0-5.12 3.1A8.8 8.8 0 0 0 5 17c0 2.7 1.59 4.54 3.06 5.6.63.44 1.24.77 1.75 1a20.42 20.42 0 0 0-1.37 3.06A10.07 10.07 0 0 0 8 31.9l2 .18c.06-.72-.13-1.1-.16-1.78-.03-.68.03-1.61.5-3 .95-2.77 3.57-7.33 10.38-14.62l-1.44-1.38c-4.08 4.38-6.72 7.79-8.44 10.53a7.73 7.73 0 0 1-1.62-.87A4.7 4.7 0 0 1 7 17c0-2.2.63-3.66 1.66-4.78a10.44 10.44 0 0 1 4.3-2.56c3.25-1.15 7.25-1.73 10.7-3A46.8 46.8 0 0 1 25 18.53c0 3.69-.86 5.8-1.88 6.97a4.21 4.21 0 0 1-3.3 1.5 6.08 6.08 0 0 1-3.26-1.25c-1-.7-1.7-1.43-2.4-1.88l-1.07 1.7c.18.1 1.18 1.03 2.35 1.84A7.83 7.83 0 0 0 19.81 29c1.54 0 3.42-.54 4.85-2.19 1.42-1.64 2.34-4.28 2.34-8.28 0-7.82-1.66-13.44-1.66-13.44Z',
        'leanpub' => 'M10.34 6C6.95 6 3.41 7.9 3.41 7.9l-.47.26-.06.53L1 24.88l-.19 1.71 1.6-.68s4.11-1.72 8-1.72c2.3 0 5.06 1.65 5.06 1.65l.53.35.53-.35s2.76-1.65 5.06-1.65c3.89 0 8 1.72 8 1.72l1.6.68-.19-1.71-1.88-16.2-.06-.52-.47-.25S25.05 6 21.66 6C18.78 6 16.68 7.26 16 7.69A10.69 10.69 0 0 0 10.34 6Zm0 2c2.59 0 5.1 1.63 5.1 1.63L16 10l.56-.38S19.07 8 21.66 8c2.27 0 4.86 1.19 5.53 1.5l1.62 14.03a21.05 21.05 0 0 0-7.22-1.34c-2.72 0-4.91 1.27-5.59 1.68a11.13 11.13 0 0 0-5.6-1.68c-3.16 0-5.68.79-7.21 1.34L4.8 9.5C5.48 9.19 8.07 8 10.34 8Zm0 1.5c-1.44 0-3.23.63-4.15 1L4.94 21.44c1.96-.5 3.79-.75 5.47-.75 2.13 0 4.18.77 5.59 1.47a13 13 0 0 1 6.03-1.44L20.78 9.59a9.75 9.75 0 0 0-3.4 1.29L16 11.8l-1.4-.94c-.03 0-2.1-1.37-4.26-1.37Z',
        'lemon-solid' => 'M13 4c-2.58 0-4.88 1.44-6.47 3.63A14.3 14.3 0 0 0 4 16c0 3.23.94 6.19 2.53 8.38C8.13 26.55 10.42 28 13 28c8.23 0 12.62-4.7 13.69-9.66A2.9 2.9 0 0 0 28 16c0-1-.56-1.8-1.31-2.34C25.56 8.58 20.3 4 13 4Zm0 2c1.84 0 3.54 1.02 4.84 2.81C19.14 10.61 20 13.16 20 16c0 2.84-.85 5.4-2.16 7.19-1.3 1.8-3 2.81-4.84 2.81-1.84 0-3.54-1.02-4.84-2.81A12.36 12.36 0 0 1 6 16c0-2.84.85-5.4 2.16-7.19C9.46 7.01 11.16 6 13 6Zm6.38 1.53c3.03 1.61 4.99 4.26 5.46 6.84l.1.5.47.22A1 1 0 0 1 26 16a1 1 0 0 1-.6.9l-.46.23-.1.5a9.57 9.57 0 0 1-5.78 7.25c.14-.17.28-.33.4-.5A14.3 14.3 0 0 0 22 16c0-3.23-.94-6.19-2.53-8.38l-.1-.09ZM13 8c-.71 0-1.39.26-2 .69l2.03 4.78 2.06-4.75A3.53 3.53 0 0 0 13 8Zm-3.5 2.28A10.38 10.38 0 0 0 8.03 15h3.47Zm7.06.1L14.53 15h3.44a10.4 10.4 0 0 0-1.4-4.63ZM8.03 17c.14 1.8.65 3.4 1.4 4.63L11.48 17Zm6.47 0 2 4.72A10.38 10.38 0 0 0 17.97 17Zm-1.53 1.53-2.06 4.75c.63.47 1.35.72 2.09.72.71 0 1.39-.26 2-.69Z',
        'lemon' => 'M13 4c-2.58 0-4.88 1.44-6.47 3.63A14.3 14.3 0 0 0 4 16c0 3.23.94 6.19 2.53 8.38C8.13 26.55 10.42 28 13 28c8.23 0 12.62-4.7 13.69-9.66A2.9 2.9 0 0 0 28 16c0-1-.56-1.8-1.31-2.34C25.56 8.58 20.3 4 13 4Zm0 2c1.84 0 3.54 1.02 4.84 2.81C19.14 10.61 20 13.16 20 16c0 2.84-.85 5.4-2.16 7.19-1.3 1.8-3 2.81-4.84 2.81-1.84 0-3.54-1.02-4.84-2.81A12.36 12.36 0 0 1 6 16c0-2.84.85-5.4 2.16-7.19C9.46 7.01 11.16 6 13 6Zm6.38 1.53c3.03 1.61 4.99 4.26 5.46 6.84l.1.5.47.22A1 1 0 0 1 26 16a1 1 0 0 1-.6.9l-.46.23-.1.5a9.57 9.57 0 0 1-5.78 7.25c.14-.17.28-.33.4-.5A14.3 14.3 0 0 0 22 16c0-3.23-.94-6.19-2.53-8.38l-.1-.09ZM13 8c-.71 0-1.39.26-2 .69l2.03 4.78 2.06-4.75A3.53 3.53 0 0 0 13 8Zm-3.5 2.28A10.38 10.38 0 0 0 8.03 15h3.47Zm7.06.1L14.53 15h3.44a10.4 10.4 0 0 0-1.4-4.63ZM8.03 17c.14 1.8.65 3.4 1.4 4.63L11.48 17Zm6.47 0 2 4.72A10.38 10.38 0 0 0 17.97 17Zm-1.53 1.53-2.06 4.75c.63.47 1.35.72 2.09.72.71 0 1.39-.26 2-.69Z',
        'less-than-equal-solid' => 'M26 5 6 13.22v1.56L26 23v-2.16L9.47 14 26 7.16ZM6 25v2h20v-2Z',
        'less-than-solid' => 'M26 6 6 15.22v1.56L26 26v-2.16L9.47 16 26 8.16Z',
        'less' => 'M3.26 9.15c-1.42 0-2.05.55-2.05 2.26 0 1.13.16 1.76.16 2.73 0 .55-.34 1.13-1.37 1.18v1.37c1.03.02 1.37.6 1.37 1.15 0 .97-.16 1.55-.16 2.68 0 1.71.63 2.26 2.02 2.26h1.03v-1.21h-.32c-.65 0-.86-.26-.86-1.13 0-.86.08-1.6.08-2.57 0-1.21-.4-1.68-1.18-1.87v-.08c.79-.18 1.18-.65 1.18-1.86 0-.95-.08-1.71-.08-2.58 0-.86.18-1.1.86-1.1h.7v7.54c0 1.6.56 2.65 2.16 2.65.5 0 .9-.08 1.18-.18l-.26-1.71c-.16.04-.23.04-.31.04-.19 0-.42-.16-.42-.66V9.15H3.26zm24.48 0v1.22h.32c.71 0 .87.23.87 1.1 0 .82-.08 1.63-.08 2.58 0 1.2.39 1.68 1.18 1.86V16c-.8.19-1.18.66-1.18 1.87 0 .94.08 1.7.08 2.57 0 .9-.19 1.13-.87 1.13v.03h-.32v1.26h1.03c1.39 0 2.02-.55 2.02-2.26 0-1.13-.16-1.71-.16-2.73 0-.55.35-1.13 1.37-1.18V15.3c-1.02-.03-1.37-.61-1.37-1.16 0-1.03.16-1.63.16-2.73 0-1.71-.63-2.26-2.02-2.26h-1.03zm-16.5 3.16c-1.92 0-3.75 1.6-3.7 4.12 0 2.6 1.7 4.13 3.96 4.13.95 0 2-.34 2.81-.9l-.79-1.39a3.3 3.3 0 0 1-1.7.5c-1.06 0-1.87-.5-2.08-1.7h4.76c.02-.2.08-.56.08-.98.03-2.13-1.13-3.78-3.34-3.78zm7.07.02c-1.79 0-3 1.03-3 2.47 0 1.29 1.13 1.95 2.08 2.31.81.32 1.6.58 1.6 1.1 0 .4-.31.66-1.02.66a3.3 3.3 0 0 1-2.03-.81l-1.02 1.52c.79.66 2 1.1 3 1.1 2.1 0 3.22-1.1 3.22-2.54 0-1.45-1.12-2.05-2.15-2.4-.81-.3-1.55-.5-1.55-1.02 0-.4.32-.63.9-.63.58 0 1.1.24 1.68.66l1.05-1.4a4.46 4.46 0 0 0-2.76-1.02zm6.38 0c-1.78 0-3 1.03-3 2.47 0 1.29 1.14 1.95 2.08 2.31.82.32 1.6.58 1.6 1.1 0 .4-.3.66-1.02.66a3.3 3.3 0 0 1-2.02-.81l-1.05 1.52c.79.66 2 1.1 3 1.1 2.1 0 3.23-1.1 3.23-2.54 0-1.45-1.13-2.05-2.16-2.4-.79-.3-1.52-.5-1.52-1.02 0-.4.31-.63.9-.63.57 0 1.1.24 1.67.66l1.05-1.4a4.46 4.46 0 0 0-2.76-1.02zm-13.42 1.74c.94 0 1.31.65 1.31 1.55H9.74c.16-1.05.8-1.55 1.53-1.55z',
        'level-down-alt-solid' => 'M4.5 4.5v3h15v15.36l-3.78-3.79-2.15 2.15 6.36 6.36L21 28.6l1.07-1.02 6.36-6.36-2.15-2.15-3.78 3.79V4.5h-18zm1 1h16v19.77l4.78-4.78.73.73-5.64 5.64-.37.35-.37-.35L15 21.22l.73-.73 4.78 4.78V6.5h-15v-1z',
        'level-up-alt-solid' => 'm17 4-.72.69-8.5 8.5 1.44 1.44L16 7.84V26H6v2h12V7.84l6.78 6.79 1.44-1.44-8.5-8.5L17 4z',
        'life-ring-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c.34 0 .67.03 1 .06V9.1c-.33-.04-.66-.09-1-.09-.34 0-.67.05-1 .1V6.05c.33-.03.66-.06 1-.06Zm-3 .44v3.25A7.01 7.01 0 0 0 9.69 13H6.47A9.98 9.98 0 0 1 13 6.44Zm6 0c3.11.97 5.59 3.45 6.56 6.56h-3.25A7 7 0 0 0 19 9.69ZM16 11a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm-9.94 4h3a7.05 7.05 0 0 0 .03 2H6.06c-.03-.33-.06-.66-.06-1 0-.34.03-.67.06-1Zm16.85 0h3.03c.03.33.06.66.06 1 0 .34-.03.67-.06 1H22.9c.04-.33.09-.66.09-1 0-.34-.05-.67-.1-1ZM6.44 19h3.25A7 7 0 0 0 13 22.31v3.25A10.07 10.07 0 0 1 6.44 19Zm15.87 0h3.25A10.07 10.07 0 0 1 19 25.56v-3.25A7 7 0 0 0 22.31 19ZM15 22.9c.33.05.66.1 1 .1.34 0 .67-.05 1-.1v3.04c-.33.03-.66.06-1 .06-.34 0-.67-.03-1-.06Z',
        'life-ring' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c.34 0 .67.03 1 .06V9.1c-.33-.04-.66-.09-1-.09-.34 0-.67.05-1 .1V6.05c.33-.03.66-.06 1-.06Zm-3 .44v3.25A7.01 7.01 0 0 0 9.69 13H6.47A9.98 9.98 0 0 1 13 6.44Zm6 0c3.11.97 5.59 3.45 6.56 6.56h-3.25A7 7 0 0 0 19 9.69ZM16 11a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm-9.94 4h3a7.05 7.05 0 0 0 .03 2H6.06c-.03-.33-.06-.66-.06-1 0-.34.03-.67.06-1Zm16.85 0h3.03c.03.33.06.66.06 1 0 .34-.03.67-.06 1H22.9c.04-.33.09-.66.09-1 0-.34-.05-.67-.1-1ZM6.44 19h3.25A7 7 0 0 0 13 22.31v3.25A10.07 10.07 0 0 1 6.44 19Zm15.87 0h3.25A10.07 10.07 0 0 1 19 25.56v-3.25A7 7 0 0 0 22.31 19ZM15 22.9c.33.05.66.1 1 .1.34 0 .67-.05 1-.1v3.04c-.33.03-.66.06-1 .06-.34 0-.67-.03-1-.06Z',
        'lightbulb-solid' => 'M16 4c-4.96 0-9 4.04-9 9 0 1.92.84 3.9 2 5.69a15.56 15.56 0 0 0 3 3.47V25c0 1.1.9 2 2 2l1 1h2l1-1a2 2 0 0 0 2-2v-2.84a15.56 15.56 0 0 0 3-3.47c1.16-1.78 2-3.77 2-5.69 0-4.96-4.04-9-9-9Zm0 2c3.88 0 7 3.12 7 7 0 1.3-.64 3.04-1.66 4.6a13.24 13.24 0 0 1-3.18 3.4h-4.32a12.99 12.99 0 0 1-3.18-3.4C9.64 16.03 9 14.3 9 13c0-3.88 3.12-7 7-7Zm-1.75 17h3.5a1 1 0 0 0 .25.13V25h-4v-1.88a1 1 0 0 0 .25-.12Z',
        'lightbulb' => 'M16 4c-4.96 0-9 4.04-9 9 0 1.92.84 3.9 2 5.69a15.56 15.56 0 0 0 3 3.47V25c0 1.1.9 2 2 2l1 1h2l1-1a2 2 0 0 0 2-2v-2.84a15.56 15.56 0 0 0 3-3.47c1.16-1.78 2-3.77 2-5.69 0-4.96-4.04-9-9-9Zm0 2c3.88 0 7 3.12 7 7 0 1.3-.64 3.04-1.66 4.6a13.24 13.24 0 0 1-3.18 3.4h-4.32a12.99 12.99 0 0 1-3.18-3.4C9.64 16.03 9 14.3 9 13c0-3.88 3.12-7 7-7Zm-1.75 17h3.5a1 1 0 0 0 .25.13V25h-4v-1.88a1 1 0 0 0 .25-.12Z',
        'line' => 'M9.63 5A4.65 4.65 0 0 0 5 9.63v12.74A4.65 4.65 0 0 0 9.63 27h12.74A4.65 4.65 0 0 0 27 22.37V9.63A4.65 4.65 0 0 0 22.37 5Zm0 2h12.74A2.62 2.62 0 0 1 25 9.63v12.74A2.62 2.62 0 0 1 22.37 25H9.63A2.62 2.62 0 0 1 7 22.37V9.63A2.62 2.62 0 0 1 9.63 7ZM16 9.22c-4.02 0-7.28 2.65-7.28 5.9 0 2.93 2.6 5.36 6.1 5.82.23.05.54.17.62.37.07.19.05.47.03.66l-.1.62c-.03.19-.15.74.63.41s4.2-2.5 5.72-4.25a5.24 5.24 0 0 0 1.56-3.63c0-3.25-3.26-5.9-7.28-5.9Zm-4.28 4.19c.21 0 .37.16.37.37v2.5h1.07c.2 0 .37.2.37.4 0 .22-.16.38-.37.38h-1.44c-.21 0-.4-.16-.4-.37v-2.9c0-.22.19-.38.4-.38Zm2.56 0c.21 0 .38.16.38.37v2.9c0 .22-.17.38-.38.38s-.4-.16-.4-.37v-2.9c0-.22.19-.38.4-.38Zm1.19 0c.04-.02.08 0 .12 0 .12 0 .21.05.29.15l1.5 2v-1.78c0-.21.16-.37.37-.37s.38.16.38.37v2.9c0 .17-.1.3-.25.35l-.13.03a.4.4 0 0 1-.31-.15l-1.47-2.04v1.82c0 .2-.17.37-.38.37-.2 0-.4-.16-.4-.37v-2.9a.4.4 0 0 1 .28-.38Zm3.56 0h1.44c.21 0 .37.16.37.37s-.16.38-.37.38H19.4v.68h1.06c.21 0 .37.17.37.38s-.16.4-.37.4H19.4v.66h1.06c.21 0 .37.2.37.4 0 .22-.16.38-.37.38h-1.44a.37.37 0 0 1-.37-.37v-2.9c0-.22.16-.38.37-.38Z',
        'link-solid' => 'M21.75 4c-1.67 0-3.26.66-4.44 1.84l-1.47 1.47a6.25 6.25 0 0 0-1.4 6.72l1.62-1.62c-.2-1.3.2-2.7 1.19-3.7l1.47-1.46a4.28 4.28 0 0 1 6.03 0 4.27 4.27 0 0 1 0 6.03l-1.47 1.47a4.28 4.28 0 0 1-3.69 1.19l-1.62 1.62a6.24 6.24 0 0 0 6.72-1.4l1.47-1.47A6.25 6.25 0 0 0 21.75 4Zm-2.47 7.28-8 8 1.44 1.44 8-8ZM11.75 14c-1.67 0-3.26.66-4.44 1.84l-1.47 1.47a6.25 6.25 0 1 0 8.85 8.85l1.47-1.47a6.25 6.25 0 0 0 1.4-6.72l-1.62 1.62c.2 1.3-.2 2.7-1.19 3.7l-1.47 1.46a4.28 4.28 0 0 1-6.03 0 4.27 4.27 0 0 1 0-6.03l1.47-1.47a4.28 4.28 0 0 1 3.69-1.19l1.62-1.62a6.16 6.16 0 0 0-2.28-.44Z',
        'linkedin-in' => 'M8.64 4A2.64 2.64 0 0 0 6 6.64a2.66 2.66 0 0 0 2.64 2.67 2.66 2.66 0 0 0 2.64-2.67A2.64 2.64 0 0 0 8.64 4zm12.9 7a4.38 4.38 0 0 0-4.1 2.31h-.07v-2H13V26h4.56v-7.27c0-1.92.14-3.77 2.51-3.77 2.34 0 2.37 2.19 2.37 3.89V26H27v-8.07c0-3.95-.85-6.93-5.46-6.93zm-15.18.31V26h4.56V11.31H6.36z',
        'linkedin' => 'M7.5 5A2.52 2.52 0 0 0 5 7.5v17C5 25.87 6.13 27 7.5 27h17c1.37 0 2.5-1.13 2.5-2.5v-17C27 6.13 25.87 5 24.5 5Zm0 2h17c.29 0 .5.21.5.5v17c0 .29-.21.5-.5.5h-17a.49.49 0 0 1-.5-.5v-17c0-.29.21-.5.5-.5Zm2.94 1.72a1.72 1.72 0 1 0 0 3.44 1.72 1.72 0 0 0 0-3.44Zm9.03 4.56a3.1 3.1 0 0 0-2.78 1.53h-.07V13.5h-2.8V23h2.93v-4.69c0-1.24.25-2.43 1.78-2.43 1.51 0 1.53 1.4 1.53 2.5V23H23v-5.22c0-2.55-.54-4.5-3.53-4.5ZM9 13.5V23h2.97v-9.5Z',
        'linode' => 'M11.5 3 5.53 4.9l4.34 2.66 6.38-2.4-4.38-2.1A.9.9 0 0 0 11.5 3ZM5 5.84l1.31 6.35c0 .1.12.2.22.31l3.81 3-1.03-7.03Zm11.72.25L10.4 8.47l1.06 6.97 5.25-2.72c.16-.06.25-.26.25-.47Zm6.25 6.13c-.1 0-.2.04-.28.1l-2.97 1.87 3.47 2.15 3.18-2.3-3.15-1.73a.46.46 0 0 0-.25-.1ZM6.72 13.97l1.12 5.56c0 .1.05.23.16.28l3.47 3.25-.85-6Zm10.31 0-5.25 3 .72 6.1 4.53-3.04c.16-.1.27-.29.22-.5Zm9.97.9-.1.1c-.05.05-.04.12-.09.12l-3.22 2.2-.15 3.37v.18l2.87-2.25c.1-.1.17-.2.22-.3Zm-8.4.07a.7.7 0 0 0-.32.1l-.1.05.16 4.44c0 .1 0 .27-.06.38l3.78-2.79-3.18-2.09a.55.55 0 0 0-.29-.1Zm4.06 3.03-4.22 2.94.12 3.62v.28l3.66-2.9c.1-.1.22-.22.22-.38ZM8.3 21.22l.78 4.22c0 .1.05.14.16.25L12.41 29l-.1-.22-.69-4.34Zm9.13.06-4.72 3.03.62 4.38.07.31 3.93-3.16c.16-.1.22-.25.22-.4Z',
        'linux' => 'M16 5C10.49 5 6 9.49 6 15v8c0 1.12-.88 2-2 2v2c2.2 0 4-1.8 4-4v-8a7.99 7.99 0 0 1 10.88-7.47c-.3.42-.14 1.15.4 1.69.59.58 1.4.73 1.78.34.15-.14.19-.36.19-.6A7.98 7.98 0 0 1 24 15v8c0 2.2 1.8 4 4 4v-2c-1.12 0-2-.88-2-2v-8c0-5.51-4.49-10-10-10Zm-3 6a3.7 3.7 0 0 0-3.25 1.88A6.35 6.35 0 0 0 9 16c0 1.36.41 2.35.88 2.97l.12.16c-.61.65-1 1.46-1 2.37 0 1.43.97 2.6 2.25 3.34A9.48 9.48 0 0 0 16 26c1.82 0 3.47-.41 4.75-1.16C22.03 24.1 23 22.93 23 21.5c0-.9-.39-1.72-1-2.38l.13-.15c.46-.62.87-1.61.87-2.97 0-.95-.17-2.1-.75-3.13A3.7 3.7 0 0 0 19 11c-1.33 0-2.37.65-3 1.5a3.69 3.69 0 0 0-3-1.5Zm0 2c.87 0 1.21.31 1.53.88.32.56.47 1.41.47 2.12h2c0-.7.15-1.56.47-2.13.32-.56.66-.87 1.53-.87s1.21.31 1.53.88c.32.56.47 1.41.47 2.12a2.83 2.83 0 0 1-.66 1.97c-.22-.11-.44-.25-.68-.34.2-.28.34-.68.34-1.13 0-.83-.45-1.5-1-1.5s-1 .67-1 1.5c0 .27.08.5.16.72a10.96 10.96 0 0 0-4.32 0c.08-.22.16-.45.16-.72 0-.83-.45-1.5-1-1.5s-1 .67-1 1.5c0 .45.13.85.34 1.13-.24.09-.46.23-.68.34A2.83 2.83 0 0 1 11 16c0-.7.15-1.56.47-2.13.32-.56.66-.87 1.53-.87Zm3 6c1.5 0 2.86.35 3.75.88.9.52 1.25 1.12 1.25 1.62s-.36 1.1-1.25 1.63A7.7 7.7 0 0 1 16 24a7.7 7.7 0 0 1-3.75-.88C11.35 22.6 11 22 11 21.5s.36-1.1 1.25-1.63A7.7 7.7 0 0 1 16 19Zm-2.5 1.44-1 1.72s1.43.84 3.5.84c2.07 0 3.5-.84 3.5-.84l-1-1.72s-.95.56-2.5.56-2.5-.56-2.5-.56Z',
        'lira-sign-solid' => 'M11 4v5.9L8 11v2l3-1.1v2L8 15v2l3-1.1V28h1c5.76 0 10.83-3.85 12.34-9.4l.63-2.35-1.94-.5-.62 2.31A10.69 10.69 0 0 1 13 25.84V15.2l6-2.2v-2l-6 2.19v-2L19 9V7l-6 2.19V4Z',
        'list-alt-solid' => 'M10.28 5.28 7 8.56 5.72 7.28 4.28 8.72l2 2 .72.69.72-.7 4-4ZM15 7v2h13V7Zm-4.72 6.28L7 16.56l-1.28-1.28-1.44 1.44 2 2 .72.69.72-.7 4-4ZM15 15v2h13v-2Zm-4.72 6.28L7 24.56l-1.28-1.28-1.44 1.44 2 2 .72.69.72-.7 4-4ZM15 23v2h13v-2Z',
        'list-alt' => 'M10.28 5.28 7 8.56 5.72 7.28 4.28 8.72l2 2 .72.69.72-.7 4-4ZM15 7v2h13V7Zm-4.72 6.28L7 16.56l-1.28-1.28-1.44 1.44 2 2 .72.69.72-.7 4-4ZM15 15v2h13v-2Zm-4.72 6.28L7 24.56l-1.28-1.28-1.44 1.44 2 2 .72.69.72-.7 4-4ZM15 23v2h13v-2Z',
        'list-ol-solid' => 'm5.97 3-.31.34S4.9 4 4.4 4v2c.68 0 1.14-.28 1.59-.53V10h2V3ZM11 6v2h17V6Zm-4.5 6A2.5 2.5 0 0 0 4 14.5v.5h2v-.5c0-.21.29-.5.5-.5.21 0 .5.29.5.5l-.1.1-2.59 2.5-.31.27V19h5v-2H7.28l.88-.88.12-.09-.03-.03c.5-.41.75-1.02.75-1.5A2.5 2.5 0 0 0 6.5 12Zm4.5 3v2h17v-2Zm-7 6v2h1.38l-.25.4-.13.23V25h1.5c.21 0 .5.29.5.5 0 .21-.29.5-.5.5H4v2h2.5A2.5 2.5 0 0 0 9 25.5c0-1-.68-1.7-1.53-2.1l.4-.68.13-.25V21Zm7 3v2h17v-2Z',
        'list-solid' => 'M4 5v6h6V5Zm2 2h2v2H6Zm6 0v2h15V7Zm-8 6v6h6v-6Zm2 2h2v2H6Zm6 0v2h15v-2Zm-8 6v6h6v-6Zm2 2h2v2H6Zm6 0v2h15v-2Z',
        'list-ul-solid' => 'M4 5v6h6V5Zm2 2h2v2H6Zm6 0v2h15V7Zm-8 6v6h6v-6Zm2 2h2v2H6Zm6 0v2h15v-2Zm-8 6v6h6v-6Zm2 2h2v2H6Zm6 0v2h15v-2Z',
        'location-arrow-solid' => 'm16 4.44-.9 2.18-8 19-.91 2.13 2.15-.81L16 24.06l7.66 2.88 2.15.81-.9-2.13-8-19Zm0 5.1 6.19 14.71-5.85-2.19-.34-.12-.34.12-5.85 2.19Z',
        'lock-open-solid' => 'M16 3a7.17 7.17 0 0 0-6.63 4.63l1.85.75A5.21 5.21 0 0 1 16 5c2.75 0 5 2.25 5 5v3H6v16h20V13h-3v-3c0-3.84-3.16-7-7-7ZM8 15h16v12H8Z',
        'lock-solid' => 'M16 3c-3.84 0-7 3.16-7 7v3H6v16h20V13h-3v-3c0-3.84-3.16-7-7-7Zm0 2c2.75 0 5 2.25 5 5v3H11v-3c0-2.75 2.25-5 5-5ZM8 15h16v12H8Z',
        'long-arrow-alt-down-solid' => 'M15 4v20.06l-4.28-4.28-1.44 1.4L16 27.92l6.72-6.72-1.44-1.4L17 24.05V4Z',
        'long-arrow-alt-left-solid' => 'M10.81 9.28 4.1 16l6.72 6.72 1.4-1.44L7.95 17H28v-2H7.94l4.28-4.28Z',
        'long-arrow-alt-right-solid' => 'm21.19 9.28-1.4 1.44L24.05 15H4v2h20.06l-4.28 4.28 1.4 1.44L27.92 16Z',
        'long-arrow-alt-up-solid' => 'm16 4.1-6.72 6.7 1.44 1.4L15 7.95V28h2V7.94l4.28 4.28 1.44-1.4Z',
        'low-vision-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44-6.6-6.6a24.47 24.47 0 0 0 5.66-4.96l.22-.28v-.9l-.25-.29C28.5 14.95 22.52 8 16 8c-1.9 0-3.68.53-5.28 1.28ZM16 10c4.65 0 9.28 4.48 10.75 6.03a22 22 0 0 1-5.06 4.22L19.44 18a4 4 0 0 0-.63-4.84 3.94 3.94 0 0 0-4.81-.6l-1.75-1.75c1.18-.47 2.43-.81 3.75-.81Zm-8.25 1.03c-2.68 1.93-4.4 4.1-4.53 4.25l-.22.25v.94l.25.28C3.51 17.05 9.72 24 16 24c1.4 0 2.75-.27 4-.72Zm.63 2.06 8.8 8.82a7.54 7.54 0 0 1-2.66-.06l-7.55-7.6c.41-.38.9-.76 1.4-1.16Zm-2.16 1.85 6.31 6.28c-3.24-1.35-6.15-4.1-7.28-5.25.23-.27.57-.64.97-1.03Z',
        'luggage-cart-solid' => 'M19 6c-1.64 0-3 1.36-3 3h-6v12h18V9h-6c0-1.64-1.36-3-3-3ZM4 7v2h1a1 1 0 0 1 1 1v11a4 4 0 0 0 4 4h18v-2H10c-1.2 0-2-.8-2-2V10c0-1.64-1.36-3-3-3Zm20.5 18a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-12 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM19 8a1 1 0 0 1 1 1h-2a1 1 0 0 1 1-1Zm-7 3h14v8H12Z',
        'lyft' => 'M2 8v11a3 3 0 0 0 3 3h2.06A3.49 3.49 0 0 1 6 19.5V8H2zm20.5 0a5.5 5.5 0 0 0-5.5 5.5V22a4 4 0 0 0 4-4h2v-4h-2v-.5a1.5 1.5 0 0 1 3 0V17a5 5 0 0 0 5 5h1v-4a2 2 0 0 1-2-2h2v-4h-2.21a5.5 5.5 0 0 0-5.29-4zM7 12v7a3 3 0 0 0 3 3h.5c.7 0 1.37-.21 1.92-.58A3.46 3.46 0 0 1 8 22.65v2.93c.61.27 1.29.42 2 .42h1c2.75 0 5-2.25 5-5v-9h-4v5.5a.5.5 0 0 1-.5.5.5.5 0 0 1-.5-.5V12H7z',
        'magento' => 'M16 3.23 5 10.17v12.27l3 1.71V11.83l8-5.06 8 5.06v12.32l3-1.71V10.17L16 3.23zm-2 8.35-3 1.88v12.4l5 2.87 5-2.86V13.48l-3-1.88v12.53l-2 1.14-2-1.14V11.58z',
        'magic-solid' => 'm20.88 2.56-.7.75L18.5 5.1h-3.6v3.5l-1.71 1.82-.69.71 2.19 2.2L3.03 25l-.72.72.72.69 3.28 3.28.69-.72L18.69 17.3l2.18 2.19.72-.69 1.82-1.72h3.5V13.5l1.78-1.69.75-.69L26.9 8.6V5.1h-3.5Zm.03 2.88 1.37 1.37.31.28h2.32v2.32l.28.3 1.37 1.38-1.34 1.29-.31.28v2.43h-2.32l-.28.29-1.4 1.34-.82-.81 4.54-4.54-3.97-3.96-.72.68-3.82 3.85-.84-.85 1.35-1.4.28-.28V7.09h2.43l.29-.3Zm-.25 4.78 1.12 1.15-15.47 15.5-1.15-1.15ZM19 21v1h-1v2h1v1h2v-1h1v-2h-1v-1Zm6 2v2h-2v2h2v2h2v-2h2v-2h-2v-2Z',
        'magnet-solid' => 'M16 5C9.94 5 5 9.94 5 16v11h8V16c0-1.67 1.33-3 3-3s3 1.33 3 3v11h8V16c0-6.06-4.94-11-11-11Zm0 2c4.98 0 9 4.02 9 9v5h-4v-5c0-2.75-2.25-5-5-5s-5 2.25-5 5v5H7v-5c0-4.98 4.02-9 9-9ZM7 23h4v2H7Zm14 0h4v2h-4Z',
        'mail-bulk-solid' => 'M6 5v10H2v13h17v-4h11V11h-7V5H6zm2 2h13v4h-9v4H8V7zm6 6h14v9h-9v-7h-5v-2zm9 2v2h3v-2h-3zM4 17h13v1.11l-6.04 3.76a.88.88 0 0 1-.92 0L4 18.12V17zm13 3.47V26H4v-5.53l4.98 3.1a2.87 2.87 0 0 0 3.04 0l4.98-3.1z',
        'mailchimp' => 'M14.73 4C10.2 4.35 1.95 14.3 5.1 16.96l.78.67a3.87 3.87 0 0 0-.21 1.8 3.78 3.78 0 0 0 3.6 3.22c3.1 7.12 14.33 7.13 17.23.16.1-.24.49-1.31.49-2.26 0-.95-.54-1.35-.88-1.35-.18-.63-.3-.7-.52-1 .13-.2.82-1.28-.16-2.31a5.27 5.27 0 0 0-2.05-1.1c-.08-.6.25-3.13-1.15-4.43C23.35 9.2 24 7.93 24 6.84c0-2.1-2.53-2.73-5.7-1.42l-.67.29-1.23-1.2a2.2 2.2 0 0 0-1.67-.5zm.41.87c.13 0 .25.03.37.06.3.08 1.28 1.22 1.28 1.22s-1.83 1.01-3.52 2.43c-2.28 1.75-4 4.3-5.04 7.07a3.1 3.1 0 0 0-1.96 1.26 5.44 5.44 0 0 1-.83-.8c-.7-1.33.76-3.9 1.78-5.36 2.36-3.37 5.97-5.97 7.92-5.88zm3.19 3.27c.02 0 .04.02.04.04s0 .03-.02.04c-.15.12-.29.26-.4.41-.02.02-.02.04 0 .06h.02c.66 0 1.59.24 2.2.58.04.02 0 .1-.04.09a9.18 9.18 0 0 0-7.19 1.43c-.02.02-.04.01-.05 0a.04.04 0 0 1 0-.06c.89-1.03 2-1.93 2.98-2.43.02-.01.04 0 .05.01v.04a2.9 2.9 0 0 0-.28.68c0 .02.01.04.04.04h.03a5.82 5.82 0 0 1 2.62-.93zm3.18 3.22c.12.02.24.07.35.14.53.35.6 1.21.64 1.84l.07 1.48c.03.57.18.65.49.74l.56.17c.7.2.97.5 1.24.76.14.13.23.3.26.5.08.6-.33 1.25-1.8 1.93-2.5 1.16-5 .78-5.37.73-1.08-.14-1.69 1.25-1.04 2.2 1.2 1.8 6.54 1.07 8.09-1.14.03-.05 0-.08-.04-.05-2.24 1.53-5.19 2.04-6.87 1.4-.25-.1-.79-.35-.85-.9 2.33.72 3.8.04 3.8.04s.1-.15-.04-.14c0 0-1.9.28-3.71-.38.33-1.07 1.44.33 5.15-.73a7.5 7.5 0 0 0 2.58-1.26c.24.26.45.75.53 1.2.2-.04.76-.03.6.97a4.96 4.96 0 0 1-1.38 2.71 5.7 5.7 0 0 1-1.66 1.25c-.35.18-.71.34-1.09.46-2.86.93-5.79-.1-6.73-2.3a4.57 4.57 0 0 1 .82-4.82c.06-.07.13-.15.13-.25a.45.45 0 0 0-.1-.25c-.38-.54-1.67-1.46-1.41-3.25.18-1.28 1.3-2.18 2.35-2.13l.27.01c.45.03.85.09 1.22.1.63.03 1.19-.06 1.85-.61.23-.19.4-.35.71-.4a.92.92 0 0 1 .38-.02zm-.2 2.17c-.34.05-.35.47-.23 1.04.07.32.19.6.32.76.17-.02.33-.02.5 0 .09-.2.1-.55.02-.94-.12-.57-.28-.91-.61-.86zm-3.82 1.55c-.28.04-.56.14-.8.32-.15.11-.3.28-.28.37.04.2.53-.14 1.2-.18.38-.03.69.1.93.2.24.1.38.17.44.11.1-.1-.19-.5-.65-.7a1.68 1.68 0 0 0-.84-.12zm4.3.8c-.41 0-.43.85-.01.85.4 0 .42-.84 0-.85zm-3.73.18c-.49.08-.8.35-.72.54.04.02.06.04.27-.04a1.9 1.9 0 0 1 1-.1c.16.01.23.02.27-.03.08-.12-.3-.43-.82-.37zm2.35.4a.27.27 0 0 0-.22.14c-.18.37.58.74.76.37.14-.27-.26-.55-.54-.52zm-11.51.02c.97.03 1.92.72 2.14 2.19.25 1.58-.25 3.12-1.82 3.09a2.92 2.92 0 0 1-2.67-2.43c-.18-1.85 1.1-2.89 2.35-2.85zm-.07.92a1.2 1.2 0 0 0-.9.36c-.47.52-.47 1.26-.27 1.3.23.02.22-.35.4-.63.2-.32.63-.4.94-.2h.01c.62.4.07.95.12 1.53.07.9.99.87 1.16.48a.11.11 0 0 0-.02-.12c0 .04.04-.07-.17-.02-.08.01-.33.08-.46-.13-.28-.43.6-1.09.16-1.9-.24-.48-.61-.66-.97-.67z',
        'male-solid' => 'M16 2c-2.2 0-4 1.8-4 4 0 1.07.43 2.03 1.13 2.75A6.02 6.02 0 0 0 10 14v5.4l.28.32L12 21.44V30h2v-9.4l-.28-.32L12 18.56V14c0-2.22 1.78-4 4-4 2.22 0 4 1.78 4 4v4.56l-1.72 1.72-.28.31V30h2v-8.56l1.72-1.72.28-.31V14a6.02 6.02 0 0 0-3.13-5.25A3.96 3.96 0 0 0 20 6c0-2.2-1.8-4-4-4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'mandalorian' => 'm19.65 2-.26.12c-.24.12-.26.13-.83.15l-.59.02-.24.13c-.22.13-.24.13-.38.1a1.3 1.3 0 0 1-.27-.13.99.99 0 0 0-.33-.1 1.65 1.65 0 0 1-.32-.07c-.1-.05-.15-.04-.35.02-.1.03-.21.06-.32.07-.14.02-.28.05-.42.1a1.3 1.3 0 0 1-.4.06c-.12-.03-.4.1-.48.23-.16.27-.46.72-.33 1.05.18.24.85.06.84.47-.12.5-.3.96-.47 1.44l-.62-.14c.4-1.38.34-.85-.77-1.59.02-.13.07-.25.13-.37a3 3 0 0 0 .3-.5.35.35 0 0 1 .07-.12c.09-.11.1-.38.01-.46-.08-.09-.17-.1-.64-.09-.38 0-.44.02-.62.11a4.3 4.3 0 0 0-.58.46l-.38.36.02.71v.71l.14.28c.13.27.28.42.62.65l.14.1.26.22.34.27c.22.2.47.34.73.43.49.18.62.35.7.95.06.32.2.77.28.88a6.25 6.25 0 0 1 .28 1.18c0 .07.03.2.05.3.06.32.1.64.1.97 0 .13 0 .16-.11.23a.5.5 0 0 1-.19.08c-.08 0-.22-.3-.3-.61-.1-.49-.26-.69-.54-.73-.24-.04-.65-.34-1.26-.93a1.02 1.02 0 0 0-.26-.15c-.4-.17-.65-.34-.83-.58-.11-.15-.12-.18-.12-.4 0-.2.03-.4.06-.61.07-.48.06-.75-.01-1.01-.1-.33-.34-.47-.52-.28-.15.17-.45.99-.58 1.6-.05.28-.12.43-.24.59a.23.23 0 0 0-.05.21 3.29 3.29 0 0 0 .47.96l.1.17-.08.25c-.12.42-.12.4.03.53.08.06.42.39.75.72.7.69.82.76 1.3.8.3.01.43.06.48.16l.03.66c.02 1.4.02 1.38.34 1.82l.18.25.05.48c.06.57.06 2.37 0 3.22l-.04.6.1.15c.06.09.38.43.7.76.47.46.64.66.73.84l.13.24-.03.91c0 .5-.04.98-.06 1.05-.02.07-.06.5-.1.97a87.36 87.36 0 0 1-.37 4.38c-.07.28-.05.33.15.54.25.25.65.56.69.52.06-.07.1-.67.13-1.57l.03-1.15a596.61 596.61 0 0 0 .15-4.3c.02-.32 0-.57-.13-1.1a4.71 4.71 0 0 1-.1-.56 2.13 2.13 0 0 0-.1-.5.73.73 0 0 1-.08-.23l-.02-.08c-.05-.1-.1-.7-.1-1.35a2.5 2.5 0 0 0-.25-1.29c-.1-.18-.57-.88-.75-1.08l-.11-.13.02-.66c.02-.71.07-1.04.16-1.2.08-.15.16-.12.25.08.09.18.18.28.56.62.29.25.4.4.4.54a.76.76 0 0 1-.09.25c-.13.26-.12.55.06 1.15.08.26.15.55.17.65 0 .09.04.18.08.26.05.08.05.08.1.03a.54.54 0 0 0 .1-.23 17.15 17.15 0 0 1 .14-.9 1.57 1.57 0 0 0-.15-1.11c-.05-.03-.05-.25 0-.43.06-.17.24-.35.7-.68a2.54 2.54 0 0 0 .58-.55c.12 0 .1.5-.02.84-.1.27-.18.54-.24.82l-.25 1.13a4.5 4.5 0 0 1-.47 1.28c-.09.13-.1.19-.11.53-.01.33.07 1.14.17 1.85.03.23.03.46.02.7 0 .4 0 .5.06.62.12.25.14.45.15 1.35 0 .49.02 1 .04 1.14.03.29.04 1.76.01 1.81a13.5 13.5 0 0 0-.18 4.08c.05.04.7-.46.84-.67l.1-.14v-1.04a10.65 10.65 0 0 0-.17-2.03 22.2 22.2 0 0 1-.03-2.42c.02-1.1.01-1.15-.24-2.03a2.26 2.26 0 0 1-.06-.48v-.29l.21-.19c.63-.55.8-.88.6-1.25-.11-.24-.15-.6-.1-1.26a14.78 14.78 0 0 1 .13-1.36c.05-.62.17-1.13.27-1.13.06 0 .22-.41.26-.66.06-.39.03-1.18-.05-1.27a.5.5 0 0 1-.08-.15 2.18 2.18 0 0 0-.12-.27.8.8 0 0 1-.08-.4c0-.26.06-.42.23-.54.06-.05.3-.25.5-.45l.39-.35.12-.4c.13-.4.36-.94.48-1.1l.24-.45c.21-.42.45-.72.92-1.18l.35-.34-.05-.14a3.15 3.15 0 0 1-.05-.6v-.45l-.25-.23-.24-.22.03-.4.08-.8c.08-.65 0-.81-.25-.59-.15.14-.25.34-.3.63-.03.15-.08.28-.16.4a1 1 0 0 0-.16.43c-.15.93-.31 1.34-.7 1.82-.22.28-.5.5-.83.64-.14.06-.37.19-.51.26l-.55.3c-.55.29-.64.39-.75.94-.14.6-.15.65-.26.66-.08 0-.11-.01-.18-.13-.07-.11-.08-.19-.08-.45 0-.17.02-.33.06-.5.08-.23.07-.33-.04-.48a.52.52 0 0 1-.07-.52.8.8 0 0 0 0-.58 2 2 0 0 1-.08-.32c-.02-.14-.01-.18.06-.25a.32.32 0 0 1 .12-.1c.05-.01.1-.04.13-.08.05-.06.25-.2.43-.33.13-.09.26-.19.38-.3a.37.37 0 0 1 .13-.09c.07-.04.11-.1.14-.16.06-.1.14-.2.24-.26a1 1 0 0 0 .22-.2c.03-.06.08-.07.25-.07.22 0 .39-.06.89-.29.4-.18.5-.3.78-.93l.06-.16c0-.08.26-.43.38-.51.13-.09.15-.14.13-.38a.77.77 0 0 0-.07-.22c-.05-.1-.09-.21-.11-.32-.05-.17-.05-.22 0-.35.06-.15.06-.16-.07-.4-.1-.18-.17-.28-.27-.33L19.65 2zm-3.06 28h-.01.01zm5.2-20.86a5.5 5.5 0 0 0-1.68 2.94c2.05 2.12 3.52 3.72 3.52 3.72 1.96 2.82.55 5.26-2.55 4.88 1.46 1.62 6 .5 5.76-3.37-.02-.42-.18-4.7-5.06-8.17zM9.54 10.9C5 14.7 4.86 18.98 6.21 21.17c1.13 1.83 4.62 1.87 5.4.27-3.77.78-5.13-1.93-3.44-4.77.42-.71 1.8-1.9 4.2-3.88-.24-.53-.56-.69-1.27-.92-.58-.2-.4-.27-1.56-.97zm4.22 9.43c-.04.03-.03 1.2 0 1.55l.05.4c0 .1.13.89.18 1.15.03.11.06.34.08.52 0 .12.02.24.05.35.04.2.08.4.1.6.02.2.05.39.09.58v.01h.05c.04-.04.1-.8.15-1.75a29.93 29.93 0 0 1 .09-1.55c0-.26.03-.62.04-.81l.03-.36-.3-.29c-.25-.25-.56-.46-.61-.4zm4.45.35c-.04 0-.1.05-.23.14-.23.17-.28.26-.28.5 0 .2.12 1.1.16 1.16.07.11.14.79.14 1.44 0 .4.03.83.05.94.08.37.13 1.11.13 1.88 0 .42 0 .78.02.8.04.06.15-.1.19-.24.07-.3.12-1.2.11-2.26 0-.88 0-1.17.05-1.56.1-.63.1-.65.1-.97 0-.3 0-.36-.22-1.19l-.15-.54c-.01-.07-.03-.1-.07-.1z',
        'map-marked-alt-solid' => 'M22 3c-3.3 0-6 2.7-6 6 0 1 .38 2 .88 3.13.49 1.12 1.1 2.3 1.75 3.4a62.17 62.17 0 0 0 2.56 4.03l.81 1.19.81-1.19s1.3-1.83 2.57-4.03a39.1 39.1 0 0 0 1.75-3.4C27.61 11 28 9.98 28 9c0-3.3-2.7-6-6-6ZM11.97 4.94 4 8.34v19.2l8.03-3.48 8 3 7.97-3.4v-8.72a49.14 49.14 0 0 1-2 3.44v3.96l-5 2.13v-1.63l-1.47-2.12-.53-.78v4.62l-6-2.25V7.44l1.1.4c.1-.67.27-1.32.53-1.93ZM22 5c2.22 0 4 1.78 4 4 0 .39-.24 1.3-.69 2.31a34.67 34.67 0 0 1-1.68 3.22c-.82 1.4-1.17 1.9-1.63 2.6-.46-.7-.8-1.2-1.63-2.6a34.67 34.67 0 0 1-1.68-3.22A7.45 7.45 0 0 1 18 9c0-2.22 1.78-4 4-4ZM11 7.5v14.84l-5 2.13V9.66Zm11 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'map-marked-solid' => 'M22 3c-3.3 0-6 2.7-6 6 0 1 .38 2 .88 3.13.49 1.12 1.1 2.3 1.75 3.4a62.05 62.05 0 0 0 2.56 4.03l.81 1.19.81-1.19s1.3-1.83 2.57-4.03a39.1 39.1 0 0 0 1.75-3.4C27.61 11 28 9.98 28 9c0-3.3-2.7-6-6-6zM11.97 4.94 4 8.34v19.2l8.03-3.48 8 3 7.97-3.4v-8.72a49.28 49.28 0 0 1-2 3.44v3.96l-5 2.13v-1.63l-1.47-2.12-.53-.78v4.62l-6-2.25V7.44l1.1.4c.1-.67.27-1.32.53-1.93l-2.66-.97zM22 5c2.22 0 4 1.78 4 4 0 .39-.24 1.3-.69 2.31a34.68 34.68 0 0 1-1.68 3.22c-.82 1.4-1.17 1.9-1.63 2.6-.46-.7-.8-1.2-1.63-2.6a34.92 34.92 0 0 1-1.68-3.22A7.46 7.46 0 0 1 18 9c0-2.22 1.78-4 4-4zM11 7.5v14.84l-5 2.13V9.66l5-2.16z',
        'map-marker-alt-solid' => 'M16 3c-4.96 0-9 4.04-9 9 0 1.4.57 3.02 1.34 4.78a55.38 55.38 0 0 0 2.79 5.38c2.02 3.48 4.06 6.4 4.06 6.4l.81 1.19.81-1.19s2.04-2.92 4.07-6.4c1-1.75 2-3.62 2.78-5.38C24.43 15.02 25 13.41 25 12c0-4.96-4.04-9-9-9Zm0 2c3.88 0 7 3.12 7 7a12 12 0 0 1-1.16 3.97 54.92 54.92 0 0 1-2.71 5.19 83.79 83.79 0 0 1-3.13 5c-.58-.86-1.55-2.3-3.13-5a54.06 54.06 0 0 1-2.71-5.2A12.07 12.07 0 0 1 9 12c0-3.88 3.12-7 7-7Zm0 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'map-marker-solid' => 'M16 3c-4.96 0-9 4.04-9 9 0 1.4.57 3.02 1.34 4.78a55.38 55.38 0 0 0 2.79 5.38c2.02 3.48 4.06 6.4 4.06 6.4l.81 1.19.81-1.19s2.04-2.92 4.07-6.4c1-1.75 2-3.62 2.78-5.38C24.43 15.02 25 13.41 25 12c0-4.96-4.04-9-9-9Zm0 2c3.88 0 7 3.12 7 7a12 12 0 0 1-1.16 3.97 54.92 54.92 0 0 1-2.71 5.19 83.79 83.79 0 0 1-3.13 5c-.58-.86-1.55-2.3-3.13-5a54.06 54.06 0 0 1-2.71-5.2A12.07 12.07 0 0 1 9 12c0-3.88 3.12-7 7-7Zm0 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'map-pin-solid' => 'M16 5a7 7 0 0 0-1 13.9V28h2v-9.1A7 7 0 0 0 16 5Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm0 1c-2.2 0-4 1.8-4 4h2c0-1.12.88-2 2-2Z',
        'map-signs-solid' => 'M15 5v2H5v9h20.47l.28-.34 3.56-4.16-3.56-4.16-.28-.34H17V5ZM7 9h17.53l2.16 2.5-2.16 2.5H7Zm8 8v10h2V17Z',
        'map-solid' => 'm28 4.47-1.4.62-6.63 2.85-7.63-2.88-.37-.12-.38.15-7 3-.59.25v19.2l1.4-.63 6.63-2.85 7.63 2.88.37.12.38-.15 7-3 .59-.25ZM13 7.44l6 2.25v14.87l-6-2.25Zm-2 .06v14.84L6 24.5V9.66Zm15 0v14.84l-5 2.16V9.66Z',
        'map' => 'm28 4.47-1.4.62-6.63 2.85-7.63-2.88-.37-.12-.38.15-7 3-.59.25v19.2l1.4-.63 6.63-2.85 7.63 2.88.37.12.38-.15 7-3 .59-.25ZM13 7.44l6 2.25v14.87l-6-2.25Zm-2 .06v14.84L6 24.5V9.66Zm15 0v14.84l-5 2.16V9.66Z',
        'markdown' => 'M2.88 6A2.86 2.86 0 0 0 0 8.81V23.2A2.86 2.86 0 0 0 2.88 26h26.25A2.86 2.86 0 0 0 32 23.19V8.8A2.86 2.86 0 0 0 29.12 6Zm0 2h26.25c.51 0 .87.38.87.81V23.2c0 .43-.36.81-.88.81H2.88c-.51 0-.87-.38-.87-.81V8.8c0-.43.36-.81.88-.81ZM5 11v10h3v-6.66l3 3.97 3-3.97V21h3V11h-3l-3 4-3-4Zm17 0v5h-3l4.5 5 4.5-5h-3v-5Z',
        'marker-solid' => 'm23.63 3.06-.72.63L7.56 17l-.5.47.25.66s1.13 3-1.03 5.15v.03l-.03.03-.16.2-.12.12L2 27.53 7.38 29l2.06-2.06.22-.19.03-.03h.03c2.15-2.16 5.15-1.03 5.15-1.03l.66.25.47-.5 13.31-15.35.63-.71Zm-.13 2.75 3.69 3.69-8.75 10.06-5-5ZM11.94 15.88l5.19 5.18-1.94 2.25-5.5-5.5ZM9.56 20.5l2.94 2.94a6.1 6.1 0 0 0-4.16 1.81l-.06.03-.25.22-.53-.53.22-.25.03-.06a6.1 6.1 0 0 0 1.81-4.16Z',
        'mars-double-solid' => 'M14 3v2h5.56l-5.4 5.4a6.92 6.92 0 0 0-9.1.66 6.94 6.94 0 0 0 0 9.88 6.92 6.92 0 0 0 9.88 0 7.02 7.02 0 0 0 1.75-2.85 4.23 4.23 0 0 0-2.32.29 4.96 4.96 0 0 1-7.9 1.16 4.96 4.96 0 0 1 0-7.07 4.96 4.96 0 0 1 8.16 1.65 8.04 8.04 0 0 1 2.09-.09 6.93 6.93 0 0 0-1.13-2.19L21 6.44V11h4.56l-5.4 5.4a6.92 6.92 0 0 0-9.1.66 7.02 7.02 0 0 0-1.75 2.85c.78.12 1.6.02 2.31-.29a4.96 4.96 0 0 1 7.9-1.16 4.96 4.96 0 0 1 .01 7.07 4.96 4.96 0 0 1-8.16-1.66 8.04 8.04 0 0 1-2.09.1 6.93 6.93 0 0 0 1.78 2.97 6.94 6.94 0 0 0 9.88 0 6.94 6.94 0 0 0 .65-9.1l5.41-5.4V18h2V9h-6V3Z',
        'mars-solid' => 'M17 4v2h7.56l-7.68 7.69A7.98 7.98 0 0 0 4 20c0 4.4 3.6 8 8 8s8-3.6 8-8c0-1.83-.64-3.52-1.69-4.88L26 7.45V15h2V4Zm-5 10a6 6 0 1 1 .02 11.98A6 6 0 0 1 12 14Z',
        'mars-stroke-h-solid' => 'M10 8c-4.4 0-8 3.6-8 8s3.6 8 8 8a8.03 8.03 0 0 0 7.94-7H20v3h2v-3h4.56l-4.28 4.28 1.44 1.44 6-6 .69-.72-.7-.72-6-6-1.43 1.44L26.56 15H22v-3h-2v3h-2.06c-.5-3.93-3.87-7-7.94-7Zm0 2a6 6 0 1 1 .02 11.98A6 6 0 0 1 10 10Z',
        'mars-stroke-solid' => 'M17 4v2h7.56L20 10.56l-2.28-2.28-1.44 1.44L18.56 12l-1.68 1.69A7.98 7.98 0 0 0 4 20c0 4.4 3.6 8 8 8s8-3.6 8-8c0-1.83-.64-3.52-1.69-4.88L20 13.45l2.28 2.28 1.44-1.44L21.44 12 26 7.44V15h2V4Zm-5 10a6 6 0 1 1 .02 11.98A6 6 0 0 1 12 14Z',
        'mars-stroke-v-solid' => 'm16 1.6-.72.68-6 6 1.44 1.44L15 5.44V10h-3v2h3v2.06c-3.93.5-7 3.87-7 7.94 0 4.4 3.6 8 8 8s8-3.6 8-8a8.03 8.03 0 0 0-7-7.94V12h3v-2h-3V5.44l4.28 4.28 1.44-1.44-6-6ZM16 16a6 6 0 1 1 .02 11.98A6 6 0 0 1 16 16Z',
        'mask-solid' => 'M16.03 7c-4.95 0-8.81 1.06-11.48 3.15A8.9 8.9 0 0 0 1 17.25C1 22.06 4.63 26 9.1 26c2.07 0 4.04-1.1 5.28-2.93l1.1-1.74c.15-.2.34-.32.55-.32.2 0 .4.12.53.3l1.14 1.78A6.4 6.4 0 0 0 22.96 26c4.36 0 8.04-4.08 8.04-8.91a8.74 8.74 0 0 0-3.52-7C24.84 8.04 20.99 7 16.03 7zm0 2c4.44 0 7.98.92 10.22 2.67A6.68 6.68 0 0 1 29 17.09c0 3.68-2.82 6.91-6.04 6.91a4.4 4.4 0 0 1-3.6-2.01l-1.13-1.77a2.67 2.67 0 0 0-2.2-1.2c-.87 0-1.7.44-2.21 1.21l-1.12 1.74A4.4 4.4 0 0 1 9.1 24C5.45 24 3 20.5 3 17.24c0-2.14.99-4.1 2.79-5.51C8.06 9.94 11.6 9 16.03 9zM10 12a5.91 5.91 0 0 0-4.6 2.34 1.88 1.88 0 0 0 0 2.32A5.9 5.9 0 0 0 10 19a5.9 5.9 0 0 0 4.6-2.34 1.9 1.9 0 0 0 0-2.32A5.91 5.91 0 0 0 10 12zm12 0a5.91 5.91 0 0 0-4.6 2.34 1.88 1.88 0 0 0 0 2.32c.7.88 2.23 2.34 4.6 2.34a5.9 5.9 0 0 0 4.6-2.34 1.9 1.9 0 0 0 0-2.32A5.91 5.91 0 0 0 22 12zm-12 2c1.47 0 2.46.9 2.96 1.5-.5.6-1.5 1.5-2.96 1.5a3.9 3.9 0 0 1-2.96-1.5c.5-.6 1.5-1.5 2.96-1.5zm12 0c1.47 0 2.46.9 2.96 1.5-.5.6-1.5 1.5-2.96 1.5a3.9 3.9 0 0 1-2.96-1.5c.5-.6 1.5-1.5 2.96-1.5z',
        'mastodon' => 'M15.94 4.03c-3.02.01-6.02.4-7.58 1.12 0 0-3.36 1.52-3.36 6.73 0 6.2 0 13.98 5.56 15.49 2.13.57 3.97.7 5.44.6 2.68-.14 4-.96 4-.96l-.09-1.98s-1.73.61-3.88.54c-2.13-.07-4.37-.23-4.72-2.89-.03-.25-.05-.5-.04-.75 4.5 1.12 8.35.5 9.4.36 2.96-.36 5.53-2.2 5.86-3.9.51-2.67.47-6.5.47-6.5 0-5.22-3.35-6.74-3.35-6.74-1.65-.77-4.7-1.13-7.71-1.12zM12.7 8c1.03.03 2.05.5 2.68 1.47l.61 1.04.6-1.04c1.27-1.97 4.11-1.84 5.46-.32 1.24 1.45.97 2.38.97 8.85h-2.45v-5.63c0-2.63-3.36-2.73-3.36.37V16h-2.43v-3.26c0-3.1-3.36-3-3.36-.37V18H8.98c0-6.47-.28-7.41.96-8.85A3.6 3.6 0 0 1 12.71 8z',
        'maxcdn' => 'm5 6 2 5-3 15h5l3-15h4l-3 15h5l3-15h4l-3 15h5l2.75-13.74A5.23 5.23 0 0 0 24.62 6Z',
        'mdb' => 'm1.08 9-1 12h2l.56-6.7L5.32 21h1.36l2.68-6.7.55 6.7h2.01l-1-12h-1.6L6 17.3 2.68 9h-1.6zM14 9v12h2c3.3 0 6-2.7 6-6s-2.7-6-6-6h-2zm10 0v12.01h4.5c1.92 0 3.5-1.58 3.5-3.5 0-1.27-.72-2.35-1.74-2.96.43-.58.74-1.27.74-2.05 0-1.92-1.58-3.5-3.5-3.5H24zm-8 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4v-8zm10 0h1.5c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5H26v-3zm0 5h2.5c.84 0 1.5.66 1.5 1.5 0 .85-.66 1.51-1.5 1.51H26V16z',
        'medal-solid' => 'm7 3 4.27 10.36a9 9 0 1 0 9.46 0L25 3h-2.16l-3.91 9.5a8.9 8.9 0 0 0-2.06-.46L20.59 3h-2.16l-3.76 9.1a8.9 8.9 0 0 0-1.6.4L9.17 3H7zm4.41 0 2.54 6.17 1.09-2.62L13.57 3h-2.16zM16 14a7 7 0 1 1-.02 14.02A7 7 0 0 1 16 14zm0 3.16-1.17 2.62-2.83.31 2.12 1.9-.6 2.82L16 23.38l2.48 1.43-.6-2.81L20 20.1l-2.83-.32L16 17.16z',
        'medapps' => 'M16 2c-4.49 0-8 3.44-8 7.84 0 2.14.86 4.73 2.18 6.62l.14.19C11.1 17.76 12 19.03 12 20a1 1 0 1 0 2 0c0-1.6-1.09-3.15-2.05-4.5l-.13-.2A10.34 10.34 0 0 1 10 9.84 5.86 5.86 0 0 1 16 4c3.36 0 6 2.56 6 5.84 0 1.72-.73 3.92-1.82 5.46l-.12.18C19.24 16.64 18 18.38 18 20a1 1 0 1 0 2 0c0-.98 1.1-2.53 1.69-3.36l.13-.18A12.32 12.32 0 0 0 24 9.84C24 5.44 20.49 2 16 2zm.22 8c-.47.08-.5 3.2-.75 4.38-.48-.67-.55-1.76-1-1.85-.33 0-.51 1.06-.7 1.7l-1.65.25c-.78.3 2.36.39 2.54.4.34.84.93 2.63 1.17 1.98l.49-3.3c.5 1.04.68 2.5.94 2.5.32-.02.36-.67.6-1.42.85-.01 2.24-.02 2.13-.39 0 0-2.07-.13-2.6-.34-.13-.56-.69-3.95-1.17-3.91zM13 23a1 1 0 0 0-1 1 1 1 0 0 0 1 1h6a1 1 0 0 0 1-1 1 1 0 0 0-1-1h-6zm1 4a1 1 0 0 0-1 1 1 1 0 0 0 1 1h4a1 1 0 0 0 1-1 1 1 0 0 0-1-1h-4z',
        'medium-m' => 'M26 10.36h-.79c-.3 0-.71.43-.71.7v9.93c0 .28.41.65.71.65H26V24h-7.17v-2.36h1.5V11.2h-.07L16.76 24h-2.71l-3.46-12.8h-.09v10.44H12V24H6v-2.36h.77c.32 0 .73-.37.73-.65v-9.93c0-.27-.41-.7-.73-.7H6V8h7.5l2.46 9.26h.08L18.52 8H26Z',
        'medium' => 'M26 10.36h-.79c-.3 0-.71.43-.71.7v9.93c0 .28.41.65.71.65H26V24h-7.17v-2.36h1.5V11.2h-.07L16.76 24h-2.71l-3.46-12.8h-.09v10.44H12V24H6v-2.36h.77c.32 0 .73-.37.73-.65v-9.93c0-.27-.41-.7-.73-.7H6V8h7.5l2.46 9.26h.08L18.52 8H26Z',
        'medkit-solid' => 'M14 5a2 2 0 0 0-2 2v1H6c-1.64 0-3 1.36-3 3v15h26V11c0-1.64-1.36-3-3-3h-6V7a2 2 0 0 0-2-2Zm0 2h4v1h-4Zm-8 3h20c.57 0 1 .43 1 1v13H5V11c0-.57.43-1 1-1Zm9 3v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'medrt' => 'M14.85 3C7.75 3 2 8.81 2 16a12.92 12.92 0 0 0 15.86 12.64C12.2 27.68 7 22.39 7 16 7 9.62 12.34 4.32 18 3.36c-.96-.24-2.1-.36-3.15-.36zm2.69 4A9.04 9.04 0 0 0 12 8.96c3.3-.9 6.96.2 9.16 3.06A8.36 8.36 0 0 1 22.42 20c2.9-2.83 3.46-7.18 1.14-10.19A7.47 7.47 0 0 0 17.54 7zm9.64 3.03A10 10 0 0 1 10.6 20.7c.29.67.78 1.4 1.2 2a9.94 9.94 0 0 0 13.95 2.44 10.2 10.2 0 0 0 2.42-14.11c-.34-.5-.64-.72-1-1zM14.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-.5.5h-2a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h2c.28 0 .5.22.5.5v2c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-2c0-.28.22-.5.5-.5h2a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-.5-.5h-1z',
        'meetup' => 'M9.5 1a.5.5 0 0 0 0 1 .5.5 0 0 0 0-1zm9 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM14 5a6 6 0 0 0-5.66 4.02 4.5 4.5 0 0 0-3.87 6.44A4.98 4.98 0 0 0 7 23.9v.1a5 5 0 0 0 8.18 3.83 3.99 3.99 0 0 0 6.68-1.85 5.5 5.5 0 0 0 4.18-8.58 3.48 3.48 0 0 0-1.06-5.56l.02-.34a5.5 5.5 0 0 0-7.28-5.2A5.97 5.97 0 0 0 14 5zM7 6a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm20 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-10 1c.15-.02.31-.01.5.02.51.07.81.42 1.2.8.31.31.54.11.72 0 .28-.15.5-.3 1.32-.27.86.01 1.85.33 2.05 1.8.23 1.66-2.65 5.92-2.46 7.89.14 1.39 2.46.4 2.65 1.67.25 1.65-2.9 1.03-3.6.68a2.85 2.85 0 0 1-1.53-3.12c.23-.94 2.3-4.82 2.4-5.4.07-.61-.25-.67-.44-.67-.27-.02-.46.1-.72.5-.23.35-2.82 5.61-3.05 6.05-.72 1.4-2.58 1.16-2.37-.25.05-.42 1.7-4.18 1.78-4.78.05-.35-.02-.74-.37-.93-.35-.18-.78.1-.9.31-.18.3-2.5 6.48-2.75 6.94-.44.79-.88 1.03-1.56 1.07-1.6.1-2.8-1.26-2.27-2.9.22-.74 1.77-6.3 2.56-7.7.53-.95 2-1.67 3-1.24.53.23 1.27.6 1.47.7.5.24 1.03-.38 1.24-.56.4-.35.7-.58 1.14-.62zm13.5 3a.5.5 0 0 0 0 1 .5.5 0 0 0 0-1zm-29 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM29 16a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM5.5 25a.5.5 0 0 0 0 1 .5.5 0 0 0 0-1zm18 2a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zM15 29a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'megaport' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm0 2-1 1v2.67l-2 2v3.04l-3 2.4V22l1 1 1-1v-2.93l1.5-1.2 1.5 1.2V22l1 1 1-1v-2.93l1.5-1.2 1.5 1.2V22l1 1 1-1v-3.89l-3-2.4v-3.04l-2-2V8l-1-1zm0 5.5 1 1v2.67l-1 1-1-1V13.5l1-1z',
        'meh-blank-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'meh-blank' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 7a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm9 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'meh-rolling-eyes-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 5a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm10 0a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm-10.98 2.27A1.5 1.5 0 0 0 11.5 14a1.5 1.5 0 0 0 1.33-.8A2 2 0 1 1 9 14a2 2 0 0 1 1.02-1.73zm11.96 0A2 2 0 0 1 21 16a2 2 0 0 1-1.83-2.8 1.5 1.5 0 0 0 1.33.8 1.5 1.5 0 0 0 1.48-1.73zM12 20v2h8v-2h-8z',
        'meh-rolling-eyes' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 5a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm10 0a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm-10.98 2.27A1.5 1.5 0 0 0 11.5 14a1.5 1.5 0 0 0 1.33-.8A2 2 0 1 1 9 14a2 2 0 0 1 1.02-1.73zm11.96 0A2 2 0 0 1 21 16a2 2 0 0 1-1.83-2.8 1.5 1.5 0 0 0 1.33.8 1.5 1.5 0 0 0 1.48-1.73zM12 20v2h8v-2h-8z',
        'meh-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM11 20v2h10v-2Z',
        'meh' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM11 20v2h10v-2Z',
        'memory-solid' => 'M2 7v18h13v-1a1 1 0 0 1 1-1 1 1 0 0 1 1 1v1h13V7Zm2 2h24v9H4Zm2 2v5h6v-5Zm7 0v5h6v-5Zm7 0v5h6v-5ZM8 13h2v1H8Zm7 0h2v1h-2Zm7 0h2v1h-2ZM4 20h24v3h-9.4c-.45-1.1-1.34-2-2.6-2s-2.15.9-2.6 2H4Z',
        'mendeley' => 'M9.66 7.2c-3.61-.04-5.46 3.63-4.33 6.48.6 3.17.02 4.85-2.13 4.9-1.05-.12-1.83.32-2.63 1.11-.98.98-.95 4.7 2.12 5.09 2.33.29 3.96-2.26 3.03-4.35-2.35-5.14 9.35-5.26 7.4-.41l-.01.02c-1.33 2.12.33 4.83 2.91 4.72 2.58.1 4.23-2.61 2.91-4.72l-.01-.02c-1.95-4.85 9.74-4.73 7.4.4-.23.5-.33 1.06-.28 1.64a2.98 2.98 0 0 0 5.2 1.74c.88-.73 1.14-3.25 0-4.37a2.92 2.92 0 0 0-2.4-.85c-2.15-.05-2.77-1.73-2.17-4.9 1.13-2.85-.74-6.51-4.33-6.48-3.83.04-3.88 4.06-6.32 4.06-2.38 0-2.55-4.02-6.36-4.06zM16 12.26h.03c1.71 0 3.1 1.4 3.1 3.11 0 1.24-.94 3.11-3.1 3.11H16a3.11 3.11 0 1 1 0-6.22z',
        'menorah-solid' => 'M4 5S3 7.02 3 8a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0S7 7.02 7 8a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3Zm4 0s-1 2.02-1 3a1 1 0 0 0 2 0c0-.94-1-3-1-3ZM3 10c0 6.8 5.32 12.41 12 12.94V25h-5v2h12v-2h-5v-2.06C23.68 22.4 29 16.8 29 10h-2c0 5.72-4.41 10.43-10 10.94v-2c4.48-.51 8-4.33 8-8.94h-2a7 7 0 0 1-6 6.9v-2c2.27-.46 4-2.5 4-4.9h-2a3 3 0 0 1-2 2.81V10h-2v2.81A3 3 0 0 1 13 10h-2c0 2.4 1.73 4.44 4 4.9v2A7 7 0 0 1 9 10H7c0 4.6 3.52 8.43 8 8.94v2C9.41 20.43 5 15.72 5 10Z',
        'mercury-solid' => 'M11 2c0 1.48.66 2.8 1.69 3.72A8.03 8.03 0 0 0 8 13a8.03 8.03 0 0 0 7 7.94V24h-4v2h4v4h2v-4h4v-2h-4v-3.06c3.93-.5 7-3.87 7-7.94a8.03 8.03 0 0 0-4.69-7.28A4.98 4.98 0 0 0 21 2h-2c0 1.67-1.33 3-3 3s-3-1.33-3-3Zm5 5a6 6 0 1 1 .02 11.98A6 6 0 0 1 16 7Z',
        'meteor-solid' => 'm30.34 1.6-3.9 2.56-6.25 4.09.37-.66 1.63-2.93-2.97 1.56s-2.73 1.46-5.94 3.37c-3.21 1.92-6.87 4.23-8.87 6.2a8.23 8.23 0 0 0 0 11.71h.03a8.17 8.17 0 0 0 11.65 0v-.03c1.7-1.7 3.81-4.81 5.54-7.56 1.72-2.76 3.03-5.13 3.03-5.13l1.4-2.47-2.62 1.06-.82.32 5.22-8.16Zm-6.71 6.8-4.38 6.85-1.69 2.66 2.9-1.2.95-.37c-.54.93-.66 1.16-1.5 2.5-1.7 2.72-3.83 5.86-5.22 7.25a6.16 6.16 0 0 1-8.88 0h-.03a6.16 6.16 0 0 1 .03-8.87c1.7-1.65 5.34-4.02 8.5-5.9a77.2 77.2 0 0 1 2.81-1.63l-.59 1.12-1.94 3.53 3.35-2.21ZM10 18a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm0 2c1.2 0 2 .8 2 2s-.8 2-2 2-2-.8-2-2 .8-2 2-2Z',
        'microchip-solid' => 'M7 6v2H3v18h4v2h2v-2h2v2h2v-2h2v2h2v-2h2v2h2v-2h2v2h2v-2h4V8h-4V6h-2v2h-2V6h-2v2h-2V6h-2v2h-2V6h-2v2H9V6Zm-2 4h22v14H5Zm3 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM8 16a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm16 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM8 20a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'microphone-alt-slash-solid' => 'M3.72 2.28 2.28 3.72l9.58 9.58 1.43 1.43 3.97 3.97 1.44 1.44 9.58 9.58 1.44-1.44-9.32-9.32 1.44-1.02A7 7 0 0 0 21 4a7 7 0 0 0-6.94 6.19l-1 1.42-9.34-9.33zM21 6a4.99 4.99 0 0 1 4.19 7.75l-6.94-6.94A5 5 0 0 1 21 6zm-4.19 2.25 6.94 6.94a5 5 0 0 1-6.94-6.94zm-6.09 6.66L6 21.6l-.47.7.56.59.82.8-2.63 2.6 1.44 1.44 2.56-2.6 1.38 1.38.71-.5 6.72-4.72-1.44-1.44-5.74 4.07-1.79-1.85 4.03-5.72-1.43-1.43z',
        'microphone-alt-solid' => 'M21 4a7 7 0 0 0-6.94 6.19L6 21.59l-.47.7.56.59.82.8-2.63 2.6 1.44 1.44 2.56-2.6 1.38 1.38.71-.5 11.47-8.06A7 7 0 0 0 21 4Zm0 2a4.98 4.98 0 0 1 4.19 7.75l-6.94-6.94A5 5 0 0 1 21 6Zm-4.19 2.25 6.94 6.94A5 5 0 0 1 16 11a5 5 0 0 1 .81-2.75Zm-2.43 4.94a7.07 7.07 0 0 0 4.4 4.44L9.91 23.9l-1.79-1.85Z',
        'microphone-slash-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44L23.44 22A5.94 5.94 0 0 0 25 18v-4h-2v4c0 1-.36 1.9-.97 2.6l-1.4-1.41c.23-.33.37-.75.37-1.19V6a2 2 0 0 0-2-2h-6a2 2 0 0 0-2 2v3.56ZM13 6h6v11.56l-6-6Zm-6 8v4a6 6 0 0 0 6 6h2v2h-4v2h10v-2h-4v-2h2c.25 0 .5-.03.75-.06L17.81 22H13a4 4 0 0 1-4-4v-4Zm4 1.19V18c0 1.1.9 2 2 2h2.81l-2-2H13v-.81Z',
        'microphone-solid' => 'M13 4a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2Zm0 2h6v12h-6Zm-6 8v4c0 3.3 2.7 6 6 6h2v2h-4v2h10v-2h-4v-2h2c3.3 0 6-2.7 6-6v-4h-2v4c0 2.22-1.78 4-4 4h-6c-2.22 0-4-1.78-4-4v-4Z',
        'microscope-solid' => 'M17 4v2h4V4Zm-1 3v2h-2c-2.75 0-5 2.25-5 5v4.19C7.84 18.6 7 19.7 7 21s.84 2.4 2 2.81V26H7v2h17v-2H11v-2.19c.84-.3 1.5-.97 1.81-1.81H24v-2H12.81c-.3-.84-.97-1.5-1.81-1.81V14a3 3 0 0 1 3-3h2v6h6V7Zm2 2h2v6h-2Zm-8 11c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'microsoft' => 'M5 5v22h22V5H5zm2 2h8v8H7V7zm10 0h8v8h-8V7zM7 17h8v8H7v-8zm10 0h8v8h-8v-8z',
        'minus-circle-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-6 10v2h12v-2Z',
        'minus-solid' => 'M5 15v2h22v-2Z',
        'minus-square-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4 8v2h10v-2Z',
        'minus-square' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4 8v2h10v-2Z',
        'mitten-solid' => 'M19 3c-4.4 0-8 3.6-8 8v2.63a3.95 3.95 0 0 0-4.4 6.56v.03h.03L12 24.16V29h14v-5.28l.06-.13A11.36 11.36 0 0 0 27 19v-7.99c0-4.4-3.6-8-8-8Zm0 2c3.3 0 6 2.7 6 6v8a9.5 9.5 0 0 1-.44 3c-.1.33-.24.57-.31.72-.04.07-.04.12-.06.16l-.03.03.15.09H13.84l-.25-.19-5.78-4.22a1.96 1.96 0 0 1-.4-2.78 1.96 1.96 0 0 1 2.78-.4h.03l1.22.84 1.56 1.1V11c0-3.3 2.7-6 6-6Zm-5 20h10v2H14Z',
        'mix' => 'M5 5v20a3 3 0 0 0 6 0V13a1 1 0 0 1 2 0v8a3 3 0 0 0 6 0v-6a1 1 0 0 1 2 0v2a3 3 0 0 0 6 0V5H5zm2 2h18v10a1 1 0 0 1-2 0v-2a3 3 0 0 0-6 0v6a1 1 0 0 1-2 0v-8a3 3 0 0 0-6 0v12a1 1 0 0 1-2 0V7z',
        'mixcloud' => 'M12.85 6a8.46 8.46 0 0 0-8 5.72A5.67 5.67 0 0 0 5.7 23h14.54a4.76 4.76 0 0 0 1.03-9.39A8.47 8.47 0 0 0 12.86 6zm0 2a6.43 6.43 0 0 1 6.08 8.47c-.46 1.4 1.64 1.99 2.04.67.15-.42.26-.85.33-1.3a2.68 2.68 0 0 1-.97 5.15L5.61 21a3.6 3.6 0 1 1 2.53-6.16c1.01 1.02 2.55-.52 1.53-1.55a5.78 5.78 0 0 0-2.64-1.5A6.4 6.4 0 0 1 12.85 8zm16.62 4c-.78-.1-1.6.8-1.02 1.64a8.79 8.79 0 0 1 0 9.74c-.48.7.05 1.62.85 1.62.34 0 .67-.17.88-.46a10.8 10.8 0 0 0 0-12.06 1 1 0 0 0-.71-.47zm-3 1.7c-.78-.1-1.6.78-1.01 1.62a5.67 5.67 0 0 1 0 6.35c-.48.7.01 1.62.86 1.62.34 0 .67-.14.87-.44a7.73 7.73 0 0 0 1.32-4.35c0-1.56-.45-3.06-1.32-4.33a1 1 0 0 0-.71-.47z',
        'mizuni' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-4.5 5c-.83 0-1.5.67-1.5 1.5V22a7.72 7.72 0 0 1 3-1.8v-8.7c0-.83-.67-1.5-1.5-1.5zm4.5 0c-.83 0-1.5.67-1.5 1.5v8.33a9.32 9.32 0 0 1 3 0V11.5c0-.83-.67-1.5-1.5-1.5zm4.5 0c-.83 0-1.5.67-1.5 1.5v8.69a7.84 7.84 0 0 1 3 1.8V11.5c0-.83-.67-1.5-1.5-1.5z',
        'mobile-alt-solid' => 'M11 4C9.36 4 8 5.36 8 7v18c0 1.64 1.36 3 3 3h10c1.64 0 3-1.36 3-3V7c0-1.64-1.36-3-3-3Zm0 2h10a1 1 0 0 1 1 1v18a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1Zm5 17a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'mobile-solid' => 'M11 4C9.36 4 8 5.36 8 7v18c0 1.64 1.36 3 3 3h10c1.64 0 3-1.36 3-3V7c0-1.64-1.36-3-3-3Zm0 2h10a1 1 0 0 1 1 1v18a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1Zm5 17a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'modx' => 'M7 4.24v12l1.86 1.2L3.89 25h12.48l1.15-1.71L25 27.77V15.44l-1.82-1.12L27.82 7H15.48l-1.13 1.6L7 4.25zm2 3.52 4.2 2.49 6.12 3.64-9.13 2.04L9 15.15v-7.4zM16.52 9h7.66l-2.5 3.96-5.6-3.33.44-.63zm3.63 6.76L15.31 23H7.6l3.42-5.2 9.13-2.04zm2.16.38.69.42v7.67l-4.33-2.59 3.64-5.5z',
        'monero' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 10.57 14H22v-8.02l-6 6.28-6-6.28V19H5.43A10.95 10.95 0 0 1 16 5zm-4 10.97 4 4.19 4-4.2V21h5.79A11 11 0 0 1 16 27a11 11 0 0 1-9.79-6H12v-5.03z',
        'money-bill-alt-solid' => 'M2 7v17h28V7H2zm4 2h20c0 1.1.9 2 2 2v9a2 2 0 0 0-2 2H6a2 2 0 0 0-2-2v-9a2 2 0 0 0 2-2zm9 2c0 1.44-.56 2-2 2v2a4.7 4.7 0 0 0 2-.41V20h2v-9h-2zm-6.5 3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3z',
        'money-bill-alt' => 'M2 7v17h28V7H2zm4 2h20c0 1.1.9 2 2 2v9a2 2 0 0 0-2 2H6a2 2 0 0 0-2-2v-9a2 2 0 0 0 2-2zm9 2c0 1.44-.56 2-2 2v2a4.7 4.7 0 0 0 2-.41V20h2v-9h-2zm-6.5 3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3z',
        'money-bill-solid' => 'M2 7v17h28V7H2zm4 2h20c0 1.1.9 2 2 2v9a2 2 0 0 0-2 2H6a2 2 0 0 0-2-2v-9a2 2 0 0 0 2-2zm10 2c-2.21 0-4 2.02-4 4.5s1.79 4.5 4 4.5 4-2.02 4-4.5-1.79-4.5-4-4.5zm0 2c1.1 0 2 1.12 2 2.5s-.9 2.5-2 2.5-2-1.12-2-2.5.9-2.5 2-2.5zm-7.5 1a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3z',
        'money-bill-wave-alt-solid' => 'M22.85 6c-2.69.08-4.77.81-6.8 1.52-2.17.75-4.22 1.46-7.06 1.5-1.9.02-3.8-.3-5.66-.95L2 7.6v17.08l.67.24A18.52 18.52 0 0 0 8.77 26c3.02 0 5.33-.8 7.57-1.57 2.35-.82 4.58-1.59 7.61-1.44 1.58.07 3.16.39 4.72.94l1.33.47V7.31l-.66-.24a17.78 17.78 0 0 0-6.49-1.06zm.06 2a14.87 14.87 0 0 1 2.17.1A2.5 2.5 0 0 0 28 9.94v9.1A17.64 17.64 0 0 0 24.05 21c-3.42-.15-5.94.71-8.37 1.55-2.36.82-4.6 1.6-7.63 1.45-.38-.02-.75-.05-1.13-.1A2.5 2.5 0 0 0 4 22.05v-9.1a2.5 2.5 0 0 0 2.96-2.05c.68.07 1.37.11 2.05.1 3.17-.03 5.47-.83 7.7-1.6 1.96-.69 3.83-1.33 6.2-1.4zM16 12c0 1.44-.56 2-2 2v2a4.7 4.7 0 0 0 2-.41V20h2v-8h-2zm7.5 1a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-15 3a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'money-bill-wave-solid' => 'M22.85 6c-2.69.08-4.77.81-6.8 1.52-2.17.75-4.22 1.46-7.06 1.5-1.9.02-3.8-.3-5.66-.95L2 7.6v17.08l.67.24A18.52 18.52 0 0 0 8.77 26c3.02 0 5.33-.8 7.57-1.57 2.35-.82 4.58-1.59 7.61-1.44 1.58.07 3.16.39 4.72.94l1.33.47V7.31l-.66-.24a17.78 17.78 0 0 0-6.49-1.06zm.06 2a14.87 14.87 0 0 1 2.17.1A2.5 2.5 0 0 0 28 9.94v9.1A17.64 17.64 0 0 0 24.05 21c-3.42-.15-5.94.71-8.37 1.55-2.36.82-4.6 1.6-7.63 1.45-.38-.02-.75-.05-1.13-.1A2.5 2.5 0 0 0 4 22.05v-9.1a2.5 2.5 0 0 0 2.96-2.05c.68.07 1.37.11 2.05.1 3.17-.03 5.47-.83 7.7-1.6 1.96-.69 3.83-1.33 6.2-1.4zM16 11c-2.2 0-4 2.24-4 5s1.8 5 4 5 4-2.24 4-5-1.8-5-4-5zm0 2c1.08 0 2 1.37 2 3s-.92 3-2 3-2-1.37-2-3 .92-3 2-3zm7.5 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-15 3a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'money-check-alt-solid' => 'M2 7v18h28V7Zm2 2h24v14H4Zm2 2v2h10v-2Zm16 0v1.06c-1.13.19-2 1.14-2 2.31a2 2 0 0 0 1.1 1.79l2.9 1.46c0 .23-.15.38-.38.38h-1.25a.36.36 0 0 1-.37-.38V17h-2v.63c0 1.17.88 2.12 2 2.3V21h2v-1.06c1.13-.19 2-1.14 2-2.32 0-.75-.42-1.44-1.1-1.78L22 14.38c0-.23.15-.38.38-.38h1.25c.22 0 .37.15.37.38V15h2v-.63c0-1.17-.88-2.12-2-2.3V11ZM6 14v2h7v-2Zm2.5 3c-.6 0-1.03.34-1.31.66-.28.3-.5.66-.66 1.03A5.73 5.73 0 0 0 6 21h2c0-.32.16-1.02.38-1.5.06-.14.12-.19.18-.28l.22.31c.15.24.3.52.5.78.2.27.43.7 1.19.72.6.01.78-.2.97-.34.19-.14.32-.28.47-.4l.25-.23A7.71 7.71 0 0 0 16 21v-2c-1.23 0-1.87-.2-2.34-.4-.48-.21-.84-.6-1.66-.6-.6 0-.75.23-.94.38-.16.12-.27.25-.4.37l-.16-.25a4.68 4.68 0 0 0-.66-.88A1.95 1.95 0 0 0 8.5 17Z',
        'money-check-solid' => 'M2 7v18h28V7H2zm2 2h24v14H4V9zm2 2v2h10v-2H6zm14 0v5h6v-5h-6zM6 14v2h7v-2H6zm2.5 3c-.6 0-1.03.34-1.31.66-.28.3-.5.66-.66 1.03A5.73 5.73 0 0 0 6 21h2c0-.32.16-1.02.38-1.5.06-.14.12-.19.18-.28l.22.31c.15.24.3.52.5.78.2.27.43.7 1.19.72.6.01.78-.2.97-.34.19-.14.32-.28.47-.4l.25-.23A7.71 7.71 0 0 0 16 21v-2c-1.23 0-1.87-.2-2.34-.4-.48-.21-.84-.6-1.66-.6-.6 0-.75.23-.94.38-.16.12-.27.25-.4.37l-.16-.25a4.7 4.7 0 0 0-.66-.88A1.95 1.95 0 0 0 8.5 17zM20 19v2h6v-2h-6z',
        'monument-solid' => 'M16 4a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm0 4h-4v2h1.47l-.44 10H10v6H8v2h16v-2h-2v-6h-3.03l-.44-10H20V8Zm-.53 2h1.06l.44 10h-1.94ZM12 22h8v4h-8Z',
        'moon-solid' => 'M5 5v2H3v2h2v2h2V9h2V7H7V5Zm15.28 2.94L18.62 8a9.98 9.98 0 1 0 10.35 10.34l.06-1.62-1.47.69a5.99 5.99 0 0 1-7.97-7.97Zm-2.9 2.37c-.13.56-.38 1.06-.38 1.66 0 4.4 3.6 8 8 8 .6 0 1.12-.25 1.69-.38A7.87 7.87 0 0 1 19 25.97c-4.43 0-8-3.57-8-8a7.85 7.85 0 0 1 6.38-7.66Z',
        'moon' => 'M5 5v2H3v2h2v2h2V9h2V7H7V5Zm15.28 2.94L18.62 8a9.98 9.98 0 1 0 10.35 10.34l.06-1.62-1.47.69a5.99 5.99 0 0 1-7.97-7.97Zm-2.9 2.37c-.13.56-.38 1.06-.38 1.66 0 4.4 3.6 8 8 8 .6 0 1.12-.25 1.69-.38A7.87 7.87 0 0 1 19 25.97c-4.43 0-8-3.57-8-8a7.85 7.85 0 0 1 6.38-7.66Z',
        'mortar-pestle-solid' => 'M22.4 3c-.84.04-1.72.66-2.12 1.63v.03h-.03a22.86 22.86 0 0 1-1.69 3.43A32 32 0 0 0 16 8c-3.14 0-5.98.44-8.13 1.22a8.36 8.36 0 0 0-2.65 1.47 3.24 3.24 0 0 0-1.16 2c-.03.08-.05.16-.06.25v.15c0 .29 0 .66.03 1.13v.1c.02.22.06.45.1.71.03.25.05.49.09.72.2 1.35.61 2.96 1.44 4.53.58 1.11 1.38 2.2 2.46 3.13l.16.18c1.02 1.02 3.03 2.1 6.25 2.35A15.36 15.36 0 0 0 16 26c.51 0 1-.02 1.47-.06.07-.01.14-.03.22-.03l.9-.13.16-.03.16-.03a11.66 11.66 0 0 0 3.12-1.1l.47-.25c.44-.25.8-.46 1.06-.65a9.34 9.34 0 0 0 2.53-2.94 14.26 14.26 0 0 0 1.88-6.56c.03-.48.03-.87.03-1.16v-.15c0-.04-.03-.07-.03-.1v-.1c-.12-.99-.81-1.8-1.69-2.4a9.73 9.73 0 0 0-2.25-1.1c.31-.37.62-.76.97-1.12l.1-.09-.04-.03c.74-.67 1.07-1.66.85-2.44-.24-.82-.8-1.4-1.38-1.81A3.33 3.33 0 0 0 22.41 3Zm.1 2c.16 0 .55.1.88.34.32.23.57.56.62.72.05.17.12.17-.25.47l-.06.03-.03.03c-3.08 3.14-4.86 6.86-5.38 9.32-.73.05-1.5.09-2.28.09l-.9-.03a31.99 31.99 0 0 0 7.03-10.6c.18-.44.2-.36.37-.37ZM16 10c.45 0 .88.01 1.31.03-1.75 2.55-3.7 4.74-4.97 5.72a18.8 18.8 0 0 1-3.78-.88 6.9 6.9 0 0 1-2.03-1.06C6.11 13.45 6 13.18 6 13v-.1c.03-.17.17-.4.53-.71a6.9 6.9 0 0 1 2.03-1.06A22.8 22.8 0 0 1 16 10Zm6.78.94c1 .3 1.83.66 2.38 1.03.66.46.84.81.84 1.03v.06c-.02.18-.15.42-.53.75a6.9 6.9 0 0 1-2.03 1.06c-.83.3-1.85.56-2.97.76a21.1 21.1 0 0 1 2.31-4.7Zm2.9 5.12c-.08.46-.16.92-.3 1.4l-.1.32c-.02.08-.07.15-.1.22-.25.66-.54 1.25-.84 1.75a9.3 9.3 0 0 1-1.93 2.34c-.71.5-1.87 1.3-3.88 1.7l-.34.05a13.63 13.63 0 0 1-3.1.13c-.13 0-.25-.02-.37-.03-.45-.04-.86-.09-1.25-.16-.31-.06-.6-.1-.88-.19l-.53-.15a8.14 8.14 0 0 1-2-.97c-.12-.1-.23-.17-.31-.25l-.03-.03c-.17-.17-.4-.35-.75-.75A12.13 12.13 0 0 1 6.3 16.1c.47.26 1 .47 1.57.68C10.02 17.56 12.86 18 16 18c3.14 0 5.98-.44 8.13-1.22.57-.21 1.09-.45 1.56-.72Z',
        'mosque-solid' => 'm6.44 4.16-.9 2.5-1.48 4-.06.15V28h11v-3c0-.59.1-.85.19-1 .08-.15.18-.24.4-.4.12-.09.25-.18.41-.32.16.14.3.23.4.31.23.17.33.26.41.41.09.15.19.41.19 1v3h11V10.81l-.06-.19-1.53-4-.97-2.46-.9 2.5-1.48 4-.06.15V17h-.1a7.33 7.33 0 0 0-3.34-5.34c-.81-.55-1.58-.93-2.06-1.25a2.6 2.6 0 0 1-.47-.38L17 10V9h-2v1c0-.01.03-.05-.03.03s-.23.24-.47.4c-.48.34-1.25.74-2.06 1.29A7.34 7.34 0 0 0 9.09 17H9v-6.19l-.06-.19-1.53-4Zm.03 5.71L7 11.22V26H6V11.19Zm19 0 .53 1.35V26h-1V11.19ZM16 11.79c.13.1.25.2.38.28.64.43 1.37.82 2.06 1.28 1.18.8 2.2 1.74 2.47 3.66h-9.82c.27-1.9 1.29-2.85 2.47-3.66.69-.46 1.42-.84 2.06-1.28l.38-.28ZM9 19h14v7h-4v-1c0-.82-.15-1.49-.44-2a3.24 3.24 0 0 0-.97-1.03 2.6 2.6 0 0 1-.46-.38c-.06-.07-.13-.18-.13-.59h-2c0 .41-.07.52-.13.6-.05.07-.19.17-.46.37-.28.2-.68.52-.97 1.03a4.04 4.04 0 0 0-.44 2v1H9Z',
        'motorcycle-solid' => 'M22.5 6c-.66 0-1.2.41-1.4 1H17v2h4.25l.31 1H18a5.4 5.4 0 0 0-4.4 2h-3.38a7.4 7.4 0 0 0-3.72-1c-2.16 0-3.94.84-3.94.84l.88 1.82S4.87 13 6.5 13c.8 0 1.57.25 2.13.47l-.88 1.81A6 6 0 1 0 11.91 22h3.46c.76 0 1.48-.44 1.82-1.13h-.03l1.09-2.21c1.66-.77 3.02-2.1 3.97-3.35.26-.34.48-.66.69-.97l2.12 6.94 1.94-.56-1.13-3.69c.06 0 .1-.03.16-.03a4 4 0 1 1-2.9 1.25l-.63-2.1a6 6 0 1 0 2.75-1.09L23.38 9H25V6ZM18 12h4c-.15.27-.6 1.07-1.38 2.1-.92 1.21-2.22 2.5-3.46 2.96l-.41.13-.16.37L15.38 20H6v2h3.84A3.97 3.97 0 0 1 2 21a3.98 3.98 0 0 1 7.44-2h2.22a6.04 6.04 0 0 0-2.13-2.84l1.1-2.16h3.9l.31-.44S15.81 12 18 12Z',
        'mountain-solid' => 'm17.01 3.02-.91 1.66-6.52 11.86-1.92-1.92-.66 1.1-5.86 9.77L.24 27h31.28l-.6-1.4-3-7-.58-1.35-2.07 2.07-7.4-14.6-.86-1.7zm-.07 4.28 3.04 6-.77.66-2.28-1.95-2.28 1.95-.93-.8 3.22-5.86zm-.01 7.34 2.28 1.96 1.7-1.46 3.2 6.31.62 1.23 1.93-1.93L28.48 25H3.77l4.29-7.15 1.99 1.98.64-1.16 2.04-3.71 1.92 1.64 2.28-1.96z',
        'mouse-pointer-solid' => 'M9 2.6v25.56l1.66-1.38 4.03-3.37 2.03 4.03.44.9.9-.46 3.1-1.6.87-.44-.44-.9-1.84-3.63 5.06-.62 2.03-.25L25.41 19 10.7 4.28Zm2 4.84 11.56 11.53-4.5.53-1.4.19.65 1.28 2.07 4-1.32.69-2.15-4.32-.6-1.12-.97.81L11 23.84Z',
        'mouse-solid' => 'M16 4C10.49 4 6 8.49 6 14v4c0 5.51 4.49 10 10 10s10-4.49 10-10v-4c0-5.51-4.49-10-10-10Zm-1 2.06V13H8.06A8 8 0 0 1 15 6.06Zm2 0A8 8 0 0 1 23.94 13H17ZM8 15h16v3c0 4.43-3.57 8-8 8s-8-3.57-8-8Z',
        'mug-hot-solid' => 'M12 2v4h2V2Zm4 1v3h2V3ZM6 7v18c0 1.64 1.36 3 3 3h12c1.64 0 3-1.36 3-3v-5h2c1.64 0 3-1.36 3-3v-3c0-1.64-1.36-3-3-3h-2V7Zm2 2h14v16a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1Zm16 4h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-2Z',
        'music-solid' => 'm27 3.78-1.19.25-16 3-.81.13v13.4A3.93 3.93 0 0 0 7 20c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4V12.81l14-2.62v7.37a3.93 3.93 0 0 0-2-.56c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4Zm-2 2.4v2l-14 2.63v-2ZM23 19c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2ZM7 22c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'napster' => 'M16 4c-3.3 0-6.25 1.54-8.17 3.94-.91-.34-1.53-.5-1.58-.51L5.01 7.1V11a5 5 0 0 0 .04 8.01A11 11 0 0 0 16 29c5.72 0 10.43-4.39 10.95-9.97A5 5 0 0 0 27 11V7.1l-1.24.32c-.05 0-.67.17-1.59.51A10.45 10.45 0 0 0 16 4zm0 2a9.18 9.18 0 0 1 6.48 2.65c-.55.27-1.15.58-1.75.94a10.08 10.08 0 0 0-9.45 0c-.6-.36-1.2-.67-1.76-.94A9.18 9.18 0 0 1 16 6zM7 9.77c.96.35 2.35.94 3.72 1.83l.53.34.54-.33a8.06 8.06 0 0 1 8.43 0l.54.33.53-.34A18.98 18.98 0 0 1 25 9.77V18a9.01 9.01 0 0 1-18 0V9.77zM10.44 18H9c.04.45 0 1.75 1.4 2.56.22.13.8.32 1.35.35 1.34.06 3.25.08 3.25.08-.57-2.63-1.51-2.97-4.56-3zm11.12 0c-3.06.02-4 .36-4.56 2.99 0 0 1.91-.02 3.25-.08a3.67 3.67 0 0 0 1.36-.35c1.4-.82 1.35-2.12 1.39-2.56h-1.44zm-8.2 4A6.98 6.98 0 0 0 16 23.75c1-.37 1.9-.97 2.64-1.75h-5.28zm.65 2.44s-.15.08-.34.35a1.6 1.6 0 0 0-.19.5c1.53.94 3.52.94 5.04 0 0 0-.01-.2-.17-.47-.17-.28-.36-.38-.36-.38a7.1 7.1 0 0 1-3.98 0z',
        'neos' => 'M8.29 5 6 6.7V26h4.67L14 23.56v-4.04L18.37 26h3.42L25 24V5h-4.66L17 7.42v3.93L12.77 5H8.29zm1.1 1h2.84L21 19.15V6h3v17h-3.28L9.4 6zm-1.06.21L20.19 24h2.85l-1.57 1h-2.49L14 17.75v-.02h-.01L10 11.93v10.32L7 24.5V7.2l1.33-.99zM20 6.48v9.37l-2-3V7.93l2-1.45zm-9 8.59 2 2.97v5L10.34 25H8l3-2.25v-7.68z',
        'network-wired-solid' => 'M13 4v2H9C7.36 6 6 7.36 6 9v4H4v6h6v-6H8V9c0-.57.43-1 1-1h4v2h6V4Zm2 2h2v2h-2Zm5 0v2h3c.57 0 1 .43 1 1v4h-2v6h6v-6h-2V9c0-1.64-1.36-3-3-3ZM6 15h2v2H6Zm18 0h2v2h-2ZM6 20v3c0 1.64 1.36 3 3 3h4v2h6v-6h-6v2H9c-.57 0-1-.43-1-1v-3Zm18 0v3c0 .57-.43 1-1 1h-3v2h3c1.64 0 3-1.36 3-3v-3Zm-9 4h2v2h-2Z',
        'neuter-solid' => 'M16 4c-4.4 0-8 3.6-8 8a8.03 8.03 0 0 0 7 7.94V28h2v-8.06c3.93-.5 7-3.87 7-7.94 0-4.4-3.6-8-8-8Zm0 2a6 6 0 1 1 .02 11.98A6 6 0 0 1 16 6Z',
        'newspaper-solid' => 'M3 5v18a4 4 0 0 0 4 4h18a4 4 0 0 0 4-4V12h-6V5Zm2 2h16v16a4 4 0 0 0 .56 2H7c-1.2 0-2-.8-2-2Zm2 2v5h12V9Zm2 2h8v1H9Zm14 3h4v9c0 1.2-.8 2-2 2s-2-.8-2-2ZM7 15v2h5v-2Zm7 0v2h5v-2Zm-7 3v2h5v-2Zm7 0v2h5v-2Zm-7 3v2h5v-2Zm7 0v2h5v-2Z',
        'newspaper' => 'M3 5v18a4 4 0 0 0 4 4h18a4 4 0 0 0 4-4V12h-6V5Zm2 2h16v16a4 4 0 0 0 .56 2H7c-1.2 0-2-.8-2-2Zm2 2v5h12V9Zm2 2h8v1H9Zm14 3h4v9c0 1.2-.8 2-2 2s-2-.8-2-2ZM7 15v2h5v-2Zm7 0v2h5v-2Zm-7 3v2h5v-2Zm7 0v2h5v-2Zm-7 3v2h5v-2Zm7 0v2h5v-2Z',
        'nimblr' => 'M7 1v18h.03c-.01.17-.03.33-.03.5a9.51 9.51 0 0 0 19 0 9.47 9.47 0 0 0-16.57-6.33L7 1zm9.5 11a7.5 7.5 0 1 1-.02 15.02A7.5 7.5 0 0 1 16.5 12zm-3 5a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'node-js' => 'M16 3c-.37 0-.74.09-1.05.27L5.04 8.99A2.1 2.1 0 0 0 4 10.8v10.38c0 .75.4 1.44 1.04 1.81l2.6 1.5c1.26.62 1.71.62 2.28.62 1.87 0 2.94-1.13 2.94-3.09v-10.7a.3.3 0 0 0-.29-.3h-1.25a.3.3 0 0 0-.3.3V22c0 .88-.9 1.74-2.37 1.01l-2.72-1.57a.3.3 0 0 1-.16-.27V10.81c0-.12.06-.22.16-.28l9.91-5.72a.29.29 0 0 1 .31 0l9.91 5.72c.1.06.16.16.16.27v10.38c0 .11-.06.22-.15.27l-9.92 5.73a.34.34 0 0 1-.31 0l-2.55-1.51a.23.23 0 0 0-.24-.02c-.7.4-.84.45-1.5.68-.16.05-.4.15.1.43l3.3 1.96c.32.18.68.28 1.04.28.37 0 .73-.1 1.05-.28L26.96 23A2.1 2.1 0 0 0 28 21.18V10.81c0-.75-.4-1.44-1.04-1.81l-9.92-5.73A2.11 2.11 0 0 0 15.99 3zm2.66 8c-2.83 0-4.52 1.2-4.52 3.2 0 2.18 1.68 2.77 4.4 3.04 3.25.32 3.5.8 3.5 1.45 0 1.1-.89 1.57-2.98 1.57-2.63 0-3.21-.67-3.4-1.97a.28.28 0 0 0-.28-.24H14.1a.28.28 0 0 0-.28.29c0 1.67.91 3.65 5.25 3.65C22.2 22 24 20.76 24 18.6c0-2.13-1.45-2.7-4.49-3.12-3.09-.4-3.4-.6-3.4-1.33 0-.6.27-1.38 2.55-1.38 2.03 0 2.79.43 3.1 1.8.03.13.14.23.28.23h1.29a.3.3 0 0 0 .2-.1.27.27 0 0 0 .08-.22c-.2-2.36-1.77-3.46-4.95-3.46z',
        'node' => 'M21.3 6a.3.3 0 0 0-.3.3v5.5l-1.25-.73a.5.5 0 0 0-.5 0l-3 1.75a.5.5 0 0 0-.25.43v3.5c0 .18.1.34.25.43l3 1.75a.5.5 0 0 0 .5 0l3-1.75a.5.5 0 0 0 .25-.43V7.23a.5.5 0 0 0-.25-.43l-1.3-.76A.3.3 0 0 0 21.3 6zm-9.8 5a.5.5 0 0 0-.25.07l-3 1.75a.5.5 0 0 0-.25.43v3.5c0 .18.1.34.25.43l3 1.75c.15.1.35.1.5 0l3-1.75a.5.5 0 0 0 .25-.43v-3.5a.5.5 0 0 0-.25-.43l-3-1.75a.5.5 0 0 0-.25-.07zm16 0a.5.5 0 0 0-.25.07l-3 1.75a.5.5 0 0 0-.25.43v3.5c0 .18.1.34.25.43l2.9 1.76c.16.1.36.1.52 0l1.42-.83a.22.22 0 0 0 0-.38L26 15.9v-1.8l1.5-.86 1.5.87v1.25c0 .17.14.2.23.14l1.52-.89a.5.5 0 0 0 .25-.43v-.93a.5.5 0 0 0-.25-.43l-3-1.75a.5.5 0 0 0-.25-.07zm-24 0a.5.5 0 0 0-.25.07l-3 1.75a.5.5 0 0 0-.25.43v4.47c0 .21.24.35.42.24l1.33-.77a.5.5 0 0 0 .25-.43V14.1l1.5-.87 1.5.87v2.65c0 .17.1.34.25.43l1.33.77c.18.11.42-.03.42-.24v-4.47a.5.5 0 0 0-.25-.43l-3-1.75A.5.5 0 0 0 3.5 11zm16 2.24 1.5.87v1.78l-1.5.87-1.5-.87V14.1l1.5-.87zm8 .76-.86.5v1l.86.5.86-.5v-1l-.86-.5zm-12.1 4a.6.6 0 0 0-.3.07l-2.8 1.63c-.19.1-.3.3-.3.51v3.25c0 .2.12.4.3.5l.74.43c.35.18.48.18.64.18.53 0 .84-.32.84-.88v-3.2a.08.08 0 0 0-.09-.1h-.35a.08.08 0 0 0-.09.1v3.2c0 .24-.25.5-.67.28l-.77-.44a.1.1 0 0 1-.04-.07V20.2a.1.1 0 0 1 .04-.08l2.81-1.62a.1.1 0 0 1 .09 0l2.81 1.62c.03.02.05.04.05.08v3.25a.1.1 0 0 1-.05.07l-2.81 1.63a.1.1 0 0 1-.09 0l-.72-.43c-.02 0-.05-.01-.07 0-.2.11-.23.13-.42.2-.05 0-.12.04.03.11l.93.56c.1.05.2.08.3.08.1 0 .2-.03.29-.08l2.81-1.63c.19-.1.3-.3.3-.51V20.2a.6.6 0 0 0-.3-.51l-2.81-1.63a.58.58 0 0 0-.3-.07zm4.4 1.5a.54.54 0 1 0 0 1.08.54.54 0 0 0 0-1.08zm-.01.08c.25 0 .46.2.46.46 0 .24-.21.45-.46.45a.46.46 0 0 1-.45-.45c0-.26.2-.46.45-.46zm-.2.15v.6h.12v-.24h.1c.05 0 .06.02.07.06l.02.19h.13a.72.72 0 0 1-.03-.16c-.02-.08-.02-.14-.1-.14.04-.02.11-.04.11-.15 0-.16-.14-.16-.21-.16h-.21zm.12.1h.1c.02 0 .08 0 .08.08 0 .03-.01.09-.1.09h-.08v-.17zm-3.55.5c-.8 0-1.28.33-1.28.9 0 .62.48.78 1.25.86.92.1.99.22.99.4 0 .32-.25.45-.85.45-.74 0-.9-.18-.96-.55 0-.04-.04-.07-.09-.07h-.36a.08.08 0 0 0-.08.08c0 .47.25 1.04 1.49 1.04.9 0 1.41-.35 1.41-.97 0-.6-.41-.77-1.28-.88-.87-.12-.96-.18-.96-.38 0-.17.07-.4.72-.4.58 0 .8.13.88.52.01.04.04.06.08.06h.36c.03 0 .05 0 .06-.02.02-.02.03-.04.02-.06-.06-.68-.5-.99-1.4-.99z',
        'not-equal-solid' => 'M6.72 5.28 5.28 6.72l20 20 1.44-1.44L21.44 20H27v-2h-7.56l-4-4H27v-2H13.44ZM5 12v2h4.9l-2-2Zm0 6v2h10.9l-2-2Z',
        'notes-medical-solid' => 'M16 3c-1.26 0-2.15.9-2.6 2H6v23h20V5h-7.4c-.45-1.1-1.34-2-2.6-2Zm0 2a1 1 0 0 1 1 1v1h3v2h-8V7h3V6a1 1 0 0 1 1-1ZM8 7h2v4h12V7h2v19H8Zm7 7v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'npm' => 'M0 10v11h9v2h7v-2h16V10H0zm1.78 1.78h7.11v7.67H7.11v-5.9H5.33v5.9H1.78v-7.67zm8.89 0h7.1v7.66h-3.55v1.78h-3.55v-9.44zm8.89 0h10.66v7.67h-1.77v-5.9h-1.78v5.9h-1.78v-5.9h-1.78v5.9h-3.55v-7.67zm-5.34 1.78v4.1H16v-4.1h-1.78z',
        'ns8' => 'M29.02 10.02c-2.03 0-4.16 1.16-3.57 3.02a8.52 8.52 0 0 0-4.7 2.4c-.16-.48-.69-.82-1.7-.82h-4.39c-.46 0-.64-.11-.57-.37l.18-.6c.1-.33.4-.36.67-.36h6.67l.49-1.58c-6.99 0-7.23-.03-8 .06-.62.06-1.18.24-1.54.75-.34.5-.72 1.78-.88 2.36-.27.96-.03 1.42 1.64 1.42h4.37c.39 0 .44.14.38.33-.05.22-.14.5-.22.74-.08.2-.24.36-.7.36h-6.33l-.58 1.98c7 0 7.26-.03 8.04-.11.33-.04.65-.11.93-.25a3.68 3.68 0 0 0 2.9 3.52c2.43.59 5.43-.85 6.75-3.4.94-1.82.7-3.82-.17-5.28 1.49-.3 3.52-1.1 3.3-2.53-.15-.9-1.2-1.4-2.11-1.56a5.01 5.01 0 0 0-.86-.08zm-.36.98c.15 0 .3 0 .43.04.77.17.99.8.25 1.22-.54.3-1.18.4-1.71.48-.21-.3-.5-.92-.13-1.31.25-.27.71-.42 1.16-.43zm-19.3.7-1.71 5.7-2.73-5.7H2.45L0 19.72h2.24l1.56-5.33 2.53 5.33h2.85l2.42-8H9.36zm16.82 2.8a4 4 0 0 1 .36 2.4 2.85 2.85 0 0 1-3.08 2.2c-1.55-.25-1.93-1.98-.7-3.25.8-.84 2.25-1.2 3.42-1.34z',
        'nutritionix' => 'M10 2c0 7 5.57 6.43 5.57 6.43a5.95 5.95 0 0 0-4.12-5.76c3.93.3 4.98 5.34 4.98 5.34 2.26-3.17 4.4-2.62 4.4-2.62-2.77.1-3.54 3.04-3.54 3.04 3.76.96 4.71-3 4.71-3-4.55-1.62-5.52 2.17-5.52 2.17C17 2 10 2 10 2zm6 7c-3.46 0-6.48.98-8.8 2.7A14.5 14.5 0 0 0 5 19c0 2.69.54 5.28 1.75 7.33C9.08 28.05 12.54 29 16 29s6.92-.95 9.25-2.67A14.45 14.45 0 0 0 27 19c0-2.69-.97-5.25-2.2-7.3A14.62 14.62 0 0 0 16 9zm0 1.3c3 0 5.91.68 8.1 1.8.48 1.08.62 1.9.9 3.15a50.6 50.6 0 0 0-9-.83c-3.44 0-6.62.39-9 .83.28-1.25.4-2.05.9-3.15 2.19-1.12 5.1-1.8 8.1-1.8zM10.44 16a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88zm3.7 0c.81 0 1.45.64 1.45 1.44 0 .8-.64 1.44-1.45 1.44-.79 0-1.43-.64-1.43-1.44 0-.8.64-1.44 1.43-1.44zm3.72 0c.79 0 1.43.64 1.43 1.44 0 .8-.64 1.44-1.43 1.44-.81 0-1.45-.64-1.45-1.44 0-.8.64-1.44 1.45-1.44zm3.7 0a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88zm-11.12 3.57a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88zm3.7 0a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 0 1 0-2.88zm3.72 0c.79 0 1.43.64 1.43 1.45 0 .8-.64 1.43-1.43 1.43a1.43 1.43 0 1 1 0-2.88zm3.7 0a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88zm-11.12 3.55a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88zm3.7 0a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 0 1 0-2.88zm3.72 0c.79 0 1.43.64 1.43 1.45 0 .8-.64 1.43-1.43 1.43a1.43 1.43 0 1 1 0-2.88zm3.7 0a1.44 1.44 0 1 1 0 2.88 1.44 1.44 0 1 1 0-2.88z',
        'object-group-solid' => 'M5 5v4h1v14H5v4h4v-1h14v1h4v-4h-1V9h1V5h-4v1H9V5Zm4 3h14v1h1v14h-1v1H9v-1H8V9h1Zm1 2v8h4v4h8v-8h-4v-4Zm2 2h4v4h-4Zm6 4h2v4h-4v-2h2Z',
        'object-group' => 'M5 5v4h1v14H5v4h4v-1h14v1h4v-4h-1V9h1V5h-4v1H9V5Zm4 3h14v1h1v14h-1v1H9v-1H8V9h1Zm1 2v8h4v4h8v-8h-4v-4Zm2 2h4v4h-4Zm6 4h2v4h-4v-2h2Z',
        'object-ungroup-solid' => 'M5 5v4h1v10H5v4h4v-1h2v2h-1v4h4v-1h10v1h4v-4h-1V14h1v-4h-4v1h-2V9h1V5h-4v1H9V5Zm4 3h10v1h1v10h-1v1H9v-1H8V9h1Zm13 5h2v1h1v10h-1v1H14v-1h-1v-2h6v1h4v-4h-1Z',
        'object-ungroup' => 'M5 5v4h1v10H5v4h4v-1h2v2h-1v4h4v-1h10v1h4v-4h-1V14h1v-4h-4v1h-2V9h1V5h-4v1H9V5Zm4 3h10v1h1v10h-1v1H9v-1H8V9h1Zm13 5h2v1h1v10h-1v1H14v-1h-1v-2h6v1h4v-4h-1Z',
        'odnoklassniki-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 2a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zm0 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zm-3.14 5.01a1 1 0 0 0-.46 1.79c.7.53 1.5.87 2.33 1.05L12.3 21.3a1 1 0 1 0 1.42 1.42L16 20.4l2.3 2.3a1 1 0 0 0 1.4 0 1 1 0 0 0 0-1.42l-2.43-2.44a5.94 5.94 0 0 0 2.33-1.05 1 1 0 0 0-1.2-1.6 4.06 4.06 0 0 1-4.8 0 1 1 0 0 0-.74-.19z',
        'odnoklassniki' => 'M15 8.33a2.35 2.35 0 1 1 0 4.7 2.35 2.35 0 0 1 0-4.7Zm0 8.03a5.68 5.68 0 1 0 0-11.37 5.68 5.68 0 0 0 0 11.37Zm2.3 4.63a10.7 10.7 0 0 0 3.3-1.37 1.66 1.66 0 1 0-1.78-2.82 7.21 7.21 0 0 1-7.64 0 1.66 1.66 0 1 0-1.77 2.82A10.7 10.7 0 0 0 12.7 21l-3.18 3.17a1.66 1.66 0 0 0 2.35 2.35L15 23.4l3.12 3.12a1.66 1.66 0 0 0 2.35-2.35L17.3 21Z',
        'oil-can-solid' => 'M11 9v2h2v2H7.56l-1.72-2.56-.3-.44H1v5.69l5 2V25h14.53l.28-.44L29.5 12H31v-2h-3.34l-.25.19L21 15v-2h-6v-2h2V9Zm-8 3h1.44L6 14.34v1.16l-3-1.19Zm22.78 1.94L19.5 23H8v-8h11v4l1.6-1.19ZM29.5 16S28 18.67 28 19.5a1.5 1.5 0 0 0 3 0c0-.83-1.5-3.5-1.5-3.5Z',
        'old-republic' => 'm16.54 3-1.18.01-.39.03-.56.05-.41.06-.55.1A12.92 12.92 0 0 0 5.8 7.92c-.6.76-1.12 1.6-1.54 2.47-.07.15-.15.3-.2.45a12.7 12.7 0 0 0-.8 2.53c-.05.2-.08.4-.12.62l-.06.44-.05.5c-.01.18-.03.36-.03.55-.01.5-.02 1 .02 1.5.03.2.03.41.07.62l.04.37a12.04 12.04 0 0 0 .6 2.38 13.02 13.02 0 0 0 9.62 8.38c.21.05.43.08.64.12l.43.06.52.05a12.6 12.6 0 0 0 2.12 0 20.53 20.53 0 0 0 1.56-.22c.36-.08.71-.17 1.06-.27a13.1 13.1 0 0 0 8.04-6.86c.43-.89.76-1.83.97-2.8l.15-.81c.03-.14.04-.29.06-.43a8.54 8.54 0 0 0 .09-1.31 12.04 12.04 0 0 0-.18-2.42 12.52 12.52 0 0 0-.89-3.01c-.05-.14-.12-.27-.18-.4a13.13 13.13 0 0 0-8.2-6.94c-.4-.11-.8-.21-1.22-.28l-.46-.08c-.25-.03-.5-.07-.77-.09-.19-.01-.37-.03-.56-.03zm-.73 1c.4 0 .8 0 1.19.04l.63.06a11.88 11.88 0 0 1 9.55 7.5c.38.96.63 1.97.75 3l.05.62a12.24 12.24 0 0 1-1.5 6.55c-.16.29-.33.57-.51.84a12.08 12.08 0 0 1-6.7 4.84l-.67.16-.59.11-.71.1a12.31 12.31 0 0 1-4.55-.4c-.28-.08-.55-.18-.82-.27a11.96 11.96 0 0 1-7.4-8.08l-.17-.75a11.25 11.25 0 0 1-.24-2.28 11.54 11.54 0 0 1 .32-2.82A11.9 11.9 0 0 1 7.53 7.6l.38-.38c.26-.24.52-.47.8-.68a12.18 12.18 0 0 1 5.62-2.42c.49-.06.98-.11 1.48-.12zm-3.24 1.8a8.7 8.7 0 0 0-2.27 1.06 6.9 6.9 0 0 0-2.89 4.12c-.2.8-.28 1.63-.24 2.45 0 .24.03.47.06.7.08.55.21 1.09.42 1.6l.2.4.16.32c.24.45.53.88.87 1.26a5.17 5.17 0 0 0 1.73 1.26 4.3 4.3 0 0 0 1.82.36v-.26l-.01-.46v-.9l-.01-.38v-.55l-.01-.65c0-.16.01-.33-.03-.49-.06-.21-.18-.4-.32-.58a2.9 2.9 0 0 0-.34-.36c-.24-.24-.53-.43-.78-.66a6 6 0 0 1-1.17-1.43 4.16 4.16 0 0 1-.17-3.95 5 5 0 0 1 .89-1.3c.46-.5 1-.94 1.59-1.29.16-.1.33-.18.5-.27zm6.92 0 .3.16c.67.37 1.3.85 1.81 1.42a5.52 5.52 0 0 1 1.1 1.86 4.3 4.3 0 0 1 .15 1.91c-.06.34-.16.66-.3.97a5.49 5.49 0 0 1-1.77 2.21c-.34.28-.69.57-.92.96-.07.11-.13.24-.16.37-.04.15-.03.31-.03.47l-.01.8v.37l-.01 1.1v.6c0 .11-.02.23 0 .34h.29a4.57 4.57 0 0 0 2.41-.87c.53-.38.99-.87 1.35-1.42a7.64 7.64 0 0 0 .98-2.12 7.32 7.32 0 0 0 .2-2.53 8.06 8.06 0 0 0-.59-2.5l-.2-.42a6.77 6.77 0 0 0-3.2-3.11c-.3-.17-.64-.3-.97-.42l-.43-.14zm-5.12 3.25a5.6 5.6 0 0 0-1.1 1.76 6.8 6.8 0 0 0-.36 1.18c-.02.15-.06.3-.06.46l.24.03c.28.08.53.25.73.45a4.24 4.24 0 0 1 1.26 2.8c.03.34.06.69.07 1.03l.01.44v.37l-.01.69-.02.29c-.01.56-.07 1.11-.11 1.67l-.07.63c-.07.5-.12.99-.24 1.47-.07.36-.16.7-.27 1.05-.08.23-.15.47-.26.69a.42.42 0 0 1-.12.16c-.06-.02-.1-.08-.13-.14a3.18 3.18 0 0 1-.18-.34l-.19-.38a3.33 3.33 0 0 0-.3-.5 1.4 1.4 0 0 0-.6-.51 1 1 0 0 0-.61-.03l-.33.06c-.19.02-.37.05-.57.06h-.8l-.43-.01c-.16-.02-.33 0-.5-.04a3.8 3.8 0 0 1-1.28-.58 9.9 9.9 0 0 1-1.53-1.28l-.44-.47.17.32c.18.34.37.68.58 1 .39.64.82 1.25 1.34 1.78.2.2.4.38.63.53a2.54 2.54 0 0 0 2.1.41 4.4 4.4 0 0 0 1.28-.57 3.37 3.37 0 0 1-2.13 1.3c.08.08.18.14.28.21a9.88 9.88 0 0 0 4.64 1.56c.25.03.51.03.78.04l.73-.02a10.66 10.66 0 0 0 5.05-1.67l.21-.15-.23-.03a2.37 2.37 0 0 1-.67-.3 4.9 4.9 0 0 1-1.17-.98c.16.12.33.23.5.32l.43.2c.18.05.36.11.54.14.46.07.94 0 1.37-.17.44-.18.83-.46 1.18-.77.25-.24.49-.5.7-.77.35-.45.66-.94.93-1.44l.22-.44.22-.5c-.07.07-.12.15-.18.23a6.65 6.65 0 0 1-2.38 1.83 4.71 4.71 0 0 1-1.9.34 5.73 5.73 0 0 1-.58-.07c-.34-.06-.68-.13-1.02-.1a1.5 1.5 0 0 0-.79.32.65.65 0 0 0-.13.18l-.65 1.23-.09.15a.08.08 0 0 1-.09.03 4.83 4.83 0 0 1-.9-1.6 14 14 0 0 1-.48-2.16c-.04-.22-.05-.43-.08-.65-.03-.16-.03-.32-.05-.49l-.05-.54-.04-.57-.01-.23-.01.62v.95l-.01.61v.57l-.01.94v.64l-.01.57v.92l-.01.64c0 .11.01.23-.03.35-.03.08-.07.17-.12.25-.04.06-.1.12-.18.13-.06.01-.12-.02-.17-.06a.82.82 0 0 1-.16-.24.58.58 0 0 1-.08-.22V13.2c0-.18-.1-.35-.23-.46-.15-.12-.32-.2-.48-.29-.1-.05-.2-.09-.28-.16-.14-.1-.26-.24-.36-.38-.23-.33-.4-.7-.46-1.1a2.1 2.1 0 0 1 .44-1.61l.1-.14zm1.53.25-.05.01-.18.77-.02.06h-.53c-.27.02-.53 0-.8.01v.06l.29.1.5.15.2.07v.09c-.07.04-.15.05-.22.08l-.54.17c-.07.03-.15.04-.22.08-.02 0 0 .04 0 .06h1.06l.26.01.06.24.14.6h.05c.02-.1 0-.19.01-.28V9.3zm.26 0v2.28c0 .1-.01.19 0 .28h.06l.13-.57.06-.27h1.07l.26-.01v-.06l-.07-.03-.76-.24a.75.75 0 0 1-.15-.06v-.09c.04 0 .07-.02.1-.03l.58-.19c.1-.03.2-.05.3-.1v-.05h-.11l-.82-.01h-.4l-.05-.23-.14-.6-.06-.02zM6.6 10.96c-.07.1-.12.23-.18.34a10.04 10.04 0 0 0-.86 2.66l-.06.45a5.9 5.9 0 0 0 .01 1.83l.06.35.1.46a8.56 8.56 0 0 0 .5 1.51 6.44 6.44 0 0 0 1.58 2.2c.36.3.76.55 1.18.75.19.1.38.17.58.25a4.5 4.5 0 0 0 3.3-.12.4.4 0 0 0-.01-.12l-.12-.47c-.1-.35-.28-.7-.53-.97a1.6 1.6 0 0 0-.69-.45c-.2-.06-.4-.09-.6-.14a6.37 6.37 0 0 1-.8-.26c-.19-.06-.36-.16-.53-.24a4.55 4.55 0 0 1-.81-.57 8.91 8.91 0 0 1-1.04-1.1c-.22-.28-.4-.59-.55-.9a7.96 7.96 0 0 1-.72-4.25c.04-.4.1-.81.19-1.2zm18.89 0a9.2 9.2 0 0 1 .13 3.26c-.02.15-.04.3-.08.45a6.14 6.14 0 0 1-1.61 3.2c-.08.1-.17.17-.25.26a4.81 4.81 0 0 1-2.56 1.39c-.2.04-.4.06-.58.14-.16.07-.3.15-.43.26-.2.17-.37.38-.5.62-.14.27-.24.57-.3.87-.01.08-.04.15-.03.23l.31.13a4.22 4.22 0 0 0 3.17-.08 5.36 5.36 0 0 0 2.62-2.13 7.67 7.67 0 0 0 1.1-2.75 7 7 0 0 0 .16-1.5v-.27a9.15 9.15 0 0 0-.7-3.1c-.08-.23-.2-.47-.3-.7l-.15-.28z',
        'om-solid' => 'M29 19.12c0 2.09-.84 7.45-5.41 7.45-4.35 0-5.94-3.84-5.64-5.23.25.43 1.05 2.62 5.33 2.62 4.39 0 4.43-4.88 4.43-4.88s-.07-3.46-2.75-3.46c-3.26 0-3.37 5.19-6.65 5.19-1.65 0-2.2-.87-2.53-1.11.7 2.2-.13 7.3-5.5 7.3C2.6 27 3 18.72 3 18.72s1.29 5.1 7.14 5.1c3.57 0 4.04-2.03 4.04-2.97 0-.93-.7-2.57-3.9-2.57l-.7-3.32s.94.31 2.11.31c1.54 0 1.9-1.02 1.9-1.87 0-.84-.83-1.69-2.34-1.69-2.34 0-4.21 2.4-4.21 2.4l-1.82-3.37s1.69-2.18 5.1-2.18A4.8 4.8 0 0 1 15.3 13c0 1.64-.76 3-2.22 3.77 1.97.92 1.37 1.6 2.62 1.6 2.07 0 2.35-1.7 3.33-3.23.9-1.41 2.17-2.67 4.43-2.67 4.53 0 5.55 4.57 5.55 6.65Zm-8.83-7.14c2.3 0 4.08-1.33 4.08-1.33l-1.9-3.37s-1.33 1.86-3.9 1.86c-2.58 0-4.71-2.35-4.71-2.35s.97 5.19 6.43 5.19Zm.36-5.37-1.91-2.04-2.13 1.86 1.9 2.18Z',
        'opencart' => 'M1 5.25c2.93 5.57 8.12 6.43 14.4 6.56 3.72.08 11.88-.24 11.88 1.75 0 1.5-5.44 6.17-5.44 7.13 0 0 3.77-3.19 5.88-5.07 2.1-1.87 3.28-2.98 3.28-4.09 0-2.26-8.73-1.84-15.78-1.84C8.17 9.69 4.32 8.35 1 5.25Zm7.88 17.28a2.1 2.1 0 1 0 0 4.22 2.1 2.1 0 0 0 2.09-2.13c0-1.16-.93-2.09-2.1-2.09Zm9.74 0c-1.16 0-2.09.93-2.09 2.1a2.1 2.1 0 1 0 4.22 0 2.1 2.1 0 0 0-2.13-2.1Z',
        'openid' => 'm19 4-4 1.94v19.68c-5.14-.67-8.06-3.02-8.06-5.96 0-2.77 2.98-5.1 7.06-5.85v-2.5c-6.28.8-11 4.23-11 8.35 0 4.29 4.52 7.81 12 8.43l4-1.87Zm1 7.38v2.53c1.31.28 2.5.73 3.5 1.3l-2.13 1.2L29 18.06l-.53-5.62-2.03 1.12A17.44 17.44 0 0 0 20 11.37Z',
        'opera' => 'M15.97 4C9.67 4 5 8.95 5 15.9 5 22.2 9.46 28 15.97 28 22.53 28 27 22.2 27 15.9 27 8.89 22.21 4 15.97 4Zm0 2C21.2 6 25 9.75 25 15.9c0 5.36-3.66 10.1-9.03 10.1C10.65 26 7 21.26 7 15.9 7 9.8 10.68 6 15.97 6Zm0 .31c-1.04 0-2 .4-2.66 1.07a5.86 5.86 0 0 0-1.37 2.4 19.8 19.8 0 0 0-.72 5.94c0 1.76.07 4 .62 5.94a6.2 6.2 0 0 0 1.35 2.59 3.82 3.82 0 0 0 5.56 0 6.19 6.19 0 0 0 1.38-2.6c.57-1.92.65-4.15.65-5.93 0-2.07-.16-4.23-.78-6.03a5.74 5.74 0 0 0-1.4-2.38c-.68-.63-1.6-1-2.63-1Zm0 2c.57 0 .9.15 1.25.47.34.32.66.83.9 1.53.49 1.4.66 3.44.66 5.4 0 1.73-.1 3.84-.56 5.38a4.5 4.5 0 0 1-.9 1.79 1.7 1.7 0 0 1-1.35.56c-.61 0-.96-.19-1.31-.57-.36-.37-.69-1-.91-1.78a21.13 21.13 0 0 1-.53-5.37c0-1.83.15-3.87.62-5.31.24-.73.57-1.26.91-1.6.34-.33.66-.5 1.22-.5Z',
        'optin-monster' => 'M16.84 3.25c-2.1 0-2.84 1.78-2.84 1.78s1.05-.66 2.4-.66a5.07 5.07 0 0 1 3.73 1.82s-.07-2.94-3.29-2.94Zm-1.96 2.28c-3.11 0-4.72.5-4.72.5s1.61.26 2.78.78c-4.33.6-6.4 3.22-6.4 3.22s1.6-.28 2.18-.22a6.4 6.4 0 0 0-1.31 1h-.2c-.69-.06-.97-.02-1.02-.72C6.14 9.4 6.02 9 5.37 9c-.64 0-1.56 1.41-1.56 2.84 0 1.63.37 3.04 3.22 3.13v.12s.96.06 1.22.63c.12.03.23.1.34.19l-.8.09c-.27-.32-.63-.38-.98-.38-.02-.17-.26-.53-.6-.53-.56 0-.83.82-.83.82s-1.25.37-1.25 1.71c0 1.56 1.38 2.32 2.28 2.32v1.03c-.25-.22-.48-.34-.7-.34-.2 0-.42.03-.62.06-.1-.1-.28-.28-.5-.28-.27 0-.33.33-.34.53-.29.12-.57.26-.81.43a.72.72 0 0 0-.31-.09c-.18 0-.2.18-.2.28v.25c-.2.22-.36.46-.5.69a.88.88 0 0 0-.27-.06c-.12 0-.16.04-.16.12 0 .07.07.34.16.53-.07.21-.1.41-.1.6 0 1.15 1.83 3.06 3.69 3.06.21 0 1.4-.2 1.9-1.16.12 0 5.62.16 8.22.16 2.6 0 8.28-.18 8.44-.19.5.98 1.73 1.19 1.94 1.19 1.86 0 3.69-1.91 3.69-3.06 0-.19-.03-.36-.1-.57.09-.19.16-.5.16-.56 0-.08-.04-.12-.16-.12a1 1 0 0 0-.28.06 3.44 3.44 0 0 0-.5-.69c.02-.1 0-.2 0-.25 0-.1-.01-.28-.18-.28-.1 0-.22.04-.32.1a3.94 3.94 0 0 0-.81-.44c0-.2-.07-.53-.34-.53-.22 0-.4.17-.5.28-.2-.03-.42-.03-.63-.03-.2 0-.44.1-.69.3v-1.02c.9 0 2.29-.76 2.29-2.32 0-1.34-1.25-1.71-1.25-1.71s-.28-.82-.85-.82c-.33 0-.57.36-.6.54-.35 0-.73.04-1 .4l-.87-.1c.13-.08.27-.15.44-.21.37-.56 1.22-.6 1.22-.6v-.15c2.93-.07 3.28-1.51 3.28-3.16 0-1.42-.89-2.81-1.53-2.81-.65 0-.8.37-.84 1.06-.06.7-.34.69-1.04.75-.25.03-.56 0-.78-.03-1.12-2.54-3.62-5.25-9.18-5.25Zm1.18 1a3.72 3.72 0 1 1 0 7.44 3.74 3.74 0 0 1-3.75-3.72c0-2.05 1.7-3.72 3.75-3.72Zm.07 2.56c-.35 0-.68.05-.97.16.44.16.75.59.75 1.06 0 .62-.53 1.13-1.2 1.13-.44 0-.85-.22-1.05-.56a2 2 0 0 0-.07.53c0 1.29 1.14 2.34 2.54 2.34 1.39 0 2.53-1.05 2.53-2.34 0-1.3-1.14-2.32-2.54-2.32Zm-10.66.6c.23 0 .24.44.25.6.01.14.1.37.1.37-1.12.55-1.35 1.45-1.5 1.78 0-2.32.91-2.75 1.15-2.75Zm21.12.03c.24 0 1.2.4 1.2 2.72-.17-.33-.43-1.23-1.54-1.78 0 0 .08-.23.1-.38 0-.15 0-.56.24-.56ZM6.03 11c.12.1.22.25.66.28 0 0-.66.95-.66 2s.1 1.06.1 1.06-1.26-.2-1.57-.93c.08-1.12.54-2.08 1.47-2.41Zm20.03 0c.94.33 1.37 1.3 1.44 2.4-.3.75-1.56.94-1.56.94s.1 0 .1-1.06c0-1.05-.66-2-.66-2 .43-.03.57-.19.68-.28Zm-1.78.34h.63s.75.93.75 1.82-.1 1.28-.1 1.28l-.62.03c-.05-.69-.18-1.83-.66-3.13Zm-16.4.1-.1.5-.03.06c-.37.88-.57 1.84-.66 2.47l-.56-.03s-.12-.4-.12-1.28c0-.57.27-1.07.5-1.41.32-.13.66-.23.96-.31Zm9.87 3.5c.46 0 1.31.03 1.31.03a9.05 9.05 0 0 0 .03 1.72c-.02.2-.03.4-.5.4-.55 0-.47.07-.84.07s-1.32 0-1.38-.5c-.06-.56-.12-1.7-.12-1.7l1.5-.02Zm-2.19.03s.1.79.1 1.53 0 .1-.04.72c-.02.33.14.5-1.37.5-1.56 0-1.56-.1-1.56-1.28 0-1.2.1-1.44.1-1.44s2.55 0 2.77-.03Zm4.19 0s1.79.07 1.94.1c0 .54-.33 2.8-1.35 2.8-.35 0-.36-1.18-.4-1.68-.06-.6-.19-1.22-.19-1.22Zm-7.63.03L12 16.69c-.02.26-.1.79-.1.84 0 .06-.05.31-.24.31-.22 0-1.41-.38-1.41-2.06 0-.3.06-.69.06-.69Zm-2.34 1.47c.3 1.35 1.48 1.94 1.94 1.94.48 0 .55-.46.6-.72.3.52 1.16.56 1.74.56 2.21 0 2.18-.53 2.22-.75 0 0 .34.22 1.31.22 1.92 0 2.04-.47 2.04-.47s.19 1.22.75 1.22c1.2 0 1.75-1.97 1.75-1.97l.5.03h.12l.69.06c-.03.06-.07.1-.07.16 0 .25.41.44.41.44s-.12.1-.22.22c-.57.52-1.52 1.41-2.28 2.06-.97.82-2.8 2.18-5.47 2.94a18.75 18.75 0 0 1-4.62-2.47 35.4 35.4 0 0 1-2.66-2.38c-.1-.21-.31-.37-.31-.37s.4-.19.4-.44c0-.05-.03-.1-.06-.16Zm13.88 1.78c.18.13.37.19.37.19l.03.15s-.28.1-.28.38c0 .37.75.5.75.5s.1.18.34.31v2.1c-.4.68-.7 1.59-.75 2.56-1.55-1.08-4.82-2.18-5.53-2.4.83-.43 1.66-.94 2.47-1.54.98-.73 1.93-1.62 2.6-2.25Zm-15.35.03c.43.4 1.7 1.56 2.5 2.22.51.42 1.44 1 2.38 1.5a28.67 28.67 0 0 0-5.31 2.4 5.7 5.7 0 0 0-.75-2.52v-2.1c.24-.13.34-.31.34-.31s.75-.13.75-.5c0-.28-.28-.38-.28-.38l.03-.15s.17-.05.34-.16ZM5.7 21.94c1.24 0 1.9 2.35 1.9 2.87 0 1.02-1.13 1.63-1.9 1.63-1.15 0-2.94-1.39-2.94-1.9 0-1.25 1.63-2.6 2.94-2.6Zm20.62 0c1.32 0 2.94 1.35 2.94 2.6 0 .51-1.79 1.9-2.94 1.9-.77 0-1.9-.6-1.9-1.63 0-.52.66-2.87 1.9-2.87Zm-20.6.4c-.69 0-2.5 1.23-2.5 2.1 0 .75 1 .81 1.13.81.5 0 2.29-.83 2.29-1.81 0-.22-.21-1.1-.91-1.1Zm12.23 0c.37.14 2.09.77 2.9 1.13.91.4 2.7 1.47 2.7 1.47s-4.3.15-7.54.15-7.47-.18-7.47-.18c1.81-1.22 5.35-2.45 5.5-2.5.74.36 1.43.68 1.81.75.6-.18 1.33-.46 2.1-.82Zm8.34 0c-.7 0-.9.88-.9 1.1 0 .98 1.78 1.81 2.28 1.81.14 0 1.12-.06 1.12-.81 0-.87-1.8-2.1-2.5-2.1ZM6.81 24.38c-.36 0-1.5.77-1.5 1.21 0 .45.58.5.75.5.17 0 1.16-.38 1.16-1.06 0 0-.04-.66-.4-.66Zm18.38 0c-.37 0-.4.65-.4.65 0 .68.98 1.06 1.15 1.06.17 0 .75-.05.75-.5 0-.44-1.14-1.21-1.5-1.21Z',
        'orcid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5zm-5 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-1 3v11h2V11h-2zm4 0v11h4.5a5.51 5.51 0 0 0 0-11H14zm2 2h2.5c1.94 0 3.5 1.56 3.5 3.5S20.44 20 18.5 20H16v-7z',
        'osi' => 'M16 4a12.01 12.01 0 0 0-4.25 23.22l.94.37.37-.93 2.47-6.57.35-.93-.94-.35a3 3 0 1 1 2.12 0l-.93.35.34.93 2.47 6.57.37.93.94-.37A12 12 0 0 0 16 4Zm0 2c5.54 0 10 4.46 10 10a9.9 9.9 0 0 1-5.6 8.84l-1.8-4.78A4.85 4.85 0 0 0 21 16c0-2.75-2.25-5-5-5s-5 2.25-5 5a4.86 4.86 0 0 0 2.4 4.06l-1.8 4.78A9.9 9.9 0 0 1 6 16c0-5.54 4.46-10 10-10Z',
        'otter-solid' => 'M14.5 5c-3.71 0-7.06 1.58-8.6 4A3 3 0 0 0 3 12c0 .9.4 2.02 1 2.82V27h2V14.07l-.27-.29A3.15 3.15 0 0 1 5 12a1 1 0 0 1 1.23-.97l.78.19.35-.73C8.35 8.44 11.28 7 14.5 7h3c3.22 0 6.15 1.44 7.14 3.49l.35.73.78-.19L26 11a1 1 0 0 1 1 1c0 .47-.3 1.31-.73 1.78l-.27.29V27h2V14.82c.6-.8 1-1.92 1-2.82a3 3 0 0 0-2.9-3c-1.54-2.42-4.89-4-8.6-4h-3zM10 12a1 1.5 0 0 0 0 3 1 1.5 0 0 0 0-3zm12 0a1 1.5 0 0 0 0 3 1 1.5 0 0 0 0-3zm-6 1.02c-.91 0-1.83.32-2.63.97l-3.89 3.15-.1.1A3.6 3.6 0 0 0 8 20a4 4 0 0 0 4 4c1.5 0 2.91-.36 4-1 1.09.64 2.5 1 4 1a4 4 0 0 0 4-4 3.6 3.6 0 0 0-1.38-2.77l-.1-.09-3.9-3.16a4.17 4.17 0 0 0-2.62-.96zM16 15c.46 0 .93.18 1.37.54a353.6 353.6 0 0 1 3.86 3.13l.11.1c.3.25.66.67.66 1.23a2 2 0 0 1-2 2c-1.34 0-2.6-.37-3.37-1l-.6-.47c.08-.87.36-1.53.97-1.53 1.1 0 2-.2 2-.73 0-.7-1.34-1.27-3-1.27s-3 .57-3 1.27c0 .53.9.73 2 .73.61 0 .9.66.97 1.53l-.6.48c-.77.62-2.03.99-3.37.99a2 2 0 0 1-2-2c0-.56.36-.98.66-1.23l.12-.1 3.85-3.13c.44-.36.9-.54 1.37-.54z',
        'outdent-solid' => 'M3 7v2h13V7Zm0 4v2h20v-2Zm22 0v10l5-5ZM3 15v2h20v-2Zm0 4v2h20v-2Zm0 4v2h13v-2Z',
        'page4' => 'M16 3A13 13 0 0 0 5.6 23.78L19.9 3.6C18.67 3.2 17.36 3 16 3zm5 1v18h6.53A13 13 0 0 0 21 4zm1.05 4h.74v1.7h.66V8.15h.73v1.57h.73V8h.73v2.48h-3.59V8zm1.47 3.22h1.87c.8 1.54.24 3.43-1.55 3.43-2.05 0-2.26-2.45-1.42-3.36l.61.56c-.67.65-.35 1.97.81 1.97 1.06 0 1.43-1.02.98-1.84h-.58v.63h-.72v-1.39zm-7.52.32L8.6 22H16V11.54zm9.63 3.27v.9l-.75.3v1.39l.75.3v.88l-3.58-1.56v-.65l3.58-1.56zm-1.42 1.47-1.1.43 1.1.44v-.87zm-1.06 2.04c.8 0 1.09.51 1.09 1.33v.57h1.4V21h-3.58v-1.32c0-.8.29-1.36 1.09-1.36zm0 .82c-.35 0-.42.34-.42.67v.41h.86v-.53c0-.3-.13-.55-.44-.55zM5.77 24c2.38 3.04 6.07 5 10.23 5v-5H5.77zM21 24v4a13.03 13.03 0 0 0 5.23-4H21z',
        'pagelines' => 'M15.1 4s-1.21 1.66-.85 4.28c.28 1.98 1.93 3.22 2.84 3.75.04.95.01 1.93-.09 2.9-.46-1.12-1.5-3.09-3.4-3.77-1.87-.68-4.22.18-4.22.18a5.14 5.14 0 0 0 4.3 4.57c1.6.28 2.65.1 3.2-.04a18.7 18.7 0 0 1-1.38 4.82 5.44 5.44 0 0 0-4.84-3.75c-1.96-.23-3.82 1-3.82 1s1.2 4.28 5.04 4.28c1.55 0 2.58-.36 3.18-.63l-.1.2c-1.7 3.07-4.4 5.21-8.5 5.21v1c4.45 0 7.55-2.44 9.38-5.75.12-.2.21-.41.32-.63.27.21 1.75 1.25 4.68 1.25 3.24 0 4.7-3.65 4.7-3.65s-1.63-1.34-4.1-1.34c-2.35 0-4.1 1.86-4.9 2.93.64-1.5 1.09-3.13 1.34-4.78.17.04 3.51.64 5.4-1.28 1.94-1.97 1.63-3.78 1.63-3.78s-3.26-.47-5.04 1.15c-1.11 1.03-1.7 2.73-1.93 3.5.17-1.32.21-2.65.15-3.93.36-.66.85-1.78.85-3.25 0-3.2-3.85-4.44-3.85-4.44Z',
        'pager-solid' => 'M7 7c-1.64 0-3 1.36-3 3v12c0 1.64 1.36 3 3 3h18c1.64 0 3-1.36 3-3V10c0-1.64-1.36-3-3-3H7zm0 2h18c.57 0 1 .43 1 1v12c0 .57-.43 1-1 1H7c-.57 0-1-.43-1-1V10c0-.57.43-1 1-1zm1 2v6h12v-6H8zm14 0v2h2v-2h-2zm0 4v2h2v-2h-2zM8 19v2h12v-2H8zm14 0v2h2v-2h-2z',
        'paint-brush-solid' => 'M24.81 4.03A3.3 3.3 0 0 0 22.5 5L9.81 17.5l-.62.6c-.75.13-1.47.5-2.03 1.12-.84.9-1 2.02-1.32 3.22-.31 1.2-.71 2.52-1.68 4l-1 1.56H5c3.91 0 6.5-1.87 7.81-3.19l.03-.03a4 4 0 0 0 1.07-2.19l.5-.46 12.68-12.5v-.04a3.25 3.25 0 0 0-2.28-5.56Zm0 1.97c.32 0 .61.14.88.4.53.54.53 1.25 0 1.79l-9.03 8.94-1.82-1.82 9.07-8.9c.26-.27.59-.41.9-.41Zm-11.4 10.72 1.8 1.81-1.5 1.47-1.8-1.81Zm-3.44 3.31c.5.02 1.05.21 1.47.6.77.7.8 1.95-.03 2.78a8.9 8.9 0 0 1-4.66 2.4c.48-1.05.82-2.03 1.03-2.84.33-1.26.58-2.11.84-2.4.35-.39.84-.55 1.35-.54Z',
        'paint-roller-solid' => 'M5 4v8h18V4Zm2 2h14v4H7Zm17 1v2h1v4.25l-9.28 2.78-.72.22V19h-2v9h6v-9h-2v-1.25l9.28-2.78.72-.22V7Zm-9 14h2v5h-2Z',
        'palette-solid' => 'M15.6 2.97a13 13 0 0 0-1.63.15h-.03A13.23 13.23 0 0 0 3.22 13.5c-.33 1.51-.3 2.92-.1 4.31v.03c.33 2.35 3.38 3.38 5.1 1.66a2.94 2.94 0 0 1 4.28 0 2.94 2.94 0 0 1 0 4.28c-1.72 1.72-.7 4.77 1.66 5.1h.03c1.38.2 2.78.22 4.28-.1h.03c5.32-1 9.5-5.4 10.38-10.72v-.03A13.12 13.12 0 0 0 15.59 2.97Zm.03 2A11.1 11.1 0 0 1 26.9 17.75a11.14 11.14 0 0 1-8.78 9.06h-.04a9.88 9.88 0 0 1-3.65.1c-.82-.1-1.2-1.02-.53-1.7a5.04 5.04 0 1 0-7.13-7.12c-.67.67-1.58.3-1.69-.53a9.88 9.88 0 0 1 .1-3.65 11.26 11.26 0 0 1 9.06-8.82c.47-.07.92-.1 1.38-.12ZM14 7a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm7 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4ZM9 11a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm14 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-4 5a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'palfed' => 'M14 4a1 1 0 0 0-1 1v1c-4.42 0-8 1.8-8 4H4a2 2 0 0 0-2 2c0 1.1.9 2 2 2h1.38l1.4 11.25A2 2 0 0 0 8.77 27h14.46a2 2 0 0 0 2-1.75L26.62 14H28a2 2 0 0 0 2-2 2 2 0 0 0-2-2h-1c0-2.2-3.58-4-8-4V5a1 1 0 0 0-1-1h-4zm1.33 4.19c.38.03.72.32.81.78C19.8 7.84 23 9.02 23 12.62c0 3.95-3.91 7.75-7 7.01v5.08c.01.18.06.64-.24.98-.49.54-1.7.5-1.85-1.13-.2-2.26.01-10.46.07-12.3-1.09.75-2.96 2.54-2.96 3.84 0 .13.01.2.02.24.01 0 .34-.14.57-.14 1.35 0 1.05 2.24-.73 2.24-1.09 0-1.88-.92-1.88-2.18 0-2.14 2.18-4.86 5.1-6.42.06-.63.16-1.12.54-1.44a.95.95 0 0 1 .69-.21zm3.2 2.5c-.77 0-1.63.2-2.38.47-.06 2-.13 4.1-.15 6.08.04.14.13.31.75.31 1.84 0 4.17-2.17 4.16-4.88 0-1.5-1.07-2-2.37-1.99z',
        'pallet-solid' => 'M6.13 5 6 5.84l-2 14V27h6v-2h12v2h6v-7.16l-2-14-.13-.84Zm1.75 2h2.06l-.88 12h-2.9Zm4.06 0H15v12h-3.94ZM17 7h3.06l.88 12H17Zm5.06 0h2.07l1.71 12h-2.9ZM6 21h20v4h-2v-2H8v2H6Z',
        'paper-plane-solid' => 'm3.6 5.34.43 1.88L5.97 16l-1.94 8.78-.44 1.88 1.79-.72 22-9 2.28-.94-2.29-.94-22-9Zm2.77 3.32L21.91 15H7.78ZM7.79 17h14.13L6.37 23.34Z',
        'paper-plane' => 'm3.6 5.34.43 1.88L5.97 16l-1.94 8.78-.44 1.88 1.79-.72 22-9 2.28-.94-2.29-.94-22-9Zm2.77 3.32L21.91 15H7.78ZM7.79 17h14.13L6.37 23.34Z',
        'paperclip-solid' => 'M21 4c-1.4 0-2.76.54-3.81 1.6L7.8 14.96a7.63 7.63 0 0 0 10.8 10.79l6.25-6.25-1.4-1.4-6.25 6.24a5.62 5.62 0 1 1-7.97-7.96L18.59 7a3.41 3.41 0 0 1 4.85 0 3.41 3.41 0 0 1 0 4.84l-9.38 9.38a1.2 1.2 0 0 1-1.72 0 1.2 1.2 0 0 1 0-1.72l8.6-8.6-1.4-1.4-8.6 8.6a3.21 3.21 0 0 0 0 4.52 3.21 3.21 0 0 0 4.53 0l9.37-9.37A5.42 5.42 0 0 0 21 4Z',
        'parachute-box-solid' => 'M28 16a12.01 12.01 0 0 0-24 0v.45l8 7V28h8v-4.55l8-7ZM16 6.36c.87.94 2.42 3.18 2.87 7.3A6.14 6.14 0 0 0 16 13c-1.2 0-2.15.28-2.87.66.45-4.13 2-6.36 2.87-7.3ZM11.09 16.4l2.4 5.6h-.12l-7.03-6.16A2.9 2.9 0 0 1 8.5 15c1.9 0 2.56 1.35 2.59 1.4Zm4.57 5.6-2.52-5.88A3.68 3.68 0 0 1 16 15c1.63 0 2.48.7 2.86 1.12L16.34 22Zm2.86 0 2.4-5.6c0-.02.63-1.4 2.58-1.4 1.1 0 1.77.45 2.16.84L18.62 22Zm7.14-8.55A5.13 5.13 0 0 0 23.5 13c-1.1 0-1.96.3-2.62.68a16.1 16.1 0 0 0-2.4-7.36c3.5.9 6.26 3.64 7.18 7.13ZM13.52 6.32a16.11 16.11 0 0 0-2.4 7.36A5.02 5.02 0 0 0 8.5 13c-.87 0-1.58.18-2.16.45a10.01 10.01 0 0 1 7.18-7.13ZM18 26h-4v-2h4Z',
        'paragraph-solid' => 'M12 5c-3.3 0-6 2.7-6 6s2.7 6 6 6h4v10h2V7h2v20h2V7h2V5Zm0 2h4v8h-4c-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Z',
        'parking-solid' => 'M6 5v22h20V5Zm2 2h16v18H8Zm4 3v12h2v-3h3c1.64 0 3-1.36 3-3v-3c0-1.64-1.36-3-3-3Zm2 2h3c.57 0 1 .43 1 1v3c0 .57-.43 1-1 1h-3Z',
        'passport-solid' => 'M6 3v26h20V3Zm2 2h16v22H8Zm8 3c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6Zm.69 2.1c.48.08.93.22 1.34.46l.06.72-.46-.19-.38.32.06.9.97-.28 1.19.38-.31.53-.72-.44-.78.13-.75.56-.44 1.31.84.69.94-.16c.05 0 .38.81.38.81l-.5 1.54c-.62.38-1.34.62-2.13.62-.23 0-.46-.05-.69-.1l-.19-.3.47-1.76-1.78-1.34h-1.65l-.13-.25c0-.09-.03-.16-.03-.25 0-.21.03-.42.06-.63l.85-.65 1.78-.85-.28-1.15.78-.16.34.5 1.35-.25Zm-3.63 6.62h.31l.6.72c-.34-.2-.64-.44-.9-.72ZM10 22v2h12v-2Z',
        'pastafarianism-solid' => 'M11 4a3 3 0 0 0-.95 5.83c.05.69.19 1.67.53 2.59a9.22 9.22 0 0 0-2.32 1.68l-.28.3-.18.2v.01l-.21.33c-.5-.13-.77-.53-1.2-1.39C5.9 12.54 5.12 11 3 11v2c.81 0 1.07.38 1.6 1.45.42.84 1.03 2.01 2.42 2.4L7 17c0 .96.35 1.83.92 2.52A2 2 0 0 1 4 19H2a4 4 0 0 0 7.59 1.73c.44.17.91.27 1.41.27.17 0 .34-.03.5-.05l-.19.86C10.97 23.59 10.7 25 8 25v2c4.34 0 4.93-3.01 5.28-4.8.1-.53.18-.83.25-1.07a3.99 3.99 0 0 0 4.94 0c.07.24.15.54.25 1.06C19.07 24 19.66 27 24 27v-2c-2.69 0-2.96-1.4-3.31-3.2-.05-.26-.12-.55-.2-.85.17.02.34.05.51.05.5 0 .97-.1 1.41-.27A4 4 0 0 0 30 19h-2a2 2 0 0 1-3.92.52c.57-.69.92-1.56.92-2.52l-.02-.14c1.39-.4 2-1.57 2.41-2.41.54-1.07.8-1.45 1.61-1.45v-2c-2.12 0-2.89 1.54-3.4 2.55-.42.86-.69 1.26-1.19 1.39a3.99 3.99 0 0 0-.22-.33h.01l-.18-.2-.28-.31a9.22 9.22 0 0 0-2.32-1.68c.34-.92.48-1.9.53-2.59a3 3 0 1 0-2-.03 8.16 8.16 0 0 1-.37 1.83C18.4 11.23 17.16 11 16 11c-1.16 0-2.4.23-3.58.63a8.27 8.27 0 0 1-.37-1.83A3 3 0 0 0 11 4zm0 2a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm10 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm-5 7c.98 0 2.03.2 3.02.54a3.99 3.99 0 0 0-1.39 5.6A2 2 0 0 1 16 20a2 2 0 0 1-1.63-.86 3.96 3.96 0 0 0-1.4-5.6c1-.33 2.05-.54 3.03-.54zm-5 2a2 2 0 1 1-2 2c0-.47.17-.9.45-1.24l.21-.24A2 2 0 0 1 11 15zm10 0a2 2 0 0 1 1.34.52l.21.24c.28.34.45.77.45 1.24a2 2 0 1 1-2-2z',
        'paste-solid' => 'M15 3c-1.26 0-2.15.9-2.6 2H5v23h8v2h14V14h-2V5h-7.4c-.45-1.1-1.34-2-2.6-2Zm0 2a1 1 0 0 1 1 1v1h3v2h-8V7h3V6a1 1 0 0 1 1-1ZM7 7h2v4h12V7h2v7H13v12H7Zm8 9h10v12H15Z',
        'patreon' => 'M4 4v24h7V4H4zm17.5 0a8.51 8.51 0 0 0 0 17 8.51 8.51 0 0 0 0-17zM6 6h3v20H6V6zm15.5 0a6.5 6.5 0 1 1-.02 13.02A6.5 6.5 0 0 1 21.5 6z',
        'pause-circle-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 5v10h2V11Zm6 0v10h2V11Z',
        'pause-circle' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 5v10h2V11Zm6 0v10h2V11Z',
        'pause-solid' => 'M10 6v20h2V6Zm10 0v20h2V6Z',
        'paw-solid' => 'M12.5 5c-1.07 0-2 .6-2.6 1.44-.59.83-.9 1.9-.9 3.06 0 1.16.31 2.23.9 3.06.6.83 1.53 1.44 2.6 1.44s2-.6 2.6-1.44c.59-.83.9-1.9.9-3.06 0-1.16-.31-2.23-.9-3.06A3.25 3.25 0 0 0 12.5 5ZM16 9.5c0 1.16.31 2.23.9 3.06.6.83 1.53 1.44 2.6 1.44s2-.6 2.6-1.44c.59-.83.9-1.9.9-3.06 0-1.16-.31-2.23-.9-3.06A3.25 3.25 0 0 0 19.5 5c-1.07 0-2 .6-2.6 1.44-.59.83-.9 1.9-.9 3.06ZM12.5 7c.31 0 .66.16.97.6.31.43.53 1.13.53 1.9s-.22 1.47-.53 1.9c-.31.44-.66.6-.97.6-.31 0-.66-.16-.97-.6A3.38 3.38 0 0 1 11 9.5c0-.77.22-1.47.53-1.9.31-.44.66-.6.97-.6Zm7 0c.31 0 .66.16.97.6.31.43.53 1.13.53 1.9s-.22 1.47-.53 1.9c-.31.44-.66.6-.97.6-.31 0-.66-.16-.97-.6A3.38 3.38 0 0 1 18 9.5c0-.77.22-1.47.53-1.9.31-.44.66-.6.97-.6Zm-12 5c-1.07 0-2 .6-2.6 1.44-.59.83-.9 1.9-.9 3.06 0 1.16.31 2.23.9 3.06.6.83 1.53 1.44 2.6 1.44s2-.6 2.6-1.44c.59-.83.9-1.9.9-3.06 0-1.16-.31-2.23-.9-3.06A3.25 3.25 0 0 0 7.5 12Zm17 0c-1.07 0-2 .6-2.6 1.44-.59.83-.9 1.9-.9 3.06 0 1.16.31 2.23.9 3.06.6.83 1.53 1.44 2.6 1.44s2-.6 2.6-1.44c.59-.83.9-1.9.9-3.06 0-1.16-.31-2.23-.9-3.06A3.25 3.25 0 0 0 24.5 12Zm-17 2c.31 0 .66.16.97.6.31.43.53 1.13.53 1.9s-.22 1.47-.53 1.9c-.31.44-.66.6-.97.6-.31 0-.66-.16-.97-.6A3.38 3.38 0 0 1 6 16.5c0-.77.22-1.47.53-1.9.31-.44.66-.6.97-.6Zm17 0c.31 0 .66.16.97.6.31.43.53 1.13.53 1.9s-.22 1.47-.53 1.9c-.31.44-.66.6-.97.6-.31 0-.66-.16-.97-.6a3.38 3.38 0 0 1-.53-1.9c0-.77.22-1.47.53-1.9.31-.44.66-.6.97-.6ZM16 16c-1.33 0-2.26.87-2.72 1.63-.46.75-.73 1.39-1 1.65-.15.16-1.12.52-2.12 1.03-.5.26-1.02.6-1.44 1.13A3.29 3.29 0 0 0 8 23.5c0 1.92 1.58 3.5 3.5 3.5.87 0 1.77-.28 2.66-.53C15.04 26.2 16 26 16 26s.96.21 1.84.47c.89.25 1.8.53 2.66.53 1.92 0 3.5-1.58 3.5-3.5 0-.8-.3-1.52-.72-2.03a4.56 4.56 0 0 0-1.44-1.1c-1-.53-1.98-.95-2.12-1.09-.24-.24-.5-.89-.97-1.66A3.26 3.26 0 0 0 16 16Zm0 2c.66 0 .73.16 1.03.66.3.5.52 1.33 1.25 2.06.83.82 1.87 1 2.63 1.4.38.2.67.42.84.63.17.2.25.4.25.75 0 .84-.66 1.5-1.5 1.5-.29 0-1.22-.22-2.1-.47-.86-.24-1.58-.53-2.4-.53-.82 0-1.54.29-2.4.53-.88.25-1.81.47-2.1.47-.84 0-1.5-.66-1.5-1.5 0-.4.08-.6.25-.81.17-.2.47-.4.84-.6.75-.38 1.79-.53 2.63-1.37.73-.74.96-1.6 1.25-2.1.3-.49.36-.62 1.03-.62Z',
        'paypal' => 'm8.9 5-.18.78-3.69 17L4.75 24h4.88l-.6 2.78L8.75 28h6.97l.15-.81 1.04-4.82h2.68A7.94 7.94 0 0 0 27.5 16a5.81 5.81 0 0 0-1-5 5.49 5.49 0 0 0-2.97-1.81 5.11 5.11 0 0 0-1.28-2.47A5.81 5.81 0 0 0 18.06 5Zm1.63 2h7.53c.98 0 2.07.38 2.75 1.1.69.7 1.1 1.73.72 3.46-.66 3.1-3 4.81-5.94 4.81h-4.3l-.16.79L10.09 22H7.25Zm2.53 1.47-.19.78-1.03 4.63-.28 1.21h3.53a3.93 3.93 0 0 0 3.75-3.03h.04V12c.21-.88.07-1.77-.41-2.44a2.75 2.75 0 0 0-2.22-1.1Zm1.6 2h1.59c.31 0 .48.09.6.25.11.16.2.42.09.81v.03c-.19.81-1.15 1.53-1.85 1.53h-1.03Zm8.93.87c.53.22 1.03.51 1.38.94.58.7.9 1.68.56 3.28-.66 3.1-3 4.81-5.94 4.81h-4.3l-.16.79L14.09 26h-2.84l.44-2h.03l.15-.81 1.04-4.82h2.68A7.94 7.94 0 0 0 23.5 12c.05-.23.07-.44.1-.66Z',
        'peace-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm-1 2.05v10.47l-8.2 6.5A11.01 11.01 0 0 1 15 5.06zm2 0a11.01 11.01 0 0 1 8.2 16.97l-8.2-6.5V5.05zm-2 13.02v8.88a10.96 10.96 0 0 1-6.95-3.37L15 18.07zm2 0 6.95 5.51A10.96 10.96 0 0 1 17 26.95v-8.88z',
        'pen-alt-solid' => 'M19.16 3c-.77 0-1.52.3-2.07.9v.04a9.23 9.23 0 0 0-2.12 3.56c-.18.47-.36.92-.6 1.38A2.48 2.48 0 0 0 10 10.5c0 1.37 1.13 2.5 2.5 2.5.74 0 1.38-.35 1.84-.88l.07.07-9.13 9.1-.28.3v3.97L4 26.6 5.4 28l1.04-1h3.97l.3-.28 16.57-16.6.03-.03a2.97 2.97 0 0 0 0-4.18L26.1 4.69A2.95 2.95 0 0 0 24 3.8c-.71 0-1.41.28-1.97.78l-.72-.68a3.06 3.06 0 0 0-2.15-.9Zm.03 2c.24 0 .5.1.72.31l.68.69-6.12 6.1a11.04 11.04 0 0 0 2.37-3.88c.43-1.13.7-1.95 1.66-2.9l.06-.07A.8.8 0 0 1 19.2 5Zm4.81.78c.23 0 .46.1.69.31l1.22 1.22c.44.45.44.93 0 1.38l-.91.87L22.44 7l.78-.78.1-.13a.95.95 0 0 1 .68-.3Zm-3 2.66L23.56 11 16 18.56 13.44 16ZM12.5 10c.29 0 .5.21.5.5 0 .29-.21.5-.5.5a.48.48 0 0 1-.5-.5c0-.29.21-.5.5-.5Zm-.5 7.44L14.56 20l-5 5H7v-2.56Z',
        'pen-fancy-solid' => 'M23.81 4.03a4.3 4.3 0 0 0-3.03 1.25l-9.28 9.28-5.47 2.1-.53.21-.1.57-1.4 9.4-.19 1.35L5.16 28l9.4-1.4.56-.1.22-.53 1.97-5.19.5-.47 9-9a4.26 4.26 0 0 0 .13-5.87l-.13-.16a4.22 4.22 0 0 0-3-1.25Zm0 1.97c.57 0 1.13.25 1.6.72.93.94.93 2.25 0 3.19l-5.04 5.03-3.18-3.19 5.03-5.03a2.27 2.27 0 0 1 1.6-.72Zm-8.06 7.19 3.19 3.19-1.82 1.8L13.95 15Zm-3.34 3.15h.03l3.22 3.22-1.97 5.16-5.85.84 2.7-2.68.15.03c.88 0 1.62-.71 1.62-1.6 0-.88-.74-1.62-1.62-1.62-.89 0-1.6.74-1.6 1.62 0 .06.03.1.04.16l-2.7 2.69.85-5.85Z',
        'pen-nib-solid' => 'M22 3.59 17.48 8.1l-6.74 1.93a4.06 4.06 0 0 0-2.8 2.65L3.86 25.27l1.43 1.44 1.44 1.43 12.59-4.08a4.06 4.06 0 0 0 2.64-2.79l1.93-6.74L28.4 10 22 3.59zm0 2.82L25.59 10 23 12.59 19.41 9 22 6.41zm-4.29 3.71 4.16 4.17-1.84 6.45c-.18.67-.68 1.2-1.33 1.42L7.69 25.72l5.8-5.79A2 2 0 0 0 14 20a2 2 0 0 0 0-4 2 2 0 0 0-1.93 2.52l-5.8 5.8 3.57-11c.22-.67.75-1.17 1.44-1.36l6.43-1.84z',
        'pen-solid' => 'M23.9 3.97c-1.04 0-2.09.4-2.9 1.22L5.19 21l-.07.31-1.09 5.5-.31 1.47 1.47-.31 5.5-1.1.31-.06L26.81 11a4.07 4.07 0 0 0 0-5.81 4.1 4.1 0 0 0-2.9-1.22Zm0 1.9c.51 0 1.02.24 1.5.72.98.98.98 2.03 0 3l-.71.7-2.97-2.98.69-.72c.48-.48 1-.71 1.5-.71Zm-3.59 2.85 2.97 2.97-12.1 12.1a6.81 6.81 0 0 0-2.96-2.98ZM6.94 22.44a4.73 4.73 0 0 1 2.62 2.62l-3.28.66Z',
        'pen-square-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13.13 1.88a3 3 0 0 0-2.13.87l-8.26 8.27-.03.31-.47 3.31L9.02 23l1.34-.22 3.31-.47.32-.03L22.25 14a3 3 0 0 0-2.13-5.13zm0 2a1 1 0 0 1 .72.28c.38.39.4.98.03 1.37l-.03.03-7.8 7.83-1.66.22.22-1.65 7.83-7.8c.2-.2.43-.28.69-.28z',
        'pencil-alt-solid' => 'M24.69 4.03c-.84 0-1.65.34-2.28.97l-.1.1-.62-.6L5.19 21l-.07.31-1.09 5.5-.31 1.47 1.47-.31 5.5-1.1.31-.06 16.5-16.5-.6-.6.07-.05.03-.07a3.25 3.25 0 0 0-2.31-5.56Zm0 1.97c.31 0 .64.14.9.4.54.54.54 1.25 0 1.79l-.09.1-1.78-1.79.1-.1c.26-.26.55-.4.87-.4Zm-2.97 1.31 2.97 2.97-1.44 1.47-3-3Zm-2.84 2.88 2.93 2.94-10.43 10.46-.41-1.8-.13-.63-.62-.13-1.81-.4ZM6.96 22.34l2.19.5.5 2.2-2.04.4-1.06-1.07Z',
        'pencil-ruler-solid' => 'm8.81 3-.69.72-4.4 4.4-.72.7L10.19 16l-5 5-.07.31-1.09 5.5-.31 1.47 1.47-.31 5.5-1.1.31-.06 5-5 7.16 7.16.68-.72 4.41-4.4.72-.7L21.8 16l4.94-4.94a4.1 4.1 0 0 0 0-5.81 4.11 4.11 0 0 0-2.9-1.22c-1.06 0-2.1.42-2.91 1.22L16 10.19Zm0 2.84 1.94 1.97-1.47 1.47 1.44 1.44 1.47-1.47 2.37 2.38-2.97 2.96-5.78-5.78Zm15.03.13c.52 0 1.05.23 1.5.69.9.9.9 2.06 0 2.96l-.65.66-2.97-2.97.66-.65c.45-.46.94-.7 1.46-.7Zm-3.53 2.75 2.97 2.97-12.1 12.1a6.98 6.98 0 0 0-2.96-2.98Zm.1 8.69 2.37 2.37-1.5 1.5 1.44 1.44 1.5-1.5 1.9 1.9-3 3-5.71-5.71Zm-13.47 5c1.2.5 2.15 1.45 2.65 2.65l-3.3.66Z',
        'penny-arcade' => 'M23.69 7c-.16 0-.33 0-.5.05l-6.78 1.79c-.43.11-.79.43-.94.86C7.21 8.95 0 10.95 0 14.55c0 1.66 1.53 3.32 4.04 4.71l.1.88c-.6.23-.96.8-.9 1.42l.22 2.2c.07.7.67 1.24 1.39 1.24.26 0-.15.09 6.12-1.57A1.37 1.37 0 0 0 12 22.05c10.83 2.24 20.1-.3 20-4.19 0-1.39-1.11-3.29-4.9-5.16l-2.27-4.9a1.4 1.4 0 0 0-1.14-.8zm-.14 1.37 3.34 7.19 1.04-.28.21 2.2-5.42 1.43-.2-1.95.75-.2-.33-.72-2.9.76-.2.86.96-.25.2 1.95-5.64 1.49-.22-2.2 1.05-.27 1.65-6.25-.86.23-.2-2.2 6.77-1.79zm-10.38 2.9c2.83-.06 3.2 3.55 2.12 5.16a4.34 4.34 0 0 1-2.53 1.66l-1.1.29-2.42.64.12 1.16 1.03-.27.23 2.2-5.77 1.52-.22-2.2 1-.27-.55-5.66-1 .27-.22-2.2c8.9-2.34 8.5-2.29 9.3-2.3zm7.93.2-.76 3.23 1.99-.53-1.23-2.7zm-10.02 2.47-.29.05-1.98.53.22 2.28 1.74-.46c1.99-.46 1.7-2.5.31-2.4z',
        'people-carry-solid' => 'M8 5a3 3 0 1 0 0 6 3 3 0 0 0 0-6zm16 0a3 3 0 1 0 0 6 3 3 0 0 0 0-6zM8 7a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm16 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2zM6.85 12a1 1 0 0 0-.95.68L4.13 18a2 2 0 0 0 .71 2.25L8 22.5V28h2v-5.5a2 2 0 0 0-.82-1.61l-3.16-2.26 1.43-4.27.9 2.34c.24.62.68 1.14 1.25 1.49L12 20h8l2.4-1.81c.57-.35 1-.87 1.24-1.48l.91-2.36L26 18.62l-3.2 2.28a2 2 0 0 0-.8 1.6V28h2l-.02-5.49 3.2-2.28a2 2 0 0 0 .7-2.23l-1.78-5.32a1 1 0 0 0-.95-.68h-.65a1.7 1.7 0 0 0-1.65 1.21l-1.07 2.77a1 1 0 0 1-.43.5.89.89 0 0 0-.1.07L20 17.5V12h-8v5.5l-1.25-.95a1.36 1.36 0 0 0-.1-.06 1 1 0 0 1-.43-.51L9.15 13.2A1.69 1.69 0 0 0 7.5 12h-.65zM14 14h4v4h-4v-4zm-9.74 7.06-.2 2.05a2 2 0 0 1-.18.63L1.93 28h2.2l1.57-3.43a4 4 0 0 0 .34-1.27l.1-.9-1.88-1.34zm23.48 0-1.87 1.34.09.9c.04.44.15.87.34 1.27L27.87 28h2.2l-1.95-4.26c-.1-.2-.15-.41-.17-.63l-.2-2.05z',
        'pepper-hot-solid' => 'M28 5V3c-1.99 0-3.54.55-4.6 1.64a4.79 4.79 0 0 0-1.15 1.93A3.37 3.37 0 0 0 17 9.37c0 .22 0 .45-.02.7C16.3 12.04 15 10.72 15 8c-3.22 3.42.25 4.68-1.73 6.66-.42.43-1.43.59-2.06-.18-.83-1 .86-2.62-.74-3.83.3 1.83-1.12 1.45-1.6 1.06C8.26 11.2 7.13 10.08 9 7c-1.92.88-3.07 2.65-3 4 .2 3.54 5.66 6.6 3.46 8.67C8.34 20.7 6.16 19.3 7 17a3.41 3.41 0 0 0-1.9 3.79C5.39 22.16 7.39 25.25 4 27l.04.01L3.96 29l.77.01c2.8 0 12.54-.43 18.54-6.17 3.14-3 4.73-7 4.73-11.84 0-1.38-.63-4-3-4-.3 0-.57.04-.82.1.1-.33.3-.72.64-1.06C25.5 5.35 26.57 5 28 5Zm-3 4c.95 0 1 1.98 1 2 0 4.28-1.39 7.77-4.11 10.4-4.43 4.23-11.4 5.28-15.19 5.53a9.67 9.67 0 0 0 3.25-1.46c5.85-3.2 8.93-10.77 9.04-15.8H19v-.28c0-.23.1-1.39 1.5-1.39.86 0 1.5 1.21 1.5 2h2c0-.43.1-1 1-1Z',
        'percent-solid' => 'M9.5 6A3.51 3.51 0 0 0 6 9.5v3C6 14.42 7.58 16 9.5 16s3.5-1.58 3.5-3.5v-3C13 7.58 11.42 6 9.5 6Zm11.25 0-12 20h2.5l12-20ZM9.5 8c.84 0 1.5.66 1.5 1.5v3c0 .84-.66 1.5-1.5 1.5S8 13.34 8 12.5v-3C8 8.66 8.66 8 9.5 8Zm13 8a3.51 3.51 0 0 0-3.5 3.5v3c0 1.92 1.58 3.5 3.5 3.5s3.5-1.58 3.5-3.5v-3c0-1.92-1.58-3.5-3.5-3.5Zm0 2c.84 0 1.5.66 1.5 1.5v3c0 .84-.66 1.5-1.5 1.5s-1.5-.66-1.5-1.5v-3c0-.84.66-1.5 1.5-1.5Z',
        'percentage-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm5 2c-1.64 0-3 1.36-3 3v1c0 1.64 1.36 3 3 3s3-1.36 3-3v-1c0-1.64-1.36-3-3-3Zm7.6 0L10 23h2.4L22 9ZM12 11c.57 0 1 .43 1 1v1c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-1c0-.57.43-1 1-1Zm8 5c-1.64 0-3 1.36-3 3v1c0 1.64 1.36 3 3 3s3-1.36 3-3v-1c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v1c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-1c0-.57.43-1 1-1Z',
        'periscope' => 'M16.14 3C9.94 3 5 7.94 5 13.9c0 3.3 2.11 6.88 4.44 9.8a25.89 25.89 0 0 0 3.52 3.66c.56.47 1.1.85 1.6 1.14.52.29.99.5 1.58.5.6 0 1.03-.23 1.5-.52.49-.28 1-.66 1.53-1.13 1.08-.93 2.29-2.2 3.43-3.66 2.3-2.9 4.4-6.5 4.4-9.79C27 7.94 22.08 3 16.14 3zm0 2A8.96 8.96 0 0 1 25 13.9c0 2.37-1.83 5.83-3.97 8.56a25.31 25.31 0 0 1-3.16 3.38 9.4 9.4 0 0 1-1.25.93c-.33.2-.59.23-.48.23.03 0-.24-.05-.6-.25-.35-.2-.8-.51-1.3-.93A24.14 24.14 0 0 1 11 22.45c-2.17-2.72-4-6.18-4-8.55A9 9 0 0 1 16.14 5zM16 10l-.18.02a2.96 2.96 0 0 1-3.8 3.8L12 14a4 4 0 1 0 4-4z',
        'person-booth-solid' => 'M7.5 4A3.51 3.51 0 0 0 4 7.5C4 9.42 5.58 11 7.5 11S11 9.42 11 7.5 9.42 4 7.5 4zM12 4v7.84c.23.29.44.6.61.93l.96 1.91.43.33V6h1.13l1.85 12.95-.95 3.8-.03.75a2.5 2.5 0 0 0 4.16 1.85 2.98 2.98 0 0 0 3.84-.13 2.98 2.98 0 0 0 3 .6V28h2V4H12zM7.5 6C8.34 6 9 6.66 9 7.5S8.34 9 7.5 9 6 8.34 6 7.5 6.66 6 7.5 6zm9.65 0H27v17a1 1 0 0 1-2 0h-2a1 1 0 0 1-2 0h-2v.5a.5.5 0 0 1-.5.5.5.5 0 0 1-.5-.5v-.38l1.02-4.07L17.15 6zM7 12a4 4 0 0 0-4 4v5.25l2 1V28h2v-7l-2-1v-4c0-1.1.9-2 2-2h1.16c.76 0 1.44.41 1.78 1.1l1.28 2.56 2.65 1.97L15 18l-2.22-1.66-1.06-2.12A3.97 3.97 0 0 0 8.16 12H7zm5 8.48V28h2v-6.03l-.73-.54-1.27-.95zM8 21v7h2v-7H8z',
        'phabricator' => 'M15.95 5c-2.76.01-5.5 1.09-7.6 3.22l-5.4 5.46a3.32 3.32 0 0 0 0 4.64l5.5 5.56a10.72 10.72 0 0 0 15.23-.1l5.38-5.46a3.32 3.32 0 0 0 0-4.64l-5.48-5.56A10.73 10.73 0 0 0 15.94 5zM16 7.02a8.98 8.98 0 1 1 .01 17.95A8.98 8.98 0 0 1 16 7.02zM17.64 10a12.24 12.24 0 0 0-1.29 1.31l-.82-.01s-1.28-1.34-1.36-1.3l-1.25.52a12 12 0 0 0 .01 1.8l-.57.57s-1.82-.06-1.85.02l-.5 1.24c-.04.09 1.3 1.3 1.3 1.3l.01.81s-1.35 1.24-1.31 1.33l.59 1.24c.03.09 1.84.03 1.84.03l.58.58s0 1.99.08 2.02l1.25.51c.1.04 1.3-1.46 1.3-1.46l.81.01s1.28 1.49 1.36 1.45l1.25-.46c.09-.04-.01-2-.01-2l.56-.57s1.83.05 1.86-.04l.5-1.23c.04-.07-1.3-1.29-1.3-1.29v-.81s1.35-1.23 1.3-1.32L21.4 13c-.03-.09-1.84-.03-1.84-.03l-.58-.58s.01-1.78-.08-1.82L17.64 10zm-1.81 3.88A2.07 2.07 0 0 1 18 15.83a2.08 2.08 0 0 1-2 2.15 2.07 2.07 0 0 1-2.17-1.96 2.07 2.07 0 0 1 2-2.14z',
        'phoenix-framework' => 'M6.7 6A10.01 10.01 0 0 0 1 7.75l.01.03.11-.01c.3-.05.59-.04.88 0 1.11.21 2.23 1.1 2.62 3.6.25 1.6-.04 2.38.37 4.03a6.54 6.54 0 0 0 5.99 5c.18-.01 1.07-.08 1.2-.11-.11-.12-2.04-.05-3.19-2.33a2.3 2.3 0 0 1-.3-1.3c.14-1.19 1.54-1.4 2.44-.86 1.69 1.01 2.97 4.28 5.33 4.57 1.73.21 3.97-.8 5.07-2.13h-.05l-.05.01a8.34 8.34 0 0 1-6.31-.7c-1.77-1.06-2.5-2.74-2.43-3.49.08-1 1.07-1.09 1.68-.92.68.19 1.15.83 1.83 1.29.73.48 1.54.64 2.4.48.7-.13 1.61-.58 1.71-.68h-.11c-.3-.04-.59-.05-.87-.09-5.21-.77-6.04-7.67-11.84-8.11A9.61 9.61 0 0 0 6.7 6zm-.51.97c-.06.7-1.05 1-1.66.32-.04-.04-.04-.05-.06-.1.57-.11 1.13-.18 1.72-.22zm7.3 1.73.1.11c.7.74 1.5 1.35 2.41 1.81 1.08.55 2.22.85 3.44.72.42-.03.82-.14 1.2-.33l.08-.06c-.02-.01-.05-.02-.07-.01l-.6.08c-.6.06-1.18-.04-1.7-.38-.84-.56-1.43-1.17-2.35-1.54-1.11-.45-2.15-.4-2.5-.4zm1.75 2.3c-.05.07.03.1.06.15 2.18 2.6 5.94 3 8.3 2.17 1.76-.63 2.93.35 3.16 1.35l.03.06h.02c0-.41-.07-.88-.24-1.3a2.58 2.58 0 0 0-1.5-1.57c-1.18-.46-2.35-.09-3.12.15a7.27 7.27 0 0 1-3.74.24 7.04 7.04 0 0 1-2.83-1.19c-.04-.03-.13-.07-.14-.06zm8.48 4.44c-.3 0-.61 0-.95.06-1.42.2-2.23.84-3.24 1.45-.87.51-1.4.45-2.52.27l-.01.02.04.03c.96.49 1.78.54 3.01.38 1.4-.18 2.05-.68 2.82-1.15.94-.55 1.8-.39 3.12-.18l.01-.03a4 4 0 0 0-2.28-.85zm1.89 1.5c-1.48.1-2.36 1-3.16 1.82-.35.37-.7.74-1.06 1.08-.7.65-1.26.7-1.39.78v.01c.29.02 1.25-.02 2.1-.2 3.26-.66 3.33-3 4.84-3.01.35 0 .69.03 1.02.15H28l-.03-.04c-.32-.21-.61-.51-1.7-.6a4.36 4.36 0 0 0-.66 0zm2.28 1.27a2.6 2.6 0 0 0-1.63.43l-.06.07c.34.02.85.04 1.32.4.56.43.9.94 1.48 1.12.94.3 1.84-.1 2-.24 0-.02-.01-.03-.02-.02-.1-.03-.58 0-1.08-.5-.53-.5-.84-.93-1.43-1.13-.2-.07-.39-.1-.58-.13zM7.02 20l-.02.02c.08.14.66.83.88 1.06 1.49 1.57 3.81 2.83 5.83 2.78 1.48-.04 2.5-.37 3.67-.28 1.12.08 1.67.35 1.9.42l.01-.02c-.09-.13-.36-.4-.47-.49-1.62-1.28-3.36-.59-4.6-1.15-.54-.25-.57-.58-.33-.78.19-.16.26-.18 1.14-.35-.1-.16-.97-.56-2.04-.14a5.22 5.22 0 0 1-3.38.15C8.23 20.84 7.33 20.2 7.02 20zm9.67 4.05c-.02 0-.03 0-.05.02.31.08 1.22.23 2.22 1.4a2.9 2.9 0 0 0 2.13 1.03c0-.02.04-.04-.06-.1a1.6 1.6 0 0 1-.57-.51c-.3-.47-.74-1.36-1.9-1.66a7.32 7.32 0 0 0-1.77-.18z',
        'phoenix-squadron' => 'M16.12 4.1a13.1 13.1 0 0 0-8.29 2.75A12.41 12.41 0 0 0 3 15.83v1.58c.1 1.63.54 3.22 1.28 4.68a12.5 12.5 0 0 0 4.6 4.97 13.35 13.35 0 0 0 12.49.74 12.87 12.87 0 0 0 5.9-5.44 12.24 12.24 0 0 0 1.49-6.85 11.8 11.8 0 0 0-1.76-5.4c.75 1.64.96 3.47.67 5.26a8.31 8.31 0 0 1-1.98 4.08c.11-.55.3-1.08.4-1.63.12-.72.18-1.44.08-2.16-.1-1.07-.21-2.43-.62-3.4 0 .37-.02.75 0 1.13a8.8 8.8 0 0 1-1.6 5.19 7.12 7.12 0 0 1-4.08 2.8 3 3 0 0 1-2.2-.25 2.43 2.43 0 0 1-1.05-1.76c-.13-1.1.13-2.2.6-3.2a7.59 7.59 0 0 1 2.61-3.03c.23-.16.5-.28.69-.5.63-.8 1.28-1.58 2.02-2.28.73-.75 1.44-1.42 2.21-2.03-1.47-.04-2.67.55-3.97 1.16a26.48 26.48 0 0 0-4.47 2.78c-.9.69-1.37 1.36-2.4 1.85a3.3 3.3 0 0 1-1.9.27 4.8 4.8 0 0 0 3.13-.04c.63-.2.88-.35 1.46-.66.1-.08.2-.04.31-.02 0 .22.06.48-.13.64a7.52 7.52 0 0 1-3.8 2.05c-.66.12-1.33 0-1.9-.34-.73-.46-1.01-1.39-1-2.22a6.46 6.46 0 0 1 1.25-3.38 8.6 8.6 0 0 1 4.35-3.15c.7-.25 1.43-.34 2.16-.48-.99-.12-2-.2-2.98-.1a9.1 9.1 0 0 0-2.89.75c-.26.1-.52.24-.8.3a9.18 9.18 0 0 1 5.63-2.99 8.04 8.04 0 0 1 3.2-.01 9.9 9.9 0 0 0-3.88-.64zm4.22 6a.8.8 0 0 1-.52.57c-.26.1-.53.18-.8.23.41-.3.87-.54 1.32-.8z',
        'phone-alt-solid' => 'M22.63 3.03c-.33.03-.65.12-.97.25v-.03l-.07.03c-2.43.86-7.09 3-11.3 7.22-4.26 4.25-6.31 9-7.23 11.34v.04a3.59 3.59 0 0 0 .69 3.46l.03.04v.03l3 2.96.13.13c.82.83 2.26.83 3.09 0l4.1-4.1c.82-.82.82-2.3 0-3.12l-1.97-1.97a16.2 16.2 0 0 1 2.8-4.12A12.66 12.66 0 0 1 19 12.4l2.06 2.06.1.06c.46.31 1 .49 1.56.47a2.14 2.14 0 0 0 1.47-.72l.03.03.06-.1 4.03-4c.83-.82.83-2.29 0-3.12L25.21 4a3.44 3.44 0 0 0-1.65-.9 3 3 0 0 0-.93-.07Zm.15 2c.38-.03.76.13 1 .38l3.13 3.09c.17.17.17.1 0 .28l-4.2 4.19c.01 0 0 .03-.09.03a.73.73 0 0 1-.3-.13h-.07l-2.34-2.37-.47-.47-.6.22s-3.07 1.15-5.37 3.56a19.94 19.94 0 0 0-3.5 5.28l-.25.63.47.5 2.5 2.5c.17.17.17.1 0 .28l-4.1 4.1c-.17.17-.1.17-.28 0l-3.06-3.04v-.03L5.22 24c-.35-.43-.45-.9-.28-1.44v-.03a31 31 0 0 1 6.78-10.62c3.96-3.96 8.44-6 10.62-6.75l.04-.04h.03c.12-.05.25-.08.37-.09Z',
        'phone-slash-solid' => 'M3.7 2.3 2.3 3.7l7.42 7.44 1.42 1.41L13 14.4l15.3 15.3 1.42-1.4-13.9-13.91a13.04 13.04 0 0 1 3.32-2.08l2 2c.05.04.13.03.18.07l-.23.22h.77a1.9 1.9 0 0 0 1.68 0h.02-.01.4l4.54-4.43.04-.04a2.4 2.4 0 0 0 0-2.96l-.04-.05-3.25-3.14.06.06a3.1 3.1 0 0 0-1.64-1 3.2 3.2 0 0 0-1.86.12c-2.3.8-6.6 2.78-10.65 6.57L3.71 2.29zm19.12 2.67c.35-.02.73.11.96.38l.03.03 3.15 3.06c.1.14.1.28 0 .42l-4.21 4.11s-.09.04-.2-.08l-2.96-2.95-.6.22s-2.44.9-4.6 2.81l-1.83-1.83a29.58 29.58 0 0 1 9.9-6.1h.03c.1-.04.21-.06.33-.07zM8.41 12.65a34.06 34.06 0 0 0-5.22 9.13 3.54 3.54 0 0 0 .74 3.53l3.1 3.1c.44.44 1 .66 1.56.66a2.2 2.2 0 0 0 1.55-.67l4.1-4.1c.9-.88.9-2.22 0-3.11l-2-2c.22-.43.55-1.04.99-1.72l-1.45-1.45A20.35 20.35 0 0 0 10.12 19l-.27.62 2.98 2.98c.07.07.07.23 0 .3l-4.1 4.09c-.07.07-.22.07-.29 0L5.4 23.95a1.5 1.5 0 0 1-.33-1.49 32.05 32.05 0 0 1 4.76-8.4l-1.43-1.4z',
        'phone-solid' => 'M8.66 3c-.53 0-1.04.19-1.47.53l-.07.03-.03.03-3.12 3.22.03.03a3.13 3.13 0 0 0-.84 3.38v.03a31.4 31.4 0 0 0 7.25 11.34c4.25 4.25 9 6.34 11.34 7.25h.03c1.22.41 2.53.12 3.47-.68L28.41 25c.82-.83.82-2.27 0-3.1l-4.07-4.06-.03-.06a2.28 2.28 0 0 0-3.12 0l-2 2a16.18 16.18 0 0 1-4.1-2.81 12.7 12.7 0 0 1-2.78-4.06l2-2c.84-.84.86-2.24-.03-3.07l.03-.03-.1-.1-4-4.12-.02-.03-.06-.03A2.36 2.36 0 0 0 8.65 3Zm0 2c.07 0 .14.04.21.1l4 4.09.1.1c0-.02.06.09-.06.21L10.4 12l-.47.44.22.62s1.14 3.08 3.56 5.38l.22.18A20.15 20.15 0 0 0 19 21.91l.63.28 2.96-2.97c.18-.17.14-.17.32 0l4.09 4.1c.17.16.17.1 0 .27l-3.06 3.07c-.46.4-.95.47-1.53.28a30.84 30.84 0 0 1-10.6-6.75A29.66 29.66 0 0 1 5.03 9.56c-.15-.4-.04-1 .31-1.31l.07-.06 3.03-3.1c.07-.05.14-.09.22-.09Z',
        'phone-square-alt-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13.13 2c-.52 0-1 .2-1.36.56l-1.15 1.15a1.96 1.96 0 0 0 0 2.71l1.71 1.7c-.53.78-1.13 1.5-1.8 2.16l-.26.25c-.65.67-1.38 1.28-2.15 1.8l-1.7-1.7a1.9 1.9 0 0 0-2.7 0l-1.16 1.15a1.92 1.92 0 0 0 0 2.7l.95.96c.53.53 1.3.7 1.99.45l.13-.04c.5-.17 1.68-.55 3.55-1.81a16.1 16.1 0 0 0 2.51-2.1l.24-.23a16.4 16.4 0 0 0 2.1-2.53c1.26-1.87 1.65-3.04 1.82-3.55l.04-.13a1.9 1.9 0 0 0-.46-1.99l-.95-.95A1.9 1.9 0 0 0 20.13 9z',
        'phone-square-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm4.87 2c-.49 0-.98.19-1.35.56l-.96.96a1.9 1.9 0 0 0-.45 1.98l.04.13c.17.5.55 1.68 1.81 3.55.61.9 1.32 1.76 2.1 2.52l.23.23c.77.78 1.62 1.5 2.53 2.1 1.87 1.27 3.04 1.65 3.55 1.82l.13.04a1.9 1.9 0 0 0 1.99-.46l.95-.95a1.9 1.9 0 0 0 0-2.7l-1.15-1.15a1.96 1.96 0 0 0-2.71 0l-1.7 1.7c-.78-.52-1.5-1.13-2.16-1.8l-.25-.26a14.19 14.19 0 0 1-1.8-2.14l1.7-1.71a1.9 1.9 0 0 0 0-2.7l-1.15-1.16A1.9 1.9 0 0 0 11.87 9z',
        'phone-volume-solid' => 'M19 0v2a11 11 0 0 1 11 11h2c0-7.17-5.83-13-13-13zM8.65 3a2.4 2.4 0 0 0-1.48.52l-.04.04L3.98 6.8l.07-.06a3.15 3.15 0 0 0-.88 3.5 31.24 31.24 0 0 0 7.22 11.37c4.25 4.25 9 6.3 11.35 7.22h.02l.03.02c1.21.4 2.52.11 3.46-.7l.03-.02 3.13-3.12c.83-.83.83-2.29 0-3.12l-4.1-4.1a2.26 2.26 0 0 0-3.12 0l-1.98 1.99a16 16 0 0 1-4.12-2.8 12.62 12.62 0 0 1-2.78-4.07l2-2c.88-.88.93-2.39-.09-3.2l.1.1-4.15-4.25-.04-.04a2.35 2.35 0 0 0-1.48-.51zM19 4v2a7 7 0 0 1 7 7h2c0-4.96-4.04-9-9-9zM8.65 5c.07 0 .14.03.21.08l4.07 4.16.05.04c-.01 0 .04.09-.09.21l-2.95 2.96.23.6s1.12 3.07 3.54 5.37c2.37 2.26 5.3 3.5 5.3 3.5l.62.27 2.98-2.98c.16-.17.12-.17.28 0l4.1 4.1c.17.17.17.11 0 .28l-3.04 3.05c-.47.4-.95.5-1.52.3A30.75 30.75 0 0 1 11.8 20.2 29.5 29.5 0 0 1 5.05 9.57v-.01l-.01-.02c-.15-.4-.04-.98.31-1.28l.03-.03 3.06-3.15A.35.35 0 0 1 8.65 5zM19 8v2a3 3 0 0 1 3 3h2a5 5 0 0 0-5-5z',
        'photo-video-solid' => 'M10 2v7h2V4h2v1h2V4h9v1h2V4h2v12h-2v-1h-2v3h6V2H10zm4 5v2h2V7h-2zm11 0v2h2V7h-2zM2 11v18h21V11H2zm23 0v2h2v-2h-2zM4 13h17v9.78l-2.6-2.6-.71-.68-2.82 2.81L10.6 18l-.68-.72L4 23.18V13zm11.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3zm-5.6 5.13 5 5 .7-.72 2.09-2.1L21 25.63V27H4v-.97l5.9-5.9z',
        'php' => 'M16 7.17c-8.84 0-16 3.76-16 8.41S7.17 24 16 24c8.84 0 16-3.77 16-8.42s-7.16-8.41-16-8.41zM16 8c8.57 0 15.16 3.6 15.16 7.57s-6.6 7.58-15.16 7.58C7.43 23.16.84 19.55.84 15.58c0-3.96 6.6-7.57 15.16-7.57zm-1.94 1.67-1.62 8.34h1.8l.94-4.78c1.46 0 2.07-.06 2.34.22.28.3.13.63-.63 4.56h1.83c.8-4.07 1.14-4.93.41-5.6-.7-.64-2.14-.53-3.7-.53l.43-2.21h-1.8zM6.49 11.9l-1.62 8.34h1.82l.43-2.21c2.03 0 3.3.14 4.46-.95 1.29-1.19 1.63-3.3.7-4.36-.47-.55-1.25-.82-2.3-.82h-3.5zm14.19 0-1.62 8.34h1.82l.43-2.21c2.14 0 3.32.12 4.46-.95 1.3-1.19 1.63-3.3.7-4.36-.47-.55-1.24-.82-2.3-.82h-3.49zM9.34 13.2c1.13.03 1.78.27 1.5 1.7-.39 2-1.76 1.8-3.46 1.8l.68-3.5h1.28zm14.19 0c1.14.03 1.78.27 1.5 1.7-.4 2.03-1.81 1.8-3.46 1.8l.67-3.5h1.29z',
        'pied-piper-alt' => 'M30.19 1.44c-1.01 1.65-2.71 6.13-10.44 8.28v-1.1c-.97.11-1.32-1.1-1.66-1.24-.77.78-1.22 1.51-2.06 2.06-1 .66-2.16.88-2.4 1.78.28-.11 1.24-.63 3.84-.63 1.66 0 1.64.18 2.53 1.29.3-.09.34-.24.44-.44-.48-.85-.71-.9-.66-1.25 2.67-.23 9.2-2.28 10.4-8.75Zm-13.16 9.6c-1.9 0-2.44.2-2.5.27-.12.44.42 1.4-.6 2.63l1.04.28c-.04.07-.16.28-.16.56 0 1.08 2.28.1 2.28 1.85 0 .56-1.52 3.12-3 3.12-1.4-1.2-2.93-2.77-2.75-3.47.82-.19 2.64-.55 2.85-.62.25-.09.53-.38.44-.72-.1-.35-.42-.58-1.16-.38-.2.06-2.13.47-2.13.47-.59-1.21-.93-.6-1.4-.5-.69.14-1.4.3-1 1.03l-7.22 1.6c-.2.04-.83.27-.69.78.13.48.52.48.63.47.4-.05 7.71-1.7 7.84-1.72.13.35.65.49 1.28 1.4.18.26 2.54 3.63 3.16 3.63 2.28 0 4.5-2.63 4.5-2.63-.05.9-1.85 2.41-1.85 2.41 0 .4.08 1.94.1 2.16.05 0 .55.15 1.9.15 1.36 0 2.25-.34 2.25-.34s.5-1.86.5-3.03c0-2.9-.79-3.07-2.06-4.19 0 0 .17-.1.38-.1 4.53.3 2.68 8.77 5.8 12.26.1-.04 4.38-1.74 5.54-2.5-5.57-4.51-5.7-10.45-11.88-10.44 0-1.47 1.5.28 1.82-1.9-.26.12-.5.22-.72.34-.99-2.52-.74-2.88-3.19-2.88Zm-4.12 2.87c-.25 0-.46.07-.7.12-.1.02-.19.06-.3.1l.3.56 1.45-.31c-.2-.1-.57-.48-.75-.47Zm.8 2c-.24.06-.47.13-.71.18l1.28 3.25 1.13-.71c-.22-.32-1.64-2.67-1.7-2.72Zm7.1 8.03c-.36.02-3.1.36-3.31.43l.13.75c.37-.05 2.76-.52 3.34-.71-.02-.1-.01-.37-.16-.47Zm-4.12.18a4.7 4.7 0 0 0 0 1.41c.1-.02.47-.1.6-.16l-.16-1.25Zm4.43.79c-2.62.11-4.31.97-4.43 1.09-.04.2.34 2.14.34 2.4 3.57.51 5.56-.48 5.66-.52a20.25 20.25 0 0 0-1.57-2.97Z',
        'pied-piper-hat' => 'm31 4.97-1.22.31c-6.29 1.52-8.92 7.17-10.22 10.19A5.18 5.18 0 0 0 15.81 14c-2.65 0-4.7 1.5-6.22 3.25-1.42 1.64-2.4 3.5-3.21 4.9-1.63.69-4.41.85-4.41.85l-1.5.03.62 1.38s.36.74 1.13 1.37A5.9 5.9 0 0 0 6 27c2.46 0 5.79-1 9-1h5v-.06c.5 0 1.02-.18 1.28-.63l2.5-4.18h.03c.5-.85-.1-2.02-1.06-2.13H21c-.3 0-.55.05-.84.06l.21-.5.29-.62.03-.07c.15-.3.48-.92.65-1.3.07-.04.14-.06.25-.1.35-.11.83-.23 1.35-.38.51-.14 1.06-.3 1.56-.53.5-.22 1-.46 1.34-1.1.38-.69.48-1.4.6-2.12.11-.71.21-1.42.4-1.93.6-1.62 1.76-2.5 3.5-3.16L31 7Zm-6.28 5.94c-.08.38-.2.78-.25 1.12a6.41 6.41 0 0 1-.38 1.47c-.02 0-.15.1-.4.22-.28.12-.69.26-1.1.37a15.45 15.45 0 0 1 2.13-3.18ZM15.82 16c1.3 0 2 .48 2.43.94.3.32.31.45.38.6l-.1.21-.66 1.5C14.19 19.77 11.66 21 10 21v2c3.1 0 6-2 11-2h.53l-1.81 3H15c-3.6 0-7.16 1-9 1-.7 0-1.23-.12-1.66-.28.98-.15 2.1-.35 3.1-.81l.28-.13.16-.28c.87-1.48 1.9-3.42 3.21-4.94C12.41 17.04 13.9 16 15.81 16Z',
        'pied-piper-pp' => 'M13.47 4c-.85 0-1.61.27-2.35.6H7V21l1.19-.25 3.6-.72.8-.16v-3.15c.14.02.28.08.41.12v11.38l1.19-.25 3.6-.72.8-.16v-3.15c.3.04.57.18.88.18 3.42 0 6.19-2.94 6.19-6.46 0-3.48-2.7-6.37-6.07-6.44A6.33 6.33 0 0 0 13.46 4Zm0 2a4.3 4.3 0 0 1 4.19 4.44c0 2.5-1.9 4.47-4.2 4.47-.52 0-1.02-.12-1.5-.32l-1.37-.56v4.19L9 18.56V6.6h2.38l.21-.12a4 4 0 0 1 1.88-.47Zm-.85.78c-.55 0-1.07.18-1.53.44l-.5.28v5.81l.5.28c.46.27.98.44 1.54.44 1.88 0 3.3-1.7 3.3-3.62 0-1.93-1.42-3.63-3.3-3.63Zm-.03 2h.04c.66 0 1.3.66 1.3 1.63 0 .96-.64 1.62-1.3 1.62h-.04Zm6.88 4.44a4.3 4.3 0 0 1 4.19 4.44c0 2.5-1.9 4.46-4.2 4.46-.52 0-1.02-.11-1.5-.3l-1.37-.57v4.19l-1.59.34v-9.06a6.1 6.1 0 0 0 1.6-.69v4.5l.5.28c.45.26.97.44 1.52.44 1.9 0 3.32-1.7 3.32-3.63 0-1.92-1.43-3.62-3.32-3.62.15-.23.26-.5.38-.75h.03c.14-.02.3-.03.44-.03ZM18.59 16h.04c.66 0 1.3.66 1.3 1.63 0 .96-.64 1.62-1.3 1.62h-.04Z',
        'pied-piper' => 'M13.47 4c-.85 0-1.61.27-2.35.6H7V21l1.19-.25 3.6-.72.8-.16v-3.15c.14.02.28.08.41.12v11.38l1.19-.25 3.6-.72.8-.16v-3.15c.3.04.57.18.88.18 3.42 0 6.19-2.94 6.19-6.46 0-3.48-2.7-6.37-6.07-6.44A6.33 6.33 0 0 0 13.46 4Zm0 2a4.3 4.3 0 0 1 4.19 4.44c0 2.5-1.9 4.47-4.2 4.47-.52 0-1.02-.12-1.5-.32l-1.37-.56v4.19L9 18.56V6.6h2.38l.21-.12a4 4 0 0 1 1.88-.47Zm-.85.78c-.55 0-1.07.18-1.53.44l-.5.28v5.81l.5.28c.46.27.98.44 1.54.44 1.88 0 3.3-1.7 3.3-3.62 0-1.93-1.42-3.63-3.3-3.63Zm-.03 2h.04c.66 0 1.3.66 1.3 1.63 0 .96-.64 1.62-1.3 1.62h-.04Zm6.88 4.44a4.3 4.3 0 0 1 4.19 4.44c0 2.5-1.9 4.46-4.2 4.46-.52 0-1.02-.11-1.5-.3l-1.37-.57v4.19l-1.59.34v-9.06a6.1 6.1 0 0 0 1.6-.69v4.5l.5.28c.45.26.97.44 1.52.44 1.9 0 3.32-1.7 3.32-3.63 0-1.92-1.43-3.62-3.32-3.62.15-.23.26-.5.38-.75h.03c.14-.02.3-.03.44-.03ZM18.59 16h.04c.66 0 1.3.66 1.3 1.63 0 .96-.64 1.62-1.3 1.62h-.04Z',
        'piggy-bank-solid' => 'M13.5 4A4.52 4.52 0 0 0 9 8.5c0 .8.23 1.54.6 2.19A9.42 9.42 0 0 0 5.62 15H5.5a.49.49 0 0 1-.5-.5c0-.18.09-.32.22-.4l-1.16-1.63A2.47 2.47 0 0 0 3 14.5a2.5 2.5 0 0 0 2.1 2.44c-.06.35-.1.7-.1 1.06 0 2.5 1.32 4.65 3.25 6.25-.24 1-.12 2.07.66 2.84a3.06 3.06 0 0 0 4.3 0l.38-.37c.79.14 1.57.28 2.41.28.84 0 1.63-.14 2.4-.28l.38.37a3.06 3.06 0 0 0 4.31 0c.77-.76.88-1.8.66-2.78A9.2 9.2 0 0 0 25.78 22H28v-8h-2.28a8.96 8.96 0 0 0-1.28-1.63L25 9.29V8h-1s-2.4.04-4.44 1.56a15.6 15.6 0 0 0-1.62-.37A4.52 4.52 0 0 0 13.5 4Zm0 2a2.49 2.49 0 0 1 2.44 3c-1.62 0-3.14.32-4.53.84A2.49 2.49 0 0 1 13.5 6Zm9.25 4.19h.03l-.37 2.28-.1.53.44.38a6.9 6.9 0 0 1 1.63 2.06l.28.56H26v4h-1.34l-.29.56a7.17 7.17 0 0 1-2.25 2.53l-.71.54.43.8c.24.41.2.9-.15 1.26-.42.42-1.05.42-1.47 0l-.72-.72-.4-.38-.54.13a11.42 11.42 0 0 1-5.12 0l-.53-.13-.41.38-.72.72c-.42.42-1.05.42-1.47 0a1 1 0 0 1-.15-1.25l.43-.82-.71-.53C8.06 21.8 7 20 7 18c0-3.74 3.91-7 9-7 1.23 0 2.4.18 3.47.53l.53.19.44-.38c.71-.63 1.6-.98 2.31-1.15ZM22 16a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'pills-solid' => 'M8.5 5A5.5 5.5 0 0 0 3 10.5v11a5.5 5.5 0 0 0 11 0v-11A5.5 5.5 0 0 0 8.5 5zm0 2a3.5 3.5 0 0 1 3.5 3.5V15H5v-4.5A3.5 3.5 0 0 1 8.5 7zm14 7a6.5 6.5 0 1 0 .02 13.02A6.5 6.5 0 0 0 22.5 14zm0 2a4.5 4.5 0 0 1 3.8 6.89l-6.19-6.2c.7-.43 1.51-.69 2.39-.69zM5 17h7v4.5a3.5 3.5 0 0 1-7 0V17zm13.7 1.11 6.19 6.2a4.5 4.5 0 0 1-6.19-6.19z',
        'pinterest-p' => 'M16.1 4C11.01 4 6 7.38 6 12.86c0 3.48 1.96 5.46 3.15 5.46.49 0 .77-1.36.77-1.75 0-.46-1.17-1.44-1.17-3.35 0-3.98 3.02-6.8 6.94-6.8 3.37 0 5.87 1.91 5.87 5.43 0 2.63-1.06 7.56-4.47 7.56-1.23 0-2.29-.9-2.29-2.17 0-1.87 1.2-3.68 1.2-5.61 0-3.28-4.54-2.68-4.54 1.28 0 .83.1 1.75.48 2.5-.68 2.94-1.94 7.63-1.94 10.66 0 .93.13 1.85.22 2.79.17.19.09.17.34.07 2.5-3.41 2.27-4.39 3.4-8.85.6 1.15 2.18 1.78 3.42 1.78 5.26 0 7.62-5.12 7.62-9.74C25 7.2 20.75 4 16.1 4z',
        'pinterest-square' => 'M5 5v22h22V5H5zm2 2h18v18H13.51c.26-.5.48-1.03.6-1.5.14-.52.89-2.76.89-2.76.36.68 1.4 1.26 2.51 1.26 3.31 0 5.49-2.9 5.49-6.67C23 11.71 20.04 9 16.24 9 11.51 9 9 12.17 9 15.63c0 1.61.86 3.61 2.22 4.25.21.1.32.05.37-.15l.3-1.24a.32.32 0 0 0-.07-.31 4.27 4.27 0 0 1-.82-2.5 4.75 4.75 0 0 1 4.95-4.76c2.7 0 4.58 1.84 4.58 4.46 0 2.96-1.3 4.87-3.24 4.87-1.08 0-2.09-.74-1.83-1.83.3-1.3.9-2.71.9-3.66 0-2.36-3.36-2.04-3.36 1.12 0 .97.32 1.63.32 1.63-1.06 4.74-1.36 5.77-1.27 7.49H7V7z',
        'pinterest' => 'M16 4a12 12 0 0 0-4.37 23.18c-.1-.95-.2-2.41.04-3.45l1.4-5.96s-.35-.72-.35-1.79c0-1.66.96-2.91 2.17-2.91 1.02 0 1.52.77 1.52 1.7 0 1.02-.66 2.56-1 3.99-.28 1.2.6 2.17 1.78 2.17 2.13 0 3.77-2.25 3.77-5.5 0-2.87-2.06-4.88-5.01-4.88a5.2 5.2 0 0 0-5.42 5.2c0 1.04.4 2.14.9 2.75.1.11.1.22.08.34l-.33 1.36c-.06.22-.18.27-.4.16-1.5-.7-2.44-2.89-2.44-4.65 0-3.78 2.75-7.26 7.93-7.26 4.16 0 7.4 2.96 7.4 6.93 0 4.14-2.62 7.46-6.23 7.46-1.22 0-2.36-.63-2.75-1.37l-.75 2.85c-.27 1.04-1 2.35-1.5 3.14A12 12 0 1 0 16 4Z',
        'pizza-slice-solid' => 'm12.38 3.81-.32.85-8 21.9-.22.6 1 1 .6-.22 21.9-8 .85-.32-.22-.87s-1.41-5.63-5.25-9.47c-3.84-3.84-9.47-5.25-9.47-5.25Zm1.21 2.47c1.14.35 4.84 1.59 7.7 4.44a19.28 19.28 0 0 1 4.43 7.69l-1.53.56c-.1-.4-.23-.87-.44-1.4-.6-1.52-1.75-3.5-3.78-5.54a16.64 16.64 0 0 0-5.53-3.75c-.54-.21-1-.36-1.4-.47Zm-1.21 3.4c.33.1.76.23 1.3.45a14.5 14.5 0 0 1 4.88 3.3c.54.54.98 1.06 1.38 1.57a2 2 0 0 0 .06 4c.74 0 1.37-.4 1.72-1 .04.1.12.21.16.31.22.57.34 1.01.43 1.35l-10 3.62a1.5 1.5 0 0 0-2.78 1.03l-2.9 1.07 3.5-9.6A2 2 0 0 0 11 16a2 2 0 0 0 .5-3.94ZM14 17.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'place-of-worship-solid' => 'm16 4.4-.78.97-4 5-.22.29v6.28L5.47 20.4l1.06 1.68.47-.28V27h8v-4c0-.57.43-1 1-1 .57 0 1 .43 1 1v4h8v-5.19l.47.28 1.06-1.68L21 16.94v-6.28l-.22-.29-4-5Zm0 3.2 3 3.74v4.35l-2.47-1.53-.53-.35-.53.35L13 15.69v-4.35Zm0 3.4a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 5.19 7 4.37V25h-4v-2c0-1.64-1.36-3-3-3s-3 1.36-3 3v2H9v-4.44Z',
        'plane-arrival-solid' => 'm3.4 3.97-.06 1.28L3 14.03l-.03.78.75.22 6.4 1.94-5.43 3.78-1.53 1.06 1.71.69 2.85 1.13.37.15.38-.16 10-4.15 6.4 1.94c1.7.5 3.5-.48 4-2.16a3.23 3.23 0 0 0-2.15-4l-5.69-1.75-3.78-6.25-.22-.34-.37-.13L14 6.06l-1.47-.37.22 1.5.53 3.9-4.25-1.3-1.62-4.2-.2-.46-.46-.16-2.13-.63Zm1.88 2.65.44.13 1.6 4.19.15.47.47.12 18.18 5.63c.66.2 1.01.85.82 1.5-.2.65-.85 1-1.5.8l-6.75-2.02-.35-.1-.3.13-9.95 4.16-.75-.32 5.63-3.87 1.72-1.19-2-.6-7.66-2.3Zm9.63 1.79.8.21 2.45 3.97-2.82-.84ZM20.5 21a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM3 26v2h26v-2Z',
        'plane-departure-solid' => 'M25.72 4.78c-.39.04-.76.15-1.13.34l-4.71 2.5-6.38-1.56-.38-.1-.37.2-2.16 1.25-1.28.75 1.19.9 2.72 2.06-3.4 1.82-3.66-1.66-.44-.19-.44.22-1.75.94-1.15.63.87.93 5.4 5.81.5.6.7-.38L15 17.1l-1.03 5.7-.35 1.8 1.72-.71 2.57-1.1.37-.16.16-.37 3.72-9.03 5.25-2.81a3.03 3.03 0 0 0 1.25-4.07 2.99 2.99 0 0 0-1.79-1.43 3.16 3.16 0 0 0-1.15-.13Zm.19 2c.12 0 .25 0 .37.03a.98.98 0 0 1 .19 1.82l-5.6 3.03-.3.15-.13.35-3.72 8.93-.44.2 1.06-5.91.38-2.04-1.81.97-6.32 3.4-3.96-4.3.15-.1 3.66 1.63.47.22.4-.25 15.22-8.04a.89.89 0 0 1 .38-.09ZM13.37 8.1l3.85.94-2.06 1.06-2.25-1.71ZM3 26v2h26v-2Z',
        'plane-solid' => 'M16 3c-1.64 0-3 1.36-3 3v7.34L4.6 17.1l-.6.25v4.79l9-1v1.84l-2.56 1.72-.44.28v4.25l1.19-.25L16 28l4.81.97 1.19.25v-4.25l-.44-.28L19 22.97v-1.84l9 1v-4.79l-.6-.25-8.4-3.75V6c0-1.64-1.36-3-3-3Zm0 2c.57 0 1 .43 1 1v8.66l.6.25 8.4 3.75v1.21l-9-1v5.2l.44.27L20 26.06v.72l-3.81-.75-.19-.06-.19.06-3.81.75v-.72l2.56-1.72.44-.28v-5.18l-9 1v-1.22l8.4-3.75.6-.25V6c0-.57.43-1 1-1Z',
        'play-circle-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 3.13v13.74l1.5-.87 9-5.13L24 16l-1.5-.88-9-5.12Zm2 3.43L19.97 16 14 19.44Z',
        'play-circle' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 3.13v13.74l1.5-.87 9-5.13L24 16l-1.5-.88-9-5.12Zm2 3.43L19.97 16 14 19.44Z',
        'play-solid' => 'M9 5.16v21.68l1.53-1L25.84 16l-15.3-9.84Zm2 3.65L22.16 16 11 23.19Z',
        'playstation' => 'M12.94 6v18.75L17 26V10.34c0-.41.05-.7.22-.87.17-.24.35-.26.6-.16.58.17.84.67.84 1.53v6.32c1.31.62 2.5.68 3.37.03.9-.62 1.38-1.75 1.38-3.4 0-1.74-.33-3.05-1.1-3.91-.69-.94-1.91-1.7-3.72-2.32A57.35 57.35 0 0 0 12.94 6Zm-1.25 11.34-.81.25-5.04 1.82-.87.34c-1.32.55-2 1.14-1.97 1.66.07.76.94 1.3 2.5 1.71a15 15 0 0 0 6.19.35v-2.13l-.81.32L10 22l-1.47.28-1.37-.19c-.28-.17-.34-.36-.16-.53.17-.1.41-.24.69-.34l.93-.34 3.07-1.07Zm11.65 1c-.37-.01-.76.02-1.12.04-1.35.02-2.72.26-4.16.71v2.5l2.85-1 1.46-.5.97-.25c.62-.16 1.29.07 1.29.07.37.03.55.16.62.34.07.2-.17.39-.69.56l-1.28.5-5.22 1.88v2.43l2.44-.87 5.84-2.06.72-.32c1.39-.51 2.01-1.08 1.94-1.78-.04-.66-.8-1.17-2.19-1.62-1.17-.4-2.34-.58-3.47-.63Z',
        'plug-solid' => 'm22 3.6-4 3.96-2.28-2.28-1.44 1.44.75.75-5.12 5.12a3.13 3.13 0 0 0 0 4.41l1.84 1.84-7.47 7.44 1.44 1.44 7.44-7.47L15 22.09a3.13 3.13 0 0 0 4.4 0l5.13-5.12.75.75 1.44-1.44L24.44 14l3.97-4L27 8.6l-4 3.96L19.44 9l3.97-4Zm-5.56 5.28 6.68 6.68L18 20.7c-.39.38-1.2.38-1.6 0l-5.09-5.1c-.38-.38-.38-1.2 0-1.59Z',
        'plus-circle-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-1 5v5h-5v2h5v5h2v-5h5v-2h-5v-5Z',
        'plus-solid' => 'M15 5v10H5v2h10v10h2V17h10v-2H17V5Z',
        'plus-square-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm8 4v4h-4v2h4v4h2v-4h4v-2h-4v-4Z',
        'plus-square' => 'M5 5v22h22V5Zm2 2h18v18H7Zm8 4v4h-4v2h4v4h2v-4h4v-2h-4v-4Z',
        'podcast-solid' => 'M16.5 3C10.16 3 5 8.16 5 14.5a11.5 11.5 0 0 0 6.76 10.46c-.12-.84-.2-1.68-.24-2.39a9.5 9.5 0 1 1 9.96 0c-.04.71-.12 1.55-.24 2.4A11.5 11.5 0 0 0 28 14.5C28 8.16 22.84 3 16.5 3zm0 4a7.5 7.5 0 0 0-4.7 13.33 4.1 4.1 0 0 1 1.14-1.65 5.49 5.49 0 1 1 7.12 0 4.1 4.1 0 0 1 1.15 1.65A7.49 7.49 0 0 0 16.5 7zm0 4a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zm0 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zm0 6c-3.16 0-3.5 2.08-3.5 2.97 0 1.64.54 4.95.83 6.2.13.55.65 1.83 2.67 1.83s2.54-1.28 2.67-1.83c.3-1.25.83-4.56.83-6.2 0-.9-.34-2.97-3.5-2.97zm0 2c1.5 0 1.5.56 1.5.97 0 1.33-.47 4.43-.78 5.75-.02.1-.06.28-.72.28-.66 0-.7-.18-.72-.28a36.7 36.7 0 0 1-.78-5.75c0-.41 0-.97 1.5-.97z',
        'poll-h-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm3 3v2h8v-2h-8zm0 5v2h12v-2H10zm0 5v2h6v-2h-6z',
        'poll-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8 3v12h2V10h-2zm-5 4v8h2v-8h-2zm10 2v6h2v-6h-2z',
        'poo-solid' => 'M17 6c-2.84 0-6 2.61-6 6.36V13h-1a4 4 0 0 0-3.81 5.2A4.5 4.5 0 0 0 7.5 27h17a4.5 4.5 0 0 0 1.31-8.8A4 4 0 0 0 22 13h-1.07c-.26-1.77-1.2-2.47-1.9-3-.75-.55-1.24-.92-1.04-2.9l.12-1.1H17zm-1.05 2.19c.08 1.9.9 2.69 1.89 3.42.7.52 1.16.86 1.16 2.39v1h3a1.99 1.99 0 0 1 1.48 3.33L21.96 20h2.54a2.5 2.5 0 0 1 0 5h-17a2.5 2.5 0 0 1 0-5h2.54l-1.52-1.67A1.99 1.99 0 0 1 10 15h3v-2.64c0-2 1.43-3.63 2.95-4.17zM12 17a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-6 3a2 2 0 1 0 4 0h-4z',
        'poo-storm-solid' => 'M17 4c-2.84 0-6 2.61-6 6.36V11h-1a4 4 0 0 0-3.81 5.2A4.5 4.5 0 0 0 7.5 25H15v-.59L10.77 23H7.5a2.5 2.5 0 0 1 0-5h2.54l-1.52-1.67A1.99 1.99 0 0 1 10 13h3v-2.64c0-2 1.43-3.63 2.95-4.17.08 1.9.9 2.69 1.89 3.42.7.52 1.16.86 1.16 2.39v1h3a1.99 1.99 0 0 1 1.48 3.33L21.96 18h2.54a2.5 2.5 0 0 1 0 5h-2.58L21 25h3.5a4.5 4.5 0 0 0 1.31-8.8A4 4 0 0 0 22 11h-1.07a4.08 4.08 0 0 0-1.9-3c-.75-.55-1.24-.92-1.04-2.9l.12-1.1H17zm0 11.5-3 6.47 3 1v5.53l3-6.5-3-1v-5.5z',
        'poop-solid' => 'm21.13 4-1.66.63a11.4 11.4 0 0 0-3.88 2.18 5.1 5.1 0 0 0-1.37 2.22c-.2.63-.27 1-.4 1.19-.12.17-.33.37-.98.56l-.09-.06h-.03a4.28 4.28 0 0 0-6 1.37l-.03.04a5.76 5.76 0 0 0-.44 4.84 4.53 4.53 0 0 0-3.63 2.25H2.6a4.53 4.53 0 0 0 1.7 6.16h.02v.03c.12.05 1.45.75 3.44 1.37A27.6 27.6 0 0 0 16 28c3.47 0 6.25-.58 8.25-1.19a15.8 15.8 0 0 0 3.47-1.43l.03-.04a4.44 4.44 0 0 0 1.63-6.06h.03a4.36 4.36 0 0 0-2.5-2.03h-.04a4.42 4.42 0 0 0-2.09-2.69c.14-.44.22-.94.22-1.56a4.6 4.6 0 0 0-.97-2.84c-.55-.71-1.22-1.18-1.78-1.63-.56-.44-1-.85-1.25-1.25-.24-.4-.36-.77-.22-1.53Zm-2.25 3.19c.09.42.23.82.43 1.15A6.6 6.6 0 0 0 21 10.06a9 9 0 0 1 1.47 1.35c.34.44.53.86.53 1.59 0 .48-.05.77-.13 1A33.67 33.67 0 0 1 16 12.25c-.35-.13-.66-.27-.97-.4.17-.15.32-.33.44-.5.45-.66.51-1.3.65-1.76.15-.46.31-.83.85-1.34.32-.3 1.21-.7 1.9-1.06Zm-8.57 4.78c.44 0 .9.13 1.31.4.56.39 1.74.99 3.7 1.72 1.97.75 4.61 1.54 7.71 1.94h.03c.7.09 1.27.5 1.63 1.1a5 5 0 0 0-1.07.3c-.05.03-.1.02-.15.04l-.06.03-.1.03c-.02.01-.06.05-.1.06a14.49 14.49 0 0 1-1.81.66c-1.25.37-3.08.75-5.4.75-1.72 0-3.2-.2-4.34-.44-.36-.08-.71-.18-1.04-.28-.65-.2-1.25-.5-1.24-.5A3.1 3.1 0 0 1 7.9 15.5c-.1-.84.13-1.74.5-2.38a2.28 2.28 0 0 1 1.9-1.15Zm-4.03 6.97c.48-.04.98.08 1.44.34l.03.03.19.1.47.21a14.41 14.41 0 0 0 2.5.79l.3.09h.04c.4.1.8.2 1.19.25v-.03a21.86 21.86 0 0 0 9.53-.56c.7-.21 1.27-.44 1.66-.6l.3-.15h.1l.03-.04.19-.09a2.52 2.52 0 0 1 3.44.97v.03a2.45 2.45 0 0 1-.94 3.38h-.03v.03c-.08.04-1.2.66-3.03 1.22C21.86 25.46 19.25 26 16 26s-5.86-.53-7.69-1.1c-1.8-.56-2.71-1.07-3.06-1.24l-.03-.04a2.47 2.47 0 0 1-.88-3.4 2.57 2.57 0 0 1 1.94-1.28Z',
        'portrait-solid' => 'M7 5v22h18V5Zm2 2h14v18H9Zm7 3a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 21h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 10Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'pound-sign-solid' => 'M17.69 5A6.74 6.74 0 0 0 11 11.66c0 1.13.28 2.24.66 3.34H9v2h3.4c.2.55.37 1.1.5 1.66.57 2.2.63 4.18-1.37 6.34H8v2h16v-5h-2v3h-7.94c1.4-2.3 1.32-4.75.78-6.84-.1-.4-.22-.78-.34-1.16H20v-2h-6.16a11.8 11.8 0 0 1-.84-3.34c0-3.23 3.3-5.55 6.38-4.32l.75-1.84a6.59 6.59 0 0 0-2.44-.5Z',
        'power-off-solid' => 'M15 4v12h2V4Zm-3 .69A12.01 12.01 0 0 0 16 28a12.01 12.01 0 0 0 4-23.31v2.15A10 10 0 0 1 16 26a10 10 0 0 1-4-19.16Z',
        'pray-solid' => 'M17.5 4a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zm0 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zm-4.34 6c-1.1 0-2.1.65-2.53 1.67l-1.97 4.59a3 3 0 0 0 .87 3.5L13.94 25H7v2h8.48a1.5 1.5 0 0 0 .89-2.7l-5.6-4.1a1 1 0 0 1-.27-1.16l1.96-4.58c.2-.48.9-.6 1.25-.22l2.44 4 .07.1a1.78 1.78 0 0 0 2.64.14l3.92-4.85-1.56-1.26-3.59 4.45-2.25-3.68-.07-.1A2.74 2.74 0 0 0 13.16 12z',
        'praying-hands-solid' => 'M15 3c-1.64 0-3 1.36-3 3l.02-.16-.99 5.9-1.89 5.18c-.03.04-.08.08-.14.08H8v-1H3v13h5v-3h3.93c1.64 0 3.12-.8 4.07-2.04A5.14 5.14 0 0 0 20.07 26H24v3h5V16h-5v1h-1c-.06 0-.1-.04-.14-.08l-1.9-5.17-.98-5.91L20 6c0-1.64-1.36-3-3-3-.34 0-.69.07-1 .23A2.19 2.19 0 0 0 15 3Zm-.04 2.02c.02.14.04.47.04.98v15.44A3.12 3.12 0 0 1 11.93 24H8v-5h1a2.2 2.2 0 0 0 1.9-1.1l.04-.08 2.03-5.57L14 6.08V6c0-.55.42-.96.96-.98Zm2.08 0c.54.02.96.43.96.98v.08l1.03 6.17 2.03 5.57.04.07A2.2 2.2 0 0 0 23 19h1v5h-3.93A3.12 3.12 0 0 1 17 21.44V6c0-.51.02-.84.04-.98ZM5 18h1v9H5Zm21 0h1v9h-1Z',
        'prescription-bottle-alt-solid' => 'M9.93 3a2.5 2.5 0 0 0-2.24 1.38L7.4 5H7a2 2 0 0 0-2 2v4h1v16c0 1.1.9 2 2 2h16a2 2 0 0 0 2-2V11h1V7a2 2 0 0 0-2-2h-.38l-.31-.62A2.49 2.49 0 0 0 22.07 3H9.93zm0 2h12.14c.2 0 .36.1.45.28L23.38 7H25v2H7V7h1.62l.86-1.72A.5.5 0 0 1 9.93 5zM8 11h16v16H8V11zm7 3v4h-4v2h4v4h2v-4h4v-2h-4v-4h-2z',
        'prescription-bottle-solid' => 'M9.93 3a2.5 2.5 0 0 0-2.24 1.38L7.4 5H7a2 2 0 0 0-2 2v4h1v16c0 1.1.9 2 2 2h16a2 2 0 0 0 2-2V11h1V7a2 2 0 0 0-2-2h-.38l-.31-.62A2.49 2.49 0 0 0 22.07 3H9.93zm0 2h12.14c.2 0 .36.1.45.28L23.38 7H25v2H7V7h1.62l.86-1.72A.5.5 0 0 1 9.93 5zM8 11h16v16H8v-3h6v-2H8v-2h6v-2H8v-2h6v-2H8v-3z',
        'prescription-solid' => 'M6 3v16h2v-6h5l4.77 8.83L13.11 29h2.38l3.9-6h.22l3.9 6h2.38l-4.65-7.15 4-6.85h-2.31l-3.42 5.85-4.48-8.29A5 5 0 0 0 13 3H6zm2 2h5a3 3 0 0 1 0 6H8V5z',
        'print-solid' => 'M9 4v7H7c-1.64 0-3 1.36-3 3v10h5v4h14v-4h5V14c0-1.64-1.36-3-3-3h-2V4Zm2 2h10v5H11Zm-4 7h18c.57 0 1 .43 1 1v8h-3v-4H9v4H6v-8c0-.57.43-1 1-1Zm1 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 6h10v6H11Z',
        'procedures-solid' => 'M17.13.44 14.38 6H9v2h6.63l1.24-2.56L19.73 13l3.78-5H28V6h-5.5l-2.22 2.88L17.12.44zM6.5 11A2.5 2.5 0 0 0 4 13.5V28h5v-2h14v2h5V17c0-1.64-1.36-3-3-3H13v.56a3.93 3.93 0 0 0-2-.56c-.73 0-1.4.21-2 .56V13.5A2.5 2.5 0 0 0 6.5 11zm0 2c.21 0 .5.29.5.5V22h19v4h-1v-2H7v2H6V13.5c0-.21.29-.5.5-.5zm4.5 3c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2zm4 0h10a1 1 0 0 1 1 1v3H15v-4z',
        'product-hunt' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-3 6v11h2v-4h2.5a3.5 3.5 0 0 0 0-7H13zm2 2h2.5a1.5 1.5 0 0 1 0 3H15v-3z',
        'project-diagram-solid' => 'M3 6v8h5.63L12 19.9V27h8v-8h-6.22l-2.84-5H11v-3h10v3h8V6h-8v3H11V6H3zm2 2h4v4H5V8zm18 0h4v4h-4V8zm-8.58 13H18v4h-4v-3.76l.42-.24z',
        'pushed' => 'M20.53 4c-.12 0-.24 0-.36.02L5.63 6.4c-.8.15-1.4.98-1.15 1.96l5.64 18.67c.34 1.14 1.96 1.3 2.55.37l1.9-4.33 12.82-12.4c.88-.9.23-2.3-.93-2.4l-5.5-.47.75-1.8c.48-1.1-.33-1.93-1.18-2zm-.16 1.15c.27-.03.4.14.28.4l-.9 2.14-9.5-.87 10.12-1.67zM5.97 7.58l13.32 1.21-5.19 12.36L5.64 8.06c-.17-.27.06-.53.33-.48zM20.49 8.9l5.92.53c.22.05.31.28.14.45L15.68 20.36l4.8-11.46zM6.76 11.91 13.6 22.5c-.38.8-1.89 4.24-1.89 4.24-.14.21-.42.16-.5-.07L6.76 11.91z',
        'puzzle-piece-solid' => 'M17 3a4 4 0 0 0-4 4H7v5a4 4 0 1 0 0 8v5h6a4 4 0 1 0 8 0h6v-7h-2c-1.2 0-2-.8-2-2s.8-2 2-2h2V7h-6a4 4 0 0 0-4-4Zm0 2c1.2 0 2 .8 2 2v2h6v3a4 4 0 1 0 0 8v3h-6v2c0 1.2-.8 2-2 2s-2-.8-2-2v-2H9v-5H7c-1.2 0-2-.8-2-2s.8-2 2-2h2V9h6V7c0-1.2.8-2 2-2Z',
        'python' => 'M16 5c-4.99 0-5 2-5 2v4h6v1H7s-3-.46-3 5 3 5 3 5h3v-1.63A4.38 4.38 0 0 1 14.38 16h3.24c1.86 0 3.38-.52 3.38-2.38V7s-.01-2-5-2Zm-3 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2Zm9 4v2.63c0 2.4-1.96 3.37-4.38 3.37h-3.25A3.38 3.38 0 0 0 11 20.38V26s.06 2 5 2 5-2 5-2v-4h-6v-1h10s3 .5 3-5-3-5-3-5Zm-3 13a1 1 0 0 1 0 2 1 1 0 0 1 0-2Z',
        'qq' => 'M16 5.89c6.09 0 6.4 5.43 6.73 6.5 0 0 .48.54.6 1.36.07.52-.23 1.12-.23 1.12s1.94 2.62 1.94 4.68c0 1.29-.38 1.95-.82 1.95-.44 0-1.1-1.36-1.1-1.36s-1 2.17-1.51 2.48c-.51.31 1.83.65 1.83 1.66 0 1.02-1.86 1.47-3.38 1.47-1.52 0-3.95-.8-3.95-.8l-.87-.02s-.68.96-3.47.96-4-.76-4-1.66c0-1.22 1.78-1.38 1.78-1.38s-1.13-.32-2.09-3c0 0-.66 1.45-1.6 1.45 0 0-.4-.24-.4-1.55 0-2.73 1.96-4.05 2.8-4.87 0 0-.13-.36-.06-.8.08-.49.37-.79.37-.79s-.1-.59.3-1.06C8.96 10.9 9.91 5.89 16 5.89m0-2c-6.4 0-8.67 4.59-9.07 7.66-.2.38-.3.77-.34 1.13a3.52 3.52 0 0 0-.4 1.38 7.46 7.46 0 0 0-2.73 5.69c0 2.03.75 2.9 1.38 3.27l.47.28h.59c-.09.28-.14.6-.14.93 0 .86.44 3.66 6 3.66 2.04 0 3.32-.44 4.1-.91.82.24 2.74.77 4.18.77 3.27 0 5.39-1.36 5.39-3.47 0-.37-.08-.7-.2-1 .97-.44 1.8-1.57 1.8-3.73 0-1.9-1.05-3.88-1.76-5.01.06-.33.08-.7.02-1.07a4.83 4.83 0 0 0-.72-1.92l-.02-.12c-1.05-5-3.93-7.54-8.56-7.54Z',
        'qrcode-solid' => 'M5 5v8h2v2h2v-2h4V5Zm8 8v2h2v2h-4v2H5v8h8v-8h6v-2h-2v-2h4v-2h2v2h2v-2h2V5h-8v8Zm12 2v2h2v-2Zm0 2h-2v2h2Zm0 2v2h2v-2Zm0 2h-2v-2h-2v2h-5v6h2v-4h4v2h2v-2h1Zm-3 4h-2v2h2Zm1-8v-2h-2v2Zm-12 0v-2H9v2Zm-4-2H5v2h2Zm8-10v4h-1v2h1v1h2V9h1V7h-1V5ZM7 7h4v4H7Zm14 0h4v4h-4ZM8 8v2h2V8Zm14 0v2h2V8ZM7 21h4v4H7Zm1 1v2h2v-2Zm17 3v2h2v-2Z',
        'question-circle-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 4c-2.2 0-4 1.8-4 4h2c0-1.12.88-2 2-2s2 .88 2 2c0 .77-.5 1.45-1.22 1.69l-.4.12a2.02 2.02 0 0 0-1.38 1.9V19h2v-1.28l.4-.13A3.8 3.8 0 0 0 20 14c0-2.2-1.8-4-4-4Zm-1 10v2h2v-2Z',
        'question-circle' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 4c-2.2 0-4 1.8-4 4h2c0-1.12.88-2 2-2s2 .88 2 2c0 .77-.5 1.45-1.22 1.69l-.4.12a2.02 2.02 0 0 0-1.38 1.9V19h2v-1.28l.4-.13A3.8 3.8 0 0 0 20 14c0-2.2-1.8-4-4-4Zm-1 10v2h2v-2Z',
        'question-solid' => 'M16 4c-4.33 0-8 3.05-8 7v3h6v-3c0-.15.09-.36.44-.6.35-.22.91-.4 1.56-.4s1.22.18 1.56.4c.35.24.44.44.44.6 0 .58-.19.98-.56 1.44-.38.45-.96.93-1.6 1.47C14.57 14.99 13 16.5 13 19v1h6v-1c0-.34.13-.58.5-.97.38-.39 1-.85 1.66-1.4C22.48 15.52 24 13.81 24 11c0-3.91-3.66-7-8-7Zm0 2c3.4 0 6 2.37 6 5 0 2.14-.98 3.1-2.16 4.1-.59.49-1.21.97-1.78 1.56a3.9 3.9 0 0 0-.81 1.34h-1.94a5.39 5.39 0 0 1 1.85-2.56c.61-.52 1.28-1.06 1.84-1.75.56-.7 1-1.6 1-2.69 0-.96-.57-1.76-1.31-2.25A4.86 4.86 0 0 0 16 8c-1 0-1.95.26-2.69.75-.74.5-1.31 1.3-1.31 2.25v1h-2v-1c0-2.68 2.6-5 6-5Zm-3 16v6h6v-6Zm2 2h2v2h-2Z',
        'quidditch-solid' => 'm28.4 5.2-10.56 7.92-.43-.57-1.05-1.39-1.6 1.2.4.53-4.54.68a7.89 7.89 0 0 0-5.1 3.07L3 20h1.7a12.96 12.96 0 0 0-2.47 4.95L1.73 27h7.11a8.4 8.4 0 0 0 7.86-5.49l1.66-4.37.36.47 1.6-1.2-1.28-1.7 10.56-7.9-1.2-1.6zm-11.87 9.5.4.55-2.1 5.56a6.38 6.38 0 0 1-6 4.19H4.3a10.88 10.88 0 0 1 2.74-4.62L9.41 18H7l.12-.16a5.9 5.9 0 0 1 3.8-2.3l5.6-.84zM23.5 20a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zm0 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3z',
        'quinscape' => 'M16 4a12 12 0 0 0 0 24c1.32 0 2.57-.24 3.75-.63-.16-.12-.3-.25-.45-.38A7.5 7.5 0 1 1 27 19.3l.38.45c.4-1.18.63-2.43.63-3.75A12 12 0 0 0 16 4zm7 14a5 5 0 0 0 0 10 5 5 0 0 0 0-10z',
        'quora' => 'M15.5 4C10.2 4 5 8.23 5 14.44c0 7.12 6.97 11.76 13.21 10.03 1.05 1.78 2.43 3.53 5.06 3.53C27.6 28 28 24 28 23h-1.55c-.08.72-.57 1.46-1.77 1.46-1.08 0-1.87-.76-2.62-1.9a10.06 10.06 0 0 0 3.89-8.12C25.95 8.2 20.89 4 15.49 4zm0 2c4.04 0 5.76 2.9 5.76 8.44 0 2.22-.29 4.01-.89 5.33-1.03-1.55-2.32-2.77-4.85-2.77-1.62 0-2.73.47-3.5 1.15l.64 1.3c.33-.17.53-.16.9-.16 1.88 0 2.84 1.63 3.67 3.25a6 6 0 0 1-1.74.23c-3.98 0-5.7-2.82-5.7-8.32C9.79 8.9 11.5 6 15.49 6z',
        'quote-left-solid' => 'M10 8c-3.3 0-6 2.7-6 6v10h10V14H6c0-2.22 1.78-4 4-4Zm14 0c-3.3 0-6 2.7-6 6v10h10V14h-8c0-2.22 1.78-4 4-4ZM6 16h6v6H6Zm14 0h6v6h-6Z',
        'quote-right-solid' => 'M4 8v10h8c0 2.22-1.78 4-4 4v2c3.3 0 6-2.7 6-6V8Zm14 0v10h8c0 2.22-1.78 4-4 4v2c3.3 0 6-2.7 6-6V8ZM6 10h6v6H6Zm14 0h6v6h-6Z',
        'quran-solid' => 'M8 3C6.36 3 5 4.36 5 6v20c0 1.64 1.36 3 3 3h19V3Zm0 2h17v18H8c-.35 0-.68.07-1 .19V6c0-.57.43-1 1-1Zm0 1v16h16V6Zm2 2h12v12H10Zm6 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 2h-3v6h6v-6Zm3 3a1 1 0 0 0 2 0 1 1 0 0 0-2 0Zm-3 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3-3a1 1 0 0 0-2 0 1 1 0 0 0 2 0Zm2-1h2v2h-2ZM8 25h17v2H8c-.57 0-1-.43-1-1 0-.57.43-1 1-1Z',
        'r-project' => 'M16 5C8.27 5 2 9.25 2 14.5c0 4.79 5.22 8.73 12 9.4V26h4v-2.1c1.32-.14 2.59-.39 3.76-.75L23.33 26H28l-2.7-4.41c2.88-1.74 4.7-4.27 4.7-7.09C30 9.25 23.73 5 16 5zm1.5 3C23.3 8 28 11.13 28 15c0 2.13-1.43 4.03-3.68 5.32a3.06 3.06 0 0 0-.75-.46A4.5 4.5 0 0 0 22.5 11H14v10.6c-4.08-.97-7-3.55-7-6.6 0-3.87 4.7-7 10.5-7zm.5 6h3.5a1.5 1.5 0 0 1 0 3H18v-3zm0 6h1.13c.56 0 1.07.3 1.34.8l.45.81c-.92.21-1.9.34-2.92.37V20z',
        'radiation-alt-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-4.5 3.19A9.1 9.1 0 0 0 7 16h6.5c0-.9.51-1.69 1.31-2.19Zm9 0-3.19 5.62c.8.4 1.28 1.19 1.28 2.19H25a9.1 9.1 0 0 0-4.5-7.81Zm-9.6 3 1.29 2.31c-.1.2-.18.3-.28.5H9.3c.3-1 .9-2.01 1.6-2.81Zm10.2 0A6.6 6.6 0 0 1 22.69 14h-2.6c-.1-.2-.18-.4-.28-.5ZM16 14.4c-.9 0-1.6.7-1.6 1.59 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6 0-.9-.7-1.6-1.6-1.6Zm-1.31 3.78L11.5 23.8c1.3.8 2.9 1.19 4.5 1.19s3.2-.39 4.5-1.19l-3.19-5.62c-.4.2-.81.31-1.31.31s-.91-.11-1.31-.31Zm1 2.31h.62l1.28 2.31c-.5.1-1.09.19-1.59.19s-1.1-.09-1.6-.19Z',
        'radiation-solid' => 'm9.16 3.89-.88.65a13 13 0 0 0-5.23 9.38L2.96 15h7.98l.14-.84a4.96 4.96 0 0 1 1.63-2.92l.64-.55-4.19-6.8zm13.68 0-4.19 6.8.64.55c.87.76 1.45 1.8 1.63 2.92l.14.84h7.98l-.1-1.08a13 13 0 0 0-5.23-9.38l-.87-.65zM8.63 6.84l2.15 3.5A6.97 6.97 0 0 0 9.3 13H5.2a11 11 0 0 1 3.44-6.16zm14.74 0A11 11 0 0 1 26.81 13h-4.1a6.9 6.9 0 0 0-1.5-2.66l2.16-3.5zM16 12a3 3 0 1 0 .01 6.01A3 3 0 0 0 16 12zm0 2a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm-2.65 5.3-4.18 6.8.97.5c1.82.93 3.8 1.4 5.86 1.4 2.07 0 4.04-.47 5.86-1.4l.97-.5-4.18-6.8-.79.34a5 5 0 0 1-3.72 0l-.8-.33zm.84 2.46c1.15.32 2.47.32 3.63 0l2.14 3.5c-2.5.98-5.41.98-7.92 0l2.15-3.5z',
        'rainbow-solid' => 'M16 5C8.28 5 2 11.28 2 19v8h2v-8a12.01 12.01 0 0 1 24 0v8h2v-8c0-7.72-6.28-14-14-14zm0 4C10.49 9 6 13.49 6 19v8h2v-8a8 8 0 0 1 16 0v8h2v-8c0-5.51-4.49-10-10-10zm0 4a6 6 0 0 0-6 6v8h2v-8a4 4 0 0 1 8 0v8h2v-8a6 6 0 0 0-6-6z',
        'random-solid' => 'M23 3v4h-4.6l-.27.5-3.63 6.47L10.6 7H4v2h5.4l3.94 7-3.93 7H4v2h6.6l9-16H23v4l5-5Zm-6.22 15-1.16 2.06L18.41 25H23v4l5-5-5-5v4h-3.4Z',
        'raspberry-pi' => 'm24.4 14.8-.2-.3c0-2.4-1.1-3.3-2.3-4 .4-.1.8-.2.9-.7.7-.2.8-.5.9-.8.2-.1.7-.4.7-1 .3-.2.5-.5.4-.9.3-.4.4-.7.3-1 .4-.5.2-.8.1-1.1.3-.6 0-1.2-.8-1.1-.3-.5-1.1-.4-1.2-.4-.1-.2-.3-.3-.8-.2-.5-.3-.9-.3-1.3-.1-.5-.4-.8-.1-1.1 0-.6-.2-.7.1-1 .2-.6-.1-.8.2-1.1.5h-.3c-.9.5-1.4 1.7-1.6 2.2-.2-.6-.6-1.7-1.6-2.2h-.3c-.3-.3-.5-.6-1.1-.5-.3-.1-.4-.4-1-.2-.2-.1-.4-.2-.7-.2-.1 0-.2.1-.4.2-.4-.2-.8-.2-1.1.1-.5-.1-.7.1-.8.2-.1 0-.9-.1-1.2.4-.9-.1-1.2.5-.9 1.1-.2.3-.3.5.1 1.1-.2.2-.1.6.3.9-.1.4 0 .7.4 1-.1.5.5.8.6 1 .1.3.2.6.9.8.1.5.5.6.9.7-1.3.7-2.3 1.7-2.3 4l-.2.3c-1.4.9-2.7 3.7-.7 6 .1.7.3 1.2.5 1.8.3 2.3 2.2 3.4 2.7 3.5.7.6 1.5 1.1 2.6 1.5 1 1 2.1 1.4 3.2 1.4s2.2-.4 3.2-1.4c1.1-.4 1.9-.9 2.6-1.5.5-.1 2.4-1.2 2.7-3.5.2-.6.4-1.1.6-1.8 2.2-2.3.9-5.1-.6-6Zm-1.3-.4c-.1 1-4.9-3.3-4.1-3.4 2.3-.4 4.2.9 4.1 3.4Zm-5.3-9.9c0 .2.1.3.1.4.3-.3.5-.6.8-.9 0 .2-.1.3.1.5.2-.3.4-.5.8-.7-.2.3 0 .4.1.5.3-.2.5-.4 1-.6-.1.2-.3.3-.1.5.3-.2.5-.3 1.2-.5-.1.2-.4.3-.3.5.3-.1.7-.2 1.1-.3-.2.2-.4.3-.2.4.4-.1.8-.3 1.3-.1l-.3.3h1.2c-.2.3-.4.5-.5.9h.5c-.2.6-.6.7-.7.9.1.1.3.1.6 0-.2.4-.5.6-.8.9.1.1.2.1.5 0-.3.3-.6.5-.9.8.1.1.3.1.5.1-.3.3-.8.5-1.2.7.1.2.3.1.4.1-.3.2-.8.4-1.2.5.1.1.2.2.4.2-.5.3-1.2.1-1.4.3 0 .1.2.2.3.3-.8 0-2.9 0-3.3-1.6.8-.9 2.2-1.9 4.7-3.2-1.9.7-3.7 1.5-5.1 2.7-1.6-.8-.5-2.8.4-3.6ZM16 10.3c1.2 0 2.7.9 2.7 1.8 0 .8-1.1 1.4-2.7 1.4s-2.7-.8-2.7-1.5 1.3-1.7 2.7-1.7Zm-6.1-.6c.2 0 .3-.1.4-.2-.5-.2-1-.3-1.3-.6.2 0 .3 0 .5-.1-.4-.2-.8-.4-1.2-.7.2 0 .4 0 .5-.1-.3-.2-.6-.5-.9-.7h.5c-.3-.4-.6-.6-.8-1 .2.1.4.1.6 0-.1-.2-.6-.3-.8-.8h.5c-.1-.4-.3-.7-.4-.9h1.2l-.3-.4c.5-.1 1 0 1.3.1.2-.1 0-.3-.2-.4.4.1.8.2 1.1.3.2-.2-.1-.3-.3-.5.7.1.9.3 1.2.5.2-.2 0-.3-.1-.5.5.2.7.4 1 .6.1-.1.2-.2.1-.5.2.2.5.4.7.7.2-.1.1-.3.1-.5.3.3.6.6.8.9.1 0 .1-.2.1-.4.8.8 2 2.8.3 3.6-1.4-1.2-3.2-2.1-5.1-2.7 2.5 1.3 3.9 2.3 4.7 3.2-.4 1.6-2.5 1.7-3.3 1.6.2-.1.3-.2.3-.3-.1-.1-.7 0-1.2-.2Zm2.8 1.2c.8.1-4 4.4-4.1 3.4-.1-2.4 1.8-3.8 4.1-3.4Zm-5.1 9.5c-1.2-1-1.6-3.7.6-5 1.3-.4.5 5.4-.6 5Zm4.6 5c-.7.4-2.3.2-3.4-1.4-.8-1.4-.7-2.8-.1-3.2.8-.5 2.1.2 3 1.3.8.9 1.2 2.7.5 3.3Zm-1.3-6.1c-1.2-.8-1.4-2.6-.5-4.1 1-1.4 2.7-2 3.9-1.2 1.2.8 1.4 2.6.5 4.1-.9 1.5-2.7 2-3.9 1.2Zm5.1 8.9c-1.5.1-2.9-1.2-2.9-1.6 0-.6 1.8-1.1 3-1.1 1.2-.1 2.8.4 2.8 1 0 .4-1.5 1.7-2.9 1.7Zm3-6.4c0 1.5-1.3 2.7-2.9 2.7-1.6 0-3-1.2-3-2.7 0-1.5 1.3-2.7 2.9-2.7 1.7 0 3 1.2 3 2.7ZM17.2 18c-1-1.4-.7-3.3.5-4.1 1.2-.8 3-.3 3.9 1.2.9 1.5.7 3.3-.5 4.1-1.2.7-3 .2-3.9-1.2Zm6 6c-1.3 1.8-3 1.8-3.6 1.3-.7-.6-.2-2.6.8-3.7 1-1.2 2.2-2 2.9-1.4.5.7.8 2.6-.1 3.8Zm.9-3.7c-1.1.5-2-5.3-.6-5 2.2 1.2 1.8 4 .6 5Z',
        'ravelry' => 'M17.12 4.01c-2.04.1-4.06.7-6.1 1.64A2 2 0 0 0 9.94 6.7a12 12 0 0 0-1.09 2.87 11.16 11.16 0 0 0-2.36 4.9 8.8 8.8 0 0 0-1.25 3.88s-.04.42-.03.43c-1.92-.25-4.15-1.16-4.15-1.16.5.79 3.34 1.45 4.15 1.76 0 0 .1 5.33 3.52 7.14L8 25.41s-1.78-3.26-1.47-5.67l.12.01a11.16 11.16 0 0 0 11.7 8.21 4.42 4.42 0 0 0 3.29-.8c3.82-2.13 5.5-4.46 6.7-8.04.3-.87.44-1.93.53-2.84.48-4.49-1.66-8.8-5.62-10.87A11.89 11.89 0 0 0 17.12 4zm.27 2.17c5.8 0 10.5 4.74 10.5 10.6a10.66 10.66 0 0 1-5.8 9.47c-.8.25-1.98.45-3.53.2 0 0-4.96-1.26-6.94-5.87a22.5 22.5 0 0 0 4.24-.21 22.5 22.5 0 0 0 6.27-1.8c.64-.3.6-1.06.52-1.62-.11-.7-.6-.66-1.17-.26 0 0-4.46 3.19-10.33 2.92-1.02-1.74-1.46-6.03-1.46-6.03 2.25-1.92 4.53-3.25 9.17-2.85 0-.35.16-1.48-1.11-1.53 0 0-5.1-.6-7.95 1.82.13-.9.32-1.6.6-2.15a10.4 10.4 0 0 1 6.99-2.7zm-8.77 4.77s-.06.67-.04 1.07c-.18.14-.55.44-.99.91.28-.7.62-1.37 1.03-1.98zm-.08 3.64s.1 2.6.86 4.9l-2.25-.37c-.12-.5-.19-1-.23-1.53a6.5 6.5 0 0 1 1.62-3zm-1.19 5.33c.8.17 1.85.41 2.35.5 1.48 4.18 5.9 6.76 5.9 6.76l.14.06a10.55 10.55 0 0 1-8.39-7.32z',
        'react' => 'M11.4 3.36a4.2 4.2 0 0 0-2.4.52 4.5 4.5 0 0 0-1.96 2.61 9.63 9.63 0 0 0-.3 3.76c0 .14.03.29.05.43l-.4.17a9.63 9.63 0 0 0-3.1 2.14A4.5 4.5 0 0 0 2 16c0 1.12.5 2.16 1.29 3.01a9.63 9.63 0 0 0 3.1 2.14l.4.17-.06.43a9.63 9.63 0 0 0 .3 3.76A4.5 4.5 0 0 0 9 28.12a4.5 4.5 0 0 0 3.25.4 9.64 9.64 0 0 0 3.4-1.62l.35-.26.35.26a9.64 9.64 0 0 0 3.4 1.62 4.5 4.5 0 0 0 3.25-.4 4.5 4.5 0 0 0 1.96-2.61c.35-1.1.43-2.38.3-3.76 0-.14-.03-.29-.05-.43l.4-.17a9.63 9.63 0 0 0 3.1-2.14A4.5 4.5 0 0 0 30 16a4.5 4.5 0 0 0-1.29-3.01 9.63 9.63 0 0 0-3.1-2.14l-.4-.17.06-.43a9.63 9.63 0 0 0-.3-3.76A4.5 4.5 0 0 0 23 3.87a4.5 4.5 0 0 0-3.25-.39 9.64 9.64 0 0 0-3.4 1.62l-.35.26-.35-.26a9.64 9.64 0 0 0-3.4-1.62 6 6 0 0 0-.85-.12zm-.13 2c.17 0 .36.03.55.08.75.16 1.66.59 2.61 1.25-.8.76-1.57 1.61-2.32 2.57-1.2.17-2.34.42-3.39.73a7.76 7.76 0 0 1 .22-2.9c.24-.75.6-1.21 1.06-1.48.35-.2.76-.3 1.27-.26zm9.46 0c.5-.05.92.05 1.27.25.46.27.82.73 1.06 1.49.23.73.32 1.73.22 2.89a23.07 23.07 0 0 0-3.39-.73 23.06 23.06 0 0 0-2.32-2.57 7.75 7.75 0 0 1 2.61-1.25c.2-.05.38-.08.55-.09zM16 7.95c.35.32.7.69 1.05 1.06a29.62 29.62 0 0 0-2.1 0c.35-.37.7-.74 1.05-1.06zM16 11c.96 0 1.9.06 2.8.15A26.46 26.46 0 0 1 21.6 16a26.46 26.46 0 0 1-2.8 4.85 26.46 26.46 0 0 1-5.6 0A26.46 26.46 0 0 1 10.4 16a26.46 26.46 0 0 1 2.8-4.85c.9-.1 1.84-.15 2.8-.15zm-5.52.6a29.65 29.65 0 0 0-1.05 1.82c-.15-.49-.29-.97-.4-1.44.46-.14.95-.27 1.45-.38zm11.04 0c.5.11.99.24 1.44.38-.1.47-.24.95-.4 1.44a29.63 29.63 0 0 0-1.04-1.82zM7.15 12.7c.26 1.07.61 2.17 1.07 3.3a23.06 23.06 0 0 0-1.07 3.3 7.75 7.75 0 0 1-2.39-1.64C4.22 17.08 4 16.54 4 16c0-.54.22-1.08.76-1.66a7.75 7.75 0 0 1 2.4-1.64zm17.7 0a7.75 7.75 0 0 1 2.39 1.64c.54.58.76 1.12.76 1.66 0 .54-.22 1.08-.76 1.66a7.75 7.75 0 0 1-2.4 1.64c-.25-1.07-.6-2.17-1.06-3.3.46-1.13.81-2.23 1.07-3.3zM16 13c-1.65 0-3 1.35-3 3s1.35 3 3 3 3-1.35 3-3-1.35-3-3-3zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1zm-6.57 3.58a29.63 29.63 0 0 0 1.05 1.82c-.5-.11-.99-.24-1.44-.38.1-.47.24-.95.4-1.44zm13.14 0c.15.49.29.97.4 1.44-.46.14-.95.27-1.45.38a29.65 29.65 0 0 0 1.05-1.82zM8.72 22c1.05.31 2.19.56 3.39.73.75.96 1.53 1.81 2.32 2.57a7.75 7.75 0 0 1-2.61 1.25c-.78.18-1.36.1-1.82-.17-.46-.27-.82-.73-1.06-1.49A7.76 7.76 0 0 1 8.72 22zm14.56 0a7.8 7.8 0 0 1-.22 2.9c-.24.75-.6 1.21-1.06 1.48-.46.27-1.04.35-1.82.17a7.75 7.75 0 0 1-2.61-1.25c.8-.76 1.57-1.61 2.32-2.57 1.2-.17 2.34-.42 3.39-.73zm-8.33.97a29.62 29.62 0 0 0 2.1 0c-.35.37-.7.74-1.05 1.06-.35-.32-.7-.69-1.05-1.06z',
        'reacteurope' => 'M21.1 4.34c-1.43.04-3.19 1.08-4.98 2.82l.47.46c3.76-3.64 5.45-2.43 5.5-2.4 1.03.58 1.65 2.54.71 6.28a26.7 26.7 0 0 0-3.85-.6c-3.28-4.57-6.4-6.47-8.3-6.47-1.4 0-2 .96-2.17 1.26-.83 1.46-.6 3.84 0 6.1-3.21.92-5.5 2.47-5.48 4.33.02 2.72 4.7 4 5.56 4.23-.93 3.73-.46 6.18 1.02 7 1.28.73 3.42.28 6.3-2.5l-.47-.47c-3.76 3.64-5.45 2.44-5.5 2.4-1.02-.57-1.65-2.53-.71-6.28a27 27 0 0 0 3.85.6c3.28 4.57 6.4 6.46 8.3 6.46 1.4 0 2-.95 2.17-1.26.82-1.45.6-3.83 0-6.1 6.93-2 7.11-5.93 1.54-8.03a16.8 16.8 0 0 0-1.62-.52c.89-3.55.52-6.13-1.02-7a2.5 2.5 0 0 0-1.31-.31zm-10.45.75c1.67 0 4.5 1.8 7.44 5.75a32.5 32.5 0 0 0-4.28.04c.59-.83 1.23-1.63 1.92-2.39l-.46-.46c-.84.92-1.61 1.9-2.31 2.92-1.3.13-2.59.35-3.85.67-.01-.07-1.1-3.75-.06-5.6.14-.24.55-.93 1.6-.93zm5.3 6.27c.86 0 1.72.02 2.57.08 1.43 2.03 1.31 2.19 1.93 2.94a.97.97 0 0 1 .48-.34c-.3-.52-.8-1.41-1.56-2.53 1.84.19 2.96.46 3.28.53-.18.66-.4 1.33-.66 2.02.12.04.22.1.31.2.1-.14.24-.23.41-.26.22-.6.42-1.2.58-1.8.54.14 1.06.31 1.58.5 4.83 1.82 3.37 4 3.3 4.12-.9 1.6-3.65 2.52-4.81 2.85-.17-.54-.35-1.1-.57-1.66a.6.6 0 0 1-.49-.26.89.89 0 0 1-.25.17c.26.65.49 1.3.67 1.93-1.07.27-2.17.47-3.28.59.16-.24.79-1.2 1.47-2.47-.1-.04-.19-.09-.27-.15-.05.06-.17.2-.5.2-.28.5-.8 1.4-1.54 2.5-1.7.16-3.42.17-5.13.05-.36-.5-.98-1.41-1.67-2.63l-.14-.07c-.09.07-.18.15-.57.15.28.5.8 1.4 1.54 2.49-1.11-.1-2.21-.29-3.3-.54.18-.64.4-1.29.65-1.95-.15 0-.25 0-.38-.05a.8.8 0 0 1-.32.05c-.22.6-.41 1.2-.58 1.8-7.28-1.95-6.39-5.64-.07-7.48.17.54.36 1.1.57 1.66.47 0 .59.15.66.24a.52.52 0 0 1 .1-.1 26.4 26.4 0 0 1-.7-1.97c.33-.09 1.48-.39 3.29-.6-.73 1.11-1.22 2-1.5 2.52.14.08.25.21.3.37a1 1 0 0 1 .46-.38 34 34 0 0 1 1.59-2.6c.85-.07 1.7-.11 2.56-.12zm.05 1.42-.1.3-.33.01.26.2-.1.3.27-.18.26.19-.1-.31.27-.2h-.33l-.1-.31zm-1.46.38-.1.31h-.33l.26.2-.09.31.27-.18.26.18-.1-.3.26-.2h-.32l-.1-.32zm2.9 0-.1.31H17l.26.2-.09.31.27-.18.26.18-.1-.3.27-.2h-.33l-.1-.32zm3.97 1.28c-.46 0-.7.22-.7.65v1.82c0 .43.24.64.7.64h.04c.46 0 .7-.21.7-.64V15.1c0-.43-.24-.64-.7-.64h-.04zm-8.99 0c-.46 0-.76.2-.76.65v1.82c0 .48.3.64.76.64h.01c.46 0 .77-.17.77-.64 0-.45.05-.62-.18-.62h-.15c-.22 0-.17.18-.17.55 0 .21-.1.28-.27.28-.16 0-.26-.07-.26-.28v-1.67c0-.21.1-.28.26-.28s.27.07.27.28c0 .33-.04.48.17.48h.15c.22 0 .18-.18.18-.56 0-.45-.3-.64-.77-.64zm4.52.04a.08.08 0 0 0-.09.07v2.36c0 .44.23.64.69.64h.02c.46 0 .68-.2.68-.64v-2.35a.09.09 0 0 0-.09-.08h-.06a.08.08 0 0 0-.09.07v2.28c0 .36-.11.51-.46.51-.34 0-.46-.14-.46-.5v-2.28a.08.08 0 0 0-.08-.08h-.06zm-6.56 0c-.1 0-.18.06-.18.15l-.5 2.7c-.03.13.04.19.15.19h.14c.09 0 .17-.06.18-.15v-.01l.09-.52h.55l.08.52c.01.1.09.17.18.16h.17c.12 0 .18-.07.15-.19l-.5-2.7a.17.17 0 0 0-.2-.15h-.31zm3.18 0c-.12 0-.18.06-.18.17v.1c0 .11.06.17.18.17h.33v2.43c0 .11.06.17.17.17h.16c.11 0 .17-.06.17-.17v-2.43h.34c.12 0 .18-.06.18-.17v-.1c0-.11-.06-.17-.18-.17h-1.17zm1.75 0a.08.08 0 0 0-.09.07v2.89c0 .04.03.08.08.08h1.04c.04 0 .08-.02.09-.06v-.06a.08.08 0 0 0-.1-.1h-.88v-1.2h.74c.04 0 .08-.03.09-.08v-.05a.09.09 0 0 0-.08-.1h-.75V14.7h.87c.05 0 .1-.03.1-.08v-.04a.08.08 0 0 0-.08-.09h-1.02zm3.58 0a.08.08 0 0 0-.09.07v2.89c0 .04.03.08.08.09h.07c.04 0 .08-.03.09-.08v-1.24h.52l.48 1.24a.1.1 0 0 0 .1.07h.07c.06 0 .1-.05.07-.1l-.49-1.25c.28-.07.42-.28.42-.6v-.45c0-.42-.23-.64-.7-.64h-.62zm-10.54 0c-.11 0-.17.06-.17.17v2.7c0 .11.06.17.17.17h1c.11 0 .17-.06.17-.17v-.1c0-.11-.06-.17-.17-.17h-.67v-.88h.52c.1 0 .17-.06.17-.17v-.1c0-.11-.06-.17-.17-.17h-.52v-.84h.65c.12 0 .18-.05.18-.17v-.1c0-.11-.06-.17-.18-.17h-.98zm14.44 0a.08.08 0 0 0-.09.09v2.87c0 .04.03.08.08.09h.07a.1.1 0 0 0 .09-.07v-1.21h.48c.46 0 .7-.22.7-.64v-.48c0-.43-.24-.65-.7-.65h-.63zm1.87 0a.07.07 0 0 0-.09.06v2.9c0 .04.03.08.08.09h1.04c.04 0 .08-.03.09-.08v-.05a.08.08 0 0 0-.08-.09h-.89V16.1h.73a.1.1 0 0 0 .1-.08v-.04a.09.09 0 0 0-.09-.1h-.74V14.7h.87c.04 0 .08-.03.09-.08v-.05a.08.08 0 0 0-.08-.09h-1.03zm-18.27 0c-.11 0-.17.07-.17.18v2.7c0 .1.06.17.17.17h.15c.12 0 .18-.06.18-.18v-1.04h.25l.34 1.07c.02.1.1.15.2.15h.15c.12 0 .18-.09.14-.2l-.37-1.1c.21-.08.34-.27.34-.56v-.54c0-.46-.3-.64-.77-.64h-.6zm15.05.18c.34 0 .47.14.47.5v1.67c0 .37-.13.5-.47.5-.35 0-.48-.13-.48-.5v-1.67c0-.36.13-.5.48-.5zm-2.4.03h.46c.35 0 .48.14.48.5v.3c0 .36-.14.5-.48.5h-.46v-1.3zm3.9 0h.46c.35 0 .48.15.48.51v.32c0 .36-.13.5-.48.5h-.46V14.7zm-16.22.23h.26c.17 0 .28.06.28.28v.4c0 .22-.11.28-.28.28h-.26v-.96zm3.82.15.21 1.36h-.43l.22-1.36zm4.04 3-.1.3h-.33l.26.2-.1.31.27-.18.27.18-.1-.3.26-.2h-.32l-.1-.32zm2.84 0-.1.3h-.33l.26.2-.1.31.27-.18.26.18-.1-.3.26-.2h-.32l-.1-.32zM16 18.4l-.1.3-.33.01.26.2-.1.31.27-.19.26.19-.1-.31.27-.2h-.32L16 18.4zm6.9 1.98c1.02 3.85.2 5.33.04 5.6-.13.24-.53.93-1.59.93-1.67 0-4.5-1.8-7.44-5.75 1.43.09 2.86.07 4.28-.04-.59.84-1.23 1.63-1.92 2.39l.46.46a26.8 26.8 0 0 0 2.31-2.92c2.16-.22 3.66-.62 3.85-.67z',
        'readme' => 'M5 6a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3l6.18-.02a5 5 0 0 1 2.78.86L16 26.2l2.04-1.36a4.99 4.99 0 0 1 2.78-.84H27a3 3 0 0 0 3-3V9a3 3 0 0 0-3-3h-6.18c-1.39 0-2.73.4-3.89 1.18L16 7.8l-.93-.62A6.98 6.98 0 0 0 11.18 6H5zm0 2h6.18c1 0 1.95.3 2.78.84L16 10.2l2.04-1.36A4.99 4.99 0 0 1 20.82 8H27a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1h-6.18c-1.39 0-2.73.4-3.89 1.18l-.93.62-.93-.62A6.98 6.98 0 0 0 11.18 22H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1zm1 4v2h8v-2H6zm12 0v2h8v-2h-8zM6 16v2h8v-2H6zm12 0v2h8v-2h-8z',
        'rebel' => 'M16 4C8.75 4 4 10.04 4 15.97 4 22.61 9.38 28 16 28s12-5.4 12-12.03C28 10.04 23.25 4 16 4Zm0 22a10.03 10.03 0 0 1-2.16-19.82 8.55 8.55 0 0 0-4.5 6.3c-.36 2.34.63 4.84 2.52 5.16l.42.03c1.65 0 2.52-1.72 2.64-2.7a4.63 4.63 0 0 0-1.02-3.29 8.46 8.46 0 0 0-1.64-1.64L13.4 8.8c.53.34.95.93 1.15 1.37 0 0 .01-.44-.08-.79a4.27 4.27 0 0 0-.52-1.18L16 5.95l2.06 2.25-.15.23c-.08.16-.25.5-.37.95-.1.35-.08.8-.08.8.2-.45.62-1.04 1.15-1.38l1.13 1.24a8.46 8.46 0 0 0-1.64 1.64 4.62 4.62 0 0 0-1.02 3.29c.12.98.99 2.7 2.64 2.7a2 2 0 0 0 .42-.04c1.9-.31 2.88-2.81 2.5-5.14a8.53 8.53 0 0 0-4.48-6.31A10.02 10.02 0 0 1 16 26Zm-3.68-13.09c.44.56.69 1.28.62 1.8-.04.32-.37.96-.66.96l-.1-.01c-.5-.08-1.09-1.4-.86-2.86.05-.28.1-.54.18-.8.33.3.6.63.82.91ZM20.5 12c.07.26.13.52.18.8.23 1.46-.36 2.78-.87 2.86a.38.38 0 0 1-.09.01c-.29 0-.62-.64-.66-.96-.07-.52.18-1.24.62-1.8.22-.29.49-.6.82-.91Z',
        'receipt-solid' => 'M7 5.38V13H3v14h26V13h-4V5.37l-3 1.5-2-1-2 1-2-1-2 1-2-1-2 1Zm5 2.75 2 1 2-1 2 1 2-1 2 1 1-.5V17H9V8.62l1 .5ZM5 15h2v4h18v-4h2v10H5Zm4 6v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Zm4 0v2h2v-2Z',
        'record-vinyl-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm5.53 3.06-1.9 1.88 1.43 1.44 1.88-1.91ZM16 11c-2.75 0-5 2.25-5 5s2.25 5 5 5 5-2.25 5-5-2.25-5-5-5Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Zm0 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-5.06 4.63-1.88 1.9 1.4 1.4 1.91-1.87Z',
        'recycle-solid' => 'M16 3.97c-1.05 0-2.12.51-2.75 1.5l-2.81 4.62 1.72 1.04 2.8-4.6c.55-.8 1.57-.82 2.1 0l3.13 5-1.5.88L23.3 15V9.69l-1.43.84-3.13-5.06A3.27 3.27 0 0 0 16 3.97Zm-5.6 8.12-4.5 2.6 1.26.75-2.57 4.22-.03-.04c0 .02.01.05 0 .07C3.1 21.92 4.8 25 7.5 25H13v-2H7.5c-1.27 0-1.95-1.25-1.28-2.22l.03-.03v-.03l2.63-4.25 1.53.94Zm14.66 3.57-1.72 1.06 2.5 4c.64 1.09-.08 2.28-1.25 2.28H19v-2l-4.9 3 4.9 3v-2h5.6c2.63 0 4.32-3 2.96-5.31v-.03Z',
        'red-river' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm5 4a1 1 0 0 0-1 1v6a2 2 0 0 0 2-2v-2a1 1 0 0 1 1-1h2a2 2 0 0 0 2-2h-6zm4 4a1 1 0 0 0-1 1v6a2 2 0 0 0 2-2v-2a1 1 0 0 1 1-1h2a2 2 0 0 0 2-2h-6z',
        'reddit-alien' => 'M18.66 4C16.56 4 15 5.7 15 7.66v3.37c-2.76.15-5.26.88-7.28 2.03A4 4 0 0 0 4.9 12a3.9 3.9 0 0 0-2.97 1.22v.03l-.03.03a4.3 4.3 0 0 0-.85 3.38 4.44 4.44 0 0 0 1.97 3c0 .11-.03.22-.03.34 0 2.6 1.57 4.89 3.94 6.47A16.4 16.4 0 0 0 16 29c3.51 0 6.7-.95 9.06-2.53C27.43 24.89 29 22.6 29 20c0-.12-.02-.23-.03-.34a4.44 4.44 0 0 0 1.97-3 4.3 4.3 0 0 0-.85-3.38l-.03-.03A3.93 3.93 0 0 0 27.1 12a4 4 0 0 0-2.8 1.06 16.44 16.44 0 0 0-7.3-2.03V7.66c0-.98.56-1.66 1.66-1.66.52 0 1.16.25 2.15.6.85.3 1.94.62 3.35.71A2.5 2.5 0 0 0 29 6.5a2.5 2.5 0 0 0-4.69-1.19 9.83 9.83 0 0 1-2.84-.6c-.9-.3-1.74-.71-2.81-.71ZM16 13c3.15 0 5.96.87 7.94 2.19C25.9 16.5 27 18.2 27 20c0 1.8-1.09 3.5-3.06 4.81A14.47 14.47 0 0 1 16 27a14.5 14.5 0 0 1-7.94-2.19C6.1 23.5 5 21.8 5 20c0-1.8 1.09-3.5 3.06-4.81A14.47 14.47 0 0 1 16 13ZM4.9 14c.39 0 .76.1 1.07.25a8.6 8.6 0 0 0-2.44 3.19 2.42 2.42 0 0 1-.06-2.88v-.03A2 2 0 0 1 4.91 14Zm22.2 0a2 2 0 0 1 1.43.53v.03a2.42 2.42 0 0 1-.06 2.88 8.6 8.6 0 0 0-2.44-3.19c.31-.16.68-.25 1.06-.25ZM11 16a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm.25 5.53c-1.15 1.07-3.08 1.75-5.25 1.75s-4.1-.69-5.25-1.62C11.39 23.39 13.45 25 16 25s4.6-1.6 5.25-3.47Z',
        'reddit-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm10.06 2a.35.35 0 0 0-.4.26l-.86 3.75c-1.67.04-3.17.6-4.22 1.45a1.5 1.5 0 1 0-1.53 2.46c-.03.2-.05.38-.05.58 0 2.48 2.69 4.5 6 4.5s6-2.02 6-4.5c0-.2-.02-.39-.05-.57a1.5 1.5 0 1 0-1.53-2.47 6.87 6.87 0 0 0-3.9-1.44l.75-3.28 2.77.46c.1.45.48.8.96.8a1 1 0 0 0 0-2c-.37 0-.68.2-.85.5l-3.1-.5zm-3.97 6.82a1.09 1.09 0 1 1 0 2.18 1.09 1.09 0 0 1 0-2.18zm5.82 0a1.1 1.1 0 1 1 0 2.18 1.1 1.1 0 0 1 0-2.18zm-5.44 3.2c.1 0 .18.02.26.09 1.15.98 3.39.98 4.54 0a.35.35 0 0 1 .46.53c-.7.6-1.7.94-2.73.94a4.23 4.23 0 0 1-2.73-.94.35.35 0 0 1 .2-.62z',
        'reddit' => 'M18.66 4C16.56 4 15 5.7 15 7.66v3.37c-2.76.15-5.26.88-7.28 2.03A4 4 0 0 0 4.9 12a3.9 3.9 0 0 0-2.97 1.22v.03l-.03.03a4.3 4.3 0 0 0-.85 3.38 4.44 4.44 0 0 0 1.97 3c0 .11-.03.22-.03.34 0 2.6 1.57 4.89 3.94 6.47A16.4 16.4 0 0 0 16 29c3.51 0 6.7-.95 9.06-2.53C27.43 24.89 29 22.6 29 20c0-.12-.02-.23-.03-.34a4.44 4.44 0 0 0 1.97-3 4.3 4.3 0 0 0-.85-3.38l-.03-.03A3.93 3.93 0 0 0 27.1 12a4 4 0 0 0-2.8 1.06 16.44 16.44 0 0 0-7.3-2.03V7.66c0-.98.56-1.66 1.66-1.66.52 0 1.16.25 2.15.6.85.3 1.94.62 3.35.71A2.5 2.5 0 0 0 29 6.5a2.5 2.5 0 0 0-4.69-1.19 9.83 9.83 0 0 1-2.84-.6c-.9-.3-1.74-.71-2.81-.71ZM16 13c3.15 0 5.96.87 7.94 2.19C25.9 16.5 27 18.2 27 20c0 1.8-1.09 3.5-3.06 4.81A14.47 14.47 0 0 1 16 27a14.5 14.5 0 0 1-7.94-2.19C6.1 23.5 5 21.8 5 20c0-1.8 1.09-3.5 3.06-4.81A14.47 14.47 0 0 1 16 13ZM4.9 14c.39 0 .76.1 1.07.25a8.6 8.6 0 0 0-2.44 3.19 2.42 2.42 0 0 1-.06-2.88v-.03A2 2 0 0 1 4.91 14Zm22.2 0a2 2 0 0 1 1.43.53v.03a2.42 2.42 0 0 1-.06 2.88 8.6 8.6 0 0 0-2.44-3.19c.31-.16.68-.25 1.06-.25ZM11 16a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm.25 5.53c-1.15 1.07-3.08 1.75-5.25 1.75s-4.1-.69-5.25-1.62C11.39 23.39 13.45 25 16 25s4.6-1.6 5.25-3.47Z',
        'redhat' => 'M16.39 6c-.78 0-1 1.08-1.94 1.08-.9 0-1.56-.8-2.4-.8-.81 0-1.34.58-1.74 1.8-1.38 4.17-1.32 3.99-1.3 4.2C9 13.63 13.87 18 20.4 18c1.68 0 4.11-.38 4.11-2.53.02-.36.05-.1-1.04-5.17-.23-1.03-.43-1.5-2.1-2.4-1.31-.71-4.16-1.9-5-1.9zm-8.12 7.04c-2.3.1-5.27.53-5.27 3.2C3 20.61 13.19 26 21.26 26c6.18 0 7.74-2.84 7.74-5.09 0-1.77-1.5-3.77-4.21-4.97.23 1.24.21 1.62.21 1.78 0 2.1-2.16 3.28-5 3.28-6.39.01-12-4.13-12-6.85 0-.38.13-.76.27-1.11z',
        'redo-alt-solid' => 'M16 3a13.01 13.01 0 0 0 0 26c7.17 0 13-5.83 13-13h-2c0 6.09-4.91 11-11 11S5 22.09 5 16a10.99 10.99 0 0 1 20.22-6H20v2h8V4h-2v3.72A12.97 12.97 0 0 0 16 3Z',
        'redo-solid' => 'm19.22 5.28-1.44 1.44L24.06 13H11c-3.84 0-7 3.16-7 7v7h2v-7c0-2.75 2.25-5 5-5h13.06l-6.28 6.28 1.44 1.44 8-8 .69-.72-.7-.72Z',
        'registered-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-4 5v12h2v-4h3.4l1.6 4h2l-1.69-4.25c1.57-.54 2.69-2 2.69-3.75a4 4 0 0 0-4-4Zm2 2h4c1.2 0 2 .8 2 2s-.8 2-2 2h-4Z',
        'registered' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-4 5v12h2v-4h3.4l1.6 4h2l-1.69-4.25c1.57-.54 2.69-2 2.69-3.75a4 4 0 0 0-4-4Zm2 2h4c1.2 0 2 .8 2 2s-.8 2-2 2h-4Z',
        'remove-format-solid' => 'm4.29 5.97-1.2 1.6 24.69 18.6 1.2-1.59-10.95-8.25L20.29 10H25v1.5c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 0-.5-.5h-16a.5.5 0 0 0-.5.5v2.78l-5.71-4.3zM12 10h5.29l-1.63 4.54-3.73-2.8a.49.49 0 0 0 .07-.24V10zm2.25 8.49L13 22h-1.5a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h5a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5H16l.62-1.73-2.37-1.78z',
        'renren' => 'M7.56 7A9.08 9.08 0 0 0 0 15.94a9 9 0 0 0 2.16 5.84 9.98 9.98 0 0 0 5.4-9.03Zm3 0v5.69c0 4.06 2.23 7.55 5.4 9.1a9.02 9.02 0 0 1 0-11.7A9.06 9.06 0 0 0 10.57 7Zm5.4 3.1a9.07 9.07 0 0 1 2.23 5.84 9.1 9.1 0 0 1-2.22 5.84c3.17-1.53 5.45-5 5.47-9.03V7a9.23 9.23 0 0 0-5.47 3.1ZM24.45 7v5.69c0 4.06 2.22 7.55 5.4 9.1A9.02 9.02 0 0 0 32 15.93 9.08 9.08 0 0 0 24.44 7ZM9.06 18.22c-.56 2.33-2.24 4.33-4.34 5.66a9.02 9.02 0 0 0 8.69 0c-2.1-1.33-3.79-3.33-4.35-5.66Zm13.88 0a9.62 9.62 0 0 1-4.35 5.66 9.02 9.02 0 0 0 8.7 0c-2.1-1.33-3.79-3.33-4.35-5.66Z',
        'reply-all-solid' => 'm10.28 5.28-8 8-.69.72.7.72 8 8 1.43-1.44L4.44 14l7.28-7.28Zm5 0-8 8-.69.72.7.72 8 8 1.43-1.44L10.44 15H23a4.99 4.99 0 1 1 0 10v2a7 7 0 0 0 0-14H10.44l6.28-6.28Z',
        'reply-solid' => 'm12.28 5.28-8 8-.69.72.7.72 8 8 1.43-1.44L7.44 15H21a4.99 4.99 0 1 1 0 10v2a7 7 0 0 0 0-14H7.44l6.28-6.28Z',
        'replyd' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm10.73 10.01c-.87 0-1.54.25-2 .75-.5.49-.73 1.24-.73 2.24 0 .94.21 1.67.64 2.2.42.53 1.09.8 2.01.8a3.88 3.88 0 0 0 2.17-.65l-.49-.96a2.4 2.4 0 0 1-1.4.43c-.5 0-.86-.12-1.08-.36-.23-.24-.35-.6-.37-1.08h3.41l.08-.57.03-.5c0-.45-.07-.81-.19-1.11a1.87 1.87 0 0 0-1.24-1.08 3.34 3.34 0 0 0-.84-.11zm-4.07.03c-.3 0-.56.07-.78.23-.22.15-.4.36-.52.64h-.04l-.18-.75H11v5.68h1.48v-3.67c.06-.22.18-.4.35-.54.18-.13.4-.2.66-.2.19 0 .4.04.64.12l.2-1.39a2.27 2.27 0 0 0-.67-.12zm8.41.08a.95.95 0 0 0-.66.23.82.82 0 0 0-.25.63c0 .27.08.48.25.64a.9.9 0 0 0 .66.24c.28 0 .51-.08.68-.24a.83.83 0 0 0 .25-.64.82.82 0 0 0-.25-.63.98.98 0 0 0-.68-.23zm-4.37 1.07c.34 0 .58.11.73.33.16.22.22.53.19.94H16.5c.04-.38.15-.7.33-.92.19-.23.47-.35.86-.35zm4.37 3.04a.9.9 0 0 0-.66.23c-.17.15-.25.36-.25.63s.08.48.25.64a.9.9 0 0 0 .66.23c.28 0 .51-.07.68-.23a.85.85 0 0 0 .25-.64c0-.27-.08-.48-.25-.63a.94.94 0 0 0-.68-.23z',
        'republican-solid' => 'M10 7a6 6 0 0 0-6 6v3h22v-3a6 6 0 0 0-6-6H10zm5.01 3.15c.1 0 .18.04.23.12l.48 1 1.1.17c.2.03.29.27.13.4l-.8.78.19 1.1c.03.2-.16.34-.34.25l-.99-.51-.99.51a.23.23 0 0 1-.33-.25l.18-1.1-.8-.78c-.14-.13-.06-.37.14-.4l1.1-.16.48-1a.24.24 0 0 1 .22-.13zm-6 .01c.08 0 .17.04.21.13l.49 1 1.1.16c.2.03.25.27.11.4l-.79.78.2 1.09c.03.2-.19.34-.35.25l-.98-.5-.98.5c-.18.1-.37-.05-.35-.25l.2-1.1-.8-.77c-.15-.13-.06-.37.13-.4l1.1-.17.49-1a.24.24 0 0 1 .21-.12zm12 0c.08 0 .17.05.22.13l.49 1 1.08.16c.2.03.28.27.13.4l-.8.78.2 1.09c.02.2-.17.34-.35.25l-.98-.5-.98.5c-.16.1-.38-.05-.34-.25l.18-1.09-.78-.78c-.15-.13-.07-.37.13-.4l1.1-.16.48-1a.22.22 0 0 1 .21-.12zM4 18v6a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1v-3h8v3a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1v-4h2v1.88c0 1.45.98 2.78 2.4 3.06A3 3 0 0 0 30 22v-2.3a.7.7 0 0 0-.7-.7h-.6a.7.7 0 0 0-.7.7V22a1 1 0 0 1-2 0v-4H4z',
        'researchgate' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm12.16 3c-1.28 0-1.72.92-1.72 1.54v1.63c0 .83.45 1.62 1.62 1.62 1.96 0 1.73-1.48 1.73-2.51h-1.54v.54h.9c0 .8-.37 1.34-1.09 1.34-.56 0-.89-.49-.89-1.17v-1.36c0-.62.6-.99 1-.99.71 0 .99.63.99.63l.54-.36s-.27-.9-1.54-.9zm-5.58 3.1c-.9 0-2.28.08-3.58.03v.4c.78.15 1.1.08 1.1 1.2v5.54c0 1.14-.32 1.06-1.1 1.2v.42c.38-.01 1.03-.05 1.7-.05.63 0 1.44.03 1.8.05v-.41c-1.01-.14-1.31-.03-1.31-1.21v-2.34c.34.03.63.03 1.08.03a21.37 21.37 0 0 0 2.14 3.22 2.4 2.4 0 0 0 2.51.71v-.37c-.5 0-1-.34-1.37-.75a16.28 16.28 0 0 1-2.12-2.96 2.6 2.6 0 0 0 1.97-2.4c0-1.59-1.22-2.32-2.82-2.32zm-.26.63c1.18 0 1.89.62 1.89 1.75 0 1.1-.76 1.85-2.02 1.85-.46 0-.68-.02-1-.04v-3.52c.32-.04.75-.04 1.13-.04z',
        'resolving' => 'M16 3A13 13 0 0 0 3.36 13.03l.02-.01 11.56-3.33c1.8-.53 2.82-.6 4.13-.43 1.89.32 2.74 1.3 3.19 2.88l.56 1.97c.43 1.46.06 2.64-1.23 3.84-1 .9-1.62 1.27-3.2 1.73l-4.82 1.38 11.48 1.41.5 1.78-2.5.7L8.12 23l1.17 4.1A12.9 12.9 0 0 0 16 29a13.01 13.01 0 0 0 0-26zm2.04 8.73c-.54 0-1.27.13-2.31.43l-9.86 2.83 1.5 5.17 10.37-3c2.41-.69 2.6-1.23 2.31-2.27l-.59-2.06c-.2-.69-.53-1.09-1.42-1.1zM3 16.13a12.9 12.9 0 0 0 1.94 6.68L3 16.13z',
        'restroom-solid' => 'M9 4a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 4 15v5.63l2 1V28h6v-6.38l2-1V15c0-1.71-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 9 4Zm13 0c-2.2 0-4 1.8-4 4 0 1.15.52 2.18 1.31 2.9-.9.69-1.56 1.7-1.78 2.91v.03l-1.5 7.97-.25 1.19H19v5h6v-5h3.22l-.25-1.19-1.5-7.97v-.03a4.62 4.62 0 0 0-1.78-2.9A3.96 3.96 0 0 0 26 8c0-2.2-1.8-4-4-4ZM9 6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm13 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2ZM9 12a3 3 0 0 1 3 3v4.38l-2 1V26H8v-5.63l-2-1V15a3 3 0 0 1 3-3Zm13 0c1.23 0 2.28.82 2.5 2.16v.03h.03L25.81 21H23v5h-2v-5h-2.81l1.28-6.81h.03v-.03A2.48 2.48 0 0 1 22 12Z',
        'retweet-solid' => 'm5 7-5 5h4v13h17l-2-2H6V12h4Zm4 0 2 2h13v11h-4l5 5 5-5h-4V7Z',
        'rev' => 'M15 3v2.05A11 11 0 0 0 16 27h11V16c0-3.37-1.52-6.38-3.91-8.4l-1.87 1.09A8.99 8.99 0 0 1 16 25a9.01 9.01 0 0 1-1-17.94V10l6-3.5L15 3zm1 10a3 3 0 0 0 0 6 3 3 0 0 0 0-6z',
        'ribbon-solid' => 'M16 4c-1.1 0-3.6 0-4.5 1.5v.1c-.1.2-1.69 3.7-2.19 5-.6 1.6.1 3.51 1 4.71.7 1.1 9.39 11.89 9.69 12.28l.6.82 5-4.1-.5-.81c-1.1-1.4-3.01-3.7-4.91-6.1 1.4-1.7 1.62-1.99 1.62-2.09.9-1.2 1.6-3.11 1-4.72-.5-1.3-2.11-4.8-2.22-5V5.5c0-.1-.09-.09-.09-.19C19.3 4.01 17 4 16 4Zm0 2c1.8 0 2.49.3 2.69.5 0 .2 0 .51-.1.81v.19c0 .2-.08.39-.18.69C17.8 7.99 17.1 8 16 8s-1.8 0-2.4.1c-.1-.2-.1-.5-.2-.7v-.2c-.1-.4-.09-.58-.09-.78.2-.1.89-.41 2.69-.41Zm-4.1 3.5c.2.6.5 1.3 1 2 .8 1.2 7.7 9.7 10 12.5L21 25.6c-2.9-3.5-8.6-10.61-9.1-11.41-.6-.8-1.1-2.08-.8-2.88.1-.4.4-1.11.8-1.81Zm8.2 0c.3.7.6 1.41.8 1.81.3.8-.2 2.08-.8 2.88-.1.1-.39.52-1.29 1.62-.5-.7-1.12-1.3-1.62-1.9 1.5-1.9 1.8-2.3 1.9-2.41.4-.7.8-1.4 1-2Zm-5.7.5h3.2c-.1.1-.1.2-.2.4 0 .2-.4.61-1.4 1.91-.7-.9-1.3-1.6-1.4-1.9-.1-.1-.1-.21-.2-.41Zm-3.5 8.6c-2.1 2.6-4 4.9-4 4.9l-.59.81 5 4.1.69-.82s1.4-1.68 3.1-3.78l-1.3-1.61a87.6 87.6 0 0 0-2.81 3.4L9.1 24c.7-.8 1.79-2.21 3.09-3.81-.5-.6-.89-1.1-1.28-1.6Z',
        'ring-solid' => 'm26 7-.3-.3c-1.7-1.9-4.2-2.5-4.2-2.5-3-.9-7.7 1.1-11.9 5.2C6.1 12.7 4 16.7 4 19.7c0 .4.1.8.1 1.2.2 2 1.5 4.1 2.6 5.1 1.4 1.4 3.2 2.1 5.2 2.1 3.3 0 7.2-1.9 10.8-5.3 5.6-5.5 7-12 3.3-15.8ZM10 21.7c0-1.3 1.4-4 4.4-7 2.9-2.9 5.9-3.7 7.3-4-.7 1.9-2.2 4.2-4.4 6.4-2.1 2-4.5 3.6-6.6 4.4-.2.1-.5.1-.7.2Zm1-10.9c3.3-3.3 6.8-4.9 9-4.9.7 0 1.3.2 1.7.6.4.4.6 1.2.5 2.1-1.2.1-5.3.8-9.2 4.7-2.5 2.5-5.1 6.1-4.9 8.6-.6 0-1.2-.2-1.5-.5-.2-.2-.4-.5-.5-.9 0 0-.1-.5-.1-.8.1-2.5 2-6 5-8.9Zm10.3 10.5c-4.8 4.8-10.3 6.1-13.2 3.3-.2-.2-.4-.4-.6-.7.2.1.5.1.8.1.9 0 2-.2 3.1-.6 2.4-.9 5-2.6 7.3-4.9 3.5-3.5 5.5-7.5 5.5-10.4l.1.1.3.2c2.8 2.9 1.4 8.3-3.3 12.9Z',
        'road-solid' => 'm5.47 6-.19.75-4.66 18L.28 26h31.44l-.34-1.25-4.66-18-.19-.75Zm1.56 2h8.1l-.07 3h1.88l-.07-3h8.1l4.16 16H17.27l-.1-4H14.8l-.1 4H2.88ZM15 13l-.13 5h2.26L17 13Z',
        'robot-solid' => 'M16 1a2 2 0 0 0-1 3.72V7h-5c-2.75 0-5 2.25-5 5v2H2v8h3v5h22v-5h3v-8h-3v-2c0-2.75-2.25-5-5-5h-5V4.72A2 2 0 0 0 16 1Zm-6 8h12c1.67 0 3 1.33 3 3v13h-2v-5H9v5H7V12c0-1.67 1.33-3 3-3Zm2 4a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm8 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4ZM4 16h1v4H4Zm23 0h1v4h-1Zm-16 6h2v3h-2Zm4 0h2v3h-2Zm4 0h2v3h-2Z',
        'rocket-solid' => 'M25.9 4c-.69 0-1.66.03-2.68.13-2.05.19-4.41.53-5.88 2-1.23 1.23-3.77 4.5-6.12 7.56l-.88 1.15-1.71-.09a3.98 3.98 0 0 0-3.32 1.47l-2.1 2.56L2.2 20.1l1.62.32 3.28.65 3.85 3.85.65 3.28.35 1.62 1.28-1.03 2.56-2.1c1-.8 1.54-2.03 1.47-3.3l-.1-1.7c.59-.43.57-.42 1.2-.9 3.07-2.35 6.35-4.88 7.56-6.1 1.45-1.45 1.77-3.84 1.96-5.9.2-2.05.1-3.81.1-3.81l-.03-.9-.9-.04S26.6 4 25.9 4ZM25 6c.4 0 .68.02.97.03.01.58.03 1.19-.1 2.56-.17 1.9-.75 4-1.4 4.66-.9.9-4.28 3.59-7.34 5.94l-5.16 3.93-3.06-3.06c.4-.55 1.8-2.46 3.87-5.15 2.35-3.06 5.05-6.46 5.97-7.38.68-.68 2.77-1.26 4.66-1.44C24.09 6.03 24.6 6 25 6Zm-4.56 3.53c-1.12 0-2 .92-2 2.03a2 2 0 0 0 2 2.03c1.11 0 2.03-.91 2.03-2.03 0-1.11-.92-2.03-2.03-2.03ZM8.5 16.75l.38.03-1.72 2.25-1.35-.28 1.03-1.25a2 2 0 0 1 1.66-.75Zm-2.28 5.19a7.9 7.9 0 0 0-1.69 3.03c-.34 1-.5 1.81-.5 1.81l-.31 1.47 1.47-.28s.8-.14 1.78-.47a7.78 7.78 0 0 0 3.06-1.72l-1.4-1.4A6.4 6.4 0 0 1 6.5 25.5a7.2 7.2 0 0 1 1.13-2.16Zm9 1.18.03.38c.04.64-.22 1.25-.72 1.66l-1.28 1.03-.28-1.35c.17-.13 1.45-1.12 2.25-1.71Z',
        'rocketchat' => 'M7.55 5c-1.29 0-2.5.3-3.55.85a7.9 7.9 0 0 1 2.84 4.45C5.07 11.85 4 13.84 4 16c0 2.1 1 4.11 2.84 5.72a7.87 7.87 0 0 1-1.76 3.4l-1.07 1.23 1.58.4a8.55 8.55 0 0 0 7.84-2.02c1 .18 2.03.27 3.07.27 6.9 0 12.5-4.04 12.5-9s-5.6-9-12.5-9c-1.06 0-2.08.1-3.06.29A8.64 8.64 0 0 0 7.54 5zm8.95 4C22.29 9 27 12.14 27 16s-4.71 7-10.5 7c-1.09 0-2.16-.11-3.2-.33l-.54-.12-.39.4A6.55 6.55 0 0 1 7.64 25a9.76 9.76 0 0 0 1.28-3.52l.1-.58-.47-.36C6.9 19.26 6 17.64 6 16c0-3.86 4.71-7 10.5-7zm-5 6a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm5 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm5 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'rockrms' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-.5 3a1 1 0 0 0-.75.34L8.05 16h2.65l4.77-5.45L19.9 16H15a1 1 0 0 0-.76 1.65L18.83 23h2.63l-4.29-5H22a1 1 0 0 0 .78-1.63l-6.5-8a1 1 0 0 0-.76-.37h-.02z',
        'route-solid' => 'M6 4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2Zm4 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm2 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-11 3a3 3 0 0 0-3 3c0 1.25 1.61 4.5 2.1 5.46l.9 1.73.9-1.73c.49-.97 2.1-4.21 2.1-5.46a3 3 0 0 0-3-3Zm11 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-11 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2Zm11 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM7 18a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm6 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM5 20a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm21 1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2ZM7 25a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'rss-solid' => 'M5 5v4c9.93 0 18 8.07 18 18h4A22 22 0 0 0 5 5zm0 7v4a11 11 0 0 1 11 11h4A15 15 0 0 0 5 12zm3 9a3 3 0 0 0 0 6 3 3 0 0 0 0-6z',
        'rss-square-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm5 3c-.68 0-1.36.05-2 .19v2.06A8.01 8.01 0 0 1 19.75 22h2.06A10 10 0 0 0 12 10Zm0 4c-.7 0-1.37.12-2 .34v2.22A3.97 3.97 0 0 1 15.44 22h2.22A6 6 0 0 0 12 14Zm0 4a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'ruble-sign-solid' => 'M11 6v10H9v2h2v2H9v2h2v4h2v-4h5v-2h-5v-2h6c3.3 0 6-2.7 6-6s-2.7-6-6-6Zm2 2h6c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4h-6Z',
        'ruler-combined-solid' => 'M4 4v24h24v-9H13V4H4zm2 2h5v2H8v2h3v2H8v2h3v2H8v2h3v1.59l-5 5V6zm6.41 15H14v3h2v-3h2v3h2v-3h2v3h2v-3h2v5H7.41l5-5z',
        'ruler-horizontal-solid' => 'M0 8v16h32V8Zm2 2h3v7h2v-7h2v4h2v-4h2v7h2v-7h2v4h2v-4h2v7h2v-7h2v4h2v-4h3v12H2Z',
        'ruler-solid' => 'M20.53 3.6 3.6 20.52l7.88 7.88L28.4 11.47Zm0 2.84 5.03 5.03-14.1 14.1-5.02-5.04 1.15-1.16 2.16 2.16 1.44-1.4L9 17.93l1.19-1.15.87.88 1.4-1.44-.87-.84 1.2-1.2 2.15 2.16 1.4-1.4-2.15-2.16 1.19-1.19.84.88 1.44-1.4-.88-.88L17.94 9l2.18 2.19 1.41-1.44-2.16-2.16Z',
        'ruler-vertical-solid' => 'M8 0v32h16V0H8zm2 2h12v3h-7v2h7v2h-4v2h4v2h-7v2h7v2h-4v2h4v2h-7v2h7v2h-4v2h4v3H10V2z',
        'running-solid' => 'M20.22 5a3.08 3.08 0 0 0-3.06 3.06 3.08 3.08 0 0 0 6.15 0A3.1 3.1 0 0 0 20.21 5Zm0 2c.6 0 1.1.46 1.1 1.06 0 .6-.5 1.06-1.1 1.06-.6 0-1.06-.46-1.06-1.06 0-.6.46-1.06 1.06-1.06Zm-7.28 2c-.48.06-.97.28-1.31.66L8.25 13.3l1.5 1.38 3.34-3.66c.04-.03.09-.06.13-.03l1.6 1.06-2.35 3.25a2.6 2.6 0 0 0 .28 3.35l3.53 3.53-2.9 5.81h2.24l2.47-4.9a2 2 0 0 0-.37-2.32l-3.53-3.53a.62.62 0 0 1-.06-.78l2.34-3.28.81.53 1.6 2.4c.37.56.98.88 1.65.88H25v-2h-4.47l-1.69-2.56-.12-.16-.16-.12-4.22-2.82c-.42-.28-.92-.4-1.4-.34Zm-.88 10.53L10.6 21H6v2h4.6c.52 0 1.03-.21 1.4-.6l1.47-1.46Z',
        'rupee-sign-solid' => 'M8 5v2h4c1.7 0 3.94 1.04 4.72 3H8v2h8.97c-.31 2.6-3 4-4.97 4H8v2.47L18.25 27h3.13l-10.82-9H12c3.23 0 6.68-2.4 6.97-6H24v-2h-5.19A6.23 6.23 0 0 0 17 7h7V5Z',
        'sad-cry-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 7 19.48V16a1 1 0 1 0-2 0v9.79a10.92 10.92 0 0 1-10 0V16a1 1 0 1 0-2 0v8.48A10.98 10.98 0 0 1 16 5zm-4 5c-1.24 0-2.18.69-2.81 1.28a7.6 7.6 0 0 0-1.03 1.16l1.68 1.12s.25-.43.69-.84c.44-.4 1.02-.72 1.47-.72h3v-2h-3zm5 0v2h3c.45 0 1.03.31 1.47.72.44.41.69.84.69.84l1.68-1.12s-.39-.57-1.03-1.16A4.15 4.15 0 0 0 20 10h-3zm-1 6c-1.65 0-3 1.57-3 3.5s1.35 3.5 3 3.5 3-1.57 3-3.5-1.35-3.5-3-3.5zm0 2c.53 0 1 .7 1 1.5s-.47 1.5-1 1.5-1-.7-1-1.5.47-1.5 1-1.5z',
        'sad-cry' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11.01 11.01 0 0 1 7 19.48V16a1 1 0 1 0-2 0v9.79a10.92 10.92 0 0 1-10 0V16a1 1 0 1 0-2 0v8.48A10.98 10.98 0 0 1 16 5zm-4 5c-1.24 0-2.18.69-2.81 1.28a7.6 7.6 0 0 0-1.03 1.16l1.68 1.12s.25-.43.69-.84c.44-.4 1.02-.72 1.47-.72h3v-2h-3zm5 0v2h3c.45 0 1.03.31 1.47.72.44.41.69.84.69.84l1.68-1.12s-.39-.57-1.03-1.16A4.15 4.15 0 0 0 20 10h-3zm-1 6c-1.65 0-3 1.57-3 3.5s1.35 3.5 3 3.5 3-1.57 3-3.5-1.35-3.5-3-3.5zm0 2c.53 0 1 .7 1 1.5s-.47 1.5-1 1.5-1-.7-1-1.5.47-1.5 1-1.5z',
        'sad-tear-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 4a4.2 4.2 0 0 0-2.81 1.28 8.24 8.24 0 0 0-1.03 1.16l1.68 1.12s.25-.43.7-.84c.43-.41 1-.72 1.46-.72h3v-2Zm5 0v2h3c.45 0 1.03.3 1.47.72.44.4.69.84.69.84l1.68-1.12s-.4-.57-1.03-1.16A4.17 4.17 0 0 0 20 10Zm-8.5 4S7 16.67 7 17.5a1.5 1.5 0 0 0 3 0c0-.83-1.5-3.5-1.5-3.5Zm7.5 2a5.94 5.94 0 0 0-4.81 2.4 7.18 7.18 0 0 0-1.16 2.35L9.72 22h12.56l-.31-1.25s-.28-1.17-1.16-2.34A5.94 5.94 0 0 0 16 16Zm0 2c1.67 0 2.57.77 3.19 1.6.15.2.11.2.22.4h-6.82c.1-.2.07-.2.22-.4A3.68 3.68 0 0 1 16 18Z',
        'sad-tear' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4 4a4.2 4.2 0 0 0-2.81 1.28 8.24 8.24 0 0 0-1.03 1.16l1.68 1.12s.25-.43.7-.84c.43-.41 1-.72 1.46-.72h3v-2Zm5 0v2h3c.45 0 1.03.3 1.47.72.44.4.69.84.69.84l1.68-1.12s-.4-.57-1.03-1.16A4.17 4.17 0 0 0 20 10Zm-8.5 4S7 16.67 7 17.5a1.5 1.5 0 0 0 3 0c0-.83-1.5-3.5-1.5-3.5Zm7.5 2a5.94 5.94 0 0 0-4.81 2.4 7.18 7.18 0 0 0-1.16 2.35L9.72 22h12.56l-.31-1.25s-.28-1.17-1.16-2.34A5.94 5.94 0 0 0 16 16Zm0 2c1.67 0 2.57.77 3.19 1.6.15.2.11.2.22.4h-6.82c.1-.2.07-.2.22-.4A3.68 3.68 0 0 1 16 18Z',
        'safari' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm.53 1.03-.1 2h.23l.18.03.29-2h-.16l-.06-.03Zm-1.72.06-.47.07.29 1.96.5-.06Zm3.97.35L18.1 9.3l.47.19.69-1.88Zm-6.1.18-.15.07-.03.03h-.06l-.28.16.84 1.8.22-.12.1-.03.05-.03Zm8.1.75-1.03 1.72.19.1.03.03.12.1 1.2-1.6-.23-.16L21 8.5Zm-10.1.38-.37.28-.06.06h-.03l.87.97.41.56.06-.03.03-.03.29-.22Zm11.6.84-7.34 5.32-5.16 7.34 1.03-.72-.94 1.03.38.35 1.34-1.47-.28-.25 5.85-4.07 3.96-5.84.29.28 1.46-1.34-.3-.38-1.16 1.04Zm-13.25.72-.31.4 1.6 1.2.3-.41Zm14.81 1.28-1.37.88-.34.15.03.04.03.06.12.28 1.82-.88-.2-.37-.02-.03Zm-15.96.6-.16.25v.06l-.03.03-.07.19 1.88.69.06-.2.1-.18Zm16.8 1.56-1.93.47.1.31.02.1 1.97-.32-.03-.06v-.13Zm-17.52.63-.07.5 1.97.28.06-.5ZM25 15.9l-1.25.09-.75-.06v.12l-.03.38 2 .12.03-.5-1-.06 1-.06Zm-15.97.56-2 .1v.34l.03.06.03.19 1.97-.29-.03-.09Zm13.75 1.28-.12.38 1.87.68.06-.1v-.09l.13-.37Zm-13.44.38-1.87.68.16.5 1.87-.68Zm12.82 1.21-.25.41 1.68 1.06.29-.43Zm-12.04.44L8.41 20.8l.09.19.06.06.19.25 1.6-1.22-.13-.12-.03-.06-.03-.04Zm10.97 1-.18.19-.1.12 1.35 1.47.18-.15.07-.07.15-.18Zm-1.3 1.13-.45.25 1.04 1.71.43-.28Zm-7.16.21-.29.6-.71 1.16h.03l.06.03.03.03.4.18.88-1.78-.31-.15-.03-.03Zm5.5.54-.38.12.5 1.94.38-.13h.09l.1-.06Zm-3.85.12-.5 1.94.35.1h.12l.1.02.3-1.96h-.03l-.09-.04Zm2.19.19-.5.03.1 2 .5-.03Z',
        'salesforce' => 'M10 6a7 7 0 0 0-7 7c0 .42.07.81.15 1.2A6.17 6.17 0 0 0 2 17.7c0 3.44 2.8 6.24 6.23 6.3A6.91 6.91 0 0 0 13 26a6.9 6.9 0 0 0 4.86-2.11H18c1.6 0 2.9-.87 3.79-2.05.4.07.79.16 1.21.16a7 7 0 0 0 0-14c-.7 0-1.34.18-1.97.37A6.88 6.88 0 0 0 17 7c-.95 0-1.8.31-2.63.66A6.88 6.88 0 0 0 10 6Zm0 2c1.36 0 2.58.54 3.48 1.42l.53.51.64-.34a4.94 4.94 0 0 1 5.56.58l.45.38.55-.21A4.99 4.99 0 0 1 28 15a4.98 4.98 0 0 1-6.3 4.82l-.77-.2-.37.7A2.87 2.87 0 0 1 18 21.9l-.3-.03-.53-.05-.34.4a4.98 4.98 0 0 1-7.56.1l-.32-.35-.47.02a4.3 4.3 0 0 1-3.52-6.96l.3-.38-.12-.47A4.98 4.98 0 0 1 10 8Zm1.27 5a.04.04 0 0 0-.04.04v2.92c0 .02.02.04.04.04h.34c.02 0 .03-.02.03-.04v-2.92c0-.02-.02-.04-.03-.04Zm5.93 0a.77.77 0 0 0-.56.2c-.14.14-.23.36-.28.63l-.02.17h-.3s-.04.01-.04.05l-.05.28c0 .02 0 .04.04.04h.3l-.3 1.63c-.03.14-.05.25-.08.33a.6.6 0 0 1-.1.19.21.21 0 0 1-.11.1.49.49 0 0 1-.34-.02s-.03-.01-.05.02c0 .03-.09.25-.1.27 0 .03 0 .05.02.06a.7.7 0 0 0 .13.03 1.03 1.03 0 0 0 .52-.03.8.8 0 0 0 .24-.17.96.96 0 0 0 .17-.3c.05-.12.09-.27.12-.44l.3-1.67h.43s.04 0 .05-.04l.04-.28c0-.02 0-.05-.04-.05h-.42s.03-.27.08-.4a.33.33 0 0 1 .1-.15.27.27 0 0 1 .1-.07.54.54 0 0 1 .32.01c.05.01.05 0 .06-.02l.1-.28c.01-.03-.01-.04-.02-.04a.66.66 0 0 0-.13-.03.83.83 0 0 0-.18-.02Zm-9.18 1c-.43 0-.73.24-.73.59 0 .36.33.48.64.57l.05.01c.23.06.43.12.43.27 0 .14-.13.24-.34.24-.07 0-.33 0-.6-.16a.47.47 0 0 1-.08-.05c-.01 0-.05-.02-.06.02l-.1.24c-.01.04 0 .04.01.05l.13.07c.24.11.46.15.7.15.47 0 .76-.23.76-.6 0-.36-.33-.48-.64-.57l-.04-.01c-.24-.07-.44-.13-.44-.27v-.01c0-.13.12-.21.3-.21.2 0 .44.06.6.14 0 0 .05.02.06-.02l.1-.24c0-.02 0-.03-.02-.04a1.4 1.4 0 0 0-.68-.17ZM10 14c-.1 0-.26.01-.36.03 0 0-.29.05-.41.14 0 0-.02.01 0 .05l.08.23c.02.03.05.02.05.02h.02c.26-.14.58-.13.58-.13.14 0 .25.02.33.08.07.05.11.13.11.3v.05l-.22-.03h-.2c-.12 0-.23 0-.34.03-.1.03-.2.07-.27.12a.6.6 0 0 0-.2.2.54.54 0 0 0-.07.3.57.57 0 0 0 .23.47c.08.05.17.09.27.1.1.03.23.04.36.04a2.8 2.8 0 0 0 .74-.1l.1-.01c.03-.01.02-.04.02-.04v-1.13c0-.25-.07-.43-.2-.55A.96.96 0 0 0 10 14Zm3 0a.99.99 0 0 0-.44.08.88.88 0 0 0-.49.54 1.28 1.28 0 0 0 0 .79.8.8 0 0 0 .2.3c.09.1.2.17.33.22.14.05.3.07.49.07.38 0 .58-.08.67-.13.01 0 .03-.01.01-.05l-.09-.23c-.01-.04-.05-.02-.05-.02-.1.03-.23.09-.55.09-.2 0-.36-.05-.45-.14a.59.59 0 0 1-.16-.41h1.34s.03 0 .04-.04c0-.01.04-.25-.04-.53a.73.73 0 0 0-.18-.29.74.74 0 0 0-.24-.18.99.99 0 0 0-.4-.07Zm1.9 0c-.43 0-.73.24-.73.59 0 .36.33.48.64.57l.06.01c.22.06.42.12.42.27 0 .14-.13.24-.34.24-.08 0-.33 0-.6-.16l-.08-.05c-.01 0-.05-.02-.06.02l-.1.24c-.01.04 0 .04.01.05l.14.07c.23.11.45.15.68.15.47 0 .77-.23.77-.6 0-.36-.33-.48-.64-.57l-.04-.01c-.24-.07-.44-.13-.44-.27v-.01c0-.13.12-.21.3-.21.2 0 .44.06.6.14 0 0 .05.02.06-.02l.1-.24c0-.02 0-.03-.03-.04a1.4 1.4 0 0 0-.67-.17Zm3.27 0c-.16 0-.3.03-.43.08a.83.83 0 0 0-.3.21.85.85 0 0 0-.18.32 1.42 1.42 0 0 0 0 .78c.04.13.1.23.19.32.08.1.18.16.3.22.12.05.26.07.42.07.16 0 .3-.02.42-.08a.85.85 0 0 0 .3-.2c.08-.1.15-.2.18-.33a1.28 1.28 0 0 0 0-.78.84.84 0 0 0-.48-.53 1.08 1.08 0 0 0-.42-.08Zm3.48 0c-.16 0-.3.03-.44.08a.86.86 0 0 0-.3.21 1.07 1.07 0 0 0-.26.7c0 .31.08.56.25.74.18.18.44.27.78.27.2 0 .41-.04.56-.1 0 0 .03 0 .02-.04l-.1-.24c-.01-.04-.05-.03-.05-.03a1.28 1.28 0 0 1-.4.06c-.2 0-.34-.04-.45-.15-.1-.1-.17-.27-.17-.5 0-.2.05-.36.15-.48.1-.12.24-.18.44-.18.16 0 .28.02.41.06 0 0 .04.01.05-.03l.1-.24c0-.04-.02-.05-.03-.05a2.75 2.75 0 0 0-.26-.06 2.17 2.17 0 0 0-.3-.02Zm1.64 0a.99.99 0 0 0-.44.08.87.87 0 0 0-.5.54 1.42 1.42 0 0 0 .02.79c.03.12.1.22.19.3.09.1.2.17.33.22.14.05.3.07.48.07.39 0 .6-.08.68-.13.01 0 .03-.01 0-.05l-.08-.23c-.01-.04-.05-.02-.05-.02-.1.03-.23.09-.55.09a.66.66 0 0 1-.45-.14.59.59 0 0 1-.16-.41h1.33s.04 0 .05-.04c0-.01.04-.25-.05-.53a.73.73 0 0 0-.17-.29.74.74 0 0 0-.25-.18.97.97 0 0 0-.38-.07Zm-2.9 0a.72.72 0 0 0-.34.05.63.63 0 0 0-.23.16v-.15c0-.02 0-.04-.03-.04h-.34c-.03 0-.05.02-.05.04v1.9c0 .02.02.04.05.04h.35c.02 0 .04-.02.04-.04v-.95c0-.13.01-.26.04-.34a.45.45 0 0 1 .12-.19c.05-.04.1-.07.17-.09a.59.59 0 0 1 .32 0c.02 0 .04-.02.05-.04l.1-.27a.03.03 0 0 0-.02-.04L20.4 14Zm-7.42.33c.17 0 .29.06.37.18a.6.6 0 0 1 .1.29h-.96a.69.69 0 0 1 .1-.3.5.5 0 0 1 .39-.17Zm10.29 0c.17 0 .29.06.37.18.06.08.08.17.09.29h-.95a.74.74 0 0 1 .1-.3.5.5 0 0 1 .39-.17Zm-5.09 0c.18 0 .3.06.38.18a.8.8 0 0 1 .13.49.9.9 0 0 1-.12.5.46.46 0 0 1-.39.17c-.18 0-.3-.06-.38-.17a.85.85 0 0 1-.12-.5.9.9 0 0 1 .12-.5c.08-.1.2-.16.38-.16Zm-8.13.72a3 3 0 0 1 .36.03v.56s-.17.03-.36.04c-.27.02-.4-.07-.39-.07l-.08-.07a.27.27 0 0 1-.04-.16c0-.11.04-.2.12-.24 0 0 .11-.1.39-.1Z',
        'sass' => 'M15.14 5.01c-1.4-.07-3 .15-4.55.69-2.47.85-5.14 2.2-7.06 3.96-2.29 2.09-2.65 3.9-2.5 4.67.53 2.7 4.34 4.46 5.86 5.76l-.21.11c-.76.37-3.6 1.83-4.32 3.4-.82 1.78.13 3.05.76 3.22a4.6 4.6 0 0 0 4.97-1.97 4.86 4.86 0 0 0 .45-4.56l-.01-.03a63.96 63.96 0 0 1 1.7-.96 7 7 0 0 0-.4 1.96c-.08 1 .34 2.3.9 2.82a1 1 0 0 0 .72.23c.64 0 .94-.52 1.26-1.14.4-.76.75-1.65.75-1.65s-.44 2.4.76 2.4c.44 0 .88-.56 1.08-.85l.03-.05.07-.1v-.02c.18-.3.57-.98 1.16-2.1.76-1.46 1.48-3.28 1.48-3.28.07.4.17.79.3 1.18.12.43.4.9.62 1.37l-.29.38h.01c-.14.19-.3.39-.47.58-.6.7-1.3 1.5-1.4 1.72-.11.27-.09.47.13.63.16.12.44.14.74.12.53-.04.91-.17 1.1-.25.33-.12.65-.28.94-.49.59-.42.95-1.02.91-1.82a3.74 3.74 0 0 0-.34-1.3l.16-.22c.93-1.33 1.64-2.78 1.64-2.78.07.4.17.8.3 1.18.1.37.33.78.53 1.18a5.2 5.2 0 0 0-1.6 2.02c-.35.98-.07 1.42.44 1.52.23.04.55-.06.8-.16.36-.12.7-.3 1.01-.51.59-.42 1.15-1.01 1.12-1.82a3.34 3.34 0 0 0-.26-1.07c.74-.3 1.7-.46 2.91-.33 2.61.3 3.13 1.9 3.03 2.56-.1.66-.65 1.04-.83 1.15-.19.1-.24.15-.23.23.03.12.1.11.26.09.22-.04 1.37-.54 1.42-1.78.08-1.55-1.45-3.27-4.16-3.26-.95 0-1.88.22-2.72.62-.28-.54-.57-1.02-.61-1.38-.06-.41-.12-.66-.05-1.15.06-.5.36-1.2.35-1.25 0-.05-.06-.3-.67-.3-.6-.01-1.12.1-1.18.26-.11.29-.2.58-.25.88-.1.53-1.21 2.45-1.83 3.45a3.5 3.5 0 0 1-.42-1.01c-.05-.42-.12-.66-.05-1.16.06-.5.36-1.2.36-1.25 0-.05-.07-.3-.67-.3-.6 0-1.13.11-1.2.27-.05.15-.12.52-.24.87a176.74 176.74 0 0 1-2.46 5.36l-.04.08.02-.03-.16.3c-.08.15-.17.29-.21.29-.03 0-.1-.39.01-.91.22-1.11.74-2.84.74-2.9 0-.03.1-.33-.35-.49-.42-.15-.58.1-.61.1-.04 0-.07.1-.07.1s.47-1.95-.91-1.95c-.86 0-2.06.93-2.65 1.77l-2.02 1.07-.97.53-.06-.07c-1.68-1.75-4.78-3-4.65-5.34.05-.86.35-3.1 5.96-5.84 4.6-2.24 8.27-1.62 8.9-.26.9 1.95-1.97 5.58-6.74 6.1-1.82.2-2.65-.57-2.9-.83-.24-.27-.28-.28-.37-.23-.16.08-.06.32 0 .46.14.36.77.93 1.76 1.25.88.28 2.9.51 5.47-.46 2.9-1.1 5.11-4.06 4.45-6.6-.42-1.62-2.29-2.55-4.65-2.68zM13.61 17.3c.07 0 .13.03.16.08.16.27-.57 2.27-.76 2.72-.3.72-.94 2.55-1.32 2.45-.33-.08-.53-1.48-.07-2.85a6.2 6.2 0 0 1 1.03-1.84c.36-.39.74-.58.96-.56zm9.74 2.26c.05.16.08.33.09.5 0 1.03-.76 1.41-1.22 1.57-.1-.06-.08-.28.24-.95.12-.26.4-.7.89-1.12zM7.6 20.7a3.6 3.6 0 0 1-.9 3.59c-.85.92-2.06 1.27-2.58.97-.56-.31-.34-1.67.72-2.65.65-.6 1.49-1.15 2.04-1.49l.53-.31a.58.58 0 0 1 .06-.03l.13-.08zm11.78.16v.07c0 .82-.8 1.38-1.17 1.6-.13.06-.24.1-.3.07-.04-.02.05-.11.05-.11s.65-.68.91-1l.51-.63z',
        'satellite-dish-solid' => 'M16.5 4.5v2c4.98 0 9 4.02 9 9h2c0-6.06-4.94-11-11-11Zm0 4v2c2.77 0 5 2.23 5 5h2a7 7 0 0 0-7-7Zm-8.6.1-.68.68a10.98 10.98 0 0 0 0 15.5 10.98 10.98 0 0 0 15.5 0l.69-.69-.7-.71-5.5-5.5a2.49 2.49 0 1 0-3.09-3.1l-5.5-5.5Zm.16 2.96 12.38 12.38a8.83 8.83 0 0 1-11.82-.57 8.83 8.83 0 0 1-.56-11.8Z',
        'satellite-solid' => 'm8.88 3.6-.72.68L4.3 8.16l-.72.71.72.7 5.75 5.77-.65.66 6.6 6.6.66-.66 5.75 5.78.71.69.72-.7 3.88-3.9.72-.68-6.78-6.79c.61-1.66.26-3.6-1.07-4.93a4.67 4.67 0 0 0-4.93-1.04L9.59 4.29Zm0 2.8 5.06 5.07-2.47 2.47L6.4 8.88Zm8.4 5.63a2.67 2.67 0 0 1 1.9 4.56l-2.9 2.88-.28.28L12.25 16l3.03-3.03.13-.16.21-.19.2-.15c.43-.3.95-.44 1.46-.44ZM8.44 17 7 18.4l6.6 6.6 1.4-1.44Zm12.1 1.06 5.05 5.07-2.46 2.46-5.07-5.06Z',
        'save-solid' => 'M5 5v22h22V9.6l-.28-.32-4-4L22.4 5Zm2 2h3v6h12V7.44l3 3V25h-2v-9H9v9H7Zm5 0h4v2h2V7h2v4h-8Zm-1 11h10v7H11Z',
        'save' => 'M5 5v22h22V9.6l-.28-.32-4-4L22.4 5Zm2 2h3v6h12V7.44l3 3V25h-2v-9H9v9H7Zm5 0h4v2h2V7h2v4h-8Zm-1 11h10v7H11Z',
        'schlix' => 'M25.46 5 21.2 7.26l3.14 2.68L30 7.56 25.46 5zm-7.67 1.24-2.65 1.63 1.45 2.06 3.22-1.69-2.02-2zm-4.57.73-1.85 1.29.71 1.67 2.13-1.3-1-1.66zm-3.05.5L8.78 8.52l.36 1.4 1.55-1.06-.52-1.4zm-1.66 2.75-1.3.9.21 1.65 1.44-.88-.35-1.67zm2.71.07L9.5 11.36l.51 2.02 1.97-1.04-.76-2.05zm4.08.1-2.45 1.3 1.13 2.6 2.94-1.23-1.62-2.67zm6.82.17-3.9 1.67 2.56 3.65 5.14-1.52-3.8-3.8zM6.86 13l-1.21.74.07 1.9 1.33-.7-.2-1.94zm2.37.62-1.6.84.31 2.37 1.8-.76-.51-2.45zm3.57.94-2.24.96.8 3.14 2.67-.79-1.23-3.31zm-7.6 1.2-1.12.59L4 18.48l1.22-.52-.02-2.21zm13.59.36-3.56 1.09 2 4.6 4.62-.66-3.06-5.03zm-11.56.82-1.45.62.09 2.71 1.64-.48-.28-2.85zm3.08 1.77-2.04.62.47 3.69 2.41-.34-.84-3.97zm5.15 2.97-3.2.5 1.4 5.56 4.12.2-2.32-6.26z',
        'school-solid' => 'M16 4 3 7v2l13-3 13 3V7Zm-6 6c-3.23 0-6.38 1.31-6.38 1.31L3 11.6V27h11.28a1.98 1.98 0 0 0 3.44 0H29V11.6l-.63-.29S25.23 10 22 10c-2.92 0-5.48.98-6 1.19A17.3 17.3 0 0 0 10 10Zm0 2c1.93 0 4 .63 5 .97v11.12a16.2 16.2 0 0 0-5-.87c-2.1 0-3.81.48-5 .87V12.97c.77-.28 2.8-.97 5-.97Zm12 0c2.2 0 4.23.7 5 .97v11.12a15.7 15.7 0 0 0-5-.87c-2.06 0-3.89.5-5 .87V12.97c1-.35 3.07-.97 5-.97Z',
        'screwdriver-solid' => 'm27.19 1.78-.66.34s-1.12.6-2.44 1.41a21.8 21.8 0 0 0-3.8 2.75c-1.49 1.48-2.74 3.36-3.35 4.22l-.22-.22L16 9.6l-.72.7-2.47 2.5-.72.71.72.69.78.78-7 7-2.12 1.06-.16.31-2 4.04L2 28l.5.53 1 .97.5.5.66-.31 4.3-2.16 1.07-2.12 7-7 .78.78.69.72.72-.72 2.5-2.47.69-.72-.7-.72-.21-.22c.83-.58 2.61-1.74 4.22-3.34 2.09-2.1 4.16-6.25 4.16-6.25l.34-.66-.5-.53-2-2Zm-.38 2.47.94.94c-.5.9-2.12 3.74-3.47 5.1-1.7 1.7-4.84 3.9-4.84 3.9l-1 .65.84.88.28.28-1.06 1.06-.1-.06-.68-.72-2-2-.72-.69-.06-.09L16 12.44l1.13 1.12.68-1s2.38-3.31 3.9-4.84c.7-.7 2.18-1.72 3.45-2.5.9-.56 1.27-.76 1.65-.97ZM15 16.44l.56.56-7.06 7.06-.1.13-.09.15-.84 1.7L4.5 27.5l1.47-2.97 1.69-.84.15-.1.13-.09Z',
        'scribd' => 'M16.3 4C11.73 4 8 6.62 8 11.6a6 6 0 0 0 1.23 3.96c1.47 1.78 4.25 1.89 5.7.42 1.18-1.2 1.35-3.35.04-4.56a2.87 2.87 0 0 0-2.78-.7c-.86.26-1.41.16-1.41-.77 0-2.43 3.03-3.82 5.54-3.78 2.17-.03 4.29.59 6.1 1.78L21.1 9.87l1.86 1.22 2.5-3.58c-1.37-1.07-4.25-3.59-9.15-3.5zm5.37 11a3.3 3.3 0 0 0-3.5 3.33c-.03.84.3 1.64.92 2.2.7.69 1.63.97 2.8.7.85-.25 1.4-.14 1.4.79 0 .2-.02.42-.06.62-.83 2.03-2.95 3.2-6.02 3.2-2.57 0-5.08-.82-7.14-2.35l1.67-1.95-1.76-1.35-3.02 3.55.77.68c2.6 2.32 5.96 3.6 9.45 3.58 2.54 0 4.67-.52 6.61-2.19 2.83-2.54 2.69-7.4 1-9.39a3.9 3.9 0 0 0-3.12-1.41z',
        'scroll-solid' => 'M10 4C8.36 4 7 5.36 7 7v14H4v4c0 1.64 1.36 3 3 3h14.03A3.02 3.02 0 0 0 24 25V11h4V7c0-1.64-1.36-3-3-3H10zm0 2h12.19c-.12.32-.19.65-.19 1v18c0 .57-.43 1-1 1-.56 0-1-.44-1-1l-.03-4H9V7c0-.57.43-1 1-1zm15 0c.57 0 1 .43 1 1v2h-2V7c0-.57.43-1 1-1zM6 23h12v2.03c0 .35.07.66.19.97H7c-.57 0-1-.43-1-1v-2z',
        'sd-card-solid' => 'm9.5 5-.31.4L6 9.67V27h19V5Zm1 2H23v18H8V10.34ZM13 9v4h2V9Zm3 0v4h2V9Zm3 0v4h2V9Zm-9 1v4h2v-4Z',
        'search-dollar-solid' => 'M19 3a10.02 10.02 0 0 0-7.75 16.31l-7.97 7.97 1.44 1.44 7.97-7.97A10.02 10.02 0 0 0 29 13c0-5.51-4.49-10-10-10zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8zm-1 3v1.06c-1.13.2-2 1.14-2 2.32 0 .75.42 1.44 1.1 1.78l2.9 1.46c0 .23-.15.38-.38.38h-1.25a.36.36 0 0 1-.37-.38V14h-2v.63c0 1.17.88 2.12 2 2.3V18h2v-1.06c1.13-.2 2-1.14 2-2.32 0-.75-.42-1.44-1.1-1.78L18 11.38c0-.23.15-.38.38-.38h1.25c.22 0 .37.15.37.38V12h2v-.63c0-1.17-.88-2.12-2-2.3V8h-2z',
        'search-location-solid' => 'M19 3a10.02 10.02 0 0 0-7.75 16.31l-7.97 7.97 1.44 1.44 7.97-7.97A10.02 10.02 0 0 0 29 13c0-5.51-4.49-10-10-10zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8zm0 3a4 4 0 0 0-4 4c0 3 4 7 4 7s4-4 4-7a4 4 0 0 0-4-4zm0 2a2 2 0 1 1 0 4 2 2 0 0 1 0-4z',
        'search-minus-solid' => 'M19 3a10.01 10.01 0 0 0-7.75 16.31l-7.97 7.97 1.44 1.44 7.97-7.97A10.01 10.01 0 0 0 29 13c0-5.51-4.49-10-10-10Zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Zm-4 7v2h8v-2Z',
        'search-plus-solid' => 'M19 3a10.01 10.01 0 0 0-7.75 16.31l-7.97 7.97 1.44 1.44 7.97-7.97A10.01 10.01 0 0 0 29 13c0-5.51-4.49-10-10-10Zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Zm-1 4v3h-3v2h3v3h2v-3h3v-2h-3V9Z',
        'search-solid' => 'M19 3a10.01 10.01 0 0 0-7.75 16.31l-7.97 7.97 1.44 1.44 7.97-7.97A10.01 10.01 0 0 0 29 13c0-5.51-4.49-10-10-10Zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Z',
        'searchengin' => 'M12.94 4v2.72a5.5 5.5 0 0 1 5 5.6 5.6 5.6 0 0 1-4.21 5.43l-.83 2.59-.11.35a8.53 8.53 0 0 0 4.24-1.51l.5.77a5.45 5.45 0 0 1 3.01 2.73c.5 1.1.51 1.68 2.25 2.97 1.74 1.28 2.87 2.22 3.15 2.31.29.1.91.04 1.5-.54.58-.6.64-1.22.54-1.5-.1-.27-1.04-1.4-2.32-3.14-1.29-1.74-1.87-1.76-2.97-2.25a5.36 5.36 0 0 1-2.73-3l-.76-.5A8.3 8.3 0 0 0 12.94 4zm-1.77.07A8.34 8.34 0 0 0 4 12.3c0 4.23 3 7.76 7.07 8.3v-2.79a5.48 5.48 0 0 1-4.35-5.5 5.6 5.6 0 0 1 3.6-5.25l.78-2.75.07-.25zm.83.5L9.15 14.5l2.86-1.26v6.8l3.51-10.92L12 10.59V4.57zm14.5 21.5c.22 0 .41.18.41.41 0 .23-.19.42-.42.42a.41.41 0 0 1-.41-.42c0-.23.18-.42.41-.42z',
        'seedling-solid' => 'M23.4 14.02a1.1 1.1 0 0 1-.6-.1l-1.68 1.07c.37.58 1.14.98 2 1.03h.2c1.13 0 2.23-.57 3.07-1.58 1.44-1.74 2.45-3.6 2.49-3.67l.45-.84-.81-.5c-4.54-2.72-7.13-1.42-8.03-.74a3.72 3.72 0 0 0-1.4 3.74 10.8 10.8 0 0 0-2.6 2.26 8.5 8.5 0 0 0-1.86-2.68 3.88 3.88 0 0 0 .2-.7 4.8 4.8 0 0 0-1.75-4.97c-1.1-.9-4.26-2.66-9.56.27l-.68.37.2.75c.03.15.98 3.72 2.85 5.8A4.2 4.2 0 0 0 8.85 15h.2c1.26 0 2.34-.56 2.78-.96l-1.35-1.48c-.01.01-1.7 1.2-3.1-.37C6.3 11 5.55 9.05 5.2 8c3.78-1.83 5.88-.7 6.62-.1.88.72 1.31 1.76 1.13 2.66A21.53 21.53 0 0 0 8.38 8l-.72 1.87C9.7 10.66 15 13.48 15 17v3.14a4 4 0 0 0-1.98 1.2A3.5 3.5 0 0 0 8.3 23.1 3.5 3.5 0 0 0 4 26.5v.51h2v-.5a1.5 1.5 0 0 1 2.4-1.2l1.6-.79v-.01a1.5 1.5 0 0 1 2.57-1.05l1.62-.28A2 2 0 0 1 16 22a2 2 0 0 1 1.75 1.06l1.58.24a1.07 1.07 0 0 1 1.8.76c0 .12-.02.24-.06.37l1.6 1.09c.27-.24.71-.52 1.33-.52a2 2 0 0 1 2 2h2a4 4 0 0 0-5-3.87 3.07 3.07 0 0 0-4.12-1.9A3.99 3.99 0 0 0 17 20.15v-1.47c0-4.15 6.54-6.14 6.6-6.16l-.56-1.92c-.1.03-.92.28-2 .77.09-.41.3-.8.66-1.07 1.06-.8 2.86-.65 4.92.39-.4.65-1.03 1.6-1.77 2.49-.55.67-1.1.83-1.45.85Zm-9.92-3.2.02.16-.16-.12c.05-.02.09-.04.14-.04Z',
        'sellcast' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13.07 2.06a.97.97 0 0 0-1.05.5l-.23.4a4.9 4.9 0 0 0-6.58 1.73 4.7 4.7 0 0 0 1.76 6.46l.89.5c1.19.67 2.2-1.09 1.02-1.75l-.88-.5a2.7 2.7 0 0 1-1.02-3.7 2.82 2.82 0 0 1 3.79-1l.88.5c.48.24.95.14 1.26-.16.13-.13.1-.1.9-1.48.43-.72-.11-1.39-.74-1.5zm-3.38 4.14c-.98-.1-1.62 1.32-.6 1.9.86.47.04.02.89.5a2.7 2.7 0 0 1 1.01 3.7 2.82 2.82 0 0 1-3.78 1l-.88-.5a1.04 1.04 0 0 0-1.4.36l-.75 1.27c-.6 1.02.92 2.48 2.01.62a4.9 4.9 0 0 0 6.59-1.74A4.7 4.7 0 0 0 18 13.85l-.88-.5c-.15-.09-.3-.13-.43-.15z',
        'sellsy' => 'M18 4a8.9 8.9 0 0 0-8.13 5.4A4.96 4.96 0 0 0 8 9c-2.75 0-5 2.25-5 5 0 .14.02.27.03.4A6.9 6.9 0 0 0 0 20a7 7 0 0 0 7 7h18a7 7 0 0 0 7-7 6.93 6.93 0 0 0-5.03-6.6c0-.13.03-.26.03-.4 0-4.96-4.04-9-9-9Zm0 2a6.98 6.98 0 0 1 6.94 7.94l-.16.97 1 .15A4.98 4.98 0 0 1 30 20c0 2.77-2.23 5-5 5H7a5 5 0 0 1-2.44-9.38l.63-.34-.13-.72a2.99 2.99 0 0 1 4.69-3l1.13.85.4-1.38A7 7 0 0 1 18 6Zm2 7v9h2v-9Zm-4 2v7h2v-7Zm-4 1v6h2v-6Zm-4 1v5h2v-5Z',
        'server-solid' => 'M3 6v20h26V6Zm2 2h22v4H5Zm2 1v2h8V9Zm17 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM5 14h22v4H5Zm2 1v2h8v-2Zm17 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM5 20h22v4H5Zm2 1v2h8v-2Zm17 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'servicestack' => 'M10 6a9.62 9.62 0 0 1 2.22 6.6c3.96 1.68 9.92 6.13 11.18 12.4H28C26.05 14.31 14.92 6.77 10 6zm-2 7c4.67 4.91.81 11.58-4 12h18.97C21.5 18.29 11.95 13.53 8 13z',
        'shapes-solid' => 'M22.36 3.86 16.19 15h12.34L22.36 3.86zm0 4.13L25.13 13h-5.55l2.78-5.01zM9 16a6 6 0 1 0 .01 12.01A6 6 0 0 0 9 16zm8 1v11h11V17H17zm-8 1a4 4 0 1 1 0 8 4 4 0 0 1 0-8zm10 1h7v7h-7v-7z',
        'share-alt-solid' => 'M16 4a4 4 0 0 0-3.97 3.84A9.93 9.93 0 0 0 6 17v.56A4 4 0 0 0 4 21a4.01 4.01 0 0 0 5.63 3.66A9.96 9.96 0 0 0 16 27c2.38 0 4.64-.89 6.38-2.34A4.01 4.01 0 0 0 28 21a4 4 0 0 0-2.04-3.47c.01-.16.03-.32.03-.53a9.93 9.93 0 0 0-6.03-9.16A4 4 0 0 0 16 4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-3.53 3.84A4 4 0 0 0 16 12a4 4 0 0 0 3.53-2.16A7.94 7.94 0 0 1 24 17c-2.2 0-4 1.8-4 4 0 .9.3 1.7.81 2.38A8.07 8.07 0 0 1 16 25a8.07 8.07 0 0 1-4.81-1.63c.5-.66.81-1.48.81-2.37 0-2.2-1.8-4-4-4a7.94 7.94 0 0 1 4.47-7.16ZM8 19c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm16 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'share-alt-square-solid' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13 3a2 2 0 0 0-2 2.16l-4.68 2.34A2 2 0 0 0 12 14a2 2 0 0 0 0 4 2 2 0 0 0 1.32-.5l4.69 2.34A2 2 0 0 0 20 22a2 2 0 0 0 0-4 2 2 0 0 0-1.32.5l-4.69-2.34a2 2 0 0 0 0-.32l4.69-2.34A2 2 0 0 0 20 14a2 2 0 0 0 0-4z',
        'share-solid' => 'm19.72 5.28-1.44 1.44L24.56 13H11a7 7 0 0 0 0 14v-2a4.99 4.99 0 1 1 0-10h13.56l-6.28 6.28 1.44 1.44 8-8 .69-.72-.7-.72Z',
        'share-square-solid' => 'M23.41 4.44 22 5.85 26.17 10H16.5a5.5 5.5 0 0 0 0 11h.5v-2h-.5a3.5 3.5 0 0 1 0-7h9.67l-4.16 4.16 1.41 1.42L30 11l-6.59-6.56zM5 5v22h22V17l-2 2v6H7V7h10.85l2-2H5z',
        'share-square' => 'M23.41 4.44 22 5.85 26.17 10H16.5a5.5 5.5 0 0 0 0 11h.5v-2h-.5a3.5 3.5 0 0 1 0-7h9.67l-4.16 4.16 1.41 1.42L30 11l-6.59-6.56zM5 5v22h22V17l-2 2v6H7V7h10.85l2-2H5z',
        'shekel-sign-solid' => 'M7 5v22h2V7h1c3.88 0 7 3.12 7 7v7h2v-7c0-4.96-4.04-9-9-9Zm15 0v20h-1c-3.88 0-7-3.12-7-7v-7h-2v7c0 4.96 4.04 9 9 9h3V5Z',
        'shield-alt-solid' => 'M16 4c-2.25 0-3.77.89-5.13 1.63A9 9 0 0 1 6 7H5v1c0 7.72 2.6 12.74 5.25 15.78a16.02 16.02 0 0 0 5.38 4.16l.37.12.38-.12s2.73-1.1 5.37-4.13S27 15.75 27 8V7h-1a9.02 9.02 0 0 1-4.88-1.38C19.77 4.9 18.25 4 16 4Zm0 2c1.75 0 2.75.61 4.16 1.38 1.18.64 2.75 1.26 4.78 1.46-.2 6.77-2.43 11.07-4.69 13.66A12.19 12.19 0 0 1 16 25.84c-.49-.21-2.2-1.02-4.25-3.37-2.26-2.6-4.5-6.9-4.69-13.63 2.04-.2 3.6-.82 4.78-1.46C13.24 6.6 14.25 6 16 6Z',
        'ship-solid' => 'M15 3v2h-4v3H7v5.9l-.84.2v.03a2.74 2.74 0 0 0-1.75 4.06L6 20.87v4.97c-.8-.22-1.38-.62-1.38-.62l-1.25 1.56S4.92 28 7.04 28c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c2.11 0 3.6-1.22 3.6-1.22l-1.25-1.56s-.55.43-1.38.66v-5l1.6-2.7a2.74 2.74 0 0 0-1.76-4.05l-.84-.2V8h-4V5h-4V3Zm-2 4h6v3h4v3.5l-6.78-1.47L16 12l-.22.03L9 13.5V10h4Zm3 7.06 9.4 2c.53.12.78.64.5 1.1l-1.74 2.93-.16.22v5.53c-.8-.22-1.38-.62-1.38-.62l-.62-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-.54.43-1.37.66V20.3l-.16-.22-1.75-2.93c-.27-.46-.02-.98.5-1.1ZM11 16c-.6 0-1 .7-1 1.5s.4 1.5 1 1.5 1-.7 1-1.5-.4-1.5-1-1.5Zm10 0c-.6 0-1 .7-1 1.5s.4 1.5 1 1.5 1-.7 1-1.5-.4-1.5-1-1.5Z',
        'shipping-fast-solid' => 'M0 6v2h19v15h-6.16A3.98 3.98 0 0 0 9 20a3.99 3.99 0 0 0-3.84 3H4v-5H2v7h3.16c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3h8.32c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3H32v-8.16l-.06-.15-2-6-.22-.69H21V6Zm1 4v2h9v-2Zm20 2h7.28L30 17.13V23h-1.16A3.98 3.98 0 0 0 25 20a3.99 3.99 0 0 0-3.84 3H21ZM2 14v2h6v-2Zm7 8c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm16 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'shirtsinbulk' => 'M5 4v19.44l.6.25 9.87 4.22.37.18.41-.15 10.13-4.25.62-.25V4Zm2 2h18v3H7Zm0 5h18v11.1l-9.16 3.8L7 22.1Zm9 2a5 5 0 1 0 0 10 5 5 0 0 0 0-10Zm.19 2.03c1.4 0 2.54.81 2.6.85l-.76 1.03c0-.01-.86-.63-1.84-.63-.6 0-1.63.17-1.63.78.23.26 1.1.25 1.47.25h.19c1.63 0 2.69.62 2.69 1.63 0 .93-.74 2.03-2.79 2.03a5.9 5.9 0 0 1-2.87-.84l.69-1.04c0 .01 1.02.63 2.19.63.7 0 1.53-.21 1.53-.78 0-.16-.62-.38-1.44-.38h-.16c-.76 0-1.8-.02-2.37-.6a1.23 1.23 0 0 1-.38-.9c0-1.23 1.13-2.03 2.88-2.03Z',
        'shoe-prints-solid' => 'M10 3C7.8 3 6.2 4.6 5.28 6.5A13.99 13.99 0 0 0 4 12.69a14.42 14.42 0 0 0 1.06 4.69l.28.62h8.41l.22-.75s.79-2.94 1-5.75c.08-1.1.05-3.03-.56-4.84-.3-.91-.75-1.8-1.47-2.5A4.2 4.2 0 0 0 10 3Zm12 0a4.2 4.2 0 0 0-2.94 1.16 6.09 6.09 0 0 0-1.47 2.5c-.6 1.81-.64 3.73-.56 4.84.21 2.8 1 5.75 1 5.75l.22.75h8.4l.29-.63s1.01-2.35 1.06-4.68c.04-2.01-.36-4.3-1.28-6.19C25.8 4.6 24.2 3 22 3ZM10 5c.7 0 1.13.2 1.53.6.4.38.76 1 1 1.71.47 1.42.53 3.22.47 4.07-.16 2.17-.68 4-.84 4.62H6.72A11 11 0 0 1 6 12.66a12.3 12.3 0 0 1 1.1-5.29C7.82 5.87 8.76 5 10 5Zm12 0c1.23 0 2.17.86 2.9 2.38a12.43 12.43 0 0 1 1.1 5.28 11.17 11.17 0 0 1-.72 3.34h-5.44c-.16-.63-.68-2.45-.84-4.63-.06-.84 0-2.64.47-4.06.24-.7.6-1.33 1-1.72.4-.39.83-.59 1.53-.59ZM5 21v1a9.9 9.9 0 0 0 .81 4.4A4.56 4.56 0 0 0 10 29c2.26 0 3.98-2.21 4-5 0-.64-.02-1.4-.25-2.25l-.19-.75Zm13.44 0-.19.75c-.23.85-.25 1.6-.25 2.25.02 2.79 1.74 5 4 5 2.04 0 3.5-1.18 4.19-2.6A9.9 9.9 0 0 0 27 22v-1ZM7.16 23h4.75c.03.33.1.66.09 1-.02 2.02-1.07 3-2 3-1.38 0-1.95-.54-2.4-1.47-.33-.67-.37-1.63-.44-2.53Zm12.93 0h4.75c-.07.9-.1 1.86-.43 2.53-.46.93-1.03 1.47-2.41 1.47-.93 0-1.98-.98-2-3 0-.34.06-.67.1-1Z',
        'shopping-bag-solid' => 'M16 3c-2.75 0-5 2.25-5 5v1H6.06L6 9.94l-1 18L4.94 29h22.12L27 27.94l-1-18-.06-.94H21V8c0-2.75-2.25-5-5-5Zm0 2a3 3 0 0 1 3 3v1h-6V8a3 3 0 0 1 3-3Zm-8.06 6H11v3h2v-3h6v3h2v-3h3.06l.88 16H7.06Z',
        'shopping-basket-solid' => 'M16 3.1 7.1 12H2v6h1.25l2.78 9.28.22.72h19.5l.22-.72L28.75 18H30v-6h-5.1Zm0 2.84L22.06 12H9.94ZM4 14h24v2h-.75l-.22.72L24.25 26H7.75l-2.78-9.28-.22-.72H4Zm7 3v7h2v-7Zm4 0v7h2v-7Zm4 0v7h2v-7Z',
        'shopping-cart-solid' => 'M5 7a1 1 0 0 0 0 2h2.22l2.62 10.5c.23.9 1.02 1.5 1.94 1.5h11.47c.9 0 1.67-.6 1.9-1.47l2.6-9.53H11l.5 2h13.66l-1.91 7H11.78L9.16 8.5A1.98 1.98 0 0 0 7.22 7Zm17 14c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm-9 0c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm9 0c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'shopware' => 'M16 3a13.01 13.01 0 0 0 0 26c2.9 0 5.58-.96 7.75-2.57l-.12-.07c-1.12-.84-2.76-1.48-4.5-2.14C14.76 22.52 10 20.61 10 15c0-5.24 4.8-8 11.49-8 .97 0 1.96.06 2.93.19l.3.04 1.1.25A12.98 12.98 0 0 0 16 3zm5.25 9C16.81 12 17 14.94 17 15.01c0 2.4 2.75 3.49 5.95 4.76 1.55.62 3.16 1.25 4.65 2.1C28.49 20.1 29 18.1 29 16c0-.18 0-.36-.02-.54l-.1-.07C26.14 13 23.94 12 21.25 12z',
        'shower-solid' => 'M15 4v2.1a5.95 5.95 0 0 0-4.9 4.9H9v2h14v-2h-1.1A5.95 5.95 0 0 0 17 6.1V4Zm1 4a3.85 3.85 0 0 1 3.81 3H12.2c.43-1.75 1.9-3 3.81-3Zm-2 6a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-6 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-10 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM8 23a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM6 26a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'shuttle-van-solid' => 'M5 5C3.36 5 2 6.36 2 8v17h3.16c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3h7.32c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3H31V14.56c0-.56-.17-1.11-.47-1.6l-4.1-6.55A2.98 2.98 0 0 0 23.92 5Zm0 2h5v6H4V8c0-.56.44-1 1-1Zm7 0h6v6h-6Zm8 0h3.9a1 1 0 0 1 .85.47L28.19 13H20ZM4 15h25v2h-3v2h3v4h-1.16A3.98 3.98 0 0 0 24 20a3.99 3.99 0 0 0-3.84 3h-7.32A3.98 3.98 0 0 0 9 20a3.99 3.99 0 0 0-3.84 3H4Zm5 7c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm15 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'sign-in-alt-solid' => 'M16 4a12 12 0 0 0-11.6 9h2.07a10 10 0 1 1 0 6H4.4A12 12 0 1 0 16 4Zm-.66 7.28-1.43 1.44L16.19 15H4v2h12.19l-2.28 2.28 1.43 1.44 4-4 .7-.72-.7-.72Z',
        'sign-language-solid' => 'm20.22 1.37-1.61 1.17 8.37 11.53a2 2 0 0 1-.84 1.5l-2.8 1.95a2 2 0 0 1-2.74-.43l-5.8-7.7-1.6 1.21 5.8 7.7a3.99 3.99 0 0 0 5.48.86l2.8-1.96A4 4 0 0 0 29 13.92V7h-2v3.69l-6.78-9.32zm-3 .95L15.58 3.5l5.25 7.22 1.62-1.18-5.25-7.22zM15.36 4.9l-1.62 1.18 4.63 6.37L20 11.26 15.37 4.9zm-2.79 10.3-1.16 1.62L14.48 19H3v2h14.25a2 2 0 0 1 .75 1.54V26a2 2 0 0 1-2 2H6v2h10a4 4 0 0 0 4-4v-3.46c0-1.28-.63-2.5-1.68-3.25l-5.74-4.1zM2 22v2h9v-2H2zm1 3v2h8v-2H3z',
        'sign-out-alt-solid' => 'M16 4C9.38 4 4 9.38 4 16a12.01 12.01 0 0 0 21.81 6.9l-1.62-1.15A9.98 9.98 0 0 1 6 16a9.98 9.98 0 0 1 18.19-5.75l1.62-1.16A11.99 11.99 0 0 0 16 4Zm7.34 7.28-1.43 1.44L24.19 15H12v2h12.19l-2.28 2.28 1.43 1.44 4-4 .7-.72-.7-.72Z',
        'sign-solid' => 'M6 4v2H4v2h2v20h2V8h20V6H8V4H6zm4 6v12h16V10H10zm2 2h12v8H12v-8z',
        'signal-solid' => 'M21 4v24h6V4Zm-8 7v17h6V11Zm-8 7v10h6V18Z',
        'signature-solid' => 'M9.31 4c-.75 0-1.4.37-2 .88-.6.5-1.14 1.19-1.62 2.06A14.96 14.96 0 0 0 4 14.19c0 1.56.36 3.18 1.1 4.47.15.28.42.46.62.71-.54.67-1.44 1.91-1.44 1.91l1.44 1.44s1-1.37 1.62-2.13c.4.18.79.41 1.25.41 1.72 0 3.5-.75 5.16-1.69.53.4 1.13.69 1.75.69 2.05 0 3.62-1.2 4.72-2.28.32-.31.53-.54.78-.81 0 .27-.01.52.06.84.06.24.13.54.38.81s.7.44 1.06.44c.73 0 1.15-.34 1.6-.66.44-.32.85-.7 1.3-1.06.92-.72 1.89-1.28 2.6-1.28v-2c-1.59 0-2.82.94-3.81 1.72l-1.22.94v-.13c.01-.36.07-.77 0-1.22A1.5 1.5 0 0 0 21.59 14c-.56 0-.77.24-.96.4-.2.17-.35.34-.54.54-.36.4-.8.88-1.28 1.34a5.36 5.36 0 0 1-2.9 1.6c.71-.58 1.43-1.15 1.93-1.79.67-.83 1.16-1.68 1.16-2.68a4 4 0 0 0-.5-2.07A2.9 2.9 0 0 0 16 10c-1.23 0-2.35.6-3.03 1.56A6.13 6.13 0 0 0 12 15.2c0 .98.22 1.79.53 2.5-1.39.72-2.83 1.3-3.93 1.3 1.7-2.54 3.4-5.99 3.4-10.19 0-.87 0-1.9-.28-2.84a3.06 3.06 0 0 0-.78-1.34A2.3 2.3 0 0 0 9.3 4Zm0 2c.18 0 .19.04.25.1.06.05.14.2.22.46A9 9 0 0 1 10 8.81c0 3.55-1.52 6.65-3.03 8.97-.04-.06-.1-.06-.13-.12A7.4 7.4 0 0 1 6 14.19a13 13 0 0 1 1.44-6.28 6 6 0 0 1 1.15-1.54c.37-.3.68-.37.72-.37ZM16 12c.55 0 .64.13.78.38.15.24.22.69.22 1.03 0 .25-.21.83-.72 1.46-.44.56-1.11 1.13-1.84 1.7-.18-.41-.44-.7-.44-1.38 0-1.16.25-2.01.6-2.5.34-.5.73-.69 1.4-.69ZM4 26v2h24v-2Z',
        'sim-card-solid' => 'M9 4c-.52 0-1.06.18-1.44.56C7.18 4.94 7 5.48 7 6v20c0 .52.18 1.06.56 1.44.38.38.92.56 1.44.56h14c.52 0 1.06-.18 1.44-.56.38-.38.56-.92.56-1.44V11.4c0-.52-.28-1.08-.6-1.4L19 4.6c-.32-.32-.88-.6-1.4-.6Zm0 2h8.6l5.4 5.4V26H9Zm2 9v9h10v-9Zm2 2h6v5h-6Z',
        'simplybuilt' => 'M6 7a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h20a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v1h-8V9a2 2 0 0 0-2-2Zm0 2h4v3h12V9h4v14H6Zm6 5.5a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm8 0a3 3 0 1 0 0 6 3 3 0 0 0 0-6Z',
        'sistrix' => 'M12.5 3a9.51 9.51 0 0 0 0 19c2.26 0 4.33-.8 5.97-2.12l9.16 9.16 1.41-1.41-9.16-9.16A9.51 9.51 0 0 0 12.5 3zm0 2a7.5 7.5 0 1 1-.02 15.02A7.5 7.5 0 0 1 12.5 5z',
        'sitemap-solid' => 'M12 5v8h3v2H5v4H2v8h8v-8H7v-2h8v2h-3v8h8v-8h-3v-2h8v2h-3v8h8v-8h-3v-4H17v-2h3V5Zm2 2h4v4h-4ZM4 21h4v4H4Zm10 0h4v4h-4Zm10 0h4v4h-4Z',
        'sith' => 'm4 4 3.73 6.36L5 10l3.25 4.06a7.96 7.96 0 0 0 0 3.88L5 22l2.73-.36L4 28l6.36-3.73L10 27l4.06-3.25a7.96 7.96 0 0 0 3.88 0L22 27l-.36-2.73L28 28l-3.73-6.36L27 22l-3.25-4.06a7.96 7.96 0 0 0 0-3.88L27 10l-2.73.36L28 4l-6.36 3.73L22 5l-4.06 3.25a7.96 7.96 0 0 0-3.88 0L10 5l.36 2.73L4 4zm12 6a6 6 0 1 1-.01 12.01A6 6 0 0 1 16 10zm0 2a4 4 0 0 0 0 8 4 4 0 0 0 0-8z',
        'skating-solid' => 'M22.5 4A3.51 3.51 0 0 0 19 7.5c0 1.92 1.58 3.5 3.5 3.5S26 9.42 26 7.5 24.42 4 22.5 4Zm0 2c.86 0 1.5.64 1.5 1.5S23.36 9 22.5 9 21 8.36 21 7.5 21.64 6 22.5 6ZM9 9v2h8.6L14 14.6a2 2 0 0 0 0 2.8l2 2V24h2v-4.6a2 2 0 0 0-.6-1.4l-2-2 3.6-3.6a2 2 0 0 0 .44-2.15c-.29-.68-1-1.25-1.85-1.25Zm3.63 8.81L9 21.44l1.4 1.4 3.63-3.62ZM7 21a1 1 0 0 0 0 2c.28 0 .54-.1.72-.28.18-.18.28-.44.28-.72a1 1 0 0 0-1-1Zm.72 1.72a.97.97 0 0 0-.31.69 1 1 0 0 0 1 1c.27 0 .54-.1.71-.29a1 1 0 0 0-.72-1.72c-.27 0-.5.14-.68.32Zm1.4 1.4a.97.97 0 0 0-.3.7 1 1 0 0 0 2 0 1 1 0 0 0-1-1c-.28 0-.52.13-.7.3Zm5.94.88a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm1 1a1 1 0 0 0 2 0 1 1 0 0 0-2 0Zm2 0a1 1 0 0 0 2 0 1 1 0 0 0-2 0Z',
        'sketch' => 'M16 3.99 8.43 5.07l-5.7 7.99L16 28.54l13.27-15.48-5.7-7.99L16 3.99zm-2.53 2.38-3.27 3.74.23-3.3 3.04-.44zm5.06 0 3.04.43.23 3.3-3.27-3.73zM16 6.52 20.8 12h-9.6L16 6.52zM8.3 8.71 8.06 12H5.94L8.3 8.7zm15.4 0L26.07 12h-2.13l-.22-3.3zM6.19 14h2.2l3.1 6.18L6.17 14zm4.44 0h10.76L16 24.76 10.62 14zm13 0h2.2l-5.3 6.18 3.1-6.18z',
        'skiing-nordic-solid' => 'M14.5 4a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zm0 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zm-.81 6a2 2 0 0 0-2.13 1.47l-1.5 5.27a2 2 0 0 0 .75 2.1l3.21 2.34.76 3.82H9.96l1.02-1.41c.08-.13.14-.27.18-.4l.83-2.27-1.68-1.22-1.03 2.8a.35.35 0 0 1-.06.14L7.5 27H3v2h21.49a4.7 4.7 0 0 0 4.45-3.21l.06-.17-1.9-.64-.05.18A2.7 2.7 0 0 1 24.49 27H21V16h-4.24l-.79-2.34a2.02 2.02 0 0 0-1.35-1.42l-.53-.17a1.98 1.98 0 0 0-.4-.08zm-.2 1.98.57.26.78 2.23a2 2 0 0 0 1.94 1.51H19V27h-2.18l-.83-4.18a2 2 0 0 0-.8-1.28L12 19.26l1.5-5.28z',
        'skiing-solid' => 'M24 4c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm-15.97.22-1.15 1.6 6.3 4.59-.34.34a3.2 3.2 0 0 0 .57 4.78l3.68 2.44-3.8 2.25-7.79-4.47-1 1.75 17.53 10.06c.03.01.06.03.1.03 0 0 .7.35 1.62.41.92.06 2.22-.2 3.06-1.34l-1.6-1.2c-.36.5-.78.58-1.3.54-.47-.03-.8-.16-.88-.19l-.1-.03-7.68-4.4 2.84-1.7a2.02 2.02 0 0 0 .1-3.37l-3.66-2.43a1.17 1.17 0 0 1-.22-1.79 36.6 36.6 0 0 1 1.66-1.71 5.2 5.2 0 0 1 2.62-1.26c.22-.04.38.11.38.35l.03 4v.47l.4.31 3.98 3.03 1.21-1.56L21 12.97l-.03-3.5a2.37 2.37 0 0 0-2.78-2.31c-1.07.2-2.44.67-3.6 1.78ZM24 6c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'skull-crossbones-solid' => 'M6.5 3a1.5 1.5 0 0 0-1.34 2.16 1.5 1.5 0 1 0 .66 2.06l2.71 2.75A8.88 8.88 0 0 0 8 19v1a3 3 0 0 0 .69 1.88L5.8 24.75a1.5 1.5 0 0 0-2.8.75 1.5 1.5 0 0 0 2.16 1.34A1.5 1.5 0 1 0 8 27.5c0-.56-.3-1.05-.75-1.31l3.25-3.25c.16.02.33.06.5.06 0 1.64 1.36 3 3 3h4c1.64 0 3-1.36 3-3 .17 0 .34-.04.5-.06l3.25 3.25A1.5 1.5 0 0 0 25.5 29a1.5 1.5 0 0 0 1.34-2.16A1.5 1.5 0 1 0 27.5 24c-.56 0-1.05.3-1.31.75l-2.88-2.88c.42-.51.69-1.16.69-1.87v-.97c.62-1.22 1-2.57 1-4.03a8.9 8.9 0 0 0-1.56-5.03l2.75-2.75a1.5 1.5 0 1 0 .66-2.06 1.5 1.5 0 1 0-2.06.66l-2.66 2.62A9 9 0 0 0 9.84 8.4L7.22 5.8A1.5 1.5 0 0 0 6.5 3Zm9.47 5a6.97 6.97 0 0 1 6.15 10.38l-.12.25V20c0 .57-.43 1-1 1h-2v2c0 .57-.43 1-1 1h-4c-.57 0-1-.43-1-1v-2h-2c-.57 0-1-.43-1-1v-1.38l-.13-.25a6.97 6.97 0 0 1 5.32-10.3c.26-.04.52-.07.78-.07ZM13 15a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-4 5v2h2v-2Z',
        'skull-solid' => 'M16 4c-2.92 0-5.65.76-7.69 2.34A8.72 8.72 0 0 0 5 13.44c0 2.8 1.38 4.99 2.13 5.97A5.4 5.4 0 0 0 7 20.47c0 1.19.71 2.19 1.66 2.75.66.39 1.51.46 2.34.56v2.63l.31.3s.44.43 1.19.73 1.9.56 3.5.56 2.75-.26 3.5-.56c.75-.3 1.19-.72 1.19-.72l.31-.31v-2.63c.83-.1 1.68-.17 2.34-.56A3.24 3.24 0 0 0 25 20.47c0-.4-.06-.74-.13-1.06.75-.98 2.13-3.17 2.13-5.97a8.71 8.71 0 0 0-3.31-7.1C21.65 4.76 18.92 4 16 4Zm0 2c2.57 0 4.85.67 6.44 1.9A6.59 6.59 0 0 1 25 13.45c0 1.36-.44 2.56-.9 3.47a3.7 3.7 0 0 1-.1-.91h-2c0 1.24.34 2.06.6 2.66.25.6.4.96.4 1.8 0 .49-.18.74-.69 1.04-.5.3-1.33.5-2.31.5h-1v3.44c-.08.04-.03.03-.25.12-.5.2-1.37.44-2.75.44a7.4 7.4 0 0 1-2.75-.44c-.22-.09-.17-.08-.25-.12V22h-1c-.98 0-1.8-.2-2.31-.5-.5-.3-.69-.55-.69-1.03 0-.85.15-1.22.4-1.81.26-.6.6-1.42.6-2.66H8c0 .39-.04.66-.1.9-.46-.9-.9-2.1-.9-3.46 0-2.53.97-4.3 2.56-5.53C11.16 6.67 13.43 6 16 6Zm-3 10a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-3 3.75s-1.25 1.6-1.25 2.34c0 .38.25.57.5.57.42 0 .75-.75.75-.75s.33.75.75.75c.25 0 .5-.2.5-.57 0-.75-1.25-2.34-1.25-2.34Z',
        'skyatlas' => 'M17.8 6.6c1.86 0 6.9 1.45 6.9 6.88 0 .32-.06 1.1-.06 1.1s.91-.28 1.95-.28c1.36 0 5.41 1.07 5.41 5.39 0 4.1-3.54 5.72-5.79 5.72-8.24 0-10.07-12.52-18.01-12.52-3.69 0-5.57 2.7-5.57 5.12 0 3.61 2.7 5.54 5.71 5.54 4.5 0 7.06-2.96 7.42-2.96.42 0 .61.24.61.48 0 .96-4.08 4.34-8.46 4.34C3.65 25.4 0 22.7 0 18c0-4.28 3.55-7.35 7.66-7.35C16.88 10.66 18.69 23 25.74 23c2.51 0 3.76-1.78 3.76-3.38 0-2-1.46-3.64-3.52-3.64-.85 0-1.74.56-2.35.56-.61 0-.85-.42-.85-.8 0-.44.33-1.2.33-2.04a5.65 5.65 0 0 0-5.87-5.52c-2.77 0-3.95 1.88-4.46 1.88-.52 0-.57-.26-.57-.59 0-.33 1.79-2.89 5.6-2.89Z',
        'skype' => 'M11 4a7 7 0 0 0-7 7c0 1.03.32 1.99.72 2.88-.13.69-.22 1.39-.22 2.12a11.51 11.51 0 0 0 13.63 11.28c.88.4 1.84.72 2.87.72a7 7 0 0 0 7-7c0-1.03-.32-1.99-.72-2.88.13-.69.22-1.39.22-2.12A11.51 11.51 0 0 0 13.87 4.72 6.96 6.96 0 0 0 11 4Zm0 2c.86 0 1.67.21 2.38.6a1 1 0 0 0 .68.09 9.49 9.49 0 0 1 11.25 11.25 1 1 0 0 0 .1.69 4.98 4.98 0 0 1-6.78 6.78 1 1 0 0 0-.7-.1A9.49 9.49 0 0 1 6.69 14.06a1 1 0 0 0-.09-.69A4.98 4.98 0 0 1 11 6Zm4.84 3.16c-2.47 0-5.12 1.04-5.12 3.84 0 1.35.48 2.77 3.12 3.44l3.32.81c1 .25 1.25.8 1.25 1.31 0 .84-.84 1.66-2.35 1.66-2.95 0-2.57-2.25-4.15-2.25-.71 0-1.22.49-1.22 1.19 0 1.36 1.67 3.15 5.37 3.15 3.52 0 5.25-1.7 5.25-3.97 0-1.46-.67-3-3.34-3.59l-2.44-.56c-.92-.21-2-.48-2-1.35 0-.87.74-1.5 2.1-1.5 2.72 0 2.49 1.88 3.84 1.88.71 0 1.31-.4 1.31-1.13 0-1.68-2.66-2.93-4.94-2.93Z',
        'slack-hash' => 'M17.66 3c-.29-.02-.6.03-.88.13a2.14 2.14 0 0 0-1.34 2.71l.9 2.66-5.12 1.72-.85-2.56a2.14 2.14 0 0 0-2.7-1.36 2.15 2.15 0 0 0-1.38 2.72l.84 2.53-2.65.9a2.17 2.17 0 0 0-1.34 2.76 2.14 2.14 0 0 0 2.71 1.34l2.66-.87 1.72 5.1-2.56.84a2.14 2.14 0 0 0-1.35 2.71 2.15 2.15 0 0 0 2.72 1.38l2.53-.84.9 2.65a2.17 2.17 0 0 0 2.76 1.34 2.14 2.14 0 0 0 1.34-2.71l-.87-2.66 5.1-1.72.84 2.56a2.14 2.14 0 0 0 2.71 1.35 2.15 2.15 0 0 0 1.38-2.72l-.84-2.53 2.65-.9a2.17 2.17 0 0 0 1.34-2.76 2.14 2.14 0 0 0-2.71-1.34l-2.66.87-1.72-5.1 2.56-.84a2.14 2.14 0 0 0 1.35-2.71 2.15 2.15 0 0 0-2.72-1.38l-2.53.84-.9-2.65A2.15 2.15 0 0 0 17.65 3Zm.03 9.6 1.72 5.09-5.1 1.72-1.72-5.1Z',
        'slack' => 'M17.66 3c-.29-.02-.6.03-.88.13a2.14 2.14 0 0 0-1.34 2.71l.9 2.66-5.12 1.72-.85-2.56a2.14 2.14 0 0 0-2.7-1.36 2.15 2.15 0 0 0-1.38 2.72l.84 2.53-2.65.9a2.17 2.17 0 0 0-1.34 2.76 2.14 2.14 0 0 0 2.71 1.34l2.66-.87 1.72 5.1-2.56.84a2.14 2.14 0 0 0-1.35 2.71 2.15 2.15 0 0 0 2.72 1.38l2.53-.84.9 2.65a2.17 2.17 0 0 0 2.76 1.34 2.14 2.14 0 0 0 1.34-2.71l-.87-2.66 5.1-1.72.84 2.56a2.14 2.14 0 0 0 2.71 1.35 2.15 2.15 0 0 0 1.38-2.72l-.84-2.53 2.65-.9a2.17 2.17 0 0 0 1.34-2.76 2.14 2.14 0 0 0-2.71-1.34l-2.66.87-1.72-5.1 2.56-.84a2.14 2.14 0 0 0 1.35-2.71 2.15 2.15 0 0 0-2.72-1.38l-2.53.84-.9-2.65A2.15 2.15 0 0 0 17.65 3Zm.03 9.6 1.72 5.09-5.1 1.72-1.72-5.1Z',
        'slash-solid' => 'm26.28 4.28-22 22 1.44 1.44 22-22Z',
        'sleigh-solid' => 'M4.5 7A2.52 2.52 0 0 0 2 9.5v.5h2v-.5c0-.29.21-.5.5-.5.26 0 .5.27.5.5 0 .2-.34.83-.88 1.81A8.47 8.47 0 0 0 3 15.5a5.52 5.52 0 0 0 5 5.47V23H3v2h24c1.64 0 3-1.36 3-3s-1.36-3-3-3v2c.57 0 1 .43 1 1 0 .57-.43 1-1 1h-5v-2.22c2.3-.66 4-2.78 4-5.28V13c0-.57.43-1 1-1 .57 0 1 .43 1 1h2c0-1.64-1.36-3-3-3s-3 1.36-3 3c0 1.27-.45 1.55-.94 1.78-.49.23-1 .22-1 .22H17c-1.14 0-1.46-.42-1.72-.94A2.85 2.85 0 0 1 15 13v-1c0-2.28-1.3-3.71-2.53-4.34-1.23-.64-2.44-.66-2.44-.66Zm2.44 2H10c.03 0 .77.05 1.53.44.77.4 1.47.97 1.47 2.56v1s0 .95.5 1.94C14 15.92 15.18 17 17 17h5c.05 0 .87.04 1.78-.34A3.47 3.47 0 0 1 20.5 19h-12A3.5 3.5 0 0 1 5 15.5c0-1.45.41-2.4.88-3.25C6.33 11.4 7 10.67 7 9.5c0-.17-.03-.34-.06-.5ZM10 21h10v2H10Z',
        'sliders-h-solid' => 'M15 5c-1.3 0-2.4.84-2.81 2H4v2h8.19A3 3 0 0 0 15 11c1.3 0 2.4-.84 2.81-2H28V7H17.81A3.01 3.01 0 0 0 15 5Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm7 6c-1.3 0-2.4.84-2.81 2H4v2h15.19A3 3 0 0 0 22 19c1.3 0 2.4-.84 2.81-2H28v-2h-3.19A3.01 3.01 0 0 0 22 13Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-11 6c-1.3 0-2.4.84-2.81 2H4v2h4.19A3 3 0 0 0 11 27c1.3 0 2.4-.84 2.81-2H28v-2H13.81A3.01 3.01 0 0 0 11 21Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'slideshare' => 'M8 4C6.36 4 5 5.36 5 7v8.4c-.77-.44-1.37-.84-1.5-.84-.36 0-.5.35-.5.56 0 1.13 3.34 3.29 5.44 4.07 0 0-.53 1.55-.53 3.31S8.99 28 12.44 28c0 0 2.56 0 2.56-2.53V20.5l2 .6v4.37c0 2.52 2.56 2.53 2.56 2.53 3.45 0 4.53-3.74 4.53-5.5 0-1.76-.53-3.31-.53-3.31 2.1-.78 5.44-2.94 5.44-4.07 0-.21-.14-.56-.5-.56-.13 0-.73.4-1.5.85V7c0-1.64-1.36-3-3-3Zm0 2h16c.57 0 1 .43 1 1v9.4a9.8 9.8 0 0 1-3.72.85c-1.46 0-2.38-.1-3-.1-1.2 0-1.28 1.29-1.28 1.29v.9l-2.34-1.78c-.2-.22-.5-.4-.94-.4-.62 0-1.54.09-3 .09A9.8 9.8 0 0 1 7 16.41V7c0-.57.43-1 1-1Zm4.31 4.97a2.6 2.6 0 0 0-2.65 2.53c0 1.39 1.18 2.5 2.65 2.5C13.8 16 15 14.89 15 13.5s-1.21-2.53-2.69-2.53Zm7.38 0C18.2 10.97 17 12.1 17 13.5s1.21 2.5 2.69 2.5a2.57 2.57 0 0 0 2.65-2.5 2.6 2.6 0 0 0-2.65-2.53Z',
        'smile-beam-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-10.19 7L9.1 20a8.11 8.11 0 0 0 5.82 3.93 7.99 7.99 0 0 0 8-3.93l-1.72-1a6 6 0 0 1-10.38 0z',
        'smile-beam' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5 7c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6S9.7 14 11 14c1.31 0 2.4.8 2.4.8l1.21-1.6S13.1 12 11 12zm10 0c-2.1 0-3.6 1.2-3.6 1.2l1.2 1.6s1.1-.8 2.4-.8c1.31 0 2.4.8 2.4.8l1.21-1.6S23.1 12 21 12zm-10.19 7L9.1 20a8.11 8.11 0 0 0 5.82 3.93 7.99 7.99 0 0 0 8-3.93l-1.72-1a6 6 0 0 1-10.38 0z',
        'smile-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-9.69 7L9.1 20a7.98 7.98 0 0 0 13.82 0l-1.72-1a5.98 5.98 0 0 1-10.38 0Z',
        'smile-wink-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm6.5 1v2h5v-2Zm2.97 4.03a4.6 4.6 0 0 1-1.66 3.69A5.4 5.4 0 0 1 16 22a6.35 6.35 0 0 1-4.69-1.97l-1.4 1.44A8.54 8.54 0 0 0 16 24c1.55 0 3.26-.59 4.63-1.75a6.75 6.75 0 0 0 2.34-5.22Z',
        'smile-wink' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm6.5 1v2h5v-2Zm2.97 4.03a4.6 4.6 0 0 1-1.66 3.69A5.4 5.4 0 0 1 16 22a6.35 6.35 0 0 1-4.69-1.97l-1.4 1.44A8.54 8.54 0 0 0 16 24c1.55 0 3.26-.59 4.63-1.75a6.75 6.75 0 0 0 2.34-5.22Z',
        'smile' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm-9.69 7L9.1 20a7.98 7.98 0 0 0 13.82 0l-1.72-1a5.98 5.98 0 0 1-10.38 0Z',
        'smog-solid' => 'M8 5a6 6 0 1 0 0 12h7.02a4.97 4.97 0 0 0 7.96 0h2.52a4.5 4.5 0 1 0-2.45-8.27 6 6 0 0 0-10.3-1.39A5.98 5.98 0 0 0 8 5zM5 21v2h25v-2H5zm-3 4v2h7v-2H2zm9 0v2h16v-2H11z',
        'smoking-ban-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44L23.44 22H31v-6H17.44ZM16.03 4a4.9 4.9 0 0 0-.94 1.47 6.1 6.1 0 0 0-.59 2.5c0 .96.33 2.05 1.19 2.87.86.83 2.17 1.36 4 1.6 1.52.2 2.5.44 3.06.78.56.33.79.68.97 1.5l1.97-.44a4.22 4.22 0 0 0-1.9-2.78c-1-.6-2.22-.86-3.85-1.06-1.56-.2-2.43-.64-2.88-1.06a1.76 1.76 0 0 1-.56-1.41c0-.54.18-1.15.4-1.66.24-.5.6-.96.54-.9Zm5.53.31v2c.62 0 1.42.1 2.03.44.61.34 1.13.85 1.25 2.31l.1.94h.9c.52 0 1.6.16 2.13.63.26.23.44.5.5 1.03.06.52-.03 1.32-.5 2.46l1.87.76c.56-1.36.75-2.5.63-3.47a3.58 3.58 0 0 0-1.19-2.29 4.52 4.52 0 0 0-2.69-1.06c-.34-1.44-1.07-2.53-2-3.06a6 6 0 0 0-3.03-.69ZM1 16v6h16.81l-2-2H3v-2h10.81l-2-2Zm18.44 2H23v2h-1.56ZM25 18h1v2h-1Zm3 0h1v2h-1Z',
        'smoking-solid' => 'M16.03 4a4.9 4.9 0 0 0-.94 1.47 6.1 6.1 0 0 0-.59 2.5c0 .96.33 2.05 1.19 2.87.86.83 2.17 1.36 4 1.6 1.52.2 2.5.44 3.06.78.56.33.79.68.97 1.5l1.97-.44a4.22 4.22 0 0 0-1.9-2.78c-1-.6-2.22-.86-3.85-1.06-1.56-.2-2.43-.64-2.88-1.06a1.76 1.76 0 0 1-.56-1.41c0-.54.18-1.15.4-1.66.24-.5.6-.96.54-.9Zm5.53.31v2c.62 0 1.42.1 2.03.44.61.34 1.13.85 1.25 2.31l.1.94h.9c.52 0 1.6.16 2.13.63.26.23.44.5.5 1.03.06.52-.03 1.32-.5 2.46l1.87.76c.56-1.36.75-2.5.63-3.47a3.58 3.58 0 0 0-1.19-2.29 4.52 4.52 0 0 0-2.69-1.06c-.34-1.44-1.07-2.53-2-3.06a6 6 0 0 0-3.03-.69ZM1 16v6h30v-6Zm2 2h20v2H3Zm22 0h1v2h-1Zm3 0h1v2h-1Z',
        'sms-solid' => 'M2 5v20h5v5.1l1.63-1.32L13.34 25H30V5Zm2 2h24v16H12.66l-.29.22L9 25.9V23H4Zm4 5v2h16v-2Zm0 4v2h12v-2Z',
        'snapchat-ghost' => 'M15.69 4c-.6 0-1.74.1-3.03.66a6.97 6.97 0 0 0-3.63 3.59c-.7 1.53-.48 3.43-.37 5-.16-.03-.3-.02-.54-.13a1.7 1.7 0 0 0-.68-.15c-.4 0-.76.1-1.1.31-.34.2-.73.53-.84 1.1-.07.35.04.87.34 1.24.31.38.77.65 1.38.88.14.05.25.12.37.16.26.07.54.15.72.25.18.09.21.16.19.12a.7.7 0 0 1-.1.25l-.03.03c-.02.06-1.44 3.14-4.3 3.6-.63.1-1.1.66-1.07 1.3.01.18.07.34.13.48.22.5.66.84 1.25 1.1.47.2 1.23.34 2.06.5l.03.12c.04.17.08.4.16.62.08.3.33.62.62.78.3.16.55.16.69.16.3 0 .49-.06.68-.1a5.77 5.77 0 0 1 2-.06c.4.07.83.36 1.44.78A6.4 6.4 0 0 0 15.84 28h.32c1.71 0 2.9-.8 3.78-1.4a4.3 4.3 0 0 1 1.47-.79 4.9 4.9 0 0 1 1.96.07c.25.04.45.09.7.09h.02c.23 0 .55-.06.82-.25.26-.19.4-.5.46-.72.07-.22.12-.41.16-.6l.03-.12c.83-.15 1.6-.3 2.07-.5.58-.25 1.02-.58 1.25-1.1.05-.13.1-.29.12-.46a1.27 1.27 0 0 0-1.03-1.31h-.03A5.42 5.42 0 0 1 24.72 19c-.73-.84-1.1-1.67-1.1-1.66l-.03-.06a.85.85 0 0 1-.09-.25c-.02.04 0-.03.19-.12.18-.1.46-.18.72-.25.13-.04.26-.1.4-.16.54-.2.92-.41 1.22-.72.3-.3.5-.77.5-1.15-.01-.83-.62-1.29-1.22-1.5v-.04h-.03c-.25-.1-.49-.12-.75-.12-.18 0-.44 0-.78.15-.17.08-.27.06-.4.1.1-1.56.31-3.45-.38-4.97a7.05 7.05 0 0 0-3.63-3.63A7.82 7.82 0 0 0 16.25 4h-.56Zm.06 2h.5a6 6 0 0 1 2.28.47 4.95 4.95 0 0 1 2.63 2.62c.3.68.32 2.66.21 4.25l-.03.07-.03.65a1 1 0 0 0 .28.75c.12.12.58.33 1.07.44-.37.2-.78.48-1 1-.25.58-.14 1.18.09 1.72l.03.1v.06l.03.03c.08.18.5 1.1 1.4 2.15a8.6 8.6 0 0 0 2.6 1.88c-.34.08-.49.17-1.03.25-.48.07-.85.5-.97.78-.1.24-.13.46-.18.69-.4-.07-.83-.16-1.41-.16-.38 0-.78.03-1.16.1-.96.15-1.64.67-2.25 1.09-.89.6-1.53 1.06-2.65 1.06h-.32c-1.12 0-1.77-.45-2.65-1.06-.61-.42-1.28-.94-2.25-1.1a7.25 7.25 0 0 0-2.53.04c-.05-.2-.1-.4-.2-.63-.1-.27-.45-.73-1-.81-.51-.08-.66-.17-1-.25a9 9 0 0 0 3.98-4v-.03l.03-.04c.01-.02.03-.04.06-.15l-.06-.03c.22-.54.37-1.12.12-1.69a2.2 2.2 0 0 0-1.03-1.03c.47-.1.93-.24 1.1-.4a1 1 0 0 0 .28-.76l-.03-.72c-.1-1.6-.12-3.57.18-4.25a4.96 4.96 0 0 1 2.63-2.62A6 6 0 0 1 15.75 6Z',
        'snapchat-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9.12 3h-.24c-.49 0-2.17.15-2.96 2.04-.3.71-.18 2-.13 2.89a.48.48 0 0 1-.24.05 1.2 1.2 0 0 1-.55-.16c-.26-.13-.72.07-.77.39-.04.18.04.45.6.68.21.1.72.2.84.5.05.12.04.28-.05.47h-.01c-.03.08-.77 1.86-2.4 2.15-.12.02-.21.14-.2.28.02.52 1.11.72 1.6.8.05.07.09.37.15.6.03.1.1.22.3.22.18 0 .46-.11.9-.11.62 0 .84.15 1.32.51.35.26.97.74 1.71.68.73.04 1.22-.3 1.73-.68.49-.36.7-.51 1.32-.51.46 0 .7.1.91.1.16 0 .25-.08.3-.21.06-.23.1-.53.14-.6.95-.16 1.46-.38 1.58-.68.08-.2-.03-.37-.17-.4-1.63-.3-2.36-2.07-2.4-2.15-.09-.2-.1-.35-.06-.48.1-.23.44-.35.67-.43l.17-.06c.4-.17.61-.38.6-.62 0-.2-.13-.37-.36-.45a.61.61 0 0 0-.48 0c-.2.1-.36.15-.51.16a.42.42 0 0 1-.2-.06c.04-.9.16-2.17-.14-2.89A3.17 3.17 0 0 0 16.12 10z',
        'snapchat' => 'M15.69 4c-.6 0-1.74.1-3.03.66a6.97 6.97 0 0 0-3.63 3.59c-.7 1.53-.48 3.43-.37 5-.16-.03-.3-.02-.54-.13a1.7 1.7 0 0 0-.68-.15c-.4 0-.76.1-1.1.31-.34.2-.73.53-.84 1.1-.07.35.04.87.34 1.24.31.38.77.65 1.38.88.14.05.25.12.37.16.26.07.54.15.72.25.18.09.21.16.19.12a.7.7 0 0 1-.1.25l-.03.03c-.02.06-1.44 3.14-4.3 3.6-.63.1-1.1.66-1.07 1.3.01.18.07.34.13.48.22.5.66.84 1.25 1.1.47.2 1.23.34 2.06.5l.03.12c.04.17.08.4.16.62.08.3.33.62.62.78.3.16.55.16.69.16.3 0 .49-.06.68-.1a5.77 5.77 0 0 1 2-.06c.4.07.83.36 1.44.78A6.4 6.4 0 0 0 15.84 28h.32c1.71 0 2.9-.8 3.78-1.4a4.3 4.3 0 0 1 1.47-.79 4.9 4.9 0 0 1 1.96.07c.25.04.45.09.7.09h.02c.23 0 .55-.06.82-.25.26-.19.4-.5.46-.72.07-.22.12-.41.16-.6l.03-.12c.83-.15 1.6-.3 2.07-.5.58-.25 1.02-.58 1.25-1.1.05-.13.1-.29.12-.46a1.27 1.27 0 0 0-1.03-1.31h-.03A5.42 5.42 0 0 1 24.72 19c-.73-.84-1.1-1.67-1.1-1.66l-.03-.06a.85.85 0 0 1-.09-.25c-.02.04 0-.03.19-.12.18-.1.46-.18.72-.25.13-.04.26-.1.4-.16.54-.2.92-.41 1.22-.72.3-.3.5-.77.5-1.15-.01-.83-.62-1.29-1.22-1.5v-.04h-.03c-.25-.1-.49-.12-.75-.12-.18 0-.44 0-.78.15-.17.08-.27.06-.4.1.1-1.56.31-3.45-.38-4.97a7.05 7.05 0 0 0-3.63-3.63A7.82 7.82 0 0 0 16.25 4h-.56Zm.06 2h.5a6 6 0 0 1 2.28.47 4.95 4.95 0 0 1 2.63 2.62c.3.68.32 2.66.21 4.25l-.03.07-.03.65a1 1 0 0 0 .28.75c.12.12.58.33 1.07.44-.37.2-.78.48-1 1-.25.58-.14 1.18.09 1.72l.03.1v.06l.03.03c.08.18.5 1.1 1.4 2.15a8.6 8.6 0 0 0 2.6 1.88c-.34.08-.49.17-1.03.25-.48.07-.85.5-.97.78-.1.24-.13.46-.18.69-.4-.07-.83-.16-1.41-.16-.38 0-.78.03-1.16.1-.96.15-1.64.67-2.25 1.09-.89.6-1.53 1.06-2.65 1.06h-.32c-1.12 0-1.77-.45-2.65-1.06-.61-.42-1.28-.94-2.25-1.1a7.25 7.25 0 0 0-2.53.04c-.05-.2-.1-.4-.2-.63-.1-.27-.45-.73-1-.81-.51-.08-.66-.17-1-.25a9 9 0 0 0 3.98-4v-.03l.03-.04c.01-.02.03-.04.06-.15l-.06-.03c.22-.54.37-1.12.12-1.69a2.2 2.2 0 0 0-1.03-1.03c.47-.1.93-.24 1.1-.4a1 1 0 0 0 .28-.76l-.03-.72c-.1-1.6-.12-3.57.18-4.25a4.96 4.96 0 0 1 2.63-2.62A6 6 0 0 1 15.75 6Z',
        'snowboarding-solid' => 'M21 4c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3zM10.53 5.16 8.88 6.28l2.3 3.4c.28.41.7.7 1.16.82l2.2.56-3.2 3.1a2.2 2.2 0 0 0-.34 2.69l1.34 2.3-.93 1.07-1.95 2.17 2.26.47 1.19-1.3 1.43-1.62.47-.53-.34-.63-1.75-2.93a.2.2 0 0 1 .03-.25l4-3.91.94.78-2.57 2.69a2.02 2.02 0 0 0-.03 2.75l1.54 1.69-.1 1.34-.23 2.89 1.98.41.25-3.14.13-1.82.03-.4-.28-.35-1.85-1.97 2.69-2.8 4.38 3.65 1.28-1.56-7.2-5.94-.15-.16-.22-.03-4.5-1.16-2.3-3.4zM21 6c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1zM4.9 21.55l-1.8.9.14.27a4.97 4.97 0 0 0 3.44 2.66l15.75 3.31a4.98 4.98 0 0 0 3.27-.42l.75-.38-.9-1.78-.75.37c-.6.3-1.3.4-1.96.25L7.1 23.42a2.99 2.99 0 0 1-2.07-1.6l-.14-.27z',
        'snowflake-solid' => 'M15 3v3.56l-2.28-2.28-1.44 1.44L15 9.44v4.81l-4.13-2.47-1.3-5.1-1.95.5.82 3.13-3.06-1.84-1.04 1.69 3.13 1.87-3.22.81.5 1.94 5.13-1.31L14.09 16l-4.21 2.53-5.13-1.31-.5 1.94 3.22.8-3.13 1.88 1.04 1.7 3.06-1.85-.81 3.12 1.93.5 1.31-5.1L15 17.76v4.81l-3.72 3.72 1.44 1.44L15 25.44V29h2v-3.56l2.28 2.28 1.44-1.44L17 22.56v-4.81l4.13 2.47 1.3 5.1 1.95-.5-.82-3.13 3.07 1.84 1.03-1.69-3.13-1.87 3.22-.81-.5-1.94-5.13 1.31L17.91 16l4.21-2.53 5.13 1.31.5-1.94-3.22-.8 3.13-1.88-1.04-1.7-3.06 1.85.82-3.12-1.94-.5-1.32 5.1L17 14.24v-4.8l3.72-3.72-1.44-1.44L17 6.56V3Z',
        'snowflake' => 'M15 3v3.56l-2.28-2.28-1.44 1.44L15 9.44v4.81l-4.13-2.47-1.3-5.1-1.95.5.82 3.13-3.06-1.84-1.04 1.69 3.13 1.87-3.22.81.5 1.94 5.13-1.31L14.09 16l-4.21 2.53-5.13-1.31-.5 1.94 3.22.8-3.13 1.88 1.04 1.7 3.06-1.85-.81 3.12 1.93.5 1.31-5.1L15 17.76v4.81l-3.72 3.72 1.44 1.44L15 25.44V29h2v-3.56l2.28 2.28 1.44-1.44L17 22.56v-4.81l4.13 2.47 1.3 5.1 1.95-.5-.82-3.13 3.07 1.84 1.03-1.69-3.13-1.87 3.22-.81-.5-1.94-5.13 1.31L17.91 16l4.21-2.53 5.13 1.31.5-1.94-3.22-.8 3.13-1.88-1.04-1.7-3.06 1.85.82-3.12-1.94-.5-1.32 5.1L17 14.24v-4.8l3.72-3.72-1.44-1.44L17 6.56V3Z',
        'snowman-solid' => 'M16 3c-2.28 0-4.34.23-5.9.63-.79.19-1.43.42-1.97.75C7.58 4.7 7 5.17 7 6v2.03c-.92.24-1.76.5-2.4.85a3.8 3.8 0 0 0-1.07.8c-.3.34-.53.81-.53 1.32 0 .95.7 1.6 1.44 2.03.4.24.9.47 1.43.66A11.02 11.02 0 0 0 16 29a11.02 11.02 0 0 0 10.13-15.31 8.2 8.2 0 0 0 1.43-.66C28.3 12.6 29 11.95 29 11c0-.5-.24-.98-.53-1.31-.3-.33-.65-.59-1.06-.81A10.9 10.9 0 0 0 25 8.03V6c0-.82-.58-1.3-1.13-1.63a7.35 7.35 0 0 0-1.96-.75A25.39 25.39 0 0 0 16 3Zm0 2c2.14 0 4.07.23 5.4.56.67.17 1.2.38 1.48.53.1.07.1.09.12.1V7.8c-.01.01-.02.03-.13.1-.26.15-.8.36-1.46.53A23.6 23.6 0 0 1 16 9a23.6 23.6 0 0 1-5.4-.56 6.34 6.34 0 0 1-1.47-.53C9.02 7.84 9 7.82 9 7.8V6.2c.01-.01.02-.03.13-.1.26-.15.8-.36 1.46-.53A23.6 23.6 0 0 1 16 5ZM8.28 9.69c.51.28 1.1.5 1.81.69 1.57.39 3.63.62 5.91.62 2.28 0 4.34-.23 5.9-.63a7.3 7.3 0 0 0 1.82-.65h.06c1.17.26 2.1.6 2.66.9.27.16.45.3.53.38-.02.04-.11.14-.4.31a9.5 9.5 0 0 1-2.32.85c-2.06.51-5 .84-8.25.84s-6.2-.33-8.25-.84a9.5 9.5 0 0 1-2.31-.85c-.3-.17-.39-.27-.4-.31.07-.08.25-.22.52-.38a10.8 10.8 0 0 1 2.72-.93Zm-.4 4.53c2.21.49 5.01.78 8.12.78 3.1 0 5.91-.3 8.13-.78a8.89 8.89 0 0 1 .71 5.44l-1.46-.6s-1.25-.49-2.63-1c-.7-.25-1.42-.52-2.06-.72A5.46 5.46 0 0 0 17 17c-1.64 0-3 1.36-3 3s1.36 3 3 3c.58 0 1.04-.15 1.69-.34.64-.2 1.37-.47 2.06-.72 1.38-.51 2.63-1 2.63-1l1.28-.53A8.98 8.98 0 0 1 7 18c0-1.37.34-2.64.88-3.8ZM13 15a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm7 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-3 4c-.03 0 .54.1 1.13.28.58.18 1.26.41 1.93.66l.16.06-.16.06c-.67.25-1.35.48-1.93.66-.6.18-1.16.28-1.13.28-.57 0-1-.43-1-1 0-.57.43-1 1-1Zm-2.81 3.84-1.44 1.41a6.03 6.03 0 0 0 8.5 0l-1.4-1.4a3.98 3.98 0 0 1-5.66 0Z',
        'snowplow-solid' => 'M10.5 6a3 3 0 0 0-2.88 2.19l-1.3 4.53-2-.66-.63 1.88 1.47.5-.29.28c-.56.56-.87 1.3-.87 2.1V19h-.81l-.16.81-1 5L1.78 26h28.44l-.25-1.19-1-5-.16-.81H28v-2.19c0-.8-.31-1.53-.88-2.1l-.28-.27 1.47-.5-.62-1.88-2 .66-1.32-4.53A3 3 0 0 0 21.5 6Zm0 2h11c.45 0 .81.29.94.72L23.66 13H8.34l1.22-4.28A.96.96 0 0 1 10.5 8Zm-3.06 7h17.12l1.16 1.13c.19.18.28.42.28.68V19h-2v-2h-4v2h-8v-2H8v2H6v-2.19c0-.26.1-.5.28-.68ZM4.8 21h22.4l.6 3H4.21Z',
        'socks-solid' => 'm9.94 2-.28.97-4.44 15.56v.03a4.99 4.99 0 0 0 2.53 5.9l.03.04h.03l11.94 4.97.06.03a4.99 4.99 0 0 0 4.44-8.97l-.06-.03h-.03l-.66-.28h-.03l-7-2.78 3.25-11.5.25-.94-9.06-2.72Zm1.37 2.47 6.22 1.87L17 8.22l-6.22-1.88Zm-1.1 3.81 6.23 1.88-2.16 7.59-.22.88.81.34 6.79 2.69a8.92 8.92 0 0 0-2.6 5.37l-7.37-3.1a6 6 0 0 0-3.78-7.6Zm-2.84 9.97a3.97 3.97 0 0 1 2.44 4.9l-1.15-.46a2.99 2.99 0 0 1-1.54-3.57v-.03Zm16.29 4.25A3 3 0 0 1 21 27.81a6.99 6.99 0 0 1 2.66-5.31Z',
        'solar-panel-solid' => 'M15 4v2.6l-1.81-1.8-1.39 1.4L13.6 8H11v2h2.6l-1.79 1.81 1.38 1.38L15 11.4V14h2v-2.6l1.81 1.79 1.38-1.38L18.4 10H21V8h-2.6l1.79-1.81L18.8 4.8 17 6.6V4Zm1 3a2 2 0 0 1 0 4 2 2 0 0 1 0-4Zm-9.78 9L4 24.88V28h24v-3.13L25.78 16Zm1.56 2h16.44L26 25.13V26H6v-.88ZM9 19l-.4 1.81h2.09L11 19Zm4 0-.19 1.81h2.1L15 19Zm4 0 .1 1.81h2.09L19 19Zm4 0 .31 1.81h2.1L23 19ZM8.19 22.81 7.8 25h2.28l.32-2.19Zm4.5 0L12.5 25h2.31l.1-2.19Zm4.4 0 .1 2.19h2.31l-.19-2.19Zm4.5 0 .32 2.19h2.28l-.38-2.19Z',
        'sort-alpha-down-alt-solid' => 'M5 5v2h5.56l-5.28 5.28-.28.31V15h8v-2H7.44l5.28-5.28.28-.31V5Zm17 0v18.69l-2.6-2.6L18 22.5l4.28 4.31.72.69.72-.69L28 22.5l-1.4-1.4-2.6 2.59V5ZM8.19 17l-.22.66L6.03 23H6v.06l-.94 2.6-.06.15V27h2v-.84L7.4 25h3.2l.4 1.16V27h2v-1.19l-.06-.15-.94-2.6V23h-.03l-1.94-5.34-.22-.66ZM9 20.66 9.84 23H8.16Z',
        'sort-alpha-down-solid' => 'm8.19 5-.22.66L6.03 11H6v.06l-.94 2.6-.06.15V15h2v-.84L7.4 13h3.2l.4 1.16V15h2v-1.19l-.06-.15-.94-2.6V11h-.03l-1.94-5.34L9.81 5ZM22 5v18.69l-2.6-2.6L18 22.5l4.28 4.31.72.69.72-.69L28 22.5l-1.4-1.4-2.6 2.59V5ZM9 8.66 9.84 11H8.16ZM5 17v2h5.56l-5.28 5.28-.28.31V27h8v-2H7.44l5.28-5.28.28-.31V17Z',
        'sort-alpha-up-alt-solid' => 'M5 5v2h5.56l-5.28 5.28-.28.31V15h8v-2H7.44l5.28-5.28.28-.31V5H5zm18 .5-.72.69L18 10.5l1.41 1.41L22 9.31V28h2V9.31l2.59 2.6L28 10.5l-4.28-4.31L23 5.5zM8.19 17l-.22.66L6.03 23H6v.06l-.94 2.6-.06.15V27h2v-.84L7.41 25h3.18l.41 1.16V27h2v-1.19l-.06-.15-.94-2.6V23h-.03l-1.94-5.34L9.8 17H8.2zM9 20.66 9.84 23H8.16L9 20.66z',
        'sort-alpha-up-solid' => 'm8.19 5-.22.66L6.03 11H6v.06l-.94 2.6-.06.15V15h2v-.84L7.41 13h3.18l.41 1.16V15h2v-1.19l-.06-.15-.94-2.6V11h-.03l-1.94-5.34L9.8 5H8.2zM23 5.5l-.72.69L18 10.5l1.41 1.41L22 9.31V28h2V9.31l2.59 2.6L28 10.5l-4.28-4.31L23 5.5zM9 8.66 9.84 11H8.16L9 8.66zM5 17v2h5.56l-5.28 5.28-.28.31V27h8v-2H7.44l5.28-5.28.28-.31V17H5z',
        'sort-amount-down-alt-solid' => 'M4 5v2h2V5Zm17 0v18.69l-2.6-2.6L17 22.5l4.28 4.31.72.69.72-.69L27 22.5l-1.4-1.4-2.6 2.59V5ZM4 9v2h4V9Zm0 4v2h6v-2Zm0 4v2h8v-2Zm0 4v2h10v-2Zm0 4v2h12v-2Z',
        'sort-amount-down-solid' => 'M4 5v2h12V5Zm17 0v18.69l-2.6-2.6L17 22.5l4.28 4.31.72.69.72-.69L27 22.5l-1.4-1.4-2.6 2.59V5ZM4 9v2h10V9Zm0 4v2h8v-2Zm0 4v2h6v-2Zm0 4v2h4v-2Zm0 4v2h2v-2Z',
        'sort-amount-up-alt-solid' => 'M4 5v2h2V5H4zm18 .5-.72.69L17 10.5l1.41 1.41L21 9.31V28h2V9.31l2.59 2.6L27 10.5l-4.28-4.31L22 5.5zM4 9v2h4V9H4zm0 4v2h6v-2H4zm0 4v2h8v-2H4zm0 4v2h10v-2H4zm0 4v2h12v-2H4z',
        'sort-amount-up-solid' => 'M4 5v2h12V5H4zm18 .5-.72.69L17 10.5l1.41 1.41L21 9.31V28h2V9.31l2.59 2.6L27 10.5l-4.28-4.31L22 5.5zM4 9v2h10V9H4zm0 4v2h8v-2H4zm0 4v2h6v-2H4zm0 4v2h4v-2H4zm0 4v2h2v-2H4z',
        'sort-down-solid' => 'm3.6 12 1.68 1.72 10 10 .72.69.72-.7 10-10L28.4 12Zm4.84 2h15.12L16 21.56Z',
        'sort-numeric-down-alt-solid' => 'M8.5 5A3.51 3.51 0 0 0 5 8.5V9h2v-.5C7 7.62 7.63 7 8.5 7h1c.88 0 1.5.63 1.5 1.5 0 .46-.35.98-.94 1.34-1.23.76-2.31 1.25-3.22 1.75-.45.26-.86.5-1.21.88A2.3 2.3 0 0 0 5 14v1h8v-2H8.44c.73-.38 1.58-.76 2.69-1.44A3.71 3.71 0 0 0 13 8.5C13 6.58 11.42 5 9.5 5ZM22 5v18.69l-2.6-2.6L18 22.5l4.28 4.31.72.69.72-.69L28 22.5l-1.4-1.4-2.6 2.59V5ZM8.6 17l-.16.78s-.17.58-.56 1.16C7.47 19.52 6.97 20 6 20v2c1.38 0 2.32-.68 3-1.4V27h2V17Z',
        'sort-numeric-down-solid' => 'm8.6 5-.16.78s-.17.58-.56 1.16C7.47 7.52 6.97 8 6 8v2c1.38 0 2.32-.68 3-1.4V15h2V5ZM22 5v18.69l-2.6-2.6L18 22.5l4.28 4.31.72.69.72-.69L28 22.5l-1.4-1.4-2.6 2.59V5ZM8.5 17A3.51 3.51 0 0 0 5 20.5v.5h2v-.5c0-.88.63-1.5 1.5-1.5h1c.88 0 1.5.63 1.5 1.5 0 .46-.35.98-.94 1.34-1.23.76-2.31 1.25-3.22 1.75-.45.26-.86.5-1.21.88A2.3 2.3 0 0 0 5 26v1h8v-2H8.44c.73-.38 1.58-.76 2.69-1.44A3.71 3.71 0 0 0 13 20.5c0-1.92-1.58-3.5-3.5-3.5Z',
        'sort-numeric-up-alt-solid' => 'M8.5 5A3.52 3.52 0 0 0 5 8.5V9h2v-.5C7 7.62 7.62 7 8.5 7h1c.88 0 1.5.62 1.5 1.5 0 .46-.35.98-.94 1.34-1.23.76-2.31 1.25-3.22 1.75-.45.26-.86.5-1.22.88-.35.38-.62.95-.62 1.53v1h8v-2H8.44c.73-.38 1.58-.76 2.68-1.44A3.7 3.7 0 0 0 13 8.5C13 6.58 11.42 5 9.5 5h-1zm14.5.5-.72.69L18 10.5l1.41 1.41L22 9.31V28h2V9.31l2.59 2.6L28 10.5l-4.28-4.31L23 5.5zM8.59 17l-.15.78s-.17.58-.56 1.16C7.48 19.52 6.98 20 6 20v2c1.38 0 2.32-.68 3-1.41V27h2V17H8.59z',
        'sort-numeric-up-solid' => 'm8.59 5-.15.78s-.17.58-.56 1.16C7.48 7.52 6.98 8 6 8v2c1.38 0 2.32-.68 3-1.41V15h2V5H8.59zM23 5.5l-.72.69L18 10.5l1.41 1.41L22 9.31V28h2V9.31l2.59 2.6L28 10.5l-4.28-4.31L23 5.5zM8.5 17A3.52 3.52 0 0 0 5 20.5v.5h2v-.5c0-.88.62-1.5 1.5-1.5h1c.88 0 1.5.62 1.5 1.5 0 .46-.35.98-.94 1.34-1.23.76-2.31 1.25-3.22 1.75-.45.26-.86.5-1.22.88-.35.38-.62.95-.62 1.53v1h8v-2H8.44c.73-.38 1.58-.76 2.68-1.44A3.7 3.7 0 0 0 13 20.5c0-1.92-1.58-3.5-3.5-3.5h-1z',
        'sort-solid' => 'm16 3.6-.72.68-8 8L5.6 14h20.82l-1.7-1.72-8-8Zm0 2.84L21.56 12H10.44ZM5.6 18l1.68 1.72 8 8 .72.69.72-.7 8-8L26.4 18Zm4.84 2h11.12L16 25.56Z',
        'sort-up-solid' => 'm16 8.6-.72.68-10 10L3.6 21h24.82l-1.7-1.72-10-10Zm0 2.84L23.56 19H8.44Z',
        'soundcloud' => 'M19.63 9.05a7 7 0 0 0-2.52.47c-.3.12-.38.23-.38.46v12.5c0 .24.19.43.42.45h10.91a3.92 3.92 0 1 0 0-7.86c-.54 0-1.05.11-1.52.31a6.95 6.95 0 0 0-6.91-6.33zm-3.7.92c-.11 0-.2.04-.28.1-.1.08-.16.2-.16.34v.04l-.18 8.82.1 1.63.08 1.6c0 .23.2.42.44.42.23 0 .43-.2.43-.43l.2-3.22-.2-8.86c0-.16-.09-.3-.22-.37a.43.43 0 0 0-.21-.07zm-1.35.77a.38.38 0 0 0-.22.06.4.4 0 0 0-.18.34v.08l-.16 8.05.16 3.27v.01c0 .1.03.18.09.24.08.1.19.15.31.15a.4.4 0 0 0 .29-.12.43.43 0 0 0 .12-.28l.01-.33.16-2.94-.17-8.13a.42.42 0 0 0-.4-.4zm-4.02.93a.33.33 0 0 0-.32.32l-.2 7.28.2 3.34c0 .18.15.32.32.32.18 0 .32-.14.33-.32l.22-3.34-.22-7.28a.33.33 0 0 0-.33-.32zm1.33.16c-.2 0-.35.15-.35.35l-.19 7.09.19 3.3c0 .2.16.36.35.36.2 0 .34-.16.35-.35l.2-3.31-.2-7.09c0-.2-.16-.35-.35-.35zm-2.65.1a.3.3 0 0 0-.3.3l-.21 7.04.22 3.36c0 .17.13.3.3.3a.3.3 0 0 0 .29-.3l.25-3.36-.25-7.04a.3.3 0 0 0-.3-.3zm3.99.13a.4.4 0 0 0-.38.38l-.17 6.83.17 3.29a.38.38 0 0 0 .76 0l.2-3.29-.2-6.83a.38.38 0 0 0-.38-.38zm-5.32.46a.27.27 0 0 0-.27.27l-.23 6.5.23 3.4c0 .14.13.26.27.26.15 0 .27-.12.27-.27l.27-3.4-.27-6.5a.27.27 0 0 0-.27-.26zm-1.27 1.22c-.13 0-.24.1-.25.24l-.25 5.29.25 3.41c.01.14.12.25.25.25s.23-.11.24-.25l.28-3.41-.28-5.29a.25.25 0 0 0-.24-.24zm-2.57 1.84c-.1 0-.18.08-.19.19l-.28 3.5.28 3.39c.01.1.1.18.19.18a.2.2 0 0 0 .19-.18l.32-3.4-.32-3.5a.2.2 0 0 0-.19-.18zm-1.27.12c-.08 0-.15.07-.16.16l-.3 3.4.3 3.3c.01.08.08.15.16.15.09 0 .15-.07.16-.16l.34-3.28-.34-3.41c0-.1-.07-.16-.16-.16zm2.55.1c-.12 0-.2.1-.22.22l-.26 3.25.26 3.41c.01.12.1.21.22.21.11 0 .2-.09.21-.2l.3-3.42-.3-3.25c0-.13-.1-.22-.21-.22zm-3.8.46c-.07 0-.13.06-.14.13l-.31 2.88.31 2.8c.01.08.07.14.14.14.06 0 .12-.06.13-.13l.36-2.81-.36-2.88c-.01-.07-.07-.13-.13-.13zm-1.19 1.1c-.06 0-.12.05-.13.13L0 19.27.23 21c.01.08.07.13.13.13.07 0 .12-.05.13-.12l.28-1.75-.28-1.78c-.01-.08-.06-.13-.13-.13z',
        'sourcetree' => 'M16 4C10.49 4 6 8.49 6 14c0 3.98 2.38 7.58 6 9.16V28h8v-4.84A10.01 10.01 0 0 0 16 4zm0 2a8 8 0 0 1 2.67 15.54l-.67.23V26h-4v-4.23l-.67-.24A8 8 0 0 1 16 6zm0 4a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm0 2a2 2 0 1 1 0 4 2 2 0 0 1 0-4z',
        'spa-solid' => 'M16 4a5.49 5.49 0 0 0-5.44 5.19 5.48 5.48 0 0 0-6.22 3.37c-1 2.64.26 5.53 2.72 6.78a5.49 5.49 0 0 0 .9 7.38 5.52 5.52 0 0 0 7.76-.69c.12-.14.15-.34.25-.5.1.17.15.38.28.53a5.52 5.52 0 0 0 7.75.69 5.47 5.47 0 0 0 .88-7.38 5.47 5.47 0 0 0 2.78-6.8 5.48 5.48 0 0 0-6.22-3.38A5.49 5.49 0 0 0 16 4Zm0 2c1.95 0 3.5 1.55 3.5 3.5 0 .16-.07.44-.19.78v.03l-2.97 4.22c.32-1.03.66-2.2.66-2.53a1 1 0 0 0-2 0c0 .32.27 1.43.53 2.44l-2.9-4.38a2.59 2.59 0 0 1-.13-.56C12.5 7.55 14.05 6 16 6Zm-6.63 5c.46-.02.93.05 1.38.22.08.03.2.13.38.25h.03l2.78 4.22c-.88-.6-1.85-1.24-2.16-1.35a1 1 0 1 0-.69 1.88c.3.1 1.48.19 2.54.25l-5.07 1.4A3.5 3.5 0 0 1 9.37 11Zm13.26 0a3.5 3.5 0 0 1 1.13 6.78c-.14.05-.39.1-.67.13l-4.87-1.44c1.09-.06 2.37-.13 2.69-.25a1 1 0 1 0-.7-1.88c-.32.12-1.4.83-2.3 1.44l3.03-4.37a2 2 0 0 1 .31-.2c.45-.16.92-.23 1.38-.21Zm-8.32 7.38c-.89.62-1.98 1.38-2.22 1.65-.36.42-.29 1.08.13 1.44a1 1 0 0 0 1.4-.13c.27-.3.97-1.9 1.38-2.84v3.69a6.7 6.7 0 0 1-.81 2.56 3.5 3.5 0 0 1-4.94.44 3.5 3.5 0 0 1-.44-4.94 3 3 0 0 1 .66-.5l.12-.06Zm3.47.06 4.78 1.37c.28.18.5.35.6.47a3.5 3.5 0 0 1-.44 4.94 3.5 3.5 0 0 1-4.94-.44c-.25-.3-.6-1.28-.78-2.4V18.5c.41.95 1.1 2.53 1.38 2.84a1 1 0 0 0 1.4.13c.42-.36.49-1.02.13-1.44a22.1 22.1 0 0 0-2.13-1.6Z',
        'space-shuttle-solid' => 'M2 4v6H0v3h1v6H0v3h2v6h4.56a9.3 9.3 0 0 0 6.57-2.72l4.34-4.31 8.03-.69a8.45 8.45 0 0 0 6.34-3.72l.35-.56-.35-.56a8.45 8.45 0 0 0-6.34-3.72l-8.03-.69-4.19-4.19-.15-.12A9.3 9.3 0 0 0 6.55 4Zm2 2h2.56c1.93 0 3.8.76 5.16 2.13L14.56 11H10v2h7l8.31.69A6.4 6.4 0 0 1 29.56 16a6.4 6.4 0 0 1-4.25 2.31l-8.4.69H10v2h4.56l-2.84 2.88A7.3 7.3 0 0 1 6.56 26H4v-7H3v-6h1Zm20 9v2h2v-2ZM6 21v3h2v-3Z',
        'speakap' => 'M15.4 3C8.55 3 3 8.59 3 15.46 3 22.2 8 29 19.17 29c2.81 0 6.6-1.08 6.76-1.13l2.07-.59-1.71-1.3a33.27 33.27 0 0 1-2.1-1.76A12.44 12.44 0 0 0 15.4 3zm0 2a10.44 10.44 0 0 1 7.38 17.81l-1.47 1.48 1.55 1.4c.26.25.52.48.78.7a22.3 22.3 0 0 1-4.47.61C8.7 27 5 20.78 5 15.46 5 9.69 9.66 5 15.4 5zm.85 4c-2.58-.05-4.73 1.4-4.77 3.94-.01.56 0 1.81 1.44 2.7 1.7 1.06 4.27 1.06 4.24 2.57-.02 1.06-1.3 1.28-1.9 1.27-.15 0-1.5-.02-2.35-1.21l-1.96 2.1A5.8 5.8 0 0 0 15.06 22c.5 0 4.75 0 4.82-4 .01-.78-.1-1.95-1.42-2.79-1.7-1.06-4.19-.96-4.16-2.44.02-1.15 1.53-1.26 1.85-1.25.02 0 1.31.01 1.95.85l1.9-2.01A5.3 5.3 0 0 0 16.25 9z',
        'speaker-deck' => 'M8 8a5 5 0 0 0 0 10h6a1 1 0 0 1 0 2H5a2 2 0 0 0 0 4h9a5 5 0 0 0 0-10H8a1 1 0 0 1 0-2h7a2 2 0 0 0 0-4H8zm10.45 0c.34.59.55 1.27.55 2s-.22 1.4-.56 2H24a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-3.08a6.98 6.98 0 0 1-2.03 4H25a4 4 0 0 0 4-4v-8a4 4 0 0 0-4-4h-6.55z',
        'spell-check-solid' => 'M7.33 5 3 18h2.1l1-3h4.57l1 3h2.1L9.45 5h-2.1zM15 5v13h6a4 4 0 0 0 1.49-7.7A3.5 3.5 0 0 0 19.5 5H15zm2 2h2.5a1.5 1.5 0 0 1 0 3H17V7zM8.39 8.16 10 13H6.78l1.6-4.84zM17 12h4a2 2 0 0 1 0 4h-4v-4zm10.8 5.78-8.68 8.33-3.93-3.77-1.38 1.44 5.3 5.1 10.08-9.66-1.38-1.44z',
        'spider-solid' => 'M7 3v5.47l.38.31L11.4 12H8.34L4.6 9.19 3.41 10.8 7.66 14h3.56l-3.6 3H3v2h5.38l.24-.22 1.41-1.16c0 .13-.03.25-.03.38 0 .18.02.35.03.53l-3.75 3.75-.28.31V29h2v-5.56l2.56-2.57c.28.76.62 1.5 1.06 2.2C12.63 24.62 14.12 26 16 26c1.9 0 3.37-1.37 4.38-2.94.44-.68.78-1.43 1.06-2.18L24 23.43V29h2v-6.4l-.28-.32-3.75-3.75c.01-.18.03-.35.03-.53 0-.12-.02-.23-.03-.34l1.4 1.12.29.22H29v-2h-4.66l-3.75-3h3.75l4.25-3.19-1.18-1.62L23.66 12h-3.07l4.04-3.22.37-.31V3h-2v4.53l-3.13 2.5A3.94 3.94 0 0 0 19 8.41V5h-2v2.16A4.05 4.05 0 0 0 16 7c-.34 0-.68.07-1 .16V5h-2v3.4a4.1 4.1 0 0 0-.88 1.63L9 7.53V3Zm9 6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm0 6c1.23 0 2.27.3 2.94.78C19.6 16.27 20 16.9 20 18s-.51 2.75-1.31 4-1.82 2-2.69 2c-.87 0-1.89-.75-2.69-2A8.32 8.32 0 0 1 12 18c0-1.1.4-1.73 1.06-2.22A5.1 5.1 0 0 1 16 15Z',
        'spinner-solid' => 'M16 3a3 3 0 1 0 0 6 3 3 0 0 0 0-6ZM8.94 6.44a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm14.12 1.5a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM6 13.75a2.25 2.25 0 1 0 0 4.5 2.25 2.25 0 0 0 0-4.5Zm20 1a1.25 1.25 0 1 0 0 2.5 1.25 1.25 0 0 0 0-2.5ZM8.94 21.06a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm14.12.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM16 24.25a1.75 1.75 0 1 0 0 3.5 1.75 1.75 0 0 0 0-3.5Z',
        'splotch-solid' => 'M17.38 4.92a3.84 3.84 0 0 0-2.78 1.23l-1.94 2.3c-.37.4-.93.6-1.6.55h-3.1a4 4 0 0 0-3.7 2.14 3 3 0 0 0 .45 3.28l2 2.06c.27.33.36.6.1 1.13l-1.43 2.52a3.2 3.2 0 0 0 .4 3.44 3.88 3.88 0 0 0 3.92 1.28l2.88-.78c.58-.13 1.18 0 1.65.37l2.5 1.8a3.86 3.86 0 0 0 4.01.48 3.4 3.4 0 0 0 2.1-2.87l.2-2.78c.03-.46.33-.88.84-1.15l2.27-1.39a3.36 3.36 0 0 0 1.84-3.2c-.1-1.35-1-2.49-2.36-2.98l-2.88-1.03a1.51 1.51 0 0 1-1-1.03l-.7-2.72a3.52 3.52 0 0 0-2.62-2.53c-.35-.09-.7-.13-1.05-.12zm.11 2c.16 0 .31.03.45.06.6.15 1.04.56 1.18 1.08l.68 2.72a3.54 3.54 0 0 0 2.27 2.42l2.88 1.04c.61.21 1 .68 1.04 1.23.04.54-.24 1.01-.83 1.33l-2.27 1.38a3.41 3.41 0 0 0-1.84 2.74l-.2 2.79c-.06.73-.66 1.07-.92 1.18-.52.23-1.3.3-2-.24l-2.5-1.81a3.89 3.89 0 0 0-3.33-.7l-2.88.77c-.87.2-1.55-.2-1.87-.59-.19-.23-.46-.72-.2-1.26l1.44-2.52a2.95 2.95 0 0 0-.38-3.39l-2-2.05a.98.98 0 0 1-.15-1.1c.22-.46.85-1 1.9-1h3.02c1.19.1 2.37-.35 3.17-1.22l1.94-2.3c.4-.44.93-.58 1.4-.56z',
        'spotify' => 'M16 4a12 12 0 1 0 0 24 12 12 0 0 0 0-24Zm0 2c5.55 0 10 4.45 10 10s-4.45 10-10 10S6 21.55 6 16 10.45 6 16 6Zm-1.6 4.75c-1.94 0-3.63.18-5.24.69-.43.08-.79.4-.79 1s.44 1.11 1.04 1.03c.25 0 .42-.1.59-.1 1.36-.33 2.88-.5 4.4-.5 2.97 0 6 .67 8.04 1.85.25.08.34.19.6.19.59 0 1-.44 1.09-1.04 0-.5-.26-.83-.6-1-2.54-1.43-5.9-2.12-9.12-2.12Zm-.28 3.72c-1.77 0-3.04.25-4.3.6-.43.16-.66.42-.66.93 0 .42.33.84.84.84.17 0 .25 0 .5-.09.93-.25 2.2-.4 3.56-.4 2.8 0 5.23.67 7 1.77.17.1.34.16.6.16.5 0 .84-.43.84-.94a.91.91 0 0 0-.5-.84c-2.2-1.36-5-2.03-7.88-2.03Zm.29 3.65c-1.44 0-2.8.17-4.16.5-.34.1-.6.33-.6.75 0 .34.27.7.7.7.08 0 .33-.1.5-.1 1.1-.26 2.28-.4 3.46-.4 2.12 0 4.05.5 5.66 1.43.17.09.36.16.53.16a.8.8 0 0 0 .75-.6c0-.42-.18-.58-.44-.75a12.47 12.47 0 0 0-6.4-1.68Z',
        'spray-can-solid' => 'M12 2v6h2v1.06c-4.1.44-5.88 3.47-5.88 3.47l-.12.22V30h14V12.75l-.13-.22S20.1 9.5 16 9.06V8h2V2Zm12 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM14 4h2v2h-2Zm7 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-9 5c1.74 0 2.91.48 3.69 1H11.3c.78-.52 1.95-1 3.69-1Zm-5 3h10v14H10Zm5 4c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'square-full-solid' => 'M6 6v20h20V6H6z',
        'square-root-alt-solid' => 'm19.31 6-.25.66-6.15 16.06-3-6.16-.29-.56H6v2h2.38L12 25.44l.28.56h1.5l.25-.66L20.7 8H26V6Z',
        'square-solid' => 'M6 6v20h20V6H6z',
        'square' => 'M6 6v20h20V6Zm2 2h16v16H8Z',
        'squarespace' => 'M12.94 6a2.4 2.4 0 0 0-1.7.7l-.01.01-5.82 5.82a4.83 4.83 0 0 0 6.83 6.82l7.67-7.67a1.2 1.2 0 1 0-1.7-1.7l-7.68 7.66a2.4 2.4 0 0 1-4.11-1.7c0-.62.23-1.24.7-1.7l7.53-7.53a2.42 2.42 0 0 0-1.7-.71zm6.12 0a4.8 4.8 0 0 0-3.41 1.41L7.97 15.1a1.2 1.2 0 0 0 0 1.7c.47.47 1.24.47 1.71 0l7.67-7.67a2.4 2.4 0 0 1 3.41 0c.24.24.54.35.86.35.3 0 .62-.1.85-.35a1.2 1.2 0 0 0 0-1.7A4.83 4.83 0 0 0 19.06 6zm5.12 5.23c-1.24 0-2.48.48-3.42 1.42l-7.67 7.67a1.21 1.21 0 0 0 0 1.7 1.2 1.2 0 0 0 1.7 0l7.68-7.67a2.41 2.41 0 1 1 3.41 3.42l-7.53 7.52c.94.94 2.47.94 3.41 0l5.83-5.82a4.83 4.83 0 0 0-3.41-8.24zm0 3.63c-.31 0-.62.12-.86.35l-7.67 7.67c-.94.94-2.47.94-3.41 0h-.01a1.2 1.2 0 0 0-2.05.86c0 .3.12.62.35.85a4.8 4.8 0 0 0 6.82 0l7.68-7.68a1.2 1.2 0 0 0-.85-2.05z',
        'stack-exchange' => 'M9 4C6.8 4 5 5.8 5 8v14c0 2.2 1.8 4 4 4h8v4.22h1.56l.32-.31L22.55 26H23c2.2 0 4-1.8 4-4V8c0-2.2-1.8-4-4-4Zm0 2h14c1.12 0 2 .88 2 2v1H7V8c0-1.12.88-2 2-2Zm-2 5h18v3H7Zm0 5h18v3H7Zm0 5h18v1c0 1.12-.88 2-2 2h-1.31l-.28.31L19 26.84V24H9c-1.12 0-2-.88-2-2Z',
        'stack-overflow' => 'm19.6 2.84-1.63 1.13 5.6 8.22 1.62-1.13Zm-4.23 3.7-1.3 1.5 7.5 6.5 1.3-1.5Zm-3 4.37-.9 1.78 8.84 4.5.9-1.78Zm-1.71 4.53-.44 1.94 9.65 2.28.44-1.94ZM6 18v11h18V18h-2v9H8v-9Zm4.1 1.69-.13 2 9.9.56.13-2ZM10 23v2h9.94v-2Z',
        'stackpath' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm3.78 6c-1 0-2.24.46-2.24 1.64 0 .83.4 1.34 2.17 1.9.74.26.93.44.93.83 0 .65-.8.61-.83.61-.87 0-1.1-.4-1.1-.94H8.4v.03C8.35 18.41 9.6 19 10.8 19c1.28 0 2.19-.58 2.19-1.64 0-.91-.52-1.48-2-1.92-.88-.31-1.1-.46-1.1-.79s.29-.63.86-.63c.6 0 .89.36.89.8h1.31l.01-.04c.02-.84-.64-1.78-2.2-1.78zm3.22.04v5.92h1.38v-2.03h.84c1.3 0 2.28-.69 2.28-1.95 0-1.08-.79-1.94-2.28-1.94H14zm6.21 0-2.05 5.92h1.28l2.1-5.92H20.2zm2.46 0-2.05 5.92h1.28l2.1-5.92h-1.33zm-7.29 1.06h.84c.73 0 .91.52.91.9 0 .35-.18.88-.9.88h-.85V14.1z',
        'stamp-solid' => 'M16 2.9a5.94 5.94 0 0 0-5.94 5.94c0 1.95.9 3.33 1.66 4.38.75 1.05 1.28 1.77 1.28 2.81v3.19l-8.22 1.81-.78.16V26h1v1c0 .57.25 1.12.66 1.47.4.35.91.53 1.43.53h17.82c.52 0 1.03-.18 1.43-.53.4-.35.66-.9.66-1.47v-1h1v-4.81l-.78-.16L19 19.22v-3.19c0-1.04.53-1.76 1.28-2.81s1.66-2.43 1.66-4.38A5.94 5.94 0 0 0 16 2.91Zm0 2c2.2 0 3.94 1.75 3.94 3.94 0 1.36-.56 2.2-1.28 3.22-.73 1.02-1.66 2.23-1.66 3.97V19h-2v-2.97c0-1.74-.93-2.95-1.66-3.97-.72-1.02-1.28-1.86-1.28-3.22A3.9 3.9 0 0 1 16 4.91ZM14 21h4l8 1.78V24H6v-1.22Zm-7 5h18v.97c-.01 0-.03.03-.1.03H7.1c-.07 0-.09-.02-.1-.03Z',
        'star-and-crescent-solid' => 'M14.5 4C8.14 4 3.03 9.41 3.03 16S8.14 28 14.5 28c3.87 0 6.48-1.55 8.44-3.4l-.69-.73-.5-.87c-1.16.68-2.21 1-4.75 1-4.43 0-8-3.34-8-8s3.58-8 8-8c2.15 0 3.64.34 4.72.94l.22-.4.06-.07-.25.47.06.03.5-.85.72-.71C21.03 5.52 18.18 4 14.5 4Zm0 2c.46 0 .89.04 1.31.1A9.9 9.9 0 0 0 7 16a9.9 9.9 0 0 0 8.84 9.9c-.42.05-.86.1-1.34.1-5.22 0-9.47-4.44-9.47-10S9.28 6 14.5 6Zm11.1 5-2.16 3.1-3.4-1.22L22.12 16 20 19.06l3.44-1.15L25.56 21v-3.81L29 16l-3.44-1.19Z',
        'star-half-alt-solid' => 'm16 2.38-.9 2.03-3.26 7.3-7.93.82-2.25.25 1.68 1.5 5.91 5.35-1.66 7.8-.46 2.2h.03l1.93-1.13L16 24.53l6.9 3.97 1.98 1.13-.47-2.2-1.66-7.8 5.9-5.35 1.7-1.5-2.26-.25-7.93-.81L16.9 4.4Zm0 4.9 2.56 5.78.25.5.57.06 6.3.66-4.71 4.25-.44.38.13.56 1.3 6.19-5.46-3.16-.5-.28Z',
        'star-half-solid' => 'm16 2.13-4.16 9.34-10.18 1.08 7.6 6.84-2.12 10L16 24.3Z',
        'star-half' => 'm16 2.13-4.16 9.34-10.18 1.08 7.6 6.84-2.12 10L16 24.3Z',
        'star-of-david-solid' => 'm16 2.06-.84 1.4L11.78 9H3.31l.9 1.53L7.54 16l-3.31 5.47-.9 1.53h8.46l3.38 5.53.84 1.4.84-1.4L20.22 23h8.56l-.94-1.53L24.5 16l3.34-5.47.94-1.53h-8.56l-3.38-5.53Zm0 3.85L17.88 9h-3.75ZM6.87 11h3.72l-1.87 3.06Zm6.04 0h6.21l3.04 5-3.04 5h-6.21l-3-5Zm8.53 0h3.78l-1.88 3.1Zm1.9 6.9 1.88 3.1h-3.78Zm-14.62.04L10.59 21H6.88Zm5.4 5.06h3.76L16 26.1Z',
        'star-of-life-solid' => 'M13 4v6.8L7.1 7.4l-3 5.2L10 16l-5.9 3.4 3 5.2 5.9-3.4V28h6v-6.8l5.9 3.4 3-5.2L22 16l5.9-3.4-3-5.2-5.9 3.4V4h-6zm2 2h2v8.27l7.16-4.14 1 1.74L18 16l7.16 4.13-1 1.74L17 17.73V26h-2v-8.27l-7.16 4.14-1-1.74L14 16l-7.16-4.13 1-1.74L15 14.27V6z',
        'star-solid' => 'm30.34 12.55-10.18-1.08L16 2.13l-4.16 9.34-10.18 1.08 7.6 6.84-2.12 10L16 24.3l8.86 5.1-2.12-10Z',
        'star' => 'm16 2.13-.9 2.06-3.26 7.28-7.93.84-2.25.25 1.68 1.5 5.91 5.35-1.66 7.8-.46 2.2 1.96-1.13 6.91-4 6.9 4 1.98 1.13-.47-2.2-1.66-7.8 5.9-5.35 1.7-1.5-2.26-.25-7.93-.84-3.25-7.28Zm0 4.9 2.56 5.78.25.53.57.07 6.28.65-4.7 4.22-.43.4.13.57 1.3 6.16-5.46-3.13-.5-.31-.5.31-5.47 3.13 1.31-6.16.13-.56-.44-.4-4.69-4.23 6.29-.65.56-.07.25-.53Z',
        'staylinked' => 'M16.05 4a.63.63 0 0 0-.48.17l-9.4 7.57c-.2.15-.22.4-.06.57l1.92 1.95 7.81 7.72a.5.5 0 0 0 .65.02l2.29-1.81-.02-.02.35-.28c.2-.15.21-.4.04-.57l-2.6-2.54c-.16-.17-.45-.17-.64-.02a.5.5 0 0 1-.65-.02l-4.3-4.3c-.17-.15-.15-.4.05-.56l4.19-3.34a.48.48 0 0 1 .63.02l7.3 7.43a.5.5 0 0 0 .64.03l2.08-1.68c.19-.15.2-.4.03-.57l-9.57-9.65a.54.54 0 0 0-.26-.11zm-.56 5.85a.5.5 0 0 0-.32.1L12.57 12c-.2.15-.22.4-.06.57l3.1 3c.16.17.45.18.64.03a.49.49 0 0 1 .64.02l3.82 3.8c.16.16.14.42-.04.57l-4.24 3.46a.5.5 0 0 1-.65-.02l-6.9-6.9c-.16-.16-.45-.17-.64-.02l-2.08 1.63a.37.37 0 0 0-.05.57l9.49 9.17s.33.32.78-.04l9-7.66c.19-.15.2-.4.04-.57l-2.02-1.93-7.6-7.7a.44.44 0 0 0-.3-.12z',
        'steam-square' => 'M5 5v11l3.81 1.6a3.99 3.99 0 0 1 3.06-1.6l2.16-3.25a5 5 0 1 1 5.22 5.22L16 20.13A4 4 0 0 1 8 20c0-.2.04-.38.06-.56L5 18.16V27h22V5Zm14 5a3 3 0 0 0 0 6 3 3 0 0 0 0-6Zm0 1a2 2 0 0 1 2 2 2 2 0 0 1-2 2 2 2 0 0 1-2-2c0-1.1.9-2 2-2Zm-7 7a2 2 0 0 0-1.22.4l1.6.66c.5.21.77.8.56 1.32-.16.38-.55.62-.94.62a.9.9 0 0 1-.38-.06l-1.59-.69A2 2 0 0 0 12 22a2 2 0 1 0 0-4Z',
        'steam-symbol' => 'M22 6a6 6 0 0 0-6 5.84l-3.66 5.24a4.5 4.5 0 0 0-3.4.72L4 15.84v5.38l3.1 1.23a4.5 4.5 0 0 0 8.82-.14l5.77-4.33.31.02a6 6 0 0 0 0-12zm0 2a4 4 0 1 1 0 8 4 4 0 0 1 0-8zm0 1a3 3 0 0 0 0 6 3 3 0 0 0 0-6zm-10.5 9a3.5 3.5 0 1 1-3.19 4.93l2.27.9a2.48 2.48 0 0 0 3.24-1.4 2.5 2.5 0 0 0-1.4-3.25l-2.28-.9c.42-.18.88-.28 1.36-.28z',
        'steam' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 0 1 0 22 11 11 0 0 1-10.63-8.23l3.66 1.57A2.99 2.99 0 0 0 15 20l-.01-.1 4.18-2.92a4 4 0 1 0-4.15-4.15l-2.93 4.18L12 17c-.66 0-1.27.22-1.77.59l-5.2-2.23A11 11 0 0 1 16 5zm3 5a3 3 0 1 1 0 6 3 3 0 0 1 0-6zm0 1a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-7 7a2 2 0 1 1-1.82 2.83l.79.33c.19.09.39.13.59.13a1.5 1.5 0 0 0 .59-2.88l-.73-.31c.18-.06.38-.1.58-.1z',
        'step-backward-solid' => 'M8 5v22h2V16.5l.44.31 13 9 1.56 1.1V5.09l-1.56 1.1-13 9-.44.31V5Zm15 3.9v14.2L12.75 16Z',
        'step-forward-solid' => 'M22 5v10.5l-.44-.31-13-9L7 5.09v21.82l1.56-1.1 13-9 .44-.31V27h2V5ZM9 8.9 19.25 16 9 23.1Z',
        'stethoscope-solid' => 'M7 4c-.79 0-1.46.46-1.78 1.13A3.01 3.01 0 0 0 3 8v9.38l.25.28S5.61 20.4 9 20.9V23c0 3.3 2.7 6 6 6s6-2.7 6-6v-5c0-1.12.88-2 2-2s2 .88 2 2v.19A3 3 0 0 0 23 21c0 1.64 1.36 3 3 3s3-1.36 3-3c0-1.3-.84-2.4-2-2.81V18c0-2.2-1.8-4-4-4s-4 1.8-4 4v5c0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4v-2.1c3.4-.49 5.75-3.24 5.75-3.24l.25-.29V8c0-1.37-.95-2.52-2.22-2.88C14.46 4.46 13.78 4 13 4a2 2 0 1 0 1.6 3.19A1 1 0 0 1 15 8v8.56c-.36.37-2.49 2.44-5 2.44s-4.64-2.07-5-2.44V8a1 1 0 0 1 .4-.81A2 2 0 1 0 7 4Zm19 16c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Z',
        'sticker-mule' => 'M26.23 5c-.15 0-.51 1.03-.7 1.07-.23.06-1.17-.47-3.14.75-1.05.55-3.62 2.72-3.62 2.72-.28.2-.83.2-1.48.67-1.85 1.26-4.57.44-4.61.42-4.61-1.11-5.34-.63-6.63.48-.86.75-.98 1.52-1 1.62-.18.85.21 2.02.27 2.68.08.8-.1.7.32 4.05.03.04.18 0 .22.06 0 .35-.16.5-.17.54-.07.2-.07.44 0 .67a12 12 0 0 1 .34 1.92c0 1.74.02 1.83.1 2.06.17.41.53.37.71.5.13.14-.02.35.05.52.02.08.15.16.25.2.39.16 1.13.02 1.25-.1.07-.06.02-.19.13-.2.21 0 .45-.03.6-.11.21-.1.17-.25.06-.44-.02-.03-.3-.55-.4-.67-.1-.08-.22-.12-.3-.18-.25-.2-.44-.81-.44-.81a5.81 5.81 0 0 1-.17-2.75c.2-.72 1.65-3.65 1.65-3.66.17-.27.71-.48 1.14-.29.25.08.8.77 2.72 1.14 2 .36 4.06-.08 4.68-.08.12.08-.08.69-.02 1.77 0 1.1-.02.57-.17 1.24-.1.4.14.97-.07 1.96-.05.4-.4 1.03-.34 1.47.02.04.05.08.07.15.02.18.06.35.19.42.3.15.5-.15.4.47-.02.13-.1.5.07.63.18.15 1.27.14 1.52.02.1-.06.06-.19.26-.3.08-.05.48-.03.48-.28a6.3 6.3 0 0 0-.4-.83c-.1-.15-.37-.19-.46-.34-.29-.42-.07-1.86.02-2.14.12-.46.23-.93.36-1.35.46-1.77.43-2.1.69-2.84.03-.08.27-.97.43-1.25.38-.7.9-1.35 1.4-1.97.74-.96 1.4-1.96 2.16-2.91.25-.3.34-.57.75-.33.45.23.9.29 1.33.7.6.54.42.76.5.96.05.2.31.43.61.4l.56-.11c.1-.02.24-.2.3-.33.13-.23.3-.38.3-.7 0-.32-.02-.11-.86-2.2-.32-.93-.21-.3-.56-1.54-.06-.27-.15-.6-.25-.83-.19-.36-.2-.31-.2-.4 0-.22 1.28-1.88.8-1.95-.24-.02-.51.48-.86.7-.36.18-.34.22-.43.22-.1 0-.24-.13-.26-.21-.08-.24.08-1.08-.15-1.08z',
        'sticky-note-solid' => 'M5 5v22h15.4l.32-.28 6-6 .28-.31V5Zm2 2h18v12h-6v6H7Zm14 14h2.56L21 23.56Z',
        'sticky-note' => 'M5 5v22h15.4l.32-.28 6-6 .28-.31V5Zm2 2h18v12h-6v6H7Zm14 14h2.56L21 23.56Z',
        'stop-circle-solid' => 'M16 3C8.85 3 3 8.85 3 16s5.85 13 13 13 13-5.85 13-13S23.15 3 16 3zm0 2c6.05 0 11 4.95 11 11s-4.95 11-11 11S5 22.05 5 16 9.95 5 16 5zm-5 6v10h10V11H11zm2 2h6v6h-6v-6z',
        'stop-circle' => 'M16 3C8.85 3 3 8.85 3 16s5.85 13 13 13 13-5.85 13-13S23.15 3 16 3zm0 2c6.05 0 11 4.95 11 11s-4.95 11-11 11S5 22.05 5 16 9.95 5 16 5zm-5 6v10h10V11H11zm2 2h6v6h-6v-6z',
        'stop-solid' => 'M6 6v20h20V6Zm2 2h16v16H8Z',
        'stopwatch-solid' => 'M13 4v2h6V4Zm3 3C9.94 7 5 11.94 5 18s4.94 11 11 11a11.02 11.02 0 0 0 8-18.56l1.72-1.72-1.44-1.44-1.81 1.81A10.97 10.97 0 0 0 16 7Zm0 2a8.99 8.99 0 1 1 0 18 8.99 8.99 0 1 1 0-18Zm-1 2v5.28a1.98 1.98 0 0 0 0 3.44V21h2v-1.28a1.98 1.98 0 0 0 0-3.44V11Z',
        'store-alt-solid' => 'M4 4v3.66l-3 4V12c0 1.64 1.36 3 3 3v13h16v-9h2v9h6V15c1.64 0 3-1.36 3-3v-.34l-3-4V4Zm2 2h20v1H6Zm-.5 3h21l2.4 3.22c-.1.43-.43.78-.9.78a1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1H9a1 1 0 0 1-1 1 1 1 0 0 1-1-1H5a1 1 0 0 1-1 1c-.47 0-.8-.35-.9-.78Zm.5 5.22a2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0V26h-2v-9h-6v9H6ZM8 17v7h8v-7Zm2 2h4v3h-4Z',
        'store-solid' => 'M4 4v3.66l-3 4V12c0 1.64 1.35 3 3 3v13h24V15c1.64 0 3-1.36 3-3v-.34l-3-4V4H4zm2 2h20v1H6V6zm-.5 3h21l2.4 3.22c-.1.43-.43.78-.9.78a1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1h-2a1 1 0 0 1-1 1 1 1 0 0 1-1-1H9a1 1 0 0 1-1 1 1 1 0 0 1-1-1H5a1 1 0 0 1-1 1c-.47 0-.8-.35-.9-.78L5.5 9zm.5 5.22a2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0 2.97 2.97 0 0 0 4 0V21H6v-6.78zM6 23h20v3H6v-3z',
        'strava' => 'M14.18 2 5.9 18h4.88l3.4-6.38L17.56 18h4.84L14.18 2zm8.22 16L20 22.79 17.56 18h-3.7L20 30l6.1-12h-3.7z',
        'stream-solid' => 'M5 5v6h19V5H5zm2 2h15v2H7V7zm2 6v6h19v-6H9zm2 2h15v2H11v-2zm-6 6v6h19v-6H5zm2 2h15v2H7v-2z',
        'street-view-solid' => 'M16 4a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 11 15v4.63l2 1V25h6v-4.38l2-1V15c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 16 4Zm0 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm0 6c1.67 0 3 1.33 3 3v3.38l-2 1V23h-2v-3.63l-2-1V15c0-1.67 1.33-3 3-3Zm-7 6.88c-2.92.81-5 2.2-5 4.12 0 3.28 6.04 5 12 5s12-1.72 12-5c0-1.93-2.08-3.3-5-4.13v2.1c1.9.61 3 1.4 3 2.03 0 1.2-3.99 3-10 3S6 24.2 6 23c0-.63 1.1-1.42 3-2.03Z',
        'strikethrough-solid' => 'M7 6v2h8v8h-5v2h5v8h2v-8h5v-2h-5V8h8V6Z',
        'stripe-s' => 'M16.52 4C10.74 4 7 7.11 7 11.93c0 4.78 4.29 6.2 7.13 7.14 1.27.42 2.86.95 2.87 1.47 0 .4-.96.46-1.52.46-1.89 0-4.78-.78-7.04-1.9L7 18.4v7.8l.61.25c2.35.99 5.1 1.55 7.54 1.56 6.17 0 9.85-2.84 9.85-7.6 0-5.2-4.4-6.6-7.32-7.54-1.07-.34-2.68-.85-2.68-1.29 0-.22 0-.57 1.23-.57 1.85 0 4.42.77 6.26 1.86l1.51.9V5.55l-.64-.25A19.37 19.37 0 0 0 16.52 4zm0 2c1.8 0 3.72.33 5.48.93v3.43A15.15 15.15 0 0 0 16.23 9C13.32 9 13 10.8 13 11.57c0 1.9 1.98 2.53 4.07 3.2C20.54 15.88 23 16.93 23 20.4c0 5.05-5.49 5.6-7.84 5.6-1.98 0-4.2-.42-6.16-1.16v-3.3c2 .8 4.47 1.46 6.48 1.46 3.05 0 3.52-1.53 3.52-2.46 0-1.96-2.07-2.65-4.24-3.37C11.39 16.05 9 15.02 9 11.93 9 8.27 11.88 6 16.52 6z',
        'stripe' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22c.57 0 1 .43 1 1v14c0 .57-.43 1-1 1H5c-.57 0-1-.43-1-1V9c0-.57.43-1 1-1Zm11.5 3.44a.84.84 0 0 0-.84.84.84.84 0 1 0 1.69 0 .84.84 0 0 0-.85-.84Zm-5.44.75-1.37.22-.19 1.21-.5.1-.19 1.12h.69v2.35c0 .6.15 1.02.47 1.28.26.21.65.31 1.19.31.41 0 .66-.08.84-.12V17.4c-.1.02-.32.06-.47.06-.32 0-.47-.16-.47-.53v-2.1h.85l.18-1.21h-1.03Zm-4.15 1.34c-.55 0-1.02.14-1.35.4-.34.28-.5.7-.5 1.2 0 .88.53 1.24 1.4 1.56.58.2.76.34.76.56 0 .21-.17.34-.5.34-.41 0-1.1-.2-1.53-.46L5 18.34a4 4 0 0 0 1.81.44 2.2 2.2 0 0 0 1.38-.37c.36-.29.56-.74.56-1.29 0-.9-.55-1.27-1.44-1.59-.47-.17-.75-.28-.75-.5 0-.18.14-.31.4-.31.5 0 1 .2 1.35.37l.19-1.21a3.7 3.7 0 0 0-1.6-.35Zm13.8 0c-.46 0-.89.22-1.27.63l-.07-.54h-1.43v6.94l1.62-.28v-1.6c.25.09.5.1.72.1.4 0 .99-.1 1.44-.6.43-.47.66-1.18.66-2.15 0-.85-.15-1.52-.47-1.94a1.42 1.42 0 0 0-1.2-.56Zm4.23 0c-1.37 0-2.22 1.03-2.22 2.66 0 .9.2 1.6.66 2.03.4.39 1 .56 1.75.56.68 0 1.31-.14 1.71-.4l-.18-1.13c-.4.21-.86.34-1.38.34a1 1 0 0 1-.69-.21c-.16-.15-.25-.36-.28-.7h2.66l.03-.55c0-.81-.19-1.46-.53-1.91a1.83 1.83 0 0 0-1.53-.69Zm-9.94.03a.99.99 0 0 0-.97.69l-.1-.63h-1.4v5.07h1.63V15.4c.2-.25.48-.35.87-.35l.28.03v-1.5a1.28 1.28 0 0 0-.31-.03Zm.69.06v5.07h1.62v-5.07Zm9.22 1c.36 0 .56.35.59 1.07h-1.19c.05-.73.23-1.06.6-1.06Zm-4.75.16c.4 0 .62.42.62 1.28 0 .5-.07.9-.22 1.16-.13.24-.33.37-.56.37a.95.95 0 0 1-.44-.09v-2.4c.28-.3.5-.32.6-.32Z',
        'stroopwafel-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c.5 0 1 .05 1.47.11L16 6.6l-1.47-1.5A11 11 0 0 1 16 5zm-3.74.67L14.59 8 12 10.59 8.97 7.55a11 11 0 0 1 3.29-1.88zm7.48 0a11 11 0 0 1 3.3 1.88L20 10.6 17.41 8l2.33-2.33zM7.55 8.97 10.6 12 8 14.59l-2.33-2.33a11 11 0 0 1 1.88-3.3zm16.9 0a11 11 0 0 1 1.88 3.29L24 14.59 21.41 12l3.04-3.03zM16 9.4l2.59 2.6L16 14.59 13.41 12 16 9.41zm-4 4 2.59 2.6L12 18.59 9.41 16 12 13.41zm8 0 2.59 2.6L20 18.59 17.41 16 20 13.41zM5.11 14.53 6.6 16l-1.5 1.47a11 11 0 0 1 0-2.94zm21.78 0a11 11 0 0 1 0 2.94L25.4 16l1.48-1.47zM8 17.4l2.59 2.6-3.04 3.03a11 11 0 0 1-1.88-3.29L8 17.41zm8 0 2.59 2.6L16 22.59 13.41 20 16 17.41zm8 0 2.33 2.33a11 11 0 0 1-1.88 3.3L21.4 20l2.6-2.59zm-12 4 2.59 2.6-2.33 2.33a11 11 0 0 1-3.3-1.88L12 21.4zm8 0 3.03 3.04a11 11 0 0 1-3.29 1.88L17.41 24 20 21.41zm-4 4 1.47 1.48a11 11 0 0 1-2.94 0L16 25.4z',
        'studiovinari' => 'm3.59 3 5.14 5.48L3 7.56l8.33 6.25-4.16.53L16 17l-1 1 6.57-1.21-.75 3.47-2.88 2.62-4.49 2.3-1.05-.66-.35.27L11 28.53l.33-.07 1.16-1.42 2.84-1.87 4.7-1.32-3.4 1.96-1.02-.04c-.11 0-1 3.23-1 3.23l.5-.2.39-.61.9-1.25 4.01-1.92 2.85-3.42 2.02-3.98 1.28-2.24v-1.43l-.21-1.42-.54-1.21.53-1.03.66-.37-.43-.62.35-.31-.58-.21-1.48-1.26-1.92.53-.22 1.92 1.07.83-.61.46-5.48-4.9 2.18 2.84L10 3l2.3 4.28 2.52.92-.95-1.95 7.28 5.03-6.32-3.78 1.6 1.93L3.6 3z',
        'stumbleupon-circle' => 'M16 4C9.4 4 4 9.4 4 16s5.4 12 12 12 12-5.4 12-12S22.6 4 16 4Zm0 7c-.6 0-1 .4-1 1v6c0 1.7-1.3 3-3 3s-3-1.3-3-3v-2h2v2c0 .6.4 1 1 1s1-.4 1-1v-6c0-1.7 1.3-3 3-3s3 1.3 3 3v1c0 .6-.4 1-1 1s-1-.4-1-1v-1c0-.6-.4-1-1-1Zm7 7c0 1.7-1.3 3-3 3s-3-1.3-3-3v-2.3c.3.2.6.3 1 .3s.7-.1 1-.3V18c0 .6.4 1 1 1s1-.4 1-1v-2h2Z',
        'stumbleupon' => 'M16 4a7 7 0 0 0-7 7v9.5a1.5 1.5 0 0 1-3 0V16H1v4.5a6.5 6.5 0 0 0 13 0V11a2 2 0 0 1 4 0v1.92l1.89.88 3.11-.92V11a7 7 0 0 0-7-7zm10 12v4.5a1.5 1.5 0 0 1-3 0V16l-3.35 1-1.65-.77v4.27a6.5 6.5 0 0 0 13 0V16h-5z',
        'subscript-solid' => 'm4.16 8 1 1.53L9.3 16l-4.15 6.47-1 1.53h6.37l.31-.47 1.66-2.56 1.66 2.56.3.47h6.38l-1-1.53L15.7 16l4.15-6.47 1-1.53h-6.37l-.31.47-1.66 2.56-1.66-2.56-.3-.47Zm3.65 2h1.66l2.19 3.44.84 1.31.84-1.31 2.2-3.44h1.65l-3.53 5.47-.35.53.35.53L17.19 22h-1.66l-2.19-3.44-.84-1.31-.84 1.31L9.46 22H7.82l3.53-5.47.35-.53-.35-.53Zm17.16 9A2.99 2.99 0 0 0 22 21.97V22h2v-.03c0-.55.42-.97.97-.97h.06c.55 0 .97.42.97.97 0 .32-.14.6-.4.78l-2.13 1.47A3.39 3.39 0 0 0 22 27v1h6v-2h-3.47c.04-.03.02-.1.06-.13l2.13-1.46A2.95 2.95 0 0 0 28 21.97 2.99 2.99 0 0 0 25.03 19Z',
        'subway-solid' => 'M10 4C7.25 4 5 6.25 5 9v12a6.01 6.01 0 0 0 3.53 5.47L6 29h2.34l2.04-2.03c.2.02.41.03.62.03h10c.2 0 .43-.01.63-.03L23.66 29H26l-2.53-2.53A6.01 6.01 0 0 0 27 21V9c0-2.75-2.25-5-5-5Zm0 2h12a3 3 0 0 1 2.84 2H7.16A3 3 0 0 1 10 6Zm-3 4h8v6H7Zm10 0h8v6h-8ZM7 18h18v3c0 2.22-1.78 4-4 4H11c-2.22 0-4-1.78-4-4Zm3.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm11 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'suitcase-rolling-solid' => 'M14 3a3 3 0 0 0-3 3v3h2V6a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v3h2V6a3 3 0 0 0-3-3h-4zm-7 8v15h2v2h2v-2h10v2h2v-2h2V11H7zm2 2h14v11H9V13zm2 3v2h10v-2H11zm0 4v2h10v-2H11z',
        'suitcase-solid' => 'M14 3a2 2 0 0 0-2 2v1H9V5H7v1H5a2 2 0 0 0-2 2v16c0 1.1.9 2 2 2h22a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-2V5h-2v1h-3V5a2 2 0 0 0-2-2Zm0 2h4v1h-4ZM5 8h22v16h-2V9h-2v15H9V9H7v15H5Z',
        'sun-solid' => 'M15 3v5h2V3ZM7.5 6.1 6.1 7.5l3.53 3.56 1.43-1.44Zm17 0-3.56 3.53 1.43 1.43 3.54-3.56ZM16 9a7 7 0 1 0 .02 14.02A7 7 0 0 0 16 9Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10ZM3 15v2h5v-2Zm21 0v2h5v-2ZM9.62 20.94 6.1 24.5l1.41 1.4 3.56-3.52Zm12.76 0-1.44 1.43 3.56 3.54 1.4-1.41ZM15 24v5h2v-5Z',
        'sun' => 'M15 3v5h2V3ZM7.5 6.1 6.1 7.5l3.53 3.56 1.43-1.44Zm17 0-3.56 3.53 1.43 1.43 3.54-3.56ZM16 9a7 7 0 1 0 .02 14.02A7 7 0 0 0 16 9Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10ZM3 15v2h5v-2Zm21 0v2h5v-2ZM9.62 20.94 6.1 24.5l1.41 1.4 3.56-3.52Zm12.76 0-1.44 1.43 3.56 3.54 1.4-1.41ZM15 24v5h2v-5Z',
        'superpowers' => 'M29 3 14.88 5.06l-.9.13H14a11.01 11.01 0 0 0-5.77 18.58L3 29l14.12-2.06.9-.13H18a11.01 11.01 0 0 0 5.77-18.58L29 3zM16 7a9.01 9.01 0 0 1 0 18 9.01 9.01 0 0 1 0-18z',
        'superscript-solid' => 'M24.97 3A2.99 2.99 0 0 0 22 5.97V6h2v-.03c0-.55.42-.97.97-.97h.06c.55 0 .97.42.97.97 0 .32-.14.6-.4.78l-2.13 1.47A3.39 3.39 0 0 0 22 11v1h6v-2h-3.47c.04-.03.02-.1.06-.13l2.13-1.46A2.95 2.95 0 0 0 28 5.97 2.99 2.99 0 0 0 25.03 3ZM4.16 8l1 1.53L9.3 16l-4.15 6.47-1 1.53h6.37l.31-.47 1.66-2.56 1.66 2.56.3.47h6.38l-1-1.53L15.7 16l4.15-6.47 1-1.53h-6.37l-.31.47-1.66 2.56-1.66-2.56-.3-.47Zm3.65 2h1.66l2.19 3.44.84 1.31.84-1.31 2.2-3.44h1.65l-3.53 5.47-.35.53.35.53L17.19 22h-1.66l-2.19-3.44-.84-1.31-.84 1.31L9.46 22H7.82l3.53-5.47.35-.53-.35-.53Z',
        'supple' => 'M12.2 9C5.54 9.02.15 11.6.15 14.78c.01 1.9 1.87 3.58 4.85 4.62-1.6-1.07-2.48-2.41-2.48-3.86-.01-3.48 5.38-6.3 12.04-6.32l1.16.02C14.6 9.08 13.42 9 12.2 9zM27 12.63c1.59 1.06 2.48 2.4 2.48 3.86 0 3.47-5.39 6.29-12.05 6.29-.39 0-.78-.01-1.16-.03 1.11.16 2.29.25 3.52.25 6.66 0 12.06-2.58 12.06-5.75 0-1.9-1.88-3.58-4.85-4.62zM7.85 14c-.75 0-1.29.46-1.29 1.1 0 1.18 1.81 1.14 1.81 1.78 0 .3-.26.46-.55.46-.54 0-.94-.46-.94-.46l-.39.49s.47.6 1.32.6c.8 0 1.27-.52 1.27-1.14 0-1.25-1.8-1.12-1.8-1.78 0-.24.24-.4.56-.4.25 0 .5.11.5.29v.18h.64v-.36c0-.54-.69-.76-1.13-.76zm14.67.05v.61h.35v2.88c0 .26.1.37.37.37h1.74c.26 0 .37-.11.37-.37v-.59h-.64v.23c0 .08-.05.12-.12.12h-.88c-.08 0-.12-.05-.12-.12v-.9h1.24v-.6H23.6v-1.02h.86c.07 0 .12.05.12.12v.23h.64v-.58c0-.26-.11-.38-.37-.38h-2.32zm-2.85.01v.6h.24c.07 0 .12.05.12.12v2.75h-.01c0 .27.1.38.37.38h1.69c.26 0 .37-.11.37-.38v-.58h-.64v.23c0 .08-.05.12-.12.12h-.84c-.08 0-.11-.05-.11-.12v-2.75c0-.26-.11-.37-.38-.37h-.69zm-10.06 0v2.48c0 .85.6 1.43 1.52 1.43.9 0 1.5-.58 1.5-1.43v-2.48h-.7v2.45c0 .5-.32.8-.8.8-.49 0-.8-.3-.8-.8v-2.45H9.6zm3.51 0v.6h.35v3.25h.7v-1.33h.7c.72 0 1.23-.52 1.23-1.27s-.5-1.25-1.22-1.25h-1.76zm3.27 0v.6h.36v3.25h.7v-1.33h.7c.72 0 1.22-.52 1.22-1.27s-.5-1.25-1.21-1.25h-1.77zm9.02 0v.06h.11v.26h.08v-.26h.11v-.06h-.3zm.37 0v.32h.07v-.25l.1.25h.06l.1-.25v.25h.07v-.32h-.1l-.1.23-.1-.23h-.1zm-11.6.6h.58c.4 0 .62.26.62.65 0 .4-.23.66-.63.66h-.57v-1.3zm3.27 0h.58c.39 0 .62.26.62.65 0 .4-.23.66-.63.66h-.57v-1.3z',
        'surprise-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 5c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5Zm9 0c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5ZM16 17c-2.3 0-4 1.86-4 4 0 .99.36 1.97 1.16 2.47.8.5 1.68.53 2.84.53s2.04-.04 2.84-.53c.8-.5 1.16-1.48 1.16-2.47 0-2.14-1.7-4-4-4Zm0 2c1.3 0 2 .83 2 2 0 .67-.04.7-.19.78-.15.1-.76.22-1.81.22a4.92 4.92 0 0 1-1.81-.22c-.15-.09-.19-.11-.19-.78 0-1.17.7-2 2-2Z',
        'surprise' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm-4.5 5c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5Zm9 0c-.83 0-1.5 1.12-1.5 2.5s.67 2.5 1.5 2.5 1.5-1.12 1.5-2.5-.67-2.5-1.5-2.5ZM16 17c-2.3 0-4 1.86-4 4 0 .99.36 1.97 1.16 2.47.8.5 1.68.53 2.84.53s2.04-.04 2.84-.53c.8-.5 1.16-1.48 1.16-2.47 0-2.14-1.7-4-4-4Zm0 2c1.3 0 2 .83 2 2 0 .67-.04.7-.19.78-.15.1-.76.22-1.81.22a4.92 4.92 0 0 1-1.81-.22c-.15-.09-.19-.11-.19-.78 0-1.17.7-2 2-2Z',
        'suse' => 'M17.1 7c-4.65 0-10.73 3.79-10.73 8 0 2.27 1.86 4 4.13 4 1.73 0 3.03-1.28 3.03-2.69 0-1.3-.88-2.81-2.72-2.81-.43 0-1.94.3-1.94 1.81 0 1.08.86 1.63 1.5 1.63.98 0 1.1-.4 1.1-.63 0-.32-.2-.45-.53-.56-.22 0-.46.13-.56.13-.11 0-.44-.13-.44-.57 0-.43.46-.62 1-.62.86 0 1.37.85 1.37 1.5 0 .32-.1 1.5-1.72 1.5-1.18 0-2.59-.85-2.59-2.47s1.42-2.6 2.72-2.6c3.46 0 4 3.47 4 3.47l1.5.75s-.1-.53-.1-.96c0-1.41.65-1.97 1.94-1.97 1.95 0 2.71 1.64 3.47 2.4l1.94.85s-.97-1.29-.97-2.47c0-1.4 1.3-.78 3.03-.78 1.84 0 4.31-.41 4.31-1.82-.32 0-.98.63-2.06.63-.76-.22-2.69-1.19-2.9-1.19l-.44-.97c1.4.87 2.71 1.53 3.68 1.53.98 0 1.82-.78 1.82-.78-.87-3.13-.86-2.92-6.16-4v.88c-.22-.33-2.7-1.08-5.94-1.19Zm10.46 1.63c.76 0 1.4.64 1.4 1.4 0 .76-.64 1.4-1.4 1.4-.76 0-1.4-.64-1.4-1.4 0-.76.54-1.4 1.4-1.4Zm0 .68a.96.96 0 0 0-.97.97c0 .54.43.97.97.97s.97-.43.97-.97a.96.96 0 0 0-.97-.97Zm.22.4c.22 0 .44.14.44.35-.11.22-.22.31-.44.31-.21 0-.44-.1-.44-.3 0-.12.23-.35.44-.35ZM3.66 18.95c-.87 0-1.63.76-1.63 1.62V21c0 .86.64 1.4 1.5 1.4h1.63c.21 0 .43.12.43.44v.44c0 .22-.22.4-.43.4H2.12v.79c0 .32.24.53.57.53h2.69C6.24 25 7 24.24 7 23.37v-.65c0-.86-.53-1.28-1.5-1.28H3.97c-.33 0-.44-.13-.44-.35v-.3c0-.22.24-.45.56-.45h2.6v-.84c0-.32-.23-.56-.44-.56Zm12.5 0c-.87 0-1.63.76-1.63 1.62V21c0 .86.67 1.4 1.53 1.4h1.63c.21 0 .4.12.4.44v.44a.4.4 0 0 1-.4.4h-3.16v.79c0 .32.24.53.56.53h2.7c.85 0 1.62-.76 1.62-1.63v-.65c0-.86-.53-1.28-1.5-1.28h-1.63c-.32 0-.44-.13-.44-.35v-.3c0-.22.21-.45.54-.45h2.71v-.84a.55.55 0 0 0-.56-.56Zm6.06.12c-.86 0-1.63.76-1.63 1.63v2.68c0 .87.77 1.63 1.63 1.63h2.28c.32 0 .53-.2.53-.53v-.78h-2.6c-.32 0-.43-.2-.43-.4v-.79h3.13c.43 0 .87-.32.87-.75V20.7c0-.87-.76-1.63-1.63-1.63Zm.22 1.19h1.62c.22 0 .44.22.44.44v.62h-2.6c.12 0 .1-.62.1-.62 0-.22.22-.44.44-.44Zm-10 .22v.1c-.33 0-.53.2-.53.52v2.2c0 .32-.24.52-.57.52h-1.4c-.33 0-.53-.2-.53-.53V21.1c0-.32-.34-.53-.66-.53h-.22c-.32 0-.53.21-.53.53v2.29C8 24.45 8.66 25 9.84 25h.22c.54 0 .98-.22 1.4-.44.22-.1.34-.22.45-.22 0 0 .07.02.18.13l.35.44h.44c.32 0 .53-.35.53-.57V21c0-.32-.34-.53-.66-.53Z',
        'swatchbook-solid' => 'M5 5v18a4 4 0 0 0 8 0V5H5zm2 2h4v4H7V7zm11.9.44-4.4 4.4v2.83l4.4-4.4 2.83 2.83-7.23 7.23v2.83L24.55 13.1 18.9 7.44zM7 13h4v4H7v-4zm0 6h4v4a2 2 0 0 1-4 0v-4zm13.78 0-2 2H25v4H14.78l-1.9 1.89c-.03.04-.08.07-.13.11H27v-8h-6.22z',
        'swift' => 'M8.94 5A3.95 3.95 0 0 0 5 8.94v14.12A3.95 3.95 0 0 0 8.94 27h14.12A3.95 3.95 0 0 0 27 23.06V8.94A3.95 3.95 0 0 0 23.06 5Zm0 2h14.12C24.14 7 25 7.86 25 8.94v14.12c0 1.08-.86 1.94-1.94 1.94H8.94A1.92 1.92 0 0 1 7 23.06V8.94C7 7.86 7.86 7 8.94 7Zm8.69 2.5s2.5 3.16 1.21 6.72c0 0-4.5-3.2-6.78-5.5 0 0 2.83 4.1 3.85 4.94 0 0-1.7-.9-5.63-4.25 0 0 4.54 5.9 6.66 7.12 0 0-3.23 2.2-7.94-.9 0 0 2.46 4.37 7.69 4.37 2.35 0 3.05-1.22 4.22-1.22 1.2 0 1.93 1.22 1.93 1.22.71-1.73-1.06-3.69-1.06-3.69s2-4.63-4.16-8.81Z',
        'swimmer-solid' => 'M23.5 11a3.51 3.51 0 0 0-3.5 3.5c0 1.92 1.58 3.5 3.5 3.5s3.5-1.58 3.5-3.5-1.58-3.5-3.5-3.5Zm-9.78.03c-.36.02-.72.15-1.03.38L7.4 15.19l1.18 1.62 5.25-3.78 2.29 2.63-7.41 6.28a10.92 10.92 0 0 0 3.25-.13l5.44-4.65 2.03 2.34c.74-.2 1.5-.36 2.28-.44l-6.38-7.34a1.95 1.95 0 0 0-1.62-.69ZM23.5 13c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5-1.5-.66-1.5-1.5.66-1.5 1.5-1.5Zm-.5 7c-2.44 0-4.57.82-6.66 1.56-2.08.75-4.1 1.44-6.34 1.44-5.5 0-8.31-2.72-8.31-2.72L.3 21.72S3.81 25 10 25c2.64 0 4.9-.8 7-1.56 2.1-.76 4.02-1.44 6-1.44 3.97 0 7.34 2.78 7.34 2.78l1.32-1.56S27.87 20 23 20Z',
        'swimming-pool-solid' => 'M12 4a3 3 0 0 0-3 3v12.63l1-.72 1 .71V7a1 1 0 0 1 1-1h1V4Zm12 0a3 3 0 0 0-3 3v1h-9v2h9v2h-9v2h9v2h-9v2h9v1.63l1-.72 1 .71V7a1 1 0 0 1 1-1h1V4ZM10 20.72l-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-1.25 1.56S4.92 24 7.03 24c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c2.11 0 3.6-1.22 3.6-1.22l-1.25-1.56s-1 .78-2.35.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78Zm0 4-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-1.25 1.56S4.92 28 7.03 28c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c1.46 0 2.4-.48 2.97-.84a5.6 5.6 0 0 0 3.03.84c2.11 0 3.6-1.22 3.6-1.22l-1.25-1.56s-1 .78-2.35.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78l-.63-.5-.63.5s-1 .78-2.34.78c-1.34 0-2.4-.78-2.4-.78Z',
        'symfony' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm4.27 5.08c-.07 0-2.51-.14-3.94 4.06-.4-.32-2.23-2.51-4.26-1-.73.55-1.22 1.85-.12 3.08.65.7 1.03.97.86 1.53-.35 1.15-2.14.62-1.97.05.06-.17.14-.17.25-.5.3-.98-1.05-1.45-1.34-.52-.16.54.1 1.52 1.48 1.95 1.62.5 3-.39 3.2-1.54.12-.72-.2-1.26-.8-1.95l-.5-.54c-.29-.3-.39-.8-.09-1.18.26-.33.63-.47 1.23-.3.88.23 1.27.84 1.92 1.33-.05.16-.39 1.25-.7 3.16-.47 2.45-.82 3.79-1.75 4.56-.19.13-.45.33-.85.35-.08 0-.55-.11-.08-.49.59-.32.27-1.33-.58-1.3a.99.99 0 0 0-.93 1.02c.02.67.65 1.18 1.6 1.15.5-.02 1.64-.22 2.76-1.55 1.53-1.8 1.83-3.94 2.24-6.23 2 .23 2.98-.69 3-1.38.01-.93-1.09-.9-1.24-.2-.08.34.51.64.05.94-.32.22-.91.37-1.74.24.4-2.19.74-4.33 2.27-4.38.1 0 .49 0 .5.26 0 .2-.26.37-.25.72.01.4.32.67.76.65.59-.02.76-.6.75-.89-.03-.7-.76-1.13-1.73-1.1z',
        'synagogue-solid' => 'm16 4.66-.66.59L7.63 12H4v15h10v-4c0-1.12.88-2 2-2s2 .88 2 2v4h10V12h-3.63l-7.71-6.75ZM6 7c-.58.88-2 1-2 2.66 0 .92.66 1.34.66 1.34h2.68S8 10.58 8 9.66C8 7.92 6.66 7.85 6 7Zm20 0c-.58.88-2 1.5-2 2.66 0 .92.66 1.34.66 1.34h2.68s.66-.42.66-1.34C28 8.4 26.66 7.85 26 7Zm-10 .31 7.34 6.44.29.25H26v11h-6v-2c0-2.2-1.8-4-4-4s-4 1.8-4 4v2H6V14h2.38l.28-.25Zm0 4.16-.88 1.5h-1.71l.84 1.5-.84 1.5h1.71L16 17.5l.88-1.53h1.71l-.84-1.5.84-1.5h-1.71Z',
        'sync-alt-solid' => 'M16 4a11.9 11.9 0 0 0-11.13 7.63l1.85.74A9.9 9.9 0 0 1 23.94 10H20v2h7V5h-2v3.1A11.94 11.94 0 0 0 16 4Zm9.28 15.63A9.9 9.9 0 0 1 16 26a10 10 0 0 1-7.97-4H12v-2H5v7h2v-3.1c2.19 2.49 5.4 4.1 9 4.1a11.9 11.9 0 0 0 11.13-7.63Z',
        'sync-solid' => 'M16 4a11.9 11.9 0 0 0-11.13 7.63l1.85.74A9.9 9.9 0 0 1 23.94 10H20v2h7V5h-2v3.1A11.94 11.94 0 0 0 16 4Zm9.28 15.63A9.9 9.9 0 0 1 16 26a10 10 0 0 1-7.97-4H12v-2H5v7h2v-3.1c2.19 2.49 5.4 4.1 9 4.1a11.9 11.9 0 0 0 11.13-7.63Z',
        'syringe-solid' => 'm23.22 3.78-1.44 1.44.38.37-2.29 2.29 1.41 1.43L23.56 7 25 8.44l-2.31 2.28 1.43 1.4 2.29-2.28.37.38 1.44-1.44Zm-5.5 3.5-1.44 1.44.66.65L7 19.34l-.34.35.06.47.34 3.18.03.35.1.06L3.94 27h2.84l2.03-2.03 3.03.31.47.06.35-.34 9.96-9.94.66.66 1.44-1.44Zm.66 3.53 2.8 2.81-9.59 9.63-2.37-.28-.19-.19-.28-2.37Z',
        'table-solid' => 'M5 5v22h22V5Zm2 2h5v5H7Zm7 0h4v5h-4Zm6 0h5v5h-5ZM7 14h5v4H7Zm7 0h4v4h-4Zm6 0h5v4h-5ZM7 20h5v5H7Zm7 0h4v5h-4Zm6 0h5v5h-5Z',
        'table-tennis-solid' => 'M7 4C5.36 4 4 5.36 4 7s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm11.94.9a11.26 11.26 0 0 0-7.47 3.38c-1.24 1.23-2.26 3-2.6 6.28a.88.88 0 0 0-.03.1v.03l-.06.15v.19l.03.19.06.19c.06.9.18 1.81.5 2.68h-.03c.02.09.12.52.13.94 0 .32-.11.6-.13.69-.6.6-1.34 1.24-2.03 1.78-.69.54-1.29 1.01-1.72 1.44h-.03a2.33 2.33 0 0 0-.6 2.06c.16.7.56 1.3 1.1 1.84s1.15.94 1.85 1.1c.7.16 1.54-.05 2.09-.6.44-.43.86-1.05 1.4-1.75.55-.7 1.17-1.45 1.79-2.06-.07.07.23-.1.62-.1.32 0 .58.04.78.07l.2.03c.86.33 1.78.45 2.68.5l.03.03c.07.02.14.03.22.03l.1.04H18c.06 0 .13-.02.19-.04.04 0 .05-.02.1-.03h.02c3.01-.25 5.03-1.34 6.32-2.62a11.26 11.26 0 0 0 3.3-6.53 8.72 8.72 0 0 0-2.65-7.29 8.8 8.8 0 0 0-6.34-2.71ZM7 6c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm11.94.9a6.63 6.63 0 0 1 4.93 2.13 6.57 6.57 0 0 1 2.07 5.66 9.32 9.32 0 0 1-2.72 5.34c-1 1-2.44 1.77-4.97 2l-7.38-7.37c.3-2.82 1-3.9 2.04-4.94a9.28 9.28 0 0 1 5.3-2.75c.25-.03.49-.06.73-.06ZM11.34 18l3.57 3.53c-.27-.04-.6-.1-1.1-.1-.6.01-1.38.05-2.03.7-.72.71-1.38 1.5-1.94 2.21-.55.71-1.05 1.37-1.28 1.6-.11.11-.06.1-.22.06a2.24 2.24 0 0 1-.84-.6 2.03 2.03 0 0 1-.56-.84c-.04-.17-.07-.12.03-.22.21-.2.85-.71 1.56-1.28.72-.56 1.53-1.22 2.25-1.93.7-.7.7-1.5.69-2.13 0-.48-.08-.76-.13-1Z',
        'tablet-alt-solid' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Zm1 7a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'tablet-solid' => 'M5 6C3.36 6 2 7.36 2 9v14c0 1.64 1.36 3 3 3h22c1.64 0 3-1.36 3-3V9c0-1.64-1.36-3-3-3Zm0 2h22a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Zm1 7a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'tablets-solid' => 'M22 3a7 7 0 1 0 .02 14.02A7 7 0 0 0 22 3zm0 2a5 5 0 0 1 4.17 7.75l-6.92-6.92A4.96 4.96 0 0 1 22 5zm-4.17 2.25 6.92 6.92a5 5 0 0 1-6.92-6.92zM10 14a7 7 0 1 0 .02 14.02A7 7 0 0 0 10 14zm0 2a5 5 0 0 1 4.9 4H5.1a5 5 0 0 1 4.9-4zm-4.9 6h9.8a5 5 0 0 1-9.8 0z',
        'tachometer-alt-solid' => 'M16 6a12.01 12.01 0 0 0-9.25 19.63l.28.37h17.94l.28-.38A12.01 12.01 0 0 0 16 6Zm0 2c5.54 0 10 4.46 10 10a9.9 9.9 0 0 1-2.06 6H8.06A9.9 9.9 0 0 1 6 18c0-5.54 4.46-10 10-10Zm0 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm-4 1.06a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM9.06 13a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm13.6.03L17 16.28A1.98 1.98 0 0 0 14 18a2 2 0 0 0 4 .03V18l5.66-3.22ZM8 17a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm16 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM9.06 21a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm13.88 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'tag-solid' => 'm16 5-.31.28-11.4 11.53-.7.69.7.72 9.5 9.5.71.69.69-.7 11.53-11.4L27 16V5Zm.84 2H25v8.16L14.5 25.59 6.4 17.5ZM22 9a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'tags-solid' => 'm14.6 4-.32.28-11 11-.69.72.7.72 9 9 .71.69.72-.7 11-11 .28-.3V4Zm.84 2H23v7.56l-10 10L5.44 16ZM26 7v2h1v8.16l-9.5 9.43-1.25-1.25-1.4 1.41 1.93 1.97.72.69.69-.7 10.53-10.4L29 18V7Zm-6 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'tape-solid' => 'M12 5a11 11 0 0 0 0 22h19v-2H18.3A10.99 10.99 0 0 0 12 5zm0 2a9.01 9.01 0 0 1 0 18 9.01 9.01 0 0 1 0-18zm0 5a4 4 0 1 0 0 8 4 4 0 0 0 0-8zm0 2a2 2 0 1 1 0 4 2 2 0 0 1 0-4z',
        'tasks-solid' => 'M10.3 5.3 7 8.58l-1.3-1.3L4.3 8.7 7 11.4l4.7-4.7ZM14 7v2h14V7Zm0 8v2h14v-2Zm0 8v2h14v-2Z',
        'taxi-solid' => 'm13 4-.66 2H9.5a3 3 0 0 0-2.88 2.13l-1.37 4.59-1.94-.66-.62 1.88 1.97.65-.63 2.13A.97.97 0 0 0 4 17v8a1 1 0 0 0 1 1h3l.34-1h15.32l.34 1h3a1 1 0 0 0 1-1v-8c0-.1 0-.2-.03-.28l-.63-2.13 1.97-.65-.62-1.88-1.94.66-1.38-4.6A3 3 0 0 0 22.5 6h-2.84L19 4ZM9.5 8h13c.45 0 .84.3.97.72L24.75 13H7.25l1.28-4.28A1 1 0 0 1 9.5 8Zm-2.84 7h18.68l.66 2.19V23H6v-5.81Zm1.84 1a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm15 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM12 19l-1.25 3h2.16l.43-1h5.32l.43 1h2.16L20 19Z',
        'teamspeak' => 'M16.38 4a13 13 0 0 0-4.06.6 10.48 10.48 0 0 0-4.8 3.17c-.17.21-.3.43-.13.68.14.19.06.3-.04.44a10.64 10.64 0 0 0-1.85 4.3c-.03.2-.13.28-.3.36-.66.33-1.05.87-1.16 1.6L4 16.39v1.3c0 1.44.98 2.36 2.43 2.3.36-.02.57-.21.57-.54v-4.38c0-.02.05-1.26.16-1.84a8.01 8.01 0 0 1 1.2-2.96A8.98 8.98 0 0 1 25 15v4.29c0 .33.08.6.42.67a2.14 2.14 0 0 0 2.5-1.72c.13-.8.04-1.94.04-2.75a2.09 2.09 0 0 0-1.22-1.97c-.13-.06-.23-.13-.27-.3a10.46 10.46 0 0 0-1.9-4.39c-.05-.07-.16-.15-.1-.23.4-.54 0-.85-.33-1.15-2.32-2.25-4.91-3.4-7.77-3.45zm-6.02 12c-.63-.04-1.14.37-1.28 1.1-.21 1.04 0 2.03.6 2.93.43.61 1.07.9 1.82.95.49.03 2.2.1 2.59-.03.5-.18.84-.48.95-.97.1-.49-.51-1.2-1.36-1.94a14.1 14.1 0 0 0-2.66-1.84 1.67 1.67 0 0 0-.66-.2zm11.62 2c-.93-.08-2.26.54-2.86.79-3.24 1.3-2 2.55-.98 2.82l2.28.36c1.6.13 2.62-1.33 2.58-2.82-.04-.79-.46-1.09-1.02-1.14zm2.32 3a.24.24 0 0 0-.17.09l-.03.08c-.37 1.23-2.04 5.41-7.84 5.85-6.81.5 3.65 2.09 6.62-.31 1.03-.84 2.17-1.69 2.12-4.1-.02-.5-.22-1.29-.53-1.56a.26.26 0 0 0-.17-.05z',
        'teeth-open-solid' => 'M10 3c-4.96 0-9 4.04-9 9v1a3 3 0 0 0 3 3c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78a3 3 0 0 0 3-3v-1c0-4.96-4.04-9-9-9H10zm0 2h12a7 7 0 0 1 6.33 4.03L28 9c-.61 0-1.17.18-1.64.49a3.49 3.49 0 0 0-4.89-.83 3.5 3.5 0 0 0-5.47-.6 3.5 3.5 0 0 0-5.47.6 3.47 3.47 0 0 0-4.89.83A2.96 2.96 0 0 0 4 9l-.33.03A7 7 0 0 1 10 5zm3.5 4c.83 0 1.5.67 1.5 1.5V13a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-2.5c0-.83.67-1.5 1.5-1.5zm5 0c.83 0 1.5.67 1.5 1.5V13a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-2.5c0-.83.67-1.5 1.5-1.5zm-10 1c.83 0 1.5.67 1.5 1.5V13a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-1.5c0-.83.67-1.5 1.5-1.5zm15 0c.83 0 1.5.67 1.5 1.5V13a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1.5c0-.83.67-1.5 1.5-1.5zM4 11a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm24 0a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zM4 18a3 3 0 0 0-3 3v1a7 7 0 0 0 7 7h16a7 7 0 0 0 7-7v-1a3 3 0 0 0-3-3c-.77 0-1.47.3-2 .78a2.97 2.97 0 0 0-2-.78h-1c-.77 0-1.47.3-2 .78a2.97 2.97 0 0 0-2-.78h-1c-.77 0-1.47.3-2 .78a2.97 2.97 0 0 0-2-.78h-1c-.77 0-1.47.3-2 .78A2.97 2.97 0 0 0 9 18H8c-.77 0-1.47.3-2 .78A2.97 2.97 0 0 0 4 18zm0 2a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zm4 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 2 2 0 0 1-2-2 1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1 2 2 0 0 1-2 2 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zM5.8 23.38A4 4 0 0 0 9 25c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78a4 4 0 0 0 3.2-1.62 2.9 2.9 0 0 0 2.4.56A5 5 0 0 1 24 27H8a5 5 0 0 1-4.6-3.06 2.99 2.99 0 0 0 2.4-.56z',
        'teeth-solid' => 'M10 5c-4.96 0-9 4.04-9 9v1c0 .77.3 1.47.78 2A2.98 2.98 0 0 0 1 19v1a7 7 0 0 0 7 7h16a7 7 0 0 0 7-7v-1c0-.77-.3-1.47-.78-2 .48-.53.78-1.23.78-2v-1c0-4.96-4.04-9-9-9H10zm0 2h12a7 7 0 0 1 6.33 4.03L28 11c-.61 0-1.17.18-1.64.49a3.49 3.49 0 0 0-4.89-.83 3.5 3.5 0 0 0-5.47-.6 3.5 3.5 0 0 0-5.47.6 3.47 3.47 0 0 0-4.89.83A2.96 2.96 0 0 0 4 11l-.33.03A7 7 0 0 1 10 7zm3.5 4c.83 0 1.5.67 1.5 1.5V15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-2.5c0-.83.67-1.5 1.5-1.5zm5 0c.83 0 1.5.67 1.5 1.5V15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-2.5c0-.83.67-1.5 1.5-1.5zm-10 1c.83 0 1.5.67 1.5 1.5V15a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-1.5c0-.83.67-1.5 1.5-1.5zm15 0c.83 0 1.5.67 1.5 1.5V15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1.5c0-.83.67-1.5 1.5-1.5zM4 13a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm24 0a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zM4 18a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zm4 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1 2 2 0 0 1-2-2 1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0h1a1 1 0 0 1 1 1 2 2 0 0 1-2 2 1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1zm5 0a1 1 0 0 1 1 1 1 1 0 0 1-1 1 1 1 0 0 1-1-1 1 1 0 0 1 1-1zM5.8 21.38A4 4 0 0 0 9 23c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78h1c.77 0 1.47-.3 2-.78.53.48 1.23.78 2 .78a4 4 0 0 0 3.2-1.62 2.9 2.9 0 0 0 2.4.56A5 5 0 0 1 24 25H8a5 5 0 0 1-4.6-3.06 2.99 2.99 0 0 0 2.4-.56z',
        'telegram-plane' => 'M26.07 4c-.34.01-.65.1-.93.22-.3.11-1.65.68-3.7 1.55l-7.39 3.1-10.5 4.43.06-.02s-.36.11-.73.37c-.2.13-.4.3-.6.57-.17.27-.32.68-.27 1.1.1.73.56 1.16.9 1.4.34.24.66.36.66.36l4.9 1.64 1.78 5.84c.18.57.36.93.58 1.2a1.12 1.12 0 0 0 .63.46h-.06l.04.01.12.02c.77.24 1.4-.24 1.4-.24l.03-.03 2.88-2.62 4.83 3.7.11.05c1.01.44 2.03.2 2.57-.24s.75-1 .75-1l.04-.08L27.9 6.66c.1-.48.14-.92.02-1.35A1.8 1.8 0 0 0 26.07 4Zm-.1 2.05-.02.17v.01l-3.7 18.93c-.02.03-.04.09-.12.15-.08.06-.14.1-.46-.03l-5.91-4.53L12.19 24l.75-4.79s9.26-8.62 9.65-9c.4-.37.27-.44.27-.44.03-.46-.6-.14-.6-.14l-12.18 7.55v-.02l-5.84-1.97h-.01l.03-.02.03-.01.03-.02 10.5-4.42 7.39-3.11 3.66-1.53c.08-.03.04-.03.1-.03Z',
        'telegram' => 'M26.07 4c-.34.01-.65.1-.93.22-.3.11-1.65.68-3.7 1.55l-7.39 3.1-10.5 4.43.06-.02s-.36.11-.73.37c-.2.13-.4.3-.6.57-.17.27-.32.68-.27 1.1.1.73.56 1.16.9 1.4.34.24.66.36.66.36l4.9 1.64 1.78 5.84c.18.57.36.93.58 1.2a1.12 1.12 0 0 0 .63.46h-.06l.04.01.12.02c.77.24 1.4-.24 1.4-.24l.03-.03 2.88-2.62 4.83 3.7.11.05c1.01.44 2.03.2 2.57-.24s.75-1 .75-1l.04-.08L27.9 6.66c.1-.48.14-.92.02-1.35A1.8 1.8 0 0 0 26.07 4Zm-.1 2.05-.02.17v.01l-3.7 18.93c-.02.03-.04.09-.12.15-.08.06-.14.1-.46-.03l-5.91-4.53L12.19 24l.75-4.79s9.26-8.62 9.65-9c.4-.37.27-.44.27-.44.03-.46-.6-.14-.6-.14l-12.18 7.55v-.02l-5.84-1.97h-.01l.03-.02.03-.01.03-.02 10.5-4.42 7.39-3.11 3.66-1.53c.08-.03.04-.03.1-.03Z',
        'temperature-high-solid' => 'M9 4v11.47A6.85 6.85 0 0 0 6 21a7 7 0 0 0 14 0 6.85 6.85 0 0 0-3-5.53V14h2v-2h-2v-2h2V8h-2V6h2V4H9zm15.5 0a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zM11 6h4v10.4l.5.29A4.99 4.99 0 0 1 13 26a4.99 4.99 0 0 1-2.5-9.31l.5-.28V6zm13.5 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zM12 8v10.19a3 3 0 1 0 2 0V8h-2z',
        'temperature-low-solid' => 'M9 4v11.47A6.85 6.85 0 0 0 6 21a7 7 0 0 0 14 0 6.85 6.85 0 0 0-3-5.53V14h2v-2h-2v-2h2V8h-2V6h2V4H9zm15.5 0a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zM11 6h4v10.4l.5.29A4.99 4.99 0 0 1 13 26a4.99 4.99 0 0 1-2.5-9.31l.5-.28V6zm13.5 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3zM12 16v2.19a3 3 0 1 0 2 0V16h-2z',
        'tencent-weibo' => 'M17 2a9.01 9.01 0 0 0-7.94 13.22c.4-.72.85-1.39 1.31-2.03A6.88 6.88 0 0 1 10 11a7 7 0 1 1 7 7 7 7 0 0 1-2.31-.4c-.35.56-.66 1.14-.94 1.77 1.01.4 2.1.63 3.25.63a9.01 9.01 0 0 0 0-18Zm0 6a3 3 0 0 0-3 3c0 .34.09.64.19.94C8.46 17.24 8 25.2 8 29h2c0-3.61.42-10.74 5.4-15.47A3 3 0 1 0 17 8Z',
        'tenge-solid' => 'M6.63 5a.63.63 0 0 0-.63.62v2.75c0 .35.28.63.63.63h18.75c.35 0 .62-.28.62-.63V5.62a.62.62 0 0 0-.62-.62H6.63zm0 7a.63.63 0 0 0-.63.62v2.75c0 .35.28.63.63.63H14v11.38c0 .35.27.62.62.62h2.76c.35 0 .62-.27.62-.62V16h7.38c.35 0 .62-.28.62-.63v-2.75a.62.62 0 0 0-.62-.62H6.63z',
        'terminal-solid' => 'M4 5v22h24V5Zm2 2h20v2H6Zm0 4h20v14H6Zm5.22 2.78-1.44 1.44L12.56 18l-2.78 2.78 1.44 1.44 3.5-3.5.69-.72-.7-.72ZM16 20v2h6v-2Z',
        'text-height-solid' => 'M4 6v2h7v18h2V8h7V6Zm21 .63L21.5 11H24v10h-2.5l3.5 4.38L28.5 21H26V11h2.5Z',
        'text-width-solid' => 'M8 6v2h7v14h2V8h7V6Zm2 15.5L5.62 25 10 28.5V26h12v2.5l4.38-3.5L22 21.5V24H10Z',
        'th-large-solid' => 'M5 5v22h22V5Zm2 2h8v8H7Zm10 0h8v8h-8ZM7 17h8v8H7Zm10 0h8v8h-8Z',
        'th-list-solid' => 'M4 6v20h24V6Zm2 2h5v4H6Zm7 0h13v4H13Zm-7 6h5v4H6Zm7 0h13v4H13Zm-7 6h5v4H6Zm7 0h13v4H13Z',
        'th-solid' => 'M3 6v20h26V6Zm2 2h4v4H5Zm6 0h4v4h-4Zm6 0h4v4h-4Zm6 0h4v4h-4ZM5 14h4v4H5Zm6 0h4v4h-4Zm6 0h4v4h-4Zm6 0h4v4h-4ZM5 20h4v4H5Zm6 0h4v4h-4Zm6 0h4v4h-4Zm6 0h4v4h-4Z',
        'the-red-yeti' => 'M12.35 3c-1.49 1.13-1.55 1.96-1.58 2.13-.05-.11-.3-.92-.72-1.26-.15.38-.16.8-.02 1.18.14.4.28.7.4.89a4.65 4.65 0 0 0-2.31 0h-.18l1.55.67A9.1 9.1 0 0 0 7.3 9.77l-.08.4.08.07.36-.22c-.16.55-.25.91-.31 1.21a9.14 9.14 0 0 0-1.3 1.9c-.7.04-1.5.5-1.9.66l.15.16 1.35.05c-.03.04-.04.1-.06.15-.34.3-1.86 1.76-1.55 3.78L5 16.88l.06.24c0 1.2.02 4.2 3.04 7.06A10.54 10.54 0 0 0 15.47 27c5.7 0 10.46-4.09 10.46-9.91.31-.46-.06.14.78-1.18l.6.67.12-.02a8.51 8.51 0 0 0-.41-1.6 2.1 2.1 0 0 0-.32-.63l.97.33c-.45-1.12-1.12-1.73-1.49-2.1l.34-.85s.57-1.3-.12-1.44c-.03-.53-.31-1.26-.86-1.26-.36-.5-.83-.58-1.44-.28-.43.2-.83.47-1.19.77-.25-.3-.14.02-.14-1.4-1.74-1.14-2.13-.54-3.5.14l.02.03a11.22 11.22 0 0 0-3.2-.63c-.27-.4-.88-.89-1.18-1.17l1.16.33a5.92 5.92 0 0 0-1.6-.71c.85-.2 1.4-.98 1.99-1.55a5.64 5.64 0 0 0-4.6.56l.57-2.08-.08-.02zm-.35.65a12 12 0 0 0-.3 1.18l-.08.34-.02.22.11.11a5.98 5.98 0 0 1 3.34-.88l1 .02a3.56 3.56 0 0 1-2.28 1.16 9.4 9.4 0 0 1-1.1.14v-.02l-.12-.06a.97.97 0 0 0-.66.1l-.33-.04-.12.08.02.06.3.03-.1.16.16-.03-.5.54c-.2.14-.25.3-.2.43l.26-.16h.05c.3-.38.72-.64 1.19-.71v-.14c.3.02.6.05.9.05.3 0 .4.03.26.06.34.19.66.4.97.63.63.48 1.1 1.03 1.4 1.66a6.04 6.04 0 0 1 .5 3.98 9.8 9.8 0 0 1-.75 2.16l.12.02c.85-.92 1.96-.75 2.3-.75l-.3.28 1.05.83-.08 1.44c-.25-.58-.77-1-1.54-1.3.77.69 1.1.98 1.02.94-.22-.13-.16-.09-.5-.17.19.19.82.88.85.97V17c0 .08.08-.06-.66 1.07-3.52-.72-4.98-2-6.62-2.96l.56.05c-.56-.86-.73-.83-1.8-1.22l.5-.4a1.98 1.98 0 0 0-1.33.03l.35-.5-.05-.08c-.7.2-.93.43-1.06.53a4.02 4.02 0 0 0-.58-1.35l-.05 1.27-.62-.23c.07-1.19.25-2.37.62-3.5l.06-.08c.05-.14.2-.36.43-.71l.12-.16-.61.57.25-.22-.47.44-.2.06a9.36 9.36 0 0 1 2.47-3.27l-.3.06c-.53-.2-.9-.33-1.16-.4l.15-.02c.48 0 .82.02.98.06.24.08.5.11.75.11l.02-.08-.39-1.67.63 1.36c.13-.2.23-.44.28-.67.08-.3.25-.61.47-.91.22-.3.36-.5.44-.53zm1.16 2.7a.67.67 0 0 0-.3.12c-.6.31-1.32.98-1.37 1.05-.08.08-.16.28-.25.63-.1.36-.14.73-.14 1.1-.22-.37-.49-.3-.93-.27l.33.36c-.77 0-1.09.72-1.1.75.32 0 .21-.36 1.4-.58-.2-.3-.15-.23-.23-.3 1.02.78.78 1 2.18 1.1l-.13-.22a2 2 0 0 0 .7-1.33 2.88 2.88 0 0 0-.42-1.94l.6-.35a.08.08 0 0 0-.02-.08.66.66 0 0 0-.32-.04zm.58.3.02.12.18.12-.12.02.03.14c.42-.02.84.07 1.22.28-.12-.26-.47-.67-1.33-.67zm-1.1.3c.12.02.23.17.33.45.12.39.17.79.14 1.19-.02.43-.15.8-.39 1.08-.14.16-.25.28-.3.36-.18.01-.35 0-.53-.03l-.33-.16-.26-.3c.04-.46.06-.88.15-1.22.06-.35.16-.6.3-.8.25-.3.5-.47.75-.55.05-.02.1-.03.14-.02zm1.54.34c-.18.05-.3.36-.37.92a2.3 2.3 0 0 0 .56 1.85c.43.48.85.5 1.22.15.37-.36.16-1.11-.53-2.24-.16-.27-.4-.5-.67-.65a.27.27 0 0 0-.2-.03zm.07.2c.08-.02.24.06.47.25.3.25.53.75.71 1.52.3 1.31-.93 1.23-1.26.23.25.1.5.09.58-.5v-.21l-.06.02c-.2-.15-.12-.21-.08-.3l.02-.02c-.04-.05-.23-.38-.58.22-.03-.63.02-1.02.14-1.16a.1.1 0 0 1 .06-.05zm6.36.25c.13.09.54.25.89.8.2.4.19.46.16.52-.02.12-.02.2-.14.34-.08.12-.26.22-.56.35-.35-.6-.77-1.1-1.3-1.46l.95-.55zm.77.01c.26 0 .63.15 1.1.46l-.03 1.03c.26.85.79.8 1.05.8l-.16-.22 1.05-.25c-.42.03-.85.03-1.27 0 .6-.1 1.56-1.36 2.02-.53.16.36.3.8.43 1.3l.08-.27a2.64 2.64 0 0 1-.08-.71c.26.02.42.15.44.47.02.3.08.7.16 1.19l.22-.54c.21 0 .2-.16-.12.98-.98-.41-1.64-.4-2.18-.4l.86-.75c-1.2.38-1.55.5-2.57.98a1.5 1.5 0 0 0-.75-.93c-.15.18-.13.04-.04.7h-.11a3.1 3.1 0 0 0-.4-1.1l.2-.15c.4-.33.55-.67.5-1.03-.03-.3-.26-.63-.64-.97a.47.47 0 0 1 .23-.06zm-9.2.3c-.37 0-.54.59-.37.99.04.1.14.17.25.2.08 0 .43-.06.43-.7h-.02c-.25-.05-.1-.26-.03-.28-.08-.14-.16-.2-.25-.22zm-1.71 2.22c-.55.04-.85.22-.9.25.03.02.14.16.28.44.2-.3.41-.48.71-.5-.08.52-.05 1.06.08 1.58 0 .02.12.81 1.29 1.13a4.5 4.5 0 0 0 2.3-.26l-.44.03c-.2-.7-.3-1.17-.28-1.39.53-.4 1.03-.52 1.44-.35h.12l-.55-.36-.34.03c-.27.05-.57.2-.9.39l.14-.3c-1.63.67-1.63.65-1.7.66-.97.23-.88-1.14-.88-1.16l.28-.05-.02-.12a3.13 3.13 0 0 0-.63-.02zm13.76.33-.7.61.02.14.83-.03c.53.02 1.04.09 1.55.2l-1.1.12-.06.14 1.25 1.08c.46.47.88.97 1.26 1.5-.52-.15-.48-.16-1-.16l.59 1.53-.42-.6-.12.02.14.44c-.17.27-1.11 2.07-3.36 3.73-1.85 1.4-3.59 1.83-3.79 1.9l-.36-.34-.05.14.67.75-.33-.22.15.2h-.05l-1.03-.64.44 1.25-.9-1.3-.05.11.36 1.36c-.29-.39-.99-1.53-2.67-1.86l1.53 1c-1.46.22-2.95.11-4.37-.3-.2-.06-.42-.12-.63-.2l.05-.14-2.1-1.05 1.22 1.05a5.16 5.16 0 0 1-5.92-3.91l-.12-.77-1.04 1.04c.91-2.69 1.2-2.7 2.4-3.28-.42-.25-.07-.16-1.8-.44.75-.27 1.56-.72 3.43.25a.88.88 0 0 1 .17-.08c.03-.15.02-.04.05-.56.18.47.17.41.14.44l.08.02c.6-.3.42-.2.8-.41l-.25.63 1.04-.27-.4.39.12.12c.22-.09 1.42.16 1.92.75l-1.1-.12a5.4 5.4 0 0 1 2.6 3.26l.09-.05c-.13-1.05-.58-1.6-.75-1.88.2.23 1.83 1.62 5.17 2.15-.53-.02-1.08.26-1.63.89l2.18-.95-.43 1.03c.36-.47.7-1.1 1-1.86v-.02l.05-.14-.06.75 1.66-5.14.63-1.3v-.1l-.25-.2h.48l.27.2.12-.06-.16-.75.58.9 1.96-.96zm1.93 1.18-.18.61-.67-.55.85-.06zm-11.95.34c.08.5.23.83.42 1.02-.44.31-1.3.66-2.18.75l.02.06c.4.06.8.02 1.16-.12l-.33.61c.2-.08.47-.33.83-.7.56-.25.6-.23.95-.74-.6-.3-.74-.64-.87-.88zm-8.06 7.44a5.97 5.97 0 0 0 5.65 1.74 7.04 7.04 0 0 0 5.34.5c.16 0 .95.8 1.19 1.83l.2-.14-.12-1.1c.42.41 1.16 1.05 1.61.6-.73-.25-1.1-.44-1.38-1.48.21.2.35.42 1.3.7l.06-.06-.5-.66c.56-.23-.16.04 1.5-.51.2 1.6.43 2.3.04 4.2-2.34 1.17-2.63 1.05-2.77 1.12a5.3 5.3 0 0 1-2.97-2.76l1.4.77c-.46-.43-.86-.77-1.8-2.07l.56 1.08-.83-.36c.66 1 1.1 2.43 3.12 3.45-5.66 1.13-9.33-3.38-9.42-3.48.52.43 1.08.82 1.66 1.16.16.08.33.12.47.05l-.75-.96c.43.2.45.2 3.24 1.35-2-.97-3.46-1.9-4.37-2.82-.02.3-.05.48-.05.48.4.34.74.76.97 1.24-1.83-.88-2.7-2.23-3.35-3.87z',
        'theater-masks-solid' => 'm17.75 2.81-.81.22S12.77 4.13 9.9 5.5h-.04C7.04 6.77 3.45 9.16 3.45 9.16l-.69.46.34.79S5.75 16.37 6.97 19l.03.03a3.55 3.55 0 0 0 1.81 1.69c.08.7.38 1.4.72 2.03a15.15 15.15 0 0 0 2.13 2.9c1.6 1.78 3.3 3.13 3.3 3.13l.32.25.4-.03s2.18-.18 4.5-.75c1.18-.29 2.4-.67 3.45-1.22 1.04-.55 2-1.28 2.34-2.44.9-2.98 3-9.68 3-9.68l.25-.82-.78-.37s-3.91-1.96-7.1-3.03c-1.3-2.91-3.25-7.13-3.25-7.13Zm-1.1 2.44 2.2 4.72c-2.86-.68-5.82-1.06-5.82-1.06l-.84-.1-.25.78-.4 1.29-3.1 2.09 1.12 1.65 1.06-.71-1.43 4.71a1.11 1.11 0 0 1-.38-.4v-.03c-1.08-2.33-3.09-6.78-3.53-7.75.68-.45 3.18-2.13 5.44-3.13 2.23-1.07 5.12-1.84 5.94-2.06Zm-3.06 5.78c1.08.15 4.33.6 6.82 1.4 2.63.86 5.61 2.35 6.37 2.73-.27.88-1.53 4.87-2.44 7.84l-.3 1c-.11.34-.55.82-1.35 1.25-.8.43-1.9.8-2.97 1.06-1.95.48-3.5.6-3.81.63-.27-.23-1.43-1.16-2.75-2.63a13.92 13.92 0 0 1-1.88-2.53c-.43-.8-.54-1.43-.44-1.78.82-2.73 2.45-7.97 2.75-8.97Zm.82 4.81-.6 1.91 3.78 1.22.6-1.94Zm5.3 1.6-.62 1.9 3.7 1.22.62-1.9Zm-4.09 2.53-1.87.69s.83 2.3 3.22 2.96v.04h.06c2.33.73 4.34-.75 4.34-.75l-1.15-1.63s-1.35.88-2.6.47h-.03l-.03-.03c-1.35-.36-1.93-1.75-1.93-1.75Z',
        'themeco' => 'M15.84 3c-.49 0-.97.11-1.37.34L5.4 8.44A2.9 2.9 0 0 0 4 10.8v10.35c0 .91.58 1.9 1.38 2.36l9.1 5.16c.4.23.88.34 1.38.34.48 0 .96-.1 1.35-.32l9.4-5.19A2.87 2.87 0 0 0 28 21.15V10.8c0-.91-.6-1.9-1.4-2.34l-9.4-5.13a2.79 2.79 0 0 0-1.36-.32zm.02 2c.15 0 .3.02.39.07l9.39 5.13c.16.1.36.41.36.6v10.34a.9.9 0 0 1-.37.6l-9.39 5.19c-.18.1-.6.1-.78 0l-9.09-5.17a.93.93 0 0 1-.37-.62V10.8c0-.18.2-.5.37-.6l9.08-5.11c.1-.05.25-.08.4-.08zm5.32 8.14c-3.7 0-3.84 5.72 0 5.72 3.76 0 3.76-5.72 0-5.72zm-10.59.1H8v5.5h1.04v-1.62h1.55c2.69 0 2.68-3.88 0-3.88zm2.72 0v5.5h1.04V16.9h1l1.6 1.84h1.23v-.07l-1.67-1.88c2-.4 1.89-3.53-.59-3.54l-2.6-.01zm7.87.84c2.39 0 2.42 3.83 0 3.83-2.43 0-2.4-3.83 0-3.83zM9 14.12h1.75c1.15 0 1.14 2.1 0 2.1H9v-2.1zm5.35.1h1.57a.88.88 0 0 1 0 1.75h-1.57V14.2z',
        'themeisle' => 'M20.15 4c-.73 0-1.45.3-1.95.86a5.52 5.52 0 0 0-.83-.06 8.2 8.2 0 0 0-6.33 3.26c-.46.6-.64 1-1.01 1.6-.07.13-.24.26-.34.38-.2.23-.39.47-.56.72a1.1 1.1 0 0 0-1.09-.7c-3.09 0-4.04 5.18-4.04 7.5 0 .68.05 1.52.32 2.15.56 1.34 2.18 3.07 3.22 4.1-.99.6-2.15.74-3.15.52a4.5 4.5 0 0 0 2.44 1.7c-.46.16-.94.26-1.42.27a4.34 4.34 0 0 0 5.47.16c0 .8.5 1.54 1.38 1.54.47 0 .91-.27 1.15-.67.26.4.69.67 1.17.67.47 0 .91-.27 1.15-.67.26.4.7.67 1.17.67s.9-.27 1.16-.67c.24.4.69.67 1.15.67a1.4 1.4 0 0 0 1.37-1.43v-1.53l.05-.01c1.57-.45 4.6-2.15 5.67-3.31 1.16-1.29 1.7-4.4 1.7-6.08 0-1.25-.23-2.87-1.2-3.74-.37-.32-.85-.65-1.34-.65-.33 0-.6.16-.8.4A8.56 8.56 0 0 0 22 6.59c.08-.1.22-.2.22-.34 0-.24-.54-.5-.74-.56.12-.14.6-.6.6-.77a.24.24 0 0 0-.06-.16A2.71 2.71 0 0 0 20.15 4zm-5.83 2.46c.93 0 1.52.89 1.52 1.73 0 .86-.6 1.74-1.52 1.74s-1.5-.88-1.5-1.74c0-.84.58-1.73 1.5-1.73zm.26.66c-.53 0-.83.55-.83 1.02 0 .48.3 1.02.83 1.02.52 0 .83-.54.83-1.02 0-.47-.3-1.02-.83-1.02zm5.34.66c2.72 0 4.34 2.43 4.34 4.95 0 1.82-.79 3.68-2.14 4.9.61-3.06-2.6-1.72-3.95-1.72-3.23 0-2.88-3.3-1.94-6.4a5.16 5.16 0 0 1 3.7-1.73zm-4.38 2.58c-.22.9-.4 1.81-.4 2.73 0 3.18 2.06 3.6 5.03 3 .2-.04.41-.08.63-.08.67 0 .96.34.96 1 0 .37-.08.72-.17 1.07a5 5 0 0 1-2.82.93c-3.86 0-5.66-4.92-3.23-8.65zM9.1 11.61a9.76 9.76 0 0 0-.28 2.33c0 4.31 3 8.27 7.53 8.27 3.2 0 5.98-2.03 7.43-4.8a9.75 9.75 0 0 1-3.35 6.95c-.23-.44-.7-.75-1.2-.75-.47 0-.92.27-1.16.67a1.4 1.4 0 0 0-1.16-.67c-.47 0-.91.27-1.17.67-.24-.4-.68-.67-1.15-.67-.48 0-.91.27-1.17.67-.24-.4-.68-.67-1.15-.67-.52 0-.97.3-1.22.76a9.91 9.91 0 0 1-3.34-7.54c0-1.82.45-3.64 1.39-5.22zm3.17 12.45c.54 0 .95.46.95.98v1.53c0 .53-.41.99-.95.99-.53 0-.94-.47-.94-1v-1.52c0-.52.4-.98.94-.98zm2.32 0c.54 0 .94.46.94.98v1.53c0 .52-.4.99-.94.99-.54 0-.95-.47-.95-1v-1.52c0-.52.41-.98.95-.98zm2.32 0c.53 0 .95.46.95.98v1.53c0 .53-.42.99-.95.99-.54 0-.95-.47-.95-1v-1.52c0-.52.41-.98.95-.98zm2.33 0c.53 0 .95.46.95.98v1.53c0 .52-.42.99-.95.99-.54 0-.95-.47-.95-1v-1.52c0-.52.41-.98.95-.98z',
        'thermometer-empty-solid' => 'M13 5v11a5.87 5.87 0 0 0-3 5c0 3.3 2.7 6 6 6s6-2.7 6-6a5.87 5.87 0 0 0-3-5v-1h2v-2h-2v-2h2V9h-2V7h2V5Zm2 2h2v10.06l.6.28A3.99 3.99 0 0 1 16 25a3.99 3.99 0 0 1-1.6-7.66l.6-.28Z',
        'thermometer-full-solid' => 'M12 4v11.47A6.85 6.85 0 0 0 9 21a7 7 0 0 0 14 0 6.85 6.85 0 0 0-3-5.53V14h2v-2h-2v-2h2V8h-2V6h2V4Zm2 2h4v10.4l.5.29A4.98 4.98 0 0 1 16 26a4.98 4.98 0 0 1-2.5-9.31l.5-.28Zm1 2v10.19a3 3 0 1 0 2 0V8Z',
        'thermometer-half-solid' => 'M12 4v11.5c-1.8 1.3-3 3.2-3 5.5 0 3.9 3.1 7 7 7s7-3.1 7-7c0-2.3-1.3-4.3-3-5.5V14h2v-2h-2v-2h2V8h-2V6h2V4H12zm2 2h4v10.4l.5.3c1.5.9 2.5 2.4 2.5 4.3 0 2.8-2.2 5-5 5s-5-2.2-5-5c0-1.9 1-3.4 2.5-4.3l.5-.3V6zm1 7v5.2c-1.2.4-2 1.5-2 2.8 0 1.7 1.3 3 3 3s3-1.3 3-3c0-1.3-.8-2.4-2-2.8V13h-2z',
        'thermometer-quarter-solid' => 'M12 4v11.5c-1.8 1.3-3 3.2-3 5.5 0 3.9 3.1 7 7 7s7-3.1 7-7c0-2.3-1.2-4.3-3-5.5V14h2v-2h-2v-2h2V8h-2V6h2V4H12zm2 2h4v10.4l.5.3c1.5.8 2.5 2.5 2.5 4.3 0 2.8-2.2 5-5 5s-5-2.2-5-5c0-1.8 1-3.5 2.5-4.3l.5-.3V6zm-.2 13c-.5.5-.8 1.2-.8 2 0 1.7 1.3 3 3 3s3-1.3 3-3c0-.8-.3-1.5-.8-2h-4.4z',
        'thermometer-solid' => 'M21.75 4c-1.6 0-3.22.63-4.44 1.84l-7.65 7.63-.13.15A5.23 5.23 0 0 0 8 17.32v2.3L4.9 22.7l-.03.06a3.13 3.13 0 0 0 .04 4.34c1.2 1.2 3.2 1.2 4.4 0l3.06-3.1h2.32c1.38 0 2.7-.55 3.69-1.53l7.78-7.78A6.27 6.27 0 0 0 21.75 4Zm0 2a4.25 4.25 0 0 1 3 7.28l-7.78 7.78c-.6.6-1.43.94-2.28.94h-3.13l-3.69 3.69a1.1 1.1 0 0 1-1.56 0 1.1 1.1 0 0 1 0-1.57L10 20.45V17.3c0-.85.34-1.68.94-2.28l.84-.84 1 1.03 1.44-1.44-1-1 1.56-1.56 1 1 1.44-1.44-1-1 1.56-1.56 1 1 1.44-1.44-.97-.97a4.25 4.25 0 0 1 2.5-.81Zm.53 2.28L10.06 20.5l1.44 1.44L23.72 9.72Z',
        'thermometer-three-quarters-solid' => 'M12 4v11.5c-1.8 1.3-3 3.2-3 5.5 0 3.9 3.1 7 7 7s7-3.1 7-7c0-2.3-1.3-4.3-3-5.5V14h2v-2h-2v-2h2V8h-2V6h2V4H12zm2 2h4v10.4l.5.3c1.5.9 2.5 2.4 2.5 4.3 0 2.8-2.2 5-5 5s-5-2.2-5-5c0-1.9 1-3.4 2.5-4.3l.5-.3V6zm1 4v8.2c-1.2.4-2 1.5-2 2.8 0 1.7 1.3 3 3 3s3-1.3 3-3c0-1.3-.8-2.4-2-2.8V10h-2z',
        'think-peaks' => 'M15.5 2.44 3 24h2.31l10.2-17.58L25.63 23.8l3.94-6.8h-2.3l-1.64 2.82L15.5 2.44zm.03 7.99L8.8 22h2.32l4.4-7.59L24.03 29h2.31L15.53 10.43z',
        'thumbs-down-solid' => 'M10.16 6C8.75 6 7.52 7 7.22 8.38l-2.16 10A3.02 3.02 0 0 0 8 22h5.75l-.19.75c-.2.16-.33.22-.62.63a4.97 4.97 0 0 0-.94 2.96c0 1.43 1.29 2.66 2.9 2.66h.41l.31-.28L22.41 22H27V6Zm0 2H21v12.6l-6.4 6.3c-.43-.08-.6-.25-.6-.56 0-.9.27-1.46.53-1.8.26-.36.44-.45.44-.45l.34-.18.13-.41.6-2.25.3-1.25H8a.98.98 0 0 1-.97-1.22l2.13-10a1 1 0 0 1 1-.78ZM23 8h2v12h-2Z',
        'thumbs-down' => 'M10.16 6C8.75 6 7.52 7 7.22 8.38l-2.16 10A3.02 3.02 0 0 0 8 22h5.75l-.19.75c-.2.16-.33.22-.62.63a4.97 4.97 0 0 0-.94 2.96c0 1.43 1.29 2.66 2.9 2.66h.41l.31-.28L22.41 22H27V6Zm0 2H21v12.6l-6.4 6.3c-.43-.08-.6-.25-.6-.56 0-.9.27-1.46.53-1.8.26-.36.44-.45.44-.45l.34-.18.13-.41.6-2.25.3-1.25H8a.98.98 0 0 1-.97-1.22l2.13-10a1 1 0 0 1 1-.78ZM23 8h2v12h-2Z',
        'thumbs-up-solid' => 'm16.69 3-.32.28L9.6 10H5v16h16.84c1.41 0 2.64-1 2.94-2.38l2.16-10A3.02 3.02 0 0 0 24 10h-5.75l.19-.75c.2-.16.33-.22.62-.63.47-.64.94-1.63.94-2.96C20 4.23 18.71 3 17.1 3Zm.72 2.1c.42.08.59.25.59.56 0 .9-.27 1.46-.53 1.8-.26.36-.44.45-.44.45l-.34.18-.13.41-.6 2.25-.3 1.25H24c.66 0 1.1.57.97 1.22l-2.13 10a1 1 0 0 1-1 .78H11V11.4ZM7 12h2v12H7Z',
        'thumbs-up' => 'm16.69 3-.32.28L9.6 10H5v16h16.84c1.41 0 2.64-1 2.94-2.38l2.16-10A3.02 3.02 0 0 0 24 10h-5.75l.19-.75c.2-.16.33-.22.62-.63.47-.64.94-1.63.94-2.96C20 4.23 18.71 3 17.1 3Zm.72 2.1c.42.08.59.25.59.56 0 .9-.27 1.46-.53 1.8-.26.36-.44.45-.44.45l-.34.18-.13.41-.6 2.25-.3 1.25H24c.66 0 1.1.57.97 1.22l-2.13 10a1 1 0 0 1-1 .78H11V11.4ZM7 12h2v12H7Z',
        'thumbtack-solid' => 'm20.53 2.56-.69.94-4.9 6.69A8.4 8.4 0 0 0 7.5 12.5l-.72.69 5.31 5.31L4 26.6V28h1.4l8.1-8.1 5.31 5.32.69-.72a8.4 8.4 0 0 0 2.31-7.44l6.69-4.9.94-.7Zm.25 3.06 5.6 5.6-6.22 4.56-.57.4.2.66a6.41 6.41 0 0 1-1.2 5.35L9.81 13.4a6.41 6.41 0 0 1 5.35-1.2l.65.2.4-.57Z',
        'ticket-alt-solid' => 'M2 7v7h1c1.2 0 2 .8 2 2s-.8 2-2 2H2v7h28v-7h-1c-1.2 0-2-.8-2-2s.8-2 2-2h1V7Zm2 2h24v3.19c-1.71.45-3 1.95-3 3.81a3.95 3.95 0 0 0 3 3.81V23H4v-3.19c1.71-.45 3-1.95 3-3.81a3.95 3.95 0 0 0-3-3.81Z',
        'times-circle-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-3.78 5.78-1.44 1.44L14.56 16l-3.78 3.78 1.44 1.44L16 17.44l3.78 3.78 1.44-1.44L17.44 16l3.78-3.78-1.44-1.44L16 14.56Z',
        'times-circle' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm-3.78 5.78-1.44 1.44L14.56 16l-3.78 3.78 1.44 1.44L16 17.44l3.78 3.78 1.44-1.44L17.44 16l3.78-3.78-1.44-1.44L16 14.56Z',
        'times-solid' => 'M7.22 5.78 5.78 7.22 14.56 16l-8.78 8.78 1.44 1.44L16 17.44l8.78 8.78 1.44-1.44L17.44 16l8.78-8.78-1.44-1.44L16 14.56Z',
        'tint-slash-solid' => 'M3.72 2.28 2.28 3.72l7.78 7.78 1.45 1.45L21.66 23.1l1.43 1.43 5.19 5.2 1.44-1.45-5.54-5.54c.53-1.14.82-2.4.82-3.74 0-1.4-.56-2.92-1.34-4.5a42.58 42.58 0 0 0-2.85-4.72c-2.03-3-4.03-5.4-4.03-5.4L16 3.44l-.78.94s-2 2.4-4.02 5.38L3.72 2.28zM16 6.66c.56.69 1.6 1.91 3.19 4.25a38.28 38.28 0 0 1 2.65 4.5C22.56 16.86 23 18.2 23 19a7 7 0 0 1-.36 2.2l-10-10.01.17-.28C14.4 8.57 15.44 7.35 16 6.66zm-6.97 6.56c-.25.43-.48.86-.69 1.28C7.56 16.08 7 17.6 7 19a9.03 9.03 0 0 0 14.74 6.93l-1.44-1.44A6.88 6.88 0 0 1 16 26c-3.85 0-7-3.15-7-7 0-.8.44-2.14 1.16-3.59l.36-.7-1.5-1.49zM11 19a4.97 4.97 0 0 0 4.49 4.97A5 5 0 0 0 16 24v-2a3 3 0 0 1-3-3h-2z',
        'tint-solid' => 'm16 3.44-.78.94s-2 2.4-4.03 5.4a41.67 41.67 0 0 0-2.85 4.72C7.56 16.08 7 17.6 7 19c0 4.95 4.05 9 9 9s9-4.05 9-9c0-1.4-.56-2.92-1.34-4.5a41.67 41.67 0 0 0-2.85-4.72c-2.03-3-4.03-5.4-4.03-5.4Zm0 3.22c.56.69 1.6 1.91 3.19 4.25a39.48 39.48 0 0 1 2.65 4.5C22.56 16.86 23 18.2 23 19a7 7 0 0 1-14 0c0-.8.44-2.14 1.16-3.6a39.48 39.48 0 0 1 2.65-4.5C14.4 8.58 15.44 7.36 16 6.67ZM11 19c0 2.75 2.25 5 5 5v-2a3 3 0 0 1-3-3Z',
        'tired-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM16 19c-2.6 0-4.33 2.16-4.95 3.34-.18.36.16.76.54.64C12.6 22.64 14.35 22 16 22c1.65 0 3.4.64 4.41.98.39.12.72-.28.54-.64C20.33 21.16 18.6 19 16 19z',
        'tired' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2a11 11 0 1 1-.01 21.99A11 11 0 0 1 16 5zm-5.95 6.17-1.1 1.66L10.7 14l-1.75 1.17 1.1 1.66L14.3 14l-4.25-2.83zm11.9 0L17.7 14l4.25 2.83 1.1-1.66L21.3 14l1.75-1.17-1.1-1.66zM16 19c-2.6 0-4.33 2.16-4.95 3.34-.18.36.16.76.54.64C12.6 22.64 14.35 22 16 22c1.65 0 3.4.64 4.41.98.39.12.72-.28.54-.64C20.33 21.16 18.6 19 16 19z',
        'toggle-off-solid' => 'M9 7a8.94 8.94 0 0 0-2.69.4 9.07 9.07 0 0 0-5.6 5.1c-.1.27-.22.53-.3.81a8.85 8.85 0 0 0 0 5.35v.03a9.07 9.07 0 0 0 5.09 5.6c.27.1.53.22.81.3.85.27 1.75.41 2.69.41h14c4.96 0 9-4.04 9-9s-4.04-9-9-9Zm0 2c3.88 0 7 3.12 7 7s-3.12 7-7 7a6.98 6.98 0 0 1-6.97-7.72A6.98 6.98 0 0 1 9 9Zm5.63 0H23c3.88 0 7 3.12 7 7s-3.12 7-7 7h-8.38a8.98 8.98 0 0 0 0-14Z',
        'toggle-on-solid' => 'M9 7a9.01 9.01 0 0 0 0 18h14c4.96 0 9-4.04 9-9s-4.04-9-9-9Zm14 2c3.88 0 7 3.12 7 7s-3.12 7-7 7-7-3.12-7-7 3.12-7 7-7Z',
        'toilet-paper-solid' => 'M9 4C7.4 4 6.1 5.18 5.28 6.72A12.44 12.44 0 0 0 4 12.5V28h16v-8.63c.78.97 1.8 1.63 3 1.63 1.6 0 2.9-1.18 3.72-2.72A12.44 12.44 0 0 0 28 12.5c0-2.21-.46-4.24-1.28-5.78C25.89 5.18 24.6 4 23 4Zm0 2h10.72c-.16.23-.3.47-.44.72A12.44 12.44 0 0 0 18 12.5c0 .17.03.33.03.5H18v13H6V12.5c0-1.93.44-3.67 1.06-4.84C7.7 6.48 8.4 6 9 6Zm14 0c.6 0 1.31.48 1.94 1.66A10.68 10.68 0 0 1 26 12.5c0 1.93-.44 3.67-1.06 4.84C24.3 18.52 23.6 19 23 19c-.6 0-1.31-.48-1.94-1.66A10.68 10.68 0 0 1 20 12.5c0-1.93.44-3.67 1.06-4.84C21.7 6.48 22.4 6 23 6Zm0 4c-.55 0-1 1.12-1 2.5s.45 2.5 1 2.5 1-1.12 1-2.5-.45-2.5-1-2.5ZM9 13a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'toilet-solid' => 'M6 4c-.52 0-1.06.18-1.44.56C4.18 4.94 4 5.48 4 6v11c0 2.79 1.65 5.12 4 6.6V28h15v-4.4c2.35-1.48 4-3.81 4-6.6v-1H14V6c0-.52-.18-1.06-.56-1.44A2.03 2.03 0 0 0 12 4Zm0 2h6v10H6Zm2 2v3h2V8ZM6.31 18H24.7a6.07 6.07 0 0 1-3.16 4.22l-.53.28V26H10v-3.5l-.53-.28A6.07 6.07 0 0 1 6.3 18Z',
        'toolbox-solid' => 'M13 5a2 2 0 0 0-2 2v2H2v18h28V9h-9V7a2 2 0 0 0-2-2Zm0 2h6v2h-6Zm-9 4h24v5h-4v-1h-4v1h-8v-1H8v1H4Zm0 7h4v1h4v-1h8v1h4v-1h4v7H4Z',
        'tools-solid' => 'm5.25 2.75-.56.53-1.4 1.4-.54.57.4.66 2.1 3.5.28.5h2.94l4 3.96-8.28 8.32a3.92 3.92 0 0 0 .03 5.62 3.92 3.92 0 0 0 5.6 0l.02-.03L16 21.6l6.19 6.22.1.07a3.92 3.92 0 0 0 5.52-.07v-.03h.03a3.94 3.94 0 0 0-.03-5.6l-.03-.02-5.22-5.2a7 7 0 0 0 6.32-6.87h.03V10a5.18 5.18 0 0 0-.75-3.22l-.7-1.06-4.65 4.66-1.4-1.47 4.75-4.75-1.38-.57A7.06 7.06 0 0 0 22 3c-3.84 0-7 3.16-7 7 0 .42.09.78.16 1.16-.44.43-.77.8-1.29 1.3L9.91 8.5V5.53l-.5-.28-3.5-2.1ZM22 5c.14 0 .24.08.38.1l-3.79 3.78.7.71 2.8 2.91.7.72 3.96-3.97c.02.23.18.4.16.66V10c0 2.75-2.25 5-5 5-.37 0-.82-.09-1.32-.19l-.53-.1-.37.38L8.4 26.41h-.04v.03c-.7.77-1.95.8-2.78-.03v-.04h-.03c-.77-.7-.8-1.95.03-2.78.38-.38 7.72-7.78 11.32-11.37l.4-.4-.15-.57A5.01 5.01 0 0 1 22 5Zm-16.44.25 2.35 1.44v1l-.22.22h-1L5.25 5.56ZM20.2 17.41l6.22 6.18v.04h.03c.77.7.8 1.95-.03 2.78h-.04v.03c-.7.77-1.95.8-2.78-.03l-6.18-6.22Z',
        'tooth-solid' => 'M13.28 4c-2.46 0-4.56.79-6.03 2.19A7.66 7.66 0 0 0 5 11.84c0 1.7.65 3.02 1.31 4.2.66 1.16 1.33 2.21 1.69 3.52.44 1.62.74 3.55 1.25 5.16.25.8.56 1.54 1.03 2.16a2.7 2.7 0 0 0 2.1 1.12c.83 0 1.66-.43 2.09-1.1a4.1 4.1 0 0 0 .53-2.27c0-1.04 0-2.65.22-3.91.1-.63.3-1.16.47-1.44.17-.28.18-.28.31-.28s.14 0 .31.28c.17.28.36.8.47 1.44.22 1.26.22 2.87.22 3.9 0 .84.1 1.63.53 2.29a2.55 2.55 0 0 0 2.1 1.09c.87 0 1.62-.5 2.09-1.13.47-.62.78-1.37 1.03-2.18.5-1.62.82-3.54 1.25-5.13.36-1.3 1.03-2.36 1.69-3.53A8.26 8.26 0 0 0 27 11.84C27.05 7.3 23.6 4 19.06 4c-1.31 0-2.87.49-3.12.56A7.22 7.22 0 0 0 13.28 4Zm0 2c2.32 0 4.97 2.44 4.97 2.44L19.65 7l-1.12-.9c.21-.04.4-.1.53-.1 3.62 0 5.98 2.24 5.94 5.81v.03a6.2 6.2 0 0 1-1.03 3.22c-.62 1.1-1.45 2.32-1.9 3.97-.48 1.74-.79 3.67-1.23 5.06-.21.7-.48 1.27-.71 1.57-.24.3-.31.34-.5.34-.31 0-.31-.03-.41-.19a2.5 2.5 0 0 1-.22-1.18c0-1.02.02-2.72-.25-4.25a6.11 6.11 0 0 0-.72-2.16A2.48 2.48 0 0 0 16 17c-.88 0-1.64.57-2.03 1.22-.4.64-.59 1.39-.72 2.16-.27 1.53-.25 3.23-.25 4.25a2.5 2.5 0 0 1-.22 1.18c-.1.16-.1.19-.4.19-.2 0-.28-.05-.5-.34a5.3 5.3 0 0 1-.72-1.54c-.44-1.39-.75-3.33-1.22-5.09-.46-1.65-1.3-2.87-1.9-3.97-.63-1.1-1.04-2-1.04-3.22 0-1.8.6-3.21 1.66-4.21A6.47 6.47 0 0 1 13.28 6Z',
        'torah-solid' => 'M7 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm0 2c-.75 0-1.44.2-2 .63-.56.41-1 1.1-1 1.87v18c0 .77.44 1.46 1 1.88.3.23.66.4 1.03.5 0 .04-.03.07-.03.12a1 1 0 0 0 2 0c0-.05-.02-.08-.03-.13.37-.1.73-.26 1.03-.5.56-.41 1-1.1 1-1.87V25h12v.5c0 .77.44 1.46 1 1.88.3.23.66.4 1.03.5 0 .04-.03.07-.03.12a1 1 0 0 0 2 0c0-.05-.02-.08-.03-.13.37-.1.73-.26 1.03-.5.56-.41 1-1.1 1-1.87v-18a2.4 2.4 0 0 0-1-1.88A3.29 3.29 0 0 0 25 5c-.75 0-1.44.2-2 .63-.56.41-1 1.1-1 1.87V8H10v-.5a2.4 2.4 0 0 0-1-1.88A3.29 3.29 0 0 0 7 5Zm18 0a1 1 0 0 0 0-2 1 1 0 0 0 0 2ZM7 7c.35 0 .64.13.81.25.17.13.19.2.19.25v18c0 .05-.02.13-.19.25A1.4 1.4 0 0 1 7 26a1.4 1.4 0 0 1-.81-.25c-.17-.13-.19-.2-.19-.25v-18c0-.05.02-.13.19-.25.17-.13.46-.25.81-.25Zm18 0c.35 0 .64.13.81.25.17.13.19.2.19.25v18c0 .05-.02.13-.19.25A1.4 1.4 0 0 1 25 26a1.4 1.4 0 0 1-.81-.25c-.17-.13-.19-.2-.19-.25v-18c0-.05.02-.13.19-.25.17-.13.46-.25.81-.25Zm-15 3h12v13H10Zm2 2v2h8v-2Zm3 3v2h5v-2Zm-3 3v2h8v-2Z',
        'torii-gate-solid' => 'M2.94 4.97v1.81l.31.31 4 3.66.31.25H9v3H7v2h2v11h2V16h10v11h2V16h2v-2h-2v-3h1.38l.3-.25 4-3.66.32-.3V4.96l-1.22.28c-.03 0-4.25.75-11.78.75-7.53 0-11.8-.74-11.84-.75Zm3.84 2.6C8.9 7.76 11.91 8 16 8a91 91 0 0 0 9.16-.44L23.59 9H8.34ZM11 11h3v3h-3Zm7 0h3v3h-3Z',
        'tractor-solid' => 'M7 5v7.25a8.9 8.9 0 0 0-3.63 1.72l1.25 1.56A6.98 6.98 0 0 1 16 21h4.56c-.35.6-.56 1.27-.56 2 0 2.2 1.8 4 4 4s4-1.8 4-4c0-1.03-.42-1.95-1.06-2.66l2-4.96.06-.2V13h-5v-3c0-.57.43-1 1-1V7c-1.64 0-3 1.36-3 3v3h-3.31l-2.75-7.34-.25-.66Zm2 2h5.31l2.75 7.34.25.66h9.6l-1.6 4h-7.56A9 9 0 0 0 9 12Zm0 8c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Zm0 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm15 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'trade-federation' => 'M16 3a13 13 0 1 0 0 26 13 13 0 0 0 0-26zm0 .7a12.3 12.3 0 1 1 0 24.6 12.3 12.3 0 0 1 0-24.6zm0 .4a11.9 11.9 0 1 0 0 23.8 11.9 11.9 0 0 0 0-23.8zm0 .7c3.16 0 6.02 1.31 8.05 3.42H13.62v4.28H5.36A11.2 11.2 0 0 1 16 4.8zM9.68 7.86l.1.73-.76.2.72.14-.04.77.35-.64.73.28-.5-.54.49-.6-.67.31-.42-.65zm4.19.68h10.37v2.65H16.6v1.62h4.36v2.68h-4.37v10.25h-2.76V15.43H7.71l-2.1-2.62h8.26V8.54zm.1.1v4.28H5.84l1.93 2.4h6.17v10.32h2.55V15.38h4.37v-2.46h-4.37v-1.83h7.64V8.63H13.97zm-2.79.11L11.3 10l-1.23.28 1.22.28-.1 1.26.64-1.07 1.16.5-.82-.95.83-.95-1.16.49-.65-1.09zm13.42.1A11.18 11.18 0 1 1 5.27 12.8l2.3 2.95h6v10.31h3.4V15.8h4.36v-3.29h-4.36v-1h7.63V8.85zm-10.06.38h9v1.28h-7.6v2.94h4.35v1.26h-4.35v10.34h-1.4V14.71h-6.5L7 13.45h7.55V9.23zm8.29 2.59.12 1.19-1.17.28 1.16.26-.1 1.2.6-1.03 1.12.46-.8-.9.8-.91-1.1.47-.63-1.02zM11.8 15.83l.08 1.29-1.24.2 1.25.3-.2 1.26.69-1.1 1.13.57-.83-.99.88-.9-1.19.5-.57-1.13zm6.08.24.07.74-.73.17.73.17-.06.74.38-.64.69.29-.5-.56.5-.57-.7.3-.38-.64z',
        'trademark-solid' => 'M3 8v2h4v13h2V10h4V8Zm12 0v15h2V10.87l4.16 6.66.84 1.34.84-1.34L27 10.87V23h2V8h-2.56l-.28.47L22 15.12l-4.16-6.65-.28-.47Z',
        'traffic-light-solid' => 'M10 4v3H7v1c0 1.89.75 3.2 1.63 3.97.44.38.9.65 1.3.81H10V13H7v1c0 1.89.75 3.2 1.63 3.97.44.38.9.66 1.3.81H10V19H7v1c0 1.89.75 3.2 1.63 3.97.44.38.9.66 1.3.81H10V28h12v-3.22h.06c.4-.16.87-.43 1.32-.81A5.1 5.1 0 0 0 25 20v-1h-3v-.22h.06c.4-.16.87-.43 1.32-.81A5.1 5.1 0 0 0 25 14v-1h-3v-.22h.06c.4-.15.87-.43 1.32-.81A5.1 5.1 0 0 0 25 8V7h-3V4Zm2 2h8v3h2.81a2.86 2.86 0 0 1-.75 1.47c-.24.21-.5.35-.72.44-.2.08-.42.09-.34.09h-1v4h2.81a2.86 2.86 0 0 1-.75 1.47c-.24.21-.5.35-.72.44-.2.08-.42.09-.34.09h-1v4h2.81a2.86 2.86 0 0 1-.75 1.47c-.24.21-.5.35-.72.44-.2.08-.42.09-.34.09h-1v3h-8v-3h-1c.08 0-.13-.01-.34-.1a2.51 2.51 0 0 1-.72-.43A2.9 2.9 0 0 1 9.19 21H12v-4h-1c.08 0-.13-.01-.34-.1a2.51 2.51 0 0 1-.72-.43A2.9 2.9 0 0 1 9.19 15H12v-4h-1c.08 0-.13-.01-.34-.1a2.51 2.51 0 0 1-.72-.43A2.9 2.9 0 0 1 9.19 9H12Zm4 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm0 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm0 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'train-solid' => 'M14 3c-1.26 0-2.15.9-2.6 2H10c-2.75 0-5 2.25-5 5v11a6.01 6.01 0 0 0 3.53 5.47L6 29h2.34l2.04-2.03c.2.02.41.03.62.03h10c.2 0 .43-.01.63-.03L23.66 29H26l-2.53-2.53A6.01 6.01 0 0 0 27 21V10c0-2.75-2.25-5-5-5h-1.4c-.45-1.1-1.34-2-2.6-2Zm0 2h4c.57 0 1 .43 1 1v1h3a3 3 0 0 1 2.84 2H7.16A3 3 0 0 1 10 7h3V6c0-.57.43-1 1-1Zm-7 6h18v5H7Zm0 7h18v3c0 2.22-1.78 4-4 4H11c-2.22 0-4-1.78-4-4Zm9 1a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'tram-solid' => 'M10.75 2 8.56 3.1l.88 1.8 1.81-.9h9.5l1.81.9.88-1.8L21.25 2ZM15 5v1h-3c-3.3 0-6 2.7-6 6v12c0 1.64 1.36 3 3 3l-2 2h2.34l2-2h9.32l2 2H25l-2-2c1.64 0 3-1.36 3-3V12c0-3.3-2.7-6-6-6h-3V5Zm-3 3h8c2.22 0 4 1.78 4 4v4H8v-4c0-2.22 1.78-4 4-4ZM8 18h16v6c0 .57-.43 1-1 1H9c-.57 0-1-.43-1-1Zm3.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm9 0a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'transgender-alt-solid' => 'M4 4v7h2V7.4l3.06 3.1-1.78 1.78 1.44 1.44 1.78-1.78 1.31 1.31A5.03 5.03 0 0 0 15 20.91V23h-3v2h3v3h2v-3h3v-2h-3v-2.1a5.03 5.03 0 0 0 3.19-7.65L26 7.41V11h2V4h-7v2h3.6l-5.85 5.81A4.92 4.92 0 0 0 16 11c-1.02 0-1.96.29-2.75.81l-1.31-1.31 1.78-1.78-1.44-1.44-1.78 1.78L7.4 6H11V4Zm12 9c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Z',
        'transgender-solid' => 'M19 3v2h3.6l-4.41 4.4A7.01 7.01 0 0 0 7 15a7 7 0 0 0 6 6.9V25h-3v2h3v3h2v-3h3v-2h-3v-3.1a7 7 0 0 0 4.6-11.09l4.4-4.4V10h2V3Zm-5 7a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Z',
        'trash-alt-solid' => 'M15 4c-.52 0-1.06.18-1.44.56-.38.38-.56.92-.56 1.44v1H7v2h1v16c0 1.64 1.36 3 3 3h12c1.64 0 3-1.36 3-3V9h1V7h-6V6c0-.52-.18-1.06-.56-1.44A2.03 2.03 0 0 0 19 4Zm0 2h4v1h-4Zm-5 3h14v16a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1Zm2 3v11h2V12Zm4 0v11h2V12Zm4 0v11h2V12Z',
        'trash-alt' => 'M15 4c-.52 0-1.06.18-1.44.56-.38.38-.56.92-.56 1.44v1H7v2h1v16c0 1.64 1.36 3 3 3h12c1.64 0 3-1.36 3-3V9h1V7h-6V6c0-.52-.18-1.06-.56-1.44A2.03 2.03 0 0 0 19 4Zm0 2h4v1h-4Zm-5 3h14v16a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1Zm2 3v11h2V12Zm4 0v11h2V12Zm4 0v11h2V12Z',
        'trash-restore-alt-solid' => 'M15 4c-.52 0-1.06.18-1.44.56-.37.38-.56.92-.56 1.44v1H7v2h1v16c0 1.64 1.36 3 3 3h12c1.64 0 3-1.36 3-3V9h1V7h-6V6c0-.52-.18-1.06-.56-1.44A2.04 2.04 0 0 0 19 4h-4zm0 2h4v1h-4V6zm-5 3h14v16a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1V9zm7 3-4 4h3v7h2v-7h3l-4-4z',
        'trash-restore-solid' => 'M14 4c-.52 0-1.06.18-1.44.56-.38.38-.56.92-.56 1.44v1H5v2h1.1L8 27.1l.1.9h15.8l.1-.9L25.9 9H27V7h-7V6c0-.52-.18-1.06-.56-1.44A2.04 2.04 0 0 0 18 4h-4zm0 2h4v1h-4V6zM8.12 9h15.76l-1.79 17H9.91L8.12 9zM16 12l-4 4h3v7h2v-7h3l-4-4z',
        'trash-solid' => 'M14 4c-.52 0-1.06.18-1.44.56-.38.38-.56.92-.56 1.44v1H5v2h1.1L8 27.1l.1.9h15.8l.1-.9L25.9 9H27V7h-7V6c0-.52-.18-1.06-.56-1.44A2.03 2.03 0 0 0 18 4Zm0 2h4v1h-4ZM8.12 9h15.76l-1.79 17H9.91ZM12 12v11h2V12Zm3 0v11h2V12Zm3 0v11h2V12Z',
        'tree-solid' => 'm16 3.6-.72.68-5.94 5.97-1 .97 1.29.62s1.01.37 2.43.7l-4.4 4.4-1 .97 1.25.62s1.07.3 1.62.5l-3.6 3.6-.96 1 1.25.62s2.44 1.18 6.78 1.6V29h2v-3.03c.34.01.65.03 1 .03s.66-.02 1-.03V29h2v-3.16c4.35-.41 6.81-1.59 6.81-1.59l1.22-.63-.97-1-3.6-3.59c.56-.2 1.63-.5 1.63-.5l1.25-.62-1-.97-4.4-4.4c1.42-.33 2.43-.7 2.43-.7l1.29-.62-1-.97-5.94-5.97Zm0 2.84 4 3.97c-.6.2-.71.35-2.19.5l-1.81.18-1.81-.18c-1.48-.15-1.6-.3-2.19-.5Zm0 5 1.19 1.15 4.6 4.6c-.47.16-.46.22-1.41.4l-1.85.38 1.34 1.31 3.66 3.66C22.26 23.39 20.08 24 16 24c-4.04 0-6.21-.6-7.5-1.06l3.63-3.66 1.34-1.31-1.85-.38c-.95-.18-.94-.24-1.4-.4l4.6-4.6Z',
        'trello' => 'M5 5v22h22V5Zm2 2h8v14H7Zm10 0h8v9h-8Z',
        'tripadvisor' => 'M16 6.6c-4.25 0-8.22 1.13-10.94 2.96H0a7.45 7.45 0 0 1 1.6 3.19 7.95 7.95 0 0 0 6.43 12.66 8 8 0 0 0 6.19-2.97c.6.7 1.58 2.1 1.78 2.5 0 0 1.14-1.68 1.78-2.47a7.97 7.97 0 0 0 12.63-9.72A7.4 7.4 0 0 1 32 9.56h-5.31C23.97 7.73 20.25 6.6 16 6.6Zm0 1.34c2.85 0 5.44.53 7.72 1.53A7.98 7.98 0 0 0 16 17.44c0-4.4-3.54-7.96-7.94-7.97A20.3 20.3 0 0 1 16 7.94ZM8.03 11a6.43 6.43 0 0 1 0 12.84 6.43 6.43 0 0 1 0-12.84Zm15.94 0a6.43 6.43 0 0 1 0 12.84 6.43 6.43 0 0 1 0-12.84ZM7.94 13.53a3.88 3.88 0 1 0 0 7.76 3.88 3.88 0 0 0 0-7.76Zm16.03 0a3.85 3.85 0 1 0 0 7.72 3.85 3.85 0 1 0 0-7.72ZM7.94 14.72a2.7 2.7 0 0 1 0 5.37 2.7 2.7 0 0 1 0-5.37Zm16.03 0a2.67 2.67 0 1 1 0 5.34 2.67 2.67 0 1 1 0-5.34ZM7.75 16.09c-.72 0-1.31.6-1.31 1.32 0 .71.6 1.3 1.31 1.3.72 0 1.28-.59 1.28-1.3a1.3 1.3 0 0 0-1.28-1.32Zm16 0c-.72 0-1.28.6-1.28 1.32 0 .71.56 1.28 1.28 1.28a1.3 1.3 0 0 0 1.31-1.28c0-.72-.6-1.32-1.31-1.32Z',
        'trophy-solid' => 'M7 4c-.94 0-1.91.36-2.69 1.03A3.9 3.9 0 0 0 3 8a4.4 4.4 0 0 0 1 2.69c.55.72 1.23 1.28 1.84 1.84C7.08 13.65 8 14.57 8 16c0 .15-.15.52-.34.81-.2.3-.38.47-.38.47l1.44 1.4s.32-.31.62-.77c.27-.4.55-.9.63-1.57.11.33.22.66.34.97a19.66 19.66 0 0 0 2.38 4.57c.32.43.66.82 1.03 1.15A4 4 0 0 0 10 27v1h12v-1a4 4 0 0 0-3.78-3.97c.37-.33.73-.72 1.06-1.16a19.6 19.6 0 0 0 2.38-4.56c.13-.33.25-.68.37-1.03.07.69.36 1.22.63 1.63.3.46.62.78.62.78l1.44-1.4s-.18-.18-.38-.48c-.2-.29-.34-.66-.34-.81 0-1.43.92-2.35 2.16-3.47.61-.56 1.29-1.12 1.84-1.84A4.4 4.4 0 0 0 29 8a3.9 3.9 0 0 0-1.31-2.97A4.12 4.12 0 0 0 25 4c-1.28 0-2.15.58-2.63 1H9.63C9.15 4.58 8.29 4 7 4Zm0 2c.47 0 .78.15 1 .28.03 2.04.38 4.35.94 6.63-.53-.72-1.2-1.32-1.78-1.85-.64-.57-1.21-1.1-1.6-1.6A2.21 2.21 0 0 1 5 8c0-.7.27-1.13.66-1.47C6.04 6.2 6.56 6 7 6Zm18 0c.43 0 .96.2 1.34.53.39.34.66.77.66 1.47 0 .54-.18.97-.56 1.47-.39.5-.96 1.02-1.6 1.6-.6.53-1.27 1.15-1.8 1.9.57-2.29.93-4.62.96-6.69.22-.13.53-.28 1-.28ZM10.12 7h11.76a32.6 32.6 0 0 1-2.1 9.6 18.47 18.47 0 0 1-2.12 4.06c-.73.96-1.4 1.34-1.7 1.34-.28 0-.92-.38-1.65-1.34a17.9 17.9 0 0 1-2.12-4.07A32.6 32.6 0 0 1 10.13 7ZM15 10v5h2v-5Zm-1 15h4c.72 0 1.21.44 1.56 1h-7.12c.35-.56.84-1 1.56-1Z',
        'truck-loading-solid' => 'M17 5v16.07L2.73 25.04l.54 1.92 16.75-4.65a5 5 0 1 0 .35-2.17l-1.37.38V7h11V5H17zm-4.54 4.76L1.92 12.8l2.77 9.68 10.55-3.02-2.78-9.69zm-1.37 2.48 1.67 5.83L6.06 20 4.4 14.16l6.7-1.92zM25 19a3 3 0 1 1 0 6 3 3 0 0 1 0-6z',
        'truck-monster-solid' => 'M14 4a2 2 0 0 0-2 2v4H6a3 3 0 0 0-3 3v2.82A6.48 6.48 0 0 0 7.5 27a6.5 6.5 0 0 0 6.32-8h4.36a6.48 6.48 0 0 0 6.32 8A6.5 6.5 0 0 0 29 15.82V12a2 2 0 0 0-2-2h-3.46l-2.82-4.22A4 4 0 0 0 17.4 4H14zm0 2h3.4a2 2 0 0 1 1.66.9l2.07 3.1H14V6zm-8 6h21v2.5a6.46 6.46 0 0 0-7.97 2.5h-6.06A6.5 6.5 0 0 0 5 14.5V13a1 1 0 0 1 1-1zm1.5 4c.17 0 .34.03.5.05l-.05.48c.56.06 1.09.23 1.58.52l.24-.41a4.51 4.51 0 0 1 1.85 2.06l-.45.2c.22.5.33 1.04.33 1.6v.03l.5-.02c0 1-.34 1.9-.88 2.64l-.4-.28c-.32.44-.75.83-1.23 1.1l.23.42c-.65.38-1.4.61-2.22.61-.16 0-.32-.03-.48-.05l.05-.47a3.95 3.95 0 0 1-1.58-.52l-.24.41a4.51 4.51 0 0 1-1.86-2.05l.45-.2a3.95 3.95 0 0 1-.34-1.6v-.07l-.5.02c0-1 .35-1.9.9-2.64l.39.29c.33-.45.76-.83 1.24-1.1l-.23-.42c.65-.37 1.4-.6 2.2-.6zm17 0c.8 0 1.55.23 2.2.6l-.23.42c.48.27.91.65 1.24 1.1l.39-.3c.55.75.9 1.66.9 2.65l-.5.03c0 .57-.11 1.11-.34 1.63l.45.2a4.51 4.51 0 0 1-1.86 2.05l-.24-.42a4.1 4.1 0 0 1-1.58.52l.05.47c-.16.02-.32.05-.48.05a4.4 4.4 0 0 1-2.22-.61l.23-.42a4.04 4.04 0 0 1-1.23-1.1l-.4.28a4.46 4.46 0 0 1-.88-2.64l.5-.01c0-.56.11-1.1.33-1.6l-.45-.2a4.51 4.51 0 0 1 1.85-2.06l.24.41a3.9 3.9 0 0 1 1.58-.52l-.06-.48c.17-.02.34-.05.51-.05zm-17 3a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm17 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z',
        'truck-moving-solid' => 'M1 4v21h3.16c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3h8.32c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3H31V14.6l-.28-.32-6-6L24.4 8H19V4Zm2 2h14v17h-5.16A3.98 3.98 0 0 0 8 20a3.99 3.99 0 0 0-3.84 3H3Zm16 4h4.56L29 15.44V23h-1.16A3.98 3.98 0 0 0 24 20a3.99 3.99 0 0 0-3.84 3H19ZM8 22c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm16 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'truck-pickup-solid' => 'M10.72 6a2 2 0 0 0-1.9 1.38L7.27 12H0v8.22a2 2 0 0 0 1.5 1.94l2.6.65a3.99 3.99 0 0 0 7.75.19h9.3c.45 1.72 2 3 3.85 3s3.4-1.28 3.84-3H30a2 2 0 0 0 2-2v-3.75a4 4 0 0 0-2.9-3.84l-4.54-1.29-3.9-4.68A3.99 3.99 0 0 0 17.59 6Zm0 2H14v4H9.37ZM16 8h1.6c.59 0 1.15.26 1.52.72L21.88 12H16ZM2 14h21.84l4.72 1.34A1.96 1.96 0 0 1 30 17.25V21h-1.16A3.98 3.98 0 0 0 25 18a3.99 3.99 0 0 0-3.84 3h-9.32A3.98 3.98 0 0 0 8 18a3.98 3.98 0 0 0-3.78 2.78L2 20.22Zm6 6c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm17 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'truck-solid' => 'M1 4v21h3.16c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3h8.32c.44 1.72 1.99 3 3.84 3 1.85 0 3.4-1.28 3.84-3H31V14.6l-.28-.32-6-6L24.4 8H19V4Zm2 2h14v17h-5.16A3.98 3.98 0 0 0 8 20a3.99 3.99 0 0 0-3.84 3H3Zm16 4h4.56L29 15.44V23h-1.16A3.98 3.98 0 0 0 24 20a3.99 3.99 0 0 0-3.84 3H19ZM8 22c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm16 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'tshirt-solid' => 'M16 3c-.93 0-1.95.27-2.81.53-.85.26-1.48.52-1.5.53h-.03l-2.88.97-.1.03-.37.13-.31.1v.02a5.6 5.6 0 0 0-2.9 2.75c-1.04 2.19-1.1 4.9-1.1 4.9V15h4v14h16V15h4v-2.1s-.09-.84-.25-1.87c-.16-1.03-.33-2.16-.9-3.06A7.17 7.17 0 0 0 24 5.37v-.09l-.4-.12-.1-.04-.19-.06-2.97-1h-.03c-.02 0-.65-.27-1.5-.53A10.2 10.2 0 0 0 16 3Zm0 2c.43 0 1.43.23 2.22.47l.37.12c-.06.1-.1.19-.18.29A2.82 2.82 0 0 1 16 7a2.82 2.82 0 0 1-2.4-1.13l-.2-.28.38-.12C14.58 5.23 15.57 5 16 5Zm-4.56 1.22A5.03 5.03 0 0 0 16 9a5.03 5.03 0 0 0 4.56-2.78l1.44.5V27H10V6.72ZM8 7.56V13H6c0-.05.16-2.48.9-4.06.3-.64.7-1.08 1.1-1.38Zm16 .16c.37.3.77.71 1.16 1.31.16.26.47 1.38.62 2.31.15.89.21 1.58.22 1.66h-2Z',
        'tty-solid' => 'M16 4c-3.9 0-7.2.71-9.4 1.38a5.03 5.03 0 0 0-3.6 4.8V13c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2v-2.63c.19-.08.23-.12.78-.28.91-.26 2.3-.53 4.22-.53s3.3.27 4.22.53c.55.16.6.2.78.29V13c0 1.1.9 2 2 2h4a2 2 0 0 0 2-2v-2.81a5.04 5.04 0 0 0-3.6-4.81A33.41 33.41 0 0 0 16 4Zm0 2c3.65 0 6.77.66 8.84 1.28a3.02 3.02 0 0 1 2.16 2.9V13h-4V9.12l-.5-.28s-.64-.37-1.72-.68c-1.08-.32-2.67-.6-4.78-.6-2.1 0-3.7.28-4.78.6a8.36 8.36 0 0 0-1.72.68l-.5.29V13H5v-2.81a3 3 0 0 1 2.16-2.9A31.5 31.5 0 0 1 16 6Zm-6 11a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-12 6a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm6 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Z',
        'tumblr-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm8 3c0 1.66-.9 3-2 3v2h1v3.37c0 2 1.63 3.63 3.63 3.63a3.18 3.18 0 0 0 2.37-.9l-.71-2.11-.86.38c-.67.3-1.43-.2-1.43-.94V15h2v-2h-2v-3h-2z',
        'tumblr' => 'M14.22 5c-.68 0-1.25.57-1.25 1.25 0 1.51-.77 2.57-1.63 3.31a7.3 7.3 0 0 1-1.59 1.03l-.1.07c-.02 0-.11.03-.03 0-.48.19-.8.64-.8 1.15v2.22c0 .68.56 1.25 1.24 1.25h1.13v5.22c0 .36 0 1.84.69 3.38A5.18 5.18 0 0 0 16.71 27c3.93 0 5.89-1.56 6.03-1.69.27-.24.44-.59.44-.93v-2.66c0-.45-.27-.88-.66-1.1-.37-.2-.83-.16-1.22.07l-.03-.03-.03.03a5.3 5.3 0 0 1-2.34.65c-.62 0-.66-.17-.79-.4-.12-.23-.15-.63-.15-.53v-4.94h3.1c.67 0 1.24-.57 1.24-1.25v-3c0-.68-.57-1.25-1.25-1.25h-3.1V6.25c0-.68-.56-1.25-1.24-1.25Zm.56 2h1.19v4.97h4.34v1.5h-4.34v6.94a2.9 2.9 0 0 0 2.94 2.94c.9 0 1.68-.22 2.28-.44v1.03c-.26.2-1.43 1.06-4.47 1.06-1.84 0-2.52-.86-3-1.94a7.15 7.15 0 0 1-.53-2.56v-7.22H10.8v-.97c.1-.05.19-.08.31-.15.43-.24.97-.6 1.54-1.1A6.66 6.66 0 0 0 14.78 7Z',
        'tv-solid' => 'M2 7v16h28V7Zm2 2h24v12H4Zm6 15v2h12v-2Z',
        'twitch' => 'M6.5 5 5 9v16h5.5v3h3l3-3H21l6-6V5ZM9 7h16v11l-3 3h-6l-3 3v-3H9Zm5 4v6h2v-6Zm5 0v6h2v-6Z',
        'twitter-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm11.69 3.63a2.87 2.87 0 0 0-2.8 3.52 8.14 8.14 0 0 1-5.92-3 2.87 2.87 0 0 0 .89 3.84 2.87 2.87 0 0 1-1.3-.36v.03c0 1.4 1 2.55 2.3 2.82-.45.12-.85.12-1.29.05a2.87 2.87 0 0 0 2.68 2A5.75 5.75 0 0 1 9 20.7a8.12 8.12 0 0 0 4.4 1.3c5.28 0 8.17-4.37 8.17-8.16v-.38A6.1 6.1 0 0 0 23 11.98a5.7 5.7 0 0 1-1.65.44c.6-.35 1.04-.91 1.26-1.58-.56.33-1.18.57-1.82.7a2.86 2.86 0 0 0-2.1-.91z',
        'twitter' => 'M28 8.56c-.88.39-1.83.65-2.83.77a4.94 4.94 0 0 0 2.17-2.72c-.95.56-2 .97-3.13 1.2a4.92 4.92 0 0 0-8.39 4.48c-4.1-.2-7.72-2.16-10.15-5.14a4.92 4.92 0 0 0 1.52 6.57 4.9 4.9 0 0 1-2.23-.61v.06c0 2.38 1.7 4.38 3.95 4.83a4.9 4.9 0 0 1-2.22.08 4.93 4.93 0 0 0 4.6 3.42A9.88 9.88 0 0 1 4 23.54a13.92 13.92 0 0 0 7.55 2.21c9.06 0 14-7.5 14-14v-.64c.95-.7 1.79-1.57 2.45-2.55Z',
        'typo3' => 'M11.7 6.5c.1 2.5 1.5 6.5 2.9 9.5 1.8 3.8 3.4 5.6 4.7 6.5C17 25.6 15 27 14.4 27s-2.6-1.5-5-6.3C7.4 16.8 6 12.4 6 9.9c0-.5.1-.8.1-.9.8-.8 2.9-1.8 5.6-2.5M14.4 4c-3.9.5-8.4 1.9-9.9 3.8-.3.4-.5 1.1-.5 2.1C4 15.7 10 29 14.4 29c2 0 5.5-3.4 8.3-7.9-.4.1-.7.1-1.1.1-3.2 0-7.9-11.3-7.9-15 0-1.4.3-1.8.7-2.2zm5.9 2c4.4 0 5.5.8 5.7 1 0 3.3-1.7 6.7-2.6 7.8C22.1 13.6 20 9 20 6h.3m0-2c-1.7 0-2.3.3-2.3 2 0 3.7 3 11 5.6 11 1.5 0 4.4-5.5 4.4-10.1C28 4.6 24.3 4 20.3 4z',
        'uber' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13 13-5.8 13-13S23.2 3 16 3zm0 2c6.1 0 11 4.9 11 11s-4.9 11-11 11A10.96 10.96 0 0 1 5.05 17H13v2h6v-6h-6v2H5.05C5.55 9.37 10.24 5 16 5z',
        'ubuntu' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm3.5 3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM16 11c-2.75 0-5 2.25-5 5s2.25 5 5 5 5-2.25 5-5-2.25-5-5-5Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Zm-6.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm10 5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'uikit' => 'm22.2 6.7-4.3 2.5 5.1 2.9v7.8L16 24l-7-4.1v-5.5L5 12v10.5L16 29l11-6.5v-13zm-2-1.2L16 3l-4.2 2.5L16 8z',
        'umbraco' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5zm6.18 6-1.44.2a.24.24 0 0 0-.2.25v.03l.08.43c.07.42.15.96.23 1.61.08.67.12 1.35.13 2.02a7.17 7.17 0 0 1-.42 2.85c-.28.62-.9 1.22-1.56 1.36-.9.19-1.83.27-2.75.24h-.5c-.92.03-1.84-.05-2.75-.24a2.37 2.37 0 0 1-1.55-1.34 7.26 7.26 0 0 1-.46-2.87 26.93 26.93 0 0 1 .36-3.64l.08-.42v-.03a.24.24 0 0 0-.2-.24L9.8 11h-.03c-.11 0-.2.07-.24.18l-.08.4a20.01 20.01 0 0 0-.43 5.1 7.1 7.1 0 0 0 .67 3.13c.4.78 1.1 1.33 2.09 1.68.98.34 2.35.5 4.1.5h.22c1.76 0 3.12-.16 4.1-.5.99-.34 1.68-.9 2.1-1.68.4-.78.63-1.82.66-3.12a19.75 19.75 0 0 0-.43-5.11l-.08-.4a.24.24 0 0 0-.24-.19h-.04z',
        'umbrella-beach-solid' => 'M15 3v1.63c-1.96.2-4.46.98-6.78 2.28C5.5 8.43 3 10.66 3 13.66A3.35 3.35 0 0 0 6.34 17c.91 0 1.7-.38 2.29-.9l.03-.04A3.2 3.2 0 0 0 11 17a3.5 3.5 0 0 0 2.4-.97c.42.4.96.69 1.6.84v6.72c-1.54.28-2.6 1.1-2.6 1.1l1.2 1.62s1.15-.81 2.4-.81 2.4.81 2.4.81l1.2-1.62s-1.06-.82-2.6-1.1v-6.75a3.66 3.66 0 0 0 1.44-.75c.58.6 1.42.91 2.31.91 1 0 1.85-.43 2.44-1l.12.13c.6.51 1.4.87 2.28.87 1.87 0 3.41-1.5 3.41-3.31 0-2.99-2.46-5.22-5.16-6.75A18.37 18.37 0 0 0 17 4.62V3Zm.94 4c.13.19.25.28.4.6.52 1.03 1.09 2.84 1.16 5.8v.6c0 .02-.09.32-.34.56-.26.24-.62.44-1.16.44-1.09 0-1.5-.88-1.5-1v-.5c.05-3.26.62-5.1 1.13-6.06.12-.24.2-.3.3-.44Zm2.53.63c.21.12.38.16.6.3a6.9 6.9 0 0 1 3.15 5.76c-.03.23-.13.56-.34.81-.25.28-.56.5-1.13.5-.47 0-.72-.14-.9-.34-.2-.2-.35-.54-.35-1.07 0-.09 0-.19-.03-.28a16.6 16.6 0 0 0-1-5.69Zm-5.1.34a17.68 17.68 0 0 0-.84 5.34v.03c-.01.07-.03.13-.03.2v.05c0 .24-.13.63-.38.91-.24.28-.55.5-1.12.5-.47 0-.72-.14-.9-.34-.2-.2-.35-.54-.35-1.07l-.03-.25v-.03c.24-2.38 1.69-4 3.22-5.12.22-.16.22-.08.44-.22Zm-3.15.25C8.87 9.67 7.69 11.45 7.69 14c0 .02-.1.34-.38.6-.28.24-.67.4-.97.4-.8 0-1.34-.63-1.34-1.34 0-1.8 1.77-3.65 4.19-5 .33-.19.68-.28 1.03-.44Zm11.94.15c.22.12.46.16.68.29 2.4 1.36 4.16 3.21 4.16 5.03 0 .69-.57 1.31-1.4 1.31-.33 0-.7-.14-.98-.38-.26-.23-.37-.5-.37-.62v-.4c0-.1 0-.2-.03-.29a8.6 8.6 0 0 0-2.06-4.94ZM6 24a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm12 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2ZM8 27a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'umbrella-solid' => 'M15 4v2.06c-6.01.5-10.75 5.4-10.97 10.57L4 17h2c0-.08.09-.28.53-.53A4.11 4.11 0 0 1 8.5 16c.81 0 1.53.21 1.97.47.44.25.53.45.53.53h2c0-.01.08-.26.63-.53.54-.27 1.4-.47 2.37-.47.97 0 1.83.2 2.38.47.54.27.62.52.62.53h2c0-.08.09-.28.53-.53A4.11 4.11 0 0 1 23.5 16c.81 0 1.53.21 1.97.47.44.25.53.45.53.53h2c0-.13-.01-.25-.03-.38C27.75 11.47 23 6.57 17 6.06V4Zm1 4c4.35 0 8.06 2.95 9.44 6.28A6.56 6.56 0 0 0 23.5 14a6 6 0 0 0-2.97.72c-.2.11-.39.26-.56.4a4.54 4.54 0 0 0-.69-.43A7.4 7.4 0 0 0 16 14a7.4 7.4 0 0 0-3.28.69c-.24.11-.45.27-.66.44h-.03a3.8 3.8 0 0 0-.56-.41A6 6 0 0 0 8.5 14c-.7 0-1.34.1-1.94.28A10.51 10.51 0 0 1 16 8Zm-1 9v8c0 .57-.43 1-1 1-.57 0-1-.43-1-1v-1h-2v1c0 1.64 1.36 3 3 3s3-1.36 3-3v-8Z',
        'underline-solid' => 'M8 4v12c0 4.43 3.57 8 8 8s8-3.57 8-8V4h-2v12c0 3.37-2.63 6-6 6s-6-2.63-6-6V4ZM6 26v2h20v-2Z',
        'undo-alt-solid' => 'M16 3C12 3 8.4 4.8 6 7.7V4H4v8h8v-2H6.8A10.98 10.98 0 0 1 27 16c0 6.1-4.9 11-11 11S5 22.1 5 16H3c0 7.2 5.8 13 13 13s13-5.8 13-13S23.2 3 16 3z',
        'undo-solid' => 'm12.78 5.28-8 8-.69.72.7.72 8 8 1.43-1.44L7.94 15H21c2.75 0 5 2.25 5 5v7h2v-7c0-3.84-3.16-7-7-7H7.94l6.28-6.28Z',
        'uniregistry' => 'M6 4.7v.1h5v-.1H6zm15 0v.1h5v-.1h-5zM6 6.5v.3h5v-.3H6zm15 0v.3h5v-.3h-5zM6 8.3v.4h5v-.4H6zm15 0v.4h5v-.4h-5zM6 10.1v.5h5v-.5H6zm15 0v.5h5v-.5h-5zM6 11.9v.6h5v-.6H6zm15 0v.6h5v-.6h-5zM6 13.7v.8h5v-.8H6zm15 0v.8h5v-.8h-5zM6 15.5v.9h5v-.9H6zm15 0v.9h5v-.9h-5zM6 17.3v1h5v-1H6zm15 0v1h5v-1h-5zM6.1 19.1c0 .4.1.8.2 1.2h5.3c-.2-.4-.4-.8-.5-1.2h-5zm14.8 0c-.1.4-.2.8-.4 1.2h5.3c.1-.4.2-.8.2-1.2h-5.1zM6.4 20.9c.1.4.3.9.5 1.3h6.4c-.5-.3-1-.8-1.3-1.3H6.4zm13.6 0c-.4.5-.8 1-1.4 1.3h6.5c.2-.4.3-.9.5-1.3H20zM7.2 22.7c.3.5.5 1 .8 1.4h15.9c.4-.4.7-.9.9-1.4H7.2zm1.1 1.8c.5.6 1.1 1.1 1.7 1.6h11.9c.6-.5 1.2-1 1.7-1.6H8.3zm2.1 1.8C12 27.4 13.9 28 16 28c2.1 0 4-.6 5.6-1.7H10.4z',
        'universal-access-solid' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c5.54 0 10 4.46 10 10s-4.46 10-10 10S6 21.54 6 16 10.46 6 16 6Zm0 2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-5.78 4.03-.44 1.94 4.22.94V19l-.97 4.81 1.94.38 1-5 .03-.1.03.1 1 5 1.94-.38L18 19v-4.1l4.22-.93-.44-1.94-4.28.97h-3Z',
        'university-solid' => 'm16 3.88-.44.21L5.56 9 5 9.28V11h22V9.28L26.44 9l-10-4.9Zm0 2.25L21.88 9H10.13ZM7 12v10H6v2h20v-2h-1V12h-2v10h-2V12h-2v10h-2V12h-2v10h-2V12h-2v10H9V12ZM4 25v2h24v-2Z',
        'unlink-solid' => 'M21.75 4c-1.6 0-3.22.63-4.44 1.84l-1.47 1.47a6.22 6.22 0 0 0-1.78 3.63l2 .25c.12-.9.5-1.78 1.19-2.47l1.47-1.47a4.25 4.25 0 0 1 6.03 0 4.25 4.25 0 0 1 0 6.03l-1.47 1.47h-.03c-.7.7-1.54 1.08-2.44 1.19l.25 2a6.22 6.22 0 0 0 3.63-1.78l1.47-1.47A6.27 6.27 0 0 0 21.75 4ZM7.72 6.28 6.28 7.72l4 4 1.44-1.44Zm3.22 7.78a6.31 6.31 0 0 0-3.63 1.78l-1.47 1.47a6.27 6.27 0 0 0 0 8.85 6.27 6.27 0 0 0 8.85 0l1.47-1.47a6.22 6.22 0 0 0 1.78-3.63l-2-.25c-.12.9-.5 1.78-1.19 2.47l-1.47 1.47a4.25 4.25 0 0 1-6.03 0 4.25 4.25 0 0 1 0-6.03l1.47-1.47h.03c.7-.7 1.54-1.08 2.44-1.19Zm10.78 6.22-1.44 1.44 4 4 1.44-1.44Z',
        'unlock-alt-solid' => 'M16 3a7.17 7.17 0 0 0-6.63 4.63l1.85.75A5.21 5.21 0 0 1 16 5c2.75 0 5 2.25 5 5v1.38A9.9 9.9 0 0 0 16 10c-5.51 0-10 4.49-10 10s4.49 10 10 10a10.02 10.02 0 0 0 7-17.13V10c0-3.84-3.16-7-7-7Zm0 9c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8Zm0 6a2 2 0 0 0-1 3.72V25h2v-3.28A2 2 0 0 0 16 18Z',
        'unlock-solid' => 'M16 3a7.17 7.17 0 0 0-6.63 4.63l1.85.75A5.21 5.21 0 0 1 16 5c2.75 0 5 2.25 5 5v3H6v16h20V13h-3v-3c0-3.84-3.16-7-7-7ZM8 15h16v12H8Z',
        'untappd' => 'M18.2 5.3c-.1 0-.1.1-.1.2v.2c0 .2-.2.2-.3.2-.1 0-.1.1-.1.3-5.3 5.4-4.9 5.5-5.7 5.9l-1.2.7c-.5.2-.9.6-1.2 1l-6.3 8.8c-.3.4-.4 1-.1 1.5.7 1.5 2.3 2.7 4 2.9.5 0 1-.2 1.3-.6l6.3-8.8c.3-.4.5-.9.6-1.4l.2-1.4c.1-.9.3-.6 3.7-7.3.2-.2.3-.2.3-.3 0-.1 0-.3.1-.3h.2c.1 0 .1-.1.1-.2-.1-.1-.2-.5-.7-1-.5-.4-.9-.4-1.1-.4zm-4.3.1c-.2 0-.6 0-1.1.4-.5.4-.7.7-.7.9-.1.1-.1.2 0 .2h.2c.1 0 .1.2.1.3 0 .1.1.1.3.3.3.7.7 1.3.9 1.9.5-.5 1.1-1.2 1.9-2-.3-.4-.7-.7-1.1-1.1 0-.2 0-.3-.1-.3s-.3 0-.3-.2v-.2c0-.1 0-.2-.1-.2zm4.6 5.2c-.8 1.6-1.4 2.6-1.7 3.1-.4.8-.5.8-.5 1.1l.2 1.3c.1.5.3 1 .6 1.4l6.3 8.8c.3.4.9.7 1.4.6 1.7-.2 3.3-1.4 4-2.9.3-.4.2-1-.1-1.4l-6.3-8.8c-.3-.4-.7-.8-1.2-1l-1.2-.7c-.4-.2-.5-.4-1.5-1.5z',
        'upload-solid' => 'm16 3.6-.72.68-7 7 1.44 1.44L15 7.44V24h2V7.44l5.28 5.28 1.44-1.44-7-7ZM7 26v2h18v-2Z',
        'ups' => 'M15.51 2.99C11.55 3.08 7.75 4 5 5.5v12.8c0 6.1 4.4 7.9 11 10.8 6.6-2.9 11-4.7 11-10.8V5.5c-3.4-1.85-7.53-2.6-11.49-2.51zm5.51 2.51c1.7-.04 3.38.05 4.98.2v12.5c0 5.1-3.1 6.7-10 9.7-6.9-3-10-4.6-10-9.7V11c4.5-4.13 9.9-5.38 15.02-5.5zm-4.85 5.53a4.7 4.7 0 0 0-2.47.67V24h1.9v-4c1.4.4 4.1-.1 4.1-4.5 0-3.5-1.84-4.46-3.53-4.47zm6.37.03c-1.27.1-2.44.94-2.44 2.44 0 2.8 3 2.5 3 4.1.1 1.4-1.7 1.3-2.9.3v1.7c2.1 1.3 4.7.5 4.8-1.9.1-3-3.1-2.7-3.1-4.3 0-1.1 1.8-1.2 2.8-.1v-1.6c-.6-.49-1.4-.7-2.16-.64zM7 11.2v5.9c0 4.4 4.7 3 5.7 2.3v-8.2h-1.9v7.1c-.3.2-1.9.7-1.9-1.1v-6H7zm9.05 1.36c.7-.06 1.65.31 1.65 2.94.1 4-2 3-2.2 3v-5.8c.13-.05.32-.12.55-.14z',
        'usb' => 'm16 3-3 5h2v12.06a9.42 9.42 0 0 0-2.34-.56 7.92 7.92 0 0 1-2.1-.47c-.42-.22-.56-.32-.56-1.03v-2.28a2 2 0 1 0-2 0V18c0 1.3.73 2.31 1.63 2.78.89.47 1.84.6 2.71.72.88.13 1.68.25 2.1.47.42.22.56.32.56 1.03v.19a3 3 0 1 0 2 0V21c0-.67.2-.86.75-1.19.56-.32 1.5-.6 2.5-.84 1-.25 2.06-.48 3-1.03A3.45 3.45 0 0 0 25 15v-2h1V9h-4v4h1v2c0 .67-.2.86-.75 1.19-.56.32-1.5.6-2.5.84-.91.23-1.88.45-2.75.9V8h2Z',
        'user-alt-slash-solid' => 'M3.7 2.3 2.3 3.7l6.84 6.84-.04.16 1.9 1.8v-.1l4.6 4.6h-.1l2.3 2.3.12.02.38.38 1.5 1.5 4.1 4.1 1.8 1.8 2.6 2.6 1.4-1.4-4.14-4.14a9.97 9.97 0 0 0-5.66-6.26A6.98 6.98 0 0 0 16 5.1a7.02 7.02 0 0 0-6.04 3.46L3.7 2.3zM16 7c2.8 0 5 2.2 5 5a4.94 4.94 0 0 1-3 4.6L11.4 10c.76-1.78 2.51-3 4.6-3zm-6.8 6.3c.4 1.9 1.4 3.5 3 4.5A9.92 9.92 0 0 0 6 27h2c0-2.9 1.5-5.4 3.8-6.8.7 1.6 2.3 2.8 4.2 2.8.8 0 1.6-.2 2.2-.6l-1.5-1.5c-.2.1-.5.1-.7.1-1.1 0-2-.7-2.3-1.7l1.2-.3-5.7-5.7z',
        'user-alt-solid' => 'M16 5a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 6 27h2c0-2.9 1.53-5.4 3.81-6.81a4.54 4.54 0 0 0 8.38 0A7.98 7.98 0 0 1 24 27h2c0-4.12-2.53-7.66-6.1-9.19A7.01 7.01 0 0 0 16 5Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm0 12c.82 0 1.6.12 2.34.34a2.48 2.48 0 0 1-4.68 0A7.99 7.99 0 0 1 16 19Z',
        'user-astronaut-solid' => 'M16 4c-5 0-9 4-9 9-.3 0-.6.2-.8.4-.2.3-.3.6-.1.9l1 3c.1.4.5.7.9.7h.5c.2.29.4.56.63.82.3.48.67.91 1.08 1.3A9 9 0 0 0 7 27h2a7.03 7.03 0 0 1 2.92-5.7c.93.44 1.97.7 3.08.7h2a7 7 0 0 0 3.04-.69A7.04 7.04 0 0 1 23 27h2a8.87 8.87 0 0 0-3.24-6.85c.42-.4.8-.84 1.11-1.33.23-.26.44-.53.63-.82h.5c.4 0 .8-.3.9-.7l1-3c.2-.3.1-.6-.1-.9-.2-.2-.5-.4-.8-.4 0-5-4-9-9-9zm0 2a6.94 6.94 0 0 1 6.9 5.88A4.95 4.95 0 0 0 19 10h-6c-1.6 0-3 .74-3.9 1.88A6.94 6.94 0 0 1 16 6zm-3 6h6c1.7 0 3 1.3 3 3 0 .72-.15 1.39-.4 2H17a1 1 0 0 0 0 2h2.62a7 7 0 0 1-8.86-1.34A5.01 5.01 0 0 1 10 15c0-1.7 1.3-3 3-3z',
        'user-check-solid' => 'M12 2a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 2 24h2a7.99 7.99 0 0 1 11.78-7.03 8 8 0 1 0 1.53-1.44c-.44-.28-.92-.51-1.4-.72A7.01 7.01 0 0 0 12 2Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm10 12a6 6 0 1 1 .02 11.98A6 6 0 0 1 22 16Zm3.28 3.28L22 22.56l-2.28-2.28-1.44 1.44 3 3 .72.69.72-.7 4-4Z',
        'user-circle-solid' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 3a4.98 4.98 0 0 0-3.22 8.78A7 7 0 0 0 9 23h2a4.99 4.99 0 1 1 10 0h2a7 7 0 0 0-3.78-6.22A4.98 4.98 0 0 0 16 8Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Z',
        'user-circle' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26Zm0 2c6.09 0 11 4.91 11 11s-4.91 11-11 11S5 22.09 5 16 9.91 5 16 5Zm0 3a4.98 4.98 0 0 0-3.22 8.78A7 7 0 0 0 9 23h2a4.99 4.99 0 1 1 10 0h2a7 7 0 0 0-3.78-6.22A4.98 4.98 0 0 0 16 8Zm0 2c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Z',
        'user-clock-solid' => 'M16 5.1c-3.9 0-7 3.1-7 7 0 2.4 1.2 4.6 3.1 5.8C8.5 19.3 6 22.9 6 27h2c0-4.4 3.6-8 8-8 .6 0 1.1.1 1.6.2l.16-.18A7.95 7.95 0 0 0 16 24c0 4.4 3.6 8 8 8s8-3.6 8-8a8.02 8.02 0 0 0-10.54-7.58A6.96 6.96 0 0 0 16 5.1zM16 7c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm3.28 10.57-.1.06.1-.06zM24 18c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6zm-5.5.21zM23 20v4.6l-1.7 1.7 1.4 1.4 2.3-2.3V20h-2z',
        'user-cog-solid' => 'M16 5c-3.9 0-7 3.1-7 7a6.96 6.96 0 0 0 3.07 5.81A10.03 10.03 0 0 0 6 27h2c0-4.4 3.6-8 8-8 3.9 0 7-3.1 7-7s-3.1-7-7-7zm0 2c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm8.1 11v2.1c-.6.1-1.2.4-1.7.7l-1.5-1.5-1.4 1.4 1.5 1.5c-.4.5-.6 1.1-.7 1.8H18v2h2.1c.1.6.4 1.2.7 1.8l-1.5 1.5 1.4 1.4 1.5-1.5c.5.3 1.1.6 1.7.7V32h2v-2.1c.6-.1 1.2-.4 1.7-.7l1.5 1.5 1.4-1.4-1.5-1.5c.4-.5.6-1.1.7-1.8H32v-2h-2.1c-.1-.6-.4-1.2-.7-1.8l1.5-1.5-1.4-1.4-1.5 1.5c-.5-.3-1.1-.6-1.7-.7V18h-2zm.9 4c1.7 0 3 1.3 3 3s-1.3 3-3 3-3-1.3-3-3 1.3-3 3-3zm0 2a.87.87 0 0 0-.37.09 1.14 1.14 0 0 0-.54.54.87.87 0 0 0-.09.37c0 .38.28.75.63.91.12.06.25.09.37.09.5 0 1-.5 1-1s-.5-1-1-1z',
        'user-edit-solid' => 'M13 3a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 3 25h2a7.95 7.95 0 0 1 13.5-5.75l-4.72 4.72-.06.31-.69 3.53-.31 1.47 1.47-.31 3.53-.69.31-.06 10.1-10.1a3 3 0 0 0-4.22-4.28l-3.97 3.97a10.1 10.1 0 0 0-3.03-2A7.01 7.01 0 0 0 13 3Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm13 10a1 1 0 0 1 .72.28c.4.4.4 1 0 1.4l-9.69 9.7-1.78.37.38-1.78 9.68-9.69c.2-.2.44-.28.69-.28Z',
        'user-friends-solid' => 'M9 7a6 6 0 0 0-3.53 10.84A8 8 0 0 0 1 25h2a6 6 0 1 1 12 0h2a6 6 0 1 1 12 0h2a8 8 0 0 0-4.47-7.16 6 6 0 1 0-7.06 0A8.06 8.06 0 0 0 16 21.13a8.06 8.06 0 0 0-3.47-3.29A6 6 0 0 0 9 7Zm0 2c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Zm14 0c2.22 0 4 1.78 4 4 0 2.22-1.78 4-4 4-2.22 0-4-1.78-4-4 0-2.22 1.78-4 4-4Z',
        'user-graduate-solid' => 'M16 3 3 7l3.1.95 2.9.9v2.66c-.13.15-.22.3-.3.45-.17.38-.29.8-.39 1.3-.19.95-.29 2.18-.3 3.53A2.96 2.96 0 0 0 7 19c0 1.28.9 2.2 2.04 2.63a11.7 11.7 0 0 0 2.29 3.95C12.52 26.91 14.1 28 16 28s3.48-1.1 4.67-2.42a11.84 11.84 0 0 0 2.3-3.95C24.08 21.2 25 20.28 25 19c0-.88-.4-1.68-1.01-2.23a19.65 19.65 0 0 0-.3-3.5c-.1-.5-.22-.93-.4-1.3a2.2 2.2 0 0 0-.29-.46V8.84L29 7Zm0 2.1L22.2 7 16 8.9 9.8 7Zm-5 4.36L16 11l.3-.09L21 9.46v2.32c-.01.02 0 .02-.05.05-.15.13-.48.33-.92.5-.9.36-2.28.67-4.03.67-1.75 0-3.13-.3-4.03-.66a3.69 3.69 0 0 1-.92-.5c-.05-.04-.04-.04-.05-.06Zm-.73 4.25c.28.17.6.34.96.48 1.18.47 2.8.81 4.77.81 1.98 0 3.59-.34 4.77-.8.36-.15.68-.32.96-.5.16.82.27 2 .27 3.3v.85l.5.3c.3.16.5.47.5.85 0 .54-.4.95-.92.99l-.67.05-.2.65a10.25 10.25 0 0 1-2.03 3.56C18.22 25.32 17.1 26 16 26s-2.22-.68-3.18-1.75a10.25 10.25 0 0 1-2.03-3.56l-.2-.65-.67-.05A.98.98 0 0 1 9 19c0-.38.2-.68.5-.86l.52-.3L10 17v-.01c0-1.3.1-2.47.27-3.28ZM8.17 17H9l-.84.02ZM13 18a1 1 0 0 0 0 2 1 1 0 0 0 0-2Zm6 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'user-injured-solid' => 'M16 5c-3.9 0-7 3.1-7 7 0 2.43 1.2 4.56 3.06 5.8a9.82 9.82 0 0 0-5.96 8.1c-.1.5.1 1.1.5 1.5.3.4.9.6 1.4.6h9c1.7 0 3-1.3 3-3s-1.3-3-3-3h-3.8l-.8-2.13A7.89 7.89 0 0 1 16 19c4.4 0 8 3.6 8 8h2c0-4.1-2.51-7.65-6.07-9.19A6.96 6.96 0 0 0 23 12c0-3.9-3.1-7-7-7zm0 2c.42 0 .82.06 1.2.16L13.66 10h-2.24c.76-1.78 2.5-3 4.59-3zm3.18 1.14c.6.5 1.1 1.12 1.41 1.86h-3.74l2.33-1.86zM11 12h10c0 2.8-2.2 5-5 5s-5-2.2-5-5zm-.3 9.04L12.55 26H8.1a7.98 7.98 0 0 1 2.6-4.96zM13.94 24H17c.6 0 1 .4 1 1s-.4 1-1 1h-2.3l-.76-2z',
        'user-lock-solid' => 'M16 5c-3.9 0-7 3.1-7 7a6.96 6.96 0 0 0 3.07 5.81A10.03 10.03 0 0 0 6 27h2c0-4.4 3.6-8 8-8 1.2 0 2.4.3 3.4.8.3-.6.6-1.2 1.1-1.7l-.6-.27A6.96 6.96 0 0 0 23 12c0-3.9-3.1-7-7-7zm0 2c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm9 11c-2.2 0-4 1.8-4 4v2h-3v8h14v-8h-3v-2c0-2.2-1.8-4-4-4zm0 2a2 2 0 0 1 2 2v2h-4v-2c0-1.1.9-2 2-2zm-5 6h10v4H20v-4z',
        'user-md-solid' => 'm8.44 6-.28.47S5 11.65 5 20v1h6.1a5.01 5.01 0 0 0 4.9 6 5.01 5.01 0 0 0 4.9-6H27v-1c0-4.6-.78-7.99-1.56-10.22-.79-2.23-1.63-3.37-1.63-3.37L23.5 6Zm1.22 2h12.71c.15.2.58.73 1.2 2.47A29.21 29.21 0 0 1 24.9 19H20a5.02 5.02 0 0 0-8 0H7.1c.22-6.65 2.22-10.43 2.56-11ZM15 10v2h-2v2h2v2h2v-2h2v-2h-2v-2Zm1 9c1.67 0 3 1.33 3 3s-1.33 3-3 3-3-1.33-3-3 1.33-3 3-3Zm0 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2Z',
        'user-minus-solid' => 'M14 4c-3.9 0-7 3.1-7 7 0 2.4 1.2 4.6 3.1 5.8A9.98 9.98 0 0 0 4 26h2c0-4.4 3.6-8 8-8 1.4 0 2.7.4 3.8 1a8.04 8.04 0 0 0-1.8 5c0 4.4 3.6 8 8 8s8-3.6 8-8a8.02 8.02 0 0 0-12.7-6.5c-.4-.3-.9-.5-1.4-.7A6.98 6.98 0 0 0 14 4zm0 2c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm10 12c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6zm-4 5v2h8v-2h-8z',
        'user-ninja-solid' => 'M16 5a6.95 6.95 0 0 0-6.33 4H9.6l-.15.52-.18.54-.02.06L5.6 7.2 4.4 8.8 7.1 11H4v2h5.07a5.27 5.27 0 0 0 .38 1.48l.15.52h.07a6.93 6.93 0 0 0 2.4 2.81A10.03 10.03 0 0 0 6 27h2c0-4.4 3.6-8 8-8s8 3.6 8 8h2c0-4.1-2.51-7.65-6.07-9.19a6.93 6.93 0 0 0 2.4-2.81h.07l.03-.2A7.04 7.04 0 0 0 16 5zm0 2c1.66 0 3.1.79 4 2h-8c.9-1.21 2.34-2 4-2zm-4.9 4h9.8l.02.1a5.2 5.2 0 0 1 0 1.8c-.01.03 0 .07-.02.1h-9.8l-.02-.1a5.2 5.2 0 0 1 0-1.8c.01-.03 0-.07.02-.1zm.9 4h8c-.9 1.21-2.34 2-4 2-1.66 0-3.1-.79-4-2z',
        'user-nurse-solid' => 'm10.16 4-.16.81-1 5.63V14h.1c.28 2 1.4 3.73 3 4.81A10.03 10.03 0 0 0 6 28h2a7.99 7.99 0 0 1 3-6.25v.66l.28.3 4 4 .72.7.72-.7 4-4 .28-.3v-.66A7.99 7.99 0 0 1 24 28h2c0-4.12-2.53-7.66-6.1-9.19a7.03 7.03 0 0 0 3-4.81h.1v-3.56L22 4.8l-.16-.8Zm1.68 2h8.32l.84 4.78V12H11v-1.22ZM15 7v1h-1v2h1v1h2v-1h1V8h-1V7Zm-3.9 7h9.8a5 5 0 0 1-9.8 0Zm4.9 6c1.06 0 2.07.2 3 .56v1l-3 3-3-3v-1a8.05 8.05 0 0 1 3-.56Z',
        'user-plus-solid' => 'M12 2a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 2 24h2a7.99 7.99 0 0 1 11.78-7.03 8 8 0 1 0 1.53-1.44c-.44-.28-.92-.51-1.4-.72A7.01 7.01 0 0 0 12 2Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm10 12a6 6 0 1 1 .02 11.98A6 6 0 0 1 22 16Zm-1 2v3h-3v2h3v3h2v-3h3v-2h-3v-3Z',
        'user-secret-solid' => 'M13.06 4c-.87 0-1.64.45-2.19 1.03a7.47 7.47 0 0 0-1.28 2.1 27.35 27.35 0 0 0-1.25 3.8c-1.08.32-2 .72-2.75 1.2C4.73 12.68 4 13.46 4 14.5c0 .9.55 1.63 1.25 2.16.6.44 1.32.81 2.19 1.12.05.23.12.47.22.69-.85.48-2.18 1.4-3.47 3.16l-.6.84.85.6 3.28 2.24L6.38 28h19.25l-1.35-2.69 3.28-2.25.85-.6-.6-.84a11.03 11.03 0 0 0-3.47-3.15c.1-.22.17-.46.22-.69.87-.3 1.6-.68 2.19-1.12.7-.53 1.25-1.25 1.25-2.16 0-1.04-.73-1.82-1.6-2.38-.74-.47-1.66-.87-2.74-1.18a34.7 34.7 0 0 0-1.32-3.88A7.11 7.11 0 0 0 21.1 5a3 3 0 0 0-2.15-1c-.58 0-1.03.16-1.5.28-.48.12-.96.22-1.44.22-.96 0-1.77-.5-2.94-.5Zm0 2c.21 0 1.44.5 2.94.5a7.9 7.9 0 0 0 1.94-.28c.52-.13.91-.22 1-.22.23 0 .4.07.68.38.29.3.63.84.91 1.5.54 1.24.96 2.93 1.4 4.5 0 0 .06-.05-.09.03-.25.13-.77.3-1.4.4-1.27.2-3 .19-4.44.19-1.43 0-3.16-.02-4.44-.22a4.83 4.83 0 0 1-1.4-.4c-.08-.05-.1-.03-.13-.04v-.06l.03-.03a.98.98 0 0 0 .13-.44v-.03c.36-1.33.76-2.73 1.25-3.84.29-.67.6-1.21.9-1.53.3-.32.5-.41.72-.41ZM8.2 13.1c.22.46.62.84 1.03 1.06.6.32 1.3.47 2.06.59 1.5.23 3.27.25 4.72.25 1.44 0 3.2 0 4.72-.22a6.18 6.18 0 0 0 2.06-.6c.41-.22.81-.61 1.03-1.09a7.5 7.5 0 0 1 1.5.7c.58.37.69.64.69.71 0 .06-.05.25-.47.56a7.3 7.3 0 0 1-2.06.97A25.9 25.9 0 0 1 16 17a25.9 25.9 0 0 1-7.47-.97 7.3 7.3 0 0 1-2.06-.97c-.42-.31-.47-.5-.47-.56 0-.07.08-.32.66-.69a8 8 0 0 1 1.53-.72Zm2.6 5.46c.32.06.64.15 1 .19.12.88.8 1.65 1.9 1.72.84.05 1.79-.35 1.87-1.47h.88c.08 1.12 1.03 1.52 1.87 1.47a1.99 1.99 0 0 0 1.9-1.72c.36-.04.68-.13 1-.19l-.09.63a9.05 9.05 0 0 1-1.96 4.22A4.26 4.26 0 0 1 16 25a4.26 4.26 0 0 1-3.16-1.63 9.13 9.13 0 0 1-1.96-4.18ZM23 20c.37.22 1.35.86 2.47 2.1l-3.03 2.09-.72.47.37.78.29.56h-3.16c.52-.35 1-.8 1.44-1.28a10.66 10.66 0 0 0 2.25-4.66L23 20Zm-14.03.03.12.06a10.83 10.83 0 0 0 2.25 4.6c.45.5.98.95 1.54 1.31H9.62l.29-.56.37-.78-.72-.47-3.03-2.1a11.23 11.23 0 0 1 2.44-2.06Z',
        'user-shield-solid' => 'M16 5c-3.9 0-7 3.1-7 7a6.96 6.96 0 0 0 3.07 5.81A10.03 10.03 0 0 0 6 27h2c0-4.4 3.6-8 8-8 .34 0 .67-.03 1-.08v4.58c0 5.2 6.8 8.2 7.1 8.3l.4.2.4-.2c.3-.1 7.1-3.1 7.1-8.3V18h-.9c-1.9 0-3-.7-3.9-1.2-.9-.4-1.7-.8-2.7-.8-1 0-1.8.4-2.5.8-.5.28-1.11.62-1.88.87A6.96 6.96 0 0 0 23 12c0-3.9-3.1-7-7-7zm0 2c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm8.5 11c.5 0 .9.2 1.7.6l.3.1c.8.4 1.9 1 3.5 1.2v3.5c0 3.3-4.3 5.7-5.5 6.3-1.2-.6-5.5-3-5.5-6.3v-3.5c1.7-.2 2.8-.8 3.6-1.2l.3-.1h.2c.6-.5.9-.6 1.4-.6z',
        'user-slash-solid' => 'M3.7 2.3 2.3 3.7l6.82 6.82-.02.08 1.9 1.9v-.1l4.6 4.6h-.1l2.2 2.2.15.04 5.81 5.82.04.14 1.8 1.8h.1l2.7 2.7 1.4-1.4-4.1-4.1a9.97 9.97 0 0 0-5.7-6.4A6.98 6.98 0 0 0 16 5a7.01 7.01 0 0 0-6.08 3.52L3.7 2.3zM16 7c2.8 0 5 2.2 5 5a4.94 4.94 0 0 1-3 4.6L11.4 10c.76-1.78 2.51-3 4.6-3zm-6.9 6.3c.4 1.9 1.4 3.5 3 4.5A9.98 9.98 0 0 0 6 27h2c0-4.1 3-7.4 6.9-7.9l-5.8-5.8z',
        'user-solid' => 'M16 5a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 6 27h2c0-4.43 3.57-8 8-8s8 3.57 8 8h2c0-4.12-2.53-7.66-6.1-9.19A7.01 7.01 0 0 0 16 5Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Z',
        'user-tag-solid' => 'M16 5c-3.9 0-7 3.1-7 7a6.96 6.96 0 0 0 3.07 5.81A10.03 10.03 0 0 0 6 27h2c0-4.4 3.6-8 8-8 3.9 0 7-3.1 7-7s-3.1-7-7-7zm0 2c2.8 0 5 2.2 5 5s-2.2 5-5 5-5-2.2-5-5 2.2-5 5-5zm5 12a2 2 0 0 0-2 2v4.4l6 6c.4.4.9.6 1.4.6.5 0 1-.2 1.4-.6l3.6-3.6c.4-.4.6-.9.6-1.4 0-.5-.2-1-.6-1.4l-6-6H21zm0 2h3.6l5.4 5.4-3.6 3.6-5.4-5.4V21zm2 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2z',
        'user-tie-solid' => 'M16 4a7 7 0 0 0-7 7 7.01 7.01 0 0 0 3.03 5.75C7.93 18.35 5 22.35 5 27h2c0-4.4 3.2-8.07 7.38-8.84L15 20h2l.63-1.84A9.02 9.02 0 0 1 25 27h2c0-4.65-2.93-8.65-7.03-10.25A7.01 7.01 0 0 0 23 11a7 7 0 0 0-7-7Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm-1 15-1 6h4l-1-6Z',
        'user-times-solid' => 'M12 2a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 2 24h2a7.99 7.99 0 0 1 11.78-7.03 8 8 0 1 0 1.53-1.44c-.44-.28-.92-.51-1.4-.72A7.01 7.01 0 0 0 12 2Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm10 12a6 6 0 1 1 .02 11.98A6 6 0 0 1 22 16Zm-2.28 2.28-1.44 1.44L20.56 22l-2.28 2.28 1.44 1.44L22 23.44l2.28 2.28 1.44-1.44L23.44 22l2.28-2.28-1.44-1.44L22 20.56Z',
        'user' => 'M16 5a7.01 7.01 0 0 0-3.9 12.81A10.03 10.03 0 0 0 6 27h2c0-4.43 3.57-8 8-8s8 3.57 8 8h2c0-4.12-2.53-7.66-6.1-9.19A7.01 7.01 0 0 0 16 5Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Z',
        'users-cog-solid' => 'M8 5c-3.3 0-6 2.7-6 6 0 2 1 3.8 2.5 4.8A8.13 8.13 0 0 0 0 23h2c0-3.3 2.7-6 6-6s6 2.7 6 6h2c0-3.2 2.6-5.9 5.8-6h.2c2.5 0 4.6-1.5 5.5-3.6 0 0 0-.1.1-.1.1-.1.1-.3.1-.4 0-.1 0-.1.1-.2 0-.1.1-.3.1-.4 0-.1 0-.2.1-.3 0-.1 0-.2.1-.3v-.6c0-3.3-2.7-6-6-6s-6 2.7-6 6c0 2 1 3.8 2.5 4.8-1.5.7-2.7 1.9-3.5 3.3-.8-1.4-2-2.6-3.5-3.3A6.3 6.3 0 0 0 14 11c0-3.3-2.7-6-6-6zm0 2c2.2 0 4 1.8 4 4s-1.8 4-4 4-4-1.8-4-4 1.8-4 4-4zm14 0c2.2 0 4 1.8 4 4s-1.8 4-4 4-4-1.8-4-4 1.8-4 4-4zm2.1 11v2.1c-.6.1-1.2.4-1.7.7l-1.5-1.5-1.4 1.4 1.5 1.5c-.4.5-.6 1.1-.7 1.8H18v2h2.1c.1.6.4 1.2.7 1.8l-1.5 1.5 1.4 1.4 1.5-1.5c.5.3 1.1.6 1.7.7V32h2v-2.1c.6-.1 1.2-.4 1.7-.7l1.5 1.5 1.4-1.4-1.5-1.5c.4-.5.6-1.1.7-1.8H32v-2h-2.1c-.1-.6-.4-1.2-.7-1.8l1.5-1.5-1.4-1.4-1.5 1.5c-.5-.3-1.1-.6-1.7-.7V18h-2zm.9 4c1.7 0 3 1.3 3 3s-1.3 3-3 3-3-1.3-3-3 1.3-3 3-3zm0 2a.87.87 0 0 0-.37.09 1.14 1.14 0 0 0-.54.54.87.87 0 0 0-.09.37c0 .13.03.25.09.37a1.14 1.14 0 0 0 .54.54c.12.06.25.09.37.09.5 0 1-.5 1-1s-.5-1-1-1z',
        'users-solid' => 'M11.5 6A3.51 3.51 0 0 0 8 9.5c0 1.92 1.58 3.5 3.5 3.5S15 11.42 15 9.5 13.42 6 11.5 6Zm9 0A3.51 3.51 0 0 0 17 9.5c0 1.92 1.58 3.5 3.5 3.5S24 11.42 24 9.5 22.42 6 20.5 6Zm-9 2c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5-1.5-.66-1.5-1.5.66-1.5 1.5-1.5Zm9 0c.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5-1.5-.66-1.5-1.5.66-1.5 1.5-1.5ZM7 12a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 2 23h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 7 12Zm5 11a5 5 0 0 0-1 3h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2a5.02 5.02 0 0 0-2.22-4.16A3.98 3.98 0 0 0 16 15a3.98 3.98 0 0 0-2.78 6.84c-.47.32-.88.7-1.22 1.16Zm8 0h2c0-1.67 1.33-3 3-3s3 1.33 3 3h2c0-1.72-.89-3.25-2.22-4.16A3.98 3.98 0 0 0 25 12a3.98 3.98 0 0 0-2.78 6.84A5.04 5.04 0 0 0 20 23ZM7 14c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm18 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-9 3c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Z',
        'usps' => 'M5.6 7c13.6 2.9 17.7 3.5 17.8 4.5 2 0 2.5 0 2.8.4 1.1 1-.8 3.6-.8 3.6-.2.1-21.7 8.5-21.7 8.5h22.7L30 7H5.6zm-.8 4L2 24c10.5-5.2 13.9-6.9 17.2-8.1 3.5-1.1 5.2-1.2 5.5-1.3.2-.2-.2-.4-1.4-.3-2.8.1-7.4 2-9.3 2.9l-1.6-5h10.5c-.1-1-5.4-1.1-12.7-1.2H4.8zm18.4 1.1s-.1-.1-.6.4c-.6.3-2 .3-2 .5s3.8-.2 4.7 0c.5.1-.1 1.1-.2 1.7-.1.3.1.2.1 0 1.4-2.2.8-2.6-.6-2.6h-1.4z',
        'ussunnah' => 'm16 2-.2 4c-.6 0-1.3 0-1.8.1l-1.1-3.8.7 3.9c-.6.1-1.2.3-1.8.6L9.9 3.4l1.5 3.5c-.6.3-1.1.6-1.7.9L7.3 5.1l2.2 3c-.6.4-1.1.8-1.5 1.3L5 7.3l2.7 2.4c-.4.5-.8 1-1.2 1.6L3.4 9.9l3 1.6c-.3.6-.6 1.2-.8 1.9l-3.2-.6 3.1.9c-.2.7-.3 1.4-.4 2.1L2 16l3 .2v.8c0 .5 0 1 .1 1.4l-2.8.8 2.8-.5c.1.8.3 1.5.6 2.2l-2.3 1.3 2.4-1c.3.7.7 1.4 1.1 2L5 24.7l2-1.4c.5.7 1 1.2 1.6 1.8L7.3 27l1.5-1.7c.6.5 1.3 1 2 1.4l-.9 2 1-1.9c.7.4 1.5.7 2.3.9l-.4 2.1.6-2c.8.2 1.6.3 2.4.3L16 30l.1-2.1c.8 0 1.7-.1 2.4-.3l.6 2-.4-2.1c.8-.2 1.6-.5 2.3-.9l1.1 1.9-.9-2c.7-.4 1.4-.8 2-1.4l1.5 1.7-1.3-1.8c.6-.5 1.1-1.1 1.6-1.8l2 1.5-1.9-1.7c.4-.6.8-1.3 1.1-2l2.5 1-2.3-1.3c.3-.7.5-1.4.6-2.2l2.7.6-2.8-.8c0-.5.1-.9.1-1.4v-.8l3-.1-3.1-.2c-.1-.7-.2-1.4-.4-2.1l3.1-.9-3.3.6c-.2-.6-.5-1.3-.8-1.9l3-1.6-3.2 1.3c-.3-.6-.7-1.1-1.2-1.6L27 7.3l-3 2.1c-.4-.5-.9-.9-1.5-1.3l2.2-3-2.5 2.8c-.5-.4-1.1-.7-1.6-.9l1.5-3.6-1.9 3.4-1.8-.6.7-3.9L18 6.1c-.6-.1-1.2-.1-1.8-.1L16 2zm0 4.9c5.5 0 10 4.5 10 10 0 5.6-4.5 10-10 10s-10-4.5-10-10 4.5-10 10-10zM16 8c-4.9 0-8.9 4-8.9 8.9s4 8.9 8.9 8.9 8.9-4 8.9-8.9S20.9 8 16 8zm4.5 3.5v6.6c0 .5 0 .7.5.9-.2.3-.4.4-.7.4H14c-.1.1-.2.3-1 1.3-.1-.5-.6-1.3-.9-1.3H8.6c.2-.4.2-.4.1-.8-.2-.5-.1-1 .2-1.3.3-.3.7-.8.8-1-.1-.2-.2-.6-.3-.7.2-.3.5-.6.7-.8.1.2.2.5.3.7.1-.1.3-.3.3-.4-.1.3-.1.5-.1.7 0 .2.1.5.3 1.1l.7 1.6h.7c.2 0 .5.5 1.1 1.2.1-.1.1-.2.1-.3 0-.3-.6-1.5-.6-1.9 0-.5.3-.8.8-1.5 0 .2-.1.4-.1.5 0 .4.4 1.2.7 2h1v-.1c-.1-.1-.2-.3-.3-.4.2-.3.5-.7.6-.8.2.4.4 1 .5 1.3h.5c-.1-.2-.2-.5-.2-.6-.1-.2-.2-.3-.3-.4.2-.3.5-.7.6-.8.1.3.5 1.2.7 1.8h.5c-.1-.2-.3-.8-.5-1.2-.1-.2-.2-.3-.3-.4.2-.3.5-.7.6-.8.3.8.7 1.9.9 2.4h1.1c.1 0 .3-.3.3-.4v-3.8c0-.3-.2-.8-.6-1.7.2 0 .6-.4 1.1-1.1zm1.6 0v5.9c0 1.1.6 1.3 1 1.5.1.1.3.1.6.2-.1.1-.3.1-.8.1-.9.2-1.4 0-1.4-1v-3.9c0-.3-.2-.8-.6-1.7.3 0 .7-.4 1.2-1.1zM9.5 13.2c0 .1.1.3.2.4.1.1.2.3.2.4 0 .1-.1.3-.3.7-.1-.2-.3-.4-.5-.5-.1-.1-.2-.2-.2-.3 0 0 .2-.3.6-.7zm1.1 0c0 .1.1.3.2.4.1.1.2.3.2.4 0 .1-.1.3-.3.7-.1-.2-.3-.4-.5-.5-.1-.1-.2-.2-.2-.3.1 0 .2-.3.6-.7zm2.4 1.1c0 .1.1.3.2.4.1.1.2.3.2.4 0 .1-.1.3-.2.7-.1-.2-.3-.4-.5-.5-.1-.1-.2-.2-.2-.3-.1 0 .1-.3.5-.7zm-2.6 3.2s-.1.1-.2.3a.22.22 0 0 0-.07.17c0 .08.02.18.07.33 0 .05.02.12.06.21l.14.3h.5l-.3-.71c-.05-.15-.1-.25-.14-.34a.62.62 0 0 1-.06-.26z',
        'utensil-spoon-solid' => 'M23.1 4a9.57 9.57 0 0 0-6.22 2.72A5.87 5.87 0 0 0 15 11.09a5.8 5.8 0 0 0 1.22 3.25L4.28 26.28l1.44 1.44 11.94-11.94A5.86 5.86 0 0 0 20.9 17c1.5.06 3.05-.56 4.37-1.88a9.57 9.57 0 0 0 2.56-4.87c.34-1.78.13-3.66-1.15-4.94a4.4 4.4 0 0 0-2.28-1.18A6.1 6.1 0 0 0 23.09 4Zm0 2c.3 0 .6 0 .87.06.54.1.99.33 1.31.66.65.65.89 1.8.63 3.16a7.75 7.75 0 0 1-2.04 3.8c-1 1-1.94 1.36-2.87 1.32a4.1 4.1 0 0 1-2.69-1.31A4.1 4.1 0 0 1 17 11c-.04-.93.31-1.88 1.31-2.88s2.46-1.76 3.82-2.03c.33-.06.66-.09.96-.09Z',
        'utensils-solid' => 'M11 5C9.36 5 8.14 6.21 7.31 7.56A8.77 8.77 0 0 0 6 12a4.92 4.92 0 0 0 4 4.9V28h2V16.9c2.22-.44 4-2.32 4-4.9 0-1.48-.49-3.09-1.31-4.44C13.86 6.21 12.64 5 11 5Zm7 0v7c0 1.85 1.28 3.4 3 3.84V28h2V15.84c1.72-.44 3-1.99 3-3.84V5h-2v7c0 1.12-.88 2-2 2s-2-.88-2-2V5Zm3 0v7a1 1 0 0 0 2 0V5ZM11 7c.57 0 1.34.57 1.97 1.6A7.24 7.24 0 0 1 14 12c0 2-1.25 3-3 3s-3-1-3-3c0-1 .4-2.38 1.03-3.4C9.66 7.56 10.43 7 11 7Z',
        'vaadin' => 'M4 4c-.6 0-1 .4-1 1v2.5C3 9.4 4.6 11 6.5 11h7.1c.8 0 1.4.6 1.4 1.4v.6c0 .6.4 1 1 1s1-.4 1-1v-.6c0-.8.6-1.4 1.4-1.4h7.1c1.9 0 3.5-1.6 3.5-3.5V5c0-.6-.4-1-1-1s-1 .4-1 1v.6c0 .8-.6 1.4-1.4 1.4H19c-1.7 0-3 1.3-3 3 0-1.7-1.3-3-3-3H6.4C5.6 7 5 6.4 5 5.6V5c0-.6-.4-1-1-1zm6.35 11.03c-.19.01-.37.07-.55.17-.7.4-1 1.3-.6 2l5.5 10c.2.5.8.8 1.3.8s1.1-.3 1.3-.8l5.5-10c.4-.7.1-1.6-.6-2-.7-.4-1.6-.1-2 .6L16 23.4l-4.2-7.6c-.3-.52-.88-.82-1.45-.77z',
        'vector-square-solid' => 'M5 5v7h2v8H5v7h7v-2h8v2h7v-7h-2v-8h2V5h-7v2h-8V5H5zm2 2h3v3H7V7zm15 0h3v3h-3V7zM12 9h8v3h3v8h-3v3h-8v-3H9v-8h3V9zM7 22h3v3H7v-3zm15 0h3v3h-3v-3z',
        'venus-double-solid' => 'M11 3a8.01 8.01 0 0 0-1 15.94V23H6v2h4v4h2v-4h8v4h2v-4h4v-2h-4v-4.06A8.01 8.01 0 0 0 21 3c-1.52 0-2.95.45-4.16 1.19.52.44 1 .95 1.41 1.5a6 6 0 1 1-2.81 3.06 4.98 4.98 0 0 0-1.4-1.69A8.01 8.01 0 0 0 20 18.94L19.99 23h-8v-4.1a7.96 7.96 0 0 0 3.16-1.09c-.52-.44-1-.95-1.41-1.5a6 6 0 1 1 2.81-3.06 5.2 5.2 0 0 0 1.4 1.69A8.01 8.01 0 0 0 11 3Z',
        'venus-mars-solid' => 'M22 3v2h3.56L22.2 8.4a6.96 6.96 0 0 0-9.13.66 6.94 6.94 0 0 0 0 9.88 6.9 6.9 0 0 0 3.06 1.81c.12-.09.25-.18.35-.28.43-.43.71-.96.87-1.53a4.96 4.96 0 0 1-2.88-8.47 4.96 4.96 0 0 1 7.07 0 4.9 4.9 0 0 1 .81 5.94 8.64 8.64 0 0 1 .04 3.06c.2-.16.37-.35.56-.53a6.95 6.95 0 0 0 .65-9.13L27 6.44V10h2V3Zm-6.13 8.25c-.1.09-.24.18-.34.28-.43.43-.71.96-.87 1.53a4.96 4.96 0 0 1 2.88 8.47 4.96 4.96 0 0 1-7.07 0 4.9 4.9 0 0 1-.81-5.94 8.64 8.64 0 0 1-.04-3.06c-.2.16-.37.35-.56.53a6.95 6.95 0 0 0-.65 9.13l-1.7 1.68-2-2-1.43 1.41 2 2-2 2 1.44 1.44 2-2 2 2 1.4-1.44-2-2 1.7-1.69a6.92 6.92 0 0 0 9.12-.65 6.94 6.94 0 0 0 0-9.88 6.9 6.9 0 0 0-3.07-1.81Z',
        'venus-solid' => 'M16 3c-4.4 0-8 3.6-8 8a8.03 8.03 0 0 0 7 7.94V23h-4v2h4v4h2v-4h4v-2h-4v-4.06c3.93-.5 7-3.87 7-7.94 0-4.4-3.6-8-8-8Zm0 2a6 6 0 1 1 .02 11.98A6 6 0 0 1 16 5Z',
        'viacoin' => 'm6.28 6 2.56 6H5v2h4.69l.84 2H5v2h6.4l4.47 10.53L20.48 18H27v-2h-5.66l.88-2H27v-2h-3.9l2.62-6h-2.19l-4.37 10h-6.44L8.44 6Zm7.28 12h4.72l-2.37 5.47Z',
        'viadeo-square' => 'M7.4 5C6.1 5 5 6.1 5 7.4v17.3C5 25.9 6.1 27 7.4 27h17.3c1.3 0 2.4-1.1 2.4-2.4V7.4A2.6 2.6 0 0 0 24.6 5H7.4zm7.9 2.7c1.4.9 2.1 3.2 2.3 4.8.4 1.1.6 2.4.6 3.6 0 2.8-1.1 5-3.5 6.5a4.32 4.32 0 0 0 4.3-4.4c0-.6-.1-1.2-.4-1.8.5-.1.9-.3 1.3-.5a5.68 5.68 0 0 1-9.3 6.3c-3.5-3.8-1-10 4.1-10 .7 0 1.4.1 2 .3-.2.4-.4.9-.4 1.4-.5-.2-1-.3-1.6-.3-2.5 0-4.3 2.1-4.3 4.5 0 2.2 1.5 4 3.5 4.4 3.1-1.2 3.7-6 3.7-8.9v-1.1c-.6-1.7-1.4-3.3-2.3-4.8zm-.6 14.9h-.1.1zm7.4-14.4c1.7 2.2.8 6.5-1.8 6.5-.7 0-1.3-.4-1.8-.8 1.1-.6 2.5-1.6 3.2-2.7.1-.2.2-.4.2-.6-.6 1.4-2.3 2.5-3.8 2.9-.2-.4-.4-.8-.4-1.2 0-.5.3-1.2.7-1.6 1.1-1 2.7-.4 3.7-2.5z',
        'viadeo' => 'M15 3c1.4 2.4 2.7 5 3.6 7.7-.2-2.6-1.4-6.2-3.6-7.7zm10.7 1c-1.5 3.2-3.9 2.3-5.6 3.9-.6.5-1 1.6-1 2.4 0 .7.2 1.3.6 1.9 2.3-.5 4.7-2.2 5.7-4.4 0 .2-.2.7-.3.9-1 1.7-3.1 3.2-4.8 4.1.8.7 1.7 1.2 2.7 1.2 3.8 0 5.3-6.5 2.7-10zm-7.2 6.7v1.8c0 4.64-.95 12.07-5.88 14.37A6.95 6.95 0 0 1 7 20c0-3.9 3.1-7 7-7 .8 0 1.5.1 2.2.4.1-.6.3-1.2.6-1.8l.1-.1A8.96 8.96 0 0 0 5 20c0 5 4 9 9 9a8.96 8.96 0 0 0 8.2-12.7c-.1 0-.2.1-.4.2-.4.3-.9.5-1.4.6.4.9.6 1.9.6 2.9 0 3.9-3.1 7-7 7h-.08c3.78-2.41 5.58-6.12 5.58-10.5 0-2-.3-4-1-5.8z',
        'vial-solid' => 'M18.69 3.27 17.27 4.7 18.6 6 5.5 19.1c-2 2-2 5.4 0 7.4a5.3 5.3 0 0 0 7.4 0L26 13.4l1.24 1.26 1.42-1.42-9.97-9.97zm1.3 4.14 4.6 4.6L20.6 16h-9.2L20 7.4zM9.4 18h9.2l-7.1 7.1a3.2 3.2 0 0 1-4.6 0 3.2 3.2 0 0 1 0-4.6L9.4 18z',
        'vials-solid' => 'M5 5v2h1v12.5C6 21.4 7.6 23 9.5 23s3.5-1.6 3.5-3.5V7h1V5H5zm13 0v2h1v12.5c0 1.9 1.6 3.5 3.5 3.5s3.5-1.6 3.5-3.5V7h1V5h-9zM8 7h3v6H8V7zm13 0h3v6h-3V7zM8 15h3v4.5c0 .8-.7 1.5-1.5 1.5S8 20.3 8 19.5V15zm13 0h3v4.5c0 .8-.7 1.5-1.5 1.5s-1.5-.7-1.5-1.5V15zM2 25v2h28v-2H2z',
        'viber' => 'M15.7 4c-1.9 0-6.6.2-9.1 2.6C4.8 8.3 4.1 10.9 4 14c-.2 4.9.9 8 2.7 9.6.4.3 1.4 1.1 3.3 1.7v2.5s0 1 .6 1.2c.1 0 .2.1.3.1.6 0 1.1-.7 1.8-1.4.6-.7 1.1-1.2 1.4-1.7h2.2c1.9 0 6.6-.2 9.1-2.6 1.8-1.8 2.5-4.4 2.5-7.7.1-.5.1-1.1.1-1.7-.1-3.7-1.2-6.2-2.7-7.6-.6-.5-3.2-2.4-8.8-2.4h-.8zm-.2 1.9h.9c5.3 0 7.3 1.7 7.5 1.9 1.2 1 1.9 3.2 2 6.1v.4c.1.6.1 1.1.1 1.4-.1 3-.7 5-1.9 6.3-2.1 1.9-6.5 2-7.7 2h-1.9l-1.6 1.8-1 1.1-.2.3c-.2.2-.5.6-.7.7v-4.5c-2-.5-2.8-1.2-3-1.4-1.4-1.2-2.2-4.1-2-8v-1c.2-2.4.8-4 1.8-5.1 2.1-1.9 6.5-2 7.7-2zm-.1 2.2c-.5 0-.5.7 0 .7 3.7 0 6.9 2.5 6.9 7.2 0 .5.7.5.7 0 0-5.1-3.4-8-7.6-7.9zm-3.96.93a.87.87 0 0 0-.64.17c-1 .5-2 1.5-1.7 2.6 0 0 .2.9 1.3 2.8.6.9 1.1 1.7 1.6 2.3.5.7 1.3 1.5 2.1 2.1 1.6 1.3 4.1 2.6 5.2 2.9 1 .3 2.1-.7 2.6-1.7.2-.4.1-.9-.3-1.2-.6-.6-1.6-1.3-2.3-1.7-.5-.3-1.1-.1-1.3.2l-.5.6c-.2.3-.7.3-.7.3-3.3-.9-4.2-4.3-4.2-4.3s0-.4.3-.7l.6-.5c.3-.2.5-.8.2-1.3-.2-.3-.5-.9-.8-1.2-.3-.4-.9-1.1-.9-1.1a.96.96 0 0 0-.56-.27zm4.66 1.07c-.5-.1-.6.7-.1.7 2.8.2 4.4 2.1 4.3 4.5-.1.5.7.5.7 0a4.8 4.8 0 0 0-4.9-5.2zm.3 1.9c-.5-.1-.5.7 0 .7 1.2 0 1.8.7 1.8 1.9.1.5.8.5.8 0-.1-1.6-1-2.6-2.6-2.6z',
        'video-slash-solid' => 'M3.72 2.28 2.28 3.72l26 26 1.44-1.44L24 22.56v-1.93l6 3V8.38l-6 3V8H9.44ZM2 8v16h18l-2-2H4V10h2L4 8Zm9.44 2H22v10.56ZM28 11.63v8.74l-4-2v-4.75Z',
        'video-solid' => 'M2 8v16h22v-3.38l6 3V8.38l-6 3V8Zm2 2h18v12H4Zm24 1.63v8.74l-4-2v-4.75Z',
        'vihara-solid' => 'M16 3.7 8.1 10H10v2.52L5.1 16.2l1.9.92v3.4L2 24.3l4 1.58V28h2v-2h7v2h2v-2h7v2h2v-2.12l4.1-1.58-5.1-3.85v-3.3l2-.95-5-3.75V10h1.9L16 3.7zm0 2.6L18.2 8h-4.3L16 6.3zM12 10h8v2h-8v-2zm-.6 4h9.3l2.3 1.8-.3.2H9.2l-.2-.2 2.4-1.8zM9 18h14v2H9v-2zm-.7 4h15.4l2.3 1.7-.7.3H6.7l-.7-.3L8.3 22z',
        'vimeo-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm13.88 3c-1.9 0-3.2.83-3.88 3.04.84-.36 2.1-.45 1.95.96a6.57 6.57 0 0 1-1.04 2.27c-1.6 2.53-2 1.68-2.88-3.9-.25-1.57-.9-2.3-1.98-2.2-.95.1-2.46 1.6-4.05 3l.65.83c.61-.44.97-.6 1.08-.6.9 0 1.35 2.32 2.44 6.3.55 1.47 1.23 2.21 2.03 2.21 1.3 0 2.88-1.21 4.76-3.65 1.8-2.33 2.85-4.16 2.91-5.5.05-1.71-.68-2.76-2-2.76z',
        'vimeo-v' => 'M27.99 10.41c-.1 2.34-1.74 5.55-4.9 9.62-3.26 4.24-6.02 6.37-8.28 6.37-1.4 0-2.58-1.3-3.55-3.88L9.32 15.4c-.71-2.59-1.48-3.88-2.3-3.88-.19 0-.82.38-1.9 1.13L4 11.2l3.5-3.13c1.58-1.37 2.77-2.09 3.56-2.16 1.87-.18 3.02 1.1 3.45 3.83a89 89 0 0 0 .97 5.51c.54 2.46 1.13 3.68 1.78 3.68.5 0 1.25-.8 2.26-2.38 1-1.6 1.54-2.8 1.62-3.64.14-1.37-.4-2.05-1.62-2.05-.57 0-1.17.12-1.78.39 1.18-3.87 3.44-5.75 6.76-5.64 2.47.07 3.63 1.67 3.49 4.8Z',
        'vimeo' => 'M27.99 10.41c-.1 2.34-1.74 5.55-4.9 9.62-3.26 4.24-6.02 6.37-8.28 6.37-1.4 0-2.58-1.3-3.55-3.88L9.32 15.4c-.71-2.59-1.48-3.88-2.3-3.88-.19 0-.82.38-1.9 1.13L4 11.2l3.5-3.13c1.58-1.37 2.77-2.09 3.56-2.16 1.87-.18 3.02 1.1 3.45 3.83a89 89 0 0 0 .97 5.51c.54 2.46 1.13 3.68 1.78 3.68.5 0 1.25-.8 2.26-2.38 1-1.6 1.54-2.8 1.62-3.64.14-1.37-.4-2.05-1.62-2.05-.57 0-1.17.12-1.78.39 1.18-3.87 3.44-5.75 6.76-5.64 2.47.07 3.63 1.67 3.49 4.8Z',
        'vine' => 'M25.64 15.94c-.57.13-1.11.19-1.6.19-2.78 0-4.92-1.94-4.92-5.31 0-1.66.64-2.52 1.54-2.52.86 0 1.44.77 1.44 2.34 0 .89-.24 1.86-.42 2.44 0 0 .86 1.5 3.2 1.03.5-1.1.76-2.52.76-3.78 0-3.37-1.71-5.33-4.87-5.33-3.23 0-5.13 2.49-5.13 5.77 0 3.25 1.52 6.05 4.03 7.32a20.93 20.93 0 0 1-3.8 5.36c-2.53-3.07-4.83-7.16-5.77-15.15H6.36c1.73 13.3 6.88 17.54 8.25 18.36.77.46 1.43.44 2.14.04 1.1-.63 4.43-3.95 6.27-7.84.77 0 1.7-.1 2.62-.3Z',
        'vk' => 'M9.08 5A4.1 4.1 0 0 0 5 9.08v13.84A4.1 4.1 0 0 0 9.08 27h13.84A4.1 4.1 0 0 0 27 22.92V9.08A4.1 4.1 0 0 0 22.92 5Zm0 2h13.84C24.08 7 25 7.92 25 9.08v13.84c0 1.16-.92 2.08-2.08 2.08H9.08A2.07 2.07 0 0 1 7 22.92V9.08C7 7.92 7.92 7 9.08 7Zm6.64 5.23c-.74 0-1.36 0-1.71.17-.24.12-.42.37-.3.39.13.01.44.08.6.3.21.29.2.93.2.93s.12 1.78-.28 2c-.28.15-.66-.16-1.48-1.57-.41-.72-.73-1.52-.73-1.52s-.06-.15-.17-.23a.8.8 0 0 0-.31-.13l-1.96.01s-.3.01-.4.14c-.1.12 0 .35 0 .35s1.52 3.58 3.26 5.38c1.59 1.66 3.4 1.55 3.4 1.55h.81s.25-.03.37-.16.12-.36.12-.36-.02-1.1.49-1.26c.5-.16 1.14 1.06 1.83 1.53.52.36.91.28.91.28L22.2 20s.95-.06.5-.81c-.04-.06-.26-.56-1.36-1.57-1.14-1.07-1-.9.39-2.73.84-1.12 1.18-1.8 1.07-2.1-.1-.28-.72-.2-.72-.2h-2.06s-.15-.02-.26.05a.58.58 0 0 0-.18.22s-.33.87-.76 1.6c-.92 1.56-1.29 1.65-1.44 1.55-.34-.22-.26-.9-.26-1.39 0-1.5.23-2.13-.44-2.3a3.41 3.41 0 0 0-.96-.09Z',
        'vnv' => 'M.6 12c-1 0-.5.9-.5.9l2.7 5.6S3.4 20 5.1 20h1.8c1.7 0 2.3-1.5 2.3-1.5l2.7-5.6s.5-.9-.5-.9H9.8c-.6 0-.7.4-1 .9L7 16.6s-.2.7-1 .7-1-.7-1-.7l-1.9-3.7c-.3-.5-.4-.9-.9-.9H.6zm14.6 0c-1.7 0-2.3 1.5-2.3 1.5l-2.7 5.6s-.5.9.5.9h1.6c.5 0 .6-.4.9-.9l1.8-3.7s.2-.7 1-.7c.7 0 1 .7 1 .7l1.9 3.7c.2.5.4.9.9.9h1.6c1 0 .5-.9.5-.9l-2.7-5.6s-.6-1.5-2.3-1.5h-1.7zm5.5 0c-1 0-.5.9-.5.9l2.7 5.6s.6 1.5 2.3 1.5h1.7c1.7 0 2.3-1.5 2.3-1.5l2.7-5.6s.5-.9-.6-.9h-1.6c-.5 0-.6.4-.9.9L27 16.6s-.2.7-1 .7c-.7 0-1-.7-1-.7l-1.8-3.7c-.3-.5-.4-.9-.9-.9h-1.6z',
        'voicemail-solid' => 'M8 9a7 7 0 0 0 0 14h16a7 7 0 1 0-7-7c0 1.96.82 3.73 2.13 5h-6.25A6.98 6.98 0 0 0 8 9Zm0 2a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Zm16 0a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Z',
        'volleyball-ball-solid' => 'M16 3C8.86 3 3 8.86 3 16s5.86 13 13 13 13-5.86 13-13S23.14 3 16 3Zm0 2c2.36 0 4.55.76 6.34 2.03a19.25 19.25 0 0 0-9.21 0c-.28.07-.45.13-.66.19a9.38 9.38 0 0 1-.16-1.56A10.9 10.9 0 0 1 16 5Zm-5.63 1.6c.06.53.17 1.18.35 1.9 0 .2.05.4.15.56a16.6 16.6 0 0 0 1.7 3.94c.6 1.04 1.36 2.1 2.34 3.16-.26.86-.57 1.66-.91 2.37A14.88 14.88 0 0 1 9.25 7.72a.93.93 0 0 0-.06-.34c.36-.3.78-.54 1.19-.79Zm7.07 1.87c2.18-.05 4.82.3 7.47 1.56.12.08.26.13.4.16.32.5.61 1.03.85 1.6-3.12-1.4-6-1.67-8.29-1.5-1.82.12-3.18.52-4.06.84-.34-.7-.6-1.36-.81-1.97l.63-.2c.74-.18 1.73-.38 2.9-.46l.9-.03Zm-10.1.78A16.83 16.83 0 0 0 13 20.31c-.45.69-.94 1.27-1.4 1.78-.62-.61-1.5-1.59-2.35-2.9-1.36-2.1-2.59-5-2.47-8.47a1 1 0 0 0-.1-.53c.21-.32.43-.64.66-.94Zm11.6 3a15.27 15.27 0 0 1 7.9 2.1c.08.49.15.99.16 1.5a15.81 15.81 0 0 0-6.16-1.35 1 1 0 0 0-.78 0H20a17.9 17.9 0 0 0-3.47.47c-.66-.7-1.21-1.4-1.69-2.1a14.04 14.04 0 0 1 4.1-.62ZM5.12 14.41a18.75 18.75 0 0 0 5.06 9.1c-.48.4-.9.7-1.21.93A10.95 10.95 0 0 1 5.12 14.4Zm16.22 2.12c.79.04 1.51.12 2.16.25a15.1 15.1 0 0 1-.9 3.5 12.7 12.7 0 0 1-5.35 6.4.95.95 0 0 0-.25.26 10.57 10.57 0 0 1-2.4-.03 16.74 16.74 0 0 0 6.74-10.38Zm-2.15.03h.12l-.06.25a14.8 14.8 0 0 1-7 9.22c-.1.05-.2.11-.28.19-.45-.18-.86-.4-1.28-.63.32-.25.72-.57 1.12-.93a1 1 0 0 0 1.03-1 16.76 16.76 0 0 0 3.85-6.7c.88-.21 1.7-.33 2.5-.4Zm6.25.78a11 11 0 0 1 1.37.6 11.01 11.01 0 0 1-4.78 7.25 15.57 15.57 0 0 0 3.34-7.38c.04-.19.04-.3.07-.47Z',
        'volume-down-solid' => 'm15 4.6-1.72 1.68L8.56 11H4v10h4.56l4.72 4.72L15 27.4Zm-2 4.84v13.12l-3.28-3.28L9.4 19H6v-6h3.4l.32-.28Zm5.5 2.6-1.44 1.43a3.92 3.92 0 0 1 0 5.06l1.44 1.44a5.96 5.96 0 0 0 0-7.94Z',
        'volume-mute-solid' => 'm15 4.6-1.72 1.68L8.56 11H4v10h4.56l4.72 4.72L15 27.4Zm-2 4.84v13.12l-3.28-3.28L9.4 19H6v-6h3.4l.32-.28Zm7.22 2.34-1.44 1.44L21.56 16l-2.78 2.78 1.44 1.44L23 17.44l2.78 2.78 1.44-1.44L24.44 16l2.78-2.78-1.44-1.44L23 14.56Z',
        'volume-off-solid' => 'm15 4.6-1.72 1.68L8.56 11H4v10h4.56l4.72 4.72L15 27.4Zm-2 4.84v13.12l-3.28-3.28L9.4 19H6v-6h3.4l.32-.28Zm7.22 2.34-1.44 1.44L21.56 16l-2.78 2.78 1.44 1.44L23 17.44l2.78 2.78 1.44-1.44L24.44 16l2.78-2.78-1.44-1.44L23 14.56Z',
        'volume-up-solid' => 'm17 3.6-1.72 1.68L9.56 11H5v10h4.56l5.72 5.72L17 28.4Zm6.81 4.59-1.4 1.4a8.94 8.94 0 0 1 0 12.7l1.4 1.43a11 11 0 0 0 0-15.53ZM15 8.44v15.12l-4.28-4.28-.31-.28H7v-6h3.4l.32-.28Zm5.9 2.65-1.4 1.41a5.08 5.08 0 0 1-.03 7.1l1.47 1.4a7.12 7.12 0 0 0-.03-9.9Z',
        'vote-yea-solid' => 'M8 5v16h16V5H8zm2 2h12v12H10V7zm9.3 2.9L15 14.2l-2.3-2.3-1.4 1.5 3 3 .7.7.7-.7 5-5-1.4-1.5zM2 19v8h2v-6h2v-2H2zm24 0v2h2v6h2v-8h-4zM6 23v2h20v-2H6z',
        'vr-cardboard-solid' => 'M8 5a3.84 3.84 0 0 0-3.88 3.16A3 3 0 0 0 2 11v13c0 1.64 1.36 3 3 3h7c1.32 0 2.52-.8 3.06-2h1.88c.54 1.2 1.74 2 3.06 2h7c1.64 0 3-1.36 3-3V11a3 3 0 0 0-2.13-2.84A3.86 3.86 0 0 0 24 5Zm0 2h16c1.15 0 1.46.42 1.72.94l.03.06H6.25l.03-.06C6.54 7.43 6.84 7 8 7Zm-3 3h22c.57 0 1 .43 1 1v13c0 .57-.43 1-1 1h-7c-.54 0-1.04-.33-1.25-.84l-1.03-2.75v-.04l-.03-.03c-.3-.7-.96-1.15-1.72-1.15s-1.45.46-1.75 1.15l-.03.04v.06l-.94 2.72c-.22.5-.7.84-1.25.84H5c-.57 0-1-.43-1-1V11c0-.57.43-1 1-1Zm5 3c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4Zm12 0c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4Zm-12 2c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm12 0c1.12 0 2 .88 2 2s-.88 2-2 2-2-.88-2-2 .88-2 2-2Zm-6.03 7.44.22.56h-.4Z',
        'vuejs' => 'm3 6 13 22L29 6H19l-3 5.3L13 6H3zm3.5 2h3.77L16 18l5.73-10h3.77L16 24.1 6.5 8z',
        'walking-solid' => 'M16.5 4A3.51 3.51 0 0 0 13 7.5c0 1.92 1.58 3.5 3.5 3.5S20 9.42 20 7.5 18.42 4 16.5 4Zm0 2c.84 0 1.5.66 1.5 1.5S17.34 9 16.5 9 15 8.34 15 7.5 15.66 6 16.5 6Zm-3.69 5.25a2 2 0 0 0-1.34.69l-1.81 2.1c-.24.26-.41.6-.47.96l-.69 3.88 1.97.34.69-3.88 1.8-2.09H13l.78.16-1.19 5.37a2 2 0 0 0 .35 1.6L18.47 28h2.47l-6.38-8.81 1.19-5.4.47.09.75 2.62a2 2 0 0 0 1.22 1.31l3.53 1.35.69-1.88-3.5-1.34-.79-2.63a1.96 1.96 0 0 0-1.53-1.4l-3.25-.63a2.03 2.03 0 0 0-.53-.03Zm-.34 10.78-.5 1.94L9.07 28h2.46l2.31-3.16.13-.59Z',
        'wallet-solid' => 'M22.97 4c-.15 0-.31.02-.47.06L6.25 8.34A3.02 3.02 0 0 0 4 11.25V25c0 1.64 1.36 3 3 3h18c1.64 0 3-1.36 3-3V12c0-1.64-1.36-3-3-3H11.62L23 6v2h2V6c0-1.13-.96-2.02-2.03-2ZM7 11h18c.57 0 1 .43 1 1v13c0 .57-.43 1-1 1H7c-.57 0-1-.43-1-1V12c0-.57.43-1 1-1Zm15.5 6a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'warehouse-solid' => 'M16 4.9 3.62 10.07l-.62.28V27h26V10.34l-.63-.28Zm0 2.2 11 4.59V25h-2V14H7v11H5V11.69ZM9 16h14v9H9Z',
        'water-solid' => 'M0 7c0 1.63 1.83 3 4 3a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 10 10a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 16 10a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 22 10a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 28 10c2.17 0 4-1.38 4-3h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.75 1-2 1-1.22 0-2-.7-2-1H6c0 .3-.75 1-2 1-1.22 0-2-.7-2-1Zm0 8c0 1.63 1.83 3 4 3a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 10 18a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 16 18a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 22 18a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 28 18c2.17 0 4-1.38 4-3h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.75 1-2 1-1.22 0-2-.7-2-1H6c0 .3-.75 1-2 1-1.22 0-2-.7-2-1Zm0 8c0 1.63 1.83 3 4 3a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 10 26a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 16 26a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 22 26a4.6 4.6 0 0 0 3-1.06A4.6 4.6 0 0 0 28 26c2.17 0 4-1.38 4-3h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.76 1-2 1-1.22 0-2-.7-2-1h-2c0 .3-.75 1-2 1-1.22 0-2-.7-2-1H6c0 .3-.75 1-2 1-1.22 0-2-.7-2-1Z',
        'wave-square-solid' => 'M8 6v9H2v2h8V8h5v18h9v-9h6v-2h-8v9h-5V6H8z',
        'waze' => 'M17.7 4c-5 0-10.1 3.3-11.1 8.3-.6 3 .2 5.8-2.3 5.8-1.1 0-1.8 1.3-1.1 2.2 1.4 1.9 3.3 3 5.2 3.7l.62.25A2.5 2.5 0 0 0 11.5 27a2.5 2.5 0 0 0 2.45-2h4.1a2.5 2.5 0 0 0 2.45 2 2.5 2.5 0 0 0 2.37-3.3c4.2-2.12 6.52-6.36 5.73-10.9C28 7.7 23 4 17.7 4zm0 2c4.5 0 8.5 3.1 9.2 7.3.6 3.6-1.3 7.1-4.8 8.8l-.45.18A2.5 2.5 0 0 0 20.5 22a2.5 2.5 0 0 0-2 1h-4.6l-.42-.02A2.5 2.5 0 0 0 11.5 22a2.5 2.5 0 0 0-1.37.41l-.03-.01-.9-.3c-1.4-.5-2.6-1.2-3.6-2.2 2.4-.7 2.6-3.5 2.7-5.1.1-.7.1-1.4.2-2.1.9-4.2 5.3-6.7 9.2-6.7zm-3.2 5a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm6 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm-6.9 3.98a.49.49 0 0 0-.2.02c-.3.1-.5.3-.4.6.5 2.3 2.7 3.4 4.5 3.4 1.8 0 4-1.1 4.5-3.4 0-.3-.1-.5-.4-.6-.3 0-.5.1-.6.4-.4 1.8-2.1 2.6-3.5 2.6s-3.1-.8-3.5-2.6c-.07-.22-.2-.4-.4-.42z',
        'weebly' => 'M6.5 6c-.6 0-1.1.1-1.7.3-2.3.9-3.4 3.6-2.5 5.9l4.5 11c.7 1.7 2.3 2.8 4.1 2.8h.1c1.8 0 3.4-1 4.1-2.6L16 21l.9 2.4C17.6 25 19.2 26 21 26h.1c1.8 0 3.4-1.1 4.1-2.8l4.5-11c.9-2.3-.2-4.9-2.5-5.9a4.57 4.57 0 0 0-5.9 2.5l-.6 1.7-.7-1.9C19.3 7 17.7 6 16 6c-.6 0-1.3.1-1.9.4-1 .5-1.7 1.2-2.2 2.2l-.1.1-.7 1.9-.6-1.7C10 7.1 8.3 6 6.5 6zm0 2c1 0 1.9.6 2.3 1.5l.5 1.6 1.8 5.5 2-5.4.6-1.6v-.2A2.57 2.57 0 0 1 16 8c1 0 1.8.6 2.3 1.4l.7 1.8 2 5.4 1.8-5.5.5-1.6a2.29 2.29 0 0 1 3.1-1.3c.6.3 1.1.7 1.4 1.3.3.6.3 1.3 0 1.9l-4.5 11c-.4 1-1.3 1.6-2.2 1.6H21c-1 0-1.8-.6-2.3-1.4l-.9-2.3-1.8-4.9-1.9 4.9-.9 2.3c-.4.8-1.2 1.4-2.2 1.4-1 0-1.9-.6-2.3-1.6l-4.5-11c-.3-.6-.2-1.3 0-1.9.3-.6.7-1.1 1.4-1.3.3-.1.6-.2.9-.2z',
        'weibo' => 'M21.94 6.28a6.31 6.31 0 0 0-1.63.13c-.5.1-.82.6-.72 1.09.1.5.6.82 1.1.72A4.54 4.54 0 0 1 25 9.59a4.55 4.55 0 0 1 .94 4.44.92.92 0 1 0 1.75.56 6.35 6.35 0 0 0-5.75-8.3Zm-8.28 2.75c-1.68.18-4.02 1.49-6.1 3.56C5.3 14.86 4 17.27 4 19.34c0 3.97 5.08 6.38 10.06 6.38 6.53 0 10.88-3.8 10.88-6.81 0-1.82-1.53-2.86-2.9-3.29-.35-.1-.6-.14-.41-.59.38-.96.44-1.81.03-2.4-.78-1.12-2.94-1.06-5.38-.04 0 0-.76.36-.56-.25.37-1.2.3-2.22-.28-2.8-.42-.42-1.02-.6-1.78-.5Zm8.12.5a3.1 3.1 0 0 0-.78.06.83.83 0 0 0-.63.97c.1.43.52.69.94.6.51-.11 1.1.05 1.47.46.38.42.47.98.31 1.47a.8.8 0 0 0 .5 1 .8.8 0 0 0 1-.5 3.1 3.1 0 0 0-.65-3.03 3.1 3.1 0 0 0-2.16-1.03Zm-7.19 5.28c3.32.12 6 1.78 6.22 4.06.26 2.61-2.74 5.05-6.72 5.44-3.97.4-7.43-1.42-7.68-4.03-.26-2.6 2.77-5.05 6.75-5.44.5-.05.96-.04 1.43-.03Zm-1.56 1.94a4.25 4.25 0 0 0-3.4 2.22c-.84 1.7-.04 3.6 1.87 4.22A4.3 4.3 0 0 0 16.63 21c.8-1.8-.2-3.62-2.16-4.13a4.16 4.16 0 0 0-1.44-.12Zm.9 2.19c.07 0 .1 0 .16.03a.4.4 0 0 1 .22.6.57.57 0 0 1-.69.24c-.23-.1-.32-.36-.18-.6a.6.6 0 0 1 .5-.27Zm-1.84.56c.17 0 .35.03.5.1.62.26.82.97.44 1.59-.38.61-1.19.9-1.81.62-.61-.27-.79-1-.4-1.6a1.5 1.5 0 0 1 1.27-.71Z',
        'weight-hanging-solid' => 'M16 5c-1.64 0-3 1.36-3 3 0 .35.07.68.19 1h-5l-.16.81-3 15-.03.1V27h22v-2.1l-.03-.09-3-15L23.8 9h-5c.12-.32.19-.65.19-1 0-1.64-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-6.19 4H22.2L25 25H7Z',
        'weight-solid' => 'M4 6v20h24V6Zm2 2h20v16H6Zm10 2c-4.33 0-7.56 2.16-7.56 2.16l-.78.53.5.81 3 5 .28.5h9.12l.28-.5 3-5 .5-.81-.78-.53S20.33 10 16 10Zm0 2c2.82 0 4.69.9 5.6 1.4L19.46 17h-1.84l1.28-2.56-1.82-.88-1.7 3.44h-2.85l-2.12-3.6c.9-.5 2.77-1.4 5.59-1.4Z',
        'weixin' => 'M14 5C8.58 5 4 8.71 4 13.5c0 1.62.6 3.1 1.5 4.38l-.38 2.9-.21 1.75 1.59-.69L9 20.81a11.4 11.4 0 0 0 4.16 1.13c.73 2.95 3.82 5.06 7.34 5.06a8.3 8.3 0 0 0 3.94-1.03l1.18.69 1.72.93-.25-1.93-.21-1.82A5.68 5.68 0 0 0 28 20.6c0-2.55-1.7-4.7-4.13-5.75.1-.43.13-.87.13-1.34C24 8.71 19.42 5 14 5Zm0 2c4.52 0 8 3 8 6.5 0 .27-.02.53-.06.78a8.3 8.3 0 0 0-1.44-.12c-3.8 0-7.09 2.46-7.47 5.78a9.09 9.09 0 0 1-3.56-1.1l-.44-.21-.44.18-1.28.53.22-1.53.03-.43-.25-.32A5.63 5.63 0 0 1 6 13.5C6 10 9.48 7 14 7Zm-3.44 2.16c-.77 0-1.4.63-1.4 1.4 0 .78.63 1.44 1.4 1.44.78 0 1.4-.66 1.4-1.44 0-.77-.62-1.4-1.4-1.4Zm6.69 0c-.78 0-1.44.63-1.44 1.4 0 .78.66 1.44 1.44 1.44.78 0 1.4-.66 1.4-1.44 0-.77-.62-1.4-1.4-1.4Zm3.25 7c3.14 0 5.5 2.09 5.5 4.43 0 .89-.32 1.7-.9 2.41l-.29.34.07.41.03.19-.47-.25-.5.34a6.4 6.4 0 0 1-3.44.97c-3.14 0-5.5-2.06-5.5-4.4 0-2.35 2.36-4.44 5.5-4.44ZM18 17.44c-.59 0-1.1.47-1.1 1.06 0 .59.51 1.06 1.1 1.06a1.06 1.06 0 1 0 0-2.12Zm5.03 0a1.06 1.06 0 1 0 0 2.12 1.06 1.06 0 0 0 0-2.12Z',
        'whatsapp-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 2c-3.9 0-7 3.1-7 7 0 1.3.4 2.5 1 3.5L9 23l3.5-.9c1 .6 2.2.9 3.5.9 3.9 0 7-3.1 7-7s-3.1-7-7-7zm0 1.5c3 0 5.5 2.5 5.5 5.5S19 21.5 16 21.5a6 6 0 0 1-2.7-.7l-.5-.3-.6.2-1 .3.3-1 .2-.6-.3-.5c-.5-.8-.8-1.8-.8-2.8-.1-3.1 2.4-5.6 5.4-5.6zm-2.2 2.6c-.1 0-.3 0-.4.2-.2.1-.6.5-.6 1.3 0 .7.5 1.5.6 1.6.1.1 1.1 1.7 2.7 2.4 1 .4 1.4.5 1.9.4.3-.1 1-.4 1.1-.8.1-.4.1-.7.2-.5 0-.1-.1-.1-.3-.2-.2-.1-1-.5-1.1-.5-.2 0-.3-.1-.4.1-.1.1-.4.5-.5.6-.1.1-.1.1-.3 0-1-.5-1.6-.9-2.2-1.9-.1-.3.2-.3.5-.9.1-.1 0-.2 0-.3-.1-.1-.4-.9-.5-1.2-.2-.3-.3-.3-.4-.3h-.3z',
        'whatsapp' => 'M24.5 7.5A11.96 11.96 0 0 0 5.7 21.91L4 28.12l6.34-1.66a11.9 11.9 0 0 0 5.7 1.45h.01A11.97 11.97 0 0 0 24.5 7.5Zm-8.45 18.38a9.93 9.93 0 0 1-5.06-1.38l-.36-.21-3.76.98 1-3.66-.23-.38a9.94 9.94 0 1 1 18.34-5.28 9.94 9.94 0 0 1-9.93 9.93Zm5.45-7.43c-.3-.15-1.77-.88-2.04-.97-.28-.1-.48-.15-.67.14-.2.3-.77.98-.95 1.18-.17.2-.35.22-.64.07-.3-.15-1.27-.46-2.4-1.48a8.94 8.94 0 0 1-1.67-2.07c-.17-.3-.02-.46.13-.6.14-.14.3-.36.45-.53.15-.17.2-.3.3-.5.1-.2.05-.37-.03-.52l-.92-2.22c-.24-.58-.49-.5-.67-.51l-.57-.01c-.2 0-.52.07-.8.37-.27.3-1.04 1.02-1.04 2.5 0 1.46 1.07 2.88 1.22 3.08.15.2 2.1 3.21 5.1 4.5.71.32 1.27.5 1.7.64.71.22 1.37.2 1.88.12.58-.09 1.77-.73 2.02-1.43.24-.69.24-1.29.17-1.41-.07-.13-.27-.2-.57-.35Z',
        'wheelchair-solid' => 'M20 3c-1.64 0-3 1.36-3 3s1.36 3 3 3 3-1.36 3-3-1.36-3-3-3Zm0 2c.56 0 1 .44 1 1s-.44 1-1 1-1-.44-1-1 .44-1 1-1Zm-5.47 2.78-3.6.4a2 2 0 0 0-1.43.91L7 12.97l1.69 1.06 2.5-3.84 2.28-.25L12 14.09A7 7 0 1 0 19.9 20h1.29l1.34 6.1 1.94-.44-1.31-6.1A2.02 2.02 0 0 0 21.19 18H19.3a7 7 0 0 0-1.65-2.19l1.15-3.22a3 3 0 0 0-1.4-3.65L15.7 8v.03c-.35-.19-.78-.3-1.18-.25Zm1 2.4.94.5a1 1 0 0 1 .47 1.23l-1 2.75a6.87 6.87 0 0 0-1.85-.57ZM13 16a4.99 4.99 0 1 1 0 10 4.99 4.99 0 1 1 0-10Z',
        'whmcs' => 'm14.8 4-.6 2.8-1.2.3L11 5 9.1 6.1 9.9 9l-.8.8L6.2 9l-1.1 1.9L7.2 13l-.3 1-2.9.8V17l2.9.8.3 1.2-2 2 1 1.9 3-.8.7.9-.9 2.7 2 1.2 2-2.1 1.1.3.7 2.9h2.3l.7-2.9 1.2-.3 2.1 2.1 2-1.2-.9-2.8.8-.8 2.9.8 1-2-2.1-1.9.2-1.2 3-.7V15l-2.6-.9.4 1.1.1.4-.3.2-1.1.6-.3.2-.3-.3-.9-1h-.1l-.3 1.3-.1.4h-1.1a5.6 5.6 0 0 1-5.5 4.4 5.7 5.7 0 0 1-5.7-5.7c0-2.7 2-4.9 4.5-5.5v-1l.3-.1 1.3-.4-.9-.9-.2-.2.2-.3.6-1 .2-.3.3.2 1.2.3-.6-2.5h-2.3zM21 4l-.3 1.4-.7.2-1-1.1-1 .6.4 1.5-.5.4-1.5-.4-.6 1 1.1 1.1-.1.5-1.5.4v1.2l1.6.4.1.7-1.2 1.1.6 1 1.6-.4.4.5-.4 1.4 1.1.6 1-1.1.6.2.4 1.5h1.2l.4-1.5.6-.2 1.1 1.2 1.1-.7-.6-1.5.4-.4 1.5.5.5-1.1-1.1-1 .1-.7 1.7-.4V9.8l-1.5-.5-.1-.6 1.1-1.1-.5-1-1.7.4-.4-.4.4-1.5-1-.6-1.1 1.1-.6-.2-.4-1.4H21zm.6 3.3a3 3 0 0 1 3 3c.1 1.7-1.3 3-3 3a3 3 0 0 1-3-3 3 3 0 0 1 3-3z',
        'wifi-solid' => 'M16 7c-5.02 0-9.54 2.08-12.81 5.4l1.4 1.41a15.94 15.94 0 0 1 22.82 0l1.4-1.4A17.93 17.93 0 0 0 16 7Zm0 5c-3.64 0-6.92 1.52-9.28 3.94l1.4 1.4a10.97 10.97 0 0 1 15.76 0l1.4-1.4A12.94 12.94 0 0 0 16 12Zm0 5c-2.26 0-4.3.96-5.75 2.47l1.4 1.4a5.99 5.99 0 0 1 8.7 0l1.4-1.4A7.96 7.96 0 0 0 16 17Zm0 5c-.88 0-1.67.4-2.22 1L16 25.22 18.22 23c-.55-.6-1.34-1-2.22-1Z',
        'wikipedia-w' => 'M30 9.21a.3.3 0 0 1-.31.31H28l-7.62 16.22a.3.3 0 0 1-.28.18.31.31 0 0 1-.28-.17l-3.62-7.17-3.9 7.18a.31.31 0 0 1-.55-.02L4.06 9.52H2.3a.31.31 0 0 1-.31-.3v-.83c0-.17.14-.3.31-.3h6.21c.18 0 .32.13.32.3v.82a.3.3 0 0 1-.32.31H7.2l5.3 12.28 2.77-5.17-3.5-7.1h-.85a.31.31 0 0 1-.31-.3V8.4c0-.17.14-.3.3-.3h4.6a.3.3 0 0 1 .31.3v.82a.3.3 0 0 1-.3.31h-.82l2.02 4.42 2.4-4.42h-1.47a.3.3 0 0 1-.31-.3V8.4c0-.17.14-.3.31-.3h4.47c.17 0 .3.13.3.3v.82a.3.3 0 0 1-.3.31h-.98l-3.5 6.37 2.85 5.88L26 9.52h-1.75a.31.31 0 0 1-.3-.3v-.83c0-.17.13-.3.3-.3h5.44a.3.3 0 0 1 .31.3Z',
        'wind-solid' => 'M16 3a7.04 7.04 0 0 0-6.8 5.34 5.04 5.04 0 0 0-2.78 2.68A6 6 0 1 0 6 23v-2a4 4 0 1 1 .88-7.9l.98.23.22-.98a3 3 0 0 1 2.22-2.26l.66-.15.1-.67a4.98 4.98 0 0 1 9.4-1.52l.4.78.82-.29a4 4 0 0 1 5.3 3.87l-.02.2-.06.73.67.28A3.99 3.99 0 0 1 26 21h-2.54a5.8 5.8 0 0 1 1.19 2H26a6 6 0 0 0 3-11.2 6 6 0 0 0-7.17-5.68A6.97 6.97 0 0 0 16 3Zm-.5 9a3.5 3.5 0 0 0-2.8 1.4l1.6 1.2c.27-.37.7-.6 1.2-.6.84 0 1.5.66 1.5 1.5s-.66 1.5-1.5 1.5H9v2h6.5c1.92 0 3.5-1.58 3.5-3.5S17.42 12 15.5 12ZM8 21v2h3c.57 0 1 .43 1 1 0 .57-.43 1-1 1-.38 0-.7-.2-.86-.5L8.4 25.51C8.93 26.4 9.9 27 11 27c1.64 0 3-1.36 3-3 0-.35-.07-.68-.19-1H19c1.12 0 2 .88 2 2s-.88 2-2 2a2 2 0 0 1-1.89-1.34l-1.88.67A4 4 0 1 0 19 21Z',
        'window-close-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4.69 3.31-1.4 1.4L14.55 16l-4.34 4.34 1.4 1.41 4.35-4.34 4.31 4.3 1.4-1.4-4.3-4.31 4.25-4.25-1.41-1.4-4.25 4.24Z',
        'window-close' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4.69 3.31-1.4 1.4L14.55 16l-4.34 4.34 1.4 1.41 4.35-4.34 4.31 4.3 1.4-1.4-4.3-4.31 4.25-4.25-1.41-1.4-4.25 4.24Z',
        'window-maximize-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm2 3v12h14V10Zm2 2h10v2H11Zm0 4h10v4H11Z',
        'window-maximize' => 'M5 5v22h22V5Zm2 2h18v18H7Zm2 3v12h14V10Zm2 2h10v2H11Zm0 4h10v4H11Z',
        'window-minimize-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm2 13v2h14v-2Z',
        'window-minimize' => 'M5 5v22h22V5Zm2 2h18v18H7Zm2 13v2h14v-2Z',
        'window-restore-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm5 2v4H9v10h11v-4h3V9Zm2 2h7v1h-7Zm0 3h7v3h-7Zm-3 1h1v1.03h-1Zm0 3.03h1V19h6v2h-7Z',
        'window-restore' => 'M5 5v22h22V5Zm2 2h18v18H7Zm5 2v4H9v10h11v-4h3V9Zm2 2h7v1h-7Zm0 3h7v3h-7Zm-3 1h1v1.03h-1Zm0 3.03h1V19h6v2h-7Z',
        'windows' => 'M27 5 5 8v16l22 3V5zm-2 2.29V15H15V8.65l10-1.36zM13 8.92V15H7V9.74l6-.82zM7 17h6v6.08l-6-.82V17zm8 0h10v7.71l-10-1.36V17z',
        'wine-bottle-solid' => 'M15 3a2 2 0 0 0-2 2v1.69c-.06.2-.06.4 0 .6v3.15l-.78.53A5.04 5.04 0 0 0 10 15.16v.53c-.06.2-.06.4 0 .6v6.4c-.06.2-.06.4 0 .6V29h12v-5.81a.9.9 0 0 0 0-.4v-6.6a.9.9 0 0 0 0-.4v-.63c0-1.68-.83-3.27-2.22-4.2l-.78-.52V7.19a.9.9 0 0 0 0-.4V5a2 2 0 0 0-2-2Zm0 2h2v1h-2Zm0 3h2v3.53l.44.31 1.22.82c.79.52 1.26 1.4 1.3 2.34h-7.93c.05-.95.52-1.82 1.31-2.34l1.22-.82.44-.3Zm-3 9h8v5h-8Zm0 7h8v3h-8Z',
        'wine-glass-alt-solid' => 'm8.19 5-.16.78S7 10.48 7 13a9.03 9.03 0 0 0 8 8.94V26h-5v2h12v-2h-5v-4.06c4.48-.51 8-4.32 8-8.94 0-2.52-1.03-7.22-1.03-7.22L23.8 5Zm1.65 2h12.32c.09.49.33 1.72.53 3H11v2h11.94A6.98 6.98 0 0 1 16 20c-3.88 0-7-3.12-7-7 0-1.69.67-5.1.84-6Z',
        'wine-glass-solid' => 'm8.3 5-.3.6C7.4 6.9 7 8.7 7 11c0 4.6 3.5 8.4 8 8.9V26h-5v2h12v-2h-5v-6.1c4.5-.5 8-4.3 8-8.9 0-2.3-.4-4.1-1-5.4l-.2-.6H8.3zm1.3 2h12.8c.4 1.2.6 2.6.6 4 0 2.1-.9 3.9-2.3 5.2l-.1.1c-.1.1-.2.2-.3.2-.1.1-.2.1-.2.2-.1.1-.2.1-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.2.1-.1.1-.2.1-.4.2-.1 0-.2.1-.2.1-.1.1-.3.1-.4.1-.1 0-.1.1-.2.1s-.3.1-.4.1c-.1 0-.1 0-.2.1H16c-3.9 0-7-3.1-7-7V9.4L9.6 7z',
        'wix' => 'M22.05 9.95c-.52-.03-.95.05-.95.05l4 6-4 5.9s1.8.3 2.6-.5c.5-.5.8-1 2.5-3.4.3-.5.6 0 .6 0 1.5 2 1.9 2.8 2.6 3.4.9.7 2.6.5 2.6.5L28 16l3.9-6s-1.7-.3-2.5.5c-.6.6-1.2 1.4-2.6 3.5 0 0-.3.5-.6 0-1.4-2-2-2.9-2.6-3.5-.4-.4-1.02-.53-1.55-.55zM.42 9.99 0 10l3.2 12s1 0 1.5-.2c.7-.3 1-.6 1.4-2.2.4-1.4 1.4-5.7 1.5-6 .2-.7.5-.7.7 0 .1.3 1.1 4.5 1.5 6 .4 1.6.7 1.9 1.4 2.2.6.3 1.6.2 1.6.2L16 10c-1.1-.1-2.4.5-2.5 1.7l-1.7 6.4-1.4-5.2c-.3-1.5-1-2.3-2.3-2.3-1.3 0-1.9.7-2.3 2.3l-1.4 5.2-1.7-6.4c-.26-1.14-1.3-1.66-2.28-1.71zM19.6 10s-.8 0-1.3.2c-.6.3-.8.9-.8 2.4 0 0 .3-.3.8-.5 1.4-.5 1.3-1.5 1.3-2.1zm-.1 2v.08c.02-.05.03-.08 0-.08zm0 .08c-.06.1-.25.28-.6.42-.3.2-.6.3-.9.4-.7.3-.6.7-.6 1.7V22s.8.1 1.3-.2c.7-.3.8-.7.8-2.2v-7.52z',
        'wizards-of-the-coast' => 'M15.9 6.1c-2.9 0-5.3.6-5.7.7.4.1.7.2 1.1.6h.1c.3-.1 2.4-.7 5.5-.7 9 0 15.1 5.8 15.1 11.2v.5c0 .1 0 .1.1 0v-1C32 13.2 27.2 6.1 15.9 6.1zm1.2 1.1C6.9 7.2.7 14 0 14.8c-.1 0-.1 0 0 .1C3 15.7 7.8 19 9.8 25h.1c2.8-3.5 7-6.4 11.8-6.4 4 0 6.5 2.1 6.5 4 0 .9-.3 1.7-1.1 2.3.7-.5 1.4-1.4 1.4-2.4 0-1.1-.6-1.9-.6-1.9.4.4.5.8.5.8.3-2 1.3-3.1 1.3-3.1a4 4 0 0 0-.3-.9c.4.4.7 1.4.7 2.1 0 .5-.2 1.1-.6 1.5.4-.2.8-.7.8-1.8 0-.8-.2-1.3-.2-1.3.3-.3.6-.5.8-.6 0 .2.1.5.1.7 0 .1 0 .1.1 0v-.8c.3-.2.5-.2.5-.2-.7-5.5-7.1-9.8-14.5-9.8zm-2.1.4-1 3.1c2.1-1.2 4.1-1.8 6.6-1.8C24 9 29 11 30.6 16c-.5-1.5-3-6.4-9.6-6.5-2.7-.1-4.7.8-6.6 1.9l4.3-.5L14 12l1.3 1-.2-.8c.4-.1 2-.4 3.3-.4l-1.1 4c.7 0 .9-.4 1-1.1l.2-.1v1.3c-1.1.2-1.9.3-2.5.5l.7-2.2-3.1-1.8.1.4.5.2c.3.9 1 2.8 1 2.9.1.2.2.3.6.2l.1.2c-.8.2-1.2.4-2 .7l-.1-.2c.2-.1.4-.2.3-.6-1.2-3.1-1.1-2.9-1.1-3l.1-.2 1.7 3.4c-.2-.6.1.1-1.6-3.9l-2.1 4.4.2-.7-1.8-2.1 1.4 4.7-.6.4c-5.6-5.1-5.3-4.9-5.7-4.9-.3 0-.7.3-.7.3l-.2-.3c1.5-1.2 1.6-1.2 2.9-2.1l.2.4s-.3.2-.4.4c-.3.5.1.7 3.1 3.8l-.9-2.9 2-.5 1.3 1.5.2-.6-.2-1.2.7-.2v.2l.2-.5L8 13.8l.6-.2-.7-2.1.9-.5 1.5 1.8 1.4-.7c-.1-.4-.1-.7-.2-1l.9.7.2-.1-3-2.1 1.2.6c.9-.3 1.3-.4 1.6-.5l.1.5c-.6.6.1.8.3 1l-.7-3.1.6 1.4c.2-.1.4-.1.4-.1l.1.4s-.2.1-.3.1l.4 1L15 7.6zm-4.6 2.6.5.4s-.2 0-.6.1l-.1-.4s.1 0 .2-.1zm9.81 1.44c.84-.02 1.44.11 1.6.86v.6c0 .1-.11.9-.11 1.2v1c0 .1 0 .2.1.3.1.1.3.1.3.1.4 0 .4-.3.4-.3l.2-2.8c0-.2-.2-.2-.2-.2V12s1 .2 1.4.4l-.1.9s.5-.5.8-.5c.3-.1.7.4.7.4l-.6.6c-.6-.3-1 0-1 0-.3 1.9-.4 2.1.2 2.3v.2c-.9-.3-.9-.3-1.8-.4-.6-.1-.5 0-1-.1-.2-.3-.1-.2-.2-.4-.2 0-.4.2-.6.3-.2.1-.4.1-.5.1 0 0-.6.1-.9-.5-.3-.5 0-1.3.3-1.6.4-.4 1.2-.5 1.4-.9.4-.5-.7-1.1-1.5-.3H19l.3-.8.91-.06zm6.69.16c.6.5.8.7 1.1 1-1.3 3.7-1.5 4-1.2 4.2l-.1.2c-.3-.2-.4-.2-.9-.4l.1-.3s-.2.2-.5.2c-1 0-1.2-1.6-.5-2.6.6-.9 1.5-.8 1.7-.2l.4-1.3c.1-.3-.1-.5-.2-.6l.1-.2zm-9.75.39c-.4 0-1.15.1-1.45 1l1.1.91.6-1.9-.25-.01zm3.55 1.21s-.6.3-.7.5c-.2.2-.4.5-.4.8 0 .4.2.5.5.5s.5-.1.5-.3c0-.2.1-1.5.1-1.5zm5.4.4c-.5-.1-.8 1.2-.9 1.7 0 .3-.1.7.3.7.3.1.5.1 1-1.7.1-.3 0-.6-.4-.7zm-13.3.1.6 3.5-.6.3-1.2-1.4.7-1.3.2.2-.2-.4.5-.9zM28 15.3c.7-.1 1.2.8 1.2.8l-.4.4-.1-.1c0-.1.1-.2.1-.4 0-.5-.6-.6-.6-.2 0 .2.4 1 .4 1.4 0 .5-.3.8-.7.8-.4 0-1-.5-1-.5l.2-.7.1.1c-.1.9.9 1 .7.3-.1-.2-.9-1.7.1-1.9zm-8.4 1c0 .1 0 .2.1.3-.1-.1-.2-.2-.8 0 0 .1.1.3.1.5.5-.1.2 0 .5-.1v.3c-.2-.1-.1 0-.5 0 0 .1.1.5.1.6.09 0 .52 0 .71-.13a.5.5 0 0 0 0 .13c-.2 0-.71.1-1.11.2v-.2c-.1-.4-.2-.9-.2-1.3 0-.1 0-.1-.1-.2.5-.1 1-.1 1.2-.1zm2 .04c.16.01.32.06.5.16.1 0 .1.2.1.3-.3-.5-1-.4-1.1.3-.1.9.7 1 1 .5 0 .1-.1.3-.1.3-.5.3-1.4-.1-1.3-.9.07-.38.43-.7.9-.66zm-3.9.16c-.1.1-.1.1 0 .2.1.3.2 1 .3 1.3.1.2.1.2.2.3-.2.1-.3.1-.5.1v-.2c-.1-.2-.2-.6-.2-.7-.2 0-.4.1-.6.2 0 .1.2.5.2.7 0 .1.1.1.1.2-.2.1-.4.1-.5.2.1-.1.1-.1 0-.2-.1-.2-.4-1.2-.5-1.4 0-.1-.1-.2-.1-.2.2-.1.3-.1.5-.2v.2c.1.2.1.4.2.5.2-.1.5-.1.6-.2l-.1-.5c0-.1-.1-.2-.1-.2.2-.1.4-.1.5-.1zm5.46.07c.08 0 .17 0 .24.03.5.1.6.6.5 1-.1.4-.4.6-.9.5-.4-.1-.7-.5-.5-1 .15-.38.41-.52.66-.53zm.24.13c-.1 0-.5 0-.6.5-.1.3 0 .7.3.7.2.1.4 0 .6-.5.1-.5-.1-.7-.3-.7zm1.3.3c.1 0 .3.1.4.1l-.1 1.3c.1.1.1.1.1.2-.1 0-.4-.1-.4-.1l.1-.1V18c-.2-.1-.3-.1-.4-.1-.1.1-.1.2-.2.3v.2c-.1 0-.2-.1-.3-.1l.1-.1c.2-.2.5-.7.7-1V17zm-9.1.2.2.2c-.2-.1-.4 0-.6.1.6 1.6.6 1.6.7 1.6-.2.1-.3.1-.5.2.1-.1.1-.1-.6-1.6 0 0-.4.2-.5.4l-.1-.3c.4-.2 1.3-.6 1.4-.6zm9.3 0c-.1.1-.3.4-.3.5.1 0 .2.1.3.1v-.6zm1.15.33c.15.02.3.12.35.27v.2c0-.3-.3-.4-.4-.3-.1.1.1.2.1.4.1.1.1.3.1.5-.1.3-.6.3-.8 0l.1-.2c0 .3.3.5.4.2.1-.1 0-.3-.1-.4-.1-.1-.2-.3-.1-.5.05-.15.2-.2.35-.17zM27 18c.2.1.5.3.6.4l-.2.3c-.1-.2 0-.1-.2-.2-.1.2-.3.5-.4.8-.1.1-.1.2 0 .2l-.3-.2.1-.1c.2-.3.3-.6.5-.9-.1-.1-.1-.1-.3-.1l.2-.2zm-13.6.2.2.2h-.3c-.1 0-.4.2-.6.4v.1c.1.1.2.3.3.5.5-.3.4-.2.6-.4 0 .1 0 .1.1.3-.2 0-.2 0-.6.3.5.9.6.8.6.8-.1.1-.3.2-.5.3.1-.2-.1-.3-.9-1.6-.1-.1-.2-.1-.2-.1.4-.3.8-.5 1.3-.8zm8.55.64c-2.52-.01-5.55.87-8.35 3.06v.1c.1.2.2.5.2 1 3.2-2.9 6.6-3.8 9.2-3.6 2.9.2 5 1.7 5 3.4 0 .5-.1.8-.2 1 .1-.2.2-.5.3-1 .2-1.9-2-3.6-5.1-3.9a10 10 0 0 0-1.05-.06zm-10.53.71c.5-.07.93.32 1.08.55-.1 0 .5.8-.3 1.5-.6.4-1.2.2-1.5-.2-.4-.5-.3-1.2.2-1.6a1 1 0 0 1 .52-.25zm-.16.33A.4.4 0 0 0 11 20c-.1.1-.6.4 0 1.2.2.3.7.6 1.1.3.3-.2.4-.6 0-1.2-.23-.22-.56-.45-.84-.42z',
        'wolf-pack-battalion' => 'M7.4 3c-.9 3.1-.2 6 0 6.6.8-.3 2.5-1.9.3-3.7 1.3.4 2 1.5 2.1 2.5C10 9.8 8.1 11 7.1 11c-1.6.1-3.1 1.7-3.1 3l1.1-.5c-.3.9-.6 1.8-.4 2.9l1.3-.3c-.8 1.3-.5 3.3-.4 4.3l1.3-.7.4 1.8 1.2-.3.5 1.5 1.3-1.1-1 .4-.4-1.7-.9.3-.3-1.7-1.4.4c-.2-1.3.1-2.5.7-3.7l-1.5-.4c.5-2.2 1.8-2.6 3.2-2.7.5 1.6.3 2.9-.1 4.1 4.1 2.9 3.9 6 4.1 7.6.2 1.5.2 4.5 1.3 4.9v-1.5l.3-.4.3.6.5-.8.6 1.1.4-1.2.5.8.3-.6.3.4V29c1.1-.4 1.1-3.4 1.3-4.9.2-1.6 0-4.7 4.1-7.6a6.3 6.3 0 0 1-.1-4.1c1.4.2 2.7.5 3.2 2.7l-1.5.4c.6 1.2.9 2.4.7 3.7l-1.4-.4-.5 1.8-.9-.4-.4 1.7-1-.4 1.3 1.1.4-1.4 1.2.3.4-1.8 1.3.7c0-1 .4-2.9-.4-4.3l1.3.3c.2-1.1-.1-2-.4-2.9l1.2.5c0-1.3-1.5-2.9-3.1-3-1-.1-2.9-1.3-2.7-2.6.1-1 .8-2.2 2.1-2.5-2.2 1.9-.5 3.4.3 3.7.2-.6.9-3.5 0-6.6-2 1.2-4.4 3.3-4.6 7.5l-2.8 1.8L16 17l5.2-2.8.4.4-.9.2-2.2 2-.8-.3-1.4 2.5-.2 6 1.1.8-1.6.8-1.6-.8 1.1-.8-.2-6.1-1.4-2.5-.8.3-2.2-2-.9-.2.4-.4 5 2.9-.2-4.7-2.8-1.8C11.8 6.3 9.5 4.2 7.4 3zm.8 10.5c-.9.1-1.8.4-2.3 1.4.7.2 1.2.3 2.2.7 0-.6.1-1.4.1-2.1zm14.6 0c0 .7.1 1.5.1 2.1 1-.4 1.5-.5 2.2-.7-.5-1-1.3-1.3-2.3-1.4zM8.1 15.8c-1 .7-1.4 1.7-1.5 2.9.6-.2 1.2-.5 1.9-.5-.3-.7-.4-1.5-.4-2.4zm14.8 0c0 .9-.1 1.7-.4 2.4.7 0 1.3.3 1.9.5-.1-1.2-.5-2.2-1.5-2.9zM8.6 18.2c-.2.5-.3 1-.3 1.7l1.2-.3c-.3-.5-.6-.9-.9-1.4zm.9 1.4c0 .6 0 1.1.1 1.6.4-.1.8-.2 1.1-.4-.4-.3-.8-.8-1.2-1.2zm12.9-1.4c-.3.5-.6.9-.9 1.4l1.2.3c0-.7-.1-1.2-.3-1.7zm-.9 1.4c-.4.4-.8.9-1.2 1.2.3.2.7.3 1.1.4.1-.5.1-1 .1-1.6zM10.7 21c.1.3.1.7.2 1.1l.8-.5c-.4-.2-.7-.4-1-.6zm9.6 0c-.3.2-.6.4-1 .6l.8.5c.1-.4.1-.8.2-1.1z',
        'won-sign-solid' => 'm4 6 1.81 6H4v2h2.4l.6 2H4v2h3.6l2.4 8h2l2-8h4l2 8h2l2.4-8H28v-2h-3l.6-2H28v-2h-1.81L28 6h-2l-1.81 6H18.5L17 6h-2l-1.5 6H7.81L6 6Zm12 4 .5 2h-1Zm-7.6 4H13l-.5 2H9Zm6.6 0h2l.5 2h-3Zm4 0h4.6l-.6 2h-3.5Zm-9.4 4H12l-1.1 4.38ZM20 18h2.4l-1.3 4.38Z',
        'wordpress-simple' => 'M16 3a13.01 13.01 0 0 0 0 26 13.01 13.01 0 0 0 0-26zm0 2.17c2.83 0 5.38 1.08 7.3 2.84l-.13-.02c-1.06 0-1.75.93-1.75 1.93 0 .9.45 1.65 1 2.55.41.71.9 1.65.9 2.98 0 .93-.35 2-.83 3.5l-1.07 3.61-4.07-12.52c.65-.04 1.24-.1 1.24-.1.58-.07.52-.93-.07-.9 0 0-1.75.14-2.9.14-1.05 0-2.84-.14-2.84-.14-.59-.03-.65.87-.07.9 0 0 .56.06 1.14.1l1.83 5.5-2.37 7.11-4.1-12.61c.67-.03 1.25-.1 1.25-.1.59-.06.51-.93-.06-.9 0 0-1.69.14-2.82.14A10.8 10.8 0 0 1 16 5.17zm9.51 5.63a10.82 10.82 0 0 1-4.75 14.93c.23-.12.47-.23.69-.37l3.3-9.57a10.19 10.19 0 0 0 .76-4.98zm-19.3.58 5.06 14.36A10.8 10.8 0 0 1 6.2 11.38zm9.97 5.56 3.34 9.13c.02.06.04.1.08.14a10.85 10.85 0 0 1-6.67.18l3.25-9.45zM11.4 25.8zm9.02.1zm-7.86.37.35.11-.35-.1z',
        'wordpress' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 .56a11.44 11.44 0 1 1-.01 22.89A11.44 11.44 0 0 1 16 4.56Zm0 1.16c-3.6 0-6.75 1.83-8.6 4.62h.66c1.08 0 2.75-.12 2.75-.12.56-.03.62.78.06.84 0 0-.56.1-1.18.13l3.75 11.12 2.25-6.75-1.6-4.37c-.55-.03-1.09-.13-1.09-.13-.55-.03-.5-.87.06-.84 0 0 1.71.12 2.72.12 1.08 0 2.75-.12 2.75-.12.56-.03.62.78.06.84 0 0-.57.1-1.18.13l3.71 11.06 1.04-3.44c.52-1.33.78-2.46.78-3.34 0-1.27-.45-2.13-.85-2.81-.52-.85-1-1.6-1-2.44 0-.95.71-1.81 1.72-1.81h.13A10.2 10.2 0 0 0 16 5.7Zm9.03 5.34a9.75 9.75 0 0 1-.72 4.75l-3.12 9.1a10.3 10.3 0 0 0 3.84-13.85Zm-18.44.75c-.57 1.28-.87 2.7-.87 4.19 0 4.07 2.35 7.58 5.78 9.25Zm9.6 5.1-3.1 8.96a10.39 10.39 0 0 0 6.31-.15l-.06-.16Z',
        'wpbeginner' => 'M16 4C9.4 4 4 8.5 4 14c0 1.7.5 3.3 1.4 4.8-.9.8-1.4 2-1.4 3.2 0 2.8 2.7 5 6 5 2.5 0 4.6-1.2 5.5-3h1c.9 1.8 3 3 5.5 3 3.3 0 6-2.2 6-5 0-1.2-.5-2.4-1.4-3.2.9-1.4 1.4-3 1.4-4.8 0-5.5-5.4-10-12-10zm0 2c5.5 0 10 3.6 10 8 0 .3-.03.61-.07.91l-.02.13c-.05.26-.1.53-.18.79l-.03.1a7.47 7.47 0 0 1-2.2 3.27c1.48.5 2.46 1.57 2.5 2.74-.04 1.59-1.82 2.96-4 2.96-1.6 0-3.1-.8-3.7-1.9l-.6-1h-3.4l-.6 1.1c-.6 1.1-2.1 1.9-3.7 1.9-2.2 0-4-1.4-4-3 0-.2.03-.38.08-.55v-.03c.15-.46.43-.83.64-1.12a4.23 4.23 0 0 1 1.78-1.1 7.89 7.89 0 0 1-1.4-1.59v-.01a7.23 7.23 0 0 1-.81-1.72v-.01a6.33 6.33 0 0 1-.2-.83l-.02-.13c-.04-.3-.07-.6-.07-.91 0-4.4 4.5-8 10-8zm-6 6v3h2v-3h-2zm3 0v3h8v-3h-8zm-2 4.2v1.4c2.5 2.4 6.3 3 9 1.7V18a8.9 8.9 0 0 1-9-1.8z',
        'wpexplorer' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13 13-5.8 13-13S23.2 3 16 3zm0 2c6.1 0 11 4.9 11 11s-4.9 11-11 11S5 22.1 5 16 9.9 5 16 5zm-4.8 5-1.8 4.3 4.3 1.8 1.8-4.3-4.3-1.8zm4.8 2.6L14.6 16l3.3 1.4.02-.03.08.03 1.5-3.4-3.5-1.4zm4 2.1-1.1 2.7 2.7 1.1 1.2-2.7-2.8-1.1zm-5.7 1.9-.3.6 1.1.5-2.5 5.3h.7l2.4-4.9 2.5 4.9h.7l-2.3-4.6.8.3.3-.7-3.4-1.4z',
        'wpforms' => 'M5 5v22h22V5H5zm2 2h.54l5.06 4.3 3.4-3 3.4 3L24.46 7H25v18H7V7zm3.7 0h3.83L12.6 8.7 10.7 7zm6.77 0h3.82L19.4 8.7 17.47 7zM9 13v2h3v-2H9zm5 0v2h9v-2h-9zm-5 4v2h3v-2H9zm5 0v2h9v-2h-9zm4 4v2h5v-2h-5z',
        'wpressr' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13 13-5.8 13-13S23.2 3 16 3zm0 2c6.1 0 11 4.9 11 11s-4.9 11-11 11S5 22.1 5 16 9.9 5 16 5zm-5.4 6c-.2 0-.3.1-.4.3-.6 1.4-1.3 2.9-1.9 4.3-.4 1-.9 1.9-1.3 2.9v.5c.6.6 1.1 1.2 1.7 1.8.1.1.2.2.4.2H16c.1 0 .3-.1.4-.3.5-1.2 1-2.3 1.5-3.5.1-.2.3-.3.5-.3h3.4c.3 0 .5-.1.6-.4.8-1.7 1.5-3.4 2.4-5.1.1-.3 0-.4-.3-.4H18c-.2 0-.3.1-.4.3 0 .2-.4.9-.8 1.9 0 .1.1.1.2.1h3.7c.5 0 .4.7-.2.7h-3.9c-.1 0-.1.1-.2.1-.9 1.9-1.9 4.2-1.9 4.2-.2.3-.8.3-.6-.3.4-.9.8-1.9 1.2-2.8.1-.2 0-.4-.3-.4h-2.3c-.1 0-.2 0-.3.2l-1.5 3.3c-.1.3-.7.1-.5-.3.2-.6.5-1.3.8-1.9.7-1.6 1.3-3.1 2-4.6.2-.3 0-.5-.3-.5h-2.1z',
        'wrench-solid' => 'M21 4a7 7 0 0 0-7 7c0 .71.21 1.36.41 2.02l-9.46 9.46a3.24 3.24 0 0 0 0 4.58 3.25 3.25 0 0 0 4.57 0l9.46-9.47c.65.2 1.3.41 2.02.41a7.01 7.01 0 0 0 6.38-9.88l-.6-1.32-1.02 1.03L22.6 11H21V9.41l4.2-4.2-1.32-.58A6.92 6.92 0 0 0 21 4Zm0 2c.17 0 .32.09.48.1L19 8.6V13h4.41l2.48-2.48c.02.16.11.3.11.48a4.98 4.98 0 0 1-6.97 4.6l-.62-.27-10.3 10.31c-.49.48-1.27.48-1.75 0a1.23 1.23 0 0 1 0-1.75l10.3-10.3-.26-.63A5 5 0 0 1 21 6Z',
        'x-ray-solid' => 'M5 5v22h22V5Zm2 2h18v18H7Zm8 1v1h-3v2h3v1h-5v2h5v1h-4v2h4v2.56a4.18 4.18 0 0 0-1.5-.56 1.5 1.5 0 0 0 0 3c.38 0 1.67 1 2.5 1 .83 0 2.12-1 2.5-1a1.5 1.5 0 0 0 0-3c-.39 0-.98.3-1.5.56V8Zm3 1v2h2V9Zm0 3v2h4v-2Zm0 3v2h3v-2Z',
        'xbox' => 'M16 4a12.01 12.01 0 0 0 0 24 12.01 12.01 0 0 0 0-24Zm0 2c.1 0 .19.03.28.03.26 0 .5 0 .75.03h.1l.28.03.18.04a9.77 9.77 0 0 1 2.29.65h.03c.16.07.3.17.46.25.21.1.43.2.63.31a5.5 5.5 0 0 1 .4.25v.04c-1.64-.95-5.37 2.06-5.37 2.06a12.18 12.18 0 0 0-3.81-2.16 2.45 2.45 0 0 0-1.47 0c.16-.1.3-.22.47-.31l.03-.03c.25-.15.52-.26.78-.38l.06-.03.57-.22c.17-.06.35-.1.53-.15.26-.08.51-.17.78-.22.08-.02.17-.02.25-.03l.65-.1h.1C15.3 6.03 15.65 6 16 6Zm6 2.6c.3 0 .64.06.94.24.04.04.09.06.12.1.06.04.1.1.16.15.14.15.28.29.4.44l.1.1.22.28.34.5a9.06 9.06 0 0 1 .9 1.62l.04.06.1.22a11.15 11.15 0 0 1 .5 1.66l.02.12c.12.62.16 1.26.16 1.91a9.98 9.98 0 0 1-2.53 6.66c.48-2.52-.4-4.37-1.81-6.7a31.26 31.26 0 0 0-3.82-4.65A12.28 12.28 0 0 1 22 8.6Zm-12.13.06c.66.04 1.33.3 1.94.68l.06.04c1.3.78 2.35 1.93 2.35 1.93-1.13 1.09-3.84 4.38-4.75 6.6-1.35 3.39-.72 4.87-.72 4.87.17-1.87 2.94-5.17 3.94-6.22.52-.6 1.53-1.6 2.31-2.37l1.03-1.1.88.88a47.26 47.26 0 0 1 4.94 5.56 8.91 8.91 0 0 1 1.56 3.19l-.35.34c-.22.23-.44.46-.68.66-.25.2-.52.38-.79.56-.26.18-.52.35-.8.5-.23.12-.44.24-.66.34l-.13.07c-.27.11-.56.22-.84.31-.03 0-.04.02-.07.03a10.5 10.5 0 0 1-1.06.28c-.19.04-.4.04-.6.07a9.8 9.8 0 0 1-2.46.06 9.86 9.86 0 0 1-1.9-.38h-.04c-.92-.29-1.8-.74-2.6-1.28h-.02A9.95 9.95 0 0 1 6.07 16a10 10 0 0 1 2.68-6.81s.43-.53 1.13-.53Z',
        'xing-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm12.64 2c-.22 0-.4.13-.55.38l-4.52 7.97 2.89 5.27c.14.25.32.38.56.38h2.04c.27 0 .39-.22.26-.44l-2.86-5.2v-.02l4.5-7.9c.12-.23-.02-.44-.26-.44h-2.06zm-8.57 3c-.24 0-.38.2-.25.44l1.37 2.35-2.15 3.76c-.12.22.02.45.26.45h2.02c.21 0 .4-.13.55-.4l2.18-3.82-1.39-2.4c-.15-.25-.33-.38-.56-.38h-2.03z',
        'xing' => 'M21.4 5c-.42 0-.87.17-1.15.4-.28.24-.4.5-.5.66l-4.31 7.66a1.07 1.07 0 0 0-.13-.31c0-.02-1.97-3.41-1.97-3.41a1.88 1.88 0 0 0-1.65-1.06h-2.9c-.42 0-.92.17-1.23.65h-.03a1.5 1.5 0 0 0 0 1.44l.03.03 1.66 2.9-2.78 4.91-.03.04c-.22.41-.25.99.03 1.43.24.4.77.66 1.25.66h2.87c.44 0 .89-.17 1.16-.4.27-.24.4-.5.5-.66l1-1.78c.02.07.05.14.1.21l4.12 7.57A1.89 1.89 0 0 0 19.13 27H22c.43 0 .95-.22 1.22-.66.3-.46.26-1.04.06-1.43l-.03-.04-3.81-6.93 6.12-10.82a1.43 1.43 0 0 0 0-1.47A1.5 1.5 0 0 0 24.31 5Zm.13 2h1.78l-5.87 10.44c-.12.2-.1.68.03.97h-.03l.03.06v.03l3.56 6.5h-1.81c-.01-.02-.02 0-.03-.03l-3.82-7.03 6.13-10.9c.02-.05.02-.02.03-.04ZM9.78 10.94h1.78c.01 0 0-.02.03.03l.04.03 1.68 2.94-2.84 5.03-.03.03H8.66l2.59-4.53.03-.13c.02-.05.1-.17.1-.37 0-.2-.08-.36-.1-.4a1.24 1.24 0 0 0-.06-.13Z',
        'y-combinator' => 'M5 5v22h22V5Zm2 2h18v18H7Zm4.5 4 3.5 6v5h2v-5l3.5-6h-2L16 15.28 13.5 11Z',
        'yahoo' => 'M7.34 6.03s.79.17 1.44.17c.66 0 1.43-.18 1.43-.18L16 15.66 21.82 6s.63.21 1.41.21c.79 0 1.43-.2 1.43-.2L17.21 18.6l.2 9.37s-.78-.21-1.41-.21c-.63 0-1.44.24-1.44.24l.23-9.41Z',
        'yammer' => 'M6.36 6.04c-.15 0-.31.01-.46.06-.7.2-1 .9-.9 1.5l5.2 13c-.7 2.1-1.4 3.1-3 3.1h-.7c-.5 0-1 .3-1.1.7-.1.6.2 1.2.8 1.4.4.1.8.1 1.2.1 3 0 3.9-1.6 4.9-4.1L18 7.6c.1-.6-.2-1.2-.7-1.4-.6-.2-1.4.1-1.6.7l-4 10.6h-.1L7.5 6.8a1.38 1.38 0 0 0-1.14-.76zm18.45 2.02c-.1 0-.21.01-.31.04 0 .1-.1.1-.1.1-.7.4-5.9 4-5.3 4.4.6.4 4.1-1.2 6.5-2.5.5-.4.6-1.2.1-1.6a1.1 1.1 0 0 0-.89-.44zm3.09 6.84c-.9 0-7.2.7-6.9 1.3.3.6 4.2.9 7 .9.7-.1 1.1-.7 1-1.3-.1-.5-.5-.8-.9-.9h-.2zm-8.35 4.54c-.16 0-.28.01-.35.06-.6.4 4.5 4 5.3 4.4 0 .1.1.1.1.1.6.2 1.2-.2 1.4-.8.1-.5-.1-1-.3-1.2-2.1-1.14-5.04-2.5-6.15-2.56z',
        'yandex-international' => 'm20.8 1-5.6 16.2-5-13.2H7l7 18.6V31h3v-9.9L24 1h-3.2z',
        'yandex' => 'M19.66 4h-3.49C12.74 4 10 6.72 10 12c0 3.17 1.24 5.5 3.75 6.66l-4.69 8.83c-.15.29 0 .51.25.51h2.17c.18 0 .3-.06.37-.22l4.4-8.78h1.25v8.78c0 .1.08.22.2.22h2.06c.18 0 .24-.1.24-.25V4.32c0-.22-.12-.32-.34-.32zM17.5 17H16c-1.5 0-3.5-1.16-3.5-5 0-4 1.63-6 3.5-6h1.5v11z',
        'yarn' => 'M16 3C8.8 3 3 8.8 3 16s5.8 13 13 13 13-5.8 13-13S23.2 3 16 3zm0 2c6.1 0 11 4.9 11 11s-4.9 11-11 11S5 22.1 5 16 9.9 5 16 5zm.2 4.04c-.44.08-.9 1.46-.9 1.46s-1.2-.2-2.2.8c-.2.2-.4.3-.7.4-.1.1-.2.1-.4.7-.4.9.6 2 .6 2-2.1 1.5-2 3.5-1.9 4-1.3 1.1-.8 2.5-.5 2.9.2.3.4.2.5.2 0 .1-.5.7 0 .9.5.3 1.3.4 1.7 0 .3-.3.4-.9.5-1.2.1-.1.1.2.5.4 0 0-.7.3-.4 1 .1.2.4.4 1 .4.2 0 2.6-.1 3.2-.3.4-.1.5-.3.5-.3 2.6-.7 3.1-1.8 4.9-2.2.6-.1.6-1.1-.5-1-.8 0-1.5.4-2.1.8-1 .6-1.7.7-1.7.6-.1-.1.4-1.3-.1-2.6-.5-1.4-1.4-1.8-1.3-1.9.3-.5 1-1.3 1.3-2.7.1-.9.1-2.4-.3-3.1-.1-.2-.7.2-.7.2s-.6-1.3-.8-1.4a.23.23 0 0 0-.2-.06z',
        'yelp' => 'M14.34 4c-1.47.05-4.6.99-5.25 1.66-.23.24-.35.57-.28.84.12.24 5.06 8 5.06 8 .74 1.19 1.34 1 1.54.94.2-.06.78-.24.71-1.63-.07-1.62-.53-8.82-.59-9.15a.91.91 0 0 0-.69-.63 1.88 1.88 0 0 0-.5-.03Zm7.47 7.1a.73.73 0 0 0-.4.12c-.16.1-.28.25-2.47 3.25l-1 1.37c-.26.32-.26.77 0 1.16.26.4.68.61 1.1.5v.03c.2-.07.55-.19 1.21-.34 4.1-1 4.25-1.02 4.4-1.13.25-.17.37-.47.35-.81v-.03c-.1-1-1.85-3.61-2.72-4.03a1 1 0 0 0-.47-.1ZM8.06 15.12c-.3-.02-.56.14-.75.43-.39.63-.54 2.57-.4 3.88.05.43.1.81.21 1.03.16.3.43.46.72.47.2 0 .34-.03 3.94-1.19l1.6-.5c.4-.1.66-.47.68-.94.03-.48-.22-.9-.62-1.06l-1.13-.47c-3.87-1.6-4.05-1.65-4.25-1.66Zm11.03 4.4c-.3 0-.62.13-.84.4-.3.38-.34.89-.1 1.26l.63 1.03c2.14 3.47 2.31 3.69 2.47 3.81.24.19.53.22.84.1.91-.37 2.9-2.88 3.04-3.85.04-.34-.05-.62-.29-.81-.15-.11-.27-.16-3.87-1.34 0 0-1.58-.52-1.6-.54a.89.89 0 0 0-.28-.06Zm-4.37 1.13a.97.97 0 0 0-.53.34l-.78.94c-2.72 3.18-2.81 3.31-2.88 3.5a.95.95 0 0 0-.06.37c.01.17.09.32.22.47.63.75 3.66 1.85 4.62 1.69.34-.06.55-.22.66-.5.06-.18.08-.31.1-4.1V21.7a.98.98 0 0 0-.66-.97 1.21 1.21 0 0 0-.7-.06Z',
        'yen-sign-solid' => 'm7.19 5 6.87 11H10v2h5v2h-5v2h5v5h2v-5h5v-2h-5v-2h5v-2h-4.06L24.8 5h-2.37L16 15.34 9.56 5Z',
        'yin-yang-solid' => 'M16 4a12.01 12.01 0 0 0 0 24h.5v-.03A12 12 0 0 0 28 16a12 12 0 0 0-9.84-11.78A6.44 6.44 0 0 0 16.5 4v.03c-.17 0-.33-.03-.5-.03Zm0 2c.35 0 .7.03 1.03.06.13.02.26.01.38.03.03 0 .06.03.09.04a4.49 4.49 0 0 1-1 8.88 6.52 6.52 0 0 0-5.78 9.46A9.98 9.98 0 0 1 16 6Zm6.72 2.63a9.96 9.96 0 0 1-6.4 17.34A4.49 4.49 0 0 1 16.5 17a6.52 6.52 0 0 0 6.2-8.38ZM16.5 9a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Zm0 11a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z',
        'yoast' => 'm20.8 4-5 13.5L13 10h-3l4 9.5s.2.6.3 1.1v.7c0 .2-.1.5-.2.7-.6 1.2-1.7 1.9-3 1.9v3c2.7 0 5.1-1.7 6-4.2L24 4h-3.2zM9 7c-2.2 0-4 1.8-4 4v10c0 2.2 1.8 4 4 4h.9v-1H9a3 3 0 0 1-3-3V11c0-1.7 1.3-3 3-3h9.1l.4-1H9zm15 .1-.3 1A3 3 0 0 1 26 11v13h-8.3c-.2.3-.4.7-.6 1H27V11c0-1.9-1.3-3.4-3-3.9z',
        'youtube-square' => 'M5 5v22h22V5H5zm2 2h18v18H7V7zm9 4.08s-4.4 0-5.47.29c-.6.17-1.08.64-1.24 1.25C8.99 13.7 9 16 9 16s0 2.3.29 3.4c.16.6.64 1.06 1.24 1.22 1.08.3 5.47.29 5.47.29s4.4 0 5.47-.29c.6-.17 1.08-.62 1.24-1.23.3-1.09.29-3.39.29-3.39s0-2.3-.29-3.4a1.78 1.78 0 0 0-1.24-1.24c-1.08-.3-5.47-.29-5.47-.29zm-2 2.08L19 16l-5 2.84v-5.7z',
        'youtube' => 'M16 6c-3.77 0-7.1.4-9.13.69a3.96 3.96 0 0 0-3.34 3.18A34.05 34.05 0 0 0 3 16c0 2.61.27 4.7.53 6.13a3.96 3.96 0 0 0 3.35 3.18c2.03.3 5.37.69 9.12.69 3.75 0 7.09-.4 9.13-.69a3.96 3.96 0 0 0 3.34-3.18c.26-1.43.53-3.52.53-6.13 0-2.6-.27-4.7-.53-6.13a3.96 3.96 0 0 0-3.34-3.18C23.09 6.39 19.77 6 16 6Zm0 2c3.63 0 6.88.37 8.84.66.85.12 1.5.76 1.66 1.59.24 1.32.5 3.28.5 5.75s-.26 4.43-.5 5.75c-.15.83-.8 1.47-1.66 1.6A64.4 64.4 0 0 1 16 24c-3.6 0-6.88-.37-8.84-.66a1.96 1.96 0 0 1-1.66-1.59C5.26 20.43 5 18.48 5 16s.26-4.43.5-5.75c.15-.83.8-1.47 1.66-1.6A65.5 65.5 0 0 1 16 8Zm-3 2.28v11.44l1.5-.84 7-4L23 16l-1.5-.88-7-4Zm2 3.44L18.97 16 15 18.28Z',
        'zhihu' => 'M30.63 8.99a7 7 0 0 0-.93.2s-8.2.9-11.6 1c.1.5.4.9.8 1 .7.1 1.2 0 2.5 0 1.2-.1 2.2-.09 2.8-.09V16H18s.1 1.2 1.2 1.2h5v3.4c0 .7-.5 1.1-1.2 1.1s-1.2-.1-2-.1c.1.2.2.7.9 1.1.5.2.8.3 1.3.3 1.5 0 2.3-.9 2.3-2.3v-3.5h6.1c.4 0 .4-1.2.3-1.1h-6.5v-4.9c.2 0 .6-.1 1.1-.1 2.1-.1 3.5-.4 4.4-.4 0 0 .6-1.4 0-1.7-.05-.03-.15-.03-.27-.01zM3.3 9s-1.2 0-1.6 1.1c-.1.4-.8 2-1.7 3.8.3 0 1.2-.1 1.8-1.1.1-.3.4-.5.5-.9h1.5c0 .5-.1 3.6-.1 3.9H1.1C.5 15.8.3 17 .3 17h3.2c-.2 2.4-1.4 4.1-3.5 5.8 1 .3 2 0 2.6-.4 0 0 1.2-.9 1.8-3.3L6.9 22s.4-1.4-.1-2c-.4-.5-1.2-1.4-1.7-1.8l-.7.6c.2-.7.4-1.1.4-1.8H8s0-1.2-.4-1.2H4.9c.1-1.3.1-2.8.1-3.9h2.4s.1-1.1-.4-1.1H2.6c.2-.7.4-1.1.7-1.8zM9 11v11h1.2l.4 1.3 2.1-1.3H15V11H9zm20.29 1.18a.73.73 0 0 0-.49.22L27 14.8l1 .7c1.1-1.3 2.3-2.9 2.3-2.9s-.5-.45-1.01-.42zm-19.1.02h3.5v8.6H12.5l-1.4.9-.3-.9h-.6v-8.6zm9.94.15c-.42-.03-.93.25-.93.25s2 2.8 2.1 2.9l1-.7S21 13 20.5 12.5a.56.56 0 0 0-.37-.15z'
    );
    if ($icon !== '') {
        return isset($icons[$icon]) ? $icons[$icon] : false;
    }
    return $icons;
    }

}

new Themify_Icon_LineAwesome();
